@extends('layouts.front')
@section('title', 'Point System')

@section('content')

    <div class="container information pt-5 faq_main">
        <h2 class="text-center term_h1 pb-3" data-aos="fade-down">
            PlaynWin 11 Points System
        </h2>

        <!-- Cricket -->
        <div class="tab-pane active" role="tabpanel" aria-labelledby="circket-tab">
            <div class="points_block">
                <div class="points_title text-start" data-aos="flip-right">
                    <span>Normal Points</span>
                </div>
                <div class="points_block_inner">
                    <div class="points_system_table table-responsive ">
                        <table class="table m-0" width="100%" cellspacing="0" cellpadding="0" border="0">
                            <thead>
                                <tr>
                                    <th>Type of Point</th>
                                    <th>T20</th>
                                    <th>ODI</th>
                                    <th>Test</th>
                                    <th>T10</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>For being part of the Starting XI</td>
                                    <td>4</td>
                                    <td>4</td>
                                    <td>4</td>
                                    <td>4</td>
                                </tr>
                                <tr>
                                    <td>For every run scored</td>
                                    <td>1</td>
                                    <td>1</td>
                                    <td>1</td>
                                    <td>1</td>
                                </tr>
                                <tr>
                                    <td>Wicket (Except Run-Out).</td>
                                    <td>25</td>
                                    <td>25</td>
                                    <td>16</td>
                                    <td>25</td>
                                </tr>
                                <tr>
                                    <td>Catch</td>
                                    <td>8</td>
                                    <td>8</td>
                                    <td>8</td>
                                    <td>8</td>
                                </tr>
                                <tr>
                                    <td>Run out (Catcher)</td>
                                    <td>6</td>
                                    <td>6</td>
                                    <td>6</td>
                                    <td>6</td>
                                </tr>
                                <tr>
                                    <td>Run out (Thrower)</td>
                                    <td>6</td>
                                    <td>6</td>
                                    <td>6</td>
                                    <td>6</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="points_block">
                <div class="points_title text-start" data-aos="flip-right">
                    <span>Bonus Points</span>
                </div>
                <div class="points_block_inner">
                    <div class="points_system_table table-responsive">
                        <table class="table m-0" width="100%" cellspacing="0" cellpadding="0" border="0">
                            <thead>
                                <tr>
                                    <th>Type of point</th>
                                    <th>T20</th>
                                    <th>ODI</th>
                                    <th>Test</th>
                                    <th>T10</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Every boundary hit</td>
                                    <td>1</td>
                                    <td>1</td>
                                    <td>1</td>
                                    <td>1</td>
                                </tr>
                                <tr>
                                    <td>Every six hit</td>
                                    <td>2</td>
                                    <td>2</td>
                                    <td>2</td>
                                    <td>2</td>
                                </tr>
                                <tr>
                                    <td>30 run Bonus</td>
                                    <td>4</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>+8</td>
                                </tr>
                                <tr>
                                    <td>Half century</td>
                                    <td>8</td>
                                    <td>4</td>
                                    <td>4</td>
                                    <td>16</td>
                                </tr>
                                <tr>
                                    <td>Century</td>
                                    <td>16</td>
                                    <td>8</td>
                                    <td>8</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Maiden over</td>
                                    <td>12</td>
                                    <td>4</td>
                                    <td>NA</td>
                                    <td>16</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="points_block">
                <div class="points_title text-start" data-aos="flip-right">
                    <span>Economy Rate</span>
                </div>
                <div class="points_block_inner">
                    <div class="points_system_table table-responsive">
                        <table class="table m-0" width="100%" cellspacing="0" cellpadding="0" border="0">
                            <thead>
                                <tr>
                                    <th>Type of point</th>
                                    <th>T20</th>
                                    <th>ODI</th>
                                    <th>Test</th>
                                    <th>T10</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Between 8.01 - 9 runs per over</td>
                                    <td>N/A</td>
                                    <td>-4</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Above 9 runs per over</td>
                                    <td>N/A</td>
                                    <td>-6</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Between 11.01 - 12 runs per over</td>
                                    <td>-4</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Above 12 runs per over</td>
                                    <td>-6</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>

                                <tr>
                                    <td>Between 14 - 15 runs per over</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>-2</td>
                                </tr>

                                <tr>
                                    <td>Between 15.01 - 16 runs per over</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>-4</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="points_block">
                <div class="points_title text-start" data-aos="flip-right">
                    <span>Strike Rate</span>
                </div>
                <div class="points_block_inner">
                    <div class="points_system_table table-responsive">
                        <table class="table m-0" width="100%" cellspacing="0" cellpadding="0" border="0">
                            <thead>
                                <tr>
                                    <th>Type of point</th>
                                    <th>T20</th>
                                    <th>ODI</th>
                                    <th>Test</th>
                                    <th>T10</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Applicable for players batting minimum balls</td>
                                    <td>10 balls</td>
                                    <td>20 balls</td>
                                    <td>N/A</td>
                                    <td>5 balls</td>
                                </tr>
                                <tr>
                                    <td>Between 40-50 runs per 100 ball</td>
                                    <td>N/A</td>
                                    <td>-2</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Between 60-70 runs per 100 ball</td>
                                    <td>-2</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Between 50-59.9 runs per 100 ball</td>
                                    <td>-4</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Between 30-39.9 runs per 100 ball</td>
                                    <td>N/A</td>
                                    <td>-4</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                                <tr>
                                    <td>Below 50 runs per 100 ball</td>
                                    <td>-6</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                    <td>N/A</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <ul class="m-0 pl-3 pt-5 points_ul" style="padding-left: 2rem !important; padding-bottom: 2rem">
                <li data-aos="fade-up">
                    The cricketer you choose to be your PlaynWin 11 Fantasy Cricket
                    Team’s Captain will receive 2 times the points.
                </li>
                <li data-aos="fade-up">
                    The Vice-Captain will receive 1.5 times the points for his
                    performance.
                </li>
                <li data-aos="fade-up">
                    Substitutes on the field will not be awarded points for any
                    contribution they make.
                </li>
                <li data-aos="fade-up">
                    In case of any transfer of a real-life player in the intervening
                    period between scheduled updates, such transfer shall not be
                    reflected in the roster of players until the next scheduled update.
                    Please note that while the transferred player will be available for
                    selection in the transferred team's roster of players in a Contest
                    during the intervening period, no points will be attributed to such
                    transferred player in the course of such contest.
                </li>
            </ul>
        </div>

        <!-- Cricket end -->
    </div>
@endsection
