@extends('layouts.front')
@section('title', 'PlaynWin 11')

@push('styles')
    <style>
        section {
            padding: 60px 0;
        }

        .page_title {
            background: radial-gradient(50% 50% at 50% 50%, #009672 0%, #03513E 100%);
            padding: 40px 0px;
        }

        .page_title h1 {
            color: #fff;
        }

        .content ul {
            padding-left: 2.5rem;
        }

        .content ul li {
            list-style-type: disc;
            padding-bottom: 10px;
        }

        h2 {
            font-size: 20px;
            font-weight: 600;
        }

        b,
        strong {
            font-weight: bolder;
        }

        @media (max-width:575px) {
            section {
                padding: 30px 15px !important;
            }

            h2 {
                font-size: 18px;
                line-height: 28px;
            }

            h3 {
                font-size: 16px;
                line-height: 25px;
            }
        }
    </style>
@endpush

@section('content')
    <section class="page_title">
        <div class="container">
            <h1>Tds-policy</h1>
        </div>
    </section>
    <section class="tdspolicy py-5">
        <div class="container">
            <div class="content">
                <p>In accordance with the provisions enclosed in <a
                        href="https://incometaxindia.gov.in/news/finance-bill-2023-highlights.pdf" target="_blank">Finance
                        Act, 2023</a>, subsequent TDS guiding principle is valid for all players
                    on Gameon11 from 1 Apr, 2023.</p>

                <p>Hence, <b>Net Profits = Total Withdrawals - Total Deposits</b> (in a financial year). A financial
                    year is defined as the period from April 1 to March 31.</p>

                <h3>How TDS was calculated before April 1, 2023:</h3>

                <h3>How does the current TDS policy differ from the one that was in place for the fiscal years
                    2022–2023?</h3>

                <ul>
                    <li>TDS is imposed at the time of withdrawal or redemption of a deposit.</li>
                    <li>Any positive net earnings at the time of withdrawal are entitled to a 30% TDS.</li>
                    <li>TDS is also payable on year-end wallet balances by classifying them as withdrawals at the end of
                        the fiscal year. The leftover sum will be carried over as a deposit balance to the following
                        fiscal year once TDS has been applied to the remaining balance (in accordance with policy). The
                        carried forward balance will be treated as an investment for the next year, and TDS will not be
                        charged on that amount.</li>
                    <li>Prior to April 1, 2023, TDS was calculated at the game level when wins exceeded 10K.</li>
                    <li>As an instance, in the past, if I won Rs. 11,000 in a game, 30% TDS, or Rs. 3300, would be
                        subtracted, leaving Rs. 7700 in my withdrawal pocket.</li>
                    <li>From April 1, if I win any money, suppose Rs. 11,000, NO TDS would be taken off when that money
                        is credited to my withdrawal wallet. The winner would receive the whole Rs 11000 in their
                        wallet.</li>
                    <li>We will only consider the user's net earnings and the appropriate TDS basis when they attempt to
                        withdraw any money from their wallet.</li>
                    <li>We shall thus only take TDS out when the running total of withdrawals exceeds the running total
                        of deposits. No TDS will exist if the user is at a loss. So, the users will benefit from this.
                    </li>
                </ul>

                <p>Please be aware that the TDS Policy is based on the interpretation of the laws adopted or changed by
                    the Finance Act of 2023, and the Company has the right to alter, revise, or amend the TDS Policy
                    based on the legislation in effect at the time. <b><a href="/finance-bill-2023-approved-Amendments.pdf"
                            target="_blank">The finance bill
                            amendment</a></b>, which states that the policy will be enforced beginning April 1, 2023,
                    rather than July 1, 2023, are attached (Refer to Page 10, Row 31 and 32).</p>

                <h2>In what ways does it impact players?</h2>

                <p>See a few examples of applications of the aforementioned TDS Policy below.</p>

                <p><strong>Case 1:</strong> 30% TDS will be subtracted from your net earnings at the time of withdrawal
                    if your net winnings (including the withdrawal amount) are more than 0.</p>

                <p><strong>Example:</strong></p>

                <p>There were 5,000 withdrawals overall during fiscal year (A).</p>

                <p>Deposits amounted to 10,000 during the financial year (B).</p>

                <p>If you choose to withdraw 7,000 in the aforementioned situation, your net gains will be as follows:
                </p>

                <table>
                    <tbody>
                        <tr>
                            <td>
                                <p>Amount being withdrawn by the player(C)</p>
                            </td>
                            <td>
                                <p>₹7,000</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>Net gain (A+C - B)</p>
                            </td>
                            <td>
                                <p>₹2,000</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>30% TDS Applicable on Net Winnings(D)</p>
                            </td>
                            <td>
                                <p>₹600</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>Amount to be credited in the bank account(C-D)</p>
                            </td>
                            <td>
                                <p>₹6400</p>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <h3>Zero TDS Withdrawal Amount:</h3>

                <p>If you withdraw up to ₹5,000, there won't be any TDS taken out because your net earnings will be ₹0
                    (i.e., ₹5,000 plus ₹5,000 less ₹10,000). The calculation is shown below:</p>

                <p>Withdrawals overall during the fiscal year (A)</p>

                <p>₹5,000</p>

                <p>Deposits made overall for the fiscal year (B)</p>

                <p>₹10,000</p>

                <p>The sum the player is withdrawing (C)</p>

                <p>₹5,000</p>

                <p>Net gains = (A+C-B)</p>

                <p>₹0</p>

                <p><strong>Case 2:</strong> TDS is not applied to withdrawals if you have previously paid TDS for prior
                    withdrawals, up until your net gains exceed the amount for which you have already made a TDS
                    payment.</p>

                <p><strong>Example:</strong></p>

                <p>Withdrawals overall during the fiscal year</p>

                <p>₹20,000</p>

                <p>Deposits made overall for the fiscal year</p>

                <p>₹20,000</p>

                <p>TDS was paid throughout the fiscal year.</p>

                <p>(TDS paid as you initially had positive net profits of ₹6,000; earnings of ₹6,000 were subject to
                    TDS)</p>

                <p>₹1,800</p>

                <p><b>No TDS will be applied in this case until your net winnings exceed 6,000 (winnings have already
                        been taxed):</b></p>

                <h3>Zero TDS Withdrawal Amount:</h3>

                <p>No TDS is due if you withdraw up to 6,000.</p>

                <p>If you withdraw ₹10,000, 30% TDS will only be applied on the first ₹4,000 in earnings, or ₹1,200.</p>

                <p><strong>Case 3:</strong> You paid TDS on your first gains throughout the financial year, but after
                    that, your net winnings decreased.</p>

                <p>(A) Financial year's worth of withdrawals amounted to 40,000.</p>

                <p>Deposits totaled for the financial year (B)</p>

                <p>20,000</p>

                <p>Net profits for fiscal years (A - B) were</p>

                <p>20,000</p>

                <p>TDS paid thus far is</p>

                <p>₹ 6,000.</p>

                <p>Following this, if your net profits drop to 10,000, subject to any relevant legislation, you may seek
                    a refund for the excess TDS that was deducted from your yearly income tax filing.</p>

                <p><strong>Case 4:</strong> If you have money in your account at the end of the fiscal year, TDS will be
                    calculated on that money by treating it like a withdrawal for the fiscal year; the leftover money
                    will be carried over to the next year as a beginning deposit amount. In the following year,
                    withdrawals from the initial deposit amount won't be taxed.</p>

                <p><strong>For instance:</strong></p>

                <p>Total withdrawals made throughout the fiscal year (A)</p>

                <p>₹40,000</p>

                <p>Deposits totaled 40,000 for the financial year (B).</p>

                <p>TDS paid to date (C)</p>

                <p>(On earnings of ₹5,000 given that your original net winnings were positive).</p>

                <p>₹1,500</p>

                <p>30000 will be the account balance as of March 31, 2024(D).</p>

                <p>In the example above, the computation is made as follows:</p>

                <table>
                    <tbody>
                        <tr>
                            <td>
                                <p>Total withdrawals in the financial year(A+D)</p>
                            </td>
                            <td>
                                <p>₹70,000</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>Total deposits in the financial year(B)</p>
                            </td>
                            <td>
                                <p>₹40,000</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>Net winnings(A+D-B)</p>
                            </td>
                            <td>
                                <p>₹30,000</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>30% TDS Applicable on Net Winnings(E)</p>
                            </td>
                            <td>
                                <p>₹9,000</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>TDS paid till date(C)</p>
                            </td>
                            <td>
                                <p>₹1,500</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <p>TDS Remaining to be paid(E-C)</p>
                            </td>
                            <td>
                                <p>₹7,500</p>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <p>Hence, as of March 31, 2024, your account balance has been reduced by 7,500 TDS, and the remaining
                    balance of 22,500 will be used as a deposit for the next fiscal year. For withdrawals from this
                    amount in the upcoming fiscal year, there will be no TDS due.</p>

                <p><strong>Important Note:</strong> Any money left on the table at the conclusion of the fiscal year
                    will not be factored into the beginning balance for the next year.</p>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script src="https://kit.fontawesome.com/ffd603c3cc.js" crossorigin="anonymous"></script>
@endpush
