@extends('layouts.app')
@section('title', 'PlaynWin11')

@section('content')

    <!-- how to play start -->
    <section class="hw-to-play faq_main">
        <div class="container information">
          <div class="text-center w-75 mx-auto">
            <h2 class="text-center top-title" data-aos="fade-down">
              How to <span>Play ?</span>
            </h2>
            <p>
                PlaynWin11 is played using your sports knowledge and skills. You can pick your own team consisting of real cricket players. Create your team within a maximum of 100 credits. Your team earns points based on your chosen players' performance in real-life matches. It's time to showcase your skills and go for glory!
            </p>
          </div>
          <div class="row responsive_tab">
            <div class="col-md-12 pt-5">
              <div class="vertical_tab mb-5">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                  <li class="nav-item" role="presentation">
                    <button
                      class="nav-link active"
                      data-aos="fade-down"
                      id="home-tab"
                      data-bs-toggle="tab"
                      data-bs-target="#v-pills-home"
                      type="button"
                      role="tab"
                      aria-controls="v-pills-home"
                      aria-selected="true"
                    >
                      Introduction
                    </button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button
                      class="nav-link"
                      data-aos="fade-down"
                      id="profile-tab"
                      data-bs-toggle="tab"
                      data-bs-target="#v-pills-profile"
                      type="button"
                      role="tab"
                      aria-controls="v-pills-profile"
                      aria-selected="false"
                    >
                      Create your Team
                    </button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button
                      class="nav-link"
                      data-aos="fade-down"
                      id="contact-tab"
                      data-bs-toggle="tab"
                      data-bs-target="#v-pills-messages"
                      type="button"
                      role="tab"
                      aria-controls="v-pills-messages"
                      aria-selected="false"
                    >
                      Manage your Team
                    </button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button
                      class="nav-link"
                      data-aos="fade-down"
                      id="contact-tab"
                      data-bs-toggle="tab"
                      data-bs-target="#v-pills-settings"
                      type="button"
                      role="tab"
                      aria-controls="v-pills-settings"
                      aria-selected="false"
                    >
                      Account Balance
                    </button>
                  </li>
                </ul>
              </div>
            </div>
            <div class="col-md-12 responsive_tab">
              <div class="tab-content how_to_play1" id="content">
                <div
                  class="tab-pane fade show active"
                  id="v-pills-home"
                  role="tabpanel"
                  aria-labelledby="v-pills-home-tab"
                >
                  <div
                    class="card-header"
                    data-aos="fade-down"
                    role="tab"
                    id="heading-A"
                  >
                    <h5 class="mb-0">
                      <!-- Note: `data-bs-parent` removed from here -->
                      <a
                        data-bs-toggle="collapse"
                        data-bs-target="#collapse-A"
                        href="#collapse-A"
                        aria-expanded="true"
                        aria-controls="collapse-A"
                      >
                        Introduction
                      </a>
                    </h5>
                  </div>

                  <div
                    id="collapse-A"
                    class="collapse show"
                    data-bs-parent="#content"
                    role="tabpanel"
                    aria-labelledby="heading-A"
                  >
                    <div class="card-body">
                      <div
                        class="row align-items-center justify-content-between justify-content-between"
                      >
                        <div class="col-md-5">
                          <div class="py-4 d-flex text-center app_screen_img">
                            <img
                              src="assets/images/introduction.png"
                              class="img-fluid"
                              data-aos="fade-right"
                            />
                          </div>
                        </div>
                        <div class="col-md-7">
                          <h2 class="pb-4" data-aos="fade-down">
                            Win & Earn at
                            <span>PlaynWin11</span> Introduction
                          </h2>
                          <p data-aos="fade-down">
                            PlaynWin11 is played using your sports knowledge and skills. You can pick your own team consisting of real cricket players. Create your team within a maximum of 100 credits. Your team earns points based on your chosen players' performance in real-life matches. It's time to showcase your skills and go for glory!
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div
                  class="tab-pane fade"
                  id="v-pills-profile"
                  role="tabpanel"
                  aria-labelledby="v-pills-profile-tab"
                >
                  <div
                    class="card-header"
                    data-aos="fade-down"
                    role="tab"
                    id="heading-B"
                  >
                    <h5 class="mb-0">
                      <a
                        class="collapsed"
                        data-bs-toggle="collapse"
                        data-bs-target="#collapse-B"
                        href="#collapse-B"
                        aria-expanded="false"
                        aria-controls="collapse-B"
                      >
                        Create your Team
                      </a>
                    </h5>
                  </div>
                  <div
                    id="collapse-B"
                    class="collapse"
                    data-bs-parent="#content"
                    role="tabpanel"
                    aria-labelledby="heading-B"
                  >
                    <div class="card-body">
                      <div class="create_team_steps position-relative py-5">
                        <div class="row align-items-center">
                          <div class="col-md-6">
                            <div class="text-center app_screen_img pb-4">
                              <img
                                src="assets/images/select-match.png"
                                alt=""
                                class="img-fluid"
                                data-aos="fade-right"
                              />
                            </div>
                          </div>
                          <div class="col-md-6">
                            <p class="steps_text">
                              <span> 1</span> Step
                            </p>
                            <h2 class="pb-4" data-aos="fade-down">
                                Select a <span>Match</span>
                              </h2>
                              <p data-aos="fade-down">
                                Step into the arena of real cricket action with PlaynWin11. Our platform offers a carefully curated selection of matches—from live events and upcoming fixtures to featured tournaments and exclusive contests. Each match is designed to challenge your strategic skills and heighten your excitement. Choose from four dynamic categories that cater to every cricket enthusiast, and let your fantasy journey begin!
                              </p>

                          </div>
                        </div>
                      </div>
                      <!-- Step2 -->
                      <div class="create_team_steps position-relative py-5">
                        <div class="row justify-content-between flex-row-reverse">
                          <div class="col-md-5 align-self-center ">
                            <div class="text-center pb-4 app_screen_img">
                              <img
                                src="assets/images/create-your-team.png"
                                alt=""
                                class="img-fluid"
                                data-aos="fade-left"
                              />
                            </div>
                          </div>
                          <div class="col-md-7 align-self-center">
                            <p class="steps_text" data-aos="fade-down">
                              <span> 2</span> Step
                            </p>
                            <h2 class="pb-4" data-aos="fade-down">
                                Create your <span> Team</span>
                              </h2>
                              <p data-aos="fade-down">
                                Experience the thrill of drafting your perfect cricket squad. Our platform lets you handpick players across all roles—batsmen, bowlers, and all-rounders—while carefully balancing your team’s credits. Every selection is a step towards building a dynamic lineup that mirrors your strategic vision and passion for the game.
                              </p>
                              <p data-aos="fade-down">
                                Delve into the excitement of designating key roles such as captain and vice-captain, and fine-tune your formation to outsmart the competition. With real-time updates and expert insights at your fingertips, each decision brings you closer to victory in the ultimate fantasy cricket challenge.
                              </p>

                          </div>
                        </div>
                      </div>
                      <!-- Step2 -->

                      <!-- Step3 -->
                      <div class="create_team_steps position-relative py-5">
                        <div class="row align-items-center">
                          <div class="col-md-6 align-self-center">
                            <div class="text-center app_screen_img pb-4">
                              <img
                                src="assets/images/choose-captain.png"
                                alt=""
                                class="img-fluid"
                                data-aos="fade-right"
                              />
                            </div>
                          </div>
                          <div class="col-md-6 align-self-center">
                            <p class="steps_text">
                              <span> 3</span> Step
                            </p>
                            <h2 class="pb-4" data-aos="fade-down">
                                Choose your Captain & <span>Vice Captain</span>
                              </h2>
                              <p data-aos="fade-down">
                                Choosing the right Captain and Vice Captain is crucial for transforming your fantasy cricket team into a champion squad. Our platform equips you with real-time statistics and expert insights, helping you pinpoint match leaders whose performance can significantly boost your score. With the Captain’s points doubled and the Vice Captain providing a strategic safety net, every selection is a decisive step towards victory.
                              </p>
                              <p data-aos="fade-down">
                                Leverage detailed player analytics and up-to-the-minute match updates to make informed choices. Whether you're opting for seasoned performers or rising stars, our tools ensure your leadership picks align perfectly with your game strategy. Trust in our comprehensive data to guide your decisions and elevate your fantasy gameplay to new heights.
                              </p>

                          </div>
                        </div>
                      </div>

                      <!-- Step3 -->

                      <!-- Step4 -->
                      <div
                        class="create_team_steps position-relative pt-5 border-0"
                      >
                        <div class="row justify-content-between flex-row-reverse">
                          <div class="col-md-6 align-self-center">
                            <div class="text-center app_screen_img pb-4">
                              <img
                                src="assets/images/create-multiple-team.png"
                                alt=""
                                class="img-fluid"
                                data-aos="fade-left"
                              />
                            </div>
                          </div>
                          <div class="col-md-6 align-self-center">
                            <p class="steps_text">
                              <span> 4</span> Step
                            </p>
                            <h2 class="pb-4" data-aos="fade-down">
                                Creating Multiple <span>Teams</span>
                              </h2>
                              <p data-aos="fade-down">
                                Expand your tactical horizon by creating multiple teams tailored to different match scenarios. Our platform lets you experiment with various player combinations and strategies to maximize your winning potential. Whether you’re crafting a high-risk, high-reward lineup or a balanced side for steady points, each team is a reflection of your unique approach to the game.
                              </p>
                              <p data-aos="fade-down">
                                With real-time updates and detailed player analytics at your fingertips, managing multiple teams becomes a strategic advantage. Adapt your lineups to match the evolving dynamics of every game, refine your strategies with each decision, and discover the thrill of diversified gameplay. Embrace the flexibility to experiment, optimize, and elevate your fantasy cricket experience to new heights.
                              </p>

                          </div>
                        </div>
                      </div>
                      <!-- step4 -->

                      <!-- Step5 -->
                      <div
                        class="create_team_steps position-relative pt-5 border-0"
                      >
                        <div class="row justify-content-between">
                          <div class="col-md-6 align-self-center">
                            <div class="text-center app_screen_img pb-4">
                              <img
                                src="assets/images/join-multiple-contest.png"
                                alt=""
                                class="img-fluid"
                                data-aos="fade-right"
                              />
                            </div>
                          </div>
                          <div class="col-md-6 align-self-center">
                            <p class="steps_text">
                              <span> 5</span> Step
                            </p>
                            <h2 class="pb-4" data-aos="fade-down">
                                Join Multiple <span>Contest</span>
                              </h2>
                              <p data-aos="fade-down">
                                Step into the world of competitive excitement by joining a variety of contests designed to suit every skill level and match format. Our platform features head-to-head battles, league challenges, and grand tournaments that test your strategy and provide an adrenaline rush with every play.
                              </p>
                              <p data-aos="fade-down">
                                Engage with a vibrant community of cricket enthusiasts, track live scores, and climb the leaderboards to win exciting prizes. Whether you’re a seasoned pro or just starting out, each contest offers a unique opportunity to showcase your skills and elevate your fantasy cricket experience.
                              </p>

                          </div>
                        </div>
                      </div>
                      <!-- step5 -->
                    </div>
                  </div>
                </div>
                <div
                  class="tab-pane fade"
                  id="v-pills-messages"
                  role="tabpanel"
                  aria-labelledby="v-pills-messages-tab"
                >
                  <div
                    class="card-header"
                    data-aos="fade-down"
                    role="tab"
                    id="heading-C"
                  >
                    <h5 class="mb-0">
                      <a
                        class="collapsed"
                        data-bs-toggle="collapse"
                        data-bs-target="#collapse-C"
                        href="#collapse-C"
                        aria-expanded="false"
                        aria-controls="collapse-C"
                      >
                        Managing Your Team
                      </a>
                    </h5>
                  </div>
                  <div
                    id="collapse-C"
                    class="collapse"
                    role="tabpanel"
                    data-bs-parent="#content"
                    aria-labelledby="heading-C"
                  >
                    <div class="card-body">
                      <div
                        class="row align-items-center justify-content-between justify-content-between"
                      >
                        <div class="col-md-6 align-self-center">
                          <div class="py-4 text-center app_screen_img">
                            <img
                              src="assets/images/create-multiple-team.png"
                              class="img-fluid"
                              data-aos="fade-right"
                            />
                          </div>
                        </div>
                        <div class="col-md-6 align-self-center">
                          <h2 class="pb-4" data-aos="fade-down">
                              Manage your <span>Team</span>
                          </h2>
                          <p data-aos="fade-down">
                            You can also change your Captain or Vice Captain
                            before the deadline of the match. Select the “Edit
                            Team” button to make changes to your team.
                          </p>
                          <p data-aos="fade-down">
                            Make sure you keep an eye on which of your players are
                            playing the match and keep your session updated at all
                            times.
                          </p>
                          <!-- <p data-aos="fade-down">
                              Tristique ac sed eget senectus purus odio ut mauris
                              laoreet. Quam amet lacus amet venenatis, mauris fames.
                              Sed et, tristique nulla neque, mi penatibus quisque
                              risus donec.
                            </p> -->
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div
                  class="tab-pane fade"
                  id="v-pills-settings"
                  role="tabpanel"
                  aria-labelledby="v-pills-settings-tab"
                >
                  <div
                    class="card-header"
                    data-aos="fade-down"
                    role="tab"
                    id="heading-d"
                  >
                    <h5 class="mb-0">
                      <a
                        class="collapsed"
                        data-bs-toggle="collapse"
                        data-bs-target="#collapse-d"
                        href="#collapse-d"
                        aria-expanded="false"
                        aria-controls="collapse-d"
                      >
                        Account Balance
                      </a>
                    </h5>
                  </div>
                  <div
                    id="collapse-d"
                    class="collapse"
                    role="tabpanel"
                    data-bs-parent="#content"
                    aria-labelledby="heading-d"
                  >
                    <div class="card-body">
                      <div
                        class="row align-items-center justify-content-between justify-content-between"
                      >
                        <div class="col-md-6">
                          <div class="py-4 text-center app_screen_img">
                            <img
                              src="assets/images/withdraw.png"
                              class="img-fluid"
                              data-aos="fade-right"
                            />
                          </div>
                        </div>
                        <div class="col-md-6">
                          <h2 class="pb-4" data-aos="fade-down">
                            View, Withdraw or <span>Deposit</span>
                          </h2>
                          <p data-aos="fade-down">
                            You can View, Withdraw or Deposit money into your
                            PlaynWin11 account anytime by going to the “My
                            Account” link.
                          </p>
                          <p data-aos="fade-down">
                            You will need to go through a One Time Account
                            Verification process before you withdraw any money
                            from your PlaynWin11 account. Don’t worry – this
                            process wont take time and will not be repeated unless
                            you change any of your details.
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

@endsection
