<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use DB;
use Carbon\Carbon;

class CheckWithdraw extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */    
    protected $signature = 'check:withdraw';

    /**
     * The console command description.
     *
     * @var string
     */    
    protected $description = 'Pending Withdraw requests has been updated successfully.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */



    public function handle()
    {
        \Log::info("schedule handle");
        $date=strtotime(date('Y-m-d'));
        // $newDate = date('Y-m-d',strtotime('-3 days',$date)).' 00:00:00';
        // $newDate = date('Y-m-d',strtotime('0 days',$date)).' 00:00:00';
        $newDate = Carbon::now()->subMinutes(2)->format("Y-m-d H:i:s");

        $query =  DB::table('withdraw')
            ->where('type', '=', 'bank')
            ->where('status',0)
            ->where('is_instant',0)
            ->whereNotNull('withdraw.transfer_id')
            ->where('withdraw.cashfree_status', '=','PENDING')
            ->where('withdraw.created', '<=', $newDate);

        $titles = $query->orderBY('created','DESC')->get();

        foreach ($titles as $output)
        {   
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => CF_URL.'/payout/v1/authorize',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_HTTPHEADER => array(
                    'X-Client-Id: '.CF_CLIENT_ID,
                    'X-Client-Secret: '.CF_CLIENT_SECRET
                ),
            ));

            $result = curl_exec($curl);
            curl_close($curl);
            $result = json_decode($result);
            $result_data = @$result->data;
            $token = @$result_data->token;
             
            if(!empty($token))
            {
                // \Log::info("CheckWithdrawCommand token");
                $headers = array();
                $headers[] = "Authorization: Bearer ".$token;
                $headers[] = "Cache-Control: no-cache";

                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => CF_URL."/payout/v1/getTransferStatus?transferId=$output->transfer_id",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => $headers,
                ));

                $result = curl_exec($curl);
                $result = json_decode($result);
                $result_data = @$result->data;
                // print_r($result_data);
                $finaloutput = (isset($result_data->{'transfer'}) ? (array)$result_data->{'transfer'} : '' );
                
                if(isset($finaloutput['status']))
                {
                    // \Log::info("CheckWithdrawCommand status");
                    if($finaloutput['status'] == 'SUCCESS')
                    {
                         $update_userbalance =   DB::table('withdraw')                         
                                                ->where('id', $output->id)
                                                ->where('transfer_id', $output->transfer_id)
                                                ->update(['status' => 1, 'comment' => 'SUCCESS - In Cashfree', 'cashfree_status' => 'SUCCESS']);

                        $withdrawal_insert_data = array(
                            "refrence_id" => $finaloutput['referenceId'],
                            "utr_number" => $finaloutput['utr'],
                            "transfer_id" => $output->transfer_id,
                            "banid" => $finaloutput['beneId'],
                            "amount" => $finaloutput['amount'],
                            "status" => 1
                        );
                        DB::table('transfer_request')->insert($withdrawal_insert_data);                   
                    }
                    elseif($finaloutput['status'] == 'REVERSED')
                    {
                        $errorReason = isset($finaloutput['reason']) ? $finaloutput['reason'] : "REVERSED - In Cashfree";
                        $update_userbalance =  DB::table('withdraw')
                            ->where('id', $output->id)
                            ->where('transfer_id', $output->transfer_id)
                            ->update(['status' => 0, 'comment' => 'REVERSED - In Cashfree =' .$errorReason, 'cashfree_status' => 'REVERSED']);                     
                    }
                    elseif($finaloutput['status'] == 'FAILED')
                    {
                        $errorReason = isset($finaloutput['reason']) ? $finaloutput['reason'] : "FAILED from Cashfree";
                        $update_userbalance =   DB::table('withdraw')
                            ->where('id', $output->id)
                            ->where('transfer_id', $output->transfer_id)
                            ->update(['status' => 0, 'cashfree_status' => 'FAILED', 'comment' => $errorReason]);                   
                    }
                }
            }
        }
        $this->info('Withdraw requests has been updated successfully');
    }
    
}