<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use DB;
use Session;
use Carbon\Carbon;
use App\Helpers\Helpers;

class UserDailyBalanceDetail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:dailybalancedetail';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Balance Details of Daily';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */


    public function handle()
    {
      // \Log::info("Balance detail saved start");
        date_default_timezone_set("Asia/Kolkata");
        $created_at = Carbon::now()->subDays(1)->format("Y-m-d");

        $exists = DB::table("users_daily_total_balance")
            ->where("created_at", date("Y-m-d", strtotime($created_at)))
            ->exists();
        if(!$exists) {
          $userbalances = DB::table('userbalances')
              ->SelectRaw("
                  SUM(balance) as balance,
                  SUM(winning) as winning,
                  SUM(bonus) as bonus
              ")
              ->first();

            // $add_cash = DB::table("transactions")
            //     ->whereBetween("created", [date("Y-m-d 00:00:00", strtotime($created_at)), date("Y-m-d 23:59:59", strtotime($created_at))])
            //     ->where("type", "Add Fund")
            //     ->where(function($q) {
            //         $q->where("paymentstatus", "=", "confirmed")
            //           ->orWhere("paymentstatus", "=", "confirm");
            //     })
            //     ->sum("amount");
            //
            // $withdraw = DB::table("transactions")
            //     ->whereBetween("created", [date("Y-m-d 00:00:00", strtotime($created_at)), date("Y-m-d 23:59:59", strtotime($created_at))])
            //     ->whereIn("type", ["Instant Withdraw Charges","Amount Withdrawn"])
            //     ->where(function($q) {
            //         $q->where("paymentstatus", "=", "confirmed")
            //           ->orWhere("paymentstatus", "=", "confirm");
            //     })
            //     ->sum("amount");
            //
            // $bonus_trans = DB::table("transactions")
            //     ->whereBetween("created", [date("Y-m-d 00:00:00", strtotime($created_at)), date("Y-m-d 23:59:59", strtotime($created_at))])
            //     ->where(function($q) {
            //         $q->where("paymentstatus", "=", "confirmed")
            //           ->orWhere("paymentstatus", "=", "confirm");
            //     })
            //     ->selectRaw("
            //         SUM(cons_bonus) as bonus_used,
            //         SUM(bonus_amt) as bonus_add
            //     ")
            //     ->first();
            //
            // $total_bonus_add = @$bonus_trans->bonus_add ?? 0;
            // $total_bonus_used = @$bonus_trans->bonus_used ?? 0;

            DB::table("users_daily_total_balance")
              ->insert([
                  "balance" => $userbalances->balance,
                  "winning" => $userbalances->winning,
                  "bonus" => $userbalances->bonus,
                  // "add_cash" => $add_cash,
                  // "withdraw" => $withdraw,
                  // "total_bonus_add" => $total_bonus_add,
                  // "total_bonus_used" => $total_bonus_used,
                  "created_at" => $created_at
              ]);

            // try {
            //     DB::table("users_daily_total_balance")
            //         ->insert([
            //             "balance" => $userbalances->balance,
            //             "winning" => $userbalances->winning,
            //             "bonus" => $userbalances->bonus,
            //             "add_cash" => $add_cash,
            //             "withdraw" => $withdraw,
            //             "total_bonus_add" => $total_bonus_add,
            //             "total_bonus_used" => $total_bonus_used,
            //             "created_at" => $created_at
            //         ]);
            // }
            // catch(Exception $e) {
            //   \Log::info("Balance detail saved error");
            // }

        }
        $this->info('Balance detail saved');
    }

}
