<?php

namespace App\Helpers;

use Swift_SmtpTransport;
use Swift_Mailer;
use Illuminate\Support\Facades\Storage;
use Aws\S3\S3Client;
use App\Models\AdminActivityLog;
use App\Services\Input;
// use App\Model\Registerusers;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use App\Services\Firebase;
use App\Services\Push;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

//	date_default_timezone_set("Asia/Kolkata");
class Helpers
{
    public static function getCurrentSessionYear()
    {

        date_default_timezone_set("Asia/Kolkata");
        $dated = date("Y-m-d");
        $month = date("n", strtotime($dated));
        if ($month < 4) {
            return date("Y", strtotime("-1 year", strtotime($dated)));
        }
        return date("Y", strtotime($dated));
    }

    public static function rozarpaypayout($bank, $users, $withdraw)
    {

        // $razorpay_key_id='rzp_live_Z3dpgmmVyXhJ0M';
        // $razorpay_key_scrireference_idpt='wm5F6ieNsD6RMYcuSjaRX7vw';
        $razorpay_key_id = 'rzp_live_od8A1KotZ88AoT';
        $razorpay_key_scrireference_idpt = 'FD7k8SuCXpyEsXsDhlGEd13N';
        $notes = array();
        $notes["notes_key_1"] = "user withdraw Payment ";
        $notes["notes_key_2"] = "FW11 razorpay payouts ";
        //user details
        $contacts = array();
        $contacts["name"] = $bank->ac_holder_name;
        $contacts["email"] = @$users->email;
        $contacts["contact"] = $users->mobile;
        $contacts["type"] = "customer";
        $contacts["reference_id"] = "User" . $users->id;
        $contacts["notes"] = $notes;
        //user Bank details
        $bankAccount = array();
        $bankAccount["name"] = $bank->ac_holder_name;
        $bankAccount["ifsc"] = $bank->ifsc;
        $bankAccount["account_number"] = $bank->accno;

        $fundaccount = array();
        $fundaccount["account_type"] = "bank_account";
        $fundaccount["bank_account"] = $bankAccount;
        $fundaccount["contact"] = $contacts;
        $withdrawAmount = round($withdraw->amount, 2);
        $withdrawAmountArr = explode(".", $withdrawAmount);
        // dd($withdrawAmountArr);
        if (isset($withdrawAmountArr[1])) {
            $totalPaisa = $withdrawAmountArr[0] * 100 + $withdrawAmountArr[1];
        } else {
            $totalPaisa = $withdrawAmountArr[0] * 100;
        }
        $from_account = array();
        $from_account["account_number"] = '409001825511';
        //  $from_account["fund_account_id"]='fa_00000000000003';
        $from_account["amount"] = $totalPaisa;
        $from_account["currency"] = "INR";
        $from_account["mode"] = "IMPS";
        $from_account["purpose"] = "payout";
        $from_account["fund_account"]['account_type'] = "bank_account";
        $from_account["fund_account"]['bank_account'] = $bankAccount;
        $from_account["fund_account"]['contact'] = $contacts;
        //  $from_account["fund_account"]=$fundaccount;
        $from_account["queue_if_low_balance"] = true;
        $from_account["reference_id"] = "withdraw_" . $withdraw->id;
        $from_account["narration"] = "Winnings";
        $from_account["notes"] = $notes;
        $withdraw_id = $withdraw->id;
        $appkey = $razorpay_key_id . ':' . $razorpay_key_scrireference_idpt;
        $token = base64_encode($appkey);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.razorpay.com/v1/payouts',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($from_account),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Basic ' . $token
            ),
        ));

        $response1 = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response1);
        return $response;
    }
    public static function rozarpaypayoutStatus($bank, $users, $withdraw, $pout_id)
    {
        // $razorpay_key_id='rzp_live_Z3dpgmmVyXhJ0M';
        // $razorpay_key_scrireference_idpt='wm5F6ieNsD6RMYcuSjaRX7vw';

        $razorpay_key_id = 'rzp_live_od8A1KotZ88AoT';
        $razorpay_key_scrireference_idpt = 'FD7k8SuCXpyEsXsDhlGEd13N';

        $appkey = $razorpay_key_id . ':' . $razorpay_key_scrireference_idpt;
        $token = base64_encode($appkey);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.razorpay.com/v1/payouts/' . $pout_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Basic ' . $token
            ),
        ));

        $response1 = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response1);
        return $response;
    }
    public static function auto_update_current_price_pool($matchkey, $challenege_id, $rate_of_distribute_winning)
    {

        $matchchalanges = DB::table('matchchallenges')->where('id', $challenege_id)->first();
        $totalwinning = $matchchalanges->win_amount;
        $totalEarning = ($matchchalanges->entryfee * $matchchalanges->maximum_user);
        $rate_of_winning_distribute = (($totalwinning / $totalEarning) * 100);
        $total_joinuser_earning = $matchchalanges->entryfee * $matchchalanges->joinedusers;
        $total_joinuser_winning = ($total_joinuser_earning * $rate_of_winning_distribute) / 100;
        $allpricecard =  DB::table('matchpricecards')->where('matchkey', $matchkey)->where('challenge_id', $challenege_id)->orderby('max_position', 'ASC')->get();
        // echo "<pre>"; print_r($allpricecard); exit;
        $Json = array();
        if (!empty($total_joinuser_winning)) {
            foreach ($allpricecard as $key => $pricecard) {
                $start_position = 0;
                if (!empty($pricecard->min_position) && $pricecard->min_position + 1 != $pricecard->max_position) {
                    $start_position = $pricecard->min_position + 1 . '-' . $pricecard->max_position;
                } else {
                    $start_position = '' . $pricecard->max_position;
                }
                if (($pricecard->price * $pricecard->winners) >= $total_joinuser_winning) {

                    $data1 = array(
                        "matchkey" => $matchkey,
                        "challenge_id" => $challenege_id,
                        "winners" => $pricecard->winners,
                        "price" => round($total_joinuser_winning / $pricecard->winners),
                        "min_position" => $pricecard->min_position,
                        "max_position" => $pricecard->max_position,
                        "total" => (string)round($total_joinuser_winning / $pricecard->winners)
                    );
                    if ($pricecard->price < $total_joinuser_winning) {
                        $total_joinuser_winning = $total_joinuser_winning - $pricecard->price;
                    }
                    array_push($Json, $data1);
                    break;
                } else {
                    $data2 = array();
                    $data2['matchkey'] = $pricecard->matchkey;
                    $data2['challenge_id'] = $pricecard->challenge_id;
                    $data2['winners'] = $pricecard->winners;
                    $data2['price'] = $pricecard->price;
                    $data2['min_position'] = $pricecard->min_position;
                    $data2['max_position'] = $pricecard->max_position;
                    $data2['total'] = $pricecard->total;

                    if ($pricecard->price < $total_joinuser_winning) {
                        $total_joinuser_winning = $total_joinuser_winning - $pricecard->price;
                    }
                    array_push($Json, $data2);
                }
            }
        }

        return $Json;
    }

    public static function auto_update_current_price_pool_old($matchkey, $challenege_id, $rate_of_distribute_winning)
    {

        $matchchalanges = DB::table('matchchallenges')->where('id', $challenege_id)->first();

        $totalwinning = $matchchalanges->win_amount;
        $totalEarning = ($matchchalanges->entryfee * $matchchalanges->maximum_user);
        $rate_of_winning_distribute = (($totalwinning / $totalEarning) * 100);

        $total_joinuser_earning = $matchchalanges->entryfee * $matchchalanges->joinedusers;
        $total_joinuser_winning = ($total_joinuser_earning * $rate_of_winning_distribute) / 100;

        $allpricecard =  DB::table('matchpricecards')->where('matchkey', $matchkey)->where('challenge_id', $challenege_id)->orderby('max_position', 'ASC')->get();
        // echo "<pre>"; print_r($allpricecard); exit;
        $Json = array();
        if (!empty($total_joinuser_winning)) {
            foreach ($allpricecard as $key => $pricecard) {
                $start_position = 0;
                if (!empty($pricecard->min_position) && $pricecard->min_position + 1 != $pricecard->max_position) {
                    $start_position = $pricecard->min_position + 1 . '-' . $pricecard->max_position;
                } else {
                    $start_position = '' . $pricecard->max_position;
                }

                if (($pricecard->price * $pricecard->winners) >= $total_joinuser_winning) {
                    $Json[] = array(
                        "matchkey" => $matchkey,
                        "challenge_id" => $challenege_id,
                        "winners" => $pricecard->winners,
                        "price" => round($total_joinuser_winning / $pricecard->winners),
                        "min_position" => $pricecard->min_position,
                        "max_position" => $pricecard->max_position,
                        "total" => (string)round($total_joinuser_winning / $pricecard->winners)
                    );

                    break;
                } else {

                    $Json[] = array(
                        "totalwinners" => (string)$pricecard->winners,
                        "price" => (string)$pricecard->price,
                        "start_position" => (string)$start_position,
                        "total" => (string)$pricecard->total

                    );
                    if ($pricecard->price < $total_joinuser_winning) {
                        $total_joinuser_winning = $total_joinuser_winning - $pricecard->price;
                    }
                }
            }
        }
        return $Json;
    }
    public static function mailSmtpSend1($datamessage)
    {
        $backup = Mail::getSwiftMailer();
        $transport = Swift_SmtpTransport::newInstance('smtp.gmail.com', 587, 'tls');
        $transport->setUsername('support@FW11.in');
        $transport->setPassword('aiptrlzdfkupchge');
        $gmail = new Swift_Mailer($transport);
        Mail::setSwiftMailer($gmail);
        Mail::send('emails.commonmail', $datamessage, function ($m) use ($datamessage) {
            $m->from($datamessage['fromemail'], 'FW11');
            $m->to($datamessage['email'])->subject($datamessage['subject']);
        });
    }
    public static function mailSmtpSend($datamessage)
    {
        Mail::send('emails.commonmail', $datamessage, function ($m) use ($datamessage) {
            $m->from('info@FW11.in', 'FW11');
            $m->to($datamessage['email'])->subject($datamessage['subject']);
        });
    }

    // public static function mailSmtpDeposit($datamessage)
    // {
    //     echo '<pre>';
    //     print_r($datamessage);
    //     exit;

    //     Mail::send('emails.deposit_mailer', $datamessage, function ($m) use ($datamessage) {
    //         $m->from('info@FW11.in', 'FW11');
    //         $m->to($datamessage['email'])->subject($datamessage['subject']);
    //     });
    // }
    public static function projectName()
    {
        return 'FW11';
    }
    public static function getmainmail()
    {
        return 'rohit19.img@gmail.com';
    }
    public static function geturl()
    {
        return env("APP_URL");
    }
    public static function getUserNameShow($name, $email)
    {
        if ($name != "") {
            return ucwords($name);
        } else {
            return $email;
        }
    }
    public static function controllerName()
    {
        $routeArray = app('request')->route()->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        list($controller, $action) = explode('@', $controllerAction);
        return $controller;
    }
    public static function actionName()
    {
        $routeArray = app('request')->route()->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        list($controller, $action) = explode('@', $controllerAction);
        return $action;
    }
    public static function errormessage($errors)
    {
        $content = "";
        if ($errors->any()) {
            $content = implode('', $errors->all('<div class="error-message">:message</div>'));
        }
        return $content;
    }

    public static function logActivity($activity = '', $activity_element = '', $transaction_id = '')
    {
        // $newDateTime = Carbon::now()->addMinute(+330);
        $newDateTime = Carbon::now();
        // var_dump('$activity');exit;
        // echo "<pre>"; print_r($newDateTime); exit;
        if (!empty($activity)) {
            $model = new AdminActivityLog;
            $model->user_id = Auth::user()->id;
            $model->activity = $activity;
            $model->activity_element = $activity_element;
            if (!empty($transaction_id)) {
                $model->transaction_id = $transaction_id;
            }
            //  $model->created_at	 = now();
            //$model->updated_at	 = $newDateTime;
            if ($model->save()) {
                return $model;
            } else {
                return 'something wrong with request.';
            }
        } else {
            return 'Activity Not Found.';
        }
    }


    public static function getSessionMessage()
    {
        $content = "";
        if (Session::has('message')) {
            $content .= '<div class="alert alert-info">' . Session::get('message') . '</div>';
        }
        return $content;
    }

    // public static function flashMessage(){
    // 	if (Session::has('message')){
    // 		$class="";
    // 		$class = Session::get('alert-class');
    // 		$message = Session::get('message');
    // 		$content='<div class="alert '.$class.'">'.$message.'</div>';
    // 		return $content;
    // 	}
    // 	else{
    // 		$content="";
    // 		return $content;
    // 	}
    // }

    public static function sendTextSmsNew($txtmsg, $mobile)
    {
        //$mobile=str_replace('$$',',',$mobile);
        $message = urlencode($txtmsg);
        $rent_payment_url = "http://api.msg91.com/api/sendhttp.php?sender=CLBELV&route=4&mobiles=" . $mobile . "&authkey=278146ALuEXu9U5ce7e453&country=91&message=" . $message . ""; //echo $rent_payment_url; exit();
        // $ch = curl_init();
        // curl_setopt( $ch, CURLOPT_URL, $rent_payment_url );
        // curl_setopt( $ch, CURLOPT_POST, true );
        // curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
        // curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        // curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false);
        // curl_setopt( $ch, CURLOPT_SSLVERSION, 6);
        // $result = curl_exec($ch);
        // $curl_error = curl_error($ch); //print_r($curl_error); exit;


        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $rent_payment_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        //print_r($response); exit;
        curl_close($curl);
        //print_r($curl);die;

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            return true;
            // echo $response;
        }
    }

    public static function sendTextSMS($txtmsg, $mobile)
    {
        // $mobile=str_replace('$$',',',$mobile);
        // $txtmsg=rawurlencode($txtmsg);
        // $url="http://sms.imgglobalinfotech.com/api/send_http.php?authkey=706b7ffed8ac4d47b4bbd9b0306735e2&mobiles=".$mobile."&message=".$txtmsg."&sender=MIMESY&route=B";
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_exec($ch);
        // curl_close($ch);
        require_once "vendor/twilio-php-master/Twilio/autoload.php";
        $sid = 'AC4d8b4a0a15f38fa3b300170f1c2d815c';
        $token = '00c7579b97c9c37e03b2eb5f3f54ce8c';
        // $clientvar = new Client($sid, $token);
        // $clientvar->messages->create(
        // $mobile,
        // array(
        // 'from' => '+1 716-221-8525',
        // 'body' => $txtmsg
        // )
        // );

    }
    public static function imageExtension($file)
    {
        $filename = $file->getClientOriginalName();
        $extension = $file->getClientOriginalExtension();
        $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');
        if (!in_array($extension, $ext)) {
            return false;
        }
        return true;
    }

    public static function imageSingleUploads($input, $destinationPath, $fileName, $mode)
    {
        $image_parts = explode(";base64,", $input['base64image']);
        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1];
        $image_base64 = base64_decode($image_parts[1]);
        $filename = $fileName . '.' . $image_type;
        $file = $destinationPath . $filename;
        file_put_contents($file, $image_base64);
        return $filename;
    }


    public static function imageUpload($file, $destinationPath, $fileName)
    {
        $array = array();
        foreach ($file as $fileimage) {
            $filename = $fileimage->getClientOriginalName();
            $extension = $fileimage->getClientOriginalExtension();
            $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');
            if (!in_array($extension, $ext)) {
                return false;
            }
            $newfilename = $fileName . '.' . $extension;
            if (file_exists($destinationPath . '/' . $newfilename)) {
                $info = pathinfo($newfilename);
                $imageNamee = $info['filename'] . '-' . rand(100, 999);
                $newfilename = $imageNamee . "." . $info['extension'];
            }
            $array[] = $newfilename;
            $upload_success = $fileimage->move($destinationPath, $newfilename);
            $resi = $destinationPath . '/' . $newfilename;
            /*$resizeimage=Helpers::resize_image($resi);
					$resizeimage=Helpers::compress_image($resi,100);*/
        }
        $imageNames = implode('{$}', $array);
        return $imageNames;
    }

    public static function imageSingleUpload($fileimage, $destinationPath, $fileName)
    {
        $array = array();

        $filename = $fileimage->getClientOriginalName();
        $extension = $fileimage->getClientOriginalExtension();
        $ext = array('jpg', 'JPG', 'jpeg', 'gif', 'png');
        if (!in_array($extension, $ext)) {
            return false;
        }
        $newfilename = $fileName . '.' . $extension;
        if (file_exists($destinationPath . '/' . $newfilename)) {
            $info = pathinfo($newfilename);
            $imageNamee = $info['filename'] . '-' . rand(100, 999);
            $newfilename = $imageNamee . "." . $info['extension'];
        }
        $array[] = $newfilename;
        $upload_success = $fileimage->move($destinationPath, $newfilename);
        $resi = $destinationPath . '/' . $newfilename;
        /*$resizeimage=Helpers::resize_image($resi);
					$resizeimage=Helpers::compress_image($resi,100);*/

        return $newfilename;
    }

    public static function compress_image($destination_url, $quality)
    {
        // $sizeee = filesize($destination_url);
        // if($sizeee>100000){
        // $info = getimagesize($destination_url);
        // if ($info['mime'] == 'image/jpeg') $image = imagecreatefromjpeg($destination_url);
        // elseif ($info['mime'] == 'image/gif') $image = imagecreatefromgif($destination_url);
        // elseif ($info['mime'] == 'image/png') $image = imagecreatefrompng($destination_url);
        // imagejpeg($image, $destination_url, $quality);
        // }
        // return $destination_url;
    }
    public static function resize_image($destination_url)
    {
        // $info = getimagesize($destination_url);
        // if($info['mime'] == 'image/jpeg' || $info['mime'] == 'image/jpg')
        // {
        // $src = imagecreatefromjpeg($destination_url);
        // }
        // else if($info['mime'] == 'image/png')
        // {
        // $src = imagecreatefrompng($destination_url);
        // }
        // else
        // {
        // $src = imagecreatefromgif($destination_url);
        // }
        // list($width,$height)=getimagesize($destination_url);
        // if($width>1500){
        // $newwidth=1500;
        // $newheight=($height/$width)*$newwidth;
        // $tmp=imagecreatetruecolor($newwidth,$newheight);
        // imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
        // imagejpeg($tmp,$destination_url,100);
        // imagedestroy($src);
        // imagedestroy($tmp);
        // }
        // return $destination_url;
    }
    public static function dateformatforposting($date)
    {
        $content = "";
        date_default_timezone_set('Asia/Kolkata');
        $cpasttime = date('d-m-Y H:i:s', strtotime($date));
        $time_ago = strtotime($cpasttime);
        $time = date('d-m-Y H:i:s');
        $cur_time     = strtotime($time);
        $time_elapsed     = $cur_time - $time_ago;
        $seconds     = $time_elapsed;
        $minutes     = round($time_elapsed / 60);
        $hours         = round($time_elapsed / 3600);
        $days         = round($time_elapsed / 86400);
        $weeks         = round($time_elapsed / 604800);
        $months     = round($time_elapsed / 2600640);
        $years         = round($time_elapsed / 31207680);
        // Seconds
        if ($seconds < 0) {
            $content .= "";
        } else if ($seconds <= 60) {
            $content .= "  $seconds seconds ago";
        }
        //Minutes
        else if ($minutes <= 60) {
            if ($minutes == 1) {
                $content .= " one minute ago";
            } else {
                $content .= "  $minutes minutes ago";
            }
        }
        //Hours
        else if ($hours <= 24) {
            if ($hours == 1) {
                $content .= "  an hour ago";
            } else {
                $content .= "  $hours hours ago";
            }
        }
        //Days
        else if ($days <= 7) {
            if ($days == 1) {
                $content .= " yesterday at " . date('h:i A', strtotime($date));
            } else {
                $content .= "  $days days ago ( " . date('M d, Y', strtotime($date)) . ' at ' . date('h:i A', strtotime($date)) . ")";
            }
        } else {
            $content .= date('M d, Y', strtotime($date));
        }
        return $content;
    }

    public static function allmatchformats()
    {
        $formats = array();
        $format['t10'] = 't10';
        $format['t20'] = 't20';
        $format['test'] = 'test';
        $format['hundred'] = 'the hundred';
        $format['one-day'] = 'one-day';
        return $format;
    }
    public static function mailheader()
    {
        $geturl = Helpers::geturl();
        $mail = '<!doctype html>
	<html lang="en">
		<head>
			<!-- Required meta tags -->
			<meta charset="utf-8">
			<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
			<title>FC | email template</title>
			<link href="https://fonts.googleapis.com/css?family=Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese" rel="stylesheet">
			<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					width: 100%;
					background-color: #f6f6f6;
				}
				table#bodyTable {
					font-family: "Roboto", sans-serif;
					font-size: 14px;
					border-collapse: collapse;
					padding: 0px;
					margin: 0px;
				}
				#emailContainer {
					background-repeat: no-repeat;
					background-position: right top;
				}
				#emailFooter {
					border-top: 1px solid #ebebeb;
					padding-top: 30px;
					padding-bottom: 30px;
					padding-left: 40px;
					padding-right: 40px;
				}
				a {
					line-height: 100%;
					color: #29a6ae;
					text-decoration: none;
				}
				img {
					display: block;
				}
				h1, h2, h3, h4, h5, h6 {
					font-family: "Roboto", sans-serif;
					font-weight: 700;
					margin: 0px;
					line-height: 1.4em;
				}
				h2 {
					font-size: 38px;
					color: #29a6ae;
				}
				h4 {
					font-size: 24px;
					font-weight: 500;
					color: #111111;
				}
				h6 {
					font-size: 18px;
					font-weight: 400;
				}
				p {
					color: #565656;
					margin: 0px;
					line-height: 1.8em;
				}
				.gray-text {
					color: #565656;
				}
				.fs-16, .link {
					font-size: 16px;
				}
				.click-button {
					display: inline-block;
					background-color: #212529;
					font-size: 14px;
					text-align: center;
					color: #ffffff;
					text-transform: uppercase;
					padding-top: 12px;
					padding-bottom: 12px;
					padding-right: 38px;
					padding-left: 38px;
					border-radius: 4px;
				}
				.click-button a {
					color: #ffffff;
				}
				.best-of-luck-text {
					font-size: 20px;
					text-transform: uppercase;
					color: #eb272a;
					font-weight: 500;
					text-shadow: 0px 2px 0px rgba(61,181,185, 0.20);
				}
			</style>
		</head> <body>';
        return $mail;
    }
    public static function mailbody($content)
    {
        $mail = '<div style="background-color:#f4f5f4;padding-bottom:20px;padding-top:20px;float:left;width:100%;">
		<div style="border-radius:0px;width:94.6%;margin:0px 0px;font-size: 13px;letter-spacing: 0.3px;">
			<div style="width:100%;float:left;border:1px solid #ab6710;padding:0px 15px;background-color:#fff;">
				' . $content . '
				<p style="width:100%;">In case of any queries please <a href="">contact us </a>.</p>
			</div>
		</div>
	</div>';
        return $mail;
    }
    public static function mailfooter()
    {
        $mail = '';
        return $mail;
    }

    // public static function mailsentFormat1($email, $subject, $mailmessage)
    // {
    //     $headers = "MIME-Version: 1.0" . "\r\n";
    //     $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    //     $headers .= 'From:  FW11 <support@FW11.in>' . " \r\n";
    //     $headers .= "Reply-To: support@FW11.in\r\n";
    //     $headers .= "Return-Path: support@FW11.in\r\n";
    //     mail($email, $subject, $mailmessage, $headers, "-f support@FW11.in");
    // }

    public static function mailsentFormat2($email, $subject, $mailmessage)
    {
        $emailGrid = new \SendGrid\Mail\Mail();
        $emailGrid->setFrom("noreply@club11.co.in", "Club11");
        $emailGrid->setSubject($subject);
        $emailGrid->addTo($email, "Example User");
        //$email->addContent("text/plain", "and easy to do anywhere, even with PHP");
        $emailGrid->addContent(
            "text/html",
            $mailmessage
        );
        $sendgrid = new \SendGrid(getenv('SENDGRID_API_KEY'));
        try {
            $response = $sendgrid->send($emailGrid);
            //echo 'sent';
        } catch (\Exception $e) {
            //echo 'Caught exception: '. $e->getMessage() ."\n";
        }
    }

    public static function mailsentFormat($to, $subject, $body)
    {
        $body = urlencode($body);
        $subject = urlencode($subject);
        $url = "http://control.msg91.com/api/sendmail.php";
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "authkey=278146ALuEXu9U5ce7e453&from=noreply@rglabs.net&to=" . $to . "&subject=" . $subject . "&body=" . $body,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
        ));

        $response = curl_exec($curl);  //print_r($response); exit;
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            // echo "cURL Error #:" . $err; exit;
            return 0;
        } else {
            // echo $response;
            return 1;
        }
    }

    public static function sendnotification($title, $message, $include_image, $regId)
    {

        if ($regId != "") {
            $findappids = DB::table('androidappid')->where('userid', $regId)->get();
            // dd($findappids);
            if (!empty($findappids)) {
                foreach ($findappids as $app) {
                    $firebase = new Firebase("fel0JZ7vRuOTaSND_18jSn:APA91bG6GBxAXk4qAqiEhH_tK3c_Kp89AU19TjVQjDS4eMInck6PN1UvdHhjXkp0VAcDbWzmU-4SdO2sBYqcaQESub9IsLbhIxZJQ6Lml45lzX4a2Fg4Szk", "Test notifica", "cation");
                    $response = $firebase->send();
                }
            }
        }
    }

    // public static function sendnotification_old($title,$message,$include_image,$regId){
    // 		require_once('./sendnotification/firebase.php');
    // 	    require_once('./sendnotification/push.php');
    // 		if($regId!=""){
    // 			//$findappids = DB::table('androidappid')->where('userid',$regId)->get();
    // 			$findappids = DB::table('registerusers')->where('id',$regId)->get();
    //     //dd($findappids);
    // 			if(!empty($findappids)){
    // 				foreach($findappids as $app){
    // 					$firebase = new Firebase();
    // 					$push = new Push();
    // 					$payload = array();
    // 					$payload['team'] = 'India';
    // 					$payload['score'] = '5.6';
    // 					$push->setTitle($title);
    // 					$push->setMessage($message);
    // 					$push_type='individual';
    // 					if ($include_image!="") {
    // 						$push->setImage($include_image);
    // 					} else {
    // 						$push->setImage('');
    // 					}
    // 					$push->setIsBackground(FALSE);
    // 					$push->setPayload($payload);
    // 					$json = '';
    // 					$response = '';

    // 					if ($push_type == 'topic') {
    // 						$json = $push->getPush();
    // 						$response = $firebase->sendToTopic('global', $json);
    // 					} else if ($push_type == 'individual') {
    // 						$json = $push->getPush();
    // 						$response = $firebase->send($app->fcmToken, $json);
    // 					}
    //         // var_dump($response);
    // 				}
    // 			}
    // 		}

    // 	}

    public static function getnewmail($email)
    {
        if (strpos($email, '@gmail.com') !== false) {
            $wordbreak = explode('@gmail.com', $email);
            $word1 = str_replace('.', '', $wordbreak[0]);
            $email = $word1 . '@gmail.com';
        }
        return $email;
    }

    public static function cf_get_token()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => ROZ_PAY_URL . '/payout/v1/authorize',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array(
                'X-Client-Id: ' . ROZARPAY_KEY_ID,
                'X-Client-Secret: ' . RAZORPAY_SECRET_KEY
            ),
        ));

        $result = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($result);
        $result_data = @$result->data;
        return @$result_data->token;
    }

    public static function cf_verify_token($token)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => CF_URL . '/payout/v1/verifyToken',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer " . $token,
                "Cache-Control: no-cache"
            ),
        ));

        $result = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($result);
        if (@$result->status == 'SUCCESS') {
            return true;
        } else {
            return false;
        }
    }

    public static function cf_genrate_banid($user_id)
    {
        $row = DB::table('registerusers')->where('id', $user_id)->first();
        $name = $row->username;
        return str_replace(' ', '', mb_substr($name, 0, 3)) . $user_id . rand(101, 999);
    }

    public static function cf_add_benificary($user_id)
    {
        $token = Helpers::cf_get_token();
        if ($token) {
            if (Helpers::cf_verify_token($token)) {

                $row = DB::table('registerusers')->where('id', $user_id)->first();
                if (!empty($row)) {
                    $name = $row->username;
                    $email = !empty($row->email) ? $row->email : 'test@royal11.com';
                    $phone = !empty($row->mobile) ? $row->mobile : '9999999999';
                    $banid = Helpers::cf_genrate_banid($user_id);
                    $banid = preg_replace('/[^A-Za-z0-9_\-]/', '', $banid);

                    $bank_row = DB::table('bank')->where('userid', $user_id)->first();
                    /* Send Request For Add Baneficary */

                    $headers = array();
                    $headers[] = "Authorization: Bearer " . $token;
                    $headers[] = "Cache-Control: no-cache";
                    $headers[] = "Content-Type: text/plain";
                    $post_data = array(
                        "beneId" => str_replace(" ", "", $banid),
                        "name" => $name,
                        "email" => $email,
                        "phone" => $phone,
                        "bankAccount" => $bank_row->accno,
                        "ifsc" => $bank_row->ifsc,
                        "address1" => "india"
                    );
                    $post_data = json_encode($post_data);

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => CF_URL . "/payout/v1/addBeneficiary",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => $post_data,
                        CURLOPT_HTTPHEADER => $headers,
                    ));

                    $result = curl_exec($curl);

                    if (curl_errno($curl)) {
                        echo 'Error:' . curl_error($curl);
                    }
                    curl_close($curl);
                    $result = json_decode($result);
                    if (@$result->status == 'SUCCESS') {
                        DB::table('registerusers')->where('id', $user_id)->whereNull('banid')->update(array('banid' => $banid));
                        return true;
                    } else if ($result->status == 'ERROR' && $result->subCode == "409") {
                        $banid = Self::getBanIdOFUser($user_id, $token);
                        if ($banid) {
                            DB::table('registerusers')->where('id', $user_id)->update(array('banid' => $banid));
                            return true;
                        } else {
                            return $result->message;
                        }
                        // return true;
                    } else {
                        return $result->message;
                    }
                    /* Send Request For Add Baneficary */
                }
            }
        }
    }

    public static function getBanIdOFUser($user_id, $token)
    {
        $bank_row = DB::table('bank')->where('userid', $user_id)->first();
        $url = CF_URL . "/payout/v1/getBeneId?bankAccount=" . $bank_row->accno . "&ifsc=" . $bank_row->ifsc;

        $headers = array();
        $headers[] = "Authorization: Bearer " . $token;
        $headers[] = "Cache-Control: no-cache";

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => $headers,
        ));

        $result = curl_exec($curl);
        $result = json_decode($result);
        $result_data = @$result->data;
        // echo "<pre>"; print_r($result_data);die();
        if (@$result_data->beneId != "") {
            return $result_data->beneId;
        } else {
            return false;
        }
    }

    public static function cf_remove_benificary($user_id)
    {
        $token = Helpers::cf_get_token();
        if ($token) {
            if (Helpers::cf_verify_token($token)) {
                $row = DB::table('registerusers')->where('id', $user_id)->first();
                if (!empty($row)) {
                    $banid = $row->banid;

                    $bank_row = DB::table('bank')->where('userid', $user_id)->first();
                    /* Send Request For Add Baneficary */

                    $headers = array();
                    $headers[] = "Authorization: Bearer " . $token;
                    $headers[] = "Cache-Control: no-cache";
                    $headers[] = "Content-Type: text/plain";
                    $post_data = array(
                        "beneId" => $banid
                    );
                    $post_data = json_encode($post_data);

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => CF_URL . "/payout/v1/removeBeneficiary",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => $post_data,
                        CURLOPT_HTTPHEADER => $headers,
                    ));

                    $result = curl_exec($curl);

                    if (curl_errno($curl)) {
                        echo 'Error:' . curl_error($curl);
                    }
                    curl_close($curl);
                    $result = json_decode($result);

                    print_r($result);
                    die();
                    if (@$result->status == 'SUCCESS') {
                        DB::table('registerusers')->where('id', $user_id)->update(array('banid' => null, 'bank_verify' => 0));
                        DB::table('bank')->where('userid', $user_id)->update(array('status' => 0));
                        return true;
                    } else {
                        return $result->message;
                    }
                    /* Send Request For Add Baneficary */
                }
            }
        }
    }

    public static function cf_request_transfer($user_id, $amount, $order_id)
    {
        $row = DB::table('registerusers')->where('id', $user_id)->first();
        $return = (object)[];
        if (!empty($row)) {
            $banid = $row->banid;
            $token = Helpers::cf_get_token();
            if (Helpers::cf_verify_token($token)) {
                /* CURL post for request transfer */

                $headers = array();
                $headers[] = "Authorization: Bearer " . $token;
                $headers[] = "Cache-Control: no-cache";
                $headers[] = "Content-Type: application/x-www-form-urlencoded";
                $post_data = array(
                    "beneId" => $banid,
                    "amount" => number_format((float)$amount, 2, '.', ''),
                    "transferId" => $order_id
                );
                $post_data = json_encode($post_data);

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => CF_URL . "/payout/v1/requestTransfer",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => $post_data,
                    CURLOPT_HTTPHEADER => $headers,
                ));

                $result = curl_exec($curl);


                if (curl_errno($curl)) {
                    echo 'Error:' . curl_error($curl);
                }
                curl_close($curl);

                /* CURL post for request transfer */
                $result = json_decode(trim($result));
                // print_r($result); exit;
                if ((@$result->status == 'SUCCESS') && (@$result->subCode == "200")) {
                    $result_data = $result->data;
                    $ref_id = $result_data->referenceId;
                    $utr = $result_data->utr;
                    $withdrawal_insert_data = array(
                        "refrence_id" => $ref_id,
                        "utr_number" => $utr,
                        "transfer_id" => $order_id,
                        "banid" => $banid,
                        "amount" => number_format((float)$amount, 2, '.', ''),
                        "status" => 1
                    );
                    DB::table('transfer_request')->insert($withdrawal_insert_data);
                    // return true;
                    return $result;
                } else {
                    // return false;
                    return $result;
                }
            } else {
                // return false;
                $return->status = 'Token Failed';
                return $return;
            }
        } else {
            // return false;
            $return->status = 'User not found';
            return $return;
        }
    }

    public static function cf_request_paytm_transfer($user_id, $amount, $withdraw_id)
    {
        $return = (object)[];
        $row = DB::table('registerusers')->where('id', $user_id)->first();

        if (!empty($row)) {

            $banid = $row->paytm_benid;

            $token = Helpers::cf_get_token();

            if (Helpers::cf_verify_token($token)) {

                /* CURL post for request transfer */

                $headers = array();
                $headers[] = "Authorization: Bearer " . $token;
                $headers[] = "Cache-Control: no-cache";
                $headers[] = "Content-Type: application/x-www-form-urlencoded";
                $post_data = array(
                    "beneId" => $banid,
                    "amount" => number_format((float)$amount, 2, '.', ''),
                    "transferId" => $withdraw_id,
                    "transferMode" => "paytm"
                );
                $post_data = json_encode($post_data);

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => CF_URL . "/payout/v1/requestTransfer",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => $post_data,
                    CURLOPT_HTTPHEADER => $headers,
                ));

                $result = curl_exec($curl);


                if (curl_errno($curl)) {
                    echo 'Error:' . curl_error($curl);
                }
                curl_close($curl);

                /* CURL post for request transfer */

                $result = json_decode($result); //print_r($result); exit;

                if ((@$result->status == 'SUCCESS') && (@$result->subCode == "200")) {

                    $result_data = $result->data;

                    $ref_id = $result_data->referenceId;

                    $utr = $result_data->utr;

                    $withdrawal_insert_data = array(

                        "refrence_id" => $ref_id,

                        "utr_number" => $utr,

                        "transfer_id" => $post_data['transferId'],

                        "banid" => $post_data['beneId'],

                        "amount" => $post_data['amount'],

                        "status" => 1

                    );

                    DB::table('transfer_request')->insert($withdrawal_insert_data);
                    return $result;
                    // return true;

                } else {
                    return $result;
                    // return false;
                }
            } else {

                // return false;
                $return->status = 'Token Failed';
                return $return;
            }
        } else {
            $return->status = 'User not found';
            return $return;
            // return false;

        }
    }

    public static function paytm_request_transfer($user_id, $amount)
    {
        $uid = $user_id;
        $amount = $amount;

        $settings = DB::table('registerusers')->where('id', $uid)->first();

        $txnid = '11CAPS-' . rand(1000000, 99999);
        $getvalues['txnid'] = $txnid;
        $getvalues['amount'] = $amount;
        $getvalues['userid'] = $settings->id;
        $getvalues['username'] = $settings->username;
        $getvalues['email'] = $settings->email;
        $getvalues['phone'] = $settings->mobile;
        require_once("./PaytmGraftification/lib/config_paytm.php");
        require_once("./PaytmGraftification/lib/encdec_paytm.php");
        $data = array(
            "request" => array(
                "requestType" => null,
                "merchantGuid" => "9717d2c7-bd03-48cb-9f68-3cb22ae1a8c2",  //87ddb260-56b2-4da2-8c4e-af2291f2d3a9
                "merchantOrderId" => $txnid,
                "salesWalletName" => "FW11",   //null
                "salesWalletGuid" => "31c507aa-8cbc-47d6-a3a8-2c9e8522eccb",   //988f3600-3d64-11e8-bf28-52540059b2ee
                "payeeEmailId" => null,
                "payeePhoneNumber" => $settings->mobile,   //9999999999
                "payeeSsoId" => "",
                "appliedToNewUsers" => "Y",
                "amount" => $amount,
                "currencyCode" => "INR"
            ),
            "metadata" => "Testing Data",
            "ipAddress" => "127.0.0.1",
            "platformName" => "PayTM",
            "operationType" => "SALES_TO_USER_CREDIT"
        );
        $requestData = json_encode($data);
        $Checksumhash = getChecksumFromString($requestData, "vg&rCnGWXzKyIEWQ");
        $headerValue = array('Content-Type:application/json', 'mid:' . '9717d2c7-bd03-48cb-9f68-3cb22ae1a8c2', 'checksumhash:' . $Checksumhash);
        $ch = curl_init(PAYTM_GRATIFICATION_URL);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $requestData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // return the output in string format
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerValue);
        $info = curl_getinfo($ch);
        $result = curl_exec($ch);
        $getfinalresult = json_decode($result);
        // echo '<pre>'; print_r($result); die;
        if ($getfinalresult->status == 'SUCCESS') {
            return true;
        } else {
            return false;
        }
    }

    public static function cf_genrate_paytm_banid($user_id)
    {

        $row = DB::table('registerusers')->where('id', $user_id)->first();

        $name = $row->username;

        return mb_substr(str_replace(' ', '', $name), 0, 3) . 'paytm' . $user_id . rand(101, 999);
    }



    public static function add_paytm_beneficary($user_id)
    {

        $token = Helpers::cf_get_token();

        if ($token) {

            if (Helpers::cf_verify_token($token)) {

                $row = DB::table('registerusers')->where('id', $user_id)->first();



                if (!empty($row)) {

                    $name = $row->username;

                    $email = $row->email;

                    $phone = $row->mobile;

                    // echo $phone; exit;
                    $banid = Helpers::cf_genrate_paytm_banid($user_id);

                    /* Send Request For Add Baneficary */

                    $post_data = array(

                        "beneId" => $banid,

                        "name" => $name,

                        "email" => $email,

                        "phone" => $phone,

                        //"bankAccount" => $data['account_number'],

                        //"ifsc" => $data['ifsc_code'],

                        "address1" => "india"

                    );

                    $post_data = json_encode($post_data);

                    $ch = curl_init();



                    curl_setopt($ch, CURLOPT_URL, CF_URL . "/payout/v1/addBeneficiary");

                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

                    curl_setopt($ch, CURLOPT_POST, 1);



                    $headers = array();

                    $headers[] = "Authorization: Bearer " . $token;

                    $headers[] = "Cache-Control: no-cache";

                    $headers[] = "Content-Type: text/plain";



                    curl_setopt($ch, CURLOPT_POSTFIELDS,     $post_data);

                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



                    $result = curl_exec($ch);

                    if (curl_errno($ch)) {

                        echo 'Error:' . curl_error($ch);
                    }

                    curl_close($ch);

                    $result = json_decode($result); //print_r($result); exit;

                    if ($result->status == 'SUCCESS') {

                        /*$update_data = array(

                    		"paytm_benid" => $banid,

                    		"paytm_mobile" => $paytm_number

                    	);*/

                        /*$user->fill([

        				'password' => Hash::make($request->newpassword)

      					])->save();*/

                        $user =  DB::table('registerusers')->where('id', $user_id)->update([

                            'paytm_benid' => $banid,

                            // 'paytm_mobile' => $paytm_number

                        ]);

                        // $user->fill()->save();



                        return true;
                    } else {

                        return false;
                    }

                    /* Send Request For Add Baneficary */
                }
            }
        }
    }

    public static function url_exists($url)
    {
        $headers = get_headers($url);
        return stripos($headers[0], "200 OK") ? true : false;
    }

    public static function check_request($userid, $request)
    {
        if (isset($request['HTTP_X_AUTH_TOKEN'])) {
            $token = $request['HTTP_X_AUTH_TOKEN'];
            $find_user = DB::table('registerusers')->where('token', $token)->where('id', $userid)->first();
            if (empty($find_user)) {
                // 			$msgg['status'] = 0;
                // $msgg['msg'] = "Invalid Request Please login again";
                // 			echo json_encode($msgg); exit;
            }
        } else {
            //  		$msgg['status'] = 0;
            // $msgg['msg'] = "Invalid Request Please login again";
            //  		echo json_encode($msgg); exit;
        }
    }

    public static function first_time_bonus($userid, $amount)
    {
        $find_trans = DB::table('transactions')->where('type', 'Add Fund')->where('paymentstatus', 'confirmed')->where('userid', $userid)->first();
        if (!empty($trans)) {
            return false;
        } else {
            $bonus_amount = 0;
            $perks = 0;
            if ($amount > 99 && $amount < 1000) {
                $bonus_amount = $amount * 10 / 100;
                $perks = $amount;
            }
            if ($amount > 999 && $amount < 2501) {
                $bonus_amount = $amount * 15 / 100;
                $perks = $amount * 1.5;
            }
            if ($amount > 2500 && $amount < 5001) {
                $bonus_amount = $amount * 30 / 100;
                $perks = $amount * 2;
            }
            if ($amount > 5000) {
                $bonus_amount = $amount * 35 / 100;
                $perks = $amount * 2;
            }
            $bonusAmount =     $bonus_amount;
            if ($bonusAmount != 0) {
                // find balance details //
                $finduser_bal = DB::table('userbalances')->where('user_id', $userid)->first();
                if (!empty($finduser_bal)) {
                    $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                    $new_bal_fund_amt = $finduser_bal->balance;
                    $new_bal_win_amt = $finduser_bal->winning;
                    $new_bal_bonus_amt = $finduser_bal->bonus;
                    $datainseert2['user_id'] = $userid;
                    // $datainseert2['refer_id']= $referid;
                    // $datainseert['balance'] = $userBalance->balance+$amount;
                    $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                    $datainseert2['perks'] = $finduser_bal->pekrs + $perks;
                    //if($getdata['paymentby']=='cashfree') {
                    DB::table('userbalances')->where('user_id', $userid)->update($datainseert2);
                    //}
                    $ntxnid = 'SMASHERSBONUS-' . time();
                    $newtransactionsdata['userid'] = $userid;
                    $newtransactionsdata['type'] = 'Bonus add during add fund';
                    $newtransactionsdata['transaction_id'] = '';
                    $newtransactionsdata['transaction_by'] = '';
                    $newtransactionsdata['amount'] = $bonusAmount;
                    $newtransactionsdata['bonus_amt'] = $bonusAmount;
                    $newtransactionsdata['paymentstatus'] = 'confirmed';
                    $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                    $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                    $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                    $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                    DB::table('transactions')->insert($newtransactionsdata);

                    $notificationdata['userid'] = $userid;
                    $notificationdata['title'] = 'Bonus of Rs ' . $bonusAmount . ' Added to your account';
                    DB::table('notifications')->insert($notificationdata);
                    //push notifications//
                    $titleget = 'Bonus Credited';
                    Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
                    //end push notifications//

                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static function aws_upload_image($path_to_file, $upload_path, $file_name)
    {
        // print_r($path_to_file);die;
        // require_once(APP . 'Vendor' . DS . 'autoload.php');

        try {

            //Create a S3Client

            //print_r($upload_path);die;

            $s3 = new S3Client([

                'version' => 'latest',

                'region'  => env('REGION'),

                'endpoint' => env('ENDPOINT'),

                'credentials' => [

                    'key'    => env('S3_KEY'),

                    'secret' => env('S3_SECRET'),

                ],

            ]);

            $result = $s3->putObject([

                'Bucket' => env('S3_NAME'),

                'Key' => $upload_path . $file_name,

                'SourceFile' => $path_to_file,

                'Body' => $path_to_file,

                'ACL'          => 'public-read'

                //'x-amz-acl' => 'public-read'

            ]);

            // print_r($result); exit;

            return $file_name;
        } catch (S3Exception $e) {

            return false;

            echo $e->getMessage() . "\n";
        }
    }

    public static function imageUploadNew($path, $file, $mode)
    {
        if ($mode = 'dev') {
            if ($file || $file != '0') {
                $folderPath = $path;
                $image_parts = explode(";base64,", $file);
                $image_type_aux = explode("image/", $image_parts[0]);
                $image_type = $image_type_aux[1];
                $image_base64 = base64_decode($image_parts[1]);
                $filename = env("APP_NAME") . '-player-' . time() . '.' . $image_type;
                $file = $folderPath . $filename;
                file_put_contents($file, $image_base64);
                return $filename;
            }
        } else {
            if ($file || $file != '0') {
                $folderPath = $path;
                $image_parts = explode(";base64,", $input['base64image']);
                $image_type_aux = explode("image/", $image_parts[0]);
                $image_type = $image_type_aux[1];
                $image_base64 = base64_decode($image_parts[1]);
                $filename = env("APP_NAME") . '-player-' . $image_type;
                $file = $folderPath . $filename;
                file_put_contents($file, $image_base64);
                Helpers::aws_upload_image($folderPath . $filename, $path, $filename);
                return $filename;
            }
        }
    }

    public static function sendnotificationAll($title, $message, $include_image, $regId = '')
    {

        $firebase = new Firebase($title, $message);
        $firebase->send();
    }



    public static function sendnotificationAllLineUp($title, $message)
    {
        $firebaseToken1 = DB::table('androidappid')
            ->whereIn('userid', [1028])
            ->whereNotNull('appkey')
            ->where('appkey', '!=', '')
            //->groupBy('userid')
            ->orderBy('id', 'DESC')
            ->pluck('appkey')
            ->all();


        // $firebaseToken = [];
        //dd($firebaseToken1);
        if (isset($firebaseToken1) && count($firebaseToken1) > 0) {

            foreach ($firebaseToken1 as $key => $value) {
                $firebaseToken[] = $value;

                //  dd($firebaseToken);
                //$firebaseToken=  array('fI-s2eVnR_2h_UhPQ_1Wlh:APA91bFB_ZItiHD3QWRDpoNHmdOQ-nl_J9buDY4jfQZGPXx27-dsPY914OQn5Jy0NohX0hpyoOsU1162o5_EvHlqPxXdX7m9EAqXQaLY-LI8n0NpfafByWZlPcg3_4I3pNlSZQsauJFJ');
                // $SERVER_API_KEY = "AAAA8AJXsMY:APA91bHj1r-H1L-JnSHeln1jdzeXErJC3WVTFTfEC03WDU1-Lj4M_9phrnG7qxsWHVxhwqiNQguq5YAe_KljkE0F9QlCjbEn9rtYbCkbol-mv6fBVoaBxHm-7p4nsT8p1L9JqBfh7CIO";
                $SERVER_API_KEY = '';
                $data = [
                    "registration_ids" => $firebaseToken,
                    "notification" => [
                        "title" => $title,
                        "body"  => $message,
                        // "image" => $include_image,
                        //"image" => "https://jeugoo.com/assets/img/hero-img-2_bkp.png",

                    ]
                ];

                $dataString = json_encode($data);
                //dd($dataString);

                $headers = [
                    'Authorization: key=' . $SERVER_API_KEY,
                    'Content-Type: application/json',
                ];

                $ch = curl_init();

                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

                $response = curl_exec($ch);
                // echo '<pre>'; print_r($response);//exit;
            }
            // dd($response);
        }
    }


    public static function sendnotificationAllTest($title, $message, $include_image, $regId = '')
    {
        $firebaseToken = DB::table('androidappid')
            ->whereIn('userid', [16])
            ->whereNotNull('appkey')
            //->groupBy('userid')
            ->orderBy('id', 'desc')
            ->limit(1)
            ->pluck('appkey')->all();
        $firebaseToken1 = DB::table('androidappid')
            // ->whereIn('userid',[22289])
            ->whereNotNull('appkey')
            ->where('appkey', '!=', '')
            ->orderBy('id', 'DESC')
            ->pluck('appkey')
            ->all();


        // $firebaseToken = [];
        // dd($firebaseToken);
        // if(isset($firebaseToken) && count($firebaseToken) > 0){
        //
        // foreach ($firebaseToken as $key => $value) {
        // $firebaseTokenarray[] = $value;
        //  dd($firebaseToken);
        //$firebaseToken=  array('fI-s2eVnR_2h_UhPQ_1Wlh:APA91bFB_ZItiHD3QWRDpoNHmdOQ-nl_J9buDY4jfQZGPXx27-dsPY914OQn5Jy0NohX0hpyoOsU1162o5_EvHlqPxXdX7m9EAqXQaLY-LI8n0NpfafByWZlPcg3_4I3pNlSZQsauJFJ');
        // $SERVER_API_KEY = "AAAA8AJXsMY:APA91bHj1r-H1L-JnSHeln1jdzeXErJC3WVTFTfEC03WDU1-Lj4M_9phrnG7qxsWHVxhwqiNQguq5YAe_KljkE0F9QlCjbEn9rtYbCkbol-mv6fBVoaBxHm-7p4nsT8p1L9JqBfh7CIO";
        $SERVER_API_KEY = "";
        $data = [
            "registration_ids" => $firebaseToken,
            "notification" => [
                "title" => $title,
                "body"  => $message,
                // "image" => $include_image,
                //"image" => "https://jeugoo.com/assets/img/hero-img-2_bkp.png",

            ]
        ];
        $dataString = json_encode($data);

        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        $response = curl_exec($ch);
        echo '<pre>';
        print_r($response);
        exit;
        // }
        // dd($response);
        // }
    }
    public static function sendnotificationWinning($title, $message, $regId = '')
    {
        $firebaseToken = DB::table('registerusers')
            ->where('id', $regId)
            ->orderBy('id', 'desc')
            ->pluck('fcmToken')->all();

        //$firebaseToken=  array('fI-s2eVnR_2h_UhPQ_1Wlh:APA91bFB_ZItiHD3QWRDpoNHmdOQ-nl_J9buDY4jfQZGPXx27-dsPY914OQn5Jy0NohX0hpyoOsU1162o5_EvHlqPxXdX7m9EAqXQaLY-LI8n0NpfafByWZlPcg3_4I3pNlSZQsauJFJ');
        //  $SERVER_API_KEY = "AAAA8AJXsMY:APA91bHj1r-H1L-JnSHeln1jdzeXErJC3WVTFTfEC03WDU1-Lj4M_9phrnG7qxsWHVxhwqiNQguq5YAe_KljkE0F9QlCjbEn9rtYbCkbol-mv6fBVoaBxHm-7p4nsT8p1L9JqBfh7CIO";
        $SERVER_API_KEY = "";
        $data = [
            "registration_ids" => $firebaseToken,
            "notification" => [
                "title" => $title,
                "body"  => $message,
            ],
            "data" => [
                "title" => $title,
                "body"  => $message,
            ],
        ];
        $dataString = json_encode($data);

        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        $response = curl_exec($ch);
        //echo '<pre>'; print_r($response);exit;
    }

    /**
     * Upload image from storage disk
     * @param mixed $path
     * @param mixed $image
     * @param mixed $disk
     * @param mixed $private
     */
    public static function uploadImage($path, $image, $disk, $private = 'public')
    {
        try {
            if ($image instanceof UploadedFile) {
                $fileName = self::uniqueFilename($image->getClientOriginalName());
                $status = Storage::disk($disk)->putFileAs($path, $image, $fileName, $private);
                return $status;
            } else {
                throw new \Exception('Invalid file format.');
            }
        } catch (\Exception $e) {
            Log::debug($e->getMessage());
            return '';
        }
    }


    /**
     * Generate a unique filename for the uploaded file.
     *
     * @param string|UploadedFile $file The path to the image file or an instance of UploadedFile.
     * @return string The unique filename.
     */
    private static function uniqueFilename($file): string
    {
        $extension = ($file instanceof UploadedFile) ? $file->getClientOriginalExtension() : pathinfo($file, PATHINFO_EXTENSION);
        return Str::random(20) . ".$extension";
    }

    /**
     * Get image url
     * @param mixed $path
     * @param mixed $disk
     */
    public static function getImage($path, $disk)
    {
        try {
            $path =  Storage::disk($disk)->url($path);
            return $path;
        } catch (\Exception $th) {
            throw $th;
        }
    }

    public static function validateCustomEmail($email) {
  $email = trim($email);
  if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    return false;
  }
  list($localPart, $domain) = explode('@', $email);

  if (is_numeric($localPart)) {
    return false;
  }
  if (preg_match('/\d/', $domain)) {
    return false;
  }

  // Invalid domains list (common typos and invalid formats)
  $invalidDomains = [
    'gmai.com', 'yaho.com', 'outlok.com', 'gmail.coma', 'gamil.com',
    'g-mail.com', 'g-maill.com', 'gamal.com', 'gamil.co', 'gamil.con',
    'gamil.com', 'gamil.come', 'gamail.com', 'gamail.co', 'gamale.com',
    'gamall.com', 'gamill.com', 'gamli.com', 'gamil.cim', 'gamil.come',
    'gimal.co', 'gimail.co', 'gimail.com', 'gimel.co', 'gimel.com',
    'gimll.com', 'giml.com', 'gmai.com', 'gmaial.com', 'gmaik.com',
    'gmaile.com', 'gmial.cam', 'gmial.co', 'gmial.com', 'gmil.com',
    'gmil.coma', 'gmmail.com', 'gmmil.com', 'gmqil.com',
    'gmsil.com', 'gnail.com', 'gnail.co', 'gmal.co', 'gmalil.com',
    'gamil.cim', 'gimall.cim', 'gmail.cam', 'gmaill.com', 'gmaiil.com',
    'gmail.coma', 'gmail.comb', 'gmail.comc', 'gmail.comd', 'gmail.comi',
    'gmail.comj', 'gmail.comk', 'gmail.coml', 'gmail.comm', 'gmail.comn',
    'gmail.como', 'gmail.comp', 'gmail.comq', 'gmail.comr', 'gmail.coms',
    'gmail.comt', 'gmail.comu', 'gmail.comv', 'gmail.comw', 'gmail.comx',
    'gmail.comy', 'gmail.comz', 'gmail.con', 'gmaile.com', 'gmal.co',
    'gmaile.com', 'gmaiil.com', 'gmaii.com', 'gmj.com', 'gmkl.com',
    'gmkr.com', 'gnail.com', 'gnail.co', 'gmalil.com', 'gmazil.com',
    'gemel.com', 'gmi.com', 'gmai.cim', 'gmail.comdas', 'gmail.com_old',
    'gmaail.com', 'gmail.comr', 'gmail.chinsingh', 'gmail.coms',
    'gmile.c', 'gmail.comments', 'gmail.kom', 'gmail.comsa',
    'gamil.coms', 'gmail.comgg', 'gmail.xom','gmiel.com',
    'gmail.comcp', 'gmail.comdas', 'gmail.com__old', 'gaml.com',
    'gmail.comhi', 'gmail.ccom', 'email.com', 'gmail.co', 'mail.com', 'gmell.com', 'gemil.com', 'gemail.com'
  ];

  if (in_array(strtolower($domain), $invalidDomains)) {
    return false;
  }

  // Ensure domain has at least one dot
  if (substr_count($domain, '.') < 1) {
    return false;
  }
  if (!checkdnsrr($domain, 'MX') && !checkdnsrr($domain, 'A')) {
    return false;
  }
  // Blacklist certain domains
  $blacklistedDomains = ['tempmail.com', '10minutemail.com'];  // Add more if needed
  if (in_array(strtolower($domain), $blacklistedDomains)) {
    return false;
  }
  return true;
}
}
