<?php

namespace App\Http\Controllers\Admin;

use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Models\Advertisments;
use App\Helpers\Helpers;
use App\libraries\CustomHelper;
use App\Services\Input;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class AdvertsimentsController extends BaseController
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Advertisments';


    public function __construct()
    {
        View::share('modelName', $this->model);
    }

    function viewAdvertisments()
    {
        if (request()->isMethod("POST")) {
            return DataTables::of(DB::table('advertisments')->get())
                ->addIndexColumn()
                ->addColumn('title', function ($result) {
                    return    ucwords($result->title);
                })
                ->addColumn('image', function ($result) {
                    return    '<div>
                            <img src="' . $result->image . '" style="width:50px;height:50px;">
                        </div>';
                })
                ->addColumn('action', function ($result) {
                    return '<a href="' . route($this->model . '.edit', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn btn-dark mr-2" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>'
                        . '<a href="' . route($this->model . '.delete', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn btn-danger action-advertisments"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>';
                })
                //->rawColumns(['action'])
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.alladvertsiment");
    }

    function addAdvertisment(Request $request)
    {
        $formData = Input::all();
        if (request()->isMethod("POST")) {
            // dd($formData);
            $message   = array(
                'image.max'                        =>    MAX_IMAGE_SIZE,
            );
            $validate  = array(
                'title'                =>    'required',
                'image'                =>    'required',
                'type'                =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {

                $obj = new Advertisments;


                if (!empty($formData['image'])) {
                    if (request()->hasFile('image')) {
                        $folderPath  = 'uploads/banners/';
                        $image = request()->file('image'); // Get the uploaded file
                        $extension = $image->getClientOriginalExtension();

                        $img_ext = explode(",", IMAGE_EXTENSION);
                        if (in_array($extension, $img_ext)) {
                            // Ensure the directory exists
                            if (!file_exists(public_path($folderPath))) {
                                mkdir(public_path($folderPath), 0777, true);
                            }

                            // Generate a unique file name
                            $fileName = env("APP_NAME") . '-banners-' . rand(100000, 999999) . "." . $extension;
                            $filePath = $folderPath . $fileName;

                            // Move the uploaded file to the directory
                            $image->move(public_path($folderPath), $fileName);

                            // Upload to AWS (if needed)
                            $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
                            $obj->image = env('CDN_URL') . 'uploads/banners/' . $uploadedFileName;

                            // Delete local file after uploading to AWS
                            @unlink(public_path($filePath));

                        } else {
                            Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                            return Redirect::back()->withInput();
                        }
                    }
                }


                $obj->title = $formData['title'];
                $obj->url = $formData['url'];
                $obj->type = $formData['type'];
                $obj->offer_code = @$formData['offer_code'] ? $formData['offer_code'] : '';
                // dd($formData['image']);
                //Insert
                // dd($obj);
                $obj->save();
                // Session::flash('message', 'Successfully Add Advertisment!');
                // Session::flash('alert-class', 'alert-success');
                Session::flash('flash_notice',  trans("Successfully Add Advertisment!"));
                Helpers::logActivity('Successfully Add Advertisment!', $formData['title']);
                return Redirect::route('Advertisments.view');
                //Session::flash('flash_notice',  trans("Successfully Add Advertisment!"));
                //return Redirect::back();
                //redirect()->route('Advertisments.view');
            }
        }
        return view("admin.$this->model.addAdvertisments");
    }

    //Edit
    function editAdvertisment_old($id)
    {
        //Get Id
        $id = unserialize(base64_decode($id));
        $formData    =    Input::all();
        $Advertisments = DB::table('advertisments')->where('id', $id)->first();
        if (request()->isMethod("POST")) {
            $message    =    array(
                'image.max'    =>    MAX_IMAGE_SIZE,
            );

            $validator = Validator::make(Input::all(), $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $obj = Advertisments::findOrFail($id);
                if (!empty($formData['image'])) {
                    if (request()->hasFile('image')) {
                        $folderPath  = 'uploads/banners/';
                        $image = request()->file('image'); // Get the uploaded file
                        $extension = $image->getClientOriginalExtension();

                        $img_ext = explode(",", IMAGE_EXTENSION);
                        if (in_array($extension, $img_ext)) {
                            // Ensure the directory exists
                            if (!file_exists(public_path($folderPath))) {
                                mkdir(public_path($folderPath), 0777, true);
                            }

                            // Generate a unique file name
                            $fileName = env("APP_NAME") . '-banners-' . rand(100000, 999999) . "." . $extension;
                            $filePath = $folderPath . $fileName;

                            // Move the uploaded file to the directory
                            $image->move(public_path($folderPath), $fileName);

                            // Upload to AWS (if needed)
                            $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
                            $obj->image = env('CDN_URL') . 'uploads/banners/' . $uploadedFileName;

                            // Delete local file after uploading to AWS
                            @unlink(public_path($filePath));

                        } else {
                            Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                            return Redirect::back()->withInput();
                        }
                    }
                }
                $obj->title = $formData['title'];
                $obj->url = $formData['url'];
                $obj->type = $formData['type'];
                $obj->sort = $formData['sort'];
                $obj->offer_code = @$formData['offer_code'] ? $formData['offer_code'] : '';
                //Update
                $obj->save();
                // Session::flash('message', 'Successfully Update Advertisment!');
                // Session::flash('alert-class', 'alert-success');
                Session::flash('flash_notice',  trans("Successfully Update Advertisment!"));
                Helpers::logActivity('Successfully Update Advertisment!', $formData['title']);
                return Redirect::route('Advertisments.view');
            }
        }
        return view("admin.$this->model.editAdvertisments", compact('Advertisments'));
    }

    function editAdvertisment(Request $request, $id)
    {
        //Get Id
        $id = unserialize(base64_decode($id));
        $formData    =    Input::all();
        $Advertisments = DB::table('advertisments')->where('id', $id)->first();

        if (request()->isMethod("POST")) {
            $message    =    array(
                'image.max'    =>    MAX_IMAGE_SIZE,
            );

            $validator = Validator::make(Input::all(), $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $obj = Advertisments::findOrFail($id);



                if (!empty($formData['image'])) {
                    if (request()->hasFile('image')) {
                        $folderPath  = 'uploads/banners/';
                        $image = request()->file('image'); // Get the uploaded file
                        $extension = $image->getClientOriginalExtension();

                        $img_ext = explode(",", IMAGE_EXTENSION);
                        if (in_array($extension, $img_ext)) {
                            // Ensure the directory exists
                            if (!file_exists(public_path($folderPath))) {
                                mkdir(public_path($folderPath), 0777, true);
                            }

                            // Generate a unique file name
                            $fileName = env("APP_NAME") . '-banners-' . rand(100000, 999999) . "." . $extension;
                            $filePath = $folderPath . $fileName;

                            // Move the uploaded file to the directory
                            $image->move(public_path($folderPath), $fileName);

                            // Upload to AWS (if needed)
                            $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
                            $obj->image = env('CDN_URL') . 'uploads/banners/' . $uploadedFileName;

                            // Delete local file after uploading to AWS
                            @unlink(public_path($filePath));

                        } else {
                            Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                            return Redirect::back()->withInput();
                        }
                    }
                }


                $input    =    $request->all();

                $obj->title = $formData['title'];
                $obj->url = $formData['url'];
                $obj->type = $formData['type'];
                $obj->sort = $formData['sort'];
                $obj->offer_code = @$formData['offer_code'] ? $formData['offer_code'] : '';
                //Update
                $obj->save();
                Session::flash('flash_notice',  trans("Successfully Update Advertisment!"));
                Helpers::logActivity('Successfully Update Advertisment!', $formData['title']);
                return Redirect::route('Advertisments.view');
            }
        }
        return view("admin.$this->model.editAdvertisments", compact('Advertisments'));
    }


    //Delete
    function deleteAdvertisment($id)
    {
        $id = unserialize(base64_decode($id));
        $data = DB::table('advertisments')->where('id', $id)->first();
        $destinationPath = ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH;
        File::delete($destinationPath . '/' . $data->image);
        DB::table('advertisments')->where('id', $id)->delete();
        return Redirect::route('Advertisments.view');
    }


    /* ----------------Bonus----------------------*/

    function bonuslist()
    {
        $formData    =    Input::all();
        //Ajax Load
        if (isset($formData) && request()->isMethod("POST")) {
            return Datatables::of(DB::table('bonus_amount')->get())
                ->addIndexColumn()
                ->addColumn('bonus_type', function ($result) {
                    if ($result->bonus_type == 'amount') {
                        return ucwords('₹ ' . $result->price);
                    } else {
                        return ucwords($result->price . ' %');
                    }
                })
                ->addColumn('action', function ($result) {
                    return '<a href="' . route($this->model . '.editBonus', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn btn-dark" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>
									<a href="' . route($this->model . '.deleteBonus', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn btn-danger" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Delete</a>';
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.bonuslist");
    }
    function addBonus(Request $request)
    {
      // echo "string";die;

        $formData    =    Input::all();
        if (request()->isMethod("POST")) {
            $validate    =    array(
                'type'            =>    'required',
                'price'            =>    'required|numeric',
                'bonus_type'    =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);
                $input['type'] = $formData['type'];
                $input['price'] = $formData['price'];
                $input['bonus_type'] = $formData['bonus_type'];
                DB::table('bonus_amount')->insert($input);
                Session::flash('flash_notice',  trans("Successfully Added Bonus!"));
                return Redirect::route('Advertisments.bonuslist');
            }
        }

        return view("admin.$this->model.add_bonus");
    }

    //Edit Bonus
    function editBonus($id, Request $request)
    {
        $id = unserialize(base64_decode($id));
        $formData    =    Input::all();
        if (request()->isMethod("POST")) {
            $validate    =    array(
                'type'            =>    'required',
                'price'            =>    'required|numeric',
                'bonus_type'    =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);
                $input['type'] = $formData['type'];
                $input['price'] = $formData['price'];
                $input['bonus_type'] = $formData['bonus_type'];
                DB::table('bonus_amount')->where('id', $id)->update($input);
                Session::flash('flash_notice',  trans("Successfully Update Bonus!"));
                return Redirect::route('Advertisments.bonuslist');
            }
        }
        $data = DB::table('bonus_amount')->where('id', $id)->first();
        return view("admin.$this->model.editbonus", compact('data'));
    }

    public function deleteBonus($id)
    {
        $id = unserialize(base64_decode($id));
        DB::table('bonus_amount')->where('id', $id)->delete();
        Session::flash('flash_notice',  trans("Successfully Deleted Bonus!"));
        return Redirect::route('Advertisments.bonuslist');
    }

    /* ----------------End Bonus-------------------------*/

    /*-----------------------Offers----------------------*/

    function viewOffers()
    {
        $formData = Input::all();
        if (isset($formData) && request()->isMethod("POST")) {
            return Datatables::of(DB::table('offers'))
                ->addIndexColumn()
                ->addColumn('minamount', function ($result) {
                    return ucwords($result->minamount);
                })
                ->addColumn('maxamount', function ($result) {
                    return ucwords($result->maxamount);
                })
                ->addColumn('bonus_type', function ($result) {
                    return ucwords($result->bonus_type);
                })
                ->addColumn('bonus', function ($result) {
                    return ucwords($result->bonus);
                })
                ->addColumn('code', function ($result) {
                    return ucwords($result->code);
                })
                ->addColumn('description', function ($result) {
                    return ucwords($result->description);
                })
                ->addColumn('expire_date', function ($result) {
                    return ucwords($result->expire_date);
                })
                ->addColumn('btype', function ($result) {
                    return ucwords($result->btype);
                })
                ->addColumn('is_for_all', function ($result) {
                    return ($result->is_for_all) ? "Yes" : "For CSV Users";
                })
                ->addColumn('per_user_count', function ($result) {
                    return ucwords($result->per_user_count);
                })
                ->addColumn('action', function ($result) {
                    $upoad_user_csv = "";
                    if ($result->is_for_all != 1) {
                        $upoad_user_csv = '<a href="' . route($this->model . '.upload_offer_csv', base64_encode(serialize($result->id))) . '" class="btn btn-primary" title="Upload CSV"><i class="fa fa-upload" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Upload CSV" ></i></a><br><br>';
                    }
                    return '<a href="' . route($this->model . '.editOffers', base64_encode(serialize($result->id))) . '" class="btn btn-dark"  title="Edit"><i class="fa fa-pencil" data-toggle="tooltip" aria-hidden="true" data-original-title="Edit"></i></a><br><br>'
                        . $upoad_user_csv
                        . '<a href="' . route($this->model . '.deleteoffers', base64_encode(serialize($result->id))) . '" class="btn btn-danger confirm_delete" title="Delete"><i class="fa fa-trash" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Delete" ></i></a><br><br>';
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view('admin.Advertisments.viewoffers');
    }


    public function upload_offer_csv($id, Request $request)
    {
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $request->validate([
                'offer_csv_users' => 'required|mimes:csv,txt',
                'offer_id' => 'required',
            ]);
            $delete_previous_csv = $request->delete_previous_csv ?? 0;
            $offer_id = $request->offer_id;
            $file = $request->file('offer_csv_users');
            $csvFile = fopen($file->getRealPath(), 'r');
            $headers = fgetcsv($csvFile);
            $rows = array_map('str_getcsv', file($file->getRealPath()));
            fclose($csvFile);
            array_shift($rows); //remove first row
            // Combine headers with the respective rows
            $data = array_map(function ($row) use ($offer_id) {
                $mobile = trim($row[0]);
                $comment = '';
                $find_user = DB::table('registerusers')
                    ->where('mobile', $mobile)
                    ->first();
                if (!empty($find_user)) {
                    $user_id = $find_user->id;
                } else {
                    $comment = "User not found";
                    $user_id = 0;
                }
                $new_row = array();
                $new_row['offer_id'] = $offer_id;
                $new_row['user_id'] = $user_id;
                $new_row['mobile'] = $mobile;
                $new_row['comment'] = $comment;
                return $new_row;
            }, $rows);
            // save all csv rows
            if ($delete_previous_csv == 1) {
                DB::table('offer_csv_users')->where('offer_id', $offer_id)->delete();
            }
            DB::table('offer_csv_users')->insert($data);
            Session::flash('flash_notice', 'CSV uploaded successfully!');
            Session::flash('alert-class', 'alert-success');
            Helpers::logActivity('Offer Users CSV uploaded successfully!', $offer_id);
            return Redirect::back();
        }
        //echo 'hi';die;
        $totaluser = "";
        $offer = DB::table('offers')->where('id', $id)->first();
        return view("admin.$this->model.upload_offer_csv", compact('totaluser', 'offer', 'id'));
    }

    public function get_upload_offer_csv(Request $req)
    {
        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (empty($formData['start_date'])) {
                $formData['start_date'] = date('Y-m-d H:i:s');
            }
            if (empty($formData['end_date'])) {
                $formData['end_date'] = date('Y-m-d H:i:s');
            }

            if (isset($formData) && request()->isMethod("POST")) {
                return Datatables::of(
                    DB::table('offer_csv_users')
                        ->leftJoin('registerusers', 'registerusers.id', '=', 'offer_csv_users.user_id')
                        ->select('offer_csv_users.*', 'registerusers.username', 'registerusers.team')
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['offer_id'])) {
                                $query->where('offer_id', $formData['offer_id']);
                            }
                        })
                        ->orderBy('id', 'DESC')->get()
                )
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->make(true);
            }
        }
    }


    function addOffers(Request $request)
    {
        $formData    =    Input::all();

        if (request()->isMethod("POST")) {
            $validate    =    array(
                'minamount'        =>    'required|numeric',
                'maxamount'        =>    'required|numeric',
                'per_user_count'        =>    'required|numeric',
                'bonus'            =>    'required',
                'bonus_type'    =>    'required',
                'btype'    =>    'required',
                'code'            =>    'required',
                'expire_date'    =>    'required',
                'description'    =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
              dd($formData);
                unset($formData['_token']);
                if ($formData['minamount'] < $formData['maxamount']) {
                    $input['minamount'] = $formData['minamount'];
                    $input['maxamount'] = $formData['maxamount'];
                } else {
                    return back()->with('success', 'Maximum value less than minimum value');
                }
                if ($formData['bonus'] < $formData['maxamount']) {
                    $input['bonus'] = $formData['bonus'];
                    $input['maxamount'] = $formData['maxamount'];
                } else {
                    return back()->with('successs', 'Maximum value less than bonus value');
                }
                $input['bonus_type'] = @$formData['bonus_type'];
                $input['btype'] = $formData['btype'];
                $input['expire_date'] = $formData['expire_date'];
                $input['description'] = $formData['description'];
                $input['first_deposit'] = @$formData['first_deposit'] != '' ? $formData['first_deposit'] : 0;
                $input['code'] = strtoupper($formData['code']);
                DB::table('offers')->insert($input);
                Session::flash('flash_notice',  trans("Successfully Added Offer!"));
                Helpers::logActivity('Successfully Added Offer!');
                return Redirect::route('Advertisments.viewOffers');
            }
        }
        return view("admin.$this->model.addoffers");
    }

    function editOffers($id, Request $request)
    {
        //Get Id
        $id = unserialize(base64_decode($id));
        $formData    =    Input::all();
        $findOffer = DB::table('offers')->where('id', $id)->get();
        if (request()->isMethod("POST")) {
          $validate    =    array(
              // 'minamount'        =>    'required|numeric',
              // 'maxamount'        =>    'required|numeric',
              // 'bonus'            =>    'required',
              // 'bonus_type'    =>    'required',
              // 'code'            =>    'required',
              // 'expire_date'    =>    'required',
              // 'description'    =>    'required',
              // 'per_user_count'        =>    'required|numeric',
              // 'bonuscredittype'    =>    'required',
          );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                // var_dump($validator);exit;
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);
                $input['minamount'] = $formData['minamount'];
                $input['maxamount'] = $formData['maxamount'];
                $input['bonus'] = $formData['bonus'];
                $input['bonus_type'] = $formData['bonus_type'];
                $input['btype'] = $formData['bonuscredittype'];
                $input['code'] = strtoupper($formData['code']);
                $input['expire_date'] = $formData['expire_date'];
                $input['description'] = $formData['description'];
                $input['first_deposit'] = @$formData['first_deposit'] != '' ? $formData['first_deposit'] : 0;
                $input['is_for_all'] = @$formData['is_for_all'] != '' ? $formData['is_for_all'] : 0;
                $input['status'] = @$formData['status'] != '' ? $formData['status'] : 0;
                $input['per_user_count'] = @$formData['per_user_count'];
                // var_dump($input);exit;

                DB::table('offers')->where('id', $formData['id'])->update($input);
                // Session::flash('message', 'Successfully Eddited Offer!');
                // Session::flash('alert-class', 'alert-success');
                Helpers::logActivity('Successfully Update Offer!', $formData['id']);
                Session::flash('flash_notice',  trans("Successfully Update Offer!"));
                return Redirect::route('Advertisments.viewOffers');
            }
            //End
        }
        return view("admin.$this->model.editOffer", compact('findOffer'));
    }



    function addNewOffers(Request $request)
    {
// echo "string";die;
        $formData    =    Input::all();
        if (request()->isMethod("POST")) {
            $validate    =    array(
                'minamount'        =>    'required|numeric',
                'maxamount'        =>    'required|numeric',
                'bonus'            =>    'required',
                'bonus_type'    =>    'required',
                'code'            =>    'required',
                'expire_date'    =>    'required',
                'description'    =>    'required',
                'per_user_count'        =>    'required|numeric',
                'bonuscredittype'    =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
              // echo "string";die;
              // dd($formData);
                unset($formData['_token']);
                $input['minamount'] = $formData['minamount'];
                $input['maxamount'] = $formData['maxamount'];
                $input['bonus'] = $formData['bonus'];
                $input['bonus_type'] = $formData['bonus_type'];
                $input['btype'] = $formData['bonuscredittype'];
                $input['expire_date'] = $formData['expire_date'];
                $input['description'] = $formData['description'];
                $input['first_deposit'] = @$formData['first_deposit'] != '' ? $formData['first_deposit'] : 0;
                $input['is_for_all'] = @$formData['is_for_all'] != '' ? $formData['is_for_all'] : 0;
                $input['status'] = @$formData['status'] != '' ? $formData['status'] : 0;
                $input['per_user_count'] = @$formData['per_user_count'] != '' ? $formData['per_user_count'] : 0;
                $input['code'] = strtoupper($formData['code']);
                // dd($input);

                DB::table('offers')->insert($input);
                // Session::flash('message', 'Successfully Added Advertisment!');
                // Session::flash('alert-class', 'alert-success');
                Session::flash('flash_notice',  trans("Successfully Added Offer!"));
                Helpers::logActivity('Successfully Added Offer!');
                return Redirect::route('Advertisments.viewOffers');
            }
        }
        // echo "string";die;
        return view("admin.$this->model.createoffers");
    }
  //   function addNewOffers(Request $request){
  //
	// 	$formData	=	Input::post();
	// 	 ### Breadcrumb Start ###
	// 	Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
	// 	Breadcrumb::addBreadcrumb($this->model,route($this->model.'.addNewOffers'));
	// 	$breadcrumbs 	= 	Breadcrumb::generate();
  //
	// 	if(!empty($formData)){
	// 		$validate	=	array(
	// 				'minamount'		=>	'required|numeric',
	// 				'maxamount'		=>	'required|numeric',
	// 				'bonus'			=>	'required',
	// 				'bonus_type'	=>	'required',
	// 				'code'			=>	'required',
	// 				'expire_date'	=>	'required',
	// 				'description'	=>	'required',
	// 			);
	// 	$validator = Validator::make(Input::all(),$validate);
	// 		if ($validator->fails()){
	// 			 return Redirect::back()->withErrors($validator)->withInput();
	// 		}else{
	// 		 unset($formData['_token']);
	// 		 $input['minamount']=$formData['minamount'];
	// 		 $input['maxamount']=$formData['maxamount'];
	// 		 $input['bonus']=$formData['bonus'];
	// 		 $input['bonus_type']=$formData['bonus_type'];
	// 		 $input['btype']=$formData['btype'];
	// 		 $input['expire_date']=$formData['expire_date'];
	// 		 $input['description']=$formData['description'];
	// 		 $input['first_deposit'] = @$formData['first_deposit'] != '' ? $formData['first_deposit'] : 0;
	// 		 $input['code'] = strtoupper($formData['code']);
	// 		 DB::table('offers')->insert($input);
	// 		 // Session::flash('message', 'Successfully Added Advertisment!');
	// 		 // Session::flash('alert-class', 'alert-success');
	// 		Session::flash('flash_notice',  trans("Successfully Added Offer!'"));
	// 		Helpers::logActivity('Successfully Added Offer!');
	// 		return Redirect::route('Advertisments.viewOffers');
  //
	// 		}
	// 	}
	//     return view("admin.$this->model.createoffers");
	// }



    function deleteoffers($id)
    {
        $id = unserialize(base64_decode($id));
        $findOffer = DB::table('offers')->where('id', $id)->get();
        if (!empty($findOffer)) {
            DB::table('offers')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Offer!');
            Helpers::logActivity('Successfully Deleted Offer!');
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Offer id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::route('Advertisments.viewOffers');
    }

    /*-----------------------Offers----------------------*/

    public function scratchManage(Request $request)
    {
        $formData    =    $request->all();
        //Ajax Load
        if (isset($formData) && request()->isMethod("POST")) {
            return Datatables::of(DB::table('control_manage')->get())
                ->addIndexColumn()
                ->addColumn('name', function ($result) {
                    return ucwords(str_replace('_', ' ', $result->name));
                })
                ->addColumn('value', function ($result) {
                    if ($result->status == 0) {
                        return '<a href="javascript:void(0);" data-toggle="tooltip" title="Click to On" data-id="' . base64_encode(serialize($result->id)) . '" data-status="1" class="btn btn-danger updateStatus">Off</a>';
                    } else {
                        return '<a href="javascript:void(0);" data-toggle="tooltip" title="Click to Off" data-id="' . base64_encode(serialize($result->id)) . '" data-status="0" class="btn btn-primary updateStatus">On</a>';
                    }
                })
                ->addColumn('range', function ($result) {
                    return '<form class="form-horizontal form-label-left">
							<label>Min: </label><input type="number" style="width: 50px;" class="form-control" name="min" value="' . $result->min . '">
							<label>Max: </label><input type="number" style="width: 50px;" class="form-control" name="max" value="' . $result->max . '">
			                <input type="hidden" name="id" value="' . base64_encode(serialize($result->id)) . '">
			                <button class="btn btn-info rangeUpdate" style="color:#000;margin-top:3px;">update</button>
			                </form>
							';
                })
                ->escapeColumns([])
                ->make(true);
        }
        return view("admin.$this->model.scratchManage");
    }

    public function scratchUpdateStatus(Request $request)
    {
        $formData = $request->all();
        $table_id = unserialize(base64_decode($formData['id']));
        $input['status'] = $formData['status'];
        DB::table('control_manage')->where('id', $table_id)->update($input);
        $res = array("status" => 200, "message" => "Scratch Card status updated.");
        echo json_encode($res);
        die();
    }

    public function scratchRangeUpdate(Request $request)
    {
        $formData = $request->all();
        $input['min'] = $formData['min'];
        $input['max'] = $formData['max'];
        $table_id = unserialize(base64_decode($formData['id']));
        DB::table('control_manage')->where('id', $table_id)->update($input);
        $res = array("status" => 200, "message" => "Scratch range update successfully!");
        echo json_encode($res);
        die();
    }

    // here we give scratch cards to the users
    public function scratchCardsGiveaway(Request $request)
    {
        date_default_timezone_set("Asia/Kolkata");
        $formData    =    $request->all();
        //Ajax Load
        if (isset($formData) && request()->isMethod("POST")) {
            $users = DB::table('registerusers')->get();

            foreach ($users as $key => $value) {
                $array = array();
                $array['user_id'] = $value->id;
                $array['coupon_type'] = COUPON_TYPE_DAILY;
                $array['active'] = ACTIVE_COUPON_CODE;
                $array['is_scratched'] = NOT_SCRATCHED;
                $array['created_at'] = date('Y-m-d H:i:s');
                DB::table('scratch_cards')->insert($array);
            }
            $res = array("status" => "success", "message" => "Scratch cards giveaway successfully!");
            echo json_encode($res);
            die();
        }

        return view("admin.$this->model.scratchcardsgiveaway");
    }
}
