<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BaseController;
use App\Services\Input;
use Illuminate\Support\Facades\DB;

class AjaxController extends BaseController
{

    /**
     * Function for get list of states
     */

    public function getStates()
    {
        $country_id    = Input::get('country_id');
        $stateList     = DB::table("states")->where('status', ACTIVE)
            ->where("country_id", $country_id)
            ->orderBy('state_name', 'ASC')
            ->pluck("state_name", "id")->toArray();

        return json_encode($stateList);
    }

    public function getCities()
    {
        $country_id    = Input::get('country_id');
        $state_id     = Input::get('state_id');
        $citylist     = DB::table("cities")->where('status', ACTIVE)
            ->where("country_id", $country_id)
            ->where("state_id", $state_id)
            ->orderBy('city_name', 'ASC')
            ->pluck("city_name", "id")->toArray();

        return json_encode($citylist);
    }

    /**
     * Function for get list of cities
     */
    public function getCityByState()
    {
        $state_id     = Input::get('state_id');
        $citylist     = DB::table("cities")->where('status', ACTIVE)
            ->where("state_id", $state_id)
            ->orderBy('name', 'ASC')
            ->pluck("name", "id")->toArray();

        return json_encode($citylist);
    } // end
    /**
     * Function for get list of cities
     */
    public function getUsersByRole()
    {
        $user_role_id     = Input::get('user_role_id');
        $users     = DB::table("users")->where('active', ACTIVE)
            ->where('is_deleted', NOT_DELETE)
            ->where("user_role_id", $user_role_id)
            ->orderBy('full_name', 'ASC')
            ->pluck("full_name", "id")->toArray();

        return json_encode($users);
    } // end

}
