<?php
namespace App\Http\Controllers\Admin;

use App\Model\EmailLog;
use App\Model\DealsMail;
use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Model\Advertisments;
use App\Services\Input;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
/**
 * Base Controller
 *
 * Add your methods in the class below
 *
 * This is the base controller called everytime on every request
 */

class  EmailLogsController extends BaseController {

	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model	=	'EmailLog';

	public function __construct() {
		View::share('modelName',$this->model);
	}

	public function index(){
		///Ajax
    $formData = Input::all();
      if(isset($formData) && !empty($formData)){
      return Datatables::of(EmailLog::get())
           ->addIndexColumn()
           ->addColumn('action', function ($result) {
                return 	'<a href="'.route($this->model.'.edit',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
				  .'<a href="'.route($this->model.'.delete',base64_encode(serialize($result->id))).'" class="btn-primary-light icon"><i class="fa fa-times" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Delete" ></i></a>';
            })->addColumn('created_at', function ($result) {
                return date('Y-M-d',strtotime($result->created_at));
            })
            //->rawColumns(['action'])
            ->make(true);
        }//end
		return  View::make("admin.$this->model.index");
	}//end

/*
 * Function for dispaly email details on popup
 *
 * @param $id as mail id
 *
 * @return view page.
 */
	public function Emailadd(){
		$formData = Input::all();
		 ### Breadcrumb Start ###
		if(!empty($formData)){
			$validate	=	array(
					'name'			    =>	'required',
					'subject'			=>	'required',
					'action'			=>	'required',
					'description'		=>	'required',
				);
			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{
			$obj = new EmailLog;
			$obj->name = $formData['name'];
			$obj->subject = $formData['subject'];
			$obj->action = $formData['action'];
			$obj->body = $formData['description'];
			//Insert
		 	$obj->save();
				Session::flash('flash_notice',  trans("Add Email Successfully!'"));
				return Redirect::route($this->model.'.index');
			}
		}
		return view("admin.$this->model.addEmail");
	}// end

/*
 * Function for dispaly email details on popup
 *
 * @param $id as mail id
 *
 * @return view page.
 */
	public function Emailedit(){
		$formData = Input::all();

		if(!empty($formData)){
			$validate	=	array(
					'name'			    =>	'required',
					'subject'			=>	'required',
					'action'			=>	'required',
					'description'		=>	'required',
				);
			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{
			$obj = new EmailLog;
			$obj->name = $formData['name'];
			$obj->subject = $formData['subject'];
			$obj->action = $formData['action'];
			$obj->body = $formData['description'];
			//Insert
		 	$obj->save();
		 	// Session::flash('success', 'Add Email Successfully!');
			// Session::flash('alert-class', 'alert-success');
			Session::flash('flash_notice',  trans("Add Email Successfully!'"));
				return Redirect::route($this->model.'.index');
			}
		}
		return view("admin.$this->model.addEmail");
	}// end

/*
 * Function for dispaly email details on popup
 *
 * @param $id as mail id
 *
 * @return view page.
 */
	public function Emaildelete(){
		$formData = Input::all();

		if(!empty($formData)){
			$message	=	array(
						'image.max'						=>	MAX_IMAGE_SIZE,
					);
			$validate	=	array(
					'title'			    =>	'required',
					//'file'			    =>	'required',
				);
			$validator = Validator::make(Input::all(),$validate,$message);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{

			$obj = new Advertisments;
			if(Input::hasFile('image')){
					$extension =	Input::file('image')->getClientOriginalExtension();
					$img_ext = explode(",",IMAGE_EXTENSION);
					if(in_array($extension,$img_ext)){
						$fileName='11caps-banner-'.$formData['title'];
						if(Input::file('image')->move(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH, $fileName)){
							$obj->image	=	$fileName;
						}
					}else{
						Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
						return Redirect::back()->withInput();
					}
				}
				$obj->title = $formData['title'];
				$obj->url = $formData['url'];
				//print_r($obj);die;
				//Insert
			 	$obj->save();
				Session::flash('flash_notice',  trans("Successfully Add Email!'"));
				return Redirect::route('Advertisments.view');
			}
		}
		return view("admin.$this->model.addEmail",compact('breadcrumbs'));
	}// end

}// end EmailLogsController
