<?php
namespace App\Http\Controllers\Admin;

use App\Model\EmailTemplate;
use App\Http\Controllers\BaseController;
/**
 * Base Controller
 *
 * Add your methods in the class below
 *
 * This is the base controller called everytime on every request
 */

class  EmailtemplateController extends BaseController {

	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model	=	'EmailTemplate';

	public function __construct() {
		View::share('modelName',$this->model);
	}

	public function index(){
		///Ajax
    $formData = Input::post();
      if(isset($formData) && !empty($formData)){
      return \Datatables::of(EmailTemplate::get())
           ->addIndexColumn()
           ->addColumn('action', function ($result) {
                return 	'<a href="'.route($this->model.'.edit',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn btn-dark mr-2" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>'
				  .'<a href="'.route($this->model.'.delete',base64_encode(serialize($result->id))).'" class="btn btn-danger action-template"><i class="fa fa-times mr-2" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Delete" ></i>Delete</a>';
            })
            //->rawColumns(['action'])
            ->make(true);
        }//end
		### Breadcrumb Start ###
		Breadcrumb::addBreadcrumb(trans("Dashboard"),route('admin_dashboard'));
		Breadcrumb::addBreadcrumb(trans($this->model),route($this->model.'.index'));
		$breadcrumbs 	= 	Breadcrumb::generate();
		### Breadcrumb End ###
		return  View::make("admin.$this->model.index",compact('breadcrumbs'));
	}//end

/*
 * Function for dispaly email details on popup
 *
 * @param $id as mail id
 *
 * @return view page.
 */
	public function Emailadd(){
		$formData = Input::all();
		 ### Breadcrumb Start ###
		Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
		Breadcrumb::addBreadcrumb($this->model,route($this->model.'.add'));
		$breadcrumbs 	= 	Breadcrumb::generate();
		//Insert Data
		if(!empty($formData)){
			$validate	=	array(
					'name'			    =>	'required',
					'subject'			=>	'required',
					'action'			=>	'required',
					'description'		=>	'required',
				);
			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{
			$obj = new EmailTemplate;
			$obj->name = $formData['name'];
			$obj->subject = $formData['subject'];
			$obj->action = $formData['action'];
			$obj->body = $formData['description'];
			//Insert
		 	$obj->save();
			Session::flash('success',  trans("Add Email Successfully!"));
			// Session::flash('message', 'Add Email Successfully!');
			// Session::flash('alert-class', 'alert-success');
			return Redirect::route($this->model.'.index');
			}
		}
		return view("admin.$this->model.addEmail",compact('breadcrumbs'));
	}// end

/*
 * Function for dispaly email details on popup
 *
 * @param $id as mail id
 *
 * @return view page.
 */
	public function Emailedit($id=null){
		 ### Breadcrumb Start ###
		Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
		Breadcrumb::addBreadcrumb($this->model,route($this->model.'.edit',$id));
		$breadcrumbs 	= 	Breadcrumb::generate();
		//Get Id
		$id = unserialize(base64_decode($id));
		$formData = Input::all();
		//Insert Data
		if(!empty($formData)){
			$validate	=	array(
					'name'			    =>	'required',
					'subject'			=>	'required',
					'action'			=>	'required',
					'description'		=>	'required',
				);
			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{

			$obj = EmailTemplate::find($id);
			$obj->name = $formData['name'];
			$obj->subject = $formData['subject'];
			$obj->action = $formData['action'];
			$obj->body = $formData['description'];
			//Insert
		 	$obj->save();
				Session::flash('success',  trans("Email Update Successfully!"));
				return Redirect::route($this->model.'.index');
			}
		}
		$emailtemplate_data=EmailTemplate::find($id);
		return view("admin.$this->model.editEmail",compact('breadcrumbs','emailtemplate_data'));
	}// end

/*
 * Function for dispaly email details on popup
 *
 * @param $id as mail id
 *
 * @return view page.
 */
	public function Emaildelete($id=null){
		$formData = Input::all();
		 ### Breadcrumb Start ###
		Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
		Breadcrumb::addBreadcrumb($this->model,route($this->model.'.add'));
		$breadcrumbs 	= 	Breadcrumb::generate();
		$id = unserialize(base64_decode($id));
		EmailTemplate::where('id', $id)->delete();
		//Insert Data
		Session::flash('flash_notice',  trans("Email Delete Successfully!"));
		return Redirect::route($this->model.'.index');
	}// end

}// end EmailTemplatesController
