<?php
namespace App\Http\Controllers\Admin;

use App\Model\Series;
use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use mjanssen\BreadcrumbsBundle\Breadcrumbs as Breadcrumb;
//use App\Http\Controllers\Admin\SeriesController;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class LevelsController extends BaseController {

	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model	=	'Levels';

	public function __construct() {
		View::share('modelName',$this->model);
	}


	public function viewlevels(Request $req)
    {
			if ($req->isMethod('post')) {
					$formData = Input::all();

					if (isset($formData) && !empty($formData)) {
							return Datatables::of($query=DB::table('levels as l')
											->select('*')
											->get())
						 ->addIndexColumn()

						 // ->addColumn('action', function ($result) {
							// 	 $series_status = '';
			 				// 	 if ($result->series_status == 'opened') {
							// 			 $series_status = '<a href="'.route($this->model.'.updatelevels', [base64_encode(serialize($result->id)),"closed"]).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Close"><i class="fa fa-lock" aria-hidden="true" data-original-title="Delete" ></i></a>';
							// 	 } else {
							// 			 $series_status = '<a href="'.route($this->model.'.updatelevels', [base64_encode(serialize($result->id)),"opened"]).'" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Open"><i class="fa fa-unlock" aria-hidden="true" data-original-title="Check" ></i></a>';
							// 	 }
							// 	 return '<a href="'.route($this->model.'.update', base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="Edit" class="btn btn-rg icon mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
							// 				.$series_status;
						 //
						 // })

						 ->addColumn('action', function ($result) {
							 $delete_level='';
							 $delete_level='<a href="'.route($this->model.'.deletelevels',base64_encode(serialize($result->id))).'" class="btn btn-danger mr-1 mt-1 action-users">Delete</a></br>';

							  return '<a href="'.route($this->model.'.update', base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="Edit" class="btn btn-rg icon mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'.$delete_level;
				 })

							->escapeColumns([])
							->make(true);
					}//end
				}

			return  View::make("admin.$this->model.viewlevels");
    }


	//Add Series
	public function addlevels(Request $request){

		$formData	=	Input::all();
		// print_r($formData);die();



		if (!empty($formData)){
	       	$validate	=	array(
					'level'=>'required|unique:levels',
					'cash'=>'required:levels',
					'contest'=>'required:levels',
					// 'type'=>'required|unique:levels'
				);
			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{
	           $input = Input::all();

			   // $input = $request->input();
	       //    print_r($input);die;

			   unset($input['_token']);


			   DB::table('levels')->insert($input);
			   Session::flash('flash_notice',  trans("Successfully added levels!"));
			    return Redirect::route($this->model.'.view_all');
			}
	  	}

	  return view("admin.$this->model.addlevels",compact('breadcrumbs'));
	}


	public function editlevels($id,Request $request){
		### Breadcrumb End ##
		$id = unserialize(base64_decode($id));
		$level = DB::table('levels')->where('id',$id)->first();
        // print_r($level->type);die();
		$formData	=	Input::all();
			// print_r($formData);die();


		if (!empty($formData)){
			$validate	=	array(
					'level'=>	"required|unique:levels,name,$id",
				);

			$validator = Validator::make(Input::all(),$validate);

			unset($formData['_token']);
		// 	$formData['start_date'] = date('Y-m-d h:i:s',strtotime($formData['start_date']));
		//     $formData['end_date'] = date('Y-m-d h:i:s',strtotime($formData['end_date']));
		 	$rowCOllection = DB::table('levels')->where('id',$id)->update($formData);
            Session::flash('flash_notice',  trans("Successfully updated series!"));
		       return Redirect::route($this->model.'.view_all');


		}
		return view("admin.$this->model.editlevels",compact('level'));
	}


	public function deletelevels($id){
		$id = unserialize(base64_decode($id));
		 $level = DB::table('levels')->where('id',$id)->first();
		// if(!empty($series)){
		// 	$findmatchexist = DB::table('listmatches')->where('series',$series->id)->get();
		// 	if(!empty($findmatchexist)){
		// 		return Redirect::back()
		// 			->withErrors('You cannot delete this series as match is added into this series');
		// 	}else{
				 DB::table('levels')->where('id',$id)->delete();
				Session::flash('flash_notice', 'Successfully deleted level!');
				//Session::flash('alert-class', 'alert-success');
				// return redirect()->action('LevelsController@viewlevels');
			// }
			return Redirect::route($this->model.'.view_all');

		}
		// else{
		// 	Session::flash('flash_notice', 'Invalid Id Provided');
		// 	//Session::flash('alert-class', 'alert-success');
		// 	return Redirect::back();
		// }
	// }




}
?>
