<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class Model_listController extends Controller {

	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model ='Model_list';

	public function __construct() {
		View::share('modelName',$this->model);
	}//End Function

	//View Sub Admin
	public function view(){
		//Get Ajax Data
		$formData = Input::all();
    	if(isset($formData) && !empty($formData)){
			return Datatables::of(DB::table('models')
				->orderBy('id', 'DESC')
				->get())
	           	->addIndexColumn()
	           ->addColumn('action', function ($result) {
	           		return '<a href="'.route($this->model.'.edit',base64_encode(serialize($result->id))).'" class="btn btn-danger"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>';
	            })
	            ->escapeColumns([])
	            ->make(true);
	        }//end

		return view("admin.$this->model.view");
    }//End Function

    public function add(){
    	$formData = Input::all();

		if(!empty($formData)){
			$message	=	array(
				'model_name.required' => 'Please select model name.',
			);
			$validate	=	array(
				'model_name' => 'required|regex:/^[\pL\s\-]+$/u',
			);
			$validator = Validator::make(Input::all(),$validate,$message);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{
				//Insert
        		$data['model_name'] =$formData['model_name'];
             	DB::table('models')->insert($data);
				Session::flash('flash_notice',  trans("Model Add Successfully!"));
				return Redirect::route($this->model.'.view');
			}
	      //First Time Page Lode
	    }else{
	        return view("admin.$this->model.add");
	    }
    }//end Function

    //Edit
    public function edit($id=null){

		$id = unserialize(base64_decode($id));
    	//Get Val
    	$formData       = Input::all();
	    if(!empty($formData)){
	        $message  = array(
	            'model_name.required'      => 'Please enter model name.',
	        );
	        $validate = array(
	            'model_name'      => 'required',
	        );
	        $validator = Validator::make(Input::all(),$validate,$message);
	        if ($validator->fails()){
	        return Redirect::back()->withErrors($validator)->withInput();
	        //Validation Comp.
	        }else{
	        	//Insert Data
	            $data['model_name'] =$formData['model_name'];
	            DB::table('models')->where('id',$id)->update($data);
	            //Message
	        	Session::flash('flash_notice', trans("Model Update Successfully!"));
				return Redirect::route($this->model.'.view');
	        }
	      //First Time Page Lode
	    }else{
	    	//Get Model
	        $models= DB::table('models')
	                ->where('id',$id )
	                ->first();
	        //Edit Page
	        return view("admin.$this->model.edit",compact('models'));
	    }
    }//end Function


}//End Class
