<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use Illuminate\Support\Str;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class NotificationController extends Controller
{

    public $model    =    'Notification';

    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function

    public function pushnotifications(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $image = "";
            $imageName = '';
            if (!empty($input['image'])) {
                $file = array_filter($input['image']);
                if (!empty($file)) {
                    $destinationPath = 'uploads/notifications';
                    $fileName = 'PlaynWin11-Notification-' . rand(1000, 9999) . time();
                    $imageName = Helpers::imageUpload($file, $destinationPath, $fileName);
                    $image = WEBSITE_URL . 'uploads/notifications/' . $imageName;
                }
            }

            $user_id = auth()->user()->id;
            $insert_data = array("title" => $input['title'], "message" => $input['message'], "image" => $imageName, "type" => $input['type'], "user_id" => $user_id);
            $query_notification = DB::table('notification_history')->insert($insert_data);
            $titleget = $input['title'];
            $msg = $input['message'];

            Helpers::sendnotificationAll($titleget, $msg, $image);

            Session::flash('flash_notice', 'notifications send Successfully!');

            return Redirect::back();
        }

        return view("admin.$this->model.sendnotifications");
    }


    public function pushnotificationsCustom(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $image = "";
            $imageName = '';

            $validate   =   array(
                'title'         =>  'required',
                'email'         =>  'required',
            );
            $validator = Validator::make($input, $validate);
            if ($validator->fails()) {
                Session::flash('error', 'Message Field required');
                return Redirect::back()->withErrors($validator)->withInput();
            }

            if (!empty($input['image'])) {
                $file = array_filter($input['image']);
                if (!empty($file)) {
                    $destinationPath = 'uploads/notifications';
                    $fileName = 'PlaynWin11-Notification-' . rand(1000, 9999) . time();
                    $imageName = Helpers::imageUpload($file, $destinationPath, $fileName);
                    $image = WEBSITE_URL . 'uploads/notifications/' . $imageName;
                }
            }

            $user_id = auth()->user()->id;
            $insert_data = array("title" => $input['title'], "message" => isset($input['message']) ? $input['message'] : 'null', "image" => $imageName, "type" => $input['type'], "user_id" => $user_id);
            $query_notification = DB::table('notification_history')->insert($insert_data);
            $titleget = $input['title'];
            $msg = isset($input['message']) ? $input['message'] : '';
            // Helpers::sendnotificationAll($titleget,$msg,$image);
            $user = DB::table('registerusers')->where('email', $input['email'])->select('id')->first();
            if (!empty($user)) {
                $titleget = $input['title'];
                $msg = isset($input['message']) ? $input['message'] : '';
                //echo $titleget.' === '.$msg.' ==== '.$image.' === '.$user->id.' <br>';
                Helpers::sendnotification($titleget, $msg, $image, $user->id);

                Session::flash('flash_notice', 'notifications send Successfully!');
            } else {
                Session::flash('flash_notice', 'Email does not exit');
                return Redirect::back();
            }
            // return view("admin.$this->model.$type_name"."notifications_history");

            return Redirect::back();
        }
        return view("admin.$this->model.sendnotificationcustom");
    }

    public function smsnotifications(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $user_id = auth()->user()->id;
            $insert_data = array("message" => $input['message'], "type" => $input['type'], "user_id" => $user_id);
            $query_notification = DB::table('notification_history')->insert($insert_data);
            $findlallusers = DB::table('registerusers')->select('mobile')->get();
            if (!empty($findlallusers)) {
                foreach ($findlallusers as $user) {
                    $msg = $input['message'];
                    Helpers::sendTextSmsNew($msg, $user->mobile);
                }
            }

            Session::flash('flash_notice', 'sms sent Successfully!');
            return Redirect::back();
        }
        return view("admin.$this->model.smsnotifications");
    }

    public function emailnotifications(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $user_id = auth()->user()->id;
            $insert_data = array("title" => $input['title'], "message" => $input['message'], "type" => $input['type'], "user_id" => $user_id);
            $query_notification = DB::table('notification_history')->insert($insert_data);
            $findlallusers = DB::table('registerusers')->select('email')->get();
            if (!empty($findlallusers)) {
                foreach ($findlallusers as $user) {
                    $titleget = $input['title'];
                    $msg = $input['message'];
                    Helpers::mailsentFormat($user->email, $titleget, $msg);
                }
            }

            Session::flash('flash_notice', 'Email send Successfully!');
            return Redirect::back();
        }
        return view("admin.$this->model.emailnotifications");
    }

    public function notifications_history($type = null, Request $request)
    {
        $type_name = '';
        switch ($type) {
            case 1:
                $type_name = 'send';
                break;
            case 2:
                $type_name = 'email';
                break;
            case 3:
                $type_name = 'sms';
                break;
            default:
                $type_name = '';
        }

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('notification_history')
                ->orderBy('id', 'DESC')
                ->select('id', 'title', 'message', 'image')
                ->where('type', $type)
                ->get())
                ->addIndexColumn()
                ->addColumn('message', function ($result) {
                    if ($result->message != '')

                        // return substr($result->message, 0, 110);
                        return    Str::limit($result->message, 110, '...');




                    else
                        return '';
                })
                ->addColumn('image', function ($result) {
                    if (isset($result->image) &&  @getimagesize(url()->asset('uploads/notifications/' . $result->image))) {
                        return '<img src="' . url()->asset('uploads/notifications/' . $result->image) . '" style="width:100px;height:50px;">';
                    } else {
                        return $result->image;
                    }
                })
                ->escapeColumns([])
                ->make(true);
        }

        return view("admin.$this->model.$type_name" . "notifications_history");
    }

    public function notifications_history_custom($type = null, Request $request)
    {
        $type_name = '';
        switch ($type) {
            case 1:
                $type_name = 'custom';
                break;
            case 2:
                $type_name = 'email';
                break;
            case 3:
                $type_name = 'sms';
                break;
            default:
                $type_name = '';
        }
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('notification_history')
                ->orderBy('id', 'DESC')
                ->select('id', 'title', 'message', 'image')
                ->where('type', $type)
                ->get())
                ->addIndexColumn()
                ->addColumn('message', function ($result) {
                    if ($result->message != '')

                        // return substr($result->message, 0, 110);
                        return    Str::limit($result->message, 110, '...');
                    else
                        return '';
                })
                ->addColumn('image', function ($result) {
                    if (isset($result->image) &&  @getimagesize(url()->asset('uploads/notifications/' . $result->image))) {
                        return '<img src="' . url()->asset('uploads/notifications/' . $result->image) . '" style="width:100px;height:50px;">';
                    } else {
                        return $result->image;
                    }
                })
                ->escapeColumns([])
                ->make(true);
        }

        return view("admin.$this->model." . "sendnotification_historycustom");
    }
}
