<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
  date_default_timezone_set('Asia/Kolkata');
class ProfitLossManagerController extends Controller {

	/*
	* Function for display email detail from database
	*
	* @param null
	*
	* @return view page.
	*/
	public $model	=	'ProfitLossManager';

	public function __construct() {
		View::share('modelName',$this->model);
	}//End Function
	public function profitlossdownload(Request $req){
		//Get Post Data
		$formData = Input::all();
		if ($req->ismethod('post')) {
			$output1 = "";
			$output1 .='"S No.",';
			$output1 .='"Sports",';
			$output1 .='"Series Name",';
			$output1 .='"Match Name",';
			$output1 .='"Date & Time",';
			$output1 .='"Winning",';
			$output1 .='"Deposit",';
			$output1 .='"GST/TDS Rebate",';
			$output1 .='"Affiliate",';
			$output1 .='"Bonus",';
			$output1 .='"Refund",';
			$output1 .='"Total Investment",';
			$output1 .='"Investment After Rebate and Bonus",';
			$output1 .='"Total Distributed",';
			$output1 .='"Giveaway Amount",';
			$output1 .='"Affiliation Commission",';
			$output1 .='"Profit",';
			$output1 .='"Loss",';
			$output1 .="\n";

			$results = DB::table('listmatches')
			->join('series as s','s.id','=','listmatches.series')
			->join('leaugestransactions as lt','lt.matchkey','=','listmatches.matchkey')
			->leftJoin('refunds', function($join)
			{
				$join->on('refunds.joinid', '=', 'lt.joinid');

			})
			->whereNull('refunds.joinid')
			->where('listmatches.launch_status','launched')
			->where('listmatches.final_status','winnerdeclared')
			->select('listmatches.*','s.name as series_name','listmatches.short_name as name')
			->selectRaw('sum(lt.bonus) as bonus')
			->selectRaw('sum(lt.gst_bonus) as gst_bonus')
			->selectRaw('sum(lt.winning) as winning')
			->selectRaw('sum(lt.balance) as balance')
			->selectRaw('sum(lt.affiliation_commission) as affiliation')
			->where(function ($query) use ($formData) {
				if (!empty($formData['start_date']) || !empty($formData['end_date']) ) {
					if(@$formData['start_date'] != "")
					$query->where("listmatches.start_date",'>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])) );
					if(@$formData['end_date'] != "")
					$query->where("listmatches.start_date",'<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])) );
				}
			})
			->orderBy('listmatches.start_date', 'DESC')
			->groupBy('lt.matchkey')
			->get();
			//print_r($result);
			if(!empty($results)){
				$count = 1;
				foreach($results as $result){
					$output1 .='"'.$count++.'",';

					$sportType = '';
					if($result->sport_type == '1'){
						$sportType = 'CRICKET';
					}
					if($result->sport_type == '2'){
						$sportType = 'FOOTBALL';
					}
					if($result->sport_type == '3'){
						$sportType = 'BASKETBALL';
					}
					if($result->sport_type == '7'){
						$sportType = 'KABADDI';
					}
					$output1 .='"'.$sportType.'",';
					$output1 .='"'.$result->series_name.'",';
					$output1 .='"'.$result->name.'",';
					$output1 .='"'.$result->start_date.'",';
					$output1 .='"'.round($result->winning,2).'",';
					$output1 .='"'.round($result->balance,2).'",';
					$output1 .='"'.round($result->gst_bonus,2).'",';
					$output1 .='"'.round($result->affiliation,2).'",';
					$output1 .='"'.round($result->bonus,2).'",';

            $totalrefundamount= DB::table('refunds')->where('matchkey',$result->matchkey)->sum('amount');
         $output1 .='"'.round($totalrefundamount,2).'",';

					$output1 .='"'.round(($result->balance+$result->winning+$result->bonus+$result->gst_bonus+$result->affiliation),2).'",';

					$output1 .='"'.round(($result->balance+$result->winning+$result->affiliation),2).'",';


		    $totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
					$output1 .='"'.round(($totalamount),2).'",';

				//Giveway Amount
					$userid=	DB::table('registerusers')->where('is_bot',1)->select('id')->pluck('id');
					$giveawayamount=	DB::table('finalresults')->where('matchkey',$result->matchkey)->whereIn('userid',$userid)	->select('amount')
						->sum('amount');
					$output1 .='"'.round(($giveawayamount),2).'",';
						//Giveway Amount

					//Affiliation Commission
					$challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
					$affiliationTotalamount=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
						->sum('league_refer_bonus.amount');
					$output1 .='"'.round(($affiliationTotalamount),2).'",';

					//profit start
					$profitnew = 0;
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');

					$profit = (($result->balance+$result->winning) - ($totalamount)-$affiliationTotalamount);

					if($profit > 0)
						$output1 .='"'.$profit.'",';
					else
					$output1 .='0,';


					//loss start
					$lossnew = 0;
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
					if ($totalamount==0) {
						$lossnew = 0;
					}

					$loss = (($totalamount+$affiliationTotalamount) - ($result->balance+$result->winning));
					if($loss > 0)
						$output1 .='"'.$loss.'",';
					else
					$output1 .='0,';
					$output1 .="\n";
				}
			}
			$filename =  "Details-userwallet.csv";
			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);
			echo $output1;
			exit;
		}

	}//End Function

	public function profitlossdownload_old2(Request $req){
		//Get Post Data
		$formData = Input::all();
		if ($req->ismethod('post')) {
			$output1 = "";
			$output1 .='"S No.",';
			$output1 .='"Sports",';
			$output1 .='"Series Name",';
			$output1 .='"Match Name",';
			$output1 .='"Date & Time",';
			$output1 .='"Deposit",';
			$output1 .='"Winning",';
			$output1 .='"Bonus",';
			$output1 .='"Coins",';
			//$output1 .='"Amount",';
			$output1 .='"Total Investment",';
			$output1 .='"Total distributed",';
			$output1 .='"giveaway Amount",';
			$output1 .='"Affiliation Commission",';
			$output1 .='"Profit",';
			$output1 .='"Loss",';
			$output1 .="\n";

			$results = DB::table('listmatches')
			->join('series as s','s.id','=','listmatches.series')
			->join('leaugestransactions as lt','lt.matchkey','=','listmatches.matchkey')
			->leftJoin('refunds', function($join)
			{
				$join->on('refunds.joinid', '=', 'lt.joinid');

			})
			->whereNull('refunds.joinid')
			->where('listmatches.launch_status','launched')
			->where('listmatches.final_status','winnerdeclared')
			->select('listmatches.*','s.name as series_name')
			->selectRaw('sum(lt.bonus) as bonus')
			->selectRaw('sum(lt.coins) as gstbonus')
			->selectRaw('sum(lt.winning) as winning')
			->selectRaw('sum(lt.balance) as balance')
			->where(function ($query) use ($formData) {
				if (!empty($formData['start_date']) || !empty($formData['end_date']) ) {
					if(@$formData['start_date'] != "")
					$query->where("listmatches.start_date",'>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])) );
					if(@$formData['end_date'] != "")
					$query->where("listmatches.start_date",'<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])) );
				}
			})
			->orderBy('listmatches.start_date', 'DESC')
			->groupBy('lt.matchkey')
			->get();
			//print_r($result);
			if(!empty($results)){
				$count = 1;
				foreach($results as $result){
					$output1 .='"'.$count++.'",';

					$sportType = '';
					if($result->sport_type == '1'){
						$sportType = 'CRICKET';
					}
					if($result->sport_type == '2'){
						$sportType = 'FOOTBALL';
					}
					if($result->sport_type == '3'){
						$sportType = 'BASKETBALL';
					}
					if($result->sport_type == '7'){
						$sportType = 'KABADDI';
					}
					$output1 .='"'.$sportType.'",';
					$output1 .='"'.$result->series_name.'",';
					$output1 .='"'.$result->name.'",';
					$output1 .='"'.$result->start_date.'",';
					$output1 .='"'.round($result->winning,2).'",';
					$output1 .='"'.round($result->balance,2).'",';
					$output1 .='"'.round($result->bonus,2).'",';
					$output1 .='"'.round($result->gstbonus,2).'",';

					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
				//	$output1 .='"'.round($totalamount,2).'",';
					$output1 .='"'.round(($result->balance+$result->winning),2).'",';
					$output1 .='"'.round(($totalamount),2).'",';

				//Giveway Amount
					$userid=	DB::table('registerusers')->where('is_bot',1)->select('id')->pluck('id');
					$giveawayamount=	DB::table('finalresults')->where('matchkey',$result->matchkey)->whereIn('userid',$userid)	->select('amount')
						->sum('amount');
					$output1 .='"'.round(($giveawayamount),2).'",';
						//Giveway Amount

					//Affiliation Commission
					$challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
					$affiliationTotalamount=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
						->sum('league_refer_bonus.amount');
					$output1 .='"'.round(($affiliationTotalamount),2).'",';

					//profit start
					$profitnew = 0;
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');

						// $challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
						// $totalaffiliate=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
						// 		->sum('league_refer_bonus.amount');
					$profit = (($result->balance+$result->winning) - ($totalamount)-$affiliationTotalamount);

					if($profit > 0)
						$output1 .='"'.$profit.'",';
					else
					$output1 .='0,';


					//loss start
					$lossnew = 0;
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
					if ($totalamount==0) {
						$lossnew = 0;
					}

					$loss = (($totalamount+$affiliationTotalamount) - ($result->balance+$result->winning));
					if($loss > 0)
						$output1 .='"'.$loss.'",';
					else
					$output1 .='0,';
					$output1 .="\n";
				}
			}
			$filename =  "Details-userwallet.csv";
			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);
			echo $output1;
			exit;
		}

	}//End Function
	//User Balance DETAIL
	public function profitlossdownload_old(Request $req){
		//Get Post Data
		$formData = Input::all();
		if ($req->ismethod('post')) {

			$output1 = "";
			$output1 .='"S No.",';
			$output1 .='"Sports",';
			$output1 .='"Series Name",';
			$output1 .='"Match Name",';
			$output1 .='"Date & Time",';
			$output1 .='"Winning",';
			$output1 .='"Balance",';
			$output1 .='"Bonus",';
			$output1 .='"Amount",';
			$output1 .='"Total winning",';
			$output1 .='"Total distributed",';
			$output1 .='"Profit",';
			$output1 .='"Loss",';
			$output1 .="\n";

			$results = DB::table('listmatches')
			->join('series as s','s.id','=','listmatches.series')
			->join('leaugestransactions as lt','lt.matchkey','=','listmatches.matchkey')
			->leftJoin('refunds', function($join)
			{
				// $join->on('refunds.userid', '!=', 'lt.user_id');
				$join->on('refunds.joinid', '=', 'lt.joinid');
				// $join->on('refunds.challengeid', '!=', 'lt.challengeid');
				// $join->on('refunds.matchkey', '!=', 'lt.matchkey');

			})
			->whereNull('refunds.joinid')
			->where('listmatches.launch_status','launched')
			->where('listmatches.final_status','winnerdeclared')
			->select('listmatches.*','s.name as series_name')
			->selectRaw('sum(lt.bonus) as bonus')
			->selectRaw('sum(lt.winning) as winning')
			->selectRaw('sum(lt.balance) as balance')
			->where(function ($query) use ($formData) {
				if (!empty($formData['start_date']) || !empty($formData['end_date']) ) {
					if(@$formData['start_date'] != "")
					$query->where("listmatches.start_date",'>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])) );
					if(@$formData['end_date'] != "")
					$query->where("listmatches.start_date",'<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])) );
				}
			})
			->orderBy('listmatches.start_date', 'DESC')
			->groupBy('lt.matchkey')
			->limit(500)
			->get();
			//print_r($result);
			if(!empty($results)){
				$count = 1;
				foreach($results as $result){
					$output1 .='"'.$count++.'",';

					$sportType = '';
					if($result->sport_type == '1'){
						$sportType = 'CRICKET';
					}
					if($result->sport_type == '2'){
						$sportType = 'FOOTBALL';
					}
					if($result->sport_type == '3'){
						$sportType = 'BASKETBALL';
					}
					$output1 .='"'.$sportType.'",';
					$output1 .='"'.$result->series_name.'",';
					$output1 .='"'.$result->name.'",';
					$output1 .='"'.$result->start_date.'",';
					$output1 .='"'.round($result->winning,2).'",';
					$output1 .='"'.round($result->balance,2).'",';
					$output1 .='"'.round($result->bonus,2).'",';

					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
					$output1 .='"'.round($totalamount,2).'",';
					$output1 .='"'.round(($result->balance+$result->winning),2).'",';
					$output1 .='"'.round(($result->bonus+$totalamount),2).'",';

					//profit start
					$profitnew = 0;
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');

					if ($totalamount==0) {
						$profitnew = 0;
					}
					$profit = (($result->balance+$result->winning) - ($result->bonus+$totalamount));
					if($profit > 0)
					$profitnew = round($profit,2);
					else
					$profitnew = 0;
					//profit end
					$output1 .='"'.$profitnew.'",';

					//loss start
					$lossnew = 0;
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
					if ($totalamount==0) {
						$lossnew = 0;
					}
					$loss = (($result->bonus+$totalamount) - ($result->balance+$result->winning));
					if($loss > 0)
					$lossnew = round($loss,2);
					else
					$lossnew = 0;
					//loss end

					$output1 .='"'.$lossnew.'",';

					$output1 .="\n";
				}
			}
			$filename =  "Details-userwallet.csv";
			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);
			echo $output1;
			exit;
		}

	}//End Function

	//User Balance DETAIL
	public function view_profit_loss_new(Request $req){
		//Get Post Data
		$formData = Input::all();
		if ($req->ismethod('post')) {

			if(isset($formData) && !empty($formData)){
				return Datatables::of(DB::table('listmatches')
				->join('series as s','s.id','=','listmatches.series')
				->join('leaugestransactions as lt','lt.matchkey','=','listmatches.matchkey')
				->leftJoin('refunds', function($join)
				{
					// $join->on('refunds.userid', '!=', 'lt.user_id');
					$join->on('refunds.joinid', '=', 'lt.joinid')
					// $join->on('refunds.challengeid', '!=', 'lt.challengeid');
					// $join->on('refunds.matchkey', '!=', 'lt.matchkey');
				->whereNotIn('refunds.reason',['Winning reversed']);
				})
				->whereNull('refunds.joinid')

				->where('listmatches.launch_status','launched')
				->where('listmatches.final_status','winnerdeclared')
				->select('listmatches.*','s.name as series_name')
				->selectRaw('sum(lt.bonus) as bonus')
				->selectRaw('sum(lt.coins) as gstbonus')
				->selectRaw('sum(lt.winning) as winning')
				->selectRaw('sum(lt.balance) as balance')
				// ->where(function ($query) use ($formData) {
				// 	 if (isset($formData['filter_columns'])) {
				// 		 if (isset($formData['filter_columns']['filter_date'])) {
				// 		 	$query->where('listmatches.start_date', 'like', '%'.$formData['filter_columns']['filter_date'].'%');
				// 		 }
				// 	 }
				// })
				->where(function ($query) use ($formData) {
					if (!empty($formData['start_date']) || !empty($formData['end_date']) ) {
						if(@$formData['start_date'] != "")
						$query->where("listmatches.start_date",'>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])) );
						if(@$formData['end_date'] != "")
						$query->where("listmatches.start_date",'<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])) );
					}
				})
				->orderBy('listmatches.start_date', 'DESC')
				->groupBy('lt.matchkey')
				//->limit(500)
				->get())
				->addIndexColumn()
				->addColumn('sports',function ($result){
					$sportType = '';
					if($result->sport_type == '1'){
						$sportType = 'CRICKET';
					}
					if($result->sport_type == '2'){
						$sportType = 'FOOTBALL';
					}
					if($result->sport_type == '3'){
						$sportType = 'BASKETBALL';
					}
					if($result->sport_type == '7'){
						$sportType = 'KABADDI';
					}
					return $sportType;
				})
				->addColumn('winning',function($result){
					return round($result->winning,2);
				})
				->addColumn('balance',function($result){
					return round($result->balance,2);
				})
				->addColumn('bonus',function($result){
					return round($result->bonus,2);
				})
				->addColumn('gstbonus',function($result){
					return round($result->gstbonus,2);
				})
				// ->addColumn('amount',function($result){
				// 	$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
				// 	return round($totalamount,2);
				// })
				->addColumn('total_winning',function($result){
					return round(($result->balance+$result->winning),2);
				})
				->addColumn('total_distributed',function($result){
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
				//return round(($result->bonus+$totalamount),2);
				//	return round(($result->bonus+$result->gstbonus+$totalamount),2);
					return round(($totalamount),2);
				})
				->addColumn('giveaway_amount',function($result){
					$userid=	DB::table('registerusers')->where('is_bot',1)->select('id')->pluck('id');
					$giveawayamount=	DB::table('finalresults')->where('matchkey',$result->matchkey)->whereIn('userid',$userid)	->select('amount')
						->sum('amount');
					return 	number_format($giveawayamount,2);
				})
				->addColumn('affiliation_commission',function($result)
				{
				$challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');

					// $affiliationTotalamount=	DB::table('finalresults')
					// 			->Join('league_refer_bonus','league_refer_bonus.challenge_id','=','finalresults.challengeid')
					// 			//->leftJoin('transactions','transactions.challengeid','=','finalresults.challengeid')
					// 				->where('finalresults.matchkey',$result->matchkey)
					// 				//->where('transactions.type','Affiliation Commission')
					// 				->select('league_refer_bonus.amount')
					// 				->sum('league_refer_bonus.amount');
					$affiliationTotalamount=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
						->sum('league_refer_bonus.amount');
					return 	number_format($affiliationTotalamount,2);
				})
				->addColumn('profit',function($result){
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');

					if ($totalamount==0) {
						return 0;
					}
							// $totalaffiliate=	DB::table('finalresults')
							// 			->Join('league_refer_bonus','league_refer_bonus.challenge_id','=','finalresults.challengeid')
							// 				->where('finalresults.matchkey',$result->matchkey)
							// 				->select('league_refer_bonus.amount')
							// 				->sum('league_refer_bonus.amount');
						$challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
						$totalaffiliate=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
								->sum('league_refer_bonus.amount');
					//$profit = (($result->balance+$result->winning) - ($totalamount));
					$profit = (($result->balance+$result->winning) - ($totalamount)-$totalaffiliate);
					if($profit > 0)
					return  round($profit,2);
					else
					return 0;
				})
				->addColumn('loss',function($result){
					$challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
				$totalaffiliate=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
						->sum('league_refer_bonus.amount');
					$totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
					if ($totalamount==0) {
						return 0;
					}
				//	$loss = (($totalamount) - ($result->balance+$result->winning));
					$loss = (($totalamount+$totalaffiliate) - ($result->balance+$result->winning));
					if($loss > 0)
					return round($loss,2);
					else
					 return 0;
			//	return round($loss,2);
				})

				->escapeColumns([])
				->make(true);
			}//end
		}

		return view("admin.$this->model.view_profit_loss_new");
	}//End Function

 public function view_profit_report(Request $request)
 {
   	  if ($request->isMethod('post')) {
         $formData = Input::all();

         $columns = array(
             0 => 'id',
             1 => 'sport_name',
             2 => 'series_name',
             3 => 'name',
             4 => 'matchkey',
             5 => 'start_date',
             6 => 'winning',
             7 => 'balance',
             8 => 'gst_bonus',
             9 => 'affiliation',
             10 => 'bonus',
             11 => 'refund',
             12 => 'total_investment',
             13 => 'total_investment_after_rebate_bonus',
             14 => 'distribution',
             15 => 'giveaway',
             16 => 'affiliation_commission',
             17 => 'profit',
             18 => 'loss',
              );

           $limit = $request->input('length');
          $start = $request->input('start');
          $order = $columns[$request->input('order.0.column')];
          $dir = $request->input('order.0.dir');

           $query=  DB::table('listmatches')
                ->join('series as s','s.id','=','listmatches.series')
                ->join('sport_types as sp','sp.id','=','listmatches.sport_type')
                ->join('leaugestransactions as lt','lt.matchkey','=','listmatches.matchkey')
                ->leftJoin('refunds', function($join)
                {
                  // $join->on('refunds.userid', '!=', 'lt.user_id');
                  $join->on('refunds.joinid', '=', 'lt.joinid')
                  // $join->on('refunds.challengeid', '!=', 'lt.challengeid');
                  // $join->on('refunds.matchkey', '!=', 'lt.matchkey');
                ->whereNotIn('refunds.reason',['Winning reversed']);
                })
                ->whereNull('refunds.joinid')

                ->where('listmatches.launch_status','launched')
                ->where('listmatches.final_status','winnerdeclared')
                ->select('listmatches.*','s.name as series_name','sp.sport_name','listmatches.short_name as name')
                ->selectRaw('sum(lt.bonus) as bonus')
                ->selectRaw('sum(lt.gst_bonus) as gst_bonus')
                ->selectRaw('sum(lt.winning) as winning')
                ->selectRaw('sum(lt.balance) as balance')
                ->selectRaw('sum(lt.affiliation_commission) as affiliation')
                 ->where(function ($query) use ($formData) {
                   if (isset($formData['filter_columns'])) {

                     if (isset($formData['filter_columns']['filter_sports'])) {

                       $query->where('sp.sport_name', 'like', '%'.$formData['filter_columns']['filter_sports'].'%');
                     }

                     if (isset($formData['filter_columns']['filter_series'])) {
                       $query->where('listmatches.season', 'like', '%'.$formData['filter_columns']['filter_series'].'%');
                     }
                     if (isset($formData['filter_columns']['filter_name'])) {
                       $query->where('listmatches.name', 'like', '%'.$formData['filter_columns']['filter_name'].'%');
                     }
                     if (isset($formData['filter_columns']['filter_matchkey'])) {
                       $query->where('listmatches.matchkey', 'like', '%'.$formData['filter_columns']['filter_matchkey'].'%');
                     }
                    if (isset($formData['filter_columns']['filter_date'])) {
                      $query->where('listmatches.start_date', 'like', '%'.$formData['filter_columns']['filter_date'].'%');
                    }
                   }
                 })

                ->where(function ($query) use ($formData) {

                  if (!empty($formData['start_date']) || !empty($formData['end_date']) ) {
                    if(@$formData['start_date'] != "")
                    $query->where("listmatches.start_date",'>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])) );
                    if(@$formData['end_date'] != "")
                    $query->where("listmatches.start_date",'<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])) );
                  }
                });
              $query->groupBy('lt.matchkey');
             $totalTitles = $query->get()->count();

             $totalFiltered = $totalTitles;
              if(empty($start))
             {
             $start=0;
             }
             $titles = $query->offset($start)
             ->limit($limit)
             ->orderBy($order, $dir)
             ->get();
           $data = array();
           if (!empty($titles)) {
              $count = 1;
              foreach ($titles as $result) {
                  $sportType = '';
                  if($result->sport_type == '1'){
                    $sportType = 'CRICKET';
                  }
                  if($result->sport_type == '2'){
                    $sportType = 'FOOTBALL';
                  }
                  if($result->sport_type == '3'){
                    $sportType = 'BASKETBALL';
                  }
                  if($result->sport_type == '7'){
                    $sportType = 'KABADDI';
                  }

              $totalrefundamount= DB::table('refunds')->where('matchkey',$result->matchkey)->sum('amount');

              $total_investment= round(($result->balance+$result->winning+$result->bonus+$result->gst_bonus+$result->affiliation),2);
                $investmet_after_rebate= round(($result->balance+$result->winning+$result->affiliation),2);



                  $totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
                  $total_distributed= round(($totalamount),2);


                  $userid=	DB::table('registerusers')->where('is_bot',1)->select('id')->pluck('id');
                  $giveawayamount=	DB::table('finalresults')->where('matchkey',$result->matchkey)->whereIn('userid',$userid)	->select('amount')
                    ->sum('amount');
               $giveawayamountuser= number_format($giveawayamount,2);


                $challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');

                  $affiliationTotalamount=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
                    ->sum('league_refer_bonus.amount');
                 $affiliation_commission= 	number_format($affiliationTotalamount,2);


                  $totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');

                  if ($totalamount==0) {
                    $profitamount= 0;
                  }

                    // $challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
                    $totalaffiliate=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
                        ->sum('league_refer_bonus.amount');

                   $profit = (($result->balance+$result->winning+$result->affiliation) - ($totalamount)-$totalaffiliate);
                  if($profit > 0){
                  $profitamount= round($profit,2);
                  }
                  else{
                    $profitamount= 0;
                  }

              // $challangeid=	DB::table('finalresults')->where('matchkey',$result->matchkey)->select('challengeid')->pluck('challengeid');
                $totalaffiliate=	DB::table('league_refer_bonus')->whereIn('challenge_id',$challangeid)	->select('league_refer_bonus.amount')
                    ->sum('league_refer_bonus.amount');
                  $totalamount = DB::table('finalresults')->where('matchkey',$result->matchkey)->sum('amount');
                  if ($totalamount==0) {
                     $lossamount= 0;
                  }
                //	$loss = (($totalamount) - ($result->balance+$result->winning));
                 // $loss = (($totalamount+$totalaffiliate) - ($result->balance+$result->winning));
                $loss = ($totalamount+$totalaffiliate)-($result->balance+$result->winning+$result->affiliation);
                  if($loss > 0){
                  $lossamount= round($loss,2);
                  }
                  else{
                   $lossamount= 0;
                  }

                    $nestedData['id'] = $count;
                    $nestedData['sport_name'] =  $sportType;
                    $nestedData['series_name'] = $result->series_name;
                    $nestedData['name'] = $result->name;
                    $nestedData['matchkey'] =  $result->matchkey;
                    $nestedData['start_date'] = $result->start_date;
                    $nestedData['winning'] =  number_format($result->winning,2);
                    $nestedData['balance'] = number_format($result->balance,2);
                    $nestedData['gst_bonus'] = number_format($result->gst_bonus,2);
                    $nestedData['affiliation'] = number_format($result->affiliation,2);
                    $nestedData['bonus'] = number_format($result->bonus,2);
                    $nestedData['refund'] = $totalrefundamount;
                    // $nestedData['refund'] = $totalrefundamount. ' - <a href="#"> Refund List</a>';
                    $nestedData['total_investment'] = $total_investment;
                    $nestedData['total_investment_after_rebate_bonus'] = $investmet_after_rebate;
                    $nestedData['distribution'] = $total_distributed;
                    $nestedData['giveaway'] = $giveawayamountuser;
                    $nestedData['affiliation_commission'] = $affiliation_commission;
                    $nestedData['profit'] = $profitamount;
                    $nestedData['loss'] = $lossamount;
                    $data[] = $nestedData;
                    $count++;
                 }
            }

            $json_data = array(
               "draw" => intval($request->input('draw')),
               "recordsTotal" => intval($totalFiltered),
               "recordsFiltered" => intval($totalFiltered),
               "data" => $data,
            );
            echo json_encode($json_data);
            exit;
    }

		return view("admin.$this->model.view_profit_report");
}

}//End Class
