<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Model\Registerusers;
// use App\Model\ReferralBonus;
use App\ReferralBonus;
use App\RegisterUser;
use App\UserBalance;
use CfPayout;
use Illuminate\Support\Facades\Storage;
use App\Transaction;
use App\Model\Setting;
use App\libraries\CustomHelper;
use App\Helpers\Helpers;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;



date_default_timezone_set("Asia/Kolkata");
class RegisterusersController extends Controller
{

    /*
  * Function for display email detail from database
  *
  * @param null
  *
  * @return view page.
  */
    public $model    =    'Registerusers';

    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function




    public function update_is_royal_exists()
    {
        exit;
    }


    public function ultimate_to_royal_newuser()
    {
        exit;
    }


    //manual withdraw
    public function manual_withdraw_amount_bank(Request $request)
    {
        //Get Post Data
        $formData = Input::all();
        // dd($request);
        if (isset($formData) && !empty($formData)) {
            $manual_withdraw_data = DB::table('withdraw as w')
                ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                ->leftJoin('bank as b', 'b.userid', '=', 'r.id')
                ->leftJoin('pancard as pn', 'pn.userid', '=', 'r.id')
                ->select(
                    'r.*',
                    'b.*',
                    'pn.*',
                    'w.*',
                    'r.id as reg_id',
                    'w.id as withdraw_id',
                    'r.activation_status as reg_status',
                    'w.status as withdraw_status',
                    'w.amount as withdraw_amount',
                    'w.created as withdraw_request'
                )
                ->groupBy('w.id')
                ->where('type', 'bank')
                ->where('is_instant', 0)
                ->where('is_manual_withdraw', 1)
                //  ->orderByRaw("w.status=22,w.status ASC, w.id DESC");
                ->orderBy("w.id", "DESC");
            if (!empty($formData['type'])) {

                $status = ($formData['type'] == 'pending') ? 0 : $formData['type'];
                $manual_withdraw_data->where('w.status', $status);
            } else {
                $manual_withdraw_data->where('w.status', 0);
            }
            $manual_withdraw = $manual_withdraw_data->get();
            if (!empty($request->download)) {
                if (count($manual_withdraw) == 0) {
                    return Redirect::back()->withError("No data found");
                }
                ini_set('memory_limit', '-1');

                //  $fileName = 'Bank-withdraw-request'.date("YmdHis", time());
                $fileName = 'Bank-withdraw-request' . rand(100, 9999);
                header('Content-Encoding: UTF-8');
                header("Content-type:application/vnd.ms-excel;charset=UTF-8");
                header('Content-Disposition: attachment;filename="' . $fileName . '.csv"');

                $tableheader = array(
                    'A' => 'Benificiary Name',
                    'B' => 'Benificiary Account number',
                    'C' => 'IFSC Code',
                    'D' => 'Amount',
                    'E' => 'Description/Purpose',
                );

                $fp = fopen('php://output', 'a');
                fputcsv($fp, $tableheader);
                $loopcount = ceil(count($manual_withdraw) / 10000);

                for ($i = 0; $i < $loopcount; $i++) {
                    $query = $manual_withdraw;

                    if (!$query->isEmpty()) {
                        foreach ($query as $key => $value) {
                            $withdraw_manually_status = '';
                            if ($value->withdraw_status == 0) {
                                $withdraw_manually_status .= "Pending";
                            }
                            if ($value->status == 1) {
                                $withdraw_manually_status .= "Approved";
                            }

                            if ($value->withdraw_status == 22) {
                                $withdraw_manually_status .= "Pending";
                            }
                            $csv = [];
                            $csv['Benificiary Name'] = $value->username;
                            $csv['Benificiary Account Number'] = $value->accno;
                            $csv['IFSC'] = $value->ifsc;
                            $csv['Amount'] = $value->amount;
                            $csv['Errors'] = '-';
                            fputcsv($fp, $csv);
                        }
                    }
                    ob_flush();
                    flush();
                }
                ob_end_clean();
                exit();
            }
            return Datatables::of($manual_withdraw)
                ->addColumn('#', function ($result) {
                    return "<input type='checkbox' id='checkBefore' name='withdrawId[]' value='$result->withdraw_id'>";
                })
                ->addIndexColumn()
                ->addColumn('username', function ($result) {
                    return $result->username;
                })
                ->addColumn('email', function ($result) {
                    return $result->email;
                })
                ->addColumn('mobile', function ($result) {
                    return $result->mobile;
                })
                ->addColumn('pan', function ($result) {
                    return $result->pan_number;
                })
                ->addColumn('bankname', function ($result) {
                    return $result->bankname;
                })
                ->addColumn('bankbranch', function ($result) {
                    return $result->bankbranch;
                })
                ->addColumn('ifsc', function ($result) {
                    return $result->ifsc;
                })
                ->addColumn('accno', function ($result) {
                    return $result->accno;
                })
                ->addColumn('withdraw_amount', function ($result) {
                    return $result->amount;
                })
                ->addColumn('withdraw_request_id', function ($result) {
                    return $result->withdraw_request_id;
                })
                ->addColumn('withdraw_status', function ($result) {
                    $withdraw_manually_status = '';
                    if ($result->withdraw_status == 0) {
                        return '<form class="form-horizontal form-label-left"  action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
                      ' . csrf_field() . '
                      <input type="text" class="form-control text-comment" name="comment">
                      <input type="hidden" name="id" value="' . $result->withdraw_id . '">
                      <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="manual">
                      <input type="hidden" name="uid" value="' . $result->reg_id . '">
                      <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
                      <button class="btn btn-info admin-comment" data-type="approve" name="type" value="approve" style="color:#000;margin-top:3px;">Approve</button>
                      <button class="btn btn-info admin-comment" data-type="reject" name="type" value="reject" style="color:#000;margin-top:3px;">Reject</button>
                      </form>';
                        //$withdraw_manually_status .= "<label class='success_icn'>Pending</label>";
                    }
                    if ($result->withdraw_status == 1) {
                        $withdraw_manually_status .= "<label class='success_icn '>Approved</label>";
                    }
                    if ($result->withdraw_status == 2) {
                        $withdraw_manually_status .= "<label class='success_icn'>Rejected</label>";
                    }
                    return $withdraw_manually_status;
                })
                ->addColumn('comment', function ($result) {
                    return $result->comment;
                })
                ->addColumn('withdraw_request', function ($result) {
                    return date('d-M-Y', strtotime($result->created));
                })
                ->addColumn('approved_date', function ($result) {
                    if (!empty($result->approved_date)) {
                        return date('d-M-Y', strtotime($result->approved_date));
                    } else {
                        return '--';
                    }
                })
                // ->addColumn('action',function ( $result){
                //   if(isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)){
                //     $joinedleauges_link='<a href="'.route($this->model.'.join_leauges',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="Joined Leagues" class="btn btn-primary mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                //   }else{
                //     $joinedleauges_link='';
                //   }//End Function
                //   return '<a href="'.route($this->model.'.view_user',base64_encode(serialize($result->reg_id))).'" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View" ></i></a>'
                //   .'<a href="'.route($this->model.'.bank_old_withdraw',base64_encode(serialize($result->reg_id))).'" data-toggle="tooltip" title="Withdrawal History" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-history"></i></a>'
                //   .$joinedleauges_link;
                // })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.manual_withdraw_amount_bank");
    } //End Function


    // end admin bank comment request form function
    public function admin_comment_bank_withdraw_multi(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            // dd($input);
            if (empty($input['withdrawId'])) {
                Session::flash('message', 'Please select any user');
                Session::flash('alert-class', 'alert-danger');
                return Redirect::back();
            } else {
                if ($input['type'] == 'rejected') {
                    $this->reject_manualy($request);
                }
                if ($input['type'] == 'approved') {
                    $this->approve_bank_manualy($request);
                }
            }
            return Redirect::back();
        }
    }



    public function ultimate_to_royal_existuser()
    {
        $ultimateBalance = array();
        $ultimateBalance = DB::table('ultimate11_userbalances as ulti_balance')
            ->join('ultimate11_registerusers as ulti_user', 'ulti_user.id', '=', 'ulti_balance.user_id')
            // ->join('registerusers as royal','royal.email','=','ulti_user.email')

            ->where('ulti_user.is_royal_exists', 1)
            ->where('ulti_user.is_yoububer', 0)
            ->where('ulti_user.is_merge', 0)
            ->select('ulti_balance.*', 'ulti_user.email', 'ulti_user.id as regid')
            ->limit(100)
            ->get();
        // var_dump($ultimateBalance);exit;
        $i = 0;
        foreach ($ultimateBalance as $key => $balance) {
            $data = array();
            $royal_balance = array();
            $royalData =   DB::table('registerusers')->where('email', $balance->email)->select('id')->first();

            $royal_balance = DB::table('userbalances')->where('user_id', $royalData->id)->first();
            if (!empty($royal_balance)) {
                $data['balance'] = $royal_balance->balance + $balance->balance;
                $data['winning'] = $royal_balance->winning + $balance->winning;
                $data['bonus'] = $royal_balance->bonus + $balance->bonus;
                DB::table('userbalances')->where('user_id', $royal_balance->user_id)->update($data);
            } else {
                $dataInsert['balance'] =  $balance->balance;
                $dataInsert['winning'] =  $balance->winning;
                $dataInsert['bonus'] =  $balance->bonus;
                $dataInsert['user_id'] = $royalData->id;
                DB::table('userbalances')->insert($dataInsert);
            }
            $updateDone = $royalData->id;

            if ($balance->balance != 0) {
                $datatr['transaction_id'] = BRAND['name'] . '-TRANSFER-' . rand(100, 999) . $updateDone;
                $datatr['type'] = 'Adjusted Ultimate11 Deposit Amount';
                $datatr['transaction_by'] = BRAND['name'];
                $datatr['amount'] = $balance->balance;
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['bonus_amt'] = $balance->bonus;
                $datatr['win_amt'] = $balance->winning;
                $datatr['addfund_amt'] = $balance->balance;
                $datatr['userid'] = $updateDone;
                $datatr['total_available_amt'] = $balance->balance + $balance->winning + $balance->bonus;
                DB::table('transactions')->insert($datatr);
            }
            if ($balance->winning != 0) {
                $datatr['transaction_id'] = BRAND['name'] . '-TRANSFER-' . rand(100, 999) . $updateDone;
                $datatr['type'] = 'Adjusted Ultimate11 Winning Amount';
                $datatr['transaction_by'] = BRAND['name'];
                $datatr['amount'] = $balance->winning;
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['bonus_amt'] = $balance->bonus;
                $datatr['win_amt'] = $balance->winning;
                $datatr['addfund_amt'] = $balance->balance;
                $datatr['userid'] = $updateDone;
                $datatr['total_available_amt'] = $balance->balance + $balance->winning + $balance->bonus;
                DB::table('transactions')->insert($datatr);
            }
            if ($balance->bonus != 0) {
                $datatr['transaction_id'] = BRAND['name'] . '-TRANSFER-' . rand(100, 999) . $updateDone;
                $datatr['type'] = 'Adjusted Ultimate11 Bonus Amount';
                $datatr['transaction_by'] = BRAND['name'];
                $datatr['amount'] = $balance->bonus;
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['bonus_amt'] = $balance->bonus;
                $datatr['win_amt'] = $balance->winning;
                $datatr['addfund_amt'] = $balance->balance;
                $datatr['userid'] = $updateDone;
                $datatr['total_available_amt'] = $balance->balance + $balance->winning + $balance->bonus;
                DB::table('transactions')->insert($datatr);
            }



            $mergeStatus['is_merge'] = 1;
            $regMerge['is_ultimate11_user'] = 1;
            DB::table('registerusers')->where('id', $royalData->id)->update($regMerge);
            DB::table('ultimate11_registerusers')->where('id', $balance->regid)->update($mergeStatus);
            $i++;
            // }
        }
        echo $i . 'Records Balance Updated in ' . BRAND['name'];
        exit;
    }


    public function deactivateusers(Request $req)
    {
        if ($req->isMethod('post')) {
            if (!empty($req->userid)) {
                $userdata = explode(',', $req->userid);

                $user =  DB::table('registerusers as r')
                    ->where('user_block', 0)
                    ->whereIN('id', $userdata)->update(['activation_status' => 'activated']);
                Session::flash('flash_notice', 'User Activated successfully');
                Session::flash('alert-class', 'alert-success');
                return redirect()->to('admin/registerusers/all-deactivateusers');
            } else {

                Session::flash('alert-class', 'alert-danger');
                Session::flash('error', 'Please select checkbox after submit');
                return redirect()->to('admin/registerusers/all-deactivateusers');
            }
        }
    }

    public function viewblockusers(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            // echo '<pre>'; print_r($formData['search']['value'] ); die();
            if (!empty($formData['search']['value'])) {
                $limit = 100000000;
            } else {
                $limit = 1000;
            }


            return Datatables::of(DB::table('registerusers as r')
                ->where('r.is_bot', 0)
                ->where('r.user_block', 1)
                ->where(function ($query) use ($formData) {
                    if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                        $query->limit(1000000);
                    } else {

                        $query->limit(500);
                    }
                })
                ->limit($limit)
                ->groupBy('r.id')
                ->select('r.id', 'r.email', 'r.mobile', 'r.team', 'r.team', 'r.team', 'r.mobile_verify', 'r.email_verify', 'r.pan_verify', 'r.aadhar_verify', 'r.bank_verify', 'r.is_yoububer', 'r.activation_status')

                ->where(function ($query) use ($formData) {
                    if (isset($formData['users_type']) && !empty($formData['users_type'])) {
                        if ($formData['users_type'] == 'active') {
                            $query->where('r.activation_status', '=', 'activated');
                        }
                        if ($formData['users_type'] == 'deactive') {
                            $query->where('r.activation_status', '=', 'deactivated');
                        }
                        if ($formData['users_type'] == 'youtuber') {
                            $query->where('r.is_yoububer', '=', 1);
                        }
                    }
                })
                ->where(function ($query) use ($formData) {
                    if (isset($formData['filter_columns'])) {

                        if (isset($formData['filter_columns']['filter_teamname'])) {
                            $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_mobile'])) {
                            $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                        }
                    }
                    //$query->limit(100);
                })
                ->orderBy('id', 'DESC')->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" class="" style="text-decoration:underline;">' . @$result->id . '</a>';
                })
                ->addColumn('checkselect', function ($result) {
                    return "<input type='checkbox' name='user_id' class='singleselect' value=" . @$result->id . ">";
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->email . '</a>';
                })
                ->addColumn('mobile_verify', function ($result) {
                    $mobileverify = '';
                    if ($result->mobile_verify == 0) {
                        $mobileverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->mobile_verify == 1) {
                        $mobileverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $mobileverify;
                })
                ->addColumn('email_verify', function ($result) {
                    $emailverify = '';
                    if ($result->email_verify == 0) {
                        $emailverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->email_verify == 1) {
                        $emailverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $emailverify;
                })
                //class="badge badge-success"
                ->addColumn('aadhar_verify', function ($result) {
                    $aadarverify    = '';
                    if ($result->aadhar_verify == 0) {
                        $aadarverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->aadhar_verify == 1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->aadhar_verify == -1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $aadarverify;
                })
                ->addColumn('pan_verify', function ($result) {
                    $panverify = '';
                    if ($result->pan_verify == 0) {
                        $panverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->pan_verify == 1) {
                        $panverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->pan_verify == -1) {
                        $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $panverify;
                })
                ->addColumn('bank_verify', function ($result) {
                    $bankverify = '';
                    if ($result->bank_verify == 0) {
                        $bankverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->bank_verify == 1) {
                        $bankverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->bank_verify == -1) {
                        $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $bankverify;
                })

                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize(@$result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="javascript:void(0);" class="user-deactivate-button" data-toggle="modal"  data-user-id="' . @$result->id . '"><button class="btn btn-danger"><i class="fa fa-ban"></i></button></a>&ensp;';
                    }

                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . @$result->id . '" data-status="' . @$result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-info mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }


                    if (1) {

                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '<a href="' . route(@$this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    }
                    $wallethistory_day_wise = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a>';


                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'

                        . $transactions_link
                        . $activation_status
                        . $is_youtuber
                        . $wallethistory_day_wise;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        $totaluser = DB::table('registerusers as r')
            ->where('r.user_block', 1)->count();
        return view("admin.$this->model.viewblockusers", compact('totaluser'));
    } //End if


    public function unblockusers(Request $req)
    {
        if ($req->isMethod('post')) {
            if (!empty($req->userid)) {
                $userdata = explode(',', $req->userid);
                $user =  DB::table('registerusers as r')
                    ->where('user_block', 1)
                    ->whereIN('id', $userdata)->update(['user_block' => 0]);
                Session::flash('flash_notice', 'User account unblock successfully');
                Session::flash('alert-class', 'alert-success');
                return redirect()->to('admin/registerusers/all-blockusers');
            } else {

                Session::flash('alert-class', 'alert-danger');
                Session::flash('error', 'Please select checkbox after submit');
                return redirect()->to('admin/registerusers/all-blockusers');
            }
        }
    }

    //Freez account

    public function freez_user_status(Request $req)
    {
        $input['status'] = 1;
        $user = DB::table('user_account_freez')->where('user_id', $req->user_id)->first();
        if (!empty($user)) {
            DB::table('user_account_freez')->where('id', $req->user_id)->update($input);
        } else {
            $freez = array('user_id' => $req->user_id, 'status' => $input['status']);
            DB::table('user_account_freez')->insert($freez);
        }
        Session::flash('flash_notice', 'User Account Freez successfully!');
        return Redirect::back();
    } //End Function

    public function updatefreezuserstatus($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['user_id'] = $id;
        $input['status'] = $status;

        DB::table('user_account_freez')->where('user_id', $id)->update($input);
        Session::flash('flash_notice', 'User Account UnFreez successfully!');
        return Redirect::back();
    } //End Function

    public function block_user_status(Request $req)
    {
        $input['user_block'] = 1;
        DB::table('registerusers')->where('id', $req->user_id)->update($input);
        Session::flash('flash_notice', 'User Block successfully!');
        return Redirect::back();
    } //End Function

    public function updateblocuserstatus($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['user_block'] = $status;

        DB::table('registerusers')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'User Unblock successfully!');
        return Redirect::back();
    } //End
    public function viewdeactivateusers(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            // echo '<pre>'; print_r($req->all()); die();
            if (!empty($formData['search']['value'])) {
                $limit = 100000000;
            } else {
                $limit = 1000;
            }

            if (!empty($req->start_date) && !empty($req->end_date)) {
                $limit = 100000;
            }

            return Datatables::of(DB::table('registerusers as r')
                ->where('r.is_bot', 0)
                ->where('r.activation_status', 'deactivated')
                //->where('r.email','!=',null)

                ->where(function ($query) use ($formData) {
                    if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                        $query->limit(1000000);
                    } else {

                        $query->limit(500);
                    }
                })
                ->limit($limit)
                ->groupBy('r.id')
                ->select('r.id', 'r.email', 'r.mobile', 'r.team', 'r.team', 'r.team', 'r.mobile_verify', 'r.email_verify', 'r.pan_verify', 'r.aadhar_verify', 'r.bank_verify', 'r.is_yoububer', 'r.activation_status', 'r.user_block')
                ->where(function ($query) use ($formData) {
                    if (isset($formData['users_type']) && !empty($formData['users_type'])) {
                        if ($formData['users_type'] == 'active') {
                            $query->where('r.activation_status', '=', 'activated');
                        }
                        if ($formData['users_type'] == 'deactive') {
                            $query->where('r.activation_status', '=', 'deactivated');
                        }
                        if ($formData['users_type'] == 'youtuber') {
                            $query->where('r.is_yoububer', '=', 1);
                        }
                    }
                })
                ->where(function ($query) use ($formData, $req) {
                    if (!empty($req->start_date)) {
                        $query->where('r.created_at', '>=', $req->start_date);
                    }
                    if (!empty($req->end_date)) {
                        $query->where('r.created_at', '<=', $req->end_date);
                    }
                })



                ->where(function ($query) use ($formData) {
                    if (isset($formData['filter_columns'])) {

                        if (isset($formData['filter_columns']['filter_teamname'])) {
                            $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_mobile'])) {
                            $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                        }
                    }
                    //$query->limit(100);
                })
                ->orderBy('id', 'DESC')->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" class="" style="text-decoration:underline;">' . @$result->id . '</a>';
                })
                ->addColumn('checkselect', function ($result) {
                    return "<input type='checkbox' name='user_id' class='singleselect' value=" . @$result->id . ">";
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->email . '</a>';
                })
                ->addColumn('mobile_verify', function ($result) {
                    $mobileverify = '';
                    if ($result->mobile_verify == 0) {
                        $mobileverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->mobile_verify == 1) {
                        $mobileverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $mobileverify;
                })
                ->addColumn('email_verify', function ($result) {
                    $emailverify = '';
                    if ($result->email_verify == 0) {
                        $emailverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->email_verify == 1) {
                        $emailverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $emailverify;
                })
                //class="badge badge-success"
                ->addColumn('aadhar_verify', function ($result) {
                    $aadarverify    = '';
                    if ($result->aadhar_verify == 0) {
                        $aadarverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->aadhar_verify == 1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->aadhar_verify == -1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $aadarverify;
                })
                ->addColumn('pan_verify', function ($result) {
                    $panverify = '';
                    if ($result->pan_verify == 0) {
                        $panverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->pan_verify == 1) {
                        $panverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->pan_verify == -1) {
                        $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $panverify;
                })
                ->addColumn('bank_verify', function ($result) {
                    $bankverify = '';
                    if ($result->bank_verify == 0) {
                        $bankverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->bank_verify == 1) {
                        $bankverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->bank_verify == -1) {
                        $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $bankverify;
                })

                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    $block_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize(@$result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="javascript:void(0);" class="user-deactivate-button" data-toggle="modal"  data-user-id="' . @$result->id . '"><button class="btn btn-danger"><i class="fa fa-ban"></i></button></a>&ensp;';
                    }
                    if ($result->user_block == '1') {
                        $block_status = '<a href="' . route($this->model . '.block_updateuser_status', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Unblock" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $block_status = '<a href="javascript:void(0);" class="user-block-button" data-toggle="modal" title="Block"  data-user-id="' . @$result->id . '"><button class="btn btn-dark"><i class="fa fa-user-times" aria-hidden="true"></i></button></a>&ensp;';
                    }

                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . @$result->id . '" data-status="' . @$result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-info mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }


                    if (1) {

                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '<a href="' . route(@$this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    }
                    $wallethistory_day_wise = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a>';
                    $account = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_delete_permanent', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="User Delete" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1 delete_user_permanent" data-original-title="User Transactions">Account Delete </a>';

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'

                        . $transactions_link
                        . $activation_status
                        . $block_status
                        . $is_youtuber
                        . $wallethistory_day_wise
                        . $account;
                })
                ->escapeColumns([])
                ->make(true);
        } //end



        $totaluser = DB::table('registerusers as r')
            ->where('r.activation_status', 'deactivated')->count();
        return view("admin.$this->model.viewdeactivateusers", compact('totaluser'));
    } //End if

    public function viewregisterusers(Request $req)
    {
      // echo "string";die;

        $result =  DB::table('registerusers as r')
            ->leftJoin('userbalances as ub', 'ub.user_id', '=', 'r.id')
            ->leftJoin('withdraw as w', 'w.user_id', '=', 'r.id')
            // ->leftJoin('transactions as t','t.userid','=','r.id')
            ->leftJoin('joinedleauges as jl', 'jl.userid', '=', 'r.id')
            ->leftJoin('jointeam as jt', 'jt.userid', '=', 'r.id')
            //  ->limit(1000)
            ->groupBy('r.id')
            //->where('is_yoububer','0')
            ->select('r.*', 'ub.id as userbalances_id', 'ub.balance', 'ub.winning', 'ub.bonus', 'w.id  as withdraw_id', 'jl.id as joinedleauges_id', 'jt.id as jointeam_id', 'ub.user_id as userid')
            ->get();
        // echo '<pre>'; print_r($result);exit;
        // echo "string";die;
        if ($req->isMethod('post')) {
            $formData = Input::all();
            // echo '<pre>'; print_r($formData['search']['value'] ); die();
            if (!empty($formData['search']['value'])) {
                $limit = 100000000;
            } else {
                $limit = 1000;
            }
            // if(isset($formData) && !empty($formData)){
            // 	$where_condition = ''; $where_operation = ''; $where_value = '';
            // 	if($formData['users_type'] == 'active'){
            // 		$where_condition = "r.activation_status";
            // 		$where_operation = "=";
            // 		$where_value = "activated";
            // 	}
            // 	elseif ($formData['users_type'] == 'deactive'){
            // 		$where_condition = "r.activation_status";
            // 		$where_operation = "=";
            // 		$where_value = "deactivated";
            // 	}
            // 	elseif ($formData['users_type'] == 'youtuber'){
            // 		$where_condition = "r.is_yoububer";
            // 		$where_operation = "=";
            // 		$where_value = "1";
            // 	}
            // 	else {
            // 		$where_condition = "r.email";
            // 		 $where_condition1 ="r.mobile";
            // 		  $where_condition2 ="r.team";
            // 		$where_operation = "LIKE";
            // 		$where_value = '%'.$formData['search']['value'].'%';
            // 		// echo $where_value; exit;
            // 	}


            //echo $where;die;

            /*$data = DB::table('registerusers as r')
      ->leftJoin('userbalances as ub','ub.user_id','=','r.id')
      ->leftJoin('withdraw as w','w.user_id','=','r.id')
      ->leftJoin('transactions as t','t.userid','=','r.id')
      ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
      ->leftJoin('jointeam as jt','jt.userid','=','r.id')
      ->limit(10)
      ->groupBy('r.id')
      //->where('is_yoububer','0')
      ->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','t.id as transactions_id','jl.id as joinedleauges_id','jt.id as jointeam_id')
      ->where($where_condition,$where_operation,$where_value)->orWhere($where_condition1,$where_operation,$where_value)->orWhere($where_condition2,$where_operation,$where_value)->orderBy('id', 'DESC')->toSql();
      print_r($data); exit;*/

            // 				DB::table('registerusers as r')
            // 					->leftJoin('userbalances as ub','ub.user_id','=','r.id')
            // 					->leftJoin('withdraw as w','w.user_id','=','r.id')
            // 					// ->leftJoin('transactions as t','t.userid','=','r.id')
            // 					->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
            // 					->leftJoin('jointeam as jt','jt.userid','=','r.id')
            // 					->limit(1000)
            // 					->groupBy('r.id')
            // 					//->where('is_yoububer','0')
            // 					->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','jl.id as joinedleauges_id','jt.id as jointeam_id')
            // 					->where(function ($query) use ($formData) {
            // 							if (isset($formData['users_type']) && !empty($formData['users_type'])) {
            // 									if ($formData['users_type']=='active') {
            // 											$query->where('r.activation_status', '=', 'activated');
            // 									}
            // 									if ($formData['users_type']=='deactive') {
            // 											$query->where('r.activation_status', '=', 'deactivated');
            // 									}
            // 									if ($formData['users_type']=='youtuber') {
            // 											$query->where('r.is_yoububer', '=',1);
            // 									}
            // 							}
            // 					})
            // 					->where(function ($query) use ($formData) {
            // 							if (isset($formData['filter_columns'])) {
            // 									if (isset($formData['filter_columns']['filter_teamname'])) {
            // 											$query->where('r.team', 'like', '%'.$formData['filter_columns']['filter_teamname'].'%');
            // 									}
            // 									if (isset($formData['filter_columns']['filter_email'])) {
            // 											$query->where('r.email', 'like', '%'.$formData['filter_columns']['filter_email'].'%');
            // 									}
            // 									if (isset($formData['filter_columns']['filter_mobile'])) {
            // 											$query->where('r.mobile', 'like', '%'.$formData['filter_columns']['filter_mobile'].'%');
            // 									}
            // 							}
            // 					})
            // 					->orderBy('id', 'DESC')->get();
            //
            // DB::enableQueryLog();
            // dd(DB::getQueryLog());



            return Datatables::of(DB::table('registerusers as r')
                // ->leftJoin('userbalances as ub','ub.user_id','=','r.id')
                //  ->leftJoin('withdraw as w','w.user_id','=','r.id')
                // ->leftJoin('transactions as t','t.userid','=','r.id')
                //->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
                //  ->leftJoin('jointeam as jt','jt.userid','=','r.id')
                ->where('r.is_bot', 0)
                ->orwhereNotNull('r.mobile')

                ->where(function ($query) use ($formData) {
                    if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                        $query->limit(1000000);
                    } else {

                        $query->limit(500);
                    }
                })
                ->limit($limit)
                ->groupBy('r.id')
                ->select('r.id', 'r.email', 'r.mobile', 'r.team', 'r.team', 'r.team', 'r.mobile_verify', 'r.email_verify', 'r.pan_verify', 'r.aadhar_verify', 'r.bank_verify', 'r.upi_verify', 'r.is_yoububer', 'r.activation_status', 'r.user_block', 'r.created_at')
                // ->select('r.id','r.email','r.mobile','r.team','r.team','r.team','r.mobile_verify','r.email_verify','r.pan_verify','r.aadhar_verify','r.bank_verify','r.is_yoububer','r.activation_status','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','ub.user_id as userid')
                ->where(function ($query) use ($formData) {
                    if (isset($formData['users_type']) && !empty($formData['users_type'])) {
                        if ($formData['users_type'] == 'active') {
                            $query->where('r.activation_status', '=', 'activated');
                        }
                        if ($formData['users_type'] == 'deactive') {
                            $query->where('r.activation_status', '=', 'deactivated');
                        }
                        if ($formData['users_type'] == 'youtuber') {
                            $query->where('r.is_yoububer', '=', 1);
                        }
                    }
                })
                ->where(function ($query) use ($formData) {
                    if (isset($formData['filter_columns'])) {

                        if (isset($formData['filter_columns']['filter_teamname'])) {
                            $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_mobile'])) {
                            $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                        }
                    }
                    //$query->limit(100);
                })
                ->orderBy('r.id', 'DESC')->get())
                // ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" class="" style="text-decoration:underline;">' . @$result->id . '</a>';
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->email . '</a>';
                })
                ->addColumn('mobile_verify', function ($result) {
                    $mobileverify = '';
                    if ($result->mobile_verify == 0) {
                        $mobileverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->mobile_verify == 1) {
                        $mobileverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $mobileverify;
                })
                ->addColumn('email_verify', function ($result) {
                    $emailverify = '';
                    if ($result->email_verify == 0) {
                        $emailverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->email_verify == 1) {
                        $emailverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $emailverify;
                })
                ->addColumn('last_play', function ($result) {
                    $lastplaydate = '';
                    $playdate = DB::table('transactions')->where('userid', $result->id)->where('paymentstatus', 'confirmed')
                        ->where('type', '=', 'Challenge Joining Fee')
                        ->where('transaction_by', 'wallet')->orderby('id', 'desc')->select('created')->first();
                    if (!empty($playdate)) {
                        $lastplaydate = $playdate->created;
                    }
                    return $lastplaydate;
                })
                //class="badge badge-success"
                ->addColumn('aadhar_verify', function ($result) {
                  // echo "string";die;
                    $aadarverify    = '';
                    if ($result->aadhar_verify == 0) {
                        $aadarverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->aadhar_verify == 1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->aadhar_verify == -1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $aadarverify;
                })
                ->addColumn('upi_verify', function ($result) {
                    $upi_verify    = '';
                    if ($result->upi_verify == 0) {
                        $upi_verify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->upi_verify == 1) {
                        $upi_verify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->upi_verify == -1) {
                        $upi_verify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    } elseif ($result->upi_verify == 2) {
                        $upi_verify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Reject</span></td>';
                    }
                    return $upi_verify;
                })
                ->addColumn('pan_verify', function ($result) {
                    $panverify = '';
                    if ($result->pan_verify == 0) {
                        $panverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->pan_verify == 1) {
                        $panverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->pan_verify == -1) {
                        $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    } elseif ($result->pan_verify == 2) {
                        $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Reject</span></td>';
                    }
                    return $panverify;
                })
                ->addColumn('bank_verify', function ($result) {
                    $bankverify = '';
                    if ($result->bank_verify == 0) {
                        $bankverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->bank_verify == 1) {
                        $bankverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->bank_verify == -1) {
                        $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    } elseif ($result->bank_verify == 2) {
                        $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Reject</span></td>';
                    }
                    return $bankverify;
                })

                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    $block_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize(@$result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="javascript:void(0);" class="user-deactivate-button" data-toggle="modal"  data-user-id="' . @$result->id . '"><button class="btn btn-danger"><i class="fa fa-ban"></i></button></a>&ensp;';
                    }
                    if ($result->user_block == '1') {
                        $block_status = '<a href="' . route($this->model . '.block_updateuser_status', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Unblock" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $block_status = '<a href="javascript:void(0);" class="user-block-button" data-toggle="modal" title="Block"  data-user-id="' . @$result->id . '"><button class="btn btn-dark"><i class="fa fa-user-times" aria-hidden="true"></i></button></a>&ensp;';
                    }

                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . @$result->id . '" data-status="' . @$result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-info mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }


                    if (1) {

                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '<a href="' . route(@$this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    }
                    $wallethistory_day_wise = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a>';


                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'

                        . $transactions_link
                        . $activation_status
                        . $block_status
                        . $is_youtuber
                        . $wallethistory_day_wise;
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        // dd($result);

        $totaluser = DB::table('registerusers as r')
            ->where('r.is_bot', 0)->count();
        return view("admin.$this->model.viewregisterusers", compact('totaluser'));
    } //End if

    public function registerusersReport(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (!empty($formData['search']['value'])) {
                $limit = 100000000;
            } else {
                $limit = 1000;
            }

            if (!empty($req->start_date) && !empty($req->end_date)) {
                $limit = 100000;
            }

            // Initial query with a left join to include the last play date
            return Datatables::of(
                DB::table('registerusers as r')
                    ->leftJoin('transactions as t', function ($join) {
                        $join->on('r.id', '=', 't.userid')
                            ->where('t.paymentstatus', '=', 'confirmed')
                            ->where('t.type', '=', 'Challenge Joining Fee')
                            ->where('t.transaction_by', '=', 'wallet');
                    })
                    ->select(
                        DB::raw('@row := @row + 1 AS DT_RowIndex'),
                        'r.id',
                        'r.email',
                        'r.mobile',
                        'r.team',
                        'r.mobile_verify',
                        'r.email_verify',
                        'r.created_at',
                        'r.pan_verify',
                        'r.aadhar_verify',
                        'r.bank_verify',
                        'r.is_yoububer',
                        'r.activation_status',
                        'r.user_block',
                        'r.upi_verify',
                        DB::raw('MAX(t.created) as last_play')
                    )
                    ->whereNotNull('r.mobile')
                    // ->where(function ($query) use ($formData) {
                    //               if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                    //         $query->limit(1000000);
                    //               } else {
                    //     $query->limit(500);
                    //   }
                    // })
                    //  ->limit($limit)
                    ->groupBy('r.id')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['users_type']) && !empty($formData['users_type'])) {
                            if ($formData['users_type'] == 'active') {
                                $query->where('r.activation_status', '=', 'activated');
                            }
                            if ($formData['users_type'] == 'deactive') {
                                $query->where('r.activation_status', '=', 'deactivated');
                            }
                            if ($formData['users_type'] == 'youtuber') {
                                $query->where('r.is_yoububer', '=', 1);
                            }
                        }
                    })
                    ->where(function ($query) use ($formData, $req) {
                        if (!empty($req->start_date)) {
                            $query->where('r.created_at', '>=', $req->start_date);
                        }
                        if (!empty($req->end_date)) {
                            $query->where('r.created_at', '<=', $req->end_date);
                        }
                    })
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_teamname'])) {
                                $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                        }
                    })
                    ->orderBy('id', 'DESC')
                //->get()
            )
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" class="" style="text-decoration:underline;">' . @$result->id . '</a>';
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->email . '</a>';
                })
                ->addColumn('mobile', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->mobile . '</a>';
                })
                ->addColumn('last_play', function ($result) {
                    return $result->last_play ? $result->last_play : '';
                })
                ->addColumn('mobile_verify', function ($result) {
                    $mobileverify = '';
                    if ($result->mobile_verify == 0) {
                        $mobileverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->mobile_verify == 1) {
                        $mobileverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $mobileverify;
                })
                ->addColumn('email_verify', function ($result) {
                    $emailverify = '';
                    if ($result->email_verify == 0) {
                        $emailverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->email_verify == 1) {
                        $emailverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $emailverify;
                })
                ->addColumn('aadhar_verify', function ($result) {
                    $aadhar_verify = '';
                    if ($result->aadhar_verify == 0) {
                        $aadhar_verify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->aadhar_verify == 1) {
                        $aadhar_verify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $aadhar_verify;
                })
                ->addColumn('upi_verify', function ($result) {
                    $aadarverify    = '';
                    if ($result->upi_verify == 0) {
                        $aadarverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->upi_verify == 1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->upi_verify == -1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $aadarverify;
                })
                ->addColumn('pan_verify', function ($result) {
                    $panverify = '';
                    if ($result->pan_verify == 0) {
                        $panverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->pan_verify == 1) {
                        $panverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->pan_verify == -1) {
                        $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $panverify;
                })
                ->addColumn('bank_verify', function ($result) {
                    $bankverify = '';
                    if ($result->bank_verify == 0) {
                        $bankverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->bank_verify == 1) {
                        $bankverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->bank_verify == -1) {
                        $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $bankverify;
                })
                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    $block_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize(@$result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="javascript:void(0);" class="user-deactivate-button" data-toggle="modal"  data-user-id="' . @$result->id . '"><button class="btn btn-danger"><i class="fa fa-ban"></i></button></a>&ensp;';
                    }
                    if ($result->user_block == '1') {
                        $block_status = '<a href="' . route($this->model . '.block_updateuser_status', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Unblock" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $block_status = '<a href="javascript:void(0);" class="user-block-button" data-toggle="modal" title="Block"  data-user-id="' . @$result->id . '"><button class="btn btn-dark"><i class="fa fa-user-times" aria-hidden="true"></i></button></a>&ensp;';
                    }

                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . @$result->id . '" data-status="' . @$result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-info mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }


                    if (1) {

                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '<a href="' . route(@$this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    }
                    $wallethistory_day_wise = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a>';
                    // $account = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_delete_permanent', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="User Delete" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1 delete_user_permanent" data-original-title="User Transactions">Account Delete </a>';
                    $account = '';

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'

                        . $transactions_link
                        . $activation_status
                        . $block_status
                        . $is_youtuber
                        . $wallethistory_day_wise
                        . $account;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        $query = DB::table('registerusers as r')
            ->where('r.is_bot', 0);
        //->where('r.email','!=',null);
        if (!empty($req->start_date)) {
            $query->where('r.created_at', '>=', $req->start_date);
        }
        if (!empty($req->end_date)) {
            $query->where('r.created_at', '<=', $req->end_date);
        }
        $totaluser = $query->count();
        return view("admin.$this->model.registerusersreport", compact('totaluser'));
    }

    public function registerusersReport_03_sep_2024(Request $req)
    {

        if ($req->isMethod('post')) {
            $formData = Input::all();
            // echo '<pre>'; print_r($req->all()); die();
            if (!empty($formData['search']['value'])) {
                $limit = 100000000;
            } else {
                $limit = 1000;
            }

            if (!empty($req->start_date) && !empty($req->end_date)) {
                $limit = 100000;
            }

            return Datatables::of(DB::table('registerusers as r')
                //->where('r.is_bot',0)
                ->whereNotNull('r.mobile')
                //->where('r.email','!=',null)

                ->where(function ($query) use ($formData) {
                    if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                        $query->limit(1000000);
                    } else {

                        $query->limit(500);
                    }
                })
                ->limit($limit)
                ->groupBy('r.id')
                ->select('r.id', 'r.email', 'r.mobile', 'r.team', 'r.team', 'r.team', 'r.mobile_verify', 'r.email_verify', 'r.pan_verify', 'r.aadhar_verify', 'upi_verify', 'r.bank_verify', 'r.is_yoububer', 'r.activation_status', 'r.user_block')
                ->where(function ($query) use ($formData) {
                    if (isset($formData['users_type']) && !empty($formData['users_type'])) {
                        if ($formData['users_type'] == 'active') {
                            $query->where('r.activation_status', '=', 'activated');
                        }
                        if ($formData['users_type'] == 'deactive') {
                            $query->where('r.activation_status', '=', 'deactivated');
                        }
                        if ($formData['users_type'] == 'youtuber') {
                            $query->where('r.is_yoububer', '=', 1);
                        }
                    }
                })
                ->where(function ($query) use ($formData, $req) {
                    if (!empty($req->start_date)) {
                        $query->where('r.created_at', '>=', $req->start_date);
                    }
                    if (!empty($req->end_date)) {
                        $query->where('r.created_at', '<=', $req->end_date);
                    }
                })



                ->where(function ($query) use ($formData) {
                    if (isset($formData['filter_columns'])) {

                        if (isset($formData['filter_columns']['filter_teamname'])) {
                            $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_mobile'])) {
                            $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                        }
                    }
                    //$query->limit(100);
                })
                ->orderBy('id', 'DESC')->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" class="" style="text-decoration:underline;">' . @$result->id . '</a>';
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->email . '</a>';
                })
                ->addColumn('mobile', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->mobile . '</a>';
                })

                ->addColumn('last_play', function ($result) {
                    $lastplaydate = '';
                    $playdate = DB::table('transactions')->where('userid', $result->id)->where('paymentstatus', 'confirmed')->where('type', '=', 'Challenge Joining Fee')->where('transaction_by', 'wallet')->orderby('id', 'desc')->select('created')->first();
                    if (!empty($playdate)) {
                        $lastplaydate = $playdate->created;
                    }
                    return $lastplaydate;
                })
                ->addColumn('mobile_verify', function ($result) {
                    $mobileverify = '';
                    if ($result->mobile_verify == 0) {
                        $mobileverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->mobile_verify == 1) {
                        $mobileverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $mobileverify;
                })
                ->addColumn('email_verify', function ($result) {
                    $emailverify = '';
                    if ($result->email_verify == 0) {
                        $emailverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                    } elseif ($result->email_verify == 1) {
                        $emailverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    }
                    return $emailverify;
                })
                //class="badge badge-success"
                ->addColumn('aadhar_verify', function ($result) {
                    $aadarverify    = '';
                    if ($result->aadhar_verify == 0) {
                        $aadarverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->aadhar_verify == 1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->aadhar_verify == -1) {
                        $aadarverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $aadarverify;
                })
                ->addColumn('upi_verify', function ($result) {
                    $upiverify    = '';
                    if ($result->upi_verify == 0) {
                        $upiverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->upi_verify == 1) {
                        $upiverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->upi_verify == -1) {
                        $upiverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $upiverify;
                })
                ->addColumn('pan_verify', function ($result) {
                    $panverify = '';
                    if ($result->pan_verify == 0) {
                        $panverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->pan_verify == 1) {
                        $panverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->pan_verify == -1) {
                        $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $panverify;
                })
                ->addColumn('bank_verify', function ($result) {
                    $bankverify = '';
                    if ($result->bank_verify == 0) {
                        $bankverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                    } elseif ($result->bank_verify == 1) {
                        $bankverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                    } elseif ($result->bank_verify == -1) {
                        $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                    }
                    return $bankverify;
                })
                /*
      ->addColumn('account_freez',function ($result){
        $freezaccount='';
        $useraccount= DB::table('user_account_freez')->where('user_id',$result->id)->first();
        if(@$useraccount->status==1){
          $freezaccount= '<a href="'.route($this->model.'.freezaccount_updateuser_status',[base64_encode(serialize(@$result->id)),'0']).'" data-toggle="tooltip" title="Account UnFreez" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
        }else{
          $freezaccount= '<a href="javascript:void(0);" class="user-freez-button" data-toggle="modal" title="Account Freez"  data-user-id="'.@$result->id.'"><button class="btn btn-dark"><i class="fa fa-user-times" aria-hidden="true"></i></button></a>&ensp;';
        }
        return $freezaccount;
      })
*/
                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    $block_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize(@$result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="javascript:void(0);" class="user-deactivate-button" data-toggle="modal"  data-user-id="' . @$result->id . '"><button class="btn btn-danger"><i class="fa fa-ban"></i></button></a>&ensp;';
                    }
                    if ($result->user_block == '1') {
                        $block_status = '<a href="' . route($this->model . '.block_updateuser_status', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Unblock" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $block_status = '<a href="javascript:void(0);" class="user-block-button" data-toggle="modal" title="Block"  data-user-id="' . @$result->id . '"><button class="btn btn-dark"><i class="fa fa-user-times" aria-hidden="true"></i></button></a>&ensp;';
                    }

                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . @$result->id . '" data-status="' . @$result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-info mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize(@$result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }


                    if (1) {

                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '<a href="' . route(@$this->model . '.add_cash_list', base64_encode(serialize(@$result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    }
                    $wallethistory_day_wise = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a>';
                    $account = '<a dataid="' . @$result->id . '" href="' . route($this->model . '.users_delete_permanent', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="User Delete" id="' . @$result->id . '" class="btn btn-primary mr-1 mt-1 delete_user_permanent" data-original-title="User Transactions">Account Delete </a>';

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize(@$result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'

                        . $transactions_link
                        . $activation_status
                        . $block_status
                        . $is_youtuber
                        . $wallethistory_day_wise
                        . $account;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        $query = DB::table('registerusers as r')
            ->where('r.is_bot', 0);
        //->where('r.email','!=',null);
        if (!empty($req->start_date)) {
            $query->where('r.created_at', '>=', $req->start_date);
        }
        if (!empty($req->end_date)) {
            $query->where('r.created_at', '<=', $req->end_date);
        }
        $totaluser = $query->count();
        return view("admin.$this->model.registerusersreport", compact('totaluser'));
    } //End if

    //View Register users
    public function viewregisterusers_old17_10_23(Request $req)
    {
        // $result=  DB::table('registerusers as r')
        //   ->leftJoin('userbalances as ub','ub.user_id','=','r.id')
        //   ->leftJoin('withdraw as w','w.user_id','=','r.id')
        //   // ->leftJoin('transactions as t','t.userid','=','r.id')
        //   ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
        //   ->leftJoin('jointeam as jt','jt.userid','=','r.id')
        // //  ->limit(1000)
        //   ->groupBy('r.id')
        //   //->where('is_yoububer','0')
        //   ->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','jl.id as joinedleauges_id','jt.id as jointeam_id','ub.user_id as userid')
        //   ->get();
        //   echo '<pre>'; print_r($result);exit;
        //if ($req->isMethod('post')) {
        $formData = Input::all();
        //print_r($formData['search']['value'] ); die();
        // if(isset($formData) && !empty($formData)){
        // 	$where_condition = ''; $where_operation = ''; $where_value = '';
        // 	if($formData['users_type'] == 'active'){
        // 		$where_condition = "r.activation_status";
        // 		$where_operation = "=";
        // 		$where_value = "activated";
        // 	}
        // 	elseif ($formData['users_type'] == 'deactive'){
        // 		$where_condition = "r.activation_status";
        // 		$where_operation = "=";
        // 		$where_value = "deactivated";
        // 	}
        // 	elseif ($formData['users_type'] == 'youtuber'){
        // 		$where_condition = "r.is_yoububer";
        // 		$where_operation = "=";
        // 		$where_value = "1";
        // 	}
        // 	else {
        // 		$where_condition = "r.email";
        // 		 $where_condition1 ="r.mobile";
        // 		  $where_condition2 ="r.team";
        // 		$where_operation = "LIKE";
        // 		$where_value = '%'.$formData['search']['value'].'%';
        // 		// echo $where_value; exit;
        // 	}


        //echo $where;die;

        /*$data = DB::table('registerusers as r')
      ->leftJoin('userbalances as ub','ub.user_id','=','r.id')
      ->leftJoin('withdraw as w','w.user_id','=','r.id')
      ->leftJoin('transactions as t','t.userid','=','r.id')
      ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
      ->leftJoin('jointeam as jt','jt.userid','=','r.id')
      ->limit(10)
      ->groupBy('r.id')
      //->where('is_yoububer','0')
      ->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','t.id as transactions_id','jl.id as joinedleauges_id','jt.id as jointeam_id')
      ->where($where_condition,$where_operation,$where_value)->orWhere($where_condition1,$where_operation,$where_value)->orWhere($where_condition2,$where_operation,$where_value)->orderBy('id', 'DESC')->toSql();
      print_r($data); exit;*/

        // 				DB::table('registerusers as r')
        // 					->leftJoin('userbalances as ub','ub.user_id','=','r.id')
        // 					->leftJoin('withdraw as w','w.user_id','=','r.id')
        // 					// ->leftJoin('transactions as t','t.userid','=','r.id')
        // 					->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
        // 					->leftJoin('jointeam as jt','jt.userid','=','r.id')
        // 					->limit(1000)
        // 					->groupBy('r.id')
        // 					//->where('is_yoububer','0')
        // 					->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','jl.id as joinedleauges_id','jt.id as jointeam_id')
        // 					->where(function ($query) use ($formData) {
        // 							if (isset($formData['users_type']) && !empty($formData['users_type'])) {
        // 									if ($formData['users_type']=='active') {
        // 											$query->where('r.activation_status', '=', 'activated');
        // 									}
        // 									if ($formData['users_type']=='deactive') {
        // 											$query->where('r.activation_status', '=', 'deactivated');
        // 									}
        // 									if ($formData['users_type']=='youtuber') {
        // 											$query->where('r.is_yoububer', '=',1);
        // 									}
        // 							}
        // 					})
        // 					->where(function ($query) use ($formData) {
        // 							if (isset($formData['filter_columns'])) {
        // 									if (isset($formData['filter_columns']['filter_teamname'])) {
        // 											$query->where('r.team', 'like', '%'.$formData['filter_columns']['filter_teamname'].'%');
        // 									}
        // 									if (isset($formData['filter_columns']['filter_email'])) {
        // 											$query->where('r.email', 'like', '%'.$formData['filter_columns']['filter_email'].'%');
        // 									}
        // 									if (isset($formData['filter_columns']['filter_mobile'])) {
        // 											$query->where('r.mobile', 'like', '%'.$formData['filter_columns']['filter_mobile'].'%');
        // 									}
        // 							}
        // 					})
        // 					->orderBy('id', 'DESC')->get();
        //
        // DB::enableQueryLog();
        // dd(DB::getQueryLog());



        return Datatables::of(DB::table('registerusers as r')
            ->leftJoin('userbalances as ub', 'ub.user_id', '=', 'r.id')
            //  ->leftJoin('withdraw as w','w.user_id','=','r.id')
            // ->leftJoin('transactions as t','t.userid','=','r.id')
            //->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
            //  ->leftJoin('jointeam as jt','jt.userid','=','r.id')
            ->where('r.is_bot', 0)

            ->where(function ($query) use ($formData) {
                if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                    $query->limit(100000);
                } else {
                    $query->limit(1000);
                }
            })
            ->groupBy('r.id')
            //->where('is_yoububer','0')
            // ->select('r.*','ub.id as userbalances_id','ub.balance','ub.winning','ub.bonus','w.id  as withdraw_id','jl.id as joinedleauges_id','jt.id as jointeam_id','ub.user_id as userid')
            ->select('r.*', 'ub.id as userbalances_id', 'ub.balance', 'ub.winning', 'ub.bonus', 'ub.user_id as userid')
            ->where(function ($query) use ($formData) {
                if (isset($formData['users_type']) && !empty($formData['users_type'])) {
                    if ($formData['users_type'] == 'active') {
                        $query->where('r.activation_status', '=', 'activated');
                    }
                    if ($formData['users_type'] == 'deactive') {
                        $query->where('r.activation_status', '=', 'deactivated');
                    }
                    if ($formData['users_type'] == 'youtuber') {
                        $query->where('r.is_yoububer', '=', 1);
                    }
                }
            })
            ->where(function ($query) use ($formData) {
                if (isset($formData['filter_columns'])) {

                    if (isset($formData['filter_columns']['filter_teamname'])) {
                        $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                    }
                    if (isset($formData['filter_columns']['filter_email'])) {
                        $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                    }
                    if (isset($formData['filter_columns']['filter_mobile'])) {
                        $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                    }
                }
            })
            ->orderBy('id', 'DESC')->get())
            ->addIndexColumn()
            ->addColumn('id', function ($result) {
                return '<a href="' . route($this->model . '.details', base64_encode(serialize(@$result->id))) . '" class="" style="text-decoration:underline;">' . @$result->id . '</a>';
            })
            ->addColumn('email', function ($result) {
                return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Click to see detail" class="" style="text-decoration:underline;">' . @$result->email . '</a>';
            })
            ->addColumn('mobile_verify', function ($result) {
                $mobileverify = '';
                if ($result->mobile_verify == 0) {
                    $mobileverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                } elseif ($result->mobile_verify == 1) {
                    $mobileverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                }
                return $mobileverify;
            })
            ->addColumn('email_verify', function ($result) {
                $emailverify = '';
                if ($result->email_verify == 0) {
                    $emailverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Verified</span></td>';
                } elseif ($result->email_verify == 1) {
                    $emailverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                }
                return $emailverify;
            })
            //class="badge badge-success"
            ->addColumn('aadhar_verify', function ($result) {
                $aadarverify    = '';
                if ($result->aadhar_verify == 0) {
                    $aadarverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                } elseif ($result->aadhar_verify == 1) {
                    $aadarverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                } elseif ($result->aadhar_verify == -1) {
                    $aadarverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                }
                return $aadarverify;
            })
            ->addColumn('pan_verify', function ($result) {
                $panverify = '';
                if ($result->pan_verify == 0) {
                    $panverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                } elseif ($result->pan_verify == 1) {
                    $panverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                } elseif ($result->pan_verify == -1) {
                    $panverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                }
                return $panverify;
            })
            ->addColumn('bank_verify', function ($result) {
                $bankverify = '';
                if ($result->bank_verify == 0) {
                    $bankverify = '<td><span class=""><i class="fa fa-search primary_icn mr-2"></i>Under Review</span></td>';
                } elseif ($result->bank_verify == 1) {
                    $bankverify = '<td><span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Verified</span></td>';
                } elseif ($result->bank_verify == -1) {
                    $bankverify = '<td><span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Not Requested</span></td>';
                }
                return $bankverify;
            })
            // ->addColumn('total_available_amt',function ($result){
            //   $startd = date('Y-m-d').' 00:00:00';
            //   $enddate = date('Y-m-d').' 23:59:00';
            //  $qurey44 =   DB::table('transactions')
            //          ->where('userid','=',$result->id)
            //          ->whereBetween('created_at',[$startd ,$enddate])
            //          ->where('type','Add Fund')->sum('amount');
            //  return  @$qurey44;
            // })
            // ->addColumn('withdraw_amt',function ($result){
            //   $startd = date('Y-m-d').' 00:00:00';
            //   $enddate = date('Y-m-d').' 23:59:00';
            //   $qurey44 =   DB::table('transactions')
            //       ->where('userid','=',$result->id)
            //       ->whereBetween('created_at',[$startd ,$enddate])
            //       ->where('type','Amount Withdrawn')->sum('amount');
            //   return  @$qurey44;
            // })
            // ->addColumn('bonus_amt',function ($result){
            //     $startd = date('Y-m-d').' 00:00:00';
            //     $enddate =  date('Y-m-d').' 23:59:00';
            //     $qurey44 =   DB::table('transactions')
            //      ->where('userid','=',$result->id)
            //      ->whereIn('type',['Refer Bonus','Signup Bonus'])
            //      ->whereBetween('created_at',[$startd ,$enddate])
            //      ->sum('amount');
            //       return  @$qurey44;
            // })
            // ->addColumn('amount',function ($result){
            //   $startd = date('Y-m-d').' 00:00:00';
            //   $enddate = date('Y-m-d').' 23:59:00';
            //   $qurey44 =   DB::table('transactions')
            //       ->where('userid','=',$result->id)
            //       ->whereIn('type',['Refer Bonus','Signup Bonus','Add Fund','Amount Withdrawn'])
            //       ->whereBetween('created_at',[$startd ,$enddate])->sum('amount');
            //   return  @$qurey44;
            // })
            // ->addColumn('balance',function ( $result){
            //   if(isset($result->userbalances_id) && !empty($result->userbalances_id)){
            //     return '<a href="javascript:void(0);" class="edit-userbalance" data-toggle="modal" data-tranasation-id="'.@$result->transactions_id.'" data-id="'.$result->userbalances_id.'">₹ '.$result->balance.'</a>';
            //   }else{
            //     return '₹ 0';
            //   }
            //
            // })
            // ->addColumn('winning',function ( $result){
            //   if(isset($result->userbalances_id) && !empty($result->userbalances_id)){
            //     return '<a href="javascript:void(0);" class="edit-userbalance" data-toggle="modal" data-tranasation-id="'.@$result->transactions_id.'" data-id="'.$result->userbalances_id.'">₹ '.$result->winning.'</a>';
            //   }else{
            //     return '₹ 0';
            //   }
            // })
            // ->addColumn('bonus',function ( $result){
            //   if(isset($result->userbalances_id) && !empty($result->userbalances_id)){
            //     return '<a href="javascript:void(0);" class="edit-userbalance" data-toggle="modal" data-tranasation-id="'.@$result->transactions_id.'" data-id="'.$result->userbalances_id.'">₹ '.$result->bonus.'</a>';
            //   }else{
            //     return '₹ 0';
            //   }
            //
            // })
            // ->addColumn('refer_id',function ($result){
            //   if(isset($result->refer_id) && !empty($result->refer_id)){
            //     return '<a href="'.route($this->model.'.refer_detail',base64_encode(serialize($result->refer_id))).'" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="User Refer">'.$result->username.'</a>';
            //   }else{
            //     return '0';
            //   }
            //
            // })
            ->addColumn('action', function ($result) {
                $activation_status = '';
                if (strtolower($result->activation_status) != 'activated') {
                    $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                } else {
                    $activation_status = '<a href="javascript:void(0);" class="user-deactivate-button" data-toggle="modal"  data-user-id="' . $result->id . '"><button class="btn btn-danger"><i class="fa fa-ban"></i></button></a>&ensp;';
                }

                /*$refer_to_join='';
        if($result->refer_to_join=='0'){
        $refer_to_join='<a href="'.route($this->model.'.update_refer_join',[base64_encode(serialize($result->id)),'1']).'" class="btn btn-success mr-1 mt-1">Convert to Youtuber</a></br>';
      }else{
      $refer_to_join='<a href="'.route($this->model.'.update_refer_join',[base64_encode(serialize($result->id)),'0']).'" class="btn btn-danger mr-1 mt-1">Convert to User</a></br>';
    }*/

                //youtuber users not show in all registerusrs
                $is_youtuber = '';
                if ($result->is_yoububer == '0') {
                    $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . $result->id . '" data-status="' . $result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-info mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                } else {
                    $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize($result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-info mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                }

                //Withdraw
                if (isset($result->withdraw_id) && !empty($result->withdraw_id)) {
                    $withdraw_link = '<a href="' . route($this->model . '.withdraw_detail', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Withdraw Amount" class="btn btn-warning mr-1 mt-1" data-original-title="withdraw Amount"><i class="fa fa-inr p-1" aria-hidden="true"></i></a>';
                } else {
                    $withdraw_link = '';
                }

                //Teansacton
                /*if(isset($result->transactioviewregisterusersns_id) && !empty($result->transactions_id)){
    $transactions_link='<a href="'.route($this->model.'.add_cash_list',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn btn-dark mr-1 mt-1" data-original-title="withdraw Amount">Add <i class="fa fa-inr" aria-hidden="true"></i> List</a></br>';
  }else{
  $transactions_link='';
}*/

                if (1) {
                    $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                } else {
                    $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                }

                //Show Joined Leauges
                if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                    $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leauges" class="btn btn-dark mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                } else {
                    $joinedleauges_link = '';
                } //End Function

                //Join team Link jointeam_id
                if (isset($result->jointeam_id) && !empty($result->jointeam_id)) {
                    $jointeam_link = '<a href="' . route($this->model . '.user_team', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="User Team" class="btn btn-dark mr-1 mt-1"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                } else {
                    $jointeam_link = '';
                } //End Function
                $wallethistory_day_wise = '<a dataid="' . $result->userid . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize($result->userid))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a>';
                return '<a href="' . route($this->model . '.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                    . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'
                    //.'<a href="'.route($this->model.'.view_user',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="View" class="btn btn-success mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View" ></i></a>'
                    . $withdraw_link
                    . $transactions_link
                    . $activation_status
                    //.$refer_to_join
                    . $is_youtuber
                    . $joinedleauges_link
                    . $jointeam_link
                    . $wallethistory_day_wise
                    //.'<a href="javascript:void(0);" class="btn btn-primary submitper mr-1 mt-1"  data-toggle="modal" data-id="'.$result->id.'">Set %</a></br>'
                ;
            })
            ->escapeColumns([])
            ->make(true);
        //}//end
    } //End if

    //Add User
    public function adduser(Request $request)
    {
        $formData = Input::all();

        $setting = Setting::where('setting_key', 'MAX_IMAGE_SIZE')->select('setting_key', 'value')->first();
        //Insert Data
        if (!empty($formData)) {
            $message    =    array(
                'image.max'       =>    $setting->setting_key,
            );
            $validate    =    array(
                'username' =>    'required|regex:/^[\pL\s\-]+$/u',
                'mobile'   =>    "required|integer|unique:registerusers,mobile,NULL,id",
                'email'       =>    "required|email|unique:registerusers,email,NULL,id",
                'dob'       =>    'required',
                'gender'   =>    'required',
                'password' =>    'required|min:6',
                'c_password' =>    'required|same:password',
                'city'     =>    'required',
                'state'    =>    'required',
                'country'  =>    'required',
                'team'     =>    'required',
                'image'    =>   'max:2048|mimes:' . IMAGE_EXTENSION,
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                if ($request->file('image')) {
                    $image = $request->file('image');
                    $destination = 'uploads/user';
                    $filename = 'profile-' . time();
                    $obj['image'] = Helpers::imageUpload($image, $destination, $filename);
                    //print_r( $input['image']);die;
                    if ($obj['image'] == '') {
                        return redirect()->back()->with('danger', 'Invalid extension of file you uploaded. You can only upload image or pdf.');
                    }
                }
                //Set Val
                $obj['username'] = $formData['username'];
                $obj['mobile'] = $formData['mobile'];
                $obj['email'] = $formData['email'];
                $obj['gender'] = $formData['gender'];
                $obj['password'] = $formData['password'];
                $obj['country'] = $formData['country'];
                $obj['state'] = $formData['state'];
                $obj['city'] = $formData['city'];
                $obj['dob'] = date('Y-m-d', strtotime($formData['dob']));
                $obj['team'] = $formData['team'];
                $obj['provider'] = 'web';
                $obj['code'] = rand(1000, 9999);
                $obj['refercode'] = 'FB11-' . rand(100000, 999999);
                $obj['activation_status'] = 'activated';
                $obj['mobile_verify'] = '1';
                $obj['email_verify'] = '1';
                $obj['pan_verify'] = '-1';
                $obj['bank_verify'] = '-1';
                //Insert Data
                DB::table('registerusers')->insert($obj);
                Session::flash('flash_notice',  trans("Successfully Add User!'"));
                Helpers::logActivity('Successfully Add User!', $obj['username']);
                return Redirect::route($this->model . '.view');
            }
        }
        //Get Avater List
        $states = DB::table('states')->get();
        return view("admin.$this->model.add_user", compact('states'));
    } //End

    //Edit User
    public function edituser($id = null, Request $request)
    {

        //Get Satting
        //Get Id
        $id = unserialize(base64_decode($id));
        //print_r($id);die;
        $user = DB::table('registerusers')->where('id', $id)->first();
        $formData = Input::all();

        //Insert Data
        if (!empty($formData)) {
            $message =    array(
                'image.max'    =>    MAX_IMAGE_SIZE,
            );
            $validate    =    array(
                'username' =>	'required',
                'mobile'   =>	"required",
                // 'email'	   =>	"required",
                // 'dob'	     =>	'required',
                //'gender'   =>	'required',
                // 'city'     =>	'required',
                // 'state'    =>	'required',
                // 'country'  =>	'required',
                'team'     =>    'required',
            );

            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                // if($request->file('image')){
                //   $image = $request->file('image');
                //   $destination = 'uploads/user';
                //   $filename = 'profile-'.time();
                //   $obj['image'] = Helpers::imageUpload($image,$destination,$filename);
                //   //print_r( $input['image']);die;
                //   if($obj['image']==''){
                //     return redirect()->back()->with('danger','Invalid extension of file you uploaded. You can only upload image or pdf.');
                //   }
                // }
                $formData = $request->all();
                // dd($formData);
                if ($formData['base64image'] || $formData['base64image'] != '0') {
                    // echo "string"; die();
                    $folderPath  = USER_PROFILE_IMAGE_ROOT_PATH;
                    // dd($folderPath);
                    // $folderPath = public_path('images/');
                    $image_parts = explode(";base64,", $formData['base64image']);
                    // dd($image_parts);
                    if ($image_parts[0] === "") {
                        // dd('asfda');
                        // echo "string"; die();
                        if (input::hasFile('image')) {
                            // echo "string"; die();
                            $extension  =   Input::file('image')->getClientOriginalExtension();
                            // dd($extension);
                            $img_ext    =   explode(",", IMAGE_EXTENSION);
                            if (in_array($extension, $img_ext)) {
                                $fileName           =   time() . '-user-image.' . $extension;
                                if (Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)) {
                                    $obj->image     =   $fileName;
                                    // dd($obj['image']);
                                }
                                @unlink(USER_PROFILE_IMAGE_ROOT_PATH . $oldimage);
                            } else {
                                Session::flash('error',  trans("$this->model.INVALID_IMAGE_EXTENSION"));
                                return Redirect::back();
                            }
                        }
                    } else {
                        // dd('d');
                        $image_type_aux = explode("image/", $image_parts[0]);
                        // dd($image_parts);
                        $image_type = $image_type_aux[1];
                        // dd($image_type);
                        $image_base64 = base64_decode($image_parts[1]);
                        // $file = $folderPath . uniqid() . '.png';
                        $filename           =   time() . '-user-image.' . $image_type;
                        // $filename = time() . '.'. $image_type;
                        $file = $folderPath . $filename;

                        $obj['image'] = $filename;
                        // dd($obj['image']);
                        file_put_contents($file, $image_base64);
                        // dd($file);

                        // $playerdetail = new Players;
                        $obj['image'] = $filename;
                        // dd($obj);
                        // dd($playerdetail);
                        // $playerdetail->save();
                    }
                }
                //Set Value
                $obj['username'] = $formData['username'];
                $obj['mobile'] = $formData['mobile'];
                //  $obj['email'] = $formData['email'];
                $obj['gender'] = isset($formData['gender']) ? $formData['gender'] : "";
                $obj['country'] = isset($formData['country']) ? $formData['country'] : "";
                // $obj['state'] = $formData['state'];
                // $obj['city'] = $formData['city'];
                if (isset($formData['dob'])) {
                    $obj['dob'] = date('Y-m-d', strtotime($formData['dob']));
                }
                $obj['team'] = isset($formData['team']) ? $formData['team'] : "";

                $obj['ip'] = @$formData['ip'];
                $obj['deviceId'] = @$formData['deviceId'];
                $obj['address'] = @$formData['address'];
                $obj['versionCode'] = @$formData['versionCode'];
                $obj['device_type'] = @$formData['device_type'];
                //echo"<pre>"; print_r($obj);exit;
                //Update
                DB::table('registerusers')->where('id', $id)->update($obj);
                Session::flash('flash_notice',  trans("Successfully Update User!"));
                Helpers::logActivity('Successfully Update User!', $obj['username']);
                return Redirect::route($this->model . '.view');
            }
        }
        //Get Avater List
        $states = DB::table('states')->get();
        $ipaddress = DB::table('login_logs')->where('user_id', $id)->orderby('id', 'desc')->first();
        return view("admin.$this->model.edit_user", compact('user', 'states', 'ipaddress'));
    } //End

    //View User Detail
    public function viewuser($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Show List
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('registerusers as r')
                ->leftJoin('bank as b', 'b.userid', '=', 'r.id')
                ->leftJoin('pancard as pn', 'pn.userid', '=', 'r.id')
                ->select('b.*', 'pn.userid as pan_userid', 'pn.pan_name', 'pn.pan_number', 'pn.pan_dob', 'pn.pan_dob', 'pn.image as pan_image', 'pn.status as pan_status', 'pn.comment as pan_comment', 'pn.created as pan_created')
                ->where('r.id', $id)
                ->get())
                ->addIndexColumn()
                ->addColumn('created', function ($result) {
                    return date('Y-M-d', strtotime($result->created));
                })->addColumn('pan_created', function ($result) {
                    return date('Y-M-d', strtotime($result->created));
                })->addColumn('image', function ($result) {
                    if ($result->image != "") {
                        return    '<div style= "display:flex; align-items:center;">
        <div style="float:left; width:45%;">
        <img src="' . $result->image . '" style="width:100px;height:100px;">
        </div>
        </div>';
                    } else {
                        return    '<div style= "display:flex; align-items:center;">
        <div style="float:left; width:45%;">
        <img src="' . URL::asset('images/logo.png') . '" style="width:30px;">
        </div>
        </div>';
                    }
                })->addColumn('pan_image', function ($result) {
                    if ($result->image != "") {
                        return    '<div style= "display:flex; align-items:center;">
        <div style="float:left; width:45%;">
        <img src="' . $result->pan_image . '" style="width:100px;height:100px;">
        </div>
        </div>';
                    } else {
                        return    '<div style= "display:flex; align-items:center;">
        <div style="float:left; width:45%;">
        <img src="' . URL::asset('images/logo.png') . '" style="width:100px;">
        </div>
        </div>';
                    }
                })->addColumn('status', function ($result) {
                    if ($result->status == '1') {
                        return '<span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Approved</span>';
                    } elseif ($result->status == '2') {
                        return '<span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Rejected</span>';
                    } elseif ($result->status == '0') {    //position: sticky;
                        return '<span class=""><i class="fa fa-clock-o primary_icn mr-2"></i>Pending</span>';
                    }
                })->addColumn('pan_status', function ($result) {
                    if ($result->status == '1') {
                        return '<span class=""><i class="fa fa-check-circle-o success_icn mr-2"></i>Approved</span>';
                    } elseif ($result->status == '2') {
                        return '<span class=""><i class="fa fa-times-circle-o failed_icn mr-2"></i>Rejected</span>';
                    } elseif ($result->status == '0') {
                        return '<span class=""><i class="fa fa-clock-o primary_icn mr-2"></i>Pending</span>';
                    }
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        return view("admin.$this->model.view_user", compact('id'));
    } //End Function

    //Refer Detail User
    public function referdetail($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Show List
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('registerusers')->where('refer_id', $id)->get())
                ->addIndexColumn()
                ->make(true);
        } //end
        return view("admin.$this->model.refer_detail", compact('id'));
    } //End

    //Withdraw Detail User
    public function withdrawdetail($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Show List
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('withdraw')->where('user_id', $id)->get())
                ->addIndexColumn()
                ->addColumn('created', function ($result) {
                    return date('Y-M-d', strtotime($result->created));
                })
                ->addColumn('approved_date', function ($result) {
                    return date('Y-M-d', strtotime($result->approved_date));
                })
                ->make(true);
        } //end
        return view("admin.$this->model.withdraw_detail", compact('id'));
    } //End

    //Add Cash List User
    public function addcashlist($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Show List
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            $gstcoin = DB::table('userbalances')->where('user_id', $id)->first();
            return Datatables::of(DB::table('transactions')->where('userid', $id)
                ->select('transaction_by', 'amount', 'paymentstatus', 'bal_bonus_amt', 'bal_win_amt', 'bal_fund_amt', 'total_available_amt', 'userid', 'type', 'id')
                ->get())
                ->addIndexColumn()
                ->editColumn('bal_bonus_amt', function ($result) use ($gstcoin) {
                    if ($result->type = 'Affiliation Commission') {
                        return $result->bal_bonus_amt;
                    } else {
                        //$gstcoin= DB::table('userbalances')->where('user_id',$result->userid)->first();
                        return $result->bal_bonus_amt - $gstcoin->gst_bonus;
                    }
                    //return date('Y-M-d',strtotime($result->created));
                })
                ->editColumn('gstbonus_amt', function ($result) use ($gstcoin) {

                    if ($result->type = 'Affiliation Commission') {
                        return $gstcoin->gst_bonus;
                    } else {
                        return $result->bal_bonus_amt - $gstcoin->gst_bonus;
                    }
                })
                /*->addColumn('created',function ($result){
    return date('Y-M-d',strtotime($result->created));
  })*/

                ->make(true);
        } //end
        return view("admin.$this->model.add_cash_list", compact('id'));
    } //End

    //join leauges
    public function joinleauges($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Show List
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('leaugestransactions as lt')
                ->leftJoin('listmatches as lm', 'lt.matchkey', '=', 'lm.matchkey')
                ->where('user_id', $id)
                ->select('lm.*', 'lt.user_id')->get())
                ->addIndexColumn()
                ->addColumn('start_date', function ($result) {
                    return date('Y-M-d', strtotime($result->start_date));
                })->addColumn('action', function ($result) {
                    return '<a href="' . route($this->model . '.match_detail', [base64_encode(serialize($result->user_id)), $result->matchkey]) . '" data-toggle="tooltip" title="View Match" class="btn btn-primary-light icon btn-success mr-1 mt-1" data-original-title="View Match"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                })
                ->make(true);
        } //end
        return view("admin.$this->model.join_leauges", compact('id'));
    } //End

    //Match Detail
    public function matchdetail($id = null, $matchkey = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Show List
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('leaugestransactions as lt')
                ->leftJoin('matchchallenges as mc', 'mc.matchkey', '=', 'lt.matchkey')
                ->where('lt.user_id', $id)
                ->where('lt.matchkey', $matchkey)
                ->select('lt.id', 'lt.user_id', 'lt.matchkey', 'mc.entryfee', 'mc.win_amount', 'mc.maximum_user', 'mc.minimum_user', 'mc.joinedusers', 'lt.bonus', 'lt.winning', 'lt.balance')->get())
                ->addIndexColumn()
                ->make(true);
        } //end
        return view("admin.$this->model.match_list", compact('id', 'matchkey'));
    } //End

    //User Team
    public function userteam($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Get Data To Show Team
        $findjointeam = DB::table('jointeam')
            ->where('userid', $id)
            ->orderBy('id', 'DESC')
            ->get();
        //echo '<pre>';print_r($findjointeam);die;
        $Json = array();
        if (!empty($findjointeam)) {
            $i = 0;
            foreach ($findjointeam as $jointeams) {
                $Json[$i]['teamnumber'] = $jointeams->teamnumber;
                $Json[$i]['teamid'] = $jointeams->id;
                $Json[$i]['matchkey'] = $jointeams->matchkey;
                $playersarr = explode(',', $jointeams->players);
                $playerdetails = DB::table('matchplayers')->whereIn('matchplayers.playerid', $playersarr)->where('matchkey', $jointeams->matchkey)->join('players', 'matchplayers.playerid', '=', 'players.id')->select('players.team', 'matchplayers.role as playerrole', 'matchplayers.credit as playercredit', 'matchplayers.role', 'players.player_name as playername', 'matchplayers.playerid as pid')->get();
                $all = 0;
                $bats = 0;
                $bow = 0;
                $keeper = 0;
                $captain = "";
                $vicecaptain = "";
                foreach ($playerdetails as $play) {
                    if ($play->playerrole == 'bowler') {
                        $bow++;
                    }
                    if ($play->playerrole == 'allrounder') {
                        $all++;
                    }
                    if ($play->playerrole == 'batsman') {
                        $bats++;
                    }
                    if ($play->playerrole == 'keeper') {
                        $keeper++;
                    }
                    //Caption And Vice Caption
                    if ($play->pid == $jointeams->captain) {
                        $captain = $play->playername;
                    }
                    if ($play->pid == $jointeams->vicecaptain) {
                        $vicecaptain = $play->playername;
                    }
                    $Json[$i][$play->playerrole][] = $play;
                }
                $Json[$i]['captain'] = $captain;
                $Json[$i]['vicecaptain'] = $vicecaptain;
                $i++;
            }
        }
        //Show List
        return view("admin.$this->model.user_team", compact('Json'));
    } //End Function

    //Edit Team
    public function editteam($id = null)
    {

        //Get Id
        $id = unserialize(base64_decode($id));
        //Get Data
        $findjointeam = DB::table('jointeam')->where('id', $id)->orderBy('id', 'DESC')->select('*')->first();
        $matchkey = $findjointeam->matchkey;
        $players = explode(',', $findjointeam->players);
        $playerdetails = DB::table('matchplayers')->where('matchkey', $findjointeam->matchkey)->join('players', 'matchplayers.playerid', '=', 'players.id')->select('players.team', 'matchplayers.role as playerrole', 'matchplayers.credit as playercredit', 'matchplayers.role', 'matchplayers.points', 'players.player_name as playername', 'matchplayers.playerid as pid')->get();
        $i = 0;
        $Json = array();
        foreach ($playerdetails as $play) {
            //Select Caption
            if ($play->pid == $findjointeam->captain) {
                $playerdetails[$i]->is_captain = 1;
            } else {
                $playerdetails[$i]->is_captain = 0;
            }
            //Select Vice Captains
            if ($play->pid == $findjointeam->vicecaptain) {
                $playerdetails[$i]->is_vc = 1;
            } else {
                $playerdetails[$i]->is_vc = 0;
            }

            $playerdetails[$i]->is_selected = in_array($play->pid, $players) ? 1 : 0;
            $i++;
            $Json[$play->playerrole][] = $play;
        }
        //Show List
        return view("admin.$this->model.edit_team", compact('id', 'Json', 'playerdetails'));
    } //End Function

    //Update Team
    public function update_team($id, Request $request)
    {
        //Get id
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $input = Input::all();
            //print_r($input);die;
            $insert_data['players'] = implode(',', $input['players']);
            $insert_data['vicecaptain'] = $input['vicecaptain'];
            $insert_data['captain'] = $input['captain'];
            DB::table('jointeam')->where('id', $id)->update($insert_data);
            Session::flash('flash_notice',  trans("Player updated successfully!"));
        }
        return Redirect::route($this->model . '.view');
    } //End Team

    //update refer join
    public function updatereferjoin($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['refer_to_join'] = $status;
        $input['is_yoububer'] = $status;
        DB::table('registerusers')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'User converted successfully!');
        Session::flash('alert-class', 'alert-success');
        return Redirect::back();
    } //End Function

    //Update Percentage
    public function updatepercentage()
    {
        $id = $_POST['getplayer_id'];
        $user_status = $_POST['is_yoububer'] == 0 ? 1 : 0;
        $input['player_percentage'] = $_POST['player_percentage'];
        $input['youtuber_commission_type'] = $_POST['youtuber_commission_type'];
        $input['is_yoububer'] = $user_status;
        $input['refer_to_join'] = $user_status;
        DB::table('registerusers')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'User Percentage Add successfully!');
        Session::flash('alert-class', 'alert-success');
        return Redirect::back();
    } //End Function

    //Update Panurls
    public function updatepanurls()
    {
        $findallpandetails = DB::table('pancard')->select('image', 'id')->get();
        if (!empty($findallpandetails)) {
            foreach ($findallpandetails as $pandeta) {
                $dataupdate = array();
                if ($pandeta->image != "") {
                    $dataupdate['image'] = str_replace('http://', 'https://', $pandeta->image);
                    DB::table('pancard')->where('id', $pandeta->id)->update($dataupdate);
                }
            }
        }
        $findallbankdetails = DB::table('bank')->select('image', 'id')->get();
        if (!empty($findallbankdetails)) {
            foreach ($findallbankdetails as $bankdata) {
                $datanak = array();
                if ($bankdata->image != "") {
                    $datanak['image'] = str_replace('http://', 'https://', $bankdata->image);
                    DB::table('bank')->where('id', $bankdata->id)->update($datanak);
                }
            }
        }
        $findalluserdetails = DB::table('registerusers')->select('image', 'id')->get();
        if (!empty($findalluserdetails)) {
            foreach ($findalluserdetails as $userdata) {
                $userdataupdate = array();
                if ($userdata->image != "") {
                    $userdataupdate['image'] = str_replace('http://', 'https://', $userdata->image);
                    DB::table('registerusers')->where('id', $userdata->id)->update($userdataupdate);
                }
            }
        }
    } //End Function

    /*New Refred Fucntion */

    /*Updated Fucntion 14092021*/
    public function viewreferedusers()
    {
        $formData = Input::all();

        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('registerusers as r1')->join('registerusers as r2', 'r2.id', '=', 'r1.refer_id')
                ->select('r1.id', 'r1.username', 'r1.email', 'r1.mobile', 'r1.team', 'r1.activation_status', 'r1.is_yoububer', 'r2.id as referral_id', 'r2.email as referral_email', 'r2.username as referral_username', 'r2.mobile as referralmobile')->limit(1000)
                ->where(function ($query) use ($formData) {
                    if (isset($formData['filter_columns'])) {
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('r1.mobile', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_referemail'])) {
                            $query->where('r2.mobile', 'like', '%' . $formData['filter_columns']['filter_referemail'] . '%');
                        }
                        if (isset($formData['filter_columns']['filter_referemobile'])) {
                            $query->where('r2.mobile', 'like', '%' . $formData['filter_columns']['filter_referemobile'] . '%');
                        }
                    }
                })
                ->get())
                ->addIndexColumn()

                ->addColumn('users_referal_username', function ($result) {
                    // return $users_referal['username'] = $result->referral_username;
                    return $users_referal['username'] = $result->referralmobile;
                })
                ->addColumn('users_referal_email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->referral_id))) . '" style="text-decoration:underline;">' . $result->referral_email . '</a>';
                })
                ->addColumn('mobile', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" style="text-decoration:underline;">' . $result->mobile . '</a>';
                })
                ->addColumn('action', function ($result) {

                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" data-toggle="tooltip" title="Deactivate" class="btn btn-danger mr-1 mt-1 action-users"><i class="fa fa-ban"></i></a>';
                    }

                    //youtuber users not show in all registerusrs
                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . $result->id . '" data-status="' . $result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-success mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize($result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-danger mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }

                    //Withdraw
                    if (isset($result->withdraw_id) && !empty($result->withdraw_id)) {
                        $withdraw_link = '<a href="' . route($this->model . '.withdraw_detail', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Withdraw Amount" class="btn btn-warning mr-1 mt-1" data-original-title="withdraw Amount"><i class="fa fa-inr p-1" aria-hidden="true"></i></a>';
                    } else {
                        $withdraw_link = '';
                    }

                    //Teansacton
                    if (isset($result->transactions_id) && !empty($result->transactions_id)) {
                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '';
                    }

                    //Show Joined Leauges
                    if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                        $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leauges" class="btn btn-dark mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                    } else {
                        $joinedleauges_link = '';
                    } //End Function

                    //Join team Link jointeam_id
                    if (isset($result->jointeam_id) && !empty($result->jointeam_id)) {
                        $jointeam_link = '<a href="' . route($this->model . '.user_team', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="User Team" class="btn btn-dark mr-1 mt-1"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $jointeam_link = '';
                    } //End Function

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'
                        . $withdraw_link
                        . $transactions_link
                        . $activation_status
                        . $is_youtuber
                        . $joinedleauges_link
                        . $jointeam_link;
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end

        return view("admin.$this->model.viewreferedusers");
    }

    /* Update Function 14092021*/








    public function viewreferedusers_backup()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('registerusers')->where('refer_id', '!=', 0)->limit(1000)
                ->where(function ($query) use ($formData) {
                    if (isset($formData['filter_columns'])) {
                        if (isset($formData['filter_columns']['filter_email'])) {
                            $query->where('email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                        }
                    }
                })
                ->get())
                ->addIndexColumn()
                /*->addColumn('id',function ( $result){
    return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->id.'</a>';
  })*/
                ->addColumn('users_referal_username', function ($result) {
                    $query = DB::table('registerusers')->select('id', 'username', 'email')->where('id', $result->refer_id)->first();
                    if (!empty($query)) {
                        $users_referal['username'] = $query->username;
                        return $query->username;;
                    } else {
                        $users_referal['username'] = '';
                    }
                })
                ->addColumn('users_referal_email', function ($result) {
                    $query = DB::table('registerusers')->select('id', 'username', 'email')->where('id', $result->refer_id)->first();
                    if (!empty($query)) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($query->id))) . '" style="text-decoration:underline;">' . $query->email . '</a>';
                    } else {
                        $users_referal['email'] = '';
                    }
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" style="text-decoration:underline;">' . $result->email . '</a>';
                })
                ->addColumn('action', function ($result) {
                    /*$activation_status='';
    if(strtolower($result->activation_status)!='activated'){
    $activation_status='<a href="'.route($this->model.'.update_user_status',[base64_encode(serialize($result->id)),'activated']).'" class="btn btn-success mr-1 mt-1 action-users">Activate</a></br>';
  }else{
  $activation_status='<a href="'.route($this->model.'.update_user_status',[base64_encode(serialize($result->id)),'deactivated']).'" class="btn btn-danger mr-1 mt-1 action-users">Deactivate</a></br>';
}

return '<a href="'.route($this->model.'.transactions',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
.$activation_status;*/

                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" data-toggle="tooltip" title="Deactivate" class="btn btn-danger mr-1 mt-1 action-users"><i class="fa fa-ban"></i></a>';
                    }

                    //youtuber users not show in all registerusrs
                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . $result->id . '" data-status="' . $result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-success mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize($result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-danger mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }

                    //Withdraw
                    if (isset($result->withdraw_id) && !empty($result->withdraw_id)) {
                        $withdraw_link = '<a href="' . route($this->model . '.withdraw_detail', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Withdraw Amount" class="btn btn-warning mr-1 mt-1" data-original-title="withdraw Amount"><i class="fa fa-inr p-1" aria-hidden="true"></i></a>';
                    } else {
                        $withdraw_link = '';
                    }

                    //Teansacton
                    if (isset($result->transactions_id) && !empty($result->transactions_id)) {
                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '';
                    }

                    //Show Joined Leauges
                    if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                        $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leauges" class="btn btn-dark mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                    } else {
                        $joinedleauges_link = '';
                    } //End Function

                    //Join team Link jointeam_id
                    if (isset($result->jointeam_id) && !empty($result->jointeam_id)) {
                        $jointeam_link = '<a href="' . route($this->model . '.user_team', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="User Team" class="btn btn-dark mr-1 mt-1"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $jointeam_link = '';
                    } //End Function

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'
                        . $withdraw_link
                        . $transactions_link
                        . $activation_status
                        . $is_youtuber
                        . $joinedleauges_link
                        . $jointeam_link;
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end

        return view("admin.$this->model.viewreferedusers");
    }


    /* New Refered Fucntion */

    //View refered user





    public function viewreferedusers_old()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('registerusers')->where('refer_id', '!=', 0)->limit(1000)->get())
                ->addIndexColumn()
                /*->addColumn('id',function ( $result){
    return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->id.'</a>';
  })*/
                ->addColumn('users_referal', function ($result) {
                    $query = DB::table('registerusers')->select('id', 'username', 'email')->where('id', $result->refer_id)->first();
                    if (!empty($query)) {
                        $users_referal['username'] = $query->username;
                        $users_referal['email'] = '<a href="' . route($this->model . '.details', base64_encode(serialize($query->id))) . '" style="text-decoration:underline;">' . $query->email . '</a>';
                        return $users_referal;
                    } else {
                        $users_referal['username'] = '';
                        $users_referal['email'] = '';
                    }
                })
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" style="text-decoration:underline;">' . $result->email . '</a>';
                })
                ->addColumn('action', function ($result) {
                    /*$activation_status='';
    if(strtolower($result->activation_status)!='activated'){
    $activation_status='<a href="'.route($this->model.'.update_user_status',[base64_encode(serialize($result->id)),'activated']).'" class="btn btn-success mr-1 mt-1 action-users">Activate</a></br>';
  }else{
  $activation_status='<a href="'.route($this->model.'.update_user_status',[base64_encode(serialize($result->id)),'deactivated']).'" class="btn btn-danger mr-1 mt-1 action-users">Deactivate</a></br>';
}

return '<a href="'.route($this->model.'.transactions',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
.$activation_status;*/

                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" data-toggle="tooltip" title="Activate" class="btn btn-success mr-1 mt-1 action-users"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" data-toggle="tooltip" title="Deactivate" class="btn btn-danger mr-1 mt-1 action-users"><i class="fa fa-ban"></i></a>';
                    }

                    //youtuber users not show in all registerusrs
                    $is_youtuber = '';
                    if ($result->is_yoububer == '0') {
                        $is_youtuber = '<a href="javascript:void(0);" data-toggle="modal" data-id="' . $result->id . '" data-status="' . $result->is_yoububer . '" data-toggle="tooltip" title="Convert to Youtuber" class="btn btn-success mr-1 mt-1 submitper"><i class="fa fa-retweet"></i></a>';
                    } else {
                        $is_youtuber = '<a href="' . route($this->model . '.update_refer_join', [base64_encode(serialize($result->id)), '0']) . '" data-toggle="tooltip" title="Convert to User" class="btn btn-danger mr-1 mt-1"><i class="fa fa-retweet"></i></a>';
                    }

                    //Withdraw
                    if (isset($result->withdraw_id) && !empty($result->withdraw_id)) {
                        $withdraw_link = '<a href="' . route($this->model . '.withdraw_detail', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Withdraw Amount" class="btn btn-warning mr-1 mt-1" data-original-title="withdraw Amount"><i class="fa fa-inr p-1" aria-hidden="true"></i></a>';
                    } else {
                        $withdraw_link = '';
                    }

                    //Teansacton
                    if (isset($result->transactions_id) && !empty($result->transactions_id)) {
                        $transactions_link = '<a href="' . route($this->model . '.add_cash_list', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1" data-toggle="tooltip" title="Add Cash Summary" ><i class="fa fa-plus" aria-hidden="true"></i></a>';
                    } else {
                        $transactions_link = '';
                    }

                    //Show Joined Leauges
                    if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                        $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leauges" class="btn btn-dark mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                    } else {
                        $joinedleauges_link = '';
                    } //End Function

                    //Join team Link jointeam_id
                    if (isset($result->jointeam_id) && !empty($result->jointeam_id)) {
                        $jointeam_link = '<a href="' . route($this->model . '.user_team', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="User Team" class="btn btn-dark mr-1 mt-1"><i class="fa fa-user-plus" aria-hidden="true"></i></a>';
                    } else {
                        $jointeam_link = '';
                    } //End Function

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.edit_user', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i></a>'
                        . $withdraw_link
                        . $transactions_link
                        . $activation_status
                        . $is_youtuber
                        . $joinedleauges_link
                        . $jointeam_link;
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end

        return view("admin.$this->model.viewreferedusers");
    } //End Function

    //View active users
    public function viewactiveusers()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('registerusers')->where('activation_status', 'activated')->limit(1000)->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" style="text-decoration:underline;">' . $result->id . '</a>';
                })
                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" class="btn btn-success mr-1 mt-1 action-users">Activate</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" class="btn btn-danger mr-1 mt-1 action-users">Deactivate</a></br>';
                    }

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . $activation_status;
                })
                ->escapeColumns([])
                ->make(true);
        } //end


        return view("admin.$this->model.viewactiveusers");
    } //End Function

    //View deactived users
    public function viewdeactivedusers()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('registerusers')->where('activation_status', 'deactivated')->limit(1000)->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" style="text-decoration:underline;">' . $result->id . '</a>';
                })
                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'activated']) . '" class="btn btn-success mr-1 mt-1 action-users">Activate</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_user_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" class="btn btn-danger mr-1 mt-1 action-users">Deactivate</a></br>';
                    }

                    return '<a href="' . route($this->model . '.transactions', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1 " data-original-title="User Transactions"><i class="fa fa-exchange" aria-hidden="true"></i></a>'
                        . $activation_status;
                })
                ->escapeColumns([])
                ->make(true);
        } //end


        return view("admin.$this->model.viewdeactivedusers");
    } //End Function

    public function downloadWalletHistory($uid)
    {

        date_default_timezone_set("Asia/Kolkata");
        //Get ID
        $id = unserialize(base64_decode($uid));
        if (empty($formData['end_date']) || empty($formData['status'])) {
            return redirect()->back()->with('successs', 'Please select data after download');
        }

        $formData = Input::all();
        $output1        = "";
        $output1 .= '"Type",';
        $output1 .= '"Amount",';
        $output1 .= '"Status",';
        $output1 .= '"Winning Balance",';
        $output1 .= '"Cash Balance",';
        $output1 .= '"Bonus Balance",';
        $output1 .= '"GST Bonus",';
        $output1 .= '"Affiliation Amount",';
        $output1 .= '"Total Available Balance",';
        $output1 .= '"Challenge ID",';
        $output1 .= '"Deposit By",';
        $output1 .= '"Match Title",';
        $output1 .= '"Date",';
        $output1 .= "\n";

        if (count($formData) > 0 && $formData['start_date'] != Null && $formData['end_date'] != Null) {

            if ($formData['start_date'] < $formData['end_date'] && $formData['end_date'] > $formData['start_date']) {

                $start_date = date('Y-m-d', strtotime($formData['start_date']));
                $end_date = date('Y-m-d', strtotime($formData['end_date']));
                //Query
                $query = DB::table('transactions')
                    ->leftJoin('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')
                    //->leftJoin('listmatches','matchchallenges.matchkey','=','listmatches.matchkey')
                    ->leftJoin('listmatches', 'matchchallenges.matchkey', '=', 'listmatches.matchkey')
                    ->where('transactions.userid', $id);
                if (!empty($start_date)) {
                    $query->whereDate('transactions.created', '>=', $start_date);
                }
                if (!empty($end_date)) {
                    $query->whereDate('transactions.created', '<=', $end_date);
                }
                if (!empty($formData['status'])) {

                    if ($formData['status'] == 'deposit') {
                        $status = 'Add Fund';
                    }
                    if ($formData['status'] == 'withdraw') {
                        $status = 'Amount Withdrawn';
                    }
                    $query->where('transactions.type', '=', $status);
                }
                if ($start_date || $end_date) {
                    $allplayers = $query->orderBY('transactions.id', 'DESC')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')
                        //->select('registerusers.email','transactions.*','listmatches.title')
                        ->select('registerusers.email', 'transactions.type', 'transactions.paymentstatus', 'transactions.bal_win_amt', 'transactions.bal_fund_amt', 'transactions.bal_bonus_amt', 'transactions.bal_gst_bonus_amt', 'transactions.bal_affi_amt', 'transactions.total_available_amt', 'transactions.challengeid', 'transactions.created', 'transactions.amount', 'listmatches.title', 'transactions.transaction_by')

                        //->limit(100)
                        ->get();
                }

                // dd('true');
                //dd($allplayers);
                if (!empty($allplayers)) {
                    foreach ($allplayers as $player) {
                        $depoditby = '';
                        if ($player->transaction_by == 'PHONEPAY' || $player->transaction_by == 'SubPaisa' || $player->transaction_by == 'SONICPAY' || $player->transaction_by == 'admin' || $player->transaction_by == 'razorPay') {
                            $depoditby =  $player->transaction_by;
                        }
                        $output1 .= '"' . $player->type . '",';
                        $output1 .= '"' . $player->amount . '",';
                        $output1 .= '"' . $player->paymentstatus . '",';
                        $output1 .= '"' . $player->bal_win_amt . '",';
                        $output1 .= '"' . $player->bal_fund_amt . '",';
                        $output1 .= '"' . $player->bal_bonus_amt . '",';
                        $output1 .= '"' . $player->bal_gst_bonus_amt . '",';
                        $output1 .= '"' . $player->bal_affi_amt . '",';
                        $output1 .= '"' . $player->total_available_amt . '",';
                        $output1 .= '"' . $player->challengeid . '",';
                        $output1 .= '"' . $depoditby . '",';
                        $output1 .= '"' . $player->title . '",';
                        $output1 .= '"' . date('Y-m-d', strtotime($player->created)) . '",';
                        $output1 .= "\n";
                    }
                }
                $filename =  "Details-userwithdrawl.csv";
                header('Content-type: application/csv');
                header('Content-Disposition: attachment; filename=' . $filename);
                echo $output1;
                exit;
            } else {
                // dd('back');
                return redirect()->back()->with('successs', 'end date less than start date');
            }
        } elseif (!empty($formData['status']) && empty($formData['start_date'])) {

            $query = DB::table('transactions')
                ->leftJoin('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')->leftJoin('listmatches', 'matchchallenges.matchkey', '=', 'listmatches.matchkey')->where('transactions.userid', $id);

            if ($formData['status'] == 'deposit') {
                $status = 'Add Fund';
            }
            if ($formData['status'] == 'withdraw') {
                $status = 'Amount Withdrawn';
            }
            $query->where('transactions.type', '=', $status)->where('transactions.paymentstatus', 'confirmed');
            $allplayers = $query->orderBY('transactions.id', 'DESC')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')->select('registerusers.email', 'transactions.*', 'listmatches.title')->get();

            if (!empty($allplayers)) {
                foreach ($allplayers as $player) {
                    $depoditby = '';
                    if ($player->transaction_by == 'PHONEPAY' || $player->transaction_by == 'SubPaisa' || $player->transaction_by == 'SONICPAY' || $player->transaction_by == 'admin' || $player->transaction_by == 'razorPay') {
                        $depoditby =  $player->transaction_by;
                    }
                    $output1 .= '"' . $player->type . '",';
                    $output1 .= '"' . $player->amount . '",';
                    $output1 .= '"' . $player->paymentstatus . '",';
                    $output1 .= '"' . $player->bal_win_amt . '",';
                    $output1 .= '"' . $player->bal_fund_amt . '",';
                    $output1 .= '"' . $player->bal_bonus_amt . '",';
                    $output1 .= '"' . $player->bal_gst_bonus_amt . '",';
                    $output1 .= '"' . $player->bal_affi_amt . '",';
                    $output1 .= '"' . $player->total_available_amt . '",';
                    $output1 .= '"' . $player->challengeid . '",';
                    $output1 .= '"' . $depoditby . '",';
                    $output1 .= '"' . $player->title . '",';
                    $output1 .= '"' . date('Y-m-d', strtotime($player->created)) . '",';
                    $output1 .= "\n";
                }
            }
            $filename =  "Details-userwithdrawl.csv";
            header('Content-type: application/csv');
            header('Content-Disposition: attachment; filename=' . $filename);
            echo $output1;
            exit;
        }



        $query = DB::table('withdraw')->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->join('bank', 'bank.userid', '=', 'registerusers.id')->join('pancard', 'pancard.userid', '=', 'registerusers.id')->where('withdraw.status', '0')->select('registerusers.*', 'bank.*', 'pancard.*', 'withdraw.*', 'registerusers.id as reg_id', 'bank.id as bank_id', 'pancard.id as pan_id', 'withdraw.id as withdraw_id', 'registerusers.activation_status as reg_status', 'bank.status as bank_status', 'pancard.status as pan_status', 'withdraw.status as withdraw_status', 'withdraw.amount as withdraw_amount', 'withdraw.created as withdraw_request');
        if (request()->has('start_date')) {
            $start_date = request('start_date');
            // 			$start_date = date('Y-m-d H:i:s', strtotime('+10 minutes', strtotime(request('start_date'))));
            $start_date =  strtotime(request('start_date'));
            if ($start_date != "") {
                $query->whereDate('withdraw.created', '>=', date('Y-m-d', strtotime($start_date)));
            }
        }
        if (request()->has('end_date')) {
            $end_date = request('end_date');
            if ($end_date != "") {
                $query->whereDate('withdraw.created', '<=', date('Y-m-d', strtotime($end_date)));
            }
        }
        $getlist = $query->orderBY('withdraw.created', 'DESC')->get();
        if (!empty($getlist)) {
            foreach ($getlist as $get) {
                $output1 .= '"' . $get->reg_id . '",';
                $output1 .= "'" . $get->accno . ",";
                $output1 .= '"' . $get->withdraw_amount . '",';
                $output1 .= '"' . strtoupper($get->username) . '",';
                $output1 .= '"' . $get->withdraw_request_id . '",';
                $output1 .= '"' . strtoupper($get->ifsc) . '",';
                $output1 .= '"' . strtoupper($get->bankname) . '",';
                $output1 .= '"' . strtoupper($get->bankbranch) . '",';
                $output1 .= '"' . $get->email . '",';
                $output1 .= '"' . date('d-M-Y', strtotime($get->withdraw_request)) . '",';
                $output1 .= '"",';
                $output1 .= '"",';
                $output1 .= "\n";
            }
        }
        $filename =  "Details-userwithdrawl.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function viewtransactions($uid)
    {
        //print_r('expression');die;
        //Set Time

        // count($formData) > 0
        date_default_timezone_set("Asia/Kolkata");
        //Get ID
        $id = unserialize(base64_decode($uid));
        //print_r($id);die;
        //Get Post Value
        $start_date = '';
        $end_date = '';
        $status = '';
        $formData = Input::all();
        $start_date = '';
        $end_date = '';



        // start
        if (count($formData) > 0 && $formData['start_date'] != Null && $formData['end_date'] != Null) {

            if ($formData['start_date'] < $formData['end_date'] && $formData['end_date'] > $formData['start_date']) {






                $start_date = date('Y-m-d', strtotime($formData['start_date']));
                $end_date = date('Y-m-d', strtotime($formData['end_date']));
                //Query
                $query = DB::table('transactions')
                    ->leftJoin('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')
                    //->leftJoin('listmatches','matchchallenges.matchkey','=','listmatches.matchkey')
                    ->leftJoin('listmatches', 'matchchallenges.matchkey', '=', 'listmatches.matchkey')
                    ->where('transactions.userid', $id);
                if (!empty($start_date)) {
                    $query->whereDate('transactions.created', '>=', $start_date);
                }
                if (!empty($end_date)) {
                    $query->whereDate('transactions.created', '<=', $end_date);
                }
                if (!empty($formData['status'])) {

                    if ($formData['status'] == 'deposit') {
                        $status = 'Add Fund';
                    }
                    if ($formData['status'] == 'withdraw') {
                        $status = 'Amount Withdrawn';
                    }
                    $query->where('transactions.type', '=', $status);
                }
                if ($start_date || $end_date) {
                    $allplayers = $query->orderBY('transactions.id', 'DESC')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')
                        //->select('registerusers.email','transactions.*','listmatches.title')
                        ->select('registerusers.email', 'transactions.type', 'transactions.paymentstatus', 'transactions.bal_win_amt', 'transactions.bal_fund_amt', 'transactions.bal_bonus_amt', 'transactions.bal_gst_bonus_amt', 'transactions.bal_affi_amt', 'transactions.total_available_amt', 'transactions.challengeid', 'transactions.created', 'transactions.amount', 'listmatches.title', 'transactions.transaction_by', 'transactions.transaction_id')

                        //->limit(100)
                        ->get();
                }

                // dd('true');
                //dd($allplayers);
                return view("admin.$this->model.viewtransactions", compact('id', 'allplayers', 'status', 'start_date', 'end_date'));
            } else {
                // dd('back');
                return redirect()->back()->with('successs', 'end date less than start date');
            }
        } elseif (!empty($formData['status']) && empty($formData['start_date'])) {

            $query = DB::table('transactions')
                ->leftJoin('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')->leftJoin('listmatches', 'matchchallenges.matchkey', '=', 'listmatches.matchkey')->where('transactions.userid', $id);

            if ($formData['status'] == 'deposit') {
                $status = 'Add Fund';
            }
            if ($formData['status'] == 'withdraw') {
                $status = 'Amount Withdrawn';
            }

            if ($formData['status'] == 'admin') {
                $query->where('transactions.transaction_by', '=', 'admin');
            } else {
                $query->where('transactions.type', 'like', '%' . $status . '%');
            }

            $allplayers = $query->orderBY('transactions.id', 'DESC')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')->select('registerusers.email', 'transactions.*', 'listmatches.title')->get();
            $status = $formData['status'];
            return view("admin.$this->model.viewtransactions", compact('id', 'allplayers', 'status', 'start_date', 'end_date'));
        } else {
            // dd('direct');
            return view("admin.$this->model.viewtransactions", compact('id', 'status', 'start_date', 'end_date'));
        }
    }

    //User Transactions
    public function viewtransactions_old($uid)
    {
        //print_r('expression');die;
        //Set Time
        date_default_timezone_set("Asia/Kolkata");
        //Get ID
        $id = unserialize(base64_decode($uid));
        // print_r($id);die;
        //Get Post Value
        $formData = Input::all();

        if (isset($formData) && !empty($formData)) {
            $start_date = date('Y-m-d', strtotime($formData['start_date']));
            $end_date = date('Y-m-d', strtotime($formData['end_date']));
            //Query
            $query = DB::table('transactions')
                ->leftJoin('matchchallenges', 'matchchallenges.id', '=', 'transactions.challengeid')->leftJoin('listmatches', 'matchchallenges.matchkey', '=', 'listmatches.matchkey')->where('transactions.userid', $id);
            if (!empty($start_date)) {
                $query->whereDate('transactions.created', '>=', $start_date);
            }
            if (!empty($end_date)) {
                $query->whereDate('transactions.created', '<=', $end_date);
            }
            if ($start_date || $end_date) {
                $allplayers = $query->orderBY('transactions.id', 'DESC')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')->select('registerusers.email', 'transactions.*', 'listmatches.title')->get();
            }
            return view("admin.$this->model.viewtransactions", compact('id', 'allplayers'));
        } else {
            return view("admin.$this->model.viewtransactions", compact('id'));
        }
    } //End Funcion

    // return Datatables::of(DB::table('transactions')
    // 			->leftJoin('matchchallenges','matchchallenges.id','=','transactions.challengeid')->leftJoin('listmatches','matchchallenges.matchkey','=','listmatches.matchkey')
    // 			->join('registerusers','registerusers.id','=','transactions.userid')
    // 			->where('transactions.userid',$id)
    // 			->whereDate('transactions.created', '>=',$start_date)
    // 			->whereDate('transactions.created', '<=',$end_date)
    // 			->orderBY('transactions.id','DESC')
    // 			->select('registerusers.email','transactions.*','listmatches.title')
    // 			->limit(1000)->get())
    //         ->addIndexColumn()
    //         ->addColumn('created', function ($result) {
    //              return date('Y-m-d H:i:s',strtotime($result->created));
    //          })
    //          ->escapeColumns([])
    //          ->make(true);

    //Detail
    public function details($id)
    {

        $id = unserialize(base64_decode($id));
        //Get All User
        $allplayers = DB::table('registerusers')->where('registerusers.id', $id)->first();
        //Bank Detail
        $bank = DB::table('bank')
            ->join('registerusers', 'registerusers.id', '=', 'bank.userid')
            ->where('registerusers.id', $id)
            ->where('bank.status', '0')
            ->where('registerusers.pan_verify', '1')
            ->where('registerusers.mobile_verify', '1')
            ->where('registerusers.email_verify', '1')
            ->select('registerusers.email', 'registerusers.username', 'registerusers.mobile_verify', 'registerusers.email_verify', 'registerusers.pan_verify', 'bank.*')->first();
        //Pancard
        $pancard = DB::table('pancard')
            ->join('registerusers', 'registerusers.id', '=', 'pancard.userid')
            ->where('registerusers.id', $id)
            ->where('pancard.status', '0')
            ->where('registerusers.pan_verify', '0')
            ->where('registerusers.mobile_verify', '1')
            ->where('registerusers.email_verify', '1')
            ->select('registerusers.email', 'registerusers.username', 'registerusers.mobile_verify', 'registerusers.email_verify', 'pancard.*')->first();
        //Get Pan Card ID
        $findpancardid = DB::table('pancard')
            ->where('userid', $id)
            ->select('id')->first();
        //Get Bank ID
        $findbankcardid = DB::table('bank')
            ->where('userid', $id)
            ->select('id')->first();

        //Get aadhar

        $findupiid = DB::table('upi_verify')
            ->where('user_id', $id)
            ->select('id')->first();

            $findaadharcardid = DB::table('adhar_card_details')
                ->where('userid', $id)
                ->select('id')->first();
        //print_r($findpancardid);die;
        //Show Page
        return view("admin.$this->model.details", compact('allplayers', 'bank', 'pancard', 'findpancardid', 'findbankcardid', 'findupiid','findaadharcardid'));
    } //End Function

    //Verify Pan List
    public function verifypan(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    $query = DB::table('pancard as p')
                        ->join('registerusers as r', 'r.id', '=', 'p.userid')
                        ->where('p.status', '0')
                        // ->orwhere('r.pan_verify', '0')
                        ->where('r.mobile_verify', '1')
                        ->where('r.email_verify', '1')
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['filter_columns'])) {
                                if (isset($formData['filter_columns']['filter_username'])) {
                                    $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                                }
                                if (isset($formData['filter_columns']['filter_email'])) {
                                    $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                                }
                            }
                        })
                        ->select('r.email', 'r.username', 'r.mobile_verify', 'r.email_verify', 'p.*', 'r.mobile')
                        ->orderBY('p.created_at', 'ASC')
                        ->get()
                )
                    ->addIndexColumn()
                    ->addColumn('mobile', function ($result) {
                        return '<a href="' . route($this->model . '.view_pan_details', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->mobile . '</a>';
                    })
                    ->addColumn('username', function ($result) {
                        return $result->username;
                            //return '<a href="'.route($this->model.'.view_pan_details', base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->username.'</a>'
                        ;
                    })
                    ->addColumn('created_at', function ($result) {
                        if ($result->created_at != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->created_at));
                        } else {
                            return '';
                        }
                    })

                    ->addColumn('status', function ($result) {
                        $status = '';
                        if ($result->status == '1') {
                            $status = 'Verified';
                        } elseif ($result->status == '0') {
                            $status = 'Pending';
                        } elseif ($result->status == '2') {
                            $status = 'Cancel';
                        }
                        return $status;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end

        }
        return view("admin.$this->model.verifypan");
    } //End Function

    //Verify Pan List
    public function verifyupi(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    $query = DB::table('upi_verify as u')
                        ->join('registerusers as r', 'r.id', '=', 'u.user_id')
                        ->where('u.status', '0')
                        // ->orwhere('r.pan_verify', '0')
                        ->where('r.mobile_verify', '1')
                        //  ->where('r.email_verify', '1')
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['filter_columns'])) {
                                if (isset($formData['filter_columns']['filter_username'])) {
                                    $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                                }
                                if (isset($formData['filter_columns']['filter_email'])) {
                                    $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                                }
                            }
                        })
                        ->select('r.email', 'r.mobile', 'r.username', 'r.mobile_verify', 'r.email_verify', 'u.*')
                        ->orderBY('u.created_at', 'ASC')
                        ->get()
                )
                    ->addIndexColumn()
                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.view_upi_details', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->mobile . '</a>';
                    })
                    ->addColumn('username', function ($result) {
                        return $result->username;
                            //return '<a href="'.route($this->model.'.view_pan_details', base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->username.'</a>'
                        ;
                    })
                    ->addColumn('created', function ($result) {
                        if ($result->created_at != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->created_at));
                        } else {
                            return '';
                        }
                    })

                    ->addColumn('status', function ($result) {
                        $status = '';
                        if ($result->status == '1') {
                            $status = 'Verified';
                        } elseif ($result->status == '0') {
                            $status = 'Pending';
                        } elseif ($result->status == '2') {
                            $status = 'Cancel';
                        }
                        return $status;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end

        }

        return view("admin.$this->model.upi_verify");
    } //End Function

    //View Pan Card Detail
    public function viewupidetails($id)
    {
        //Get Data
        $id = unserialize(base64_decode($id));
        //Get Data
        $upidetails = DB::table('upi_verify')
            ->where('upi_verify.id', $id)
            ->join('registerusers', 'registerusers.id', '=', 'upi_verify.user_id')
            ->select('upi_verify.*', 'registerusers.mobile', 'registerusers.dob', 'registerusers.username')
            ->first();
        //echo "<pre>"; print_r($pancarddetails); die();
        if (!empty($upidetails)) {
            return view("admin.$this->model.viewupidetails", compact('upidetails'));
        } else {
            Session::flash('error', 'Data Not Found!');
            return Redirect::back();
        }
    } //End Function



    //View Pan Card Detail
    public function viewpandetails($id)
    {

        //Get Data
        $id = unserialize(base64_decode($id));
        //Get Data
        $pancarddetails = DB::table('pancard')
            ->where('pancard.id', $id)
            ->join('registerusers', 'registerusers.id', '=', 'pancard.userid')
            ->select('pancard.*', 'registerusers.email', 'registerusers.dob')
            ->first();
        //echo "<pre>"; print_r($pancarddetails); die();
        if (!empty($pancarddetails)) {
            return view("admin.$this->model.viewpandetails", compact('pancarddetails'));
        } else {
            Session::flash('error', 'Data Not Found!');
            return Redirect::back();
        }
    } //End Function

    //Update Pan Status
    public function updatepanstatus(Request $request)
    {

        $status = "";
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];
            $status = $input['status'];
            if (isset($input['pan_name'])) {
                $input['pan_name'] = strtoupper($input['pan_name']);
            }
            if (isset($input['pan_number'])) {
                $input['pan_number'] = strtoupper($input['pan_number']);
            }
            if (isset($input['image'])) {
                $filee = array_filter($input['image']);
                unset($input['image']);
                if (!empty($filee)) {
                    $destinationPath = 'uploads';
                    $oldimage = $input['oldimage'];
                    if ($oldimage != "") {
                        File::delete($oldimage);
                    }
                    unset($input['oldimage']);
                    if (!empty($filee)) {
                        $fileName  = 'select2win-pancard-' . rand(100, 999);
                        $imageName = Helpers::imageUpload($filee, $destinationPath, $fileName);
                        $input['image'] = config()->get('constants.PROJECT_URL') . 'uploads/pan_image/' . $imageName;
                    }
                }
            }
            unset($input['oldimage']);
        }
        if ($status != "") {
            if ($status == 1) {
                $st = 'Verified';
            }
        }
        unset($input['_token']);
        $req['pan_verify'] = $status;
        DB::table('pancard')->where('id', $id)->update($input);
        $findlastow = DB::table('pancard')->where('id', $id)->first();
        if (!empty($findlastow)) {
            $userid = $findlastow->userid;
        }
        $finduserbonus = DB::table('registerusers')->where('id', $userid)->select('panbonus', 'email', 'team')->first();
        if ($status == 1) {
            $st = 'Verified';
        }
        if ($status == 2) {
            $st = 'rejected';
            $email = $finduserbonus->email;
            //Send Mail Template
            $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
            //Set Subject
            // $emailsubject = $email_templates->subject.'- FC';
            // //Set Email Body
            // $email_body=array('{NAME}','{comment}');
            // //Replace
            // $rep_Array =array(ucwords($finduserbonus->team),$input['comment']);
            // //Replase Value
            // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
            // //Send MAil
            // $msg = Helpers::mailheader();
            // $msg.= $messageBody;
            // $msg.= Helpers::mailfooter();
            // Helpers::mailsentFormat($email,$emailsubject,$msg);
            Helpers::logActivity('Pancard Rejected', $userid);
        }
        if ($st == 'Verified') {
            $req['username'] = $findlastow->pan_name;
            $req['dob'] = date('Y-m-d', strtotime($findlastow->pan_dob));
            $req['panbonus'] = 1;
            if ($finduserbonus->panbonus == 0) {
                //ApiController::getbonus($userid,'Pan Card');
            }
            //Email
            $email = $finduserbonus->email;
            //Send Mail Template
            // $email_templates = DB::table('email_templates')->where('action','Your PAN card documents approved')->first();
            //Set Subject
            // print_r($email_templates);die;
            // $emailsubject = $email_templates->subject.'- FC';
            // //Set Email Body
            // $email_body=array('{NAME}');
            // //Replace
            // $rep_Array =array(ucwords($finduserbonus->team));
            // //Replase Value
            // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
            // $msg = Helpers::mailheader();
            // $msg.= $messageBody;
            // $msg.= Helpers::mailfooter();
            // Helpers::mailsentFormat($email,$emailsubject,$msg);
        }

        if ($status == 1) {
            // DB::table('registerusers')->where('id',$userid)->update($req);
            $exist_signup = DB::table('transactions')->where('userid', $userid)->where('type', PAN_VERIFY_SIGNUP_BONUS_STMT)->count();
            /* if($exist_signup<1){
            $userbalance = UserBalance::where("user_id", $userid)->first();

            if(empty($userbalance))
            {
            DB::table('userbalances')->insert(['user_id'=>$userid]);
            $userbalance = UserBalance::where("user_id", $userid)->first();
            }
            if(!empty($userbalance)) {
              $userbalance->bonus += PAN_VERIFY_SIGNUP_BONUS;
              $userbalance->save();

              Transaction::insert([
                'userid'=> $userid,
                'amount' => PAN_VERIFY_SIGNUP_BONUS,
                'type' => PAN_VERIFY_SIGNUP_BONUS_STMT,
                'paymentstatus' => 'confirmed',
                'transaction_by' => 'PLAYNWIN11',
                'transaction_id' => 'PLAYNWIN11-SIGNUP-'.time(),
                'bonus_amt' => PAN_VERIFY_SIGNUP_BONUS,
                'bal_fund_amt' => $userbalance->balance,
                'bal_win_amt' => $userbalance->winning,
                'bal_bonus_amt' => $userbalance->bonus,
                'bal_gst_bonus_amt' => $userbalance->gst_bonus,
                'bal_affi_amt' => $userbalance->affiliation_commission,
                'total_available_amt' => round(($userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission),2)
              ]);
            }
        } */

            Helpers::logActivity('Pancard Approved', $userid);
        }
        Helpers::logActivity('PAN card verification request is' . $st . '!', $userid);

        DB::table('registerusers')->where('id', $userid)->update($req);
        $notificationdata['userid'] = $userid;
        $notificationdata['title'] = 'Your PAN card verification request is ' . $st;
        DB::table('notifications')->insert($notificationdata);
        //push notifications//
        $titleget = 'Verification Request!';
        Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
        //end push notifications//
        Session::flash('flash_notice', 'PAN Card Request is ' . $st . '!');
        return Redirect::back();
    } //End Function


    //Update UPI Status
    public function updateupistatus(Request $request)
    {

        $status = "";
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];
            $status = $input['status'];

            if (isset($input['image'])) {
                $filee = array_filter($input['image']);
                unset($input['image']);
                if (!empty($filee)) {
                    $destinationPath = 'uploads';
                    $oldimage = $input['oldimage'];
                    if ($oldimage != "") {
                        File::delete($oldimage);
                    }
                    unset($input['oldimage']);
                    if (!empty($filee)) {
                        $fileName  = 'select2win-pancard-' . rand(100, 999);
                        $imageName = Helpers::imageUpload($filee, $destinationPath, $fileName);
                        $input['image'] = config()->get('constants.PROJECT_URL') . 'uploads/pan_image/' . $imageName;
                    }
                }
                unset($input['oldimage']);
            }
        }
        if ($status != "") {
            if ($status == 1) {
                $st = 'Verified';
            }
        }
        unset($input['_token']);
        $req['upi_verify'] = $status;
        DB::table('upi_verify')->where('id', $id)->update($input);
        $findlastow = DB::table('upi_verify')->where('id', $id)->first();
        if (!empty($findlastow)) {
            $userid = $findlastow->user_id;
        }

        if ($status == 1) {
            $st = 'Verified';
        }
        if ($status == 2) {
            $st = 'rejected';
            Helpers::logActivity('Upi detail Rejected', $userid);
        }


        if ($status == 1) {

            if (0) {
                $exist_signup = DB::table('transactions')->where('userid', $userid)->where('type', PAN_VERIFY_SIGNUP_BONUS_STMT)->count();
                if ($exist_signup < 1) {
                    $userbalance = UserBalance::where("user_id", $userid)->first();

                    if (empty($userbalance)) {
                        DB::table('userbalances')->insert(['user_id' => $userid]);
                        $userbalance = UserBalance::where("user_id", $userid)->first();
                    }
                    if (!empty($userbalance)) {
                        $userbalance->bonus += PAN_VERIFY_SIGNUP_BONUS;
                        $userbalance->save();

                        Transaction::insert([
                            'userid' => $userid,
                            'amount' => PAN_VERIFY_SIGNUP_BONUS,
                            'type' => PAN_VERIFY_SIGNUP_BONUS_STMT,
                            'paymentstatus' => 'confirmed',
                            'transaction_by' => 'PLAYNWIN11',
                            'transaction_id' => 'PLAYNWIN11-SIGNUP-' . time(),
                            'bonus_amt' => PAN_VERIFY_SIGNUP_BONUS,
                            'bal_fund_amt' => $userbalance->balance,
                            'bal_win_amt' => $userbalance->winning,
                            'bal_bonus_amt' => $userbalance->bonus,
                            'bal_gst_bonus_amt' => $userbalance->gst_bonus,
                            'bal_affi_amt' => $userbalance->affiliation_commission,
                            'total_available_amt' => round(($userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission), 2)
                        ]);
                    }
                }
            }

            Helpers::logActivity('UPI Approved', $userid);
        }
        Helpers::logActivity('UPI verification request is' . $st . '!', $userid);

        DB::table('registerusers')->where('id', $userid)->update($req);
        $notificationdata['userid'] = $userid;
        $notificationdata['title'] = 'Your UPI verification request is ' . $st;
        DB::table('notifications')->insert($notificationdata);
        //push notifications//
        $titleget = 'Verification Request!';
        //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
        //end push notifications//
        Session::flash('flash_notice', 'UPI Request is ' . $st . '!');
        return Redirect::back();
    } //End Function
    //View Bank Card Detail
    public function viewbankdetails($id)
    {

        //Decode Id
        $id = unserialize(base64_decode($id));
        //Get Data
        $bankdetails = DB::table('bank')->where('bank.id', $id)->join('registerusers', 'registerusers.id', '=', 'bank.userid')->select('bank.*', 'registerusers.email', 'registerusers.username')->first();
        //print_r($bankdetails);die;
        if (!empty($bankdetails)) {
            return view("admin.$this->model.viewbankdetails", compact('bankdetails'));
        } else {
            Session::flash('error', 'Data Not Found!');
            return Redirect::back();
        }
    } //End Function

    //Bank Verify Status
    public function updatebankstatus(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];

            //  echo '<pre>'; print_r($request->all());exit;
            $status = $input['status'];
            unset($input['_token']);

            $req['bank_verify'] = $status;
            if (isset($input['accno'])) {
                $input['accno'] = $input['accno'];
            }
            if (isset($input['ifsc'])) {
                $input['ifsc'] = strtoupper($input['ifsc']);
            }
            if (isset($input['bankname'])) {
                $input['bankname'] = strtoupper($input['bankname']);
            }
            if (isset($input['bankbranch'])) {
                $input['bankbranch'] = strtoupper($input['bankbranch']);
            }
            // if(isset($input['state'])){
            //   $input['state'] = $input['state'];
            // }
            if (isset($input['image'])) {
                $filee = array_filter($input['image']);
                unset($input['image']);
                if (!empty($filee)) {
                    $destinationPath = 'uploads';
                    $oldimage = $input['oldimage'];
                    if ($oldimage != "") {
                        File::delete($oldimage);
                    }
                    unset($input['oldimage']);
                    if (!empty($filee)) {
                        $fileName  = 'select2win-bank-' . rand(100, 999);
                        $imageName = Helpers::imageUpload($filee, $destinationPath, $fileName);
                        $input['image'] = config()->get('constants.PROJECT_URL') . 'uploads/bank_image/' . $imageName;
                    }
                }
            }
            unset($input['oldimage']);

            $findlastow = DB::table('bank')->where('id', $id)->first();
            if (!empty($findlastow)) {
                $userid = $findlastow->userid;
            }
            $finduserbonus = DB::table('registerusers')->where('id', $userid)->first();

            if ($status == 1) {
                $st = 'Verified';
            }
            if ($status == 2) {
                $st = 'rejected';
                $email = $finduserbonus->email;
                //Edit Url
                $edit_url = config()->get('constants.FRONT_PROJECT_URL') . 'varifyaccount';
                //Send Mail Template
                $email_templates = DB::table('email_templates')->where('action', 'your Bank Documents were not Approved')->first();
                //Set Subject
                // $emailsubject = $email_templates->subject.'- FC';
                // //Set Email Body
                // $email_body=array('{NAME}','{COMMENT}','{EDIT_URL}');
                // //Replace
                // $rep_Array =array(ucwords($finduserbonus->team),$input['comment'],$edit_url);
                // //Replase Value
                // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
                // $msg = Helpers::mailheader();
                // $msg.= $messageBody;
                // $msg.= Helpers::mailfooter();
                // Helpers::mailsentFormat($email,$emailsubject,$msg);
            }
            if ($st == 'Verified') {

                $req['bankbonus'] = 1;
                //$req['state']=$findlastow->state;

                $Transbal = 0;
                $userbalanse = DB::table('userbalances')->where('user_id', $userid)->first();
                if (empty($userbalanse)) {
                    DB::table('userbalances')->insert(['user_id' => $userid]);
                }
                $userbalanse = DB::table('userbalances')->where('user_id', $userid)->first();
                $Transbal = DB::table('transactions')->where('userid', $userid)->where('type', BANK_VERIFY_SIGNUP_BONUS_STMT)->count();
                if ($Transbal < 1) {
                    if (1) {
                        if (!empty($userbalanse)) {
                            $user_bns_amt['bonus'] = $userbalanse->bonus + 5;
                            DB::table('userbalances')->where('user_id', $userid)->update($user_bns_amt);

                            $userbalanse = DB::table('userbalances')->where('user_id', $userid)->first();

                            $trans_bonus = DB::table('transactions');
                            $ins_tran_bonus['userid'] = $userid;
                            $ins_tran_bonus['refer_id'] = 0;
                            $ins_tran_bonus['transaction_id'] = 'PlaynWin11-SIGNUP-' . time();
                            $ins_tran_bonus['type'] = BANK_VERIFY_SIGNUP_BONUS_STMT;
                            $ins_tran_bonus['transaction_by'] = "PlaynWin11";
                            $ins_tran_bonus['paymentstatus'] = CONFIRMED;
                            $ins_tran_bonus['total_available_amt'] = $userbalanse->winning + $userbalanse->balance + $userbalanse->bonus + $userbalanse->gst_bonus + $userbalanse->affiliation_commission;
                            $ins_tran_bonus['bal_bonus_amt'] = $userbalanse->bonus;
                            $ins_tran_bonus['bal_fund_amt'] = $userbalanse->balance;
                            $ins_tran_bonus['bal_win_amt'] = $userbalanse->winning;
                            $ins_tran_bonus['bal_gst_bonus_amt'] = $userbalanse->gst_bonus;
                            $ins_tran_bonus['bal_affi_amt'] = $userbalanse->affiliation_commission;
                            $ins_tran_bonus['bonus_amt'] = 5;
                            $ins_tran_bonus['amount'] = 5;
                            $trans_bonus->insert($ins_tran_bonus);
                        }
                    }
                }

                // $is_code_exist = RegisterUser::where('id',$finduserbonus->refer_id)->first();
                // if(!empty($is_code_exist) && $is_code_exist->refer_to_join!=1){
                if (0) {
                    // $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                    // $bns_amt['bonus']=$refer_bal->bonus + 50;
                    // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);


                    // $trans = DB::table('transactions');
                    //
                    // $ins_tran['userid'] = $is_code_exist->id;
                    // $ins_tran['refer_id'] = $userid;
                    //
                    // $ins_tran['transaction_id'] = BRAND['name'].'-Refer-'.time();
                    //
                    // $ins_tran['type'] = 'Refer Bonus';
                    //
                    // $ins_tran['transaction_by'] =BRAND['name'];
                    //
                    // $ins_tran['paymentstatus'] = CONFIRMED;
                    //
                    // $ins_tran['total_available_amt'] = $refer_bal->winning+$refer_bal->balance+$refer_bal->bonus;
                    //
                    // $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                    //
                    // $ins_tran['bonus_amt'] = 50;
                    //
                    // $ins_tran['amount'] = 50;
                    //
                    // $trans->insert($ins_tran);
                }


                // $return_status = Helpers::cf_add_benificary($userid);
                // echo $return_status;die;
                /*// code for signup bonus
      $userbalance = UserBalance::where('user_id',$userid)->first();

      $bonus_amount_db = DB::table('bonus_amount')->where('type', 'SIGN_UP_BONUS_AMOUNT')->first();
      $SIGN_UP_BONUS_AMOUNT = @$bonus_amount_db->price;

      if (!is_null($userbalance)) {

      $userbalance->bonus = $userbalance->bonus + $SIGN_UP_BONUS_AMOUNT;
      //bonus will be given when user will go through from all verification
      $userbalance->save();

      //transaction for signup bonus
      $get_user_bal = UserBalance::where('user_id',$userid)->first();

      $random = rand(1000000,999999999);

      //Entry for bonus to the new user account

      $trans = DB::table('transactions');

      $ins_tran['userid'] = $get_user_bal->user_id;

      $ins_tran['transaction_id'] = 'Royal11-SIGNUP-'.$random;

      $ins_tran['type'] = SIGN_UP_BONUS_STMT;

      $ins_tran['transaction_by'] = 'Royal11';

      $ins_tran['paymentstatus'] = CONFIRMED;

      $ins_tran['total_available_amt'] = $get_user_bal->winning+$get_user_bal->balance+$get_user_bal->bonus;

      $ins_tran['bal_bonus_amt'] = $get_user_bal->bonus;

      $ins_tran['bonus_amt'] = $SIGN_UP_BONUS_AMOUNT;

      $ins_tran['amount'] = $SIGN_UP_BONUS_AMOUNT;
      //it will give when user verify all verification
      $trans->insert($ins_tran);
    }
    //end code for signup bonus*/
                if (1) {
                } else {
                    Session::flash('flash_notice', Helpers::cf_add_benificary($userid));
                    Session::flash('alert-class', 'alert-warning');
                    return Redirect::back();
                }
            }
            //Update Bank
            DB::table('bank')->where('id', $id)->update($input);
            //Update In User Table
            DB::table('registerusers')->where('id', $userid)->update($req);
            //Send Notification
            $notificationdata['userid'] = $userid;
            Helpers::logActivity('bank documents request is' . $st . '!', $userid);
            $notificationdata['title'] = 'Your Bank documents request is ' . $st;
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Bank Documents Verification Request!';
            Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
            //end push notifications//
            Session::flash('flash_notice', 'Bank Account Request is ' . $st . '!');
            return Redirect::back();
        }
    } //End Function

    // //Veryfy Bank Account
    // public function verifybankaccount(){
    // 	// echo "Dsds";die();
    // $formData = Input::all();
    // 	if(isset($formData) && !empty($formData)){
    //
    // 	return Datatables::of(DB::table('bank as b')
    // 			->join('registerusers as r','r.id','=','b.userid')
    // 			->where('b.status','0')
    // 			->where('r.pan_verify','1')
    // 			->where('r.mobile_verify','1')
    // 			->where('r.email_verify','1')
    // 			->select('r.email','r.username', 'r.mobile','b.*')
    // 			// ->orderBY('b.id','DESC')
    // 			->orderBY('b.created','DESC')
    // 			->get())
    //            ->addIndexColumn()
    //            /*->addColumn('userid', function ($result) {
    //            		 return '<a href="'.route($this->model.'.view_bank_details',base64_encode(serialize($result->id))).'" target="_blank" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->userid.'</a>'
    //            			;
    //             })*/
    //             ->addColumn('email', function ($result) {
    //            		 return '<a href="'.route($this->model.'.view_bank_details',base64_encode(serialize($result->id))).'" target="_blank" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->email.'</a>'
    //            			;
    //             })
    //              ->addColumn('username', function ($result) {
    //            		 return '<a href="'.route($this->model.'.view_bank_details',base64_encode(serialize($result->id))).'" target="_blank" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->username.'</a>'
    //            			;
    //             })
    //            ->addColumn('status', function ($result) {
    //            		$status='';
    //            		if($result->status=='1'){
    //            			$status='Verified';
    //            		}elseif($result->status=='0'){
    //            			$status='Pending';
    //            		}elseif($result->status=='2'){
    //            			$status='Cancel';
    //            		}
    //            		return $status;
    //             })
    //             ->escapeColumns([])
    //             ->make(true);
    //         }//end

    // }//End Function

    //Veryfy Bank Account
    public function verifybankaccount(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of($query = DB::table('bank as b')
                    ->join('registerusers as r', 'r.id', '=', 'b.userid')
                    ->where('b.status', '0')
                    ->where('r.pan_verify', '1')
                    ->where('r.mobile_verify', '1')
                    ->where('r.email_verify', '1')
                    ->select('r.email', 'r.username', 'r.mobile', 'b.*')
                    ->orderBy('b.created_at', 'ASC')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                        }
                    })
                    // ->select('r.email', 'r.username', 'b.*')
                    ->get())
                    ->addIndexColumn()

                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.view_bank_details', base64_encode(serialize($result->id))) . '"  data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->email . '</a>';
                    })

                    ->addColumn('mobile', function ($result) {
                        return '<a href="' . route($this->model . '.view_bank_details', base64_encode(serialize($result->id))) . '"  data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->mobile . '</a>';
                    })
                    ->addColumn('username', function ($result) {
                        return '<a href="' . route($this->model . '.view_bank_details', base64_encode(serialize($result->id))) . '"  data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->username . '</a>';
                    })
                    ->addColumn('created_at', function ($result) {
                        if ($result->created_at != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->created_at));
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('status', function ($result) {
                        $status = '';
                        if ($result->status == '1') {
                            $status = 'Verified';
                        } elseif ($result->status == '0') {
                            $status = 'Pending';
                        } elseif ($result->status == '2') {
                            $status = 'Cancel';
                        }
                        return $status;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.verifybankaccount");
    } //End Function




    //User Wallet List
    public function userswallet(Request $req)
    {
        //Get Post Data

        // $userdata= DB::table('registerusers as r')
        // ->join('userbalances','userbalances.user_id','=','r.id')
        //
        // ->where('r.is_bot',0)
        // // ->orderBy('r_id', 'DESC')
        // // ->orderBy('userbalances.winning', 'DESC')
        // ->select('r.id as r_id','r.email','r.mobile','r.team','userbalances.*')
        // ->orderBy('affiliation_commission', 'desc')
        // ->limit(500)
        // ->get();
        // echo '<pre>'; print_r($userdata);exit;
        $formData = Input::all();

        //  $limit = $req->input('length');
        //  $start = $req->input('start');
        // // $order = $columns[$req->input('order.0.column')];
        //  $dir = $req->input('order.0.dir');

        if ($req->ismethod('post')) {
            if (isset($formData) && !empty($formData)) {
                // echo "<pre>";print_r($formData);die();
                $columns = array(
                    0 => 'id',
                    1 => 'team',
                    2 => 'email',
                    3 => 'mobile',
                    4 => 'balance',
                    5 => 'winning',
                    6 => 'bonus',
                    7 => 'gst_bonus',
                    8 => 'affiliation_commission',
                    // 9 => 'total_bal',
                );
                //echo $order = $req->input('order.0.column');
                $order = $columns[$req->input('order.0.column')];
                $dir = $req->input('order.0.dir');
                if (!empty($formData['order'][0]['dir'])) {
                    $limit = 5000;
                } else {
                    $limit = 10000;
                }
                //dd($limit);
                return Datatables::of(DB::table('registerusers as r')
                    ->join('userbalances', 'userbalances.user_id', '=', 'r.id')

                    ->where('r.is_bot', 0)
                    // ->orderBy('r_id', 'DESC')
                    // ->orderBy('userbalances.winning', 'DESC')
                    ->select('r.id as r_id', 'r.email', 'r.mobile', 'r.team', 'userbalances.*')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_teamname'])) {
                                $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                        }
                    })
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['order'][0]['dir'])) {
                            $query->limit(1000000);
                        } else {

                            $query->limit(500);
                        }
                    })
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['search']['value']) && !empty($formData['search']['value'])) {
                            $query->limit(1000000);
                        } else {

                            $query->limit(500);
                        }
                    })
                    ->orderBy($order, $dir)
                    ->limit($limit)
                    ->get())

                    ->addIndexColumn()
                    /*->addColumn('user_id',function ( $result){
      return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->user_id))).'" style="text-decoration:underline;">'.$result->user_id;
    })
    ->addColumn('current_date',function ( $result){
    return date('Y-m-d');
  })*/
                    ->addColumn('total_bal', function ($result) {
                        return round($result->bonus + $result->gst_bonus + $result->winning + $result->balance + $result->affiliation_commission, 2);
                    })
                    ->addColumn('action', function ($result) {
                        return '<a href="' . route($this->model . '.edit_users_amount', base64_encode(serialize($result->r_id))) . '"  class="btn btn-rg" data-toggle="tooltip" title="" data-original-title="Transfer" ><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Transfer Balance</a> &ensp;
    <a href="' . route($this->model . '.deduct_users_amount', base64_encode(serialize($result->r_id))) . '"  class="btn btn-rg" data-toggle="tooltip" title="" data-original-title="Deduct" ><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Deduct Balance</a>';
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.userswallet");
    } //End Function

    //User Wallet List
    public function userspromo(Request $req)
    {
        //Get Post Data
        //   $formData = Input::all();
        // $limit=100000;
        // $data= DB::table('registerusers as r')
        //  ->join('user_promo','user_promo.user_id','=','r.id')
        // ->orderBy('r_id', 'DESC')
        // ->select('r.id as r_id','r.email','r.mobile','r.team')
        // ->where(function ($query) use ($formData) {
        //   if (isset($formData['filter_columns'])) {
        //     if (isset($formData['filter_columns']['filter_teamname'])) {
        //       $query->where('r.team', 'like', '%'.$formData['filter_columns']['filter_teamname'].'%');
        //     }
        //     if (isset($formData['filter_columns']['filter_email'])) {
        //       $query->where('r.email', 'like', '%'.$formData['filter_columns']['filter_email'].'%');
        //     }
        //     if (isset($formData['filter_columns']['filter_mobile'])) {
        //       $query->where('r.mobile', 'like', '%'.$formData['filter_columns']['filter_mobile'].'%');
        //     }
        //     if (isset($formData['filter_columns']['filter_status'])) {
        //       // $query->where('user_promo.status', 'like', '%'.$formData['filter_columns']['filter_status'].'%');
        //     }
        //   }
        // })
        // ->limit($limit)
        // ->get();
        // dd($data);

        $formData = Input::all();
        if ($req->ismethod('post')) {

            if (isset($formData) && !empty($formData)) {

                /*return Datatables::of(DB::table('registerusers as r')
      // ->join('user_promo','user_promo.user_id','=','r.id')
      ->limit(20000)
      ->orderBy('r_id', 'DESC')
      ->select('r.id as r_id','r.email','r.mobile','r.team','user_promo.*' , 'user_promo.created as promo_applied' , 'user_promo.status as promo_status')*/
                if (!empty($formData['search']['value'])) {
                    $limit = 100000;
                } else {
                    $limit = 1000;
                }
                return Datatables::of(DB::table('registerusers as r')
                    ->join('user_promo', 'user_promo.user_id', '=', 'r.id')
                    ->orderBy('r_id', 'DESC')
                    ->select('r.id as r_id', 'r.email', 'r.mobile', 'r.team', 'user_promo.promo_code', 'user_promo.status as prostatus', 'user_promo.bonustype')
                    //->where('user_promo.status',1)
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_teamname'])) {
                                $query->where('r.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_status'])) {
                                // $query->where('user_promo.status', 'like', '%'.$formData['filter_columns']['filter_status'].'%');
                            }
                        }
                    })
                    ->limit($limit)
                    ->get())

                    ->addIndexColumn()
                    /*->addColumn('user_id',function ( $result){
      return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->user_id))).'" style="text-decoration:underline;">'.$result->user_id;
    })
    ->addColumn('current_date',function ( $result){
    return date('Y-m-d');
  })*/
                    ->addColumn('promo_code', function ($result) {
                        $findifexist = DB::table('user_promo')->where('user_id', $result->r_id)->where('promo_code', $result->promo_code)
                            ->first();
                        return $findifexist->promo_code;
                        // if(!empty($findifexist->status==1))
                        // {
                        //   return $findifexist->promo_code;
                        // }
                        // else
                        // {
                        //   return 'Not Applied';
                        // }

                    })
                    ->addColumn('promo_applied', function ($result) {
                        // return date('d M Y H:i:s',strtotime($result->promo_applied));
                        $findifexist = DB::table('user_promo')->where('user_id', $result->r_id)->where('promo_code', $result->promo_code)
                            ->where('status', 1)
                            ->first();
                        if (!empty(@$result->prostatus == 1)) {
                            return date('d M Y H:i:s', strtotime($findifexist->created));
                        } else {
                            return 'Not Applied';
                        }
                    })
                    ->addColumn('promo_status', function ($result) {
                        $findifexist = DB::table('user_promo')->where('promo_code', $result->promo_code)->where('user_id', $result->r_id)
                            ->where('status', 1)
                            ->first();
                        if (!empty($result)) {
                            if (@$result->prostatus == 0) {
                                return 'Not Used';
                            } else {
                                return 'Used ';
                            }
                        } else
                            return 'Not Applied';
                    })
                    ->addColumn('bonustype', function ($result) {
                        return $result->bonustype;
                    })

                    // ->addColumn('action',function ( $result){
                    // 				return '<a href="'.route($this->model.'.edit_users_amount',base64_encode(serialize($result->r_id))).'"  class="btn btn-rg" data-toggle="tooltip" title="" data-original-title="Transfer" ><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Transfer Balance</a> &ensp;
                    // 		<a href="'.route($this->model.'.deduct_users_amount',base64_encode(serialize($result->r_id))).'"  class="btn btn-rg" data-toggle="tooltip" title="" data-original-title="Deduct" ><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Deduct Balance</a>';
                    // 			 })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.userspromo");
    } //End Function
    //User Balance DETAIL
    public function users_delete_permanent(Request $req, $userid = null)
    {
        $userid = unserialize(base64_decode($userid));
        $user =  DB::table('registerusers')->where('id', $userid)->first();
        if (!empty($user)) {
            DB::table('delete_user_list')->insert([
                'user_id' => $user->id,
                'refer_id' => $user->refer_id,
                'username' => $user->username,
                'mobile' => $user->mobile,
                'email' => $user->email,
                'dob' => $user->dob,
                'gender' => $user->gender,
                'password' => $user->password,
                'fcmToken' => $user->fcmToken,
                'socialLoginType' => $user->socialLoginType,
                'deviceId' => $user->deviceId,
                'device_type' => $user->device_type,
                'jwt_token' => $user->jwt_token,
                'custom_user_token' => $user->custom_user_token,
                'image' => $user->image,
                'activation_status' => $user->activation_status,
                'city' => $user->city,
                'state' => $user->state,
                'pincode' => $user->pincode,
                'team' => $user->team,
                'mobile_verify' => $user->mobile_verify,
                'email_verify' => $user->email_verify,
                'pan_verify' => $user->pan_verify,
                'aadhar_verify' => $user->aadhar_verify,
                'bank_verify' => $user->bank_verify,
                'refercode' => $user->refercode,
            ]);

            DB::table('registerusers')->where('id', $userid)->delete();

            DB::table('adhar_card_details')->where('userid', $userid)->delete();
            DB::table('bank')->where('userid', $userid)->delete();
            DB::table('pancard')->where('userid', $userid)->delete();

            Session::flash('flash_notice', 'User account delete successfully');
            Session::flash('alert-class', 'alert-success');
            return redirect()->to('admin/registerusers/all-registerusers');
        } else {
            Session::flash('flash_notice', 'User does not exit');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->to('admin/registerusers/all-registerusers');
        }
    }

    public function users_balance_history(Request $req, $userid = null)
    {
        //Get Post Data
        $user_id = $userid;
        // / $user_id='7106';
        $userhistory = $userid;

        $userid = unserialize(base64_decode($userid));
        $UserBalance = [];
        // $UserBalance= DB::table("transactions")
        //     ->join('registerusers','registerusers.id','=','userid')
        //     ->join('userbalances','userbalances.user_id','=','registerusers.id')
        //     ->where('userid',$userid)
        //     ->where('amount','!=','0.00')
        //     ->where('paymentstatus','confirmed')
        //     //->whereBetween('transactions.created',['transactions.created'])
        //     //->whereIn('type',['Add Fund','Amount Withdrawn','Challenge winning amount','Challenge Joining Fee'])
        //        ->select(['transactions.total_available_amt',"transactions.created as created","registerusers.id as userid",
        //                 DB::raw('DATE(transactions.created_at) as date'),
        //                   DB::raw("sum(case when type='Add Fund' then amount else 0 end) as addfund"),
        //                   DB::raw("sum(case when type='Amount Withdrawn' then amount else 0 end) as withdraw"),
        //                   DB::raw("sum(case when type='Challenge winning amount' then amount else 0 end) as challange"),
        //                   DB::raw("sum(case when type='Challenge Joining Fee' then amount else 0 end) as challengejoining")
        //       ])
        //       ->groupBy("date")
        //       ->orderBy("date",'desc')
        //       ->get();

        //  $from = date('Y-m-d 00:00:00');
        //  $end = date('Y-m-d 23:59:59');
        //  $contest_refund_data = DB :: table('refunds')->where('userid',$userid)->whereBetween('created',[$from,$end])
        //  ->where('matchkey','65556')
        //  ->select(DB::raw('sum(amount) as total_refund'))->first();
        // echo '<pre>'; print_r(  $contest_refund_data);exit;
        // foreach ($UserBalance as $key => $value) {
        //          $from = date('Y-m-d',strtotime($value->date)).' 00:00:00';
        //          $end = date('Y-m-d',strtotime($value->date)).' 23:59:59';
        //
        //        $winingwithdraw = DB :: table('transactions')->where('userid',$userid)->whereBetween('created_at',[$from,$end])
        //             ->where('type','Winning Deduction By Admin')
        //               ->where('paymentstatus','confirmed')
        //          ->select(DB::raw('sum(amount) as total_winning_deduct'))->first();
        //          $value->winning_deduct =$winingwithdraw->total_winning_deduct;
        //
        //
        //        $depositewithdraw = DB :: table('transactions')->where('userid',$userid)->whereBetween('created_at',[$from,$end])
        //          ->where('type','Deposit Deduction By Admin')
        //            ->where('paymentstatus','confirmed')
        //            ->select(DB::raw('sum(amount) as total_deposite_deduct'))->first();
        //            $value->deposite_deduct =$depositewithdraw->total_deposite_deduct;
        //
        //       $match_count_data = DB :: table('joinedleauges')->where('userid',$userid)->whereBetween('created_at',[$from,$end])
        //       ->select(DB::raw('count(DISTINCT(matchkey)) as match_count'))->first();
        //       $value->total_join_matches =$match_count_data->match_count;
        //
        //       $contest_count_data = DB :: table('joinedleauges')->where('userid',$userid)->whereBetween('created_at',[$from,$end])
        //       ->select(DB::raw('count(DISTINCT(challengeid)) as contest_count'))->first();
        //       $value->total_join_contest =$contest_count_data->contest_count;
        //
        //       $contest_refund_data = DB :: table('refunds')->where('userid',$userid)->whereBetween('created',[$from,$end])
        //       ->select(DB::raw('sum(amount) as total_refund'))->first();
        //       $value->total_refund =!empty($contest_refund_data->total_refund) ? $contest_refund_data->total_refund :0;
        //
        // }
        //   echo "<pre>";print_r($userid);die();
        $formData = Input::all();


        if ($req->ismethod('post')) {
            if (isset($formData) && !empty($formData)) {

                $userid = unserialize(base64_decode($formData['userid']));

                return Datatables::of(DB::table("transactions")
                    ->join('registerusers', 'registerusers.id', '=', 'userid')
                    ->join('userbalances', 'userbalances.user_id', '=', 'registerusers.id')
                    ->where('transactions.userid', $userid)
                    ->where('transactions.amount', '!=', '0.00')
                    ->where('transactions.paymentstatus', 'confirmed')
                    //->whereBetween('transactions.created',['transactions.created'])
                    //->whereIn('type',['Add Fund','Amount Withdrawn','Challenge winning amount','Challenge Joining Fee'])
                    ->select([
                        'transactions.total_available_amt',
                        "transactions.created as created",
                        "registerusers.id as userid",
                        "transactions.transaction_by",
                        DB::raw('DATE(transactions.created_at) as date'),
                        DB::raw("sum(case when type='Add Fund' then amount else 0 end) as addfund"),
                        DB::raw("sum(case when type='Amount Withdrawn' then amount else 0 end) as withdraw"),
                        DB::raw("sum(case when type='Challenge winning amount' then amount else 0 end) as challange"),
                        DB::raw("sum(case when type='Challenge Joining Fee' then amount else 0 end) as challengejoining")
                    ])
                    ->where(function ($query) use ($formData) {

                        if (!empty($formData['start_date']) || !empty($formData['end_date'])) {
                            if (@$formData['start_date'] != "")

                                $query->where("transactions.created", '>=', date("Y-m-d 00:00:00", strtotime($formData['start_date'])));
                            if (@$formData['end_date'] != "")
                                $query->where("transactions.created", '<=', date("Y-m-d 23:59:59", strtotime($formData['end_date'])));
                        }
                    })
                    ->groupBy("date")
                    ->orderBy("date", 'desc')
                    ->get())
                    ->addIndexColumn()

                    ->addColumn('clossing_balance', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $closestart =    date('Y-m-d', (strtotime('-1 day', strtotime($from))));
                        $closestart =   date('Y-m-d', strtotime($closestart)) . ' 00:00:00';
                        $closeendt =    date('Y-m-d', (strtotime('-1 day', strtotime($end))));
                        $closeendt =   date('Y-m-d', strtotime($closeendt)) . ' 23:59:59';
                        $closeingdate = DB::table('transactions')->where('userid', $userid)
                            ->whereBetween('created_at', [$closestart, $closeendt])
                            ->orderBy('id', 'desc')
                            ->first();
                        if (empty($closeingdate)) {
                            $closeingdate = DB::table('transactions')->where('userid', $userid)
                                ->where('created_at', '<=', $from)
                                ->orderBy('id', 'desc')
                                ->first();
                        }
                        return  @$closeingdate->total_available_amt;
                    })
                    ->addColumn('affiliationcomm', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $affiliationcomm = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->where('type', 'Affiliation Commission')
                            ->where('paymentstatus', 'confirmed')
                            ->select(DB::raw('sum(amount) as total_commission'))->first();
                        return  number_format($affiliationcomm->total_commission, 2);
                    })


                    ->addColumn('winning_adjustment', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $winingadjustment = DB::table('transactions')->where('userid', $userid)
                            ->whereBetween('created_at', [$from, $end])
                            ->where('type', 'Winning Adjustment')
                            ->where('paymentstatus', 'confirmed')
                            ->select(DB::raw('sum(amount) as total_winning_adjust'))->first();
                        return  !empty($winingadjustment->total_winning_adjust) ? $winingadjustment->total_winning_adjust : 0;
                    })

                    ->addColumn('total_deposite', function ($result) {
                        return $result->addfund;
                    })
                    ->addColumn('deposite_by', function ($result) {
                        if ($result->transaction_by != 'wallet' || $result->transaction_by != 'PLAYNWIN11' || $result->transaction_by != 'PLAYNWIN11') {
                            return $result->transaction_by;
                        } else {
                            return "";
                        }
                    })
                    ->addColumn('total_withdraw', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $winingwithdraw = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->where('type', 'Winning Deduction By Admin')
                            ->where('paymentstatus', 'confirmed')
                            ->select(DB::raw('sum(amount) as total_winning_deduct'))->first();
                        $winingwithdraw->total_winning_deduct;
                        //deposite deductionUsers
                        $depositewithdraw = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->where('type', 'Deposit Deduction By Admin')
                            ->where('paymentstatus', 'confirmed')
                            ->select(DB::raw('sum(amount) as total_deposite_deduct'))->first();
                        $depositewithdraw->total_deposite_deduct;

                        //tds amount refunds
                        $tdsamountrefund = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->where('type', 'TDS amount refund')
                            ->where('paymentstatus', 'confirmed')
                            ->select(DB::raw('sum(amount) as tds_amount'))->first();
                        $tdsamountrefund->tds_amount;

                        return @$result->withdraw + @$winingwithdraw->total_winning_deduct + @$depositewithdraw->total_deposite_deduct + @$tdsamountrefund->tds_amount;
                    })
                    ->addColumn('total_join_match', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $match_count_data = DB::table('joinedleauges')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->select(DB::raw('count(DISTINCT(matchkey)) as match_count'))->first();
                        return $match_count_data->match_count;
                    })
                    ->addColumn('total_join_contest', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $contest_count_data = DB::table('joinedleauges')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->select(DB::raw('count(DISTINCT(challengeid)) as contest_count'))->first();
                        return  $contest_count_data->contest_count;
                    })
                    ->addColumn('total_invest', function ($result) {
                        return  $result->challengejoining;
                    })
                    ->addColumn('total_winning', function ($result) {
                        return  $result->challange;
                    })
                    ->addColumn('total_refund_amount', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $contest_refund_data = DB::table('refunds')->where('userid', $userid)->whereBetween('created', [$from, $end])
                            ->select(DB::raw('sum(amount) as total_refund'))->first();
                        return  !empty($contest_refund_data->total_refund) ? $contest_refund_data->total_refund : 0;
                    })
                    ->addColumn('total_available_amt', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $toatlaavalableamount = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->orderBY('id', 'desc')
                            ->first();
                        return  $toatlaavalableamount->total_available_amt;
                    })
                    ->addColumn('date', function ($result) use ($userid) {
                        $from = date('Y-m-d', strtotime($result->date)) . ' 00:00:00';
                        $end = date('Y-m-d', strtotime($result->date)) . ' 23:59:59';
                        $toatlaavalableamount = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                            ->orderBY('id', 'desc')
                            ->first();
                        return  $toatlaavalableamount->created;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }



        return view("admin.$this->model.user_balance_history", compact('user_id', 'UserBalance', 'userhistory'));
    }
    public function users_balance_history_old(Request $req, $userid)
    {
        //Get Post Data
        //  $user_id=$userid;
        $user_id = '7106';

        $userid = unserialize(base64_decode($userid));

        $UserBalance = DB::table("transactions")
            ->join('registerusers', 'registerusers.id', '=', 'userid')
            ->join('userbalances', 'userbalances.user_id', '=', 'registerusers.id')
            ->where('userid', $userid)
            ->where('amount', '!=', '0.00')
            ->where('paymentstatus', 'confirmed')
            //->whereIn('type',['Add Fund','Amount Withdrawn','Challenge winning amount','Challenge Joining Fee','Winning Adjustment','Winning Deduction By Admin','Refund amount','Contest Joining Fee Refund','Deposit Deduction By Admin'])
            ->select([
                'transactions.total_available_amt',
                "transactions.created as created",
                "registerusers.id as userid",
                DB::raw('DATE(transactions.created_at) as date'),
                DB::raw("sum(case when type='Add Fund' then amount else 0 end) as addfund"),
                DB::raw("sum(case when type='Amount Withdrawn' then amount else 0 end) as withdraw"),
                DB::raw("sum(case when type='Challenge winning amount' then amount else 0 end) as challange"),
                DB::raw("sum(case when type='Challenge Joining Fee' then amount else 0 end) as challengejoining")
            ])
            ->groupBy("date")
            ->orderBy("date", 'desc')
            ->get();


        foreach ($UserBalance as $key => $value) {
            $from = date('Y-m-d', strtotime($value->date)) . ' 00:00:00';
            $end = date('Y-m-d', strtotime($value->date)) . ' 23:59:59';

            //closeing balance
            $closestart =    date('Y-m-d', (strtotime('-1 day', strtotime($from))));
            $closestart =   date('Y-m-d', strtotime($closestart)) . ' 00:00:00';
            $closeendt =    date('Y-m-d', (strtotime('-1 day', strtotime($end))));
            $closeendt =   date('Y-m-d', strtotime($closeendt)) . ' 23:59:59';
            $closeingdate = DB::table('transactions')->where('userid', $userid)
                ->whereBetween('created_at', [$closestart, $closeendt])
                ->orderBy('id', 'desc')
                ->first();
            $value->closing_balance = @$closeingdate->total_available_amt;
            //Affiliation Commission
            $affiliationcomm = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                ->where('type', 'Affiliation Commission')
                ->where('paymentstatus', 'confirmed')
                ->select(DB::raw('sum(amount) as total_commission'))->first();
            $value->commission = $affiliationcomm->total_commission;


            $winingwithdraw = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                ->where('type', 'Winning Deduction By Admin')
                ->where('paymentstatus', 'confirmed')
                ->select(DB::raw('sum(amount) as total_winning_deduct'))->first();
            $value->winning_deduct = $winingwithdraw->total_winning_deduct;

            $tdsamountrefund = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                ->where('type', 'TDS amount refund')
                ->where('paymentstatus', 'confirmed')
                ->select(DB::raw('sum(amount) as tds_amount'))->first();
            $value->tdsamountrefund = $tdsamountrefund->tds_amount;

            $winingadjustment = DB::table('transactions')->where('userid', $userid)
                ->whereBetween('created_at', [$from, $end])
                ->where('type', 'Winning Adjustment')
                ->where('paymentstatus', 'confirmed')
                ->select(DB::raw('sum(amount) as total_winning_adjust'))->first();
            $value->winingadjustment = $winingadjustment->total_winning_adjust;

            $toatlaavalableamount = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                // ->where('type','Winning Deduction By Admin')
                // ->where('paymentstatus','confirmed')
                //->select(DB::raw('sum(amount) as total_winning_deduct'))
                ->orderBY('id', 'desc')
                ->first();
            $value->toatlaavalableamount = $toatlaavalableamount->total_available_amt;
            $value->created = $toatlaavalableamount->created;



            $depositewithdraw = DB::table('transactions')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                ->where('type', 'Deposit Deduction By Admin')
                ->where('paymentstatus', 'confirmed')
                ->select(DB::raw('sum(amount) as total_deposite_deduct'))->first();
            $value->deposite_deduct = $depositewithdraw->total_deposite_deduct;

            $match_count_data = DB::table('joinedleauges')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                ->select(DB::raw('count(DISTINCT(matchkey)) as match_count'))->first();
            $value->total_join_matches = $match_count_data->match_count;

            $contest_count_data = DB::table('joinedleauges')->where('userid', $userid)->whereBetween('created_at', [$from, $end])
                ->select(DB::raw('count(DISTINCT(challengeid)) as contest_count'))->first();
            $value->total_join_contest = $contest_count_data->contest_count;

            $contest_refund_data = DB::table('refunds')->where('userid', $userid)->whereBetween('created', [$from, $end])
                ->select(DB::raw('sum(amount) as total_refund'))->first();
            $value->total_refund = !empty($contest_refund_data->total_refund) ? $contest_refund_data->total_refund : 0;
            // if($value->created > date('Y-m-d h:i:s')){
            // $value->created= $from;
            // }else{
            // $value->created= $end;
            //
            //   }

        }
        //echo "<pre>";print_r($UserBalance);die();


        return view("admin.$this->model.user_balance_history", compact('user_id', 'UserBalance'));
    }
    public function users_balance_detail(Request $req)
    {
        //Get Post Data
        $formData = Input::all();
        if ($req->ismethod('post')) {
            if (isset($formData) && !empty($formData)) {
                // echo "<pre>";print_r($formData);die();
                return Datatables::of(DB::table('user_balance_detail as ub')
                    // return Datatables::of(DB::table('userbalances as ub')
                    ->limit(20000)
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_teamname'])) {
                                $query->where('ub.team', 'like', '%' . $formData['filter_columns']['filter_teamname'] . '%');
                            }
                        }
                    })
                    ->orderby('ub.id', 'desc')
                    ->get())->addIndexColumn()
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.users_balance_detail");
    }
    public function users_balance_detail_old(Request $req)
    {
        //Get Post Data
        $formData = Input::all();
        if ($req->ismethod('post')) {
            if (isset($formData) && !empty($formData)) {
                // echo "<pre>";print_r($formData);die();
                return Datatables::of(DB::table('user_balance_detail')
                    ->limit(20000)
                    // ->where(function ($query) use ($formData) {
                    //   if (isset($formData['filter_columns'])) {
                    //     if (isset($formData['filter_columns']['filter_teamname'])) {
                    //       $query->where('ub.team', 'like', '%'.$formData['filter_columns']['filter_teamname'].'%');
                    //     }
                    //   }
                    // })
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('total_balance', function ($result) {
                        return round($result->balance, 2);
                    })
                    ->addColumn('total_winning', function ($result) {
                        return round($result->winning, 2);
                    })
                    ->addColumn('total_bonus', function ($result) {
                        return round($result->bonus, 2);
                    })
                    ->addColumn('overall_balance', function ($result) {
                        return round($result->bonus + $result->winning + $result->balance, 2);
                    })
                    ->addColumn('created_at', function ($result) {
                        return $result->created_at;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.users_balance_detail");
    }
    //End Function

    public function users_balance_detail_cron(Request $req)
    {


        // $start_date = Carbon::create(2023, 7, 1);
        //
        // // End date (current date)
        // $end_date = Carbon::today();
        // $current_date = clone $start_date;
        // while ($current_date->lte($end_date)) {
        //    // $date_string = date('Y-m-d H:i:s', strtotime($current_date));
        // $activitydata['created_at']= $current_date->toDateString();
        //     DB::table('user_activity_daily_report')->insert($activitydata);
        //    $current_date->addDay();
        // }
        //exit;
        // $user_withdraw_amount=DB::table('withdraw')
        //   ->select(DB::raw('SUM(amount) as user_withdraw_amount'),
        //   DB::raw('DATE(approved_date) date'))
        //   // ->where('status','1')
        //   ->whereIn('status',['1','3'])
        //
        //   // ->whereRaw('DATE(`created`) = ?',array(date('d')))
        //   ->where('approved_date', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
        //   ->groupby('date')
        //   ->orderByDesc('approved_date')
        //  // ->limit(1)
        //   ->get()
        //   ->reverse()->values();

        // foreach ($user_withdraw_amount as $key => $value) {
        //
        // $check= DB::table('user_activity_daily_report')->where('created_at','LIKE','%'.$value->date.'%')->first();
        //
        // if(!empty($check)){
        // $data= date('Y-m-d', strtotime($check->created_at));
        //  if($data==$value->date)
        //   {
        //       $activitydata['withdraw']=  $value->user_withdraw_amount;
        //       DB::table('user_activity_daily_report')->where('id',$check->id)->update($activitydata);
        //   }
        // }
        // }
        //  $user_add_amount=DB::table('transactions')
        //    ->select(DB::raw('SUM(amount) as user_add_amount'),
        //    DB::raw('DATE(created) date'))
        //    ->where('type','=','Add Fund')
        //    ->where('paymentstatus','=','confirmed')
        //    ->orWhere('paymentstatus','=','authorized')
        //    ->whereRaw('DATE(`created`) = ?', array(date('D')))
        //    ->groupby('date')
        //    ->orderByDesc('created')
        // //   ->limit(1)
        //    ->get()
        //    ->reverse()->values();

        // foreach ($user_add_amount as $key => $value) {
        //
        // $check= DB::table('user_activity_daily_report')->where('created_at','LIKE','%'.$value->date.'%')->first();
        //
        // if(!empty($check)){
        // $data= date('Y-m-d', strtotime($check->created_at));
        //  if($data==$value->date)
        //   {
        //       $activitydata['add_cash']=  $value->user_add_amount;
        //       DB::table('user_activity_daily_report')->where('id',$check->id)->update($activitydata);
        //   }
        // }
        // }

        // $total_registers=DB::table('registerusers')
        // 	->select(DB::raw('COUNT(*) as total_registers'),DB::raw('DATE(created_at) date'))
        // 	->where('created_at', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
        // 	->groupby('date')
        // 	->orderByDesc('created_at')
        // 	//->limit(1)
        // 	->get()
        // 	->reverse()->values();
        // foreach ($total_registers as $key => $value) {
        //
        // $check= DB::table('user_activity_daily_report')->where('created_at','LIKE','%'.$value->date.'%')->first();
        //
        // if(!empty($check)){
        // $data= date('Y-m-d', strtotime($check->created_at));
        //  if($data==$value->date)
        //   {
        //       $activitydata['register_user']=  $value->total_registers;
        //       DB::table('user_activity_daily_report')->where('id',$check->id)->update($activitydata);
        //   }
        // }
        // }
        // 					$total_active_users= DB::table('registerusers')
        // 						 ->join('transactions','registerusers.id','=','transactions.userid')
        // 						->select(DB::raw('COUNT(*) as total_active_users'),DB::raw('DATE(created) date'))
        // 						->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
        // 						->where('transactions.paymentstatus','=','confirmed')
        // 						->groupby('date')
        // 						->orderByDesc('transactions.created')
        // 					//	->limit(1)
        // 						->get()
        // 						->reverse()->values();
        // //
        // foreach ($total_active_users as $key => $value) {
        //
        // $check= DB::table('user_activity_daily_report')->where('created_at','LIKE','%'.$value->date.'%')->first();
        //
        // if(!empty($check)){
        // $data= date('Y-m-d', strtotime($check->created_at));
        //  if($data==$value->date)
        //   {
        //       $activitydata['active_user']=  $value->total_active_users;
        //       DB::table('user_activity_daily_report')->where('id',$check->id)->update($activitydata);
        //   }
        // }
        // }
        // exit;

        Storage::append('croncheck.txt', 'users_balance_detail_cron-' . Carbon::now());
        $current_date_time = date("Y-m-d") . ' 00:00:00';
        $current_date_time_end = date("Y-m-d") . ' 23:59:59';

        $countuserbalanacedetail = DB::table('user_balance_detail')->where('created_at', '>=', $current_date_time)->where('created_at', '<=', $current_date_time_end)->count();

        if ($countuserbalanacedetail == 0) {
            // $addAmount=DB::table('transactions')
            //                ->where('type','=','Add Fund')
            //                ->where('paymentstatus','=','confirmed')
            //                ->where('created', 'LIKE', '%'.date('Y-m-d').'%')
            //                ->sum('amount');
            //  $checkmonthdata= DB::table('month_wise_report_add_joinuser')
            //             ->where('year',date('Y'))
            //           ->where('month',date('n'))
            //           ->first();
            //   if(!empty($checkmonthdata))
            //   {
            //     DB::table('month_wise_report_add_joinuser')
            //                ->where('id',$checkmonthdata->id)
            //              ->update(['add_amount'=>$addAmount]);
            //   }
            // $string_date = Carbon::now();
            // $today_date = explode(' ', $string_date);
            // $today_join_user =DB::table('registerusers')
            //                      ->where('created_at', 'like', '%' . $today_date[0] . '%')
            //                     ->where('is_bot', 0)
            //                     ->where('email', '!=',null)
            //                     ->where('activation_status', '!=','pending')
            //                     ->select(DB::raw("COUNT(id) as total_user"))
            //                     ->get();
            //           // print_r($today_join_user);die();
            //
            // $count_total_user_join=$today_join_user[0]->total_user;
            //
            //
            //   if(!empty($checkmonthdata))
            //   {
            //     DB::table('month_wise_report_add_joinuser')
            //                ->where('id',$checkmonthdata->id)
            //              ->update(['add_user'=>$count_total_user_join]);
            //   }
            //
            //

            $userbalanacedetail = DB::table('userbalances')
                ->select(
                    DB::raw('SUM(userbalances.balance) as total_bal'),
                    DB::raw('SUM(userbalances.winning) as total_win'),
                    DB::raw('SUM(userbalances.bonus) as total_bon'),
                    DB::raw('SUM(userbalances.gst_bonus) as total_gstbon'),
                    DB::raw('SUM(userbalances.affiliation_commission) as total_affiliation_amount'),
                    DB::raw('SUM(userbalances.balance + userbalances.winning + userbalances.bonus+userbalances.gst_bonus+userbalances.affiliation_commission) as overall_bal')
                )
                ->where('created_at', '<=', $current_date_time_end)->first();


            // Totaluniqueuser unique user calculation
            $todaymatcheslist = DB::table('listmatches')
                ->select('id', 'matchkey', 'start_date', 'status')
                ->where('start_date', '>=', $current_date_time)
                ->where('start_date', '<=', $current_date_time_end)
                // ->where('status', '=', 'completed')
                ->get();

            $match_keys = array();
            foreach ($todaymatcheslist as $matchlist) {
                $match_keys[] = $matchlist->matchkey;
            }

            /*
    $Totaluser = DB::table('joinedleauges')
    ->select('userid')
    ->whereIn('joinedleauges.matchkey', $match_keys)
    ->groupBy('joinedleauges.userid')
    ->orderBy('joinedleauges.userid','ASC')->get();

    $Totaluniqueuser = count($Totaluser);
    */

            // Update the logic number of unique users
            $Totaluser = DB::table('joinedleauges')
                ->select('userid')
                ->whereIn('joinedleauges.matchkey', $match_keys)
                ->groupBy('joinedleauges.userid')
                ->orderBy('joinedleauges.userid', 'ASC')->get();



            $Jlusers = array();

            foreach ($Totaluser as $userbuysell) {
                $Jlusers[] = $userbuysell->userid;
            }


            // $Totaluniqueuserpass = array_values(array_unique(array_merge ($Jlusers, $Vplusers)));
            $Totaluniqueuserpass = array_values(array_unique($Jlusers));

            $Totaluniqueuser = count($Totaluniqueuserpass);

            // Update the logic number of unique users




            // Totaluniqueuser unique user calculation
            $overall_balance = $userbalanacedetail->total_bal + $userbalanacedetail->total_win + $userbalanacedetail->total_bon + $userbalanacedetail->total_gstbon + $userbalanacedetail->total_affiliation_amount;

            $insertdata['total_balance']    = number_format($userbalanacedetail->total_bal, 2);
            $insertdata['total_winning']    = number_format($userbalanacedetail->total_win, 2);
            $insertdata['total_bonus']      = number_format($userbalanacedetail->total_bon, 2);
            $insertdata['total_gstbonus']      = number_format($userbalanacedetail->total_gstbon, 2);
            $insertdata['total_affiliation_amount']  = number_format($userbalanacedetail->total_affiliation_amount, 2);
            // $insertdata['overall_balance']  = number_format($userbalanacedetail->overall_bal,2);
            $insertdata['overall_balance']  = number_format($overall_balance, 2);
            $insertdata['unique_user']      = $Totaluniqueuser;

            DB::table('user_balance_detail')->insert($insertdata);



            if (isset($req->isButton) && !empty($req->isButton)) {
                return Redirect::back();
            }
            echo "Today Userbalace Set.....!";
            return 1;
        }
        echo "No Data available....!";
        if (isset($req->isButton) && !empty($req->isButton)) {
            return Redirect::back();
        }
        // else { echo "we already have these record"; }

    } //End Function


    public function useractivityreport()
    {
        //All activity recorde
        $user_withdraw_amount = DB::table('withdraw')
            ->select(
                DB::raw('SUM(amount) as user_withdraw_amount'),
                DB::raw('DATE(approved_date) date')
            )
            // ->where('status','1')
            ->whereIn('status', ['1', '3'])

            // ->whereRaw('DATE(`created`) = ?',array(date('d')))
            ->where('approved_date', '<=', date('Y-m-d', strtotime('-0 day', strtotime(date('Y-m-d')))) . ' 23:59:00')
            ->groupby('date')
            ->orderByDesc('approved_date')
            ->limit(1)
            ->get()
            ->reverse()->values();

        $user_add_amount = DB::table('transactions')
            ->select(
                DB::raw('SUM(amount) as user_add_amount'),
                DB::raw('DATE(created) date')
            )
            ->where('type', '=', 'Add Fund')
            ->where('paymentstatus', '=', 'confirmed')
            ->orWhere('paymentstatus', '=', 'authorized')
            ->whereRaw('DATE(`created`) = ?', array(date('D')))
            ->groupby('date')
            ->orderByDesc('created')
            ->limit(1)
            ->get()
            ->reverse()->values();

        $total_registers = DB::table('registerusers')
            ->select(DB::raw('COUNT(*) as total_registers'), DB::raw('DATE(created_at) date'))
            ->where('created_at', '<=', date('Y-m-d', strtotime('-0 day', strtotime(date('Y-m-d')))) . ' 23:59:00')
            ->groupby('date')
            ->orderByDesc('created_at')
            ->limit(1)
            ->get()
            ->reverse()->values();


        // $total_active_users= DB::table('registerusers')
        // 	 ->join('transactions','registerusers.id','=','transactions.userid')
        // 	->select(DB::raw('COUNT(*) as total_active_users'),DB::raw('DATE(created) date'))
        // 	->where('created', '<=', date('Y-m-d' , strtotime('-0 day', strtotime(date('Y-m-d')))).' 23:59:00')
        // 	->where('transactions.paymentstatus','=','confirmed')
        // 	->groupby('date')
        // 	->orderByDesc('transactions.created')
        // 	->limit(1)
        // 	->get()
        // 	->reverse()->values();


        $activitydata['active_user'] = 0;
        $activitydata['register_user'] = 0;
        $activitydata['add_cash'] = 0;
        $activitydata['withdraw'] = 0;
        if (!empty($total_active_users)) {
            $activuser = $total_active_users[0]->total_active_users;
            $activitydata['active_user'] = $activuser;
        }
        if (!empty($total_registers)) {
            $register = $total_registers[0]->total_registers;
            $activitydata['register_user'] = $register;
        }
        if (!empty($user_add_amount)) {
            $addcash = $user_add_amount[0]->user_add_amount;
            $activitydata['add_cash'] = $addcash;
        }
        if (!empty($user_withdraw_amount)) {
            $withdraw = $user_withdraw_amount[0]->user_withdraw_amount;
            $activitydata['withdraw'] = $withdraw;
        }

        DB::table('user_activity_daily_report')->insert($activitydata);
    }
    //Edit Details
    public function edit_details(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $refercode = $input['refercode'];
            $user_id = $input['id'];
            if (!empty($refercode) && !empty($user_id)) {
                $findifexist = DB::table('registerusers')->where('refercode', $refercode)->where('id', '!=', $user_id)->first();
                if (empty($findifexist)) {
                    $update_data['refercode'] = $refercode;
                    DB::table('registerusers')->where('id', $user_id)->update($update_data);
                    Session::flash('flash_notice', 'User refer code edit successfully.');
                    Session::flash('alert-class', 'alert-success');
                    return Redirect::back();
                } else {
                    Session::flash('flash_notice', 'Refer Code already exists.');
                    Session::flash('alert-class', 'alert-danger');
                    return Redirect::back();
                }
            }
            die;
        }
        Session::flash('error', 'Please select fields!');
        return Redirect::back();
    } //End Function

    //update user status
    public function updateuserstatus($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['activation_status'] = $status;
        DB::table('registerusers')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'User ' . $status . ' successfully!');
        return Redirect::back();
    } //End Function

    //update user status
    public function deactivate_user_status(Request $req)
    {
        if (isset($req->pan_used)) {
            if ($req->pan_used == 1) {
                $input_pancard['status'] = 2;
            } else {
                $input_pancard['status'] = 1;
            }
        } else {
            $input_pancard['status'] = 1;
        }
        if (isset($req->bank_used)) {
            if ($req->bank_used == 1) {
                $input_bank['status'] = 2;
            } else {
                $input_bank['status'] = 2;
            }
        } else {
            $input_bank['status'] = 2;
        }
        $input['activation_status'] = 'deactivated';
        DB::table('pancard')->where('userid', $req->user_id)->update($input_pancard);
        DB::table('bank')->where('userid', $req->user_id)->update($input_bank);
        DB::table('registerusers')->where('id', $req->user_id)->update($input);
        Session::flash('flash_notice', 'User Deactivated successfully!');
        return Redirect::back();
    } //End Function


    //edit-pan-details
    public function editpandetails(Request $request, $id)
    {


        //Get ID Unserialize
        $id = unserialize(base64_decode($id));
        //Get Pan Card Data
        $editpandetails = DB::table('pancard')->where('id', $id)->first();

        if ($request->isMethod('post')) {
            //Velidation Bank
            $validate = array(
                'pan_number'              => "required|min:10|max:10",
                'pan_name'                => "required|regex:/^[\pL\s\-]+$/u",
                'pan_dob'                    => "required",
                'status'                    => "required",
                'comment'                    => "required",
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Get Input data
                $input = Input::all();
                //Set Value
                $status = $input['status'];
                $fiends['pan_name'] = strtoupper($input['pan_name']);
                $fiends['pan_number'] = $input['pan_number'];
                if (request()->hasFile('image')) {
                    $folderPath  = 'uploads/pan_image/';
                    $image = request()->file('image'); // Get the uploaded file
                    $extension = $image->getClientOriginalExtension();

                    $img_ext = explode(",", IMAGE_EXTENSION);
                    if (in_array($extension, $img_ext)) {
                        // Ensure the directory exists
                        if (!file_exists(public_path($folderPath))) {
                            mkdir(public_path($folderPath), 0777, true);
                        }

                        // Generate a unique file name
                        $fileName = env("APP_NAME") . '-pan_image-' . rand(100000, 999999) . "." . $extension;
                        $filePath = $folderPath . $fileName;

                        // Move the uploaded file to the directory
                        $image->move(public_path($folderPath), $fileName);

                        // Upload to AWS (if needed)
                        $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
                        $input['image'] = env('CDN_URL') . 'uploads/pan_image/' . $uploadedFileName;
                        // Delete local file after uploading to AWS
                        @unlink(public_path($filePath));
                    } else {
                        Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                        return Redirect::back()->withInput();
                    }
                }
                unset($input['oldimage']);
                if ($status != "") {
                    if ($status == 1) {
                        $st = 'Verified';
                    }
                }
                unset($input['_token']);
                $req['pan_verify'] = $status;

                //print_r($input);die;
                DB::table('pancard')->where('id', $id)->update($input);
                $findlastow = DB::table('pancard')->where('id', $id)->first();
                if (!empty($findlastow)) {
                    $userid = $findlastow->userid;
                }
                $finduserbonus = DB::table('registerusers')->where('id', $userid)->select('panbonus', 'email', 'team')->first();
                if ($status == 1) {
                    $st = 'Verified';
                }
                if ($status == 2) {
                    $st = 'rejected';
                    $email = $finduserbonus->email;
                    //Send Mail Template
                    $email_templates = DB::table('email_templates')->where('action', 'PAN Card Documents were not Approved')->first();

                    //Set Subject
                    $emailsubject = $email_templates->subject . '- FC';
                    //Set Email Body
                    $email_body = array('{NAME}', '{COMMENT}');
                    //Replace
                    $rep_Array = array(ucwords($finduserbonus->team), $input['comment']);
                    //Replase Value
                    $messageBody = str_replace($email_body, $rep_Array, $email_templates->body);
                    //Send Mail
                    $msg = Helpers::mailheader();
                    $msg .= $messageBody;
                    $msg .= Helpers::mailfooter();
                    Helpers::mailsentFormat($email, $emailsubject, $msg);
                }
                if ($st == 'Verified') {
                    $req['username'] = $findlastow->pan_name;
                    $req['dob'] = date('Y-m-d', strtotime($findlastow->pan_dob));
                    $req['panbonus'] = 1;
                    if ($finduserbonus->panbonus == 0) {
                        //ApiController::getbonus($userid,'Pan Card');
                    }
                    $email = $finduserbonus->email;
                    //Send Mail Template
                    $email_templates = DB::table('email_templates')->where('action', 'PAN Card Documents Approved')->first();
                    //Set Subject
                    $emailsubject = '- FC';
                    //Set Email Body
                    $email_body = array('{NAME}');
                    //Replace
                    $rep_Array = array(ucwords($finduserbonus->team));
                    //Replase Value
                    $messageBody = str_replace($email_body, $rep_Array, $email_body);
                    //Send Mail

                    $msg = Helpers::mailheader();
                    $msg .= $messageBody[0];
                    $msg .= Helpers::mailfooter();

                    Helpers::mailsentFormat($email, $emailsubject, $msg);
                }
                // print_r($req); exit;
                DB::table('registerusers')->where('id', $userid)->update($req);
                $notificationdata['userid'] = $userid;
                $notificationdata['title'] = 'Your PAN card verification request is ' . $st;
                if ($st != 'Verified') {
                    $notificationdata['title'] = 'Your Bank documents request is ' . $st . ' Due to ' . $input['comment'];
                }
                DB::table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Verification Request!';
                Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
                //end push notifications//
                Session::flash('flash_notice', 'PAN Card Request is ' . $st . '!');
                Session::flash('alert-class', 'alert-success');
                //return Redirect::back();
                return Redirect::route($this->model . '.view_pan_details', base64_encode(serialize($id)));
            } //Validation
        } //EndCkeck Empty Val
        //Show Page
        return view("admin.$this->model.editpandetails", compact('editpandetails'));
    }

    //edit-bank-details
    public function editbankdetails($id, Request $request)
    {



        $id = unserialize(base64_decode($id));
        //Bank Detail
        $editbankdetails = DB::table('bank')->where('id', $id)->first();
        //State states
        //$states = DB::table('states')->get();
        //Update Bank Data
        if ($request->isMethod('post')) {
            //Velidation Bank
            $validate = array(
                'accno'                      => "required|unique:bank,accno,$id",
                'ifsc'                      => "required",
                //'bankname'                => "required|regex:/^[\pL\s\-]+$/u",
                //'bankbranch'              => "required",
                //'state'              	  => "required",
                'status'                    => "required",
                //'comment'              	  => "required",
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Get All Data
                $input = Input::all();
                //Unset Request
                unset($input['_token']);
                //Set Value
                $status = $input['status'];
                $req['bank_verify'] = $status;
                $input['ifsc'] = strtoupper($input['ifsc']);
                $input['bankname'] = strtoupper($input['bankname']);
                $input['bankbranch'] = strtoupper($input['bankbranch']);

                if (request()->hasFile('image')) {
                    $folderPath  = 'uploads/bank_image/';
                    $image = request()->file('image'); // Get the uploaded file
                    $extension = $image->getClientOriginalExtension();

                    $img_ext = explode(",", IMAGE_EXTENSION);
                    if (in_array($extension, $img_ext)) {
                        // Ensure the directory exists
                        if (!file_exists(public_path($folderPath))) {
                            mkdir(public_path($folderPath), 0777, true);
                        }

                        // Generate a unique file name
                        $fileName = env("APP_NAME") . '-bank_image-' . rand(100000, 999999) . "." . $extension;
                        $filePath = $folderPath . $fileName;

                        // Move the uploaded file to the directory
                        $image->move(public_path($folderPath), $fileName);

                        // Upload to AWS (if needed)
                        $uploadedFileName = TeamsController::aws_upload_image($filePath, $folderPath, $fileName);
                        $input['image'] = env('CDN_URL') . 'uploads/bank_image/' . $uploadedFileName;
                        // Delete local file after uploading to AWS
                        @unlink(public_path($filePath));
                    } else {
                        Session::flash('error', trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                        return Redirect::back()->withInput();
                    }
                }


                unset($input['oldimage']);
                //Update Bank All Data

                DB::table('bank')->where('id', $id)->update($input);
                //Get Bank Data
                // print_r("success"); die();
                $findlastow = DB::table('bank')->where('id', $id)->first();
                //Get Data
                if (!empty($findlastow)) {
                    $userid = $findlastow->userid;
                }
                //Get User Data
                $finduserbonus = DB::table('registerusers')->where('id', $userid)->select('bankbonus', 'email', 'team')->first();
                //Ckeck Status
                if ($status == 1) {
                    $st = 'Verified';
                }
                //Rejected
                if ($status == 2) {
                    $st = 'rejected';
                    $email = $finduserbonus->email;
                    //Edit Url
                    $edit_url = config()->get('constants.FRONT_PROJECT_URL') . 'varifyaccount';
                    //Send Mail Template
                    $email_templates = DB::table('email_templates')->where('action', 'Bank Documents were not Approved')->first();
                    //Set Subject
                    $emailsubject = '- FC';
                    //Set Email Body
                    $email_body = array('{NAME}', '{COMMENT}', '{EDIT_URL}');
                    //Replace
                    $rep_Array = array(ucwords($finduserbonus->team), $input['comment'], $edit_url);
                    //Replase Value
                    //$messageBody = str_replace($email_body,$rep_Array);

                    $msg = Helpers::mailheader();
                    $msg .= @$messageBody;
                    $msg .= Helpers::mailfooter();
                    Helpers::mailsentFormat($email, $emailsubject, $msg);
                }
                //Verified
                if ($st == 'Verified') {
                    $req['bankbonus'] = 1;
                    //  $req['state']=$findlastow->state;
                    // if(Helpers::cf_add_benificary($userid)) {
                    // } else {
                    //
                    // Session::flash('flash_notice', 'There is some error please try again!');
                    // Session::flash('alert-class', 'alert-danger');
                    // return Redirect::back();
                    // }
                }
                //Update User
                DB::table('registerusers')->where('id', $userid)->update($req);
                //Notification
                $notificationdata['userid'] = $userid;
                $notificationdata['title'] = 'Your Bank documents request is ' . $st;
                if ($st != 'Verified') {
                    $notificationdata['title'] = 'Your Bank documents request is ' . $st . ' Due to ' . $input['comment'];
                }

                DB::table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Bank Documents Verification Request!';
                Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
                //end push notifications//
                Session::flash('flash_notice', 'Bank Account Request is ' . $st . '!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::back();
            }
        }
        //View Page
        return view("admin.$this->model.editbankdetails", compact('editbankdetails'));
    } //End Function

    public function withdraw_amount_instant(Request $req)
    {


        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {

                if (isset($formData['withdraw_request_id'])) {

                    $res = DB::table('withdraw as w')->where('withdraw_request_id', '=', $formData['withdraw_request_id'])->first();

                    if (!is_null($res)) {
                        Session::flash('flash_notice', 'Withdraw Request Id Is Already Exist!');
                        Session::flash('alert-class', 'alert-warning');
                        return Redirect::back();
                    } else {
                        DB::table('withdraw as w')->where('id', '=', $formData['id'])->update(['withdraw_request_id' => $formData['withdraw_request_id']]);
                        Session::flash('flash_notice', 'Withdraw Request Id Updated!');
                        Session::flash('alert-class', 'alert-success');
                        return Redirect::back();
                    }
                }

                $checkfaild = DB::table('withdraw')->where('status', 0)
                    ->where('is_instant', 1)
                    ->first();


                return Datatables::of(DB::table('withdraw as w')
                    ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                    ->leftJoin('joinedleauges as jl', 'jl.userid', '=', 'r.id')
                    ->select('r.*', 'w.*', 'r.id as reg_id', 'w.id as withdraw_id', 'r.activation_status as reg_status', 'w.status as withdraw_status', 'w.amount as withdraw_amount', 'w.created as withdraw_request', 'jl.id as joinedleauges_id')

                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_amount'])) {
                                $query->where('w.amount', 'like', '%' . $formData['filter_columns']['filter_withdraw_amount'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_request_id'])) {
                                $query->where('w.withdraw_request_id', 'like', '%' . $formData['filter_columns']['filter_withdraw_request_id'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_status'])) {
                                if ($formData['filter_columns']['filter_withdraw_status'] == 0) {
                                    $query->whereIN('w.status', [0]);
                                } else {
                                    $query->where('w.status', '=', $formData['filter_columns']['filter_withdraw_status']);
                                }
                            }
                            if (isset($formData['start_date'])) {
                                $query->whereBetween('w.created', [$formData['start_date'], $formData['end_date']]);
                            }
                        }
                    })
                    ->where('is_instant', 1)

                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_status'])) {
                                $query->where('status', $formData['filter_columns']['filter_status']);
                            }
                        } else {
                            $query->whereIn('status', [0, 1, -1, 18, 9, 2, 3]);
                        }
                    })

                    ->where(function ($query) use ($checkfaild) {
                        if (!empty($checkfaild)) {
                            $query->orderBy('w.withdraw_status', 0)
                                ->orderBy('w.created', 'DESC');
                        } else {
                            $query->orderBy('w.created', 'DESC');
                        }
                    })
                    //->orderBy('w.status','0')
                    ->orderBy('w.created', 'DESC')
                    ->groupBy('w.id')
                    ->limit('1000')
                    ->get())

                    ->addIndexColumn()
                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->email;
                    })
                    /*->addColumn('withdraw_request',function ($result){
      return date('d-M-Y',strtotime($result->withdraw_request));
    })*/
                    ->addColumn('withdraw_request_id', function ($result) {
                        return '<form name="form-' . $result->withdraw_id . '" action="' . route($this->model . '.update_withdraw_req_id') . '" method="post">
      ' . csrf_field() . '
      <input type="text" id="req_id' . $result->withdraw_id . '" class="form-control" name="withdraw_request_id" value="' . htmlspecialchars($result->withdraw_request_id, ENT_QUOTES, 'UTF-8') . '">
      <input type="hidden" id="w_id' . $result->withdraw_id . '" name="id" value="' . $result->withdraw_id . '">
      <input type="submit" id="req_id_update' . $result->withdraw_id . '" value="Update" maxlength="20" class="btn btn-info mr-1 mt-1">
      </form>';
                    })
                    ->addColumn('withdraw_amount', function ($result) {

                        return number_format($result->withdraw_amount, 2);
                    })
                    ->addColumn('withdraw_request', function ($result) {
                        if ($result->withdraw_request != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->withdraw_request));
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('approved_date', function ($result) {
                        if ($result->status == 1 || $result->status == 3) {
                            return date('d M Y', strtotime($result->approved_date));
                        } else {
                            if ($result->withdraw_status == 0) {
                                return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_paytm_withdraw') . '" method="post">
          ' . csrf_field() . '
          <input type="text" class="form-control text-comment" name="comment">
          <input type="hidden" name="id" value="' . $result->withdraw_id . '">
          <input type="hidden" name="uid" value="' . $result->reg_id . '">
          <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">


          <button type="submit" data-type="reject" data-toggle="tooltip" title="Reject" class="btn btn-info admin-comment mr-1 mt-1">Reject<i class="fa fa-times" aria-hidden="true"></i></button>
          </form>
          ';
                            }
                            return '';
                        }
                    })
                    ->addColumn('cashfree_error_text', function ($result) {
                        if ($result->razorpay_status != '') {
                            return $result->razorpay_status;
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('approve_paytm_manual', function ($result) {
                        if ($result->withdraw_status == 0) {
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.approve_paytm_manual') . '" method="post">
        ' . csrf_field() . '
        <input type="text" class="form-control" name="comment">
        <input type="hidden" name="id" value="' . $result->withdraw_id . '">
        <input type="hidden" name="uid" value="' . $result->reg_id . '">
        <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
        <input type="submit" value="Approve" maxlength="20" class="btn btn-info mr-1 mt-1">
        </form>';
                        } else {

                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            $withdraw_manually_status = '';
                            if ($result->withdraw_status == 1) {
                                $withdraw_manually_status .= "<label class='success_icn'>Approved $info </label>";
                            }
                            if ($result->withdraw_status == -1) {
                                $withdraw_manually_status .= "<label class='failed_icn'>Rejected $info</label>";
                            }

                            return $withdraw_manually_status;
                        }
                    })->addColumn('withdraw_status', function ($result) {
                        if ($result->withdraw_status == 0) { //
                            /*return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.approve').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Approve" maxlength="20" class="btn btn-info" style="color:#000;margin-top:3px;">
        </form>
        <form class="form-horizontal form-label-left" action="'.route($this->model.'.reject').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Reject" maxlength="20" class="btn btn-info" style="color:#000;margin-top:3px;">
        </form>';

        //approve and reject button original
        <button class="btn btn-info admin-comment" data-type="approve" style="color:#000;margin-top:3px;">Approve</button>
        <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
        */
                            if (empty($result->paytm_benid)) {
                                // return '<a href="'.route($this->model.'.addPaytmBen',$result->reg_id).'" style="text-decoration:underline;" class="btn btn-primary">Add Paytm Beneficary</a>';
                            }
                            // <button type="submit" data-type="approve" data-toggle="tooltip" title="Approve" class="btn btn-info admin-comment mr-1 mt-1"><i class="fa fa-check" aria-hidden="true"></i>
                            // </button>

                            //band kiya
                            // return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.admin_comment_paytm_withdraw').'" method="post">
                            // '.csrf_field().'
                            // <input type="text" class="form-control text-comment" name="comment">
                            // <input type="hidden" name="id" value="'.$result->withdraw_id.'">
                            // <input type="hidden" name="uid" value="'.$result->reg_id.'">
                            // <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
                            //
                            //
                            // <button type="submit" data-type="reject" data-toggle="tooltip" title="Reject" class="btn btn-info admin-comment mr-1 mt-1"><i class="fa fa-times" aria-hidden="true"></i></button>
                            // </form>
                            // ';


                            // if(($result->razorpay_status=='reversed' || $result->razorpay_status=='failed') && ($result->withdraw_status==0)){
                            //
                            //     return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.admin_comment_bank_withdraw').'" method="post">
                            //     '.csrf_field().'
                            //     <input type="text" class="form-control text-comment" name="comment">
                            //     <input type="hidden" name="id" value="'.$result->withdraw_id.'">
                            //   <input type="hidden" name="is_manual_withdraw" value="1">
                            //     <input type="hidden" name="uid" value="'.$result->reg_id.'">
                            //     <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
                            //
                            //     <button class="btn btn-info admin-comment" data-type="settle" style="color:#000;margin-top:3px;">Settled</button>
                            //     </form>
                            //     ';
                            // }
                        } else {
                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            $withdraw_status = '';
                            if ($result->withdraw_status == 1) {
                                $withdraw_status .= "<label class='success_icn'>Approved $info</label>";
                            }
                            if ($result->withdraw_status == -1) {
                                $withdraw_status .= "<label class='failed_icn'>Rejected $info</label>";
                            }
                            if ($result->withdraw_status == 2) {
                                $withdraw_status .= "<label class='failed_icn'>Rejected $info</label>";
                            }
                            if ($result->withdraw_status == 3) {
                                $withdraw_status .= "<label class='success_icn'>Settled $info</label>";
                            }


                            return $withdraw_status;
                        }
                    })
                    ->addColumn('gateway_id', function ($result) {
                        return $result->razorpay_pout_id;
                    })
                    ->addColumn('action', function ($result) {
                        //Show Joined Leauges
                        if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                            $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leagues" class="btn btn-primary mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                        } else {
                            $joinedleauges_link = '';
                        } //End Function
                        return '<a href="' . route($this->model . '.view_user', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View"></i></a>'
                            . $joinedleauges_link;
                    })

                    ->escapeColumns([])
                    ->make(true);
            }
        } //end

        return view("admin.$this->model.withdraw_amount_instant");
    } //End Function

    public function manage_otp_limit(Request $req)
    {


        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {

                if (isset($formData['withdraw_request_id'])) {

                    $res = DB::table('withdraw as w')->where('withdraw_request_id', '=', $formData['withdraw_request_id'])->first();

                    if (!is_null($res)) {
                        Session::flash('flash_notice', 'Withdraw Request Id Is Already Exist!');
                        Session::flash('alert-class', 'alert-warning');
                        return Redirect::back();
                    } else {
                        DB::table('withdraw as w')->where('id', '=', $formData['id'])->update(['withdraw_request_id' => $formData['withdraw_request_id']]);
                        Session::flash('flash_notice', 'Withdraw Request Id Updated!');
                        Session::flash('alert-class', 'alert-success');
                        return Redirect::back();
                    }
                }


                return Datatables::of(DB::table('otp as o')
                    ->select('o.*')

                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('o.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                        }
                    })
                    ->orderBy('o.id', 'DESC')
                    ->limit('1000')
                    ->get())
                    ->addIndexColumn()
                    /*->addColumn('withdraw_request',function ($result){
      return date('d-M-Y',strtotime($result->withdraw_request));
    })*/
                    ->addColumn('action', function ($result) {
                        //Show Joined Leauges

                        // return '<a href="'.route($this->model.'.view_user',base64_encode(serialize($result->reg_id))).'" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View"></i></a>'
                        // .$joinedleauges_link;
                        return '<form name="form-"' . $result->id . '"  action="' . route($this->model . '.remove_otp_limit') . '" method="post">
                        <input type="hidden" name="_token" value="' . csrf_token() . '">
      <input type="hidden" id="otp_id' . $result->id . '" name="otp_id" value="' . $result->id . '">
      <input type="submit" value="Remove Limit" class="btn btn-info mr-1 mt-1">
      </form>';
                    })
                    ->escapeColumns([])
                    ->make(true);
            }
        } //end

        return view("admin.$this->model.manage_otp_limit");
    } //End Function


    public function add_fund_list_download(Request $req)
    {
        if (empty($req->start_date) && empty($req->end_date)) {
            $req->start_date = date('Y-m-d') . ' 00:00:00';
            $req->end_date = date('Y-m-d H:i:s');
        }
        $getlist =  DB::table('transactions')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')
            ->where('transactions.type', 'Add Fund')
            ->where(function ($query) use ($req) {
                if (isset($req->transaction_by))
                    $query->where('transactions.transaction_by', $req->transaction_by);
            })
            ->where(function ($query) use ($req) {
                if (isset($req->start_date) && isset($req->end_date)) {
                    $newdate = date('Y-m-d', strtotime($req->start_date));
                    $startdate = $newdate . ' 00:00:00';
                    $query->whereBetween('transactions.created', [$startdate, $req->end_date]);
                }
            })
            ->select('transactions.amount', 'transactions.paymentstatus', 'registerusers.username', 'registerusers.email', 'registerusers.mobile', 'transactions.created', 'transactions.transaction_by', 'transaction_id', 'transactions.state')
            ->orderBy('transactions.id', 'DESC')
            ->get();

        $output1        = "";
        $output1 .= '"User Name",';
        $output1 .= '"Mobile",';
        $output1 .= '"Amount",';
        $output1 .= '"Status",';
        $output1 .= '"Payment Mode",';
        $output1 .= '"Geteway Transaction Id ",';
        $output1 .= '"Add cash State ",';
        $output1 .= '"Create Date",';
        $output1 .= "\n";
        if (!empty($getlist)) {
            foreach ($getlist as $get) {
                $output1 .= '"' . $get->username . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->amount . '",';
                $output1 .= '"' . $get->paymentstatus . '",';
                $output1 .= '"' . $get->transaction_by . '",';
                $output1 .= '"' . $get->transaction_id . '",';
                $output1 .= '"' . $get->state . '",';
                $output1 .= '"' . date('d-M-Y H:i:s', strtotime($get->created)) . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "Download_add_fund_list.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }


    public function add_fund_list(Request $req)
    {

        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (empty($formData['start_date'])) {
                $formData['start_date'] = date('Y-m-d H:i:s');
            }
            if (empty($formData['end_date'])) {
                $formData['end_date'] = date('Y-m-d H:i:s');
            }
            //echo '<pre>'; print_r($formData);exit;

            if (isset($formData) && !empty($formData)) {
                return Datatables::of(DB::table('transactions')->join('registerusers', 'registerusers.id', '=', 'transactions.userid')
                    ->where('transactions.type', 'Add Fund')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['transaction_by']))
                            $query->where('transactions.transaction_by', $formData['transaction_by']);
                    })
                    // ->where(function ($query) use ($formData) {
                    //   if(isset($formData['start_date']))
                    //     $query->where('transactions.created', $formData['start_date']);
                    // })
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['start_date']) && isset($formData['end_date'])) {
                            $newdate = date('Y-m-d', strtotime($formData['start_date']));
                            $startdate = $newdate . ' 00:00:00';
                            $query->whereBetween('transactions.created', [$startdate, $formData['end_date']]);
                        }
                    })

                    ->select('transactions.amount', 'transactions.paymentstatus', 'registerusers.username', 'registerusers.email', 'registerusers.mobile', 'transactions.created', 'transactions.transaction_by', 'transaction_id', 'transactions.state')
                    ->orderBy('transactions.id', 'DESC')
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('paymentstatus', function ($result) {
                        if ($result->paymentstatus == 'pending' && $result->transaction_by == 'PHONEPAY') {
                            return '<a href="' . route('Bonus.checkPaymentStatus', [$result->transaction_id, 1]) . '"><b style="color:orange;">' . $result->paymentstatus . '</b></a>';
                        }
                        if ($result->paymentstatus == 'failed') {
                            return '<b style="color:red;">' . $result->paymentstatus . '</b>';
                        }
                        if ($result->paymentstatus == 'confirmed') {
                            return '<b style="color:green;">' . $result->paymentstatus . '</b>';
                        }
                        return $result->paymentstatus;
                    })

                    ->escapeColumns([])
                    ->make(true);
            }
        } //end

        return view("admin.$this->model.add_fund_list");
    } //End Function

    public function remove_otp_limit(Request $req)
    {
        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {

                if (isset($formData['otp_id'])) {

                    DB::table('otp as o')->where('id', '=', $formData['otp_id'])->update(['count' => '0']);
                    Session::flash('flash_notice', 'OTP Limit Removed!');
                    Session::flash('alert-class', 'alert-success');
                    return Redirect::back();
                }
            }
        } //end
    } //End Function


    public function update_withdraw_req_id(Request $req)
    {
        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {

                if (isset($formData['withdraw_request_id'])) {

                    $res = DB::table('withdraw as w')->where('withdraw_request_id', '=', $formData['withdraw_request_id'])->first();

                    if (!is_null($res)) {
                        Session::flash('flash_notice', 'Withdraw Request Id Is Already Exist!');
                        Session::flash('alert-class', 'alert-warning');
                        return Redirect::back();
                    } else {
                        DB::table('withdraw as w')->where('id', '=', $formData['id'])->update(['withdraw_request_id' => $formData['withdraw_request_id']]);
                        Session::flash('flash_notice', 'Withdraw Request Id Updated!');
                        Session::flash('alert-class', 'alert-success');
                        return Redirect::back();
                    }
                }
            }
        } //end
    } //End Function

    // public function withdraw_request_id_update(Request $request)
    // {
    //
    // }

    //Withdraw Amount
    public function withdraw_amount(Request $request)
    {
        //Get Post Data
        if ($request->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {

                if (isset($formData['req_id_update']['withdraw_request_id'])) {

                    $res = DB::table('withdraw as w')->where('withdraw_request_id', '=', $formData['withdraw_request_id'])->first();

                    if (!is_null($res)) {
                        Session::flash('flash_notice', 'Withdraw Request Id Is Already Exist!');
                        Session::flash('alert-class', 'alert-warning');
                        return Redirect::back();
                    } else {
                        DB::table('withdraw as w')->where('id', '=', $formData['id'])->update(['withdraw_request_id' => $formData['withdraw_request_id']]);
                        Session::flash('flash_notice', 'Withdraw Request Id Updated!');
                        Session::flash('alert-class', 'alert-success');
                        return Redirect::back();
                    }
                }

                return Datatables::of(DB::table('withdraw as w')
                    ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                    ->leftJoin('joinedleauges as jl', 'jl.userid', '=', 'r.id')
                    ->select('r.*', 'w.*', 'r.id as reg_id', 'w.id as withdraw_id', 'r.activation_status as reg_status', 'w.status as withdraw_status', 'w.amount as withdraw_amount', 'w.created as withdraw_request', 'jl.id as joinedleauges_id')
                    ->where('type', '=', 'paytm')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_amount'])) {
                                $query->where('w.amount', 'like', '%' . $formData['filter_columns']['filter_withdraw_amount'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_request_id'])) {
                                $query->where('w.withdraw_request_id', 'like', '%' . $formData['filter_columns']['filter_withdraw_request_id'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_status'])) {
                                if ($formData['filter_columns']['filter_withdraw_status'] == 0) {
                                    $query->whereIN('w.status', [0, 8, 9]);
                                } else {

                                    $query->where('w.status', '=', $formData['filter_columns']['filter_withdraw_status']);
                                }
                            }
                        }
                    })
                    ->whereIn('status', [0, 1, -1, 8, 3])
                    ->limit('1000')
                    ->groupBy('w.id')
                    ->orderBy('w.created', 'DESC')
                    ->get())

                    ->addIndexColumn()
                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->email;
                    })
                    /*->addColumn('withdraw_request',function ($result){
      return date('d-M-Y',strtotime($result->withdraw_request));
    })*/
                    // ->addColumn('withdraw_request_id',function ($result){
                    // return '<form name="form-"'.$result->withdraw_id.'" method="post" action="'..'">
                    // <input type="text" id="req_id'.$result->withdraw_id.'" class="form-control" name="withdraw_request_id" value="'.$result->withdraw_request_id.'">
                    // <input type="hidden" id="w_id'.$result->withdraw_id.'" name="id" value="'.$result->withdraw_id.'">
                    // <input type="button" onclick="getFormData(\''.$result->withdraw_id.'\')" id="req_id_update'.$result->withdraw_id.'" value="Update" maxlength="20" class="btn btn-info mr-1 mt-1">
                    // </form>';
                    // })
                    ->addColumn('withdraw_request_id', function ($result) {
                        return '<form name="form-"' . $result->withdraw_id . '"  action="' . route($this->model . '.update_withdraw_req_id') . '" method="post">
      <input type="text" id="req_id' . $result->withdraw_id . '" class="form-control" name="withdraw_request_id" value="' . $result->withdraw_request_id . '">
      <input type="hidden" id="w_id' . $result->withdraw_id . '" name="id" value="' . $result->withdraw_id . '">
      <input type="submit" id="req_id_update' . $result->withdraw_id . '" value="Update" maxlength="20" class="btn btn-info mr-1 mt-1">
      </form>';
                    })
                    ->addColumn('withdraw_request', function ($result) {
                        if ($result->withdraw_request != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->withdraw_request));
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('approved_date', function ($result) {
                        if ($result->status == 1) {
                            return date('d M Y', strtotime($result->modified));
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('approve_paytm_manual', function ($result) {
                        if ($result->withdraw_status == 0) {
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.approve_paytm_manual') . '" method="post">
        ' . csrf_field() . '
        <input type="text" class="form-control" name="comment">
        <input type="hidden" name="id" value="' . $result->withdraw_id . '">
        <input type="hidden" name="uid" value="' . $result->reg_id . '">
        <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
        <input type="submit" value="Approve" maxlength="20" class="btn btn-info mr-1 mt-1">
        </form>';
                        } else {

                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            $withdraw_manually_status = '';
                            if ($result->withdraw_status == 1) {
                                $withdraw_manually_status .= "<label class='success_icn'>Approved $info </label>";
                            }
                            if ($result->withdraw_status == -1) {
                                $withdraw_manually_status .= "<label class='failed_icn'>Rejected $info</label>";
                            }
                            return $withdraw_manually_status;
                        }
                    })->addColumn('withdraw_status', function ($result) {
                        if ($result->withdraw_status == 0) { //
                            /*return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.approve').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Approve" maxlength="20" class="btn btn-info" style="color:#000;margin-top:3px;">
        </form>
        <form class="form-horizontal form-label-left" action="'.route($this->model.'.reject').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Reject" maxlength="20" class="btn btn-info" style="color:#000;margin-top:3px;">
        </form>';

        //approve and reject button original
        <button class="btn btn-info admin-comment" data-type="approve" style="color:#000;margin-top:3px;">Approve</button>
        <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
        */
                            if (empty($result->paytm_benid)) {
                                // return '<a href="'.route($this->model.'.addPaytmBen',$result->reg_id).'" style="text-decoration:underline;" class="btn btn-primary">Add Paytm Beneficary</a>';
                            }
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_paytm_withdraw') . '" method="post">
        ' . csrf_field() . '
        <input type="text" class="form-control text-comment" name="comment">
        <input type="hidden" name="id" value="' . $result->withdraw_id . '">
        <input type="hidden" name="uid" value="' . $result->reg_id . '">
        <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">

        <button type="submit" data-type="approve" data-toggle="tooltip" title="Approve" class="btn btn-info admin-comment mr-1 mt-1"><i class="fa fa-check" aria-hidden="true"></i>
        </button>
        <button type="submit" data-type="reject" data-toggle="tooltip" title="Reject" class="btn btn-info admin-comment mr-1 mt-1"><i class="fa fa-times" aria-hidden="true"></i></button>
        </form>
        ';
                        } else {
                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            $withdraw_status = '';
                            if ($result->withdraw_status == 1) {
                                $withdraw_status .= "<label class='success_icn'>Approved $info</label>";
                            }
                            if ($result->withdraw_status == 8) {
                                $withdraw_status .= "<label class='success_icn'>Pending $info</label>";
                            }
                            if ($result->withdraw_status == -1) {
                                $withdraw_status .= "<label class='failed_icn'>Rejected $info</label>";
                            }
                            return $withdraw_status;
                        }
                    })->addColumn('action', function ($result) {
                        //Show Joined Leauges
                        if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                            $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leagues" class="btn btn-primary mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                        } else {
                            $joinedleauges_link = '';
                        } //End Function
                        return '<a href="' . route($this->model . '.view_user', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View"></i></a>'
                            . $joinedleauges_link;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.withdraw_amount");
    } //End Function

    //Approve Paytm Manual
    public function approve_paytm_manual(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $uid = $input['uid'];
            $amount = $input['amount'];
            //Set Val
            $data['status'] = 1;
            $data['comment'] = $input['comment'];
            $data['approved_date'] = date('Y-m-d');
            //Update Status
            $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($data);
            //Get Details
            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $input['id'])->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id')->first();
            $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
            if (!empty($findtransactiondate)) {
                $tdata['paymentstatus'] = 'Confirmed';
                $tdata['created'] = $findtransactiondate->created;
                $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
            }
            //mail//
            $email = $finduserdetails->email;
            //Send Mail Template
            $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
            //Set Subject
            $emailsubject = $email_templates->subject . '- FC';
            //Set Email Body
            $email_body = array('{NAME}', '{AMOUNT}');
            //Replace
            $rep_Array = array(ucwords($finduserdetails->team), $input['amount']);
            //Replase Value
            $messageBody = str_replace($email_body, $rep_Array, $email_templates->body);

            $msg = Helpers::mailheader();
            $msg .= $messageBody;
            $msg .= Helpers::mailfooter();
            Helpers::mailsentFormat($email, $emailsubject, $msg);
            //notifications//
            $notificationdata['userid'] = $finduserdetails->user_id;
            $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.' . $input['amount'];
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdrawl Request Approved!';
            Helpers::sendnotification($titleget, $notificationdata['title'], '', $finduserdetails->user_id);
            //end push notifications//
            //message show//
            Session::flash('flash_notice', 'Withdraw Request Approved successfully!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    }

    //Approve
    public function approve(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $uid = $input['uid'];
            $amount = $input['amount'];
            //User Data Get
            $settings = DB::table('registerusers')->where('id', $uid)->first();

            //
            $txnid = 'TRANS' . $input['id'];
            $getvalues['txnid'] = $txnid;
            $getvalues['amount'] = $amount;
            $getvalues['userid'] = $settings->id;
            $getvalues['username'] = $settings->username;
            $getvalues['email'] = $settings->email;
            $getvalues['phone'] = $settings->mobile;

            //Include Files
            require_once("./PaytmGraftification/lib/config_paytm.php");
            //require_once("./PaytmGraftification/lib/encdec_paytm.php");

            /*$data = array("request" => array( "requestType" => null,
    "merchantGuid" => "9717d2c7-bd03-48cb-9f68-3cb22ae1a8c2",  //87ddb260-56b2-4da2-8c4e-af2291f2d3a9
    "merchantOrderId" => $txnid,
    "salesWalletName"=> "Royal11",   //null
    "salesWalletGuid"=>"31c507aa-8cbc-47d6-a3a8-2c9e8522eccb",   //988f3600-3d64-11e8-bf28-52540059b2ee
    "payeeEmailId"=>null,
    "payeePhoneNumber"=>$settings->mobile,   //9999999999
    "payeeSsoId"=>"",
    "appliedToNewUsers"=>"Y",
    "amount"=>$amount,
    "currencyCode"=>"INR"
  ),
  "metadata"=>"Testing Data",
  "ipAddress"=>"127.0.0.1",
  "platformName"=>"PayTM",
  "operationType"=>"SALES_TO_USER_CREDIT");
  $requestData=json_encode($data);
  $Checksumhash = getChecksumFromString($requestData,"vg&rCnGWXzKyIEWQ");
  $headerValue = array('Content-Type:application/json','mid:'.'9717d2c7-bd03-48cb-9f68-3cb22ae1a8c2','checksumhash:'.$Checksumhash);
  $ch = curl_init(PAYTM_GRATIFICATION_URL);
  curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
  curl_setopt($ch, CURLOPT_POSTFIELDS, $requestData);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // return the output in string format
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
  curl_setopt($ch, CURLOPT_HTTPHEADER, $headerValue);
  $info = curl_getinfo($ch);
  $result = curl_exec($ch);
  $getfinalresult = json_decode($result);*/
            // 	echo '<pre>'; print_r($result); die;

            if (1) {

                // if(Helpers::cf_request_paytm_transfer($uid, $amount, $txnid)){
                //$walletidresponse = $getfinalresult->response;

                $data1['comment'] = $input['comment'];
                //$data1['paytm_id']=$walletidresponse->walletSysTransactionId;
                // $data1['paytm_id']="demotestdata123";
                $data1['approved_date'] = date('Y-m-d');
                $data1['status'] = 9;

                $finduserdetails = DB::table('withdraw')->where('withdraw.id', $input['id'])->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id')->first();
                $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($data1);
                $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
                $tdata['paymentstatus'] = 'Confirmed';
                //$tdata['created'] = $findtransactiondate->created;
                $tdata['created'] = isset($findtransactiondate->created) ? $findtransactiondate->created : '0000-00-00';
                $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
                //mail//
                $email = $finduserdetails->email;
                //Send Mail Template
                $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
                if (!empty($email_templates)) {
                    //Set Subject
                    $emailsubject = $email_templates->subject . '- FC';
                    //Set Email Body
                    $email_body = array('{NAME}', '{AMOUNT}');
                    //Replace
                    $rep_Array = array(ucwords($finduserdetails->team), $input['amount']);
                    //Replase Value
                    $messageBody = str_replace($email_body, $rep_Array, $email_templates->body);

                    $msg = Helpers::mailheader();
                    $msg .= $messageBody;
                    $msg .= Helpers::mailfooter();
                }

                // Helpers::mailsentFormat($email,$emailsubject,$msg);
                //push notifications//
                $titleget = 'Withdrawl Request Approved!';
                $details = 'Withdrawl Request of rs ' . $amount . ' is approved successfully.';
                // Helpers::sendnotification($titleget,$details,'',$finduserdetails->user_id);
                //end push notifications//
                //message show//
                Session::flash('flash_notice', 'Withdraw Request Processed successfully!');
                Helpers::logActivity('Paytm Withdraw Request Processed successfully', $finduserdetails->withdraw_request_id);

                Session::flash('alert-class', 'alert-success');
                return Redirect::back();
            } else {
                Session::flash('flash_notice', 'Something went wrong..');
                Session::flash('alert-class', 'alert-error');
                return Redirect::back();
            }
        }
    } //End Function

    //Raject
    public function reject(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];
            $uid = $input['uid'];
            $amount = $input['amount'];
            $data1['comment'] = $input['comment'];
            $data1['paytm_id'] = '';
            $data1['approved_date'] = date('Y-m-d');
            $data1['status'] = 2;

            $withdrawtypedata =  DB::table('withdraw')
                ->where('withdraw.id', $id)
                ->select('withdrawtype', 'is_instant')
                ->first();

            if ($withdrawtypedata->withdrawtype == 0) {
                $gettdsamount =  DB::table('withdraw')
                    ->join('tds_new', 'tds_new.withdraw_id', '=', 'withdraw.id')
                    ->where('withdraw.id', $id)
                    ->select('tds_new.tds_amount', 'tds_new.id', 'withdraw.is_instant')
                    ->first();
            } else {
                // $gettdsamount=  DB::table('withdraw')
                //   ->leftjoin('tds_new','tds_new.withdraw_id','=','withdraw.id')
                //     ->where('withdraw.id',$id)
                //     ->select('tds_new.tds_amount','tds_new.id')
                //     ->first();
                $gettdsamount =  DB::table('withdraw')
                    ->join('tds_refer_commission', 'tds_refer_commission.withdraw_id', '=', 'withdraw.id')
                    ->where('withdraw.id', $id)
                    ->select('tds_refer_commission.tds_amount', 'tds_refer_commission.id')
                    ->first();
            }


            //Update Data
            DB::table('withdraw')->where('id', $id)->update($data1);
            $useramount = DB::table('userbalances')->where('user_id', $uid)->first();
            if ($withdrawtypedata->withdrawtype == 0) {
                $updatedAmount['winning'] = $useramount->winning +  $amount;
            } else {
                $updatedAmount['affiliation_commission'] = $useramount->affiliation_commission +  $amount;
            }
            DB::table('userbalances')->where('user_id', $uid)->update($updatedAmount);
            $titleget = 'Withdrawl Request Rejected!';
            $details = 'Withdrawl Request of rs ' . $amount . ' is rejected due to ' . $input['comment'];

            $notificationdata['userid'] = $uid;
            $notificationdata['title'] = 'Your withdraw Request Rejected of amount ₹.' . $amount;
            DB::table('notifications')->insert($notificationdata);

            $finduserbalanace = DB::table('userbalances')->where('user_id', $uid)->first();
            $bonusbal = $finduserbalanace->bonus;
            $balancebal = $finduserbalanace->balance;
            $winningbal = $finduserbalanace->winning;
            $gstbal = $finduserbalanace->gst_bonus;
            $affiliationcomm = $finduserbalanace->affiliation_commission;
            $nowtotalbal = $bonusbal + $balancebal + $winningbal + $gstbal + $affiliationcomm;
            $getlasttransactionid = DB::table('transactions')->select('id')->orderBy('id', 'DESC')->first();
            if (!empty($getlasttransactionid)) {
                $tid = $getlasttransactionid->id + 1;
            } else {
                $tid = 1;
            }

            $transactiondata['type'] = 'Withdraw Request Rejected';
            $transactiondata['amount'] = $amount;
            $transactiondata['total_available_amt'] = $nowtotalbal;
            $transactiondata['transaction_id'] = 'S2W-' . $tid;
            $transactiondata['transaction_by'] = 'PLAYNWIN11';
            $transactiondata['challengeid'] = "";
            $transactiondata['userid'] = $uid;
            $transactiondata['paymentstatus'] = 'confirmed';
            $transactiondata['win_amt'] = $amount;
            $transactiondata['bal_bonus_amt'] = $bonusbal;
            $transactiondata['bal_win_amt'] = $winningbal;
            $transactiondata['bal_fund_amt'] = $balancebal;
            $transactiondata['bal_affi_amt'] = $affiliationcomm;

            DB::table('transactions')->insert($transactiondata);
            if ($withdrawtypedata->withdrawtype == 0) {
                if (!empty($gettdsamount) && $gettdsamount->tds_amount > 0) {
                    $finduserbal = DB::table('userbalances')->where('user_id', $uid)->first();
                    $bonusbal = $finduserbal->bonus;
                    $balancebal = $finduserbal->balance;
                    $winningbal = $finduserbal->winning;
                    $gstbalancebal = $finduserbal->gst_bonus;
                    $affiliationcomm = $finduserbal->affiliation_commission;
                    $nowtotalbal = $bonusbal + $balancebal + $winningbal + $gstbalancebal + $affiliationcomm + $gettdsamount->tds_amount;

                    $useramount = DB::table('userbalances')->where('user_id', $uid)->first();
                    $updatedAmount['winning'] = $useramount->winning +  $gettdsamount->tds_amount;
                    DB::table('userbalances')->where('user_id', $uid)->update($updatedAmount);



                    $getlasttransactionid = DB::table('transactions')->select('id')->orderBy('id', 'DESC')->first();
                    if (!empty($getlasttransactionid)) {
                        $tid = $getlasttransactionid->id + 1;
                    } else {
                        $tid = 1;
                    }

                    $transactiondata['type'] = 'TDS amount refund';
                    $transactiondata['amount'] = $gettdsamount->tds_amount;
                    $transactiondata['total_available_amt'] = $nowtotalbal;
                    $transactiondata['transaction_id'] = 'S2W-' . $tid;
                    $transactiondata['transaction_by'] = 'PLAYNWIN11';
                    $transactiondata['challengeid'] = "";
                    $transactiondata['userid'] = $uid;
                    $transactiondata['paymentstatus'] = 'confirmed';
                    $transactiondata['win_amt'] = $gettdsamount->tds_amount;
                    $transactiondata['bal_bonus_amt'] = $bonusbal;
                    $transactiondata['bal_win_amt'] = $winningbal + $gettdsamount->tds_amount;
                    $transactiondata['bal_fund_amt'] = $balancebal;
                    $transactiondata['bal_gst_bonus_amt'] = $gstbalancebal;
                    $transactiondata['bal_affi_amt'] = $affiliationcomm;

                    DB::table('transactions')->insert($transactiondata);
                    $tds_array = array(
                        "status" => 2,
                        "is_refunded" => 1,
                        "tds_refund_amount" => $gettdsamount->tds_amount
                    );

                    DB::table("tds_new")->where("id", $gettdsamount->id)->update($tds_array);
                }

                if (!empty($withdrawtypedata) && $withdrawtypedata->is_instant == 1) {
                    $userbalins = DB::table('userbalances')->where('user_id', $uid)->first();

                    $transactiondata['type'] = 'Instant withdraw charge refund';
                    $transactiondata['amount'] = 10;
                    $transactiondata['transaction_id'] = 'INS-CHARGE-REF-' . rand(111, 999) . $uid;
                    $transactiondata['transaction_by'] = 'PLAYNWIN11';
                    $transactiondata['challengeid'] = "";
                    $transactiondata['userid'] = $uid;
                    $transactiondata['win_amt'] = 10;
                    $transactiondata['paymentstatus'] = 'confirmed';
                    $transactiondata['bal_bonus_amt'] = $userbalins->bonus;
                    $transactiondata['bal_win_amt'] = $userbalins->winning + 10;
                    $transactiondata['bal_fund_amt'] = $userbalins->balance;
                    $transactiondata['bal_affi_amt'] = $userbalins->affiliation_commission;
                    $transactiondata['total_available_amt'] = $userbalins->bonus + $userbalins->winning + $userbalins->balance + $userbalins->affiliation_commission + 10;

                    DB::table('transactions')->insert($transactiondata);
                    DB::table('userbalances')->where('user_id', $uid)->update(['winning' => $userbalins->winning + 10]);
                }
                // $session_year = date("Y");
                $session_year = Helpers::getCurrentSessionYear();
                // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                // {
                //   $session_year = "2024";
                // }
                $registerusers_session = DB::table("registerusers_session")
                    ->where("user_id", $uid)
                    ->where("session_year", $session_year)
                    ->first();
                if (!empty($registerusers_session)) {
                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_withdraw" => ($registerusers_session->total_withdraw - ($amount + @$gettdsamount->tds_amount)) < 0 ? 0 : ($registerusers_session->total_withdraw - ($amount + @$gettdsamount->tds_amount)),
                            "total_tds_dedcuted" => ($registerusers_session->total_tds_dedcuted - @$gettdsamount->tds_amount) < 0 ? 0 : ($registerusers_session->total_tds_dedcuted - @$gettdsamount->tds_amount)
                        ]);
                }
            } else {
                $finduserbal = DB::table('userbalances')->where('user_id', $uid)->first();
                $bonusbal = $finduserbal->bonus;
                $balancebal = $finduserbal->balance;
                $winningbal = $finduserbal->winning;
                $gstbalancebal = $finduserbal->gst_bonus;
                $affbalancebal = $finduserbal->affiliation_commission;
                $nowtotalbal = $bonusbal + $balancebal + $winningbal + $gstbalancebal + $affbalancebal + $gettdsamount->tds_amount;
                $useramount = DB::table('userbalances')->where('user_id', $uid)->first();

                $updatedAmount['affiliation_commission'] = $useramount->affiliation_commission +  $gettdsamount->tds_amount;
                DB::table('userbalances')->where('user_id', $uid)->update($updatedAmount);
                $getlasttransactionid = DB::table('transactions')->select('id')->orderBy('id', 'DESC')->first();
                if (!empty($getlasttransactionid)) {
                    $tid = $getlasttransactionid->id + 1;
                } else {
                    $tid = 1;
                }

                $transactiondata['type'] = 'TDS amount refund';
                $transactiondata['amount'] = $gettdsamount->tds_amount;
                $transactiondata['total_available_amt'] = $nowtotalbal;
                $transactiondata['transaction_id'] = 'S2W-' . $tid;
                $transactiondata['transaction_by'] = 'PLAYNWIN11';
                $transactiondata['challengeid'] = "";
                $transactiondata['userid'] = $uid;
                $transactiondata['paymentstatus'] = 'confirmed';
                $transactiondata['bal_bonus_amt'] = $bonusbal;
                $transactiondata['bal_win_amt'] = $winningbal;
                $transactiondata['bal_fund_amt'] = $balancebal;
                $transactiondata['bal_gst_bonus_amt'] = $gstbalancebal;
                $transactiondata['bal_affi_amt'] = $affbalancebal + $gettdsamount->tds_amount;

                DB::table('transactions')->insert($transactiondata);
                $tds_array = array(
                    "status" => 2
                );

                DB::table("tds_refer_commission")->where("id", $gettdsamount->id)->update($tds_array);

                // $session_year = date("Y");
                // $session_year = "2023";
                // $registerusers_session = DB::table("registerusers_session")
                //     ->where("user_id", $uid)
                //     ->where("session_year", $session_year)
                //     ->first();
                // if(!empty($registerusers_session)) {
                //     DB::table("registerusers_session")
                //         ->where("id", $registerusers_session->id)
                //         ->update([
                //             "total_withdraw" => ($registerusers_session->total_withdraw-($amount+@$gettdsamount->tds_amount)) < 0 ? 0 : ($registerusers_session->total_withdraw-($amount+@$gettdsamount->tds_amount)),
                //             "total_tds_dedcuted" => ($registerusers_session->total_tds_dedcuted-@$gettdsamount->tds_amount) < 0 ? 0 : ($registerusers_session->total_tds_dedcuted-@$gettdsamount->tds_amount)
                //         ]);
                // }
            }
            //push notifications//
            Helpers::sendnotification($titleget, $details, '', $uid);

            Helpers::logActivity('Transaction Request Rejected', 'Transaction Id - ' . $getlasttransactionid->id);
            //message show//
            Session::flash('flash_notice', 'Withdraw Request Rejected successfully!');
            Helpers::logActivity('Withdraw Request Rejected successfully', 'Transaction Id - ' . $getlasttransactionid->id);
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    } //End Function


    //admin paytm comment request form function

    public function admin_comment_paytm_withdraw(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            if ($input['type'] == 'reject') {
                $this->reject($request);
            }
            if ($input['type'] == 'approve') {

                //$this->approve($request);
                $this->approve_bank_razorpay($request);
            }
            return Redirect::back();
        }
    }
    // end admin paytm comment request form function


    //Withdraw Amount Bank

    public function withdraw_amount_bank(Request $request)
    {
        //Get Post Data
        $withdrawstatus = isset($_GET['filter_withdraw_status']) ? $_GET['filter_withdraw_status'] : '';
        $formData = Input::all();
        if (!empty($formData['search']['value'])) {
            $limit = 1000;
        } else {
            $limit = 500;
        }
        if ($request->isMethod('post')) {
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(DB::table('withdraw as w')
                    ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                    ->leftJoin('bank as b', 'b.userid', '=', 'r.id')
                    ->leftJoin('pancard as pn', 'pn.userid', '=', 'r.id')
                    // ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
                    ->select(
                        'r.*',
                        'b.*',
                        'pn.*',
                        'w.*',
                        'r.id as reg_id',
                        'w.id as withdraw_id',
                        'r.activation_status as reg_status',
                        'w.status as withdraw_status',
                        'w.amount as withdraw_amount',
                        'w.created as withdraw_request',
                        'r.email',
                        'r.team',
                        // ,'jl.id as joinedleauges_id'
                    )
                    ->groupBy('w.id')
                    ->where('type', 'bank')
                    ->where(function ($query) use ($formData) {

                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_amount'])) {
                                $query->where('w.amount', 'like', '%' . $formData['filter_columns']['filter_withdraw_amount'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_request_id'])) {
                                $query->where('w.withdraw_request_id', 'like', '%' . $formData['filter_columns']['filter_withdraw_request_id'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_status'])) {

                                if ($formData['filter_columns']['filter_withdraw_status'] == 0) {
                                    $query->whereIN('w.status', [0]);
                                } else {
                                    $query->where('w.status', '=', $formData['filter_columns']['filter_withdraw_status']);
                                }
                            }
                            if (isset($formData['start_date'])) {
                                $query->whereBetween('w.created', [$formData['start_date'], $formData['end_date']]);
                            }
                        }
                    })
                    ->where('is_instant', 0)
                    // ->where('w.status',0)
                    // ->whereNotIn('w.id' , array(495 , 506 , 518))
                    // ->orderBy("w.id","DESC")
                    //  ->orderByRaw("w.status=-1,w.status ASC, w.id DESC")
                    // ->where(function ($query) use ($withdrawstatus) {
                    //   if (isset($withdrawstatus) && !empty($withdrawstatus)) {
                    //       $query->where('withdraw_status', $withdrawstatus);
                    //     }
                    // })

                    ->orderByRaw("w.id DESC")

                    ->limit($limit)

                    ->get())
                    ->addIndexColumn()
                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->email;
                    })
                    ->addColumn('reg_id', function ($result) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->reg_id;
                    })->addColumn('withdraw_request', function ($result) {
                        return date('d-M-Y', strtotime($result->withdraw_request));
                    })
                    // ->addColumn('withdraw_request',function ($result){
                    //      if($result->approved_date!='0000-00-00 00:00:00'){
                    //      /*return date('d M Y H:i:s a',strtotime($result->approved_date));
                    //        }else{
                    //          return '';
                    //        }*/
                    //        return date('d M Y',strtotime($result->approved_date));
                    //        }else{
                    //          return '';
                    //        }
                    //})
                    ->addColumn('withdraw_amount', function ($result) {
                        return number_format($result->withdraw_amount, 2);
                    })
                    ->addColumn('approve_bank_manual', function ($result) {
                        if ($result->withdraw_status == 0) {
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.approve_bank_manual') . '" method="post">
        ' . csrf_field() . '
        <input type="text" class="form-control" name="comment">
        <input type="hidden" name="id" value="' . $result->withdraw_id . '">
        <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
        <input type="hidden" name="uid" value="' . $result->reg_id . '">
        <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
        <input type="submit" value="Approve" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
        </form>';
                        } else {
                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            $withdraw_manually_status = '';
                            if ($result->withdraw_status == 1) {
                                $withdraw_manually_status .= "<label class='success_icn'>Approved $info</label>";
                            }
                            if ($result->withdraw_status == 2) {
                                $withdraw_manually_status .= "<label class='success_icn'>Rejected $info</label>";
                            }
                            if ($result->withdraw_status == 3) {
                                $withdraw_manually_status .= "<label class='success_icn'>Settled $info</label>";
                            }
                            return $withdraw_manually_status;
                        }
                    })->addColumn('withdraw_type', function ($result) {
                        if ($result->withdrawtype == 0) {
                            return "Winning";
                        } else {
                            return "Affiliation";
                        }
                    })->addColumn('manual_payout_status', function ($result) {
                        if (($result->razorpay_status == 'reversed' || $result->razorpay_status == 'failed') && ($result->withdraw_status == 0)) {
                            //   return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.admin_comment_bank_withdraw').'" method="post">
                            //   '.csrf_field().'
                            //   <input type="text" class="form-control text-comment" name="comment">
                            //   <input type="hidden" name="id" value="'.$result->withdraw_id.'">
                            // <input type="hidden" name="is_manual_withdraw" value="1">
                            //   <input type="hidden" name="uid" value="'.$result->reg_id.'">
                            //   <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
                            //
                            //   <button class="btn btn-info admin-comment success_icn" data-type="settle" style="margin-top:3px;">Settled</button>
                            //   </form>
                            //   ';
                        } elseif (($result->razorpay_status == 'reversed' || $result->razorpay_status == 'failed') && $result->is_manual_withdraw == 1) {
                            return "<label class='success_icn'>Settled</label>";
                        } else {
                            return "";
                        }
                    })
                    ->addColumn('withdraw_status', function ($result) {
                        if ($result->withdraw_status == 0) {
                            /*return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.approve_bank').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Approve" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
        </form>
        <form class="form-horizontal form-label-left" action="'.route($this->model.'.reject').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Reject" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
        </form>';*/
                            if ($result->razorpay_status == 'PENDING') {
                                return "Pending in cashfree";
                            }
                            // if(empty($result->banid) || $result->banid == 'NULL') {
                            //   return '<a href="'.route($this->model.'.addBankBaneId',$result->reg_id).'" style="text-decoration:underline;" class="btn btn-primary">Add Bank Beneficary</a>';
                            // }''
                            if ($result->razorpay_status == 'reversed') {
                                return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
             ' . csrf_field() . '
             <input type="text" class="form-control text-comment" name="comment">
             <input type="hidden" name="id" value="' . $result->withdraw_id . '">
             <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
             <input type="hidden" name="uid" value="' . $result->reg_id . '">
             <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">

             <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
             </form>
             ';
                            } else {
                                if ($result->razorpay_status == 'reversed' || $result->razorpay_status == 'failed') {
                                    return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
                 ' . csrf_field() . '
                 <input type="text" class="form-control text-comment" name="comment">
                 <input type="hidden" name="id" value="' . $result->withdraw_id . '">
                 <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
                 <input type="hidden" name="uid" value="' . $result->reg_id . '">
                 <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">

                 <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
                 </form>
                 ';
                                } else {
                                    return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
                ' . csrf_field() . '
                <input type="text" class="form-control text-comment" name="comment">
                <input type="hidden" name="id" value="' . $result->withdraw_id . '">
                <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
                <input type="hidden" name="uid" value="' . $result->reg_id . '">
                <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
                <button class="btn btn-info admin-comment" data-type="approve" style="color:#000;margin-top:3px;">Approve</button>
                <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
                </form>
                ';
                                }
                            }
                        } else {
                            $withdraw_status = '';
                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            if ($result->withdraw_status == 1) {
                                $withdraw_status .= "<label class='success_icn'>Approved $info</label>";
                            }
                            if ($result->withdraw_status == 2) {
                                $withdraw_status .= "<label class='success_icn'>Rejected $info</label>";
                            }
                            if ($result->withdraw_status == 3) {
                                $withdraw_status .= "<label class='success_icn'>Settled $info</label>";
                            }
                            return $withdraw_status;
                        }
                    })->addColumn('action', function ($result) {
                        //Show Joined Leauges
                        if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                            $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leagues" class="btn btn-primary mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                        } else {
                            $joinedleauges_link = '';
                        } //End Function

                        return '<a href="' . route($this->model . '.view_user', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View" ></i></a>'
                            . '<a href="' . route($this->model . '.bank_old_withdraw', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="Withdrawal History" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-history"></i></a><a dataid="' . @$result->reg_id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->reg_id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->reg_id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a><a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->reg_id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Transaction History</a>'
                            . $joinedleauges_link;
                    })->addColumn('order_id', function ($result) {
                        // return 'TRANS'.$result->withdraw_id;
                        if ($result->transfer_id != null)
                            return $result->transfer_id;
                        else
                            return 'TRANS' . $result->withdraw_id;
                    })
                    ->addColumn('gateway_id', function ($result) {
                        return $result->razorpay_pout_id;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.withdraw_amount_bank");
    } //End Function
    public function download_all_transaction(Request $request)
    {
        // dd($request);
        $todate = date('Y-m-d');
        $is_instant = 0;
        if (!empty($request->is_instant)) {
            $is_instant = 1;
        }
        $start_date = !empty($request->start_date) ? $request->start_date : $todate . " 00:00:00";
        $end_date = !empty($request->end_date) ? $request->end_date : $todate . " 23:59:59";
        $query = DB::table('withdraw as w')
            ->join('registerusers as r', 'r.id', '=', 'w.user_id')
            ->leftJoin('bank as b', 'b.userid', '=', 'r.id')
            ->leftJoin('pancard as pn', 'pn.userid', '=', 'r.id')
            ->select(
                'r.*',
                'b.*',
                'pn.*',
                'w.*',
                'r.id as reg_id',
                'w.id as withdraw_id',
                'r.activation_status as reg_status',
                'w.status as withdraw_status',
                'w.amount as withdraw_amount',
                'w.created as withdraw_request'
            )
            ->groupBy('w.id')
            ->where('type', 'bank')
            ->where('is_instant', $is_instant)
            ->orderByRaw("w.status=-1,w.status ASC, w.id DESC")
            ->whereBetween('w.created', [$start_date, $end_date])
            ->get();

        $output1 = "";
        $output1 .= '"S No.","Acc number","Mobile Number","Withdraw Request ID","Bank IFSC Code","Order ID","UserName","Withdraw Amount","Withdrawl Type","Status","Razorpay Transaction ID","Comment","Approved/Reject Date"';
        $output1 .= "\n";
        $i = 1;
        if (!empty($query)) {
            foreach ($query as $get) {
                if ($get->transfer_id != null) {
                    $orderid = $get->transfer_id;
                } else {
                    $orderid = 'TRANS' . $get->withdraw_id;
                }
                if ($get->withdraw_status == 0) {
                    $statusWithdrw = "Pending";
                }
                if ($get->withdraw_status == 2) {
                    $statusWithdrw = "Rejected";
                }
                if ($get->withdraw_status == 1) {
                    $statusWithdrw = "Approved";
                }
                if ($get->withdrawtype == 0) {
                    $withdrawtype = "Winning";
                } else {
                    $withdrawtype = "Affiliation";
                }
                $output1 .= '"' . $i++ . '",';
                $output1 .= '"' . $get->accno . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->withdraw_request_id . '",';
                $output1 .= '"' . $get->ifsc . '",';
                // $output1 .='"'.$get->bankname.'",';
                // $output1 .='"'.$get->bankbranch.'",';
                $output1 .= '"' . $orderid . '",';
                $output1 .= '"' . $get->username . '",';
                // $output1 .='"'.$get->email.'",';
                $output1 .= '"' . $get->withdraw_amount . '",';
                $output1 .= '"' . $withdrawtype . '",';
                $output1 .= '"' . $statusWithdrw . '",';
                $output1 .= '"' . $get->razorpay_pout_id . '",';
                $output1 .= '"' . $get->comment . '",';
                $output1 .= '"' . $get->approved_date . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "bank_withdraw-" . $start_date . " TO " . $end_date . ".csv";
        if ($is_instant == 1) {
            $filename =  "instant_withdraw-" . $start_date . " TO " . $end_date . ".csv";
        }
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function withdraw_amount_bank_old()
    {
        //Get Post Data
        $withdrawstatus = isset($_GET['filter_withdraw_status']) ? $_GET['filter_withdraw_status'] : '';
        $formData = Input::all();
        if (!empty($formData['search']['value'])) {
            $limit = 1000;
        } else {
            $limit = 500;
        }
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('withdraw as w')
                ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                ->leftJoin('bank as b', 'b.userid', '=', 'r.id')
                ->leftJoin('pancard as pn', 'pn.userid', '=', 'r.id')
                // ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
                ->select(
                    'r.*',
                    'b.*',
                    'pn.*',
                    'w.*',
                    'r.id as reg_id',
                    'w.id as withdraw_id',
                    'r.activation_status as reg_status',
                    'w.status as withdraw_status',
                    'w.amount as withdraw_amount',
                    'w.created as withdraw_request',
                    'r.email',
                    'r.team',
                    // ,'jl.id as joinedleauges_id'
                )
                ->groupBy('w.id')
                ->where('type', 'bank')
                ->where('is_instant', 0)
                // ->where('w.status',0)
                // ->whereNotIn('w.id' , array(495 , 506 , 518))
                // ->orderBy("w.id","DESC")
                //  ->orderByRaw("w.status=-1,w.status ASC, w.id DESC")
                // ->where(function ($query) use ($withdrawstatus) {
                //   if (isset($withdrawstatus) && !empty($withdrawstatus)) {
                //       $query->where('withdraw_status', $withdrawstatus);
                //     }
                // })

                ->orderByRaw("w.id DESC")

                ->limit($limit)

                ->get())
                ->addIndexColumn()
                ->addColumn('email', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->email;
                })
                ->addColumn('reg_id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->reg_id;
                })->addColumn('withdraw_request', function ($result) {
                    return date('d-M-Y', strtotime($result->withdraw_request));
                })
                // ->addColumn('withdraw_request',function ($result){
                //      if($result->approved_date!='0000-00-00 00:00:00'){
                //      /*return date('d M Y H:i:s a',strtotime($result->approved_date));
                //        }else{
                //          return '';
                //        }*/
                //        return date('d M Y',strtotime($result->approved_date));
                //        }else{
                //          return '';
                //        }
                //})
                ->addColumn('withdraw_amount', function ($result) {
                    return number_format($result->withdraw_amount, 2);
                })
                ->addColumn('approve_bank_manual', function ($result) {
                    if ($result->withdraw_status == 0) {
                        return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.approve_bank_manual') . '" method="post">
        ' . csrf_field() . '
        <input type="text" class="form-control" name="comment">
        <input type="hidden" name="id" value="' . $result->withdraw_id . '">
        <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
        <input type="hidden" name="uid" value="' . $result->reg_id . '">
        <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
        <input type="submit" value="Approve" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
        </form>';
                    } else {
                        $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                        $withdraw_manually_status = '';
                        if ($result->withdraw_status == 1) {
                            $withdraw_manually_status .= "<label class='success_icn'>Approved $info</label>";
                        }
                        if ($result->withdraw_status == 2) {
                            $withdraw_manually_status .= "<label class='success_icn'>Rejected $info</label>";
                        }
                        if ($result->withdraw_status == 3) {
                            $withdraw_manually_status .= "<label class='success_icn'>Settled $info</label>";
                        }
                        return $withdraw_manually_status;
                    }
                })->addColumn('withdraw_type', function ($result) {
                    if ($result->withdrawtype == 0) {
                        return "Winning";
                    } else {
                        return "Affiliation";
                    }
                })->addColumn('manual_payout_status', function ($result) {
                    if (($result->razorpay_status == 'reversed' || $result->razorpay_status == 'failed') && ($result->withdraw_status == 0)) {
                        return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
                      ' . csrf_field() . '
                      <input type="text" class="form-control text-comment" name="comment">
                      <input type="hidden" name="id" value="' . $result->withdraw_id . '">
                    <input type="hidden" name="is_manual_withdraw" value="1">
                      <input type="hidden" name="uid" value="' . $result->reg_id . '">
                      <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">

                      <button class="btn btn-info admin-comment success_icn" data-type="settle" style="margin-top:3px;">Settled</button>
                      </form>
                      ';
                    } elseif (($result->razorpay_status == 'reversed' || $result->razorpay_status == 'failed') && $result->is_manual_withdraw == 1) {
                        return "<label class='success_icn'>Settled</label>";
                    } else {
                        return "";
                    }
                })
                ->addColumn('withdraw_status', function ($result) {
                    if ($result->withdraw_status == 0) {
                        /*return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.approve_bank').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Approve" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
        </form>
        <form class="form-horizontal form-label-left" action="'.route($this->model.'.reject').'" method="post">
        '.csrf_field().'
        <input type="text" class="form-control" name="comment" required>
        <input type="hidden" name="id" value="'.$result->withdraw_id.'">
        <input type="hidden" name="uid" value="'.$result->reg_id.'">
        <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
        <input type="submit" value="Reject" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
        </form>';*/
                        if ($result->razorpay_status == 'PENDING') {
                            return "Pending in cashfree";
                        }
                        // if(empty($result->banid) || $result->banid == 'NULL') {
                        //   return '<a href="'.route($this->model.'.addBankBaneId',$result->reg_id).'" style="text-decoration:underline;" class="btn btn-primary">Add Bank Beneficary</a>';
                        // }''
                        if ($result->razorpay_status == 'reversed') {
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
             ' . csrf_field() . '
             <input type="text" class="form-control text-comment" name="comment">
             <input type="hidden" name="id" value="' . $result->withdraw_id . '">
             <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
             <input type="hidden" name="uid" value="' . $result->reg_id . '">
             <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">

             <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
             </form>
             ';
                        } else {
                            if ($result->razorpay_status == 'reversed' || $result->razorpay_status == 'failed') {
                                return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
                 ' . csrf_field() . '
                 <input type="text" class="form-control text-comment" name="comment">
                 <input type="hidden" name="id" value="' . $result->withdraw_id . '">
                 <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
                 <input type="hidden" name="uid" value="' . $result->reg_id . '">
                 <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">

                 <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
                 </form>
                 ';
                            } else {
                                return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
                ' . csrf_field() . '
                <input type="text" class="form-control text-comment" name="comment">
                <input type="hidden" name="id" value="' . $result->withdraw_id . '">
                <input type="hidden" id="Withdrowtype" name="Withdrowtype" value="bank">
                <input type="hidden" name="uid" value="' . $result->reg_id . '">
                <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
                <button class="btn btn-info admin-comment" data-type="approve" style="color:#000;margin-top:3px;">Approve</button>
                <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
                </form>
                ';
                            }
                        }
                    } else {
                        $withdraw_status = '';
                        $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                        if ($result->withdraw_status == 1) {
                            $withdraw_status .= "<label class='success_icn'>Approved $info</label>";
                        }
                        if ($result->withdraw_status == 2) {
                            $withdraw_status .= "<label class='success_icn'>Rejected $info</label>";
                        }
                        if ($result->withdraw_status == 3) {
                            $withdraw_status .= "<label class='success_icn'>Settled $info</label>";
                        }
                        return $withdraw_status;
                    }
                })->addColumn('action', function ($result) {
                    //Show Joined Leauges
                    if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                        $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leagues" class="btn btn-primary mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                    } else {
                        $joinedleauges_link = '';
                    } //End Function

                    return '<a href="' . route($this->model . '.view_user', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View" ></i></a>'
                        . '<a href="' . route($this->model . '.bank_old_withdraw', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="Withdrawal History" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-history"></i></a><a dataid="' . @$result->reg_id . '" href="' . route($this->model . '.users_balance_history', base64_encode(serialize(@$result->reg_id))) . '" data-toggle="tooltip" title="Transactions" id="' . @$result->reg_id . '" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Wallet History</a><a href="' . route($this->model . '.transactions', base64_encode(serialize(@$result->reg_id))) . '" data-toggle="tooltip" title="Transactions" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions">Transaction History</a>'
                        . $joinedleauges_link;
                })->addColumn('order_id', function ($result) {
                    // return 'TRANS'.$result->withdraw_id;
                    if ($result->transfer_id != null)
                        return $result->transfer_id;
                    else
                        return 'TRANS' . $result->withdraw_id;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.withdraw_amount_bank");
    } //End Function


    //Withdraw Amount Bank
    public function withdraw_amount_bank_old_2021_11_30(Request $req)
    {
        if ($req->isMethod('post')) {
            //Get Post Data
            $formData = Input::all();

            //dd($formData['req_id_update']);
            if (isset($formData) && !empty($formData)) {
                ini_set('memory_limit', '-1');

                if (isset($formData['req_id_update'])) {

                    $res = DB::table('withdraw as w')->where('withdraw_request_id', '=', $formData['req_id_update']['withdraw_request_id'])->first();

                    if (!is_null($res)) {
                        // Session::flash('flash_notice', 'Withdraw Request Id Is Already Exist!');
                        // Session::flash('alert-class', 'alert-warning');
                        // return Redirect::back();
                    } else {
                        DB::table('withdraw as w')->where('id', '=', $formData['req_id_update']['id'])->update(['withdraw_request_id' => $formData['req_id_update']['withdraw_request_id']]);
                        // Session::flash('flash_notice', 'Withdraw Request Id Updated!');
                        // Session::flash('alert-class', 'alert-success');
                        // return Redirect::back();
                    }
                }
                //dd('y');
                return Datatables::of(DB::table('withdraw as w')
                    ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                    ->leftJoin('bank as b', 'b.userid', '=', 'r.id')
                    ->leftJoin('pancard as pn', 'pn.userid', '=', 'r.id')
                    // ->leftJoin('joinedleauges as jl','jl.userid','=','r.id')
                    ->select(
                        'r.*',
                        'b.*',
                        'pn.*',
                        'w.*',
                        'r.id as reg_id',
                        'w.id as withdraw_id',
                        'r.activation_status as reg_status',
                        'w.status as withdraw_status',
                        'w.amount as withdraw_amount',
                        'w.created as withdraw_request'
                        // ,'jl.id as joinedleauges_id'
                    )
                    ->where('w.type', 'bank')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_bankname'])) {
                                $query->where('b.bankname', 'like', '%' . $formData['filter_columns']['filter_bankname'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_bankbranch'])) {
                                $query->where('b.bankbranch', 'like', '%' . $formData['filter_columns']['filter_bankbranch'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_amount'])) {
                                $query->where('w.amount', 'like', '%' . $formData['filter_columns']['filter_withdraw_amount'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw_request_id'])) {
                                $query->where('w.withdraw_request_id', 'like', '%' . $formData['filter_columns']['filter_withdraw_request_id'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_withdraw'])) {
                                $query->where('w.status', $formData['filter_columns']['filter_withdraw']);
                            }
                        } else {
                            $query->whereIn('w.status', ['0', '1', '-1']);

                            // $query->whereIn('w.status',['1']);
                        }
                    })
                    ->orderBy(DB::raw(
                        "CASE
        WHEN w.status = -1 THEN 3
        WHEN w.status = 1 THEN 2
        WHEN w.status = 0 THEN 1
        END"
                    ))
                    ->groupBy('w.id')
                    ->orderBy('w.status', 'ASC')
                    ->limit('1000')
                    // ->orderBy('w.created','DESC')
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('withdraw_request_id', function ($result) {

                        return '<form name="form-' . $result->withdraw_id . '">
          <input type="text" id="req_id' . $result->withdraw_id . '" class="form-control" name="withdraw_request_id" value="' . $result->withdraw_request_id . '">
          <input type="hidden" id="w_id' . $result->withdraw_id . '" name="id" value="' . $result->withdraw_id . '">
          <input type="button" onclick="getFormData(' . $result->withdraw_id . ')" id="req_id_update' . $result->withdraw_id . '" value="Update" maxlength="20" class="btn btn-info mr-1 mt-1">
          </form>';
                    })
                    ->addColumn('reg_id', function ($result) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->reg_id))) . '" style="text-decoration:underline;">' . $result->reg_id;
                    })->addColumn('withdraw_request', function ($result) {
                        return date('d-M-Y', strtotime($result->withdraw_request));
                    })
                    /*->addColumn('withdraw_request',function ($result){
        if($result->approved_date!='0000-00-00 00:00:00'){
        return date('d M Y H:i:s a',strtotime($result->approved_date));
      }else{
      return '';
    }
    return date('d M Y',strtotime($result->approved_date));
  }else{
  return '';
}
})*/
                    ->addColumn('approve_bank_manual', function ($result) {
                        if ($result->withdraw_status == 0) {
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.approve_bank_manual') . '" method="post">
    ' . csrf_field() . '
    <input type="text" class="form-control" name="comment">
    <input type="hidden" name="id" value="' . $result->withdraw_id . '">
    <input type="hidden" name="uid" value="' . $result->reg_id . '">
    <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
    <input type="submit" value="Approve" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
    </form>';
                        } else {
                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            $withdraw_manually_status = '';
                            if ($result->withdraw_status == 1) {
                                $withdraw_manually_status .= "<label class='success_icn'>Approved $info</label>";
                            }
                            if ($result->withdraw_status == -1) {
                                $withdraw_manually_status .= "<label class='success_icn'>Rejected $info</label>";
                            }
                            return $withdraw_manually_status;
                        }
                    })->addColumn('withdraw_status', function ($result) {
                        if ($result->withdraw_status == 0) {
                            /*return '<form class="form-horizontal form-label-left" action="'.route($this->model.'.approve_bank').'" method="post">
    '.csrf_field().'
    <input type="text" class="form-control" name="comment" required>
    <input type="hidden" name="id" value="'.$result->withdraw_id.'">
    <input type="hidden" name="uid" value="'.$result->reg_id.'">
    <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
    <input type="submit" value="Approve" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
    </form>
    <form class="form-horizontal form-label-left" action="'.route($this->model.'.reject').'" method="post">
    '.csrf_field().'
    <input type="text" class="form-control" name="comment" required>
    <input type="hidden" name="id" value="'.$result->withdraw_id.'">
    <input type="hidden" name="uid" value="'.$result->reg_id.'">
    <input type="hidden" name="amount" value="'.$result->withdraw_amount.'">
    <input type="submit" value="Reject" maxlength="20" class="btn tbn-info" style="color:#000;margin-top:3px;">
    </form>';*/
                            return '<form class="form-horizontal form-label-left" action="' . route($this->model . '.admin_comment_bank_withdraw') . '" method="post">
    ' . csrf_field() . '
    <input type="text" class="form-control text-comment" name="comment">
    <input type="hidden" name="id" value="' . $result->withdraw_id . '">
    <input type="hidden" name="uid" value="' . $result->reg_id . '">
    <input type="hidden" name="amount" value="' . $result->withdraw_amount . '">
    <button class="btn btn-info admin-comment" data-type="approve" style="color:#000;margin-top:3px;">Approve</button>
    <button class="btn btn-info admin-comment" data-type="reject" style="color:#000;margin-top:3px;">Reject</button>
    </form>
    ';
                        } else {
                            $withdraw_status = '';
                            $info = isset($result->comment) ? "<span toggle='tooltip' data-title='" . ucwords($result->comment) . "'><i class='fa fa-info-circle info_icn ml-1' aria-hidden='true'></i></span>" : " ";

                            if ($result->withdraw_status == 1) {
                                $withdraw_status .= "<label class='success_icn'>Approved $info</label>";
                            }
                            if ($result->withdraw_status == -1) {
                                $withdraw_status .= "<label class='success_icn'>Rejected $info</label>";
                            }
                            return $withdraw_status;
                        }
                    })
                    ->addColumn('approved_date', function ($result) {
                        if ($result->status == 1) {
                            return date('d M Y', strtotime($result->modified));
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('action', function ($result) {
                        //Show Joined Leauges
                        if (isset($result->joinedleauges_id) && !empty($result->joinedleauges_id)) {
                            $joinedleauges_link = '<a href="' . route($this->model . '.join_leauges', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Joined Leagues" class="btn btn-primary mr-1 mt-1"><i class="fa fa-trophy"></i></a>';
                        } else {
                            $joinedleauges_link = '';
                        } //End Function

                        return '<a href="' . route($this->model . '.view_user', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="View" class="btn btn-primary mr-1 mt-1"><i class="fa fa-eye" aria-hidden="true" data-toggle="tooltip" data-original-title="View" ></i></a>'
                            . '<a href="' . route($this->model . '.bank_old_withdraw', base64_encode(serialize($result->reg_id))) . '" data-toggle="tooltip" title="Withdrawal History" class="btn btn-primary mr-1 mt-1" data-original-title="User Transactions"><i class="fa fa-history"></i></a>'
                            . $joinedleauges_link;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.withdraw_amount_bank");
    } //End Function

    //bank_old_withdraw
    public function bank_old_withdraw($id = null)
    {

        //Get ID Unserialize
        $id = unserialize(base64_decode($id));
        //Get Post Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('withdraw')->where('type', 'bank')->where('user_id', $id)->get())
                ->addIndexColumn()
                ->addColumn('approved_date', function ($result) {
                    if (!empty($result->approved_date)) {
                        return date('d-M-Y', strtotime($result->approved_date));
                    } else {
                        return '--';
                    }
                })->addColumn('status', function ($result) {
                    $status = '';
                    if ($result->status == '1') {
                        return '<div class="btn btn-success"><td style="color:red;" class="btn btn-success">Approve</td></div>';
                    } elseif ($result->status == '-1') {
                        return '<div class="btn btn-danger"><td style="color:red;">Reject</td><div>';
                    } elseif ($result->status == '0') {
                        return '<div class="btn btn-primary"><td style="color:red;" class="btn btn-primary">  Pending</td></div>';
                    } elseif ($result->status == '18') {
                        return '<div class="btn btn-primary"><td style="color:red;" class="btn btn-primary">  Pending</td></div>';
                    }
                })
                ->escapeColumns([])
                ->make(true);
        } //end
        //View
        return view("admin.$this->model.bank_old_withdraw", compact('id'));
    }

    //XXXXXXXXXXXXXXXXXX Cashfree Instant Cron XXXXXXXXXXXXXXXXX //

    public function cashfree_withdraw_instant_cron()
    {
        include(app_path() . '/cashfree/cfpayout.inc.php');
        $clientId = CF_CLIENT_ID;
        $clientSecret = CF_CLIENT_SECRET;
        $stage = "PROD";
        $deductionUsers = DB::table('deduction_users')->pluck('user_id');
        $find_withdraw = DB::table('withdraw')
            ->where('status', 9)
            ->where('is_instant', 1)
            // ->whereNotIn('user_id' , $deductionUsers)
            ->where('type', 'bank')->get();
        // echo"<pre>";  print_r($find_withdraw); exit;
        foreach ($find_withdraw as $withdraw) {
            // var_dump($withdraw->user_id == '170158');exit;
            // if($withdraw->user_id == '170158'){
            //   var_dump("as");exit;
            // }
            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $withdraw->id)->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.mobile', 'registerusers.team', 'withdraw_request_id')->first();

            $bank_detail = DB::table('bank')->where('userid', $withdraw->user_id)->first();
            // echo "<pre>"; print_r($bank_detail); exit;
            $authParams["clientId"] = $clientId;
            $authParams["clientSecret"] = $clientSecret;
            $authParams["stage"] = $stage;

            try {
                $payout = new CfPayout($authParams);
                // print_r($payout); exit;
            } catch (Exception $e) {
                echo 'error';
                exit;
            }

            $beneficiary = [];
            //echo $withdraw->user_id;
            $user = Registerusers::find($withdraw->user_id);
            if (empty($user)) {
                DB::table('withdraw')->where('user_id', $withdraw->user_id)->where('id', $withdraw->id)
                    ->update([
                        "cashfree_message" => "User Not Found !",
                        "status" => 0
                    ]);
                continue;
            }
            $beneficiary["beneId"] = $user->id . '' . $bank_detail->accno;
            $beneficiary["name"] = $user->username == '' ? "vision user" : $user->username;
            $beneficiary["email"] = !empty($user->email) ? $user->email : "vision11official@gmail.com";
            $beneficiary["phone"] = !empty($user->mobile) ? $user->mobile : '8882742743';
            $beneficiary["bankAccount"] = $bank_detail->accno;
            $beneficiary["ifsc"] = $bank_detail->ifsc;
            $beneficiary["address1"] = "India";
            $beneficiary["city"] = "";
            $beneficiary["state"] = "";
            $beneficiary["pincode"] = "";

            // var_dump($beneficiary);exit;
            if ($user->banid == '') {
                $response = $payout->addBeneficiary($beneficiary);
                // var_dump($response);exit;
                if ($response['status'] == 'ERROR' && $response['subCode'] == 422) {
                    var_dump($response);
                    $uperror['withdraw_error_text'] = $response['message'];
                    $uperror['status'] = 0;

                    DB::table('withdraw')->where('user_id', $withdraw->user_id)->where('id', $withdraw->id)->update($uperror);
                    // var_dump("er");exit;
                    echo "Add Beneficary Error<br>";
                    continue;
                }
                DB::table('registerusers')->where('id', $withdraw->user_id)->update(array('banid' => $beneficiary["beneId"]));
            } else {
                $beneficiary["beneId"] = $user->banid;
            }
            $responseBalcheck = $payout->getBalance();

            if ($responseBalcheck['available'] > $withdraw->amount) {

                $tid = str_replace('-', '_', $withdraw->withdraw_request_id);
                // $order_id = 'Trans_'.$tid;
                $order_id = 'Trans' . $withdraw->id;

                $transfer_id = $order_id;
                $transfer = [];
                $transfer["beneId"] = $beneficiary["beneId"];


                $transfer["amount"] = number_format(($withdraw->amount), 2, ".", "");
                $transfer["transferId"] = $transfer_id;
                $transfer["remarks"] = "Transfer request from Payout kit";
                // var_dump($transfer);exit;
                $response_pt = $payout->requestTransfer($transfer);
                // Storage::append('croncheck.txt', 'cashfreecheck-'.Carbon::now().$response_pt);
                $upstatus = array();
                if ($response_pt["status"] == "SUCCESS") {
                    $upstatus['status'] = 1;

                    $upstatus['reference_id'] = $response_pt["data"]["referenceId"];
                    $upstatus['utr_number'] = $response_pt["data"]["utr"];
                    $upstatus['acknowledged'] = $response_pt["data"]["acknowledged"];
                    $upstatus['transfer_id'] = $transfer_id;
                    // $upstatus['beneId'] = $beneficiary["beneId"];
                    $upstatus['cashfree_status'] = $response_pt["status"];
                    // $upstatus['transfer_from'] = 2;

                } elseif ($response_pt["status"] == "PENDING") {
                    $upstatus['status'] = 13;
                    $upstatus['transfer_id'] = $transfer_id;
                    $upstatus['reference_id'] = $response_pt["data"]["referenceId"];
                    $upstatus['utr_number'] = $response_pt["data"]["utr"];
                    // $upstatus['beneId'] = $beneficiary["beneId"];
                    $upstatus['comment'] = "Transfer request is in pending status.";
                    $upstatus['cashfree_status'] = $response_pt["status"];
                    // $upstatus['transfer_from'] = 2;
                    // $upstatus['withdraw_error_text'] = $response_pt['message'];
                } else {
                    // var_dump($response_pt);exit;
                    $upstatus['status'] = 0;
                    $upstatus['transfer_id'] = $transfer_id;
                    $upstatus['reference_id'] = @$response_pt["data"]["referenceId"];
                    $upstatus['utr_number'] = @$response_pt["data"]["utr"];
                    // $upstatus['beneId'] = $beneficiary["beneId"];
                    $upstatus['comment'] = "Transfer request is failed.";
                    $upstatus['cashfree_status'] = $response_pt["status"];
                    // $upstatus['transfer_from'] = 2;

                    // $upstatus['withdraw_error_text'] = $response_pt['message'];
                }
                DB::table('withdraw')->where('user_id', $withdraw->user_id)->where('id', $withdraw->id)->update($upstatus);
                // var_dump($response_pt);
                unset($upstatus);
            }
        }
    }

    public function check_cashfree_withdraw_instant()
    {

        date_default_timezone_set("Asia/Kolkata");
        $preDate = Carbon::now()->subDays(10);

        // ->where('transfer_from', 2)
        $titles = DB::table('withdraw')
            // ->whereIn('status',[0,1])
            ->where('is_instant', 1)
            ->whereIn('status', [0, 13])
            ->where('acknowledged', 0)
            ->where('type', 'bank')
            // ->where('transfer_from',2)
            ->whereNotNull('transfer_id')
            // ->where('id',116473)
            // ->where('acknowledged',0)
            // ->limit(50)
            ->orderBy('modified', 'ASC')
            ->where('created', '>=', $preDate)
            // ->limit(50)
            ->get();
        $titles_count = DB::table('withdraw')
            // ->whereIn('status',[0,1])
            ->where('is_instant', 1)
            ->whereIn('status', [0, 13])
            // ->where('acknowledged',0)
            ->where('type', 'bank')
            // ->where('transfer_from',2)
            ->whereNotNull('transfer_id')
            // ->where('id',116473)
            // ->where('acknowledged',0)
            // ->limit(50)
            ->orderBy('modified', 'ASC')
            ->where('created', '>=', $preDate)
            // ->limit(50)
            ->count();
        // var_dump($titles_count);
        // echo "<pre>";print_r($titles);die();

        // var_dump($titles);exit;


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://payout-api.cashfree.com/payout/v1/authorize");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        $headers = array();
        // $headers[] = "Cache-Control: no-cache";
        $headers[] = "Content-Type: application/json";
        $headers[] = "X-Client-Id: " . CF_CLIENT_ID;
        $headers[] = "X-Client-Secret: " . CF_CLIENT_SECRET;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array()));
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // $returnData = curl_exec($ch);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        // echo json_encode($info); exit;
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        curl_close($ch);

        // curl_close ($ch);
        $result = json_decode($result);
        // echo "<pre>";print_r($result);die();
        $result_data = @$result->data;
        // @$result_data->token;
        $token = @$result_data->token;

        foreach ($titles as $output) {


            // var_dump($token);exit;
            if ($token) {
                if ($token) {
                    // $tid = str_replace('-','_',$output->withdraw_request_id);
                    //     $order_id = 'Trans_'.$tid;
                    $order_id = $output->transfer_id;
                    $url = "https://payout-api.cashfree.com/payout/v1/getTransferStatus?transferId=$order_id";
                    // var_dump($url);exit;
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $headers = array();
                    $headers[] = "Authorization: Bearer " . $token;
                    $headers[] = "Cache-Control: no-cache";
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    $result = curl_exec($ch);
                    $result = json_decode($result);
                    var_dump("result");
                    var_dump($result);
                    // exit;
                    if ($result->status == 'ERROR') {
                        continue;
                    }
                    // print_r($result);exit;
                    $result_data = @$result->data;
                    // print_r($result_data);

                    $finaloutput = ((array)$result_data->{'transfer'});
                    // print_r($finaloutput);

                    if ($finaloutput['status'] == 'SUCCESS') {
                        if ($finaloutput['acknowledged'] == 1 || $output->status == 0) {
                            $update_userbalance =   DB::table('withdraw')
                                ->where('id', $output->id)
                                ->where('transfer_id', $output->transfer_id)
                                ->update(['status' => 1, 'cashfree_status' => $finaloutput['status'], 'comment' => 'SUCCESS - Add by ADMIN', 'utr_number' => $finaloutput['utr'], 'reference_id' => $finaloutput['referenceId'], 'acknowledged' => $finaloutput['acknowledged']]);
                        }
                    } elseif ($finaloutput['status'] == 'REVERSED') {
                        $update_userbalance =   DB::table('withdraw')
                            ->where('id', $output->id)
                            ->where('transfer_id', $output->transfer_id)
                            ->update(['status' => 0, 'cashfree_status' => $finaloutput['status'], 'comment' => 'REVERSED -' . @$finaloutput["message"], 'reference_id' => $finaloutput['referenceId'], 'modified' => Carbon::now()]);

                        // $user_id = $output->user_id;
                        // $balances = DB::table('userbalances')->where('user_id',$user_id)->first();
                        // $dataq['winning'] = $balances->winning+$output->amount;
                        // DB::table('userbalances')->where('user_id', $user_id)->update($dataq);

                        // $transaction['userid'] = $user_id;
                        // $transaction['type'] = "Withdraw Request Rejected";
                        // $transaction['transaction_id'] = $output->transfer_id."-".$output->id;
                        // $transaction['transaction_by'] = "Vision11-WAR-".$output->transfer_id;
                        // $transaction['amount'] = $output->amount;
                        // $transaction['paymentstatus'] = "confirmed";
                        // $transaction['win_amt'] = $output->amount;
                        // $transaction['bal_bonus_amt'] = $balances->bonus;
                        // $transaction['bal_win_amt'] = $dataq['winning'];
                        // $transaction['bal_fund_amt'] = $balances->balance;
                        // $transaction['total_available_amt'] = $balances->bonus+$dataq['winning']+$balances->balance;
                        // DB::table('transactions')->insert($transaction);
                    } elseif ($finaloutput['status'] == 'FAILED') {
                        $update_userbalance =   DB::table('withdraw')
                            ->where('id', $output->id)
                            ->where('transfer_id', $output->transfer_id)
                            ->update(['status' => 0, 'cashfree_status' => $finaloutput['status'], 'comment' => 'FAILED -' . @$finaloutput["message"], 'reference_id' => $finaloutput['referenceId'], 'modified' => Carbon::now()]);

                        // $user_id = $output->user_id;
                        // $balances = DB::table('userbalances')->where('user_id',$user_id)->first();
                        // $dataq['winning'] = $balances->winning+$output->amount;
                        // DB::table('userbalances')->where('user_id', $user_id)->update($dataq);

                        // $transaction['userid'] = $user_id;
                        // $transaction['type'] = "Withdraw Request Rejected";
                        // $transaction['transaction_id'] = $output->transfer_id."-".$output->id;
                        // $transaction['transaction_by'] = "Vision11-WAR-".$output->transfer_id;
                        // $transaction['amount'] = $output->amount;
                        // $transaction['paymentstatus'] = "confirmed";
                        // $transaction['win_amt'] = $output->amount;
                        // $transaction['bal_bonus_amt'] = $balances->bonus;
                        // $transaction['bal_win_amt'] = $dataq['winning'];
                        // $transaction['bal_fund_amt'] = $balances->balance;
                        // $transaction['total_available_amt'] = $balances->bonus+$dataq['winning']+$balances->balance;
                        // DB::table('transactions')->insert($transaction);

                    }
                }
            }
        }

        RegisterusersController::check_cashfree_withdraw_instant_reversed();
    }

    public function check_cashfree_withdraw_instant_reversed()
    {
        date_default_timezone_set("Asia/Kolkata");
        $preDate = Carbon::now()->subDays(20);

        // ->where('transfer_from', 2)
        $titles = DB::table('withdraw')
            // ->whereIn('status',[0,1])
            ->where('is_instant', 1)
            ->whereIn('status', [1])
            ->where('acknowledged', 0)
            ->where('type', 'bank')
            // ->where('transfer_from',2)
            // ->where('id',119964)
            // ->where('acknowledged',0)
            // ->limit(50)
            ->where('created', '>=', $preDate)
            ->get();

        // var_dump($titles);exit;
        foreach ($titles as $output) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://payout-api.cashfree.com/payout/v1/authorize");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            $headers = array();
            $headers[] = "Cache-Control: no-cache";
            $headers[] = "Content-Type: application/x-www-form-urlencoded";
            $headers[] = "X-Client-Id: " . CF_CLIENT_ID;
            $headers[] = "X-Client-Secret: " . CF_CLIENT_SECRET;
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $result = curl_exec($ch);
            $info = curl_getinfo($ch);

            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }

            curl_close($ch);
            $result = json_decode($result);
            // var_dump($result);exit;

            $result_data = @$result->data;
            @$result_data->token;
            $token = @$result_data->token;
            // var_dump($token);exit;
            if ($token) {
                if ($token) {
                    // $tid = str_replace('-','_',$output->withdraw_request_id);
                    //     $order_id = 'Trans_'.$tid;
                    $order_id = $output->transfer_id;
                    $url = "https://payout-api.cashfree.com/payout/v1/getTransferStatus?transferId=$order_id";
                    // var_dump($url);exit;
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $headers = array();
                    $headers[] = "Authorization: Bearer " . $token;
                    $headers[] = "Cache-Control: no-cache";
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    $result = curl_exec($ch);
                    $result = json_decode($result);
                    // var_dump("result");
                    // var_dump($result);
                    // exit;
                    if ($result->status == 'ERROR') {
                        continue;
                    }
                    // print_r($result);exit;
                    $result_data = @$result->data;
                    // print_r($result_data);

                    $finaloutput = ((array)$result_data->{'transfer'});
                    // print_r($finaloutput);

                    if ($finaloutput['status'] == 'SUCCESS') {
                        if ($finaloutput['acknowledged'] == 1 || $output->status == 0) {
                            $update_userbalance =   DB::table('withdraw')
                                ->where('id', $output->id)
                                ->where('transfer_id', $output->transfer_id)
                                ->update(['status' => 1, 'cashfree_status' => $finaloutput['status'], 'comment' => 'SUCCESS - Add by ADMIN', 'utr_number' => $finaloutput['utr'], 'reference_id' => $finaloutput['referenceId'], 'acknowledged' => $finaloutput['acknowledged']]);
                        }
                    } elseif ($finaloutput['status'] == 'REVERSED') {
                        $update_userbalance =   DB::table('withdraw')
                            ->where('id', $output->id)
                            ->where('transfer_id', $output->transfer_id)
                            ->update(['status' => 0, 'cashfree_status' => $finaloutput['status'], 'comment' => 'REVERSED -' . @$finaloutput["message"], 'reference_id' => $finaloutput['referenceId']]);

                        // $user_id = $output->user_id;
                        // $balances = DB::table('userbalances')->where('user_id',$user_id)->first();
                        // $dataq['winning'] = $balances->winning+$output->amount;
                        // DB::table('userbalances')->where('user_id', $user_id)->update($dataq);

                        // $transaction['userid'] = $user_id;
                        // $transaction['type'] = "Withdraw Request Rejected";
                        // $transaction['transaction_id'] = $output->transfer_id."-".$output->id;
                        // $transaction['transaction_by'] = "Vision11-WAR-".$output->transfer_id;
                        // $transaction['amount'] = $output->amount;
                        // $transaction['paymentstatus'] = "confirmed";
                        // $transaction['win_amt'] = $output->amount;
                        // $transaction['bal_bonus_amt'] = $balances->bonus;
                        // $transaction['bal_win_amt'] = $dataq['winning'];
                        // $transaction['bal_fund_amt'] = $balances->balance;
                        // $transaction['total_available_amt'] = $balances->bonus+$dataq['winning']+$balances->balance;
                        // DB::table('transactions')->insert($transaction);
                    } elseif ($finaloutput['status'] == 'FAILED') {
                        $update_userbalance =   DB::table('withdraw')
                            ->where('id', $output->id)
                            ->where('transfer_id', $output->transfer_id)
                            ->update(['status' => 0, 'cashfree_status' => $finaloutput['status'], 'comment' => 'FAILED -' . @$finaloutput["message"], 'reference_id' => $finaloutput['referenceId']]);

                        // $user_id = $output->user_id;
                        // $balances = DB::table('userbalances')->where('user_id',$user_id)->first();
                        // $dataq['winning'] = $balances->winning+$output->amount;
                        // DB::table('userbalances')->where('user_id', $user_id)->update($dataq);

                        // $transaction['userid'] = $user_id;
                        // $transaction['type'] = "Withdraw Request Rejected";
                        // $transaction['transaction_id'] = $output->transfer_id."-".$output->id;
                        // $transaction['transaction_by'] = "Vision11-WAR-".$output->transfer_id;
                        // $transaction['amount'] = $output->amount;
                        // $transaction['paymentstatus'] = "confirmed";
                        // $transaction['win_amt'] = $output->amount;
                        // $transaction['bal_bonus_amt'] = $balances->bonus;
                        // $transaction['bal_win_amt'] = $dataq['winning'];
                        // $transaction['bal_fund_amt'] = $balances->balance;
                        // $transaction['total_available_amt'] = $balances->bonus+$dataq['winning']+$balances->balance;
                        // DB::table('transactions')->insert($transaction);

                    }
                }
            }
        }
    }








    //XXXXXXXXXXXXXXXXXX Cashfree Instant Cron XXXXXXXXXXXXXXXXX //




    //Approve Bank

    public function approve_bank_razorpay(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $uid = $input['uid'];
            $amount = $input['amount'];
            //  $data['approved_date']  = date('Y-m-d');
            ini_set('memory_limit', '-1');

            $settings = DB::table('registerusers')->where('id', $uid)->first();
            //Get Data
            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $input['id'])
                ->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')
                ->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id', 'withdraw.status', 'withdraw.razorpay_status')
                ->first();

            if ($finduserdetails->status == 0 && ($finduserdetails->razorpay_status != "processed" || $finduserdetails->razorpay_status != "processing")) {
                $data['status'] = 18;
            } else {
                Session::flash('message', 'There is some error please check status in your razorpay account!');
                Session::flash('alert-class', 'alert-danger');
                return Redirect::back();
            }
            //Withdraw Value
            //Update Withdraw
            $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($data);
            //Get Transactions
            $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
            //Ckeck  Data
            //print_r($findtransactiondate);die;
            if (!empty($findtransactiondate)) {
                $tdata['paymentstatus'] = 'Confirmed';
                $tdata['created'] = $findtransactiondate->created;
                $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
            }

            //mail//
            // $email = $finduserdetails->email;
            // //Get Email Template
            // $email_templates = DB::table('email_templates')->where('action','Withdraw Request approved')->first();
            // //Set Subject
            // $emailsubject = $email_templates->subject.'- FC';
            // //Set Email Body
            // $email_body=array('{NAME}','{AMOUNT}');
            // //Replace
            // $rep_Array 	 = 	array(ucwords($finduserdetails->team),$input['amount']);
            // //Replase Value
            // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
            //
            // $msg = Helpers::mailheader();
            // $msg.= $messageBody;
            // $msg.= Helpers::mailfooter();
            // Helpers::mailsentFormat($email,$emailsubject,$msg);
            // //notifications//
            $notificationdata['userid'] = $finduserdetails->user_id;
            $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.' . $input['amount'];
            //  DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdrawl Request Approved!';
            //  Helpers::sendnotification($titleget,$notificationdata['title'],'',$finduserdetails->user_id);
            //end push notifications//
            //message show//
            Session::flash('flash_notice', 'Withdraw Request Approved successfully!');
            //Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    }
    // public function approve_bank(Request $request) {
    //   if ($request->isMethod('post')){
    //     $input = Input::all();
    //     $uid=$input['uid'];
    //     $amount=$input['amount'];
    //     $order_id = 'Trans'.$input['id'];
    //     if($order_id=='Trans389') {
    //       $order_id = 'Trans3491xs';
    //     }
    //     $withdrawDetails = DB::table('withdraw')->where('id',$input['id'])->first();
    //
    //     $finduserdetails = DB::table('withdraw as w')
    //     ->where('w.id',$input['id'])
    //     ->join('registerusers as r','r.id','=','w.user_id')
    //     ->select('w.user_id','r.email','r.team','w.withdraw_request_id', 'r.banid')
    //     ->first();
    //
    //     //dd($finduserdetails);
    //     if(empty($finduserdetails)) {
    //       Session::flash('flash_notice', 'There is some error in finding user!');
    //       Session::flash('alert-class', 'alert-success');
    //       return Redirect::back();
    //     }
    //
    //     $userId = $finduserdetails->user_id;
    //
    //     if(trim($withdrawDetails->cashfree_status) == 'ERROR' || trim($withdrawDetails->cashfree_status) == 'FAILED') {
    //       $order_id= 'TRANS'.$input['id'].'_'.substr(time(), -5);
    //     }
    //
    //     if(empty($finduserdetails->banid) || strlen($finduserdetails->banid) < 3) {
    //       $return_banid = Helpers::cf_add_benificary($userId);
    //     //  dd($return_banid);
    //       if($return_banid != true) {
    //         $update['cashfree_status'] = 'ERROR';
    //         $update['transfer_id'] = $order_id;
    //         $update['comment'] = @$return ?? 'Error from cashfree';
    //         $update['cashfree_message'] = @$return ?? 'Error from cashfree';
    //
    //         $rowCOllection = DB::table('withdraw')->where('id',$input['id'])->update($update);
    //
    //         Session::flash('flash_notice', @$return);
    //         Session::flash('alert-class', 'alert-danger');
    //         return Redirect::back();
    //       }
    //     }
    //
    //
    //     $cashfreeData = Helpers::cf_request_transfer($uid, $amount, $order_id);
    //     // echo "<pre>"; print_r($cashfreeData);die();
    //     if($cashfreeData->status == 'SUCCESS') {
    //       $data['status'] = 1;
    //       $data['transfer_id'] = $order_id;
    //       $data['reference_id'] = @$cashfreeData->data->referenceId ?? '';
    //       $data['utr_number'] = @$cashfreeData->data->utr ?? '';
    //       $data['acknowledged'] = @$cashfreeData->data->acknowledged ?? 0;
    //       $data['approved_date']  = date('Y-m-d H:i:s');
    //       $data['cashfree_status'] = 'SUCCESS';
    //       $data['comment'] = $input['comment'] != '' ? $input['comment'] : 'Approved by admin';
    //       $data['cashfree_message'] = @$cashfreeData->message ?? '';
    //
    //       $rowCOllection = DB::table('withdraw')->where('id',$input['id'])->update($data);
    //
    //       // $finduserdetails = DB::table('withdraw')->where('withdraw.id',$input['id'])->join('registerusers','registerusers.id','=','withdraw.user_id')->select('user_id','registerusers.email','registerusers.team','withdraw_request_id')->first();
    //
    //       $findtransactiondate = DB::table('transactions')->where('transaction_id',$finduserdetails->withdraw_request_id)->first();
    //       $tdata['paymentstatus'] = 'Confirmed';
    //       $tdata['created'] = $findtransactiondate->created;
    //       $findtransactiondetails  = DB::table('transactions')->where('transaction_id',$finduserdetails->withdraw_request_id)->update($tdata);
    //       //mail//
    //       // $email = $finduserdetails->email;
    //       // //Send Mail Template
    //       // $email_templates = DB::table('email_templates')->where('action','Withdraw Request approved')->first();
    //       // //Set Subject
    //       // $emailsubject = $email_templates->subject.'- FC';
    //       // //Set Email Body
    //       // $email_body=array('{NAME}','{AMOUNT}');
    //       //Replace
    //       $rep_Array =array(ucwords($finduserdetails->team),$input['amount']);
    //       //Replase Value
    //       // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
    //
    //       // $msg = Helpers::mailheader();
    //       // $msg.= $messageBody;
    //       // $msg.= Helpers::mailfooter();
    //       // Helpers::mailsentFormat($email,$emailsubject,$msg);
    //       //notifications//
    //       $notificationdata['userid'] = $finduserdetails->user_id;
    //       $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.'.$input['amount'];
    //       DB::table('notifications')->insert($notificationdata);
    //       //push notifications//
    //       $titleget = 'Withdrawl Request Approved!';
    //       Helpers::sendnotification($titleget,$notificationdata['title'],'',$finduserdetails->user_id);
    //       //end push notifications//
    //       //message show//
    //       Session::flash('flash_notice', 'Withdraw Request Approved successfully!');
    //       Session::flash('alert-class', 'alert-success');
    //       return Redirect::back();
    //
    //
    //     }
    //     elseif ($cashfreeData->status == 'PENDING') {
    //       $update['cashfree_status'] = 'PENDING';
    //       $update['transfer_id'] = $order_id;
    //       $update['reference_id'] = @$cashfreeData->data->referenceId ?? '';
    //       $update['utr_number'] = @$cashfreeData->data->utr ?? '';
    //       $update['comment'] = 'Pending In cashfree';
    //       $update['cashfree_message'] = @$cashfreeData->message ?? '';
    //
    //       $rowCOllection = DB::table('withdraw')->where('id',$input['id'])->update($update);
    //
    //       Session::flash('flash_notice', $cashfreeData->message);
    //       Session::flash('alert-class', 'alert-warning');
    //       return Redirect::back();
    //     }
    //     elseif ($cashfreeData->status == 'ERROR') {
    //       $update['cashfree_status'] = 'ERROR';
    //       $update['transfer_id'] = $order_id;
    //       $update['reference_id'] = @$cashfreeData->data->referenceId ?? '';
    //       $update['utr_number'] = @$cashfreeData->data->utr ?? '';
    //       $update['comment'] = 'Error from cashfree';
    //       $update['cashfree_message'] = @$cashfreeData->message ?? 'Error from cashfree';
    //
    //       $rowCOllection = DB::table('withdraw')->where('id',$input['id'])->update($update);
    //
    //       Session::flash('flash_notice', @$cashfreeData->message);
    //       Session::flash('alert-class', 'alert-danger');
    //       return Redirect::back();
    //     }
    //     else {
    //       Session::flash('flash_notice', 'There is some error please check status in your cashfree account!');
    //       Session::flash('alert-class', 'alert-danger');
    //       return Redirect::back();
    //     }
    //   }
    // }

    public function approve_bank_old_20220407(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $uid = $input['uid'];
            $amount = $input['amount'];
            $order_id = 'Trans' . $input['id'];
            if ($order_id == 'Trans389') {
                $order_id = 'Trans3491xs';
            }
            $withdrawDetails = DB::table('withdraw')->where('id', $input['id'])->first();

            $finduserdetails = DB::table('withdraw as w')
                ->where('w.id', $input['id'])
                ->join('registerusers as r', 'r.id', '=', 'w.user_id')
                ->select('w.user_id', 'r.email', 'r.team', 'w.withdraw_request_id', 'r.banid')
                ->first();


            if (empty($finduserdetails)) {
                Session::flash('flash_notice', 'There is some error in finding user!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::back();
            }

            $userId = $finduserdetails->user_id;

            if (trim($withdrawDetails->cashfree_status) == 'ERROR' || trim($withdrawDetails->cashfree_status) == 'FAILED') {
                $order_id = 'TRANS' . $input['id'] . '_' . substr(time(), -5);
            }

            if (empty($finduserdetails->banid)) {
                $return_banid = Helpers::cf_add_benificary($userId);
                if ($return_banid != true) {
                    Session::flash('flash_notice', "Something went wrong");
                    Session::flash('alert-class', 'alert-success');
                    return Redirect::back();
                }
            }

            // echo "<pre>"; print_r($finduserdetails);die();

            $cashfreeData = Helpers::cf_request_transfer($uid, $amount, $order_id);
            if ($cashfreeData->status == 'SUCCESS') {
                $data['status'] = 1;
                $data['transfer_id'] = $order_id;
                $data['approved_date']  = date('Y-m-d');
                $data['cashfree_status'] = 'SUCCESS';
                $data['comment'] = $input['comment'] != '' ? $input['comment'] : 'Approved by admin';
                // $data['comment'] = 'Approved by admin';

                $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($data);

                // $finduserdetails = DB::table('withdraw')->where('withdraw.id',$input['id'])->join('registerusers','registerusers.id','=','withdraw.user_id')->select('user_id','registerusers.email','registerusers.team','withdraw_request_id')->first();

                $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
                $tdata['paymentstatus'] = 'Confirmed';
                $tdata['created'] = $findtransactiondate->created;
                $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
                //mail//
                $email = $finduserdetails->email;
                //Send Mail Template
                $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
                //Set Subject
                $emailsubject = $email_templates->subject . '- FC';
                //Set Email Body
                $email_body = array('{NAME}', '{AMOUNT}');
                //Replace
                $rep_Array = array(ucwords($finduserdetails->team), $input['amount']);
                //Replase Value
                $messageBody = str_replace($email_body, $rep_Array, $email_templates->body);

                $msg = Helpers::mailheader();
                $msg .= $messageBody;
                $msg .= Helpers::mailfooter();
                Helpers::mailsentFormat($email, $emailsubject, $msg);
                //notifications//
                $notificationdata['userid'] = $finduserdetails->user_id;
                $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.' . $input['amount'];
                DB::table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Withdrawl Request Approved!';
                Helpers::sendnotification($titleget, $notificationdata['title'], '', $finduserdetails->user_id);
                //end push notifications//
                //message show//
                Session::flash('flash_notice', 'Withdraw Request Approved successfully!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::back();
            } elseif ($cashfreeData->status == 'PENDING') {
                $update['cashfree_status'] = 'PENDING';
                $update['transfer_id'] = $order_id;
                $update['comment'] = 'Pending from cashfree';
                $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($update);

                Session::flash('flash_notice', $cashfreeData->message);
                Session::flash('alert-class', 'alert-warning');
                return Redirect::back();
            } elseif ($cashfreeData->status == 'ERROR') {
                $update['cashfree_status'] = 'ERROR';
                $update['transfer_id'] = $order_id;
                $update['comment'] = @$cashfreeData->message ?? 'Error from cashfree';
                $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($update);

                Session::flash('flash_notice', $cashfreeData->message);
                Session::flash('alert-class', 'alert-danger');
                return Redirect::back();
            } else {
                Session::flash('flash_notice', 'There is some error please check status in your cashfree account!');
                Session::flash('alert-class', 'alert-danger');
                return Redirect::back();
            }
        }
    }

    //End Function


    public function approve_bank_old_2021_11_30(Request $request)
    {
        if ($request->isMethod('post')) {

            $input = Input::all();
            $uid = $input['uid'];
            $amount = $input['amount'];
            $data['approved_date']  = date('Y-m-d');
            $order_id = 'Trans' . $input['id'];
            if ($order_id == 'Trans389') {
                $order_id = 'Trans3491xs';
            }
            // if(Helpers::cf_request_transfer($uid, $amount, $order_id)) {
            if (1) {
                $data['status'] = 9;
                // }
            } else {
                Session::flash('flash_notice', 'There is some error please check status in your cashfree account!');
                Session::flash('alert-class', 'alert-danger');
                return Redirect::back();
            }
            ini_set('memory_limit', '-1');
            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $input['id'])->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id')->first();
            $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($data);
            $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
            $tdata['paymentstatus'] = 'Confirmed';
            $tdata['created'] = @$findtransactiondate->created ? $findtransactiondate->created : date('Y-m-d H:i:s');
            $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
            //mail//
            $email = $finduserdetails->email;
            //Send Mail Template
            $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
            //Set Subject
            $emailsubject = $email_templates->subject . '- FC';
            //Set Email Body
            $email_body = array('{NAME}', '{AMOUNT}');
            //Replace
            $rep_Array = array(ucwords($finduserdetails->team), $input['amount']);
            //Replase Value
            $messageBody = str_replace($email_body, $rep_Array, $email_templates->body);

            $msg = Helpers::mailheader();
            $msg .= $messageBody;
            $msg .= Helpers::mailfooter();
            // Helpers::mailsentFormat($email,$emailsubject,$msg);
            //notifications//
            $notificationdata['userid'] = $finduserdetails->user_id;
            $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.' . $input['amount'];
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdrawl Request Approved!';
            // Helpers::sendnotification($titleget,$notificationdata['title'],'',$finduserdetails->user_id);
            //end push notifications//
            //message show//
            Session::flash('flash_notice', 'Withdraw Request Processed successfully!');
            Helpers::logActivity('Bank Withdraw Request Processed successfully', $finduserdetails->withdraw_request_id);
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    } //End Function



    //admin bannk comment request form function

    public function admin_comment_bank_withdraw(Request $request)
    {

        if ($request->isMethod('post')) {
            $input = Input::all();
            //dd($input);

            if ($input['type'] == 'reject') {
                $this->reject($request);
            }
            if ($input['type'] == 'settle') {
                DB::table('withdraw')->where('id', $input['id'])->update(['is_manual_withdraw' => 1, 'status' => 3, 'approved_date' => date('Y-m-d H:i:s')]);
                $titleget = 'Withdrawl Request Manual settled!';
                //$details = 'Withdrawl Request of rs '.$amount.' is rejected due to '.$input['comment'];
                // Helpers::sendnotification($titleget,$details,'',$input['uid']);

                //  Helpers::logActivity('Bank Request Rejected','Transaction Id - '.$getlasttransactionid->id);
            }
            if ($input['type'] == 'approve') {
                if ($input['Withdrowtype'] == 'manual') {
                    $this->approve_bank_manual($request);
                }
                if ($input['Withdrowtype'] == 'bank') {

                    $this->approve_bank_razorpay($request);
                }
                //  echo "<pre>"; print_r($input);
                // Transaction >> Status
                // if(1){
                //
                // }

            }
            return Redirect::back();
        }
    }
    // end admin bank comment request form function



    //Approve Bank Manual
    public function approve_bank_manual(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $uid = $input['uid'];
            $amount = $input['amount'];
            $data['approved_date']  = date('Y-m-d');
            ini_set('memory_limit', '-1');

            $settings = DB::table('registerusers')->where('id', $uid)->first();
            //Get Data

            if (1) {
                $data['status'] = 1;
            } else {
                Session::flash('message', 'There is some error please check status in your cashfree account!');
                Session::flash('alert-class', 'alert-danger');
                return Redirect::back();
            }
            //Withdraw Value
            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $input['id'])->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id')->first();
            //Update Withdraw
            $rowCOllection = DB::table('withdraw')->where('id', $input['id'])->update($data);
            //Get Transactions
            $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
            //Ckeck  Data
            //print_r($findtransactiondate);die;
            if (!empty($findtransactiondate)) {
                $tdata['paymentstatus'] = 'Confirmed';
                $tdata['created'] = $findtransactiondate->created;
                $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);

                Helpers::logActivity('Bank Request Approved', $finduserdetails->withdraw_request_id);
            }

            //mail//
            $email = $finduserdetails->email;
            //Get Email Template
            $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
            //Set Subject
            //  $emailsubject = $email_templates->subject.'- FC';
            //Set Email Body
            $email_body = array('{NAME}', '{AMOUNT}');
            //Replace
            $rep_Array      =     array(ucwords($finduserdetails->team), $input['amount']);
            //Replase Value
            //$messageBody = str_replace($email_body,$rep_Array,$email_templates->body);

            //$msg = Helpers::mailheader();
            //  $msg.= $messageBody;
            //  $msg.= Helpers::mailfooter();
            //  Helpers::mailsentFormat($email,$emailsubject,$msg);
            //notifications//
            $notificationdata['userid'] = $finduserdetails->user_id;
            $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.' . $input['amount'];
            DB::table('notifications')->insert($notificationdata);
            //push notifications//
            $titleget = 'Withdrawl Request Approved!';
            Helpers::sendnotification($titleget, $notificationdata['title'], '', $finduserdetails->user_id);
            //end push notifications//
            //message show//
            Session::flash('flash_notice', 'Withdraw Request Approved successfully!');
            Helpers::logActivity('Bank Withdraw Request Processed successfully', $finduserdetails->withdraw_request_id);
            //Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    }

    //Admin Wallet Info
    public function adminwalletinfo(Request $req)
    {
        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of($query = DB::table('adminwallets')->orderBy('id', 'DESC')->join('registerusers', 'registerusers.id', '=', 'adminwallets.userid')->select('adminwallets.*', 'registerusers.username', 'registerusers.email', 'registerusers.mobile')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('registerusers.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('registerusers.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_bonus_type'])) {
                                $query->where('adminwallets.bonustype', 'like', '%' . $formData['filter_columns']['filter_bonus_type'] . '%');
                            }
                        }
                    })
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('username', function ($result) {
                        if ($result->username != "") {
                            return $result->username;
                        } else {
                            return $result->email;
                        }
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.adminwalletinfo");
    } //End Function

    //User Avatars
    public function user_avatars()
    {
        //Get Post Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('user_avatars')->get())
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" class="" style="text-decoration:underline;">' . $result->id . '</a>';
                })
                ->addColumn('status', function ($result) {
                    if ($result->status == '1') {
                        return 'Active';
                    } else {
                        return 'InActive';
                    }
                })->addColumn('image', function ($result) {
                    if (isset($result->image) && @getimagesize(URL::asset("uploads/user_avatars/" . $result->image))) {
                        return    '<div style= "display:flex; align-items:center;">
        <div style="float:left; width:45%;">
        <img src="' . URL::asset('uploads/user_avatars/' . $result->image) . '" style="width:30px;height:30px;">
        </div>
        </div>';
                    } else {
                        return    '<div style= "display:flex; align-items:center;">
        <div style="float:left; width:45%;">
        <img src="' . URL::asset('uploads/default-user-avatars.png') . '" style="width:30px;">

        </div>
        </div>';
                    }
                })->addColumn('action', function ($result) {
                    return '<a href="' . route($this->model . '.edit_user_avatars', base64_encode(serialize($result->id))) . '"  class="btn btn-rg" data-toggle="tooltip" title="" data-original-title="Edit" ><i class="fa fa-pencil mr-2" aria-hidden="true">
      </i>Edit</a>';
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        $user_avat = DB::table('user_avatars')->get();
        return view("admin.$this->model.user_avatars");
    } //End Function

    //User Avatars
    public function add_user_avatars(Request  $request)
    {

        $post = Input::all();
        if (!empty($post)) {
            //print_r($post);die;
            $message  = array(
                'status.required'         => 'Please enter status.',
            );
            $validate = array(
                'status'                      => 'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['status'] = $post['status'];
                if ($request->file('image')) {
                    $image = $request->file('image');
                    $destination = 'uploads/user_avatars';
                    $filename = 'profile-' . time();
                    $data['image'] = Helpers::imageUpload($image, $destination, $filename);
                    //print_r( $input['image']);die;
                    if ($data['image'] == '') {
                        return redirect()->back()->with('danger', 'Invalid extension of file you uploaded. You can only upload image or pdf.');
                    }
                }
                DB::table('user_avatars')->insert($data);
                Session::flash('flash_notice', 'Add User Avatars Successfully!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.user_avatars");
            }
        } else {
            return view("admin.$this->model.add_user_avatars");
        }
    } //End Function

    //User Avatars
    public function edit_user_avatars($id = null, Request  $request)
    {

        $id = unserialize(base64_decode($id));
        //Det Data
        $user_avat = DB::table('user_avatars')->where('id', $id)->first();
        //Input get
        $post = Input::all();
        if (!empty($post)) {
            //print_r($post);die;
            $message  = array(
                'status.required'         => 'Please enter status.',
            );
            $validate = array(
                'status'                      => 'required',
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['status'] = $post['status'];
                if ($request->file('image')) {
                    $image = $request->file('image');
                    $destination = 'uploads/user_avatars';
                    $filename = 'profile-' . time();
                    $data['image'] = Helpers::imageUpload($image, $destination, $filename);
                    //print_r( $input['image']);die;
                    if ($data['image'] == '') {
                        return redirect()->back()->with('danger', 'Invalid extension of file you uploaded. You can only upload image or pdf.');
                    }
                    $oldimage = DB::table('user_avatars')->where('id', $id)->first();
                    $filename = $oldimage->image;
                    $filenamep = 'uploads/user_avatars/' . $filename;
                    @unlink($filenamep);
                }
                DB::table('user_avatars')->where('id', $id)->update($data);
                Session::flash('flash_notice', 'Update User Avatars Successfully!');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route("$this->model.user_avatars");
            }
        } else {
            return view("admin.$this->model.edit_user_avatars", compact('user_avat'));
        }
    } //End Function

    //Admin Wallet Action
    public function adminwalletaction(Request $req)
    {
        // Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of($query = DB::table('registerusers as r')
                    // ->where($where_condition,$where_operation,$where_value)
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_username'])) {
                                $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_email'])) {
                                $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_mobile'])) {
                                $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                            }
                        }
                    })
                    //->orWhere($where_condition1,$where_operation,$where_value)
                    ->orderBy('id', 'desc')
                    ->limit(1000)->get())
                    ->addIndexColumn()

                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.details', base64_encode(serialize($result->id))) . '" style="text-decoration:underline;">' . $result->email . '</td>';
                    })
                    ->addColumn('action', function ($result) {
                        return '<a href="' . route($this->model . '.add_moneyin_wallet', base64_encode(serialize($result->id))) . '" class="editbtn" style="cursor:pointer;"><i class="fa fa-plus-circle"></i> Add Money </a>';
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return view("admin.$this->model.adminwalletaction");
    } //End Function

    //Add Money In wallet
    public function addmoneyinwallet(Request $request, $id = null)
    {

        //Get Id
        $getuserid = unserialize(base64_decode($id));
        $userbalanace = DB::table('registerusers')->where('id', $getuserid)->first();
        //Ckeck Post Value
        if ($request->isMethod('post')) {
            $input = Input::all();
            //echo "<pre>";print_r($input);die;
            $message  = array(
                'bonustype.required'         => 'Please enter bonustype.',
                'amount.required'         => 'Please enter amount.',
            );
            $validate = array(
                'bonustype'                      => 'required',
                'amount'                      => 'numeric|required',
            );

            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                $finduserbalanace = DB::table('userbalances')->where('user_id', $getuserid)->first();

                $bonusbal = $finduserbalanace->bonus ?? 0;

                $balancebal = $finduserbalanace->balance ?? 0;
                $winningbal = $finduserbalanace->winning ?? 0;
                $gstbonusbal = $finduserbalanace->gst_bonus ?? 0;
                $affbalancebal = $finduserbalanace->affiliation_commission ?? 0;
                unset($input['_token']);

                $amount = $input['amount'];
                if (($input['bonustype'] == 'addfund') || ($input['bonustype'] == 'Unutilized')) {
                    $balancebal += $input['amount'];
                    $transactiondata['addfund_amt'] = $input['amount'];
                } else if ($input['bonustype'] == 'Add Fund') {
                    $balancebal += $input['amount'];
                    $transactiondata['addfund_amt'] = $input['amount'];
                } else if ($input['bonustype'] == 'specialbonus') {
                    $bonusbal += $input['amount'];
                    $transactiondata['bonus_amt'] = $input['amount'];
                } else if ($input['bonustype'] == 'gst_bonus') {
                    $gstbonusbal += $input['amount'];
                    $transactiondata['gst_bonus_amt'] = $input['amount'];
                } else if ($input['bonustype'] == 'promotional') {
                    $affbalancebal += $input['amount'];
                    $transactiondata['affiliation_amount'] = $input['amount'];
                } else {
                    $winningbal += $input['amount'];
                    $transactiondata['win_amt'] = $input['amount'];
                }

                $update['bonus'] = $bonusbal;
                $update['balance'] = $balancebal;
                $update['winning'] = $winningbal;
                $update['gst_bonus'] = $gstbonusbal;
                $update['affiliation_commission'] = $affbalancebal;
                $nowtotalbal = $bonusbal + $balancebal + $winningbal + $gstbonusbal + $affbalancebal;

                DB::table('userbalances')->where('user_id', $getuserid)->update($update);
                $input['userid'] = $getuserid;
                DB::table('adminwallets')->insert($input);
                //entry in transactions//
                $getlasttransactionid = DB::table('transactions')->select('id')->orderBy('id', 'DESC')->first();
                if (!empty($getlasttransactionid)) {
                    $tid = $getlasttransactionid->id + 1;
                } else {
                    $tid = 1;
                }

                if (($input['bonustype'] == 'addfundw') || ($input['bonustype'] == 'Unutilized')) {
                    $transactiondata['type'] = 'Add Fund Adjustments';
                } else if ($input['bonustype'] == 'specialbonus') {
                    $transactiondata['type'] = 'Special Bonus';
                } else if ($input['bonustype'] == 'gst_bonus') {
                    $transactiondata['type'] = 'GST/TDS Bonus';
                } else if (($input['bonustype'] == 'addfund')) {
                    $transactiondata['type'] = 'Add Fund';

                    //GST Calculation
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($amount - $add_Fund, 2);

                    //TDS Calculation
                    //   $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $getuserid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $getuserid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $getuserid)
                            ->where("session_year", $session_year)
                            ->first();
                    }

                    // DB::table("registerusers_session")
                    //   ->where("id", $registerusers_session->id)
                    //   ->update([
                    //       "total_deposit" => $registerusers_session->total_deposit+$input['amount']
                    //   ]);
                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $amount
                        ]);
                } else if ($input['bonustype'] == 'promotional') {
                    $transactiondata['type'] = 'Affiliation amount';
                } else {
                    $transactiondata['type'] = 'Winning Adjustment';
                }
                $transactiondata['amount'] = $input['amount'];
                $transactiondata['total_available_amt'] = $nowtotalbal;
                $transactiondata['transaction_id'] = 'S2W-' . $tid;
                $transactiondata['transaction_by'] = 'admin';
                $transactiondata['challengeid'] = "";
                $transactiondata['userid'] = $getuserid;
                $transactiondata['addfund_amt'] = $input['amount'];
                $transactiondata['paymentstatus'] = 'confirmed';
                //  $transactiondata['bal_bonus_amt'] = $bonusbal+$gstbonusbal;
                $transactiondata['bal_bonus_amt'] = $bonusbal;
                $transactiondata['bal_gst_bonus_amt'] = $gstbonusbal;
                $transactiondata['bal_win_amt'] = $winningbal;
                $transactiondata['bal_fund_amt'] = $balancebal;
                $transactiondata['bal_affi_amt'] = $affbalancebal;

                DB::table('transactions')->insert($transactiondata);
                if (($input['bonustype'] == 'addfund')) {
                    $findlastow = DB::table('userbalances')->where('user_id', $getuserid)->first();
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($amount - $add_Fund, 2);
                    $gstamount = $GSTAmount;
                    $bal_fund_amt = $balancebal;
                    $bal_win_amt = $winningbal;
                    $bal_bonus_amt = $bonusbal;
                    $bal_bonus_gstamt = 0;
                    $total_available_amt = $bal_fund_amt + $bal_win_amt + $bal_bonus_amt + $bal_bonus_gstamt  - $gstamount;
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;
                        $bal_fund_amt = $findlastow->balance - $gstamount;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                        $bal_bonus_gstamt = $findlastow->gst_bonus;
                        $affbalancebal = $findlastow->affiliation_commission;
                    }

                    $transactionsdata['userid'] = $getuserid;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['type'] = 'GST Deduction as per new government rule';
                    $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $getuserid;
                    $transactionsdata['transaction_by'] = 'wallet';
                    $transactionsdata['amount'] = $gstamount;
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['bal_gst_bonus_amt'] = $bal_bonus_gstamt;
                    $transactionsdata['bal_affi_amt'] = $affbalancebal;
                    $transactionsdata['cons_amount'] = $gstamount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;

                    DB::table('transactions')->insert($transactionsdata);

                    $datainseert['balance'] = $findlastow->balance - $gstamount;
                    DB::table('userbalances')->where('user_id', $getuserid)->update($datainseert);
                    //GST Report
                    $user_data = DB::table('registerusers')->where('id', $getuserid)->first();
                    $igst = 0;
                    $cgst = 0;
                    $sgst = 0;
                    if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                        $igst = 0;
                        $cgst = $gstamount;
                        $sgst = $gstamount;
                    } else {
                        $igst = $gstamount;
                        $cgst = 0;
                        $sgst = 0;
                    }

                    $GST_entry = array(
                        "user_id" => $getuserid,
                        "deposit_amount" => $amount,
                        "gst_amount" => $gstamount,
                        "wallet_amount" => $amount,
                        "transaction_id" => $getuserid . time() . rand(11, 99),
                        "igst" => $igst,
                        "cgst" => $cgst,
                        "sgst" =>  $sgst,
                        "transaction_by" => 'admin',
                        "transactions_date" => date('Y-m-d H:i:s'),
                    );
                    DB::table('deposit_gst')->insert($GST_entry);

                    //GST Rebat
                    // $findlastow = DB::table('userbalances')->where('user_id', $getuserid)->first();
                    // if (!empty($findlastow)) {
                    //     $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                    //     $bal_fund_amt = $findlastow->balance;
                    //     $bal_win_amt = $findlastow->winning;
                    //     $bal_gst_bonus_amt = $findlastow->gst_bonus + $gstamount;
                    //     $bal_bonus_amt = $findlastow->bonus;
                    //     $affbalancebal = $findlastow->affiliation_commission;
                    // }
                    //
                    // $transactionsgstrebat['userid'] = $getuserid;
                    // $transactionsgstrebat['paymentstatus'] = 'confirmed';
                    // $transactionsgstrebat['type'] = 'GST Coins Rebat from PLAYNWIN11';
                    // $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $getuserid;
                    // $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                    // $transactionsgstrebat['amount'] = $gstamount;
                    // $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                    // $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                    // $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                    // $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                    // $transactionsgstrebat['bal_affi_amt'] = $affbalancebal;
                    // //$transactionsgstrebat['addfund_amt'] = $gstamount;
                    // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                    // $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                    // DB::table('transactions')->insert($transactionsgstrebat);
                    //
                    // // $datainseert['balance'] = $findlastow->balance+$gstamount;
                    // $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                    // DB::table('userbalances')->where('user_id', $getuserid)->update($datainseert);
                      //GST Rebat End
                }

                Session::flash('flash_notice', 'Money has been successfully transferred to user wallet');
                Session::flash('alert-class', 'alert-success');
                return Redirect::route($this->model . '.admin_wallet_action');
            }
        } else {
            return view("admin.$this->model.addmoneyinwallet", compact('userbalanace'));
        }
    } //End Function

    //Uplode Withdrawle Excel
    public function uploadwithdrawlexcel(Request $request)
    {
        // require_once("./phpexcel/PHPExcel.php");
        // $objPHPExcel = new PHPExcel;
        // $inputFileName = 'discussdesk.xlsx';
        $input = $request->all();
        if (isset($input['file'])) {
            $image = $request->file('file');
            $filename = $image->getClientOriginalName();
            $realpath = $image->getRealPath();
            $file = fopen($realpath, "r");
            $header = fgetcsv($file);
            $escapedHeader = [];
            //validate
            foreach ($header as $key => $value) {
                $lheader = strtolower($value);
                $escapedItem = preg_replace('/[^a-z]/', '', $lheader);
                array_push($escapedHeader, $escapedItem);
            }
            //looping through othe columns
            while ($columns = fgetcsv($file)) {
                if ($columns[0] == "") {
                    continue;
                }
                //trim data
                // foreach ($columns as $key => &$value) {
                // $value=preg_replace('/\D/','',$value);
                // }
                $data = array_combine($escapedHeader, $columns);
                // setting type
                if ($data['admincomment'] != "") {
                    if ($data['approveddate'] != "") {
                        $findapproveddate = $dataupdate['approved_date'] = date('Y-m-d', strtotime($data['approveddate']));
                    } else {
                        $findapproveddate = $dataupdate['approved_date'] =  date('Y-m-d');
                    }
                    $uid = $data['userid'];
                    $amount = $data['withdrawlamount'];
                    $data['admincomment'] = $dataupdate['comment'] = $data['admincomment'];
                    $dataupdate['status'] = 1;
                    $finduserdetails = DB::table('withdraw')->where('withdraw.withdraw_request_id', $data['withdrawrequestid'])->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id')->first();
                    $rowCOllection = DB::table('withdraw')->where('withdraw.withdraw_request_id', $data['withdrawrequestid'])->update($dataupdate);
                    $findtransactiondate = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->first();
                    if (!empty($findtransactiondate)) {
                        $tdata['paymentstatus'] = 'Confirmed';
                        $tdata['created'] = $findtransactiondate->created;
                        $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $finduserdetails->withdraw_request_id)->update($tdata);
                    }
                    //mail//
                    $email = $finduserdetails->email;
                    //Send Mail Template
                    $email_templates = DB::table('email_templates')->where('action', 'Withdraw Request approved')->first();
                    //Set Subject
                    $emailsubject = $email_templates->subject . '- FC';
                    //Set Email Body
                    $email_body = array('{NAME}', '{AMOUNT}');
                    //Replace
                    $rep_Array = array(ucwords($finduserdetails->team), $data['withdrawlamount']);
                    //Replase Value
                    $messageBody = str_replace($email_body, $rep_Array, $email_templates->body);
                    $msg = Helpers::mailheader();
                    $msg .= $messageBody;
                    $msg .= Helpers::mailfooter();
                    Helpers::mailsentFormat($email, $emailsubject, $msg);
                    //notifications//
                    $notificationdata['userid'] = $finduserdetails->user_id;
                    $notificationdata['title'] = 'Withdraw Request Approved successfully of amount ₹.' . $data['withdrawlamount'];
                    DB::table('notifications')->insert($notificationdata);
                    //push notifications//
                    $titleget = 'Withdrawl Request !';
                    Helpers::sendnotification($titleget, $notificationdata['title'], '', $finduserdetails->user_id);
                    //end push notifications//
                }
            }
            //message show//
            Session::flash('flash_notice', 'Withdraw Request Approved successfully!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
        return Redirect::back();
    } //End Function

    //Commision List
    public function commisionlist()
    {
        $user_id = $_POST['user_id'];
        $data = DB::table('transactions')->join('registerusers', 'transactions.refer_id', ' = ', 'registerusers.id')->where('transactions.userid', $user_id)->where('transactions.refer_id', '!=', '0')->get();
        //echo '<pre>'; print_r($data);die;
        $json = array();
        $total_refers = DB::table('registerusers')->where('refer_id', $user_id)->count('id');
        $i = 0;
        foreach ($data as $user) {
            $json[$i]['total_refers'] = $total_refers;
            $json[$i]['name'] = $user->username;
            $json[$i]['email'] = $user->team;
            $json[$i]['Amount'] = $user->addfund_amt;
            $json[$i]['userid'] = $user->id;
            $json[$i]['date'] = date('d M Y', strtotime($user->created));
            $i++;
        }
        echo json_encode($json);
        die;
    }


    public function downloadusers()
    {
        $output1 = "";
        $output1 .= '"User Id",';
        $output1 .= '"Team name",';
        $output1 .= '"Mobile",';
        $output1 .= '"Last Play",';
        $output1 .= '"State",';
        $output1 .= '"Referral Code",';
        $output1 .= '"PAN Uploaded",';
        $output1 .= '"Bank Uploaded",';
        $output1 .= '"PAN Number",';
        $output1 .= '"Bank A/C Num",';
        $output1 .= '"Bank Name",';
        $output1 .= '"Registration Date",';
        $output1 .= "\n";

        // Main query with subqueries
        $query = DB::table('registerusers')
            ->leftJoin(DB::raw('(SELECT userid, MAX(created) as last_play FROM transactions WHERE paymentstatus = "confirmed" AND type = "Challenge Joining Fee" AND transaction_by = "wallet" GROUP BY userid) as last_play'), 'registerusers.id', '=', 'last_play.userid')
            ->leftJoin('pancard', 'registerusers.id', '=', 'pancard.userid')
            ->leftJoin('bank', 'registerusers.id', '=', 'bank.userid')
            ->where('registerusers.is_bot', 0)
            ->select(
                'registerusers.id',
                'registerusers.team',
                'registerusers.mobile',
                'last_play.last_play as created',
                'registerusers.state',
                'registerusers.refercode',
                'registerusers.pan_verify',
                'registerusers.bank_verify',
                'registerusers.created_at',
                'pancard.pan_number',
                'bank.accno',
                'bank.bankname'
            )
            ->orderBy('registerusers.id', 'asc')
            //->limit(10000)
            ->get();

        // Process the results
        foreach ($query as $get) {
            $lastplaydate = isset($get->created) ? $get->created : '';
            $output1 .= '"' . $get->id . '",';
            $output1 .= '"' . $get->team . '",';
            $output1 .= '"' . $get->mobile . '",';
            $output1 .= '"' . $lastplaydate . '",';
            $output1 .= '"' . $get->state . '",';
            $output1 .= '"' . $get->refercode . '",';
            $output1 .= ($get->pan_verify == 1) ? '"Yes",' : '"No",';
            $output1 .= ($get->bank_verify == 1) ? '"Yes",' : '"No",';
            $output1 .= ($get->pan_verify == 1 && !empty($get->pan_number)) ? '"' . $get->pan_number . '",' : '"",';
            if ($get->bank_verify == 1 && !empty($get->accno)) {
                $output1 .= '"' . $get->accno . '",';
                $output1 .= '"' . $get->bankname . '",';
            } else {
                $output1 .= '"",';
                $output1 .= '"",';
            }
            $output1 .= '"' . $get->created_at . '",';
            $output1 .= "\n";
        }

        $filename =  "Details-userwallet.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }


    public function downloadusers_old()
    {
        $output1 = "";
        $output1 .= '"User Id",';
        $output1 .= '"Team name",';
        // $output1 .='"Email Id",';
        // $output1 .='"User Name",';
        // $output1 .='"DOB",';
        $output1 .= '"Mobile",';
        $output1 .= '"Last Play",';
        // $output1 .='"Gender",';
        $output1 .= '"State",';
        $output1 .= '"Referal Code",';
        $output1 .= '"PAN Uploaded",';
        $output1 .= '"Bank Uploaded",';
        $output1 .= '"PAN Number",';
        $output1 .= '"Bank A/C Num",';
        $output1 .= '"Bank Name",';
        // $output1 .='"Bank Branch",';
        $output1 .= "\n";
        $query = DB::table('registerusers')->where('is_bot', 0)->select('id', 'team', 'email', 'username', 'dob', 'mobile', 'gender', 'state', 'refercode', 'pan_verify', 'bank_verify')->orderBY('id', 'asc')->limit(10000)->get();
        /*if(request()->has('name')){
  $name=request('name');
  if($name!=""){
  $query->where('username', 'LIKE', '%'.$name.'%');
}
}
if(request()->has('email')){
$email=request('email');
if($email!=""){
$query->where('email', 'LIKE', '%'.$email.'%');
}
}
$getlist = $query->orderBY('username','ASC')->get();*/
        if (!empty($query)) {
            foreach ($query as $get) {

                $playdate = DB::table('transactions')->where('userid', $get->id)->where('paymentstatus', 'confirmed')->where('type', '=', 'Challenge Joining Fee')->where('transaction_by', 'wallet')->orderby('id', 'desc')->select('created')->first();

                $lastplaydate = isset($playdate->created) ? $playdate->created : '';

                $output1 .= '"' . $get->id . '",';
                $output1 .= '"' . $get->team . '",';
                // $output1 .='"'.$get->email.'",';
                // $output1 .='"'.$get->username.'",';
                // $output1 .='"'.$get->dob.'",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $lastplaydate . '",';
                // $output1 .='"'.$get->gender.'",';
                $output1 .= '"' . $get->state . '",';
                $output1 .= '"' . $get->refercode . '",';
                if ($get->pan_verify == 1) {
                    $output1 .= '"Yes",';
                } else {
                    $output1 .= '"No",';
                }
                if ($get->bank_verify == 1) {
                    $output1 .= '"Yes",';
                } else {
                    $output1 .= '"No",';
                }
                if ($get->pan_verify == 1) {
                    $findpandetails = DB::table('pancard')->where('userid', $get->id)->first();
                    if (!empty($findpandetails)) {
                        $output1 .= '"' . $findpandetails->pan_number . '",';
                    } else {
                        $output1 .= '"",';
                    }
                } else {
                    $output1 .= '"",';
                }
                if ($get->bank_verify == 1) {
                    $findbankdetails = DB::table('bank')->where('userid', $get->id)->first();
                    if (!empty($findbankdetails)) {
                        $output1 .= '"' . $findbankdetails->accno . '",';
                        $output1 .= '"' . $findbankdetails->bankname . '",';
                        // $output1 .='"'.$findbankdetails->bankbranch.'",';
                    } else {
                        $output1 .= '"",';
                        $output1 .= '"",';
                        //  $output1 .='"",';
                    }
                } else {
                    $output1 .= '"",';
                }
                $output1 .= "\n";
            }
        }
        $filename =  "Details-userwallet.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    } //End Function

    public function downloadwithdrawl()
    {
        $output1        = "";
        $output1 .= '"User Id",';
        $output1 .= '"Account Number",';
        $output1 .= '"Withdrawl Amount",';
        $output1 .= '"User Name",';
        $output1 .= '"Withdraw RequestId",';
        $output1 .= '"Bank IFSC Code",';
        $output1 .= '"Bank Name",';
        $output1 .= '"Bank Branch",';
        $output1 .= '"User Email",';
        $output1 .= '"Requested Date",';
        $output1 .= '"Approved Date",';
        $output1 .= '"Admin comment",';
        $output1 .= "\n";
        $query = DB::table('withdraw')->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->join('bank', 'bank.userid', '=', 'registerusers.id')->join('pancard', 'pancard.userid', '=', 'registerusers.id')->where('withdraw.status', '0')->select('registerusers.*', 'bank.*', 'pancard.*', 'withdraw.*', 'registerusers.id as reg_id', 'bank.id as bank_id', 'pancard.id as pan_id', 'withdraw.id as withdraw_id', 'registerusers.activation_status as reg_status', 'bank.status as bank_status', 'pancard.status as pan_status', 'withdraw.status as withdraw_status', 'withdraw.amount as withdraw_amount', 'withdraw.created as withdraw_request');
        if (request()->has('start_date')) {
            $start_date = request('start_date');
            // 			$start_date = date('Y-m-d H:i:s', strtotime('+10 minutes', strtotime(request('start_date'))));
            $start_date =  strtotime(request('start_date'));
            if ($start_date != "") {
                $query->whereDate('withdraw.created', '>=', date('Y-m-d', strtotime($start_date)));
            }
        }
        if (request()->has('end_date')) {
            $end_date = request('end_date');
            if ($end_date != "") {
                $query->whereDate('withdraw.created', '<=', date('Y-m-d', strtotime($end_date)));
            }
        }
        $getlist = $query->orderBY('withdraw.created', 'DESC')->get();
        if (!empty($getlist)) {
            foreach ($getlist as $get) {
                $output1 .= '"' . $get->reg_id . '",';
                $output1 .= "'" . $get->accno . ",";
                $output1 .= '"' . $get->withdraw_amount . '",';
                $output1 .= '"' . strtoupper($get->username) . '",';
                $output1 .= '"' . $get->withdraw_request_id . '",';
                $output1 .= '"' . strtoupper($get->ifsc) . '",';
                $output1 .= '"' . strtoupper($get->bankname) . '",';
                $output1 .= '"' . strtoupper($get->bankbranch) . '",';
                $output1 .= '"' . $get->email . '",';
                $output1 .= '"' . date('d-M-Y', strtotime($get->withdraw_request)) . '",';
                $output1 .= '"",';
                $output1 .= '"",';
                $output1 .= "\n";
            }
        }
        $filename =  "Details-userwithdrawl.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    public function downloadwithdrawl1()
    {
        require_once("./phpexcel/PHPExcel.php");
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('My sales report');
        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A1:L1')->getFont()->setBold(true)->setSize(12);

        // write header
        $objSheet->getCell('A1')->setValue('Sno');
        $objSheet->getCell('B1')->setValue('User id');
        $objSheet->getCell('C1')->setValue('User Name');
        $objSheet->getCell('D1')->setValue('Total Amount');
        $objSheet->getCell('E1')->setValue('Due Amount');
        $objSheet->getCell('F1')->setValue('Complete Amount');
        $objSheet->getCell('G1')->setValue('Account No.');
        $objSheet->getCell('H1')->setValue('IFSC Code');
        // we could get this data from database, but here we are writing for simplicity
    }


    public function approvepaytm(Request $request) {}

    public function paytm_withdraw_cron()
    {

        // exit;
        require_once base_path() . '/PaytmKit/lib/encdec_paytm.php';
        $environment    = "TEST";
        $find_withdraw = DB::table('withdraw')->where('status', 9)->where('type', 'bank')->get();
        // print_r($find_withdraw); exit;
        foreach ($find_withdraw as $withdraw) {

            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $withdraw->id)->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.mobile', 'registerusers.team', 'withdraw_request_id')->first();

            $bank = DB::table('bank')->where('userid', $withdraw->user_id)->first();


            $mid = strtoupper(BRAND['name']) . '176599464839523';
            //old ROYAL44488145458701
            $key = 'l8w_nj9X0_gR%wfQ';
            //old eTSrzO!57240#jOf
            $orderId = $finduserdetails->withdraw_request_id;
            // $orderId = 'ROYAL-ORDER-007';
            $subwalletGuid = '1ea37e26-a2e7-428f-8c00-5c80ba48158c';
            //old f13636d7-cb68-47e6-bfcb-1365830815d8
            // $beneficiaryAccount = '7777777777';
            // $beneficiaryAccount = '34137001075';
            $beneficiaryAccount = $bank->accno;
            $amount = $withdraw->amount;
            // $amount = 10;
            $beneficiaryIFSC = $bank->ifsc;
            $purpose = "BONUS";


            $paramList = array();

            $paramList["orderId"]            = $orderId;
            $paramList["subwalletGuid"]      = $subwalletGuid;
            $paramList["amount"]             = $amount;
            // $paramList["beneficiaryPhoneNo"] = $beneficiaryAccount;
            $paramList["beneficiaryAccount"] = $beneficiaryAccount;
            // $paramList["pendingDaysLimit"] = "0";
            $paramList["beneficiaryIFSC"]    = $beneficiaryIFSC;
            $paramList["purpose"]            = $purpose;
            $paramList["callbackUrl"]        = "https://paytm.com/test/";

            $body = json_encode($paramList, true);

            // echo $body;

            $Checksumhash = getChecksumFromString($body, $key);

            // print_r($body);
            // print_r($Checksumhash);
            // exit;

            $header = array('Content-Type:application/json', 'x-mid:' . $mid, 'x-checksum:' . $Checksumhash);

            $url = "https://dashboard.paytm.com/bpay/api/v1/disburse/order/bank";
            // $url = "https://staging-dashboard.paytm.com/bpay/api/v1/disburse/order/wallet/gratification";
            // $url ='https://staging-dashboard.paytm.com/bpay/api/v1/disburse/order/bank';

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "x-mid: " . $mid, "x-checksum: " . $Checksumhash));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            //print_r($response); exit;
            $data = json_decode($response, true);
            // print_r($data); exit;
            // return $data;
            if ($data['status'] == 'ACCEPTED') {
                $data1['status'] = 8;
                DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
            } else {
                $data1['status'] = 0;
                DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
            }
        }
    } //End

    public function paytm_wallet_withdraw_cron()
    {
        // exit;
        require_once base_path() . '/PaytmKit/lib/paytm_checksum.php';
        $environment    = "PROD";
        $find_withdraw = DB::table('withdraw')->where('status', 9)
            // ->where('id', 547)
            ->where('type', 'paytm')->get();
        // print_r($find_withdraw); exit;
        foreach ($find_withdraw as $withdraw) {

            $finduserdetails = DB::table('withdraw')->where('withdraw.id', $withdraw->id)->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.mobile', 'registerusers.team', 'withdraw_request_id')->first();

            $bank = DB::table('bank')->where('userid', $withdraw->user_id)->first();


            // $mid = "ROYAL02462304741738";
            // $key = "s6NZUr1Q3tI8GLyx";
            $orderId = $finduserdetails->withdraw_request_id . '_1209';
            // $orderId = 'Royal-ORDER-007';
            // $subwalletGuid = "3aca70fb-2979-4699-9741-af78a8d7ca31";

            // $subwalletGuid = "3aca70fb-2979-4699-9741-af78a8d7ca31";
            $mid = BRAND['name'] . "176599464839523";
            $key = "l8w_nj9X0_gR%wfQ";
            // $orderId = $finduserdetails->withdraw_request_id.'_0609';
            // $orderId = 'ROYAL-ORDER-007';
            $subwalletGuid = "1ea37e26-a2e7-428f-8c00-5c80ba48158c";

            // $beneficiaryAccount = '7777777777';
            // $beneficiaryAccount = '34137001075';
            $beneficiaryAccount = $finduserdetails->mobile;
            // $amount = number_format($withdraw->amount,2);
            $amount = number_format((float)$withdraw->amount, 2, '.', '');
            // $amount = 10;
            // $beneficiaryIFSC =$bank->ifsc;
            $purpose = "BONUS";


            $paramList = array();

            $paramList["orderId"]            = $orderId;
            $paramList["subwalletGuid"]      = $subwalletGuid;
            $paramList["amount"]             = $amount;
            $paramList["beneficiaryPhoneNo"] = $beneficiaryAccount;
            // $paramList["beneficiaryAccount"] = $beneficiaryAccount;
            // $paramList["pendingDaysLimit"] = "0";
            // $paramList["beneficiaryIFSC"]    = $beneficiaryIFSC;
            $paramList["purpose"]            = $purpose;
            $paramList["callbackUrl"]        = "https://paytm.com/test/";

            $body = json_encode($paramList, true);

            // echo $body;

            $Checksumhash = generateSignature($body, $key);

            print_r($body);
            // print_r($Checksumhash);
            // exit;

            $header = array('Content-Type:application/json', 'x-mid:' . $mid, 'x-checksum:' . $Checksumhash);

            $url = "https://dashboard.paytm.com/bpay/api/v1/disburse/order/wallet/gratification";
            // $url = "https://staging-dashboard.paytm.com/bpay/api/v1/disburse/order/wallet/gratification";
            // $url ='https://staging-dashboard.paytm.com/bpay/api/v1/disburse/order/bank';

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "x-mid: " . $mid, "x-checksum: " . $Checksumhash));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            // if($withdraw->user_id == 4590){
            // print_r($response);
            // exit;
            // }
            $data = json_decode($response, true);
            // return $data;
            if ($data['status'] == 'ACCEPTED') {
                $data1['status'] = 8;
                DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
            } else {
                $data1['status'] = 0;
                DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
            }
            // print_r($data); exit;

        }
    } //End


    public function paytm_check_withdraw()
    {
        require_once base_path() . '/PaytmKit/lib/encdec_paytm.php';
        $environment    = "PROD";

        $mid = BRAND['name'] . "02462304741738";
        $key = "s6NZUr1Q3tI8GLyx";

        // $orderId = 'Royal-ORDER-007';
        $subwalletGuid = "3aca70fb-2979-4699-9741-af78a8d7ca31";
        $mid = BRAND['name'] . "176599464839523";
        $key = "l8w_nj9X0_gR%wfQ";
        // $orderId = $finduserdetails->withdraw_request_id.'_0609';
        $orderId = strtoupper(BRAND['name']) . '-ORDER-007';
        $subwalletGuid = "1ea37e26-a2e7-428f-8c00-5c80ba48158c";
        // $beneficiaryAccount = '7777777777';

        // $mid = "ROYAL44488145458701";
        // $key = "eTSrzO!57240#jOf";
        // $orderId = "ROYAL-ORDER-007";
        // $subwalletGuid = "37956fa9-69d3-11ea-8708-fa163e429e83";
        $beneficiaryAccount = "7777777777";
        $amount = 10;
        $beneficiaryIFSC = "PYTM0123456";
        $purpose = "BONUS";

        $finduserdetails = DB::table('withdraw')->where('withdraw.status', 8)
            ->join('registerusers', 'registerusers.id', '=', 'withdraw.user_id')->select('user_id', 'registerusers.email', 'registerusers.team', 'withdraw_request_id', 'withdraw.id', 'withdraw.type')->get();
        // print_r($finduserdetails); exit;
        foreach ($finduserdetails as $key1 => $value) {
            $data1 = array();
            $tdata = array();
            $paramList = array();

            if ($value->type == 'paytm') {
                $paramList["orderId"]            = $value->withdraw_request_id . '_1209';
            } else {
                $paramList["orderId"]            = $value->withdraw_request_id;
            }
            // $paramList["orderId"]            = $orderId;
            // var_dump($paramList["orderId"]);exit;
            // $paramList["orderId"]            = 'WD-652042-88542';
            // print_r($paramList); exit;
            $body = json_encode($paramList, true);

            $Checksumhash = getChecksumFromString($body, $key);

            $header = array('Content-Type:application/json', 'x-mid:' . $mid, 'x-checksum:' . $Checksumhash);


            $url = "https://dashboard.paytm.com/bpay/api/v1/disburse/order/query";
            // $url = "https://staging-dashboard.paytm.com/bpay/api/v1/disburse/order/query";
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // return the output in string format
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
            $output = curl_exec($ch); // execute
            $info = curl_getinfo($ch);
            $data = json_decode($output, true);
            // if($value->user_id == 1413){
            // 	print_r($output); exit;
            // }
            // print_r($data);
            if ($data['status'] == 'SUCCESS') {
                $data1['status'] = 1;
                $rowCOllection = DB::table('withdraw')->where('id', $value->id)->update($data1);
                // echo 1; exit;
                $findtransactiondate = DB::table('transactions')->where('transaction_id', $value->withdraw_request_id)->first();
                $tdata['paymentstatus'] = 'Confirmed';
                // $tdata['created'] = $findtransactiondate->created;
                $findtransactiondetails  = DB::table('transactions')->where('transaction_id', $value->withdraw_request_id)->update($tdata);

                $notificationdata['userid'] = $value->user_id;

                $titleget = 'Withdrawl Request Approved!';
            } else if ($data['status'] == 'FAILURE') {
                $data1['status'] = 0;
                $rowCOllection = DB::table('withdraw')->where('id', $value->id)->update($data1);
            }
            // exit;


        }
    }

    public function failedTransactions()
    {
        $allplayers = DB::table('paytm_transactions')->where('status', 0)->paginate(10);
        return view('registerusers.failed_transaction', compact('allplayers'));
    }

    //View user use refercode list
    public function user_use_refercode_list($refer_id = null)
    {
        //print_r($refer_id);die;
        $getlist = DB::table('registerusers')->where('refer_id', $refer_id)->orderBY('id', 'DESC')->get();
        return view('registerusers.user_use_refercode_list', compact('getlist'));
    }
    //View user refercode list view
    public function refercode_list_view($user_id = null)
    {
        $getlist = DB::table('league_refer_bonus')->where('user_id', $user_id)->orderBY('id', 'DESC')->limit(10)->get();
        return view('registerusers.refercode_list_view', compact('getlist'));
    } //End Function

    public  function userbalancesdetail()
    {
        //Get Post Data
        $formData = Input::all();
        $user_balance = DB::table('userbalances')->where('id', $formData['user_balance_id'])->first();
        $balance = $user_balance->balance + $formData['balance'];
        $winning = $user_balance->winning + $formData['winning'];
        $bonus = $user_balance->bonus + $formData['bonus'];
        //Update Amount
        $update_amount['balance'] = $balance;
        $update_amount['winning'] = $winning;
        $update_amount['bonus'] = $bonus;
        DB::table('userbalances')->where('id', $formData['user_balance_id'])->update($update_amount);
        //Insert Transactions Tablae
        $user_tranasation = DB::table('transactions')->where('id', $formData['user_tranasation_id'])->first();
        if (!is_null($user_tranasation)) {
            //Update Amount Transactions Tablae
            $tranasation_amount['bal_fund_amt'] = $user_tranasation->bal_fund_amt + $formData['balance'];
            $tranasation_amount['bal_win_amt'] = $user_tranasation->bal_win_amt + $formData['winning'];
            $tranasation_amount['bal_bonus_amt'] = $user_tranasation->bal_bonus_amt + $formData['bonus'];
            DB::table('transactions')->where('id', $formData['user_tranasation_id'])->update($tranasation_amount);
            Session::flash('flash_notice', 'Add Amount successfully!');
        } else {
            $tranasation_amount['bal_fund_amt'] = $formData['balance'];
            $tranasation_amount['bal_win_amt'] = $formData['winning'];
            $tranasation_amount['bal_bonus_amt'] = $formData['bonus'];
            DB::table('transactions')->insert($tranasation_amount);
            Session::flash('flash_notice', 'Add Amount successfully!');
        }
        //Go Back
        return Redirect::back();
    }

    public function addPaytmBen($userid)
    {
        // echo 1; exit;
        if (Helpers::add_paytm_beneficary($userid)) {
            // echo 1; exit;
            Session::flash('flash_notice', 'Ben Added successfully!');
        } else {
            Session::flash('flash_notice', 'There is some error!');
        }
        return Redirect::back();
    }

    public function addBankBaneId($userid)
    {
        $return = Helpers::cf_add_benificary($userid);
        // echo "$return";exit();
        if ($return === true) {
            Session::flash('flash_notice', 'Bane Id Added successfully!');
        } else {
            Session::flash('flash_notice', $return);
        }
        return Redirect::back();
    }


    public function uploadExcel()
    {

        $path = base_path() . '/user_report.csv';
        $file = fopen($path, "r");
        $i = 0;
        $insert = array();
        while (! feof($file)) {
            $columns = fgetcsv($file);
            // print_r($columns); exit;
            /*if($i==1000) {
    continue;
  }*/
            if ($columns[0] == 'UserId') {
                continue;
            } else {
                if (!empty($columns[3]) || !empty($columns[4])) {
                    $email = $columns[3];
                    $mobile = $columns[4];

                    if (!empty($columns[3])) {
                        $find_user = DB::table('registerusers')->where('email', $email)->first();
                        if (empty($find_user)) {
                            $find_user_mobile = DB::table('registerusers')->where('mobile', $mobile)->first();
                            if (empty($find_user_mobile)) {
                                $insert['email'] = $columns[3];
                                $insert['username'] = $columns[2];
                                $insert['mobile'] = $columns[4];
                                $insert['import'] = 1;
                                $user_id = DB::table('registerusers')->insertGetId($insert);
                                $insertBalance['balance'] = $columns[14];
                                $insertBalance['winning'] = $columns[15];
                                $insertBalance['bonus'] = $columns[16];
                                $insertBalance['user_id'] = $user_id;
                                DB::table('userbalances')->insertGetId($insertBalance);
                                $i++;
                            }
                        }
                    }


                    /*
      $orderid = $columns[1];
      $amount= $columns[13];
      $email= $columns[12];
      $email= str_replace("'", "", $columns[12]);
      echo $amount; echo '<br>';
      $orderid = str_replace("'", "", $orderid);
      $findTrans = DB::table('transactions')->where('transaction_id',$orderid)->first();
      if(empty($findTrans)) {
      $user = DB::table('registerusers')->where('email', $email)->first();
      // print_r($user);
      $userid = @$user->id;
      if(!empty($userid)) {
      $user_balance = DB::table('userbalances')->where('user_id',$userid)->first();
      $update['balance'] = $user_balance->balance+$amount;
      print_r($update);
      // DB::table('userbalances')->where('user_id', $userid)->update($update);
      $trans_update = array();
      $trans_update['paymentstatus'] = 'confirmed';
      print_r($trans_update);
      // DB::table('transactions')->where('id', $findTrans->userid)->update($trans_update);
    }
  }
  */
                }
            }
        }
        if (!empty($insert)) {

            print_r($insert);
            exit;
        }
        exit;
    }

    public function paytm_notify(Request $request)
    {


        $myfile = fopen("paytm_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($_REQUEST) . "John Doe\n";
        fwrite($myfile, $txt);

        $orderId = $request->ORDERID;
        $txnid = $request->ORDERID;
        fclose($myfile);

        if ($request->STATUS == 'TXN_SUCCESS') {
            $orderId = $request->ORDERID;
            if ($orderId != '') {
                $trans = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();
                if (!empty($trans)) {
                    DB::table('transactions')->where('id', $trans->id)->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->update(array("paymentstatus" => "confirmed"));
                    $user_id = $getdata['userid'] = $trans->userid;
                    $amount = $request->TXNAMOUNT;
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();


                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();


                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";
                    if (!empty($promo) && $promo->status == 0) {
                        $promocode = $promo->promo_code;
                        $bonusAmount = 0;
                        if ($promocode != "") {
                            $valid_promo = 0;
                            $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $amount)->where('maxamount', '>=', $amount)->where('status', 1)->first();
                            //check first deposit
                            if (!empty($offers->first_deposit) && $offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // end check first deposit
                            // foreach($offers as $o){
                            if (!empty($offers)) {

                                $valid_promo = 1;
                                $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {
                                    $bonusAmount = $bonusAmount1;
                                } else {
                                    $bonusAmount = (($amount * $bonusAmount1) / 100);
                                }
                                // if(!empty($used))
                                //     $bonusAmount= 0;
                            }
                            if ($bonusAmount) {
                                $usedoffer['offer_id'] = $promocode;
                                $usedoffer['user_id'] = $user_id;
                                DB::table('usedoffers')->insert($usedoffer);
                                DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                            }
                        }
                    }


                    // if(!empty($promo) && $promo->status==0 && strtolower($promo->promo_code)=='real100') {

                    // /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                    // if($countFund == 1) {
                    // if($amount>=1 && $amount<=1000) {
                    // $bonusAmount = $amount;
                    // }
                    // }
                    // /* Check first time bonus */

                    // }

                    /* Check first time bonus */
                    /*$countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->count();
        if($countFund == 1) {
        if($amount>=100) {
        $bonusAmount = $amount;
      }
    }*/
                    /* Check first time bonus */

                    /* Bonus Credit */
                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;
                            if ($promocode != '' && ($promocode == '15AUG' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')) {


                                $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            } else {
                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            }

                            // $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 1) //check for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund (Valid for 30 days)';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'cashfree';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                            if ($first_deposit == 0) //check for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Bonus */




                    //referral bonus refferal
                    if (1) {

                        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();

                        if (empty($check_exist_referral)) {

                            //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                            if (1) {

                                $user_self = RegisterUser::where('id', $user_id)->first();
                                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                if (!empty($user_self) && !empty($user_referrer)) {
                                    // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                    $user_self_id = $user_self->id;
                                    $user_referrer_id = $user_referrer->id;
                                    ReferralBonus::create([
                                        'user_id' => $user_self_id,
                                        'refer_id' => $user_referrer_id,
                                        'amount' => $share_amount
                                    ]);

                                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                    $user_balance_self->bonus += $share_amount;
                                    $user_balance_referrer->bonus += $share_amount;

                                    //check for minimum add fund amount for referral bonus
                                    if ($request->TXNAMOUNT <= 500) {
                                        $user_balance_self->save();
                                        $user_balance_referrer->save();
                                    }


                                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance;
                                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance;

                                    // echo 1; exit;

                                    $rand1 = rand(100000, 999999);
                                    $rand2 = rand(100000, 999999);

                                    // ENTRY FOR SELF USER
                                    //check for minimum add fund amount for referral bonus
                                    if ($request->TXNAMOUNT >= 50) {
                                        $self_array = [
                                            'userid' => $user_self_id,
                                            'refer_id' => $user_referrer_id,
                                            'type' => 'Referral Bonus (Valid for 30 days)',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => strtoupper(BRAND['name']),
                                            'amount' => $share_amount,
                                            'addfund_amt' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'bal_bonus_amt' => $user_balance_self->bonus,
                                            'bal_win_amt' => $user_balance_self->winning,
                                            'bal_fund_amt' => $user_balance_self->balance,
                                            'total_available_amt' => $total_balance_self,
                                        ];

                                        Transaction::create($self_array);


                                        // ENTRY FOR REFERRER USER
                                        Transaction::create([
                                            'userid' => $user_referrer_id,
                                            'refer_id' => $user_self_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => strtoupper(BRAND['name']),
                                            'amount' => $share_amount,
                                            'paymentstatus' => 'confirmed',
                                            'addfund_amt' => $share_amount,
                                            'bal_bonus_amt' => $user_balance_referrer->bonus,
                                            'bal_win_amt' => $user_balance_referrer->winning,
                                            'bal_fund_amt' => $user_balance_referrer->balance,
                                            'total_available_amt' => $total_balance_referrer,
                                        ]);
                                    }
                                }
                            }
                        }
                    }

                    //end code refferal
                    ////   DEPOSIT REFERRAL BONUS 3%  ////
                    //   if (1) {
                    //     $check_exist_referral = ReferralBonus::where('user_id',$user_id)->first();
                    //     if (empty($check_exist_referral)) {
                    //       $user_self = RegisterUser::where('id',$user_id)->first();
                    //     $user_referrer = RegisterUser::where('id',$user_self->refer_id)->first();

                    //     if (!empty($user_self) && !empty($user_referrer)) {
                    //     $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;

                    //     $user_self_id = $user_self->id;
                    //     $user_referrer_id = $user_referrer->id;
                    //     ReferralBonus::create([
                    //       'user_id' => $user_self_id,
                    //       'refer_id' => $user_referrer_id,
                    //       'amount' => $share_amount
                    //     ]);

                    // $user_balance_self = UserBalance::where('user_id',$user_self_id)->first();
                    // $user_balance_referrer = UserBalance::where('user_id',$user_referrer_id)->first();


                    // $user_balance_self->balance += $share_amount;
                    // $user_balance_referrer->balance += $share_amount;

                    // $user_balance_self->save();
                    // $user_balance_referrer->save();


                    // $total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;
                    // $total_balance_referrer = $user_balance_referrer->bonus+$user_balance_referrer->winning+$user_balance_referrer->balance;

                    // // echo 1; exit;

                    // $rand1 = rand(100000,999999);
                    // $rand2 = rand(100000,999999);

                    // // ENTRY FOR SELF USER
                    // $self_array = [
                    //   'userid' => $user_self_id,
                    //   'refer_id' => $user_referrer_id,
                    //   'type' => 'Deposit Refer Bonus',
                    //   'transaction_id' => 'RFR-DPST-'.$rand1,
                    //   'transaction_by' => 'Royal11',
                    //   'amount' => $share_amount,
                    //   'addfund_amt' => $share_amount,
                    //   'paymentstatus' => 'Confirmed',
                    //   'bal_bonus_amt' => $user_balance_self->bonus,
                    //   'bal_win_amt' => $user_balance_self->winning,
                    //   'bal_fund_amt' => $user_balance_self->balance,
                    //   'total_available_amt' => $total_balance_self,
                    // ];
                    // // print_r($self_array); exit;
                    // Transaction::create($self_array);


                    // // ENTRY FOR REFERRER USER
                    // Transaction::create([
                    //   'userid' => $user_referrer_id,
                    //   'refer_id' => $user_self_id,
                    //   'type' => 'Deposit Refer Bonus',
                    //   'transaction_id' => 'RFR-DPST-'.$rand1,
                    //   'transaction_by' => 'Royal11',
                    //   'amount' => $share_amount,
                    //    'paymentstatus' => 'confirmed',
                    //   'addfund_amt' => $share_amount,
                    //   'bal_bonus_amt' => $user_balance_referrer->bonus,
                    //   'bal_win_amt' => $user_balance_referrer->winning,
                    //   'bal_fund_amt' => $user_balance_referrer->balance,
                    //   'total_available_amt' => $total_balance_referrer,
                    // ]);
                    //     }

                    //     }


                    //   }

                    ////   DEPOSIT REFERRAL BONUS 3%  ////



                    if (!empty($referdata)) {
                        if (!empty($referid) || $referid != 0) {
                            $bal_bonus_amt = 0;
                            $bal_win_amt = 0;
                            $bal_fund_amt = 0;
                            $total_available_amt = 0;
                            $bal_bonus_amt = $userBalanceReffred->bonus;
                            $bal_win_amt = $userBalanceReffred->winning;
                            $bal_fund_amt = $userBalanceReffred->balance;
                            $total_available_amt = $bal_bonus_amt + $bal_win_amt + $bal_fund_amt;
                            // $bonus = DB::table('bonus_amount')->where('type',"Add Fund Bonus")->first();
                            // $bonus_type = $bonus->bonus_type;
                            // $price = $bonus->price;
                            //   echo '<pre>';print_r($userBalance);die;
                            if (!empty($userBalance)) {
                                // if($bonus_type == 'amount'){
                                //     $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+$price;
                                //     $amount_added = $price;
                                // }else{
                                //     $balance_refer=$datainseertt['balance'] = $userBalanceReffred->balance+(($amount * $price)/100);
                                //     $amount_added = (($amount * $price)/100);
                                // }
                                /*
          $dataInsert['amount'] = $amount_added;
          $dataInsert['user_id'] = $user_id;
          $dataInsert['refered_by'] = $referid;
          DB::table('refer_bonus')->insert($dataInsert);*/
                            }
                            $total_available_amt = $total_available_amt;
                            // $total_available_amt = $total_available_amt+$balance_refer;
                            $datainseertt['user_id'] = $referid;
                            //echo '<pre>'; print_r($datainseertt); die;
                            // DB::table('userbalances')->where('user_id',$referid)->update($datainseertt);
                            // $notificationdata['userid'] = $referid;
                            // 			$notificationdata['title'] = 'Add Fund of ₹ '.$amount_added.' for refer.';
                            // 			DB::table('notifications')->insert($notificationdata);
                            // 			//push notifications//
                            // 			$titleget = 'Add fund successfully!';
                            // 			Helpers::sendnotification($titleget,$notificationdata['title'],'',$referid);
                            // $txnid = 'fantasypower11-'.rand(1000,9999).''.$getdata['userid'];
                            //    $transactionsdata_refer['userid'] = $referid;
                            //     		$transactionsdata_refer['type'] = 'Add Fund Refer Bonus';
                            //     		$transactionsdata_refer['refer_id'] = $user_id;
                            //     		// $transactionsdata_refer['paytid'] = $orderId;
                            //     		$transactionsdata_refer['transaction_id'] = $txnid;
                            //     		$transactionsdata_refer['transaction_by'] = 'paytm';
                            //     		$transactionsdata_refer['amount'] = $amount_added;
                            //     		$transactionsdata_refer['addfund_amt'] = $amount_added;
                            //     		$transactionsdata_refer['paymentstatus'] = 'confirmed';
                            //     		$transactionsdata_refer['bal_fund_amt'] = $balance_refer;
                            //     		$transactionsdata_refer['bal_win_amt'] = $bal_win_amt;
                            //     		$transactionsdata_refer['bal_bonus_amt'] = $bal_bonus_amt;
                            //     		$transactionsdata_refer['cons_amount'] = $amount;
                            //     		$transactionsdata_refer['total_available_amt'] = $total_available_amt; //print_r($transactionsdata_refer); exit;
                            //     		DB::table('transactions')->insert($transactionsdata_refer);
                        }
                    }
                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                    }
                    $bal_bonus_amt = 0;
                    $bal_win_amt = 0;
                    $bal_fund_amt = 0;
                    $total_available_amt = 0;
                    $findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
                        $bal_fund_amt = $findlastow->balance;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                    }
                    //push notifications//
                    $titleget = 'Add fund successfully!';
                    $notificationdata['title'] = 'Add fund of ' . $amount . ' is successful';
                    Helpers::sendnotification($titleget, $notificationdata['title'], '', $getdata['userid']);
                    $transactionsdata['userid'] = $user_id;
                    $transactionsdata['type'] = 'Add Fund';
                    $transactionsdata['transaction_id'] = $txnid;
                    $transactionsdata['transaction_by'] = 'paytm';
                    $transactionsdata['amount'] = $amount;
                    $transactionsdata['addfund_amt'] = $amount;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['cons_amount'] = $amount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;
                    DB::table('transactions')->where('paytid', $orderId)->update($transactionsdata);
                    $notificationdata['userid'] = $user_id;
                    $notificationdata['title'] = 'Add Fund of ₹ ' . $amount . ' through paytm';
                    DB::table('notifications')->insert($notificationdata);
                }
            }
        }
        echo json_encode(array("status" => "OK"));
        exit;
    }
    public function phonepay_notify(Request $request)
    {
        // \Log::info("phonepay_notify: ". json_encode($request->all()));
        date_default_timezone_set('Asia/Kolkata');
        $headers = $request->header();

        $result =  base64_decode($request['response']);
        $finalresult = json_decode($result);
        //\Log::info("phonepay_notify: ". json_encode($finalresult));
        // $myfile = fopen("phonepay_notify.txt", "a") or die("Unable to open file!");
        // $txt = json_encode($finalresult)."John Does\n";
        // fwrite($myfile, $txt);
        // fclose($myfile);
        //  echo '<pre>'; print_r( $finalresult);exit;
        $orderId = $txnid = $finalresult->data->merchantTransactionId;
        $orderAmount =  ($finalresult->data->amount) / 100;
        $txStatus = $finalresult->data->responseCode;
        $paymentStatus = $finalresult->code;
        $paymentId =  $finalresult->data->transactionId;
        //$paymentmode = $request['transaction']['payment_mode'];
        $GST_ORDER_ID = 'GST-' . $orderId;
        $signature = '';

        $amount = $orderAmount;
        $TotalOrderAmount  = $orderAmount;
        $add_Fund     = round(($orderAmount / 128) * 100, 2);
        $GSTAmount    = round($orderAmount - $add_Fund, 2);
        $OrderAmount = $add_Fund;

        if (1) {
            if ($paymentStatus == 'PAYMENT_SUCCESS') {
                $add_fund_respose = array(
                    "transaction_id" => $orderId,
                    "sonicpay_id" => $paymentId,
                    "amount" => $orderAmount,
                    "sonic_status" => $txStatus,
                    "Response" => json_encode($request->all()),
                );
                try {
                    DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                    exit;
                }

                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                if (!empty($transaction_row)) {
                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    if (empty($userBalance1)) {
                        DB::table('userbalances')->insert(['user_id' => $transaction_row->userid]);
                    }
                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();

                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'phonepay_id' => $paymentId,
                        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                        'bal_bonus_amt' => $userBalance1->bonus,
                        'bal_win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'bal_affi_amt' => $userBalance1->affiliation_commission,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                    //TDS Calculation
                    // $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }
                    $amount = $orderAmount;
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($orderAmount - $add_Fund, 2);
                    $gstamount =  $GSTAmount;

                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount
                        ]);

                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();

                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            //$trans->insert($ins_tran);
                        }
                    }

                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        //  if($add_Fund>=1 && $add_Fund>=5000) {
                        // if($amount>=1 && $amount>=5000) {
                        //   $bonusAmount = 5000;
                        // }
                        if ($amount >= 1 && $amount >= 500) {
                            $bonusAmount = 500;
                        } elseif ($amount >= 1 && $amount < 500) {
                            $bonusAmount = $transaction_row->amount;
                        }
                    }

                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                            $new_bal_affi_amt = $finduser_bal->affiliation_commission;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;

                            $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;

                            // if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || @$offers->btype == 'deposit')){
                            //   $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
                            // }else{
                            //   $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
                            // }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . 'BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount;
                            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                            $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $bonusAmount;
                            //print_r($newtransactionsdata); exit;

                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Balance */
                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();

                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount = $GSTAmount;
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;

                            $bal_fund_amt = $findlastow->balance - $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsdata['userid'] = $user_id;
                        $transactionsdata['paymentstatus'] = 'confirmed';
                        $transactionsdata['type'] = 'GST Deduction as per new government rule';
                        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                        $transactionsdata['transaction_by'] = 'wallet';
                        $transactionsdata['amount'] = $gstamount;
                        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsdata['bal_win_amt'] = $bal_win_amt;
                        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsdata['cons_amount'] = $gstamount;
                        $transactionsdata['total_available_amt'] = $total_available_amt;

                        DB::table('transactions')->insert($transactionsdata);

                        $datainseert['balance'] = $findlastow->balance - $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        //GST Report
                        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                        $igst = 0;
                        $cgst = 0;
                        $sgst = 0;
                        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                            $igst = 0;
                            $cgst = $gstamount;
                            $sgst = $gstamount;
                        } else {
                            $igst = $gstamount;
                            $cgst = 0;
                            $sgst = 0;
                        }
                        $GST_entry = array(
                            //"league_tran_id"=>$user_id.rand(11,999),
                            "user_id" => $user_id,
                            "deposit_amount" => $amount,
                            "gst_amount" => $gstamount,
                            "wallet_amount" => $amount,
                            "order_id" => $paymentId,
                            "transaction_id" => $transaction_row->id,
                            //"transaction_id"=>$user_id.time().rand(11,99),
                            // "state"=> $user_data->state,
                            "igst" => $igst,
                            "cgst" => $cgst,
                            "sgst" =>  $sgst,
                            "transaction_by" => 'PHONEPAY',
                            "ip" => @$transaction_row->ip,
                            "transactions_date" => date('Y-m-d H:i:s'),
                            "state" => @$transaction_row->state,
                        );
                        DB::table('deposit_gst')->insert($GST_entry);

                        //GST Rebat
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                            $bal_fund_amt = $findlastow->balance + $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsgstrebat['userid'] = $user_id;
                        $transactionsgstrebat['paymentstatus'] = 'confirmed';
                        $transactionsgstrebat['type'] = 'GST Bonus rebate from PLAYNWIN11';
                        $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                        $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                        $transactionsgstrebat['amount'] = $gstamount;
                        $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                        $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsgstrebat['addfund_amt'] = $gstamount;
                        // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                        $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsgstrebat);

                        //$datainseert['balance'] = $findlastow->balance+$gstamount;
                        $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                    }


                    //Offer Promo code//

                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;

                        $offerAmount = 0;
                        $bonustype = "";
                        if ($promocode != "") {
                            // $offers= DB::table('offers')
                            //   ->where('code',$promocode)
                            //   ->where('minamount','<=', $amount)
                            //   ->where('maxamount','>=', $amount)
                            //   ->where('expire_date','>=', date('Y-m-d H:i:s'))
                            //   ->where('status', 1)
                            //   ->first();

                            $offers = DB::table('offers')
                                ->leftjoin('offer_csv_users', 'offers.id', '=', 'offer_csv_users.offer_id')
                                ->where('offers.code', $promocode)
                                ->where('offers.minamount', '<=', $amount)
                                ->where('offers.maxamount', '>=', $amount)
                                ->where('offers.status', 1)
                                ->where('offers.expire_date', '>=', date('Y-m-d H:i:s'))
                                ->where(function ($query) use ($user_id) {
                                    $query->where(function ($q) use ($user_id) {
                                        $q->where('offers.is_for_all', 0)
                                            ->where('offer_csv_users.user_id', $user_id);
                                    })
                                        ->orWhere('offers.is_for_all', 1);
                                })
                                ->first();


                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            $used = DB::table('user_promo')->where('promo_code', $promocode)->where('user_id', $user_id)->where('status', 1)->count();

                            if (!empty($offers) && $offers->per_user_count <= $used) {

                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {

                                    $offerAmount = $bonusAmount1;
                                } else {
                                    $offerAmount = (($amount * $bonusAmount1) / 100);
                                }
                                if ($offers->btype == 'deposit') {
                                    $bonustype = 'Amount';
                                } else {
                                    $bonustype = 'Bonus';
                                }

                                if ($offerAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1, 'amount' => $offerAmount, 'bonustype' => $bonustype));
                                }
                            }
                        }


                        if ($offerAmount != 0) {
                            // find balance details //
                            $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                            if (!empty($finduser_bal)) {
                                $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                                $new_bal_fund_amt = $finduser_bal->balance;
                                $new_bal_win_amt = $finduser_bal->winning;
                                $new_bal_bonus_amt = $finduser_bal->bonus;
                                $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                                $new_bal_affi_amt = $finduser_bal->affiliation_commission;

                                $bonusAmount_balance = 0;
                                $bonusAmount_winning = 0;
                                $bonusAmount_bonus = 0;
                                $bonusAmount_gst_bonus = 0;
                                $bonusAmount_affiliation_commission = 0;



                                if ($offers->btype == 'balance' || $offers->btype == 'deposit') {
                                    $datainseert2['balance'] = $finduser_bal->balance + $offerAmount;
                                    $bonusAmount_balance = $offerAmount;
                                } elseif ($offers->btype == 'winning') {
                                    $datainseert2['winning'] = $finduser_bal->winning + $offerAmount;
                                    $bonusAmount_winning = $offerAmount;
                                } elseif ($offers->btype == 'bonus') {
                                    $datainseert2['bonus'] = $finduser_bal->bonus + $offerAmount;
                                    $bonusAmount_bonus = $offerAmount;
                                } elseif ($offers->btype == 'gst_bonus') {
                                    $datainseert2['gst_bonus'] = $finduser_bal->gst_bonus + $offerAmount;
                                    $bonusAmount_gst_bonus = $offerAmount;
                                } elseif ($offers->btype == 'affiliation_commission') {
                                    $datainseert2['affiliation_commission'] = $finduser_bal->affiliation_commission + $offerAmount;
                                    $bonusAmount_affiliation_commission = $offerAmount;
                                } else {
                                    $datainseert2['bonus'] = $finduser_bal->bonus + $offerAmount;
                                    $bonusAmount_bonus = $offerAmount;
                                }

                                if ($first_deposit == 0) //for first deposit
                                {
                                    DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                                }
                                //}
                                $ntxnid = strtoupper(BRAND['name']) . 'OFFERBONUS-' . time();
                                $newtransactionsdata['userid'] = $user_id;
                                $newtransactionsdata['type'] = 'Offer Bonus add during add fund';
                                $newtransactionsdata['transaction_id'] = $ntxnid;
                                $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
                                $newtransactionsdata['amount'] = $offerAmount;
                                $newtransactionsdata['bonus_amt'] = $offerAmount;
                                $newtransactionsdata['paymentstatus'] = 'confirmed';
                                $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt + $bonusAmount_balance;
                                $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt + $bonusAmount_winning;
                                $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount_bonus;
                                $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt + $bonusAmount_gst_bonus;
                                $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt + $bonusAmount_affiliation_commission;
                                $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $offerAmount;

                                if ($first_deposit == 0) //for first deposit
                                {
                                    DB::table('transactions')->insert($newtransactionsdata);
                                }
                            }
                        }
                    }

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'phonepay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance + @$userBalance->gst_bonus + @$userBalance->affiliation_commission,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }
    public function phonepay_notify_old(Request $request)
    {
        // \Log::info("phonepay_notify: ". json_encode($request->all()));
        date_default_timezone_set('Asia/Kolkata');
        $headers = $request->header();

        $result =  base64_decode($request['response']);
        $finalresult = json_decode($result);
        //\Log::info("phonepay_notify: ". json_encode($finalresult));
        // $myfile = fopen("phonepay_notify.txt", "a") or die("Unable to open file!");
        // $txt = json_encode($finalresult)."John Does\n";
        // fwrite($myfile, $txt);
        // fclose($myfile);
        //  echo '<pre>'; print_r( $finalresult);exit;
        $orderId = $txnid = $finalresult->data->merchantTransactionId;
        $orderAmount =  ($finalresult->data->amount) / 100;
        $txStatus = $finalresult->data->responseCode;
        $paymentStatus = $finalresult->code;
        $paymentId =  $finalresult->data->transactionId;
        //$paymentmode = $request['transaction']['payment_mode'];
        $GST_ORDER_ID = 'GST-' . $orderId;
        $signature = '';

        $amount = $orderAmount;
        $TotalOrderAmount  = $orderAmount;
        $add_Fund     = round(($orderAmount / 128) * 100, 2);
        $GSTAmount    = round($orderAmount - $add_Fund, 2);
        $OrderAmount = $add_Fund;

        if (1) {
            if ($paymentStatus == 'PAYMENT_SUCCESS') {
                $add_fund_respose = array(
                    "transaction_id" => $orderId,
                    "sonicpay_id" => $paymentId,
                    "amount" => $orderAmount,
                    "sonic_status" => $txStatus,
                    "Response" => json_encode($request->all()),
                );
                try {
                    DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                    exit;
                }

                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                if (!empty($transaction_row)) {
                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    if (empty($userBalance1)) {
                        DB::table('userbalances')->insert(['user_id' => $transaction_row->userid]);
                    }
                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();

                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'phonepay_id' => $paymentId,
                        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                        'bal_bonus_amt' => $userBalance1->bonus,
                        'bal_win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'bal_affi_amt' => $userBalance1->affiliation_commission,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                    //TDS Calculation
                    // $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }
                    $amount = $orderAmount;
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($orderAmount - $add_Fund, 2);
                    $gstamount =  $GSTAmount;

                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount
                        ]);

                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();

                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            //$trans->insert($ins_tran);
                        }
                    }

                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        //  if($add_Fund>=1 && $add_Fund>=5000) {
                        // if($amount>=1 && $amount>=5000) {
                        //   $bonusAmount = 5000;
                        // }
                        if ($amount >= 1 && $amount >= 500) {
                            $bonusAmount = 500;
                        } elseif ($amount >= 1 && $amount < 500) {
                            $bonusAmount = $transaction_row->amount;
                        }
                    }

                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                            $new_bal_affi_amt = $finduser_bal->affiliation_commission;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;

                            $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;

                            // if($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || @$offers->btype == 'deposit')){
                            //   $datainseert2['balance'] = $finduser_bal->balance+$bonusAmount;
                            // }else{
                            //   $datainseert2['bonus'] = $finduser_bal->bonus+$bonusAmount;
                            // }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . 'BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount;
                            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                            $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $bonusAmount;
                            //print_r($newtransactionsdata); exit;

                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Balance */
                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();

                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount = $GSTAmount;
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;

                            $bal_fund_amt = $findlastow->balance - $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsdata['userid'] = $user_id;
                        $transactionsdata['paymentstatus'] = 'confirmed';
                        $transactionsdata['type'] = 'GST Deduction as per new government rule';
                        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                        $transactionsdata['transaction_by'] = 'wallet';
                        $transactionsdata['amount'] = $gstamount;
                        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsdata['bal_win_amt'] = $bal_win_amt;
                        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsdata['cons_amount'] = $gstamount;
                        $transactionsdata['total_available_amt'] = $total_available_amt;

                        DB::table('transactions')->insert($transactionsdata);

                        $datainseert['balance'] = $findlastow->balance - $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        //GST Report
                        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                        $igst = 0;
                        $cgst = 0;
                        $sgst = 0;
                        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                            $igst = 0;
                            $cgst = $gstamount;
                            $sgst = $gstamount;
                        } else {
                            $igst = $gstamount;
                            $cgst = 0;
                            $sgst = 0;
                        }
                        $GST_entry = array(
                            //"league_tran_id"=>$user_id.rand(11,999),
                            "user_id" => $user_id,
                            "deposit_amount" => $amount,
                            "gst_amount" => $gstamount,
                            "wallet_amount" => $amount,
                            "order_id" => $paymentId,
                            "transaction_id" => $transaction_row->id,
                            //"transaction_id"=>$user_id.time().rand(11,99),
                            // "state"=> $user_data->state,
                            "igst" => $igst,
                            "cgst" => $cgst,
                            "sgst" =>  $sgst,
                            "transaction_by" => 'PHONEPAY',
                            "ip" => @$transaction_row->ip,
                            "transactions_date" => date('Y-m-d H:i:s'),
                        );
                        DB::table('deposit_gst')->insert($GST_entry);

                        //GST Rebat
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                            $bal_fund_amt = $findlastow->balance + $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsgstrebat['userid'] = $user_id;
                        $transactionsgstrebat['paymentstatus'] = 'confirmed';
                        $transactionsgstrebat['type'] = 'GST Bonus rebate from PLAYNWIN11';
                        $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                        $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                        $transactionsgstrebat['amount'] = $gstamount;
                        $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                        $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsgstrebat['addfund_amt'] = $gstamount;
                        // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                        $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsgstrebat);

                        //$datainseert['balance'] = $findlastow->balance+$gstamount;
                        $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                    }


                    //Offer Promo code//

                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;

                        $offerAmount = 0;
                        $bonustype = "";
                        if ($promocode != "") {
                            $offers = DB::table('offers')
                                ->where('code', $promocode)
                                ->where('minamount', '<=', $amount)
                                ->where('maxamount', '>=', $amount)
                                ->where('expire_date', '>=', date('Y-m-d H:i:s'))
                                ->where('status', 1)->first();

                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            if (!empty($offers)) {

                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {

                                    $offerAmount = $bonusAmount1;
                                } else {
                                    $offerAmount = (($amount * $bonusAmount1) / 100);
                                }
                                if ($offers->btype == 'deposit') {
                                    $bonustype = 'Amount';
                                } else {
                                    $bonustype = 'Bonus';
                                }

                                if ($offerAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1, 'amount' => $offerAmount, 'bonustype' => $bonustype));
                                }
                            }
                        }


                        if ($offerAmount != 0) {
                            // find balance details //
                            $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                            if (!empty($finduser_bal)) {
                                $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                                $new_bal_fund_amt = $finduser_bal->balance;
                                $new_bal_win_amt = $finduser_bal->winning;
                                $new_bal_bonus_amt = $finduser_bal->bonus;
                                $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                                $new_bal_affi_amt = $finduser_bal->affiliation_commission;

                                $bonusAmountoffer1 = 0;
                                $bonusAmountoffer = 0;
                                if ($promocode != '' &&  @$offers->btype == 'deposit') {
                                    $datainseert2['balance'] = $finduser_bal->balance + $offerAmount;
                                    $bonusAmountoffer1 = $offerAmount;
                                } else {
                                    $datainseert2['bonus'] = $finduser_bal->bonus + $offerAmount;
                                    $bonusAmountoffer = $offerAmount;
                                }

                                if ($first_deposit == 0) //for first deposit
                                {
                                    DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                                }
                                //}
                                $ntxnid = strtoupper(BRAND['name']) . 'OFFERBONUS-' . time();
                                $newtransactionsdata['userid'] = $user_id;
                                $newtransactionsdata['type'] = 'Offer Bonus add during add fund';
                                $newtransactionsdata['transaction_id'] = $ntxnid;
                                $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
                                $newtransactionsdata['amount'] = $offerAmount;
                                $newtransactionsdata['bonus_amt'] = $offerAmount;
                                $newtransactionsdata['paymentstatus'] = 'confirmed';
                                $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt + $bonusAmountoffer1;
                                $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                                $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmountoffer;
                                $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                                $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                                $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $offerAmount;

                                if ($first_deposit == 0) //for first deposit
                                {
                                    DB::table('transactions')->insert($newtransactionsdata);
                                }
                            }
                        }
                    }

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'phonepay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance + @$userBalance->gst_bonus + @$userBalance->affiliation_commission,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    public function phonepay_notify_10_01_24Ganesh(Request $request)
    {
        date_default_timezone_set('Asia/Kolkata');
        $headers = $request->header();
        $myfile = fopen("phonepay_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($request->all()) . "John Does\n";
        // fwrite($myfile, $txt);
        // fclose($myfile);
        $result =  base64_decode($request['response']);
        $finalresult = json_decode($result);
        //print_r($finalresult); exit;

        $orderId = $txnid = $finalresult->data->merchantTransactionId;
        $orderAmount =  ($finalresult->data->amount) / 100;
        $txStatus = $finalresult->data->responseCode;
        $paymentStatus = $finalresult->code;
        $paymentId =  $finalresult->data->transactionId;
        //$paymentmode = $request['transaction']['payment_mode'];
        $GST_ORDER_ID = 'GST-' . $orderId;
        $signature = '';


        $amount = $orderAmount;
        $TotalOrderAmount  = $orderAmount;
        $add_Fund     = round(($orderAmount / 128) * 100, 2);
        $GSTAmount    = round($orderAmount - $add_Fund, 2);
        $OrderAmount = $add_Fund;

        if (1) {
            if ($paymentStatus == 'PAYMENT_SUCCESS') {
                $add_fund_respose = array(
                    "transaction_id" => $orderId,
                    "sonicpay_id" => $paymentId,
                    "amount" => $orderAmount,
                    "sonic_status" => $txStatus,
                    "Response" => json_encode($request->all()),
                );
                try {
                    DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                    exit;
                }

                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();
                // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
                if (!empty($transaction_row)) {

                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'phonepay_id' => $paymentId,
                        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                        'bal_bonus_amt' => $userBalance1->bonus,
                        'bal_win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'bal_affi_amt' => $userBalance1->affiliation_commission,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);


                    //TDS Calculation
                    // $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }


                    // DB::table("registerusers_session")
                    //   ->where("id", $registerusers_session->id)
                    //   ->update([
                    //       "total_deposit" => $registerusers_session->total_deposit+$transaction_row->amount
                    //   ]);
                    $amount = $orderAmount;
                    // if($transaction_row->userid==3 || $transaction_row->userid==1 || $transaction_row->userid==1028)
                    // {
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($orderAmount - $add_Fund, 2);
                    $gstamount =  $GSTAmount;
                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount - $gstamount
                        ]);
                    // }

                    // DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'confirmed','sonicpay_id'=>$paymentId));
                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";
                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;
                        $bonusAmount = 0;
                        if ($promocode != "") {
                            $valid_promo = 0;
                            //$offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $amount)->where('maxamount','>=', $amount)->where('status', 1)->first();
                            $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $add_Fund)->where('maxamount', '>=', $add_Fund)->where('status', 1)->first();
                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            if (!empty($offers)) {
                                $valid_promo = 1;
                                $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {
                                    $bonusAmount = $bonusAmount1;
                                } else {
                                    //$bonusAmount = (($amount * $bonusAmount1)/100);
                                    $bonusAmount = (($add_Fund * $bonusAmount1) / 100);
                                }
                                if ($bonusAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                                }
                            }
                        }
                    }

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            //$trans->insert($ins_tran);
                        }
                    }

                    // if(!empty($promo) && $promo->status==0 && strtolower($promo->promo_code)=='real100') {
                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                    // if($countFund == 1) {
                    //   if($amount>=1 && $amount<=500) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }

                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        if ($add_Fund >= 1 && $add_Fund >= 5000) {
                            // if($amount>=1 && $amount>=5000) {
                            $bonusAmount = 5000;
                        }
                    }

                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->count();
                    // if($countFund == 1) {
                    //   if($amount>=100) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }
                    /* Check first time bonus */
                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                            $new_bal_affi_amt = $finduser_bal->affiliation_commission;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;

                            if ($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')) {
                                $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            } else {
                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'cashfree';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                            $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;

                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Bonus */

                    //referral bonus refferal
                    if (0) {
                        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
                        if (empty($check_exist_referral)) {

                            //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                            if (1) {

                                $user_self = RegisterUser::where('id', $user_id)->first();
                                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                if (!empty($user_self) && !empty($user_referrer)) {
                                    // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                    $user_self_id = $user_self->id;
                                    $user_referrer_id = $user_referrer->id;
                                    ReferralBonus::create([
                                        'user_id' => $user_self_id,
                                        'refer_id' => $user_referrer_id,
                                        'amount' => $share_amount
                                    ]);

                                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                    $user_balance_self->bonus += $share_amount;
                                    $user_balance_referrer->bonus += $share_amount;

                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount) {
                                        $user_balance_self->save();
                                        $user_balance_referrer->save();
                                    }


                                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance + $user_balance_self->gst_bonus;
                                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance + $user_balance_referrer->gst_bonus;

                                    // echo 1; exit;

                                    $rand1 = rand(100000, 999999);
                                    $rand2 = rand(100000, 999999);

                                    // ENTRY FOR SELF USER
                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount >= 50) {
                                        $self_array = [
                                            'userid' => $user_self_id,
                                            'refer_id' => $user_referrer_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'addfund_amt' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'bal_bonus_amt' => $user_balance_self->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_self->gst_bonus,
                                            'bal_win_amt' => $user_balance_self->winning,
                                            'bal_fund_amt' => $user_balance_self->balance,
                                            'total_available_amt' => $total_balance_self,
                                        ];

                                        Transaction::create($self_array);

                                        // ENTRY FOR REFERRER USER
                                        Transaction::create([
                                            'userid' => $user_referrer_id,
                                            'refer_id' => $user_self_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'addfund_amt' => $share_amount,
                                            'bal_bonus_amt' => $user_balance_referrer->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_referrer->gst_bonus,
                                            'bal_win_amt' => $user_balance_referrer->winning,
                                            'bal_fund_amt' => $user_balance_referrer->balance,
                                            'total_available_amt' => $total_balance_referrer,
                                        ]);
                                    }
                                }
                            }
                        }
                    }

                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        //Gst transaction
                        //if($user_id==3 || $user_id==1 ||$user_id==1028){
                        //Gst transaction
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        //$gstamount= $amount*28/100;
                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount = $GSTAmount;
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;

                            $bal_fund_amt = $findlastow->balance - $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsdata['userid'] = $user_id;
                        $transactionsdata['paymentstatus'] = 'confirmed';
                        $transactionsdata['type'] = 'GST Deduction as per new government rule';
                        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                        $transactionsdata['transaction_by'] = 'wallet';
                        $transactionsdata['amount'] = $gstamount;
                        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsdata['bal_win_amt'] = $bal_win_amt;
                        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsdata['cons_amount'] = $gstamount;
                        $transactionsdata['total_available_amt'] = $total_available_amt;

                        DB::table('transactions')->insert($transactionsdata);

                        $datainseert['balance'] = $findlastow->balance - $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        //GST Report
                        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                        $igst = 0;
                        $cgst = 0;
                        $sgst = 0;
                        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                            $igst = 0;
                            $cgst = $gstamount;
                            $sgst = $gstamount;
                        } else {
                            $igst = $gstamount;
                            $cgst = 0;
                            $sgst = 0;
                        }
                        $GST_entry = array(
                            //"league_tran_id"=>$user_id.rand(11,999),
                            "user_id" => $user_id,
                            "deposit_amount" => $amount,
                            "gst_amount" => $gstamount,
                            "wallet_amount" => $add_Fund,
                            "transaction_id" => $user_id . time() . rand(11, 99),
                            // "state"=> $user_data->state,
                            "igst" => $igst,
                            "cgst" => $cgst,
                            "sgst" =>  $sgst,
                            "transaction_by" => 'PHONEPAY',
                            "transactions_date" => date('Y-m-d H:i:s'),
                            // "before_tax_platform_fees"=>$amount,
                            // "gst_rate"=>'28%',
                            // "challenge_id"=>rand(11,999).$user_id,
                            // "joinid"=>$user_id.time().rand(11,99)
                        );
                        DB::table('deposit_gst')->insert($GST_entry);

                        //GST Rebat
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                            $bal_fund_amt = $findlastow->balance;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus + $gstamount;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsgstrebat['userid'] = $user_id;
                        $transactionsgstrebat['paymentstatus'] = 'confirmed';
                        $transactionsgstrebat['type'] = 'GST Coins Rebat from PLAYNWIN11';
                        $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                        $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                        $transactionsgstrebat['amount'] = $gstamount;
                        $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                        $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                        // $transactionsgstrebat['addfund_amt'] = $gstamount;
                        $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                        $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsgstrebat);

                        // $datainseert['balance'] = $findlastow->balance+$gstamount;
                        $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        // }
                    }
                    $bal_bonus_amt = 0;
                    $bal_win_amt = 0;
                    $bal_fund_amt = 0;
                    $total_available_amt = 0;
                    $findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
                        $bal_fund_amt = $findlastow->balance;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                    }
                    //push notifications//
                    $titleget = 'Add fund successfully!';
                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);
                    // $transactionsdata['userid'] = $user_id;
                    $transactionsdata['type'] = 'Add Fund';
                    $transactionsdata['transaction_id'] = $txnid;
                    $transactionsdata['transaction_by'] = 'cashfree';
                    $transactionsdata['amount'] = $amount;
                    $transactionsdata['addfund_amt'] = $amount;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['cons_amount'] = $amount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;
                    DB::table('transactions')->where('id', $transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);
                    $notificationdata['userid'] = $user_id;
                    $notificationdata['title'] = 'Add Fund of ₹ ' . $amount . ' through cashfree';
                    // DB::table('notifications')->insert($notificationdata);
                    //mail//
                    $toEmail = $userdata->email;

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'sonicpay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                //  DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'pending','sonicpay_id'=>$paymentId));
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }


    public function promoter_leaderboard_users(Request $request)
    {


        if ($request->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    //DB::table('promoter_leaderboard_users')
                    DB::table('promoter_leaderboard_users as sl')
                        ->leftjoin('series as psl', 'sl.series_id', '=', 'psl.id')
                        ->leftjoin('registerusers as r', 'r.id', '=', 'sl.user_id')
                        ->select(
                            'sl.*',
                            'psl.name as series_name',
                            'psl.start_date',
                            'psl.end_date',
                            'psl.start_date',
                            'psl.start_date',
                            'psl.is_promoter_series_leaderboard',
                            'psl.series_status',
                            'r.username',
                            'r.mobile',
                            'r.team',
                            'r.refercode'
                        )
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['filter_columns'])) {
                                if (isset($formData['filter_columns']['filter_team'])) {
                                    $users = DB::table('registerusers')->where('team', 'like', '%' . $formData['filter_columns']['filter_team'] . '%')->select('id')->get();
                                    $usersIds = array();
                                    if (!empty($users)) {
                                        foreach ($users as $key => $value) {
                                            $usersIds[] = $value->id;
                                        }
                                    }
                                    $query->whereIN('user_id', $usersIds);
                                }
                                if (isset($formData['filter_columns']['filter_refercode'])) {
                                    $users = DB::table('registerusers')->where('refercode', 'like', '%' . $formData['filter_columns']['filter_refercode'] . '%')->select('id')->get();
                                    $usersIds = array();
                                    if (!empty($users)) {
                                        foreach ($users as $key => $value) {
                                            $usersIds[] = $value->id;
                                        }
                                    }
                                    $query->whereIN('user_id', $usersIds);
                                }
                            }
                        })
                        ->get()
                )
                    ->addIndexColumn()

                    ->addColumn('action', function ($result) {
                        $leaderboard = '<a href="' . route('Leaderboard.seriesPromotorLeaderboard', $result->id) . '" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Leaderboard"><i class="fa fa-trophy" aria-hidden="true" data-original-title="Leaderboard" ></i></a>';
                        $pricecards = '<a href="' . route('Leaderboard.seriesPromotorLeaderboardPricecards', base64_encode(serialize($result->id))) . '" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Pricecards"><i class="fa fa-rupee" aria-hidden="true" data-original-title="Pricecards" ></i></a>';

                        $winningDistribute = '';
                        if ($result->win_distrubute == 0)
                            $winningDistribute = '<a href="' . route('Leaderboard.seriesPromoterLeaderboardWinningDistribute', base64_encode(serialize($result->id))) . '" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Winning distribute"><i class="fa fa-gift" aria-hidden="true" data-original-title="Winning distribute" ></i></a>';

                        return $leaderboard . ' ' . $pricecards . ' ' . $winningDistribute;
                        //return '<a href="'.route($this->model.'.action-promoter-leaderboard-user',base64_encode(serialize($result->id))).'" class="btn btn-danger action-promoter-leaderboard-user"><i class="fa fa-times mr-2" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Delete" ></i>Delete</a>';
                    })
                    //->rawColumns(['action'])
                    ->escapeColumns([])
                    ->make(true);
            } //end

        }
        //$promoter_leaderboard = DB::table('promoter_leaderboard_series')->orderBY('name','ASC')->get();
        $promoter_leaderboard = DB::table('series')
            ->where('is_promoter_series_leaderboard', 1)
            ->get();
        $promoters = DB::table('registerusers')->where('is_yoububer', 1)->orderBy('refercode', 'ASC')->get();
        //$selectedPromotersdb = DB::table('promoter_leaderboard_users')->pluck('user_id');
        $selectedPromoters = array();
        //     if(!$selectedPromotersdb->isEmpty()){
        //
        //       $selectedPromoters = $selectedPromotersdb->toArray();
        //
        // }
        return view("admin.$this->model.promoterleaderboardusers", compact('promoters', 'selectedPromoters', 'promoter_leaderboard'));
    }

    /* Promoter Leaderboard Users */
    public function add_leaderboard_users(Request $request)
    {
        $formData    =    Input::all();
        if (!empty($formData) && !empty($formData['user_ids']) && !empty($formData['series_id'])) {
            $validate    =    array();

            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {

                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                foreach ($formData['user_ids'] as $key => $value) {
                    $data = array();
                    $data['user_id'] = $value;
                    $data['series_id'] = $formData['series_id'];
                    //$data['promoter_leaderboard_id']=$formData['leaderboard_id'];
                    $data['status'] = 1;
                    $data['sports_type'] = 1;
                    $check = DB::table('promoter_leaderboard_users')->where('user_id', $data['user_id'])->where('series_id', $data['series_id'])->first();
                    if (empty($check)) {
                        $getid = DB::table('promoter_leaderboard_users')->insert($data);
                    }
                }
                Session::flash('flash_notice',  trans("Successfully Added Promoter Leaderboard User!"));
                // Helpers::logActivity('Successfully Added Promoter Leaderboard User!',);
                return Redirect::route('Registerusers.view_leaderboard_users');
            }
        }
    }

    function action_promoter_leaderboard_user($id)
    {
        $id = unserialize(base64_decode($id));
        $findOffer = DB::table('promoter_leaderboard_users')->where('id', $id)->get();
        if (!empty($findOffer)) {
            DB::table('promoter_leaderboard_users')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Promoter Leaderboard Users!');
            // Helpers::logActivity('Successfully Deleted Links!');
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Offer id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::route('Registerusers.view_leaderboard_users');
    }

    public function sonicpay_notify_10_01_24Ganesh(Request $request)
    {
        date_default_timezone_set('Asia/Kolkata');
        $headers = $request->header();
        $myfile = fopen("sonicpay_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($request->all()) . "John Does\n";

        // fwrite($myfile, $txt);
        // fclose($myfile);
        //  exit;

        // print_r($request['data']['order']); exit;
        //  $txt =  $request['transaction']['payment_id'];
        $orderId = $txnid = $request['transaction']['order']['order_id'];
        // echo $orderId; exit;
        $orderAmount = $request['transaction']['order']['gross_amount'];
        //  $referenceId = $request['transaction']['payment']['bank_reference'];
        $txStatus = $request['transaction']['status'];
        $paymentId = $request['transaction']['payment_id'];
        //  $paymentMode = $request['data']['payment']['payment_group'];
        $paymentmode = $request['transaction']['payment_mode'];
        $signature = '';

        if (1) {
            if ($txStatus == 'Success') {
                $add_fund_respose = array(
                    "transaction_id" => $orderId,
                    "sonicpay_id" => $paymentId,
                    "amount" => $orderAmount,
                    "sonic_status" => $txStatus,
                    "Response" => json_encode($request->all()),
                );
                try {
                    DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                    exit;
                }

                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();
                // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
                if (!empty($transaction_row)) {

                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'sonicpay_id' => $paymentId,
                        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                        'bal_bonus_amt' => $userBalance1->bonus,
                        'bal_win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'bal_affi_amt' => $userBalance1->affiliation_commission,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                    if ($transaction_row->userid == 3) {
                        //DB::table('transactions')->where('userid', $transaction_row->userid)->where('gst_order_id', $transaction_row->transaction_id)->update(array('paymentstatus'=>'confirmed'));
                    }

                    //TDS Calculation
                    // $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }


                    // DB::table("registerusers_session")
                    //   ->where("id", $registerusers_session->id)
                    //   ->update([
                    //       "total_deposit" => $registerusers_session->total_deposit+$transaction_row->amount
                    //   ]);
                    $amount = $orderAmount;
                    // if($transaction_row->userid==3 || $transaction_row->userid==1 || $transaction_row->userid==1028)
                    // {
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($orderAmount - $add_Fund, 2);
                    $gstamount =  $GSTAmount;
                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount - $gstamount
                        ]);
                    // }

                    // DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'confirmed','sonicpay_id'=>$paymentId));
                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";
                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;
                        $bonusAmount = 0;
                        if ($promocode != "") {
                            $valid_promo = 0;
                            //$offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $amount)->where('maxamount','>=', $amount)->where('status', 1)->first();
                            $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $add_Fund)->where('maxamount', '>=', $add_Fund)->where('status', 1)->first();
                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            if (!empty($offers)) {
                                $valid_promo = 1;
                                $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {
                                    $bonusAmount = $bonusAmount1;
                                } else {
                                    //$bonusAmount = (($amount * $bonusAmount1)/100);
                                    $bonusAmount = (($add_Fund * $bonusAmount1) / 100);
                                }
                                if ($bonusAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                                }
                            }
                        }
                    }

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            //$trans->insert($ins_tran);
                        }
                    }

                    // if(!empty($promo) && $promo->status==0 && strtolower($promo->promo_code)=='real100') {
                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                    // if($countFund == 1) {
                    //   if($amount>=1 && $amount<=500) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }

                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        if ($add_Fund >= 1 && $add_Fund >= 5000) {
                            // if($amount>=1 && $amount>=5000) {
                            $bonusAmount = 5000;
                        }
                    }

                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->count();
                    // if($countFund == 1) {
                    //   if($amount>=100) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }
                    /* Check first time bonus */
                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                            $new_bal_aff_amt = $finduser_bal->affiliation_commission;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;


                            if ($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')) {
                                $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            } else {
                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'cashfree';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                            $newtransactionsdata['bal_affi_amt'] = $new_bal_aff_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Bonus */

                    //referral bonus refferal
                    if (0) {
                        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
                        if (empty($check_exist_referral)) {

                            //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                            if (1) {

                                $user_self = RegisterUser::where('id', $user_id)->first();
                                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                if (!empty($user_self) && !empty($user_referrer)) {
                                    // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                    $user_self_id = $user_self->id;
                                    $user_referrer_id = $user_referrer->id;
                                    ReferralBonus::create([
                                        'user_id' => $user_self_id,
                                        'refer_id' => $user_referrer_id,
                                        'amount' => $share_amount
                                    ]);

                                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                    $user_balance_self->bonus += $share_amount;
                                    $user_balance_referrer->bonus += $share_amount;

                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount) {
                                        $user_balance_self->save();
                                        $user_balance_referrer->save();
                                    }


                                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance + $user_balance_self->gst_bonus;
                                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance + $user_balance_referrer->gst_bonus;

                                    // echo 1; exit;

                                    $rand1 = rand(100000, 999999);
                                    $rand2 = rand(100000, 999999);

                                    // ENTRY FOR SELF USER
                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount >= 50) {
                                        $self_array = [
                                            'userid' => $user_self_id,
                                            'refer_id' => $user_referrer_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'addfund_amt' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'bal_bonus_amt' => $user_balance_self->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_self->gst_bonus,
                                            'bal_win_amt' => $user_balance_self->winning,
                                            'bal_fund_amt' => $user_balance_self->balance,
                                            'total_available_amt' => $total_balance_self,
                                        ];

                                        Transaction::create($self_array);

                                        // ENTRY FOR REFERRER USER
                                        Transaction::create([
                                            'userid' => $user_referrer_id,
                                            'refer_id' => $user_self_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'addfund_amt' => $share_amount,
                                            'bal_bonus_amt' => $user_balance_referrer->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_referrer->gst_bonus,
                                            'bal_win_amt' => $user_balance_referrer->winning,
                                            'bal_fund_amt' => $user_balance_referrer->balance,
                                            'total_available_amt' => $total_balance_referrer,
                                        ]);
                                    }
                                }
                            }
                        }
                    }

                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        //Gst transaction
                        //if($user_id==3 || $user_id==1 ||$user_id==1028){
                        //Gst transaction
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        //$gstamount= $amount*28/100;
                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount = $GSTAmount;
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;
                            $bal_fund_amt = $findlastow->balance - $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->$affiliation_commission;
                        }


                        $transactionsdata['userid'] = $user_id;
                        $transactionsdata['paymentstatus'] = 'confirmed';
                        $transactionsdata['type'] = 'GST Deduction as per new government rule';
                        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                        $transactionsdata['transaction_by'] = 'wallet';
                        $transactionsdata['amount'] = $gstamount;
                        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsdata['bal_win_amt'] = $bal_win_amt;
                        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsdata['cons_amount'] = $gstamount;
                        $transactionsdata['total_available_amt'] = $total_available_amt;

                        DB::table('transactions')->insert($transactionsdata);

                        $datainseert['balance'] = $findlastow->balance - $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        //GST Report
                        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                        $igst = 0;
                        $cgst = 0;
                        $sgst = 0;
                        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                            $igst = 0;
                            $cgst = $gstamount;
                            $sgst = $gstamount;
                        } else {
                            $igst = $gstamount;
                            $cgst = 0;
                            $sgst = 0;
                        }
                        $GST_entry = array(
                            //"league_tran_id"=>$user_id.rand(11,999),
                            "user_id" => $user_id,
                            "deposit_amount" => $amount,
                            "gst_amount" => $gstamount,
                            "wallet_amount" => $add_Fund,
                            "transaction_id" => $user_id . time() . rand(11, 99),
                            // "state"=> $user_data->state,
                            "igst" => $igst,
                            "cgst" => $cgst,
                            "sgst" =>  $sgst,
                            "transaction_by" => 'SONICPAY',
                            "transactions_date" => date('Y-m-d H:i:s'),
                            // "before_tax_platform_fees"=>$amount,
                            // "gst_rate"=>'28%',
                            // "challenge_id"=>rand(11,999).$user_id,
                            // "joinid"=>$user_id.time().rand(11,99)
                        );
                        DB::table('deposit_gst')->insert($GST_entry);

                        //GST Rebat
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                            $bal_fund_amt = $findlastow->balance;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus + $gstamount;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsgstrebat['userid'] = $user_id;
                        $transactionsgstrebat['paymentstatus'] = 'confirmed';
                        $transactionsgstrebat['type'] = 'GST Coins Rebat from PLAYNWIN11';
                        $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                        $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                        $transactionsgstrebat['amount'] = $gstamount;
                        $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                        $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                        // $transactionsgstrebat['addfund_amt'] = $gstamount;
                        $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                        $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsgstrebat);

                        // $datainseert['balance'] = $findlastow->balance+$gstamount;
                        $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        // }
                    }
                    $bal_bonus_amt = 0;
                    $bal_win_amt = 0;
                    $bal_fund_amt = 0;
                    $total_available_amt = 0;
                    $findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
                        $bal_fund_amt = $findlastow->balance;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                    }
                    //push notifications//
                    $titleget = 'Add fund successfully!';
                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);
                    // $transactionsdata['userid'] = $user_id;
                    $transactionsdata['type'] = 'Add Fund';
                    $transactionsdata['transaction_id'] = $txnid;
                    $transactionsdata['transaction_by'] = 'cashfree';
                    $transactionsdata['amount'] = $amount;
                    $transactionsdata['addfund_amt'] = $amount;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['cons_amount'] = $amount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;
                    DB::table('transactions')->where('id', $transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);
                    $notificationdata['userid'] = $user_id;
                    $notificationdata['title'] = 'Add Fund of Rs ' . $amount . ' through cashfree';
                    // DB::table('notifications')->insert($notificationdata);
                    //mail//
                    $toEmail = $userdata->email;

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'sonicpay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => @$userBalance->bonus + @$userBalance->winning + @$userBalance->balance,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                //  DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'pending','sonicpay_id'=>$paymentId));
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }
    public function sonicpay_notify_OLD23_10(Request $request)
    {
        date_default_timezone_set('Asia/Kolkata');
        $headers = $request->header();
        $myfile = fopen("sonicpay_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($request->all()) . "John Does\n";

        fwrite($myfile, $txt);
        fclose($myfile);
        exit;

        // print_r($request['data']['order']); exit;
        //  $txt =  $request['transaction']['payment_id'];
        $orderId = $txnid = $request['transaction']['order']['order_id'];
        // echo $orderId; exit;
        $orderAmount = $request['transaction']['order']['gross_amount'];
        //  $referenceId = $request['transaction']['payment']['bank_reference'];
        $txStatus = $request['transaction']['status'];
        $paymentId = $request['transaction']['payment_id'];
        //  $paymentMode = $request['data']['payment']['payment_group'];
        $paymentmode = $request['transaction']['payment_mode'];
        $signature = '';

        if (1) {
            if ($txStatus == 'Success') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();
                // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
                if (!empty($transaction_row)) {

                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'sonicpay_id' => $paymentId,
                        'bonus_amt' => $userBalance1->bonus,
                        'win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->winning + $userBalance1->balance + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                    if ($transaction_row->userid == 3) {
                        //DB::table('transactions')->where('userid', $transaction_row->userid)->where('gst_order_id', $transaction_row->transaction_id)->update(array('paymentstatus'=>'confirmed'));
                    }

                    //TDS Calculation
                    // $session_year = date("Y");

                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }


                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount
                        ]);
                    $amount = $orderAmount;
                    if ($transaction_row->userid == 3 || $transaction_row->userid == 1 || $transaction_row->userid == 1028) {
                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount =  $GSTAmount;
                        DB::table("registerusers_session")
                            ->where("id", $registerusers_session->id)
                            ->update([
                                "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount - $gstamount
                            ]);
                    }

                    // DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'confirmed','sonicpay_id'=>$paymentId));
                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";
                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;
                        $bonusAmount = 0;
                        if ($promocode != "") {
                            $valid_promo = 0;
                            $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $amount)->where('maxamount', '>=', $amount)->where('status', 1)->first();
                            // $offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $add_Fund)->where('maxamount','>=', $add_Fund)->where('status', 1)->first();
                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            if (!empty($offers)) {
                                $valid_promo = 1;
                                $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {
                                    $bonusAmount = $bonusAmount1;
                                } else {
                                    $bonusAmount = (($amount * $bonusAmount1) / 100);
                                    //$bonusAmount = (($add_Fund * $bonusAmount1)/100);
                                }
                                if ($bonusAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                                }
                            }
                        }
                    }

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            //$trans->insert($ins_tran);
                        }
                    }

                    // if(!empty($promo) && $promo->status==0 && strtolower($promo->promo_code)=='real100') {
                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                    // if($countFund == 1) {
                    //   if($amount>=1 && $amount<=500) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }

                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        // if($add_Fund>=1 && $add_Fund>=5000) {
                        if ($amount >= 1 && $amount >= 5000) {
                            $bonusAmount = 5000;
                        }
                    }

                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->count();
                    // if($countFund == 1) {
                    //   if($amount>=100) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }
                    /* Check first time bonus */
                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;

                            if ($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')) {
                                $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            } else {
                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'cashfree';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Bonus */

                    //referral bonus refferal
                    if (0) {
                        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
                        if (empty($check_exist_referral)) {

                            //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                            if (1) {

                                $user_self = RegisterUser::where('id', $user_id)->first();
                                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                if (!empty($user_self) && !empty($user_referrer)) {
                                    // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                    $user_self_id = $user_self->id;
                                    $user_referrer_id = $user_referrer->id;
                                    ReferralBonus::create([
                                        'user_id' => $user_self_id,
                                        'refer_id' => $user_referrer_id,
                                        'amount' => $share_amount
                                    ]);

                                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                    $user_balance_self->bonus += $share_amount;
                                    $user_balance_referrer->bonus += $share_amount;

                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount) {
                                        $user_balance_self->save();
                                        $user_balance_referrer->save();
                                    }


                                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance;
                                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance;

                                    // echo 1; exit;

                                    $rand1 = rand(100000, 999999);
                                    $rand2 = rand(100000, 999999);

                                    // ENTRY FOR SELF USER
                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount >= 50) {
                                        $self_array = [
                                            'userid' => $user_self_id,
                                            'refer_id' => $user_referrer_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'addfund_amt' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'bal_bonus_amt' => $user_balance_self->bonus,
                                            'bal_win_amt' => $user_balance_self->winning,
                                            'bal_fund_amt' => $user_balance_self->balance,
                                            'total_available_amt' => $total_balance_self,
                                        ];

                                        Transaction::create($self_array);

                                        // ENTRY FOR REFERRER USER
                                        Transaction::create([
                                            'userid' => $user_referrer_id,
                                            'refer_id' => $user_self_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'addfund_amt' => $share_amount,
                                            'bal_bonus_amt' => $user_balance_referrer->bonus,
                                            'bal_win_amt' => $user_balance_referrer->winning,
                                            'bal_fund_amt' => $user_balance_referrer->balance,
                                            'total_available_amt' => $total_balance_referrer,
                                        ]);
                                    }
                                }
                            }
                        }
                    }

                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        //Gst transaction
                        if ($user_id == 3 || $user_id == 1 || $user_id == 1028) {
                            //Gst transaction
                            $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                            //$gstamount= $amount*28/100;
                            $add_Fund     = round(($amount / 128) * 100, 2);
                            $GSTAmount    = round($orderAmount - $add_Fund, 2);
                            $gstamount = $GSTAmount;
                            if (!empty($findlastow)) {
                                $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus - $gstamount;
                                $bal_fund_amt = $findlastow->balance;
                                $bal_win_amt = $findlastow->winning;
                                $bal_bonus_amt = $findlastow->bonus;
                            }

                            $transactionsdata['userid'] = $user_id;
                            $transactionsdata['paymentstatus'] = 'confirmed';
                            $transactionsdata['type'] = 'GST Deduction as per new government rule';
                            $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                            $transactionsdata['transaction_by'] = 'wallet';
                            $transactionsdata['amount'] = $gstamount;
                            $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                            $transactionsdata['bal_win_amt'] = $bal_win_amt;
                            $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                            $transactionsdata['cons_amount'] = $gstamount;
                            $transactionsdata['total_available_amt'] = $total_available_amt;

                            DB::table('transactions')->insert($transactionsdata);

                            $datainseert['balance'] = $findlastow->balance - $gstamount;
                            DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                            //GST Report
                            $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                            $igst = 0;
                            $cgst = 0;
                            $sgst = 0;
                            if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                                $igst = 0;
                                $cgst = $gstamount;
                                $sgst = $gstamount;
                            } else {
                                $igst = $gstamount;
                                $cgst = 0;
                                $sgst = 0;
                            }
                            $GST_entry = array(
                                "league_tran_id" => $user_id . rand(11, 999),
                                "user_id" => $user_id,
                                "state" => $user_data->state,
                                "igst" => $igst,
                                "cgst" => $cgst,
                                "sgst" =>  $sgst,
                                "transaction_at" => date('Y-m-d H:i:s'),
                                "before_tax_platform_fees" => $amount,
                                "gst_rate" => '28%',
                                "challenge_id" => rand(11, 999) . $user_id,
                                "joinid" => $user_id . time() . rand(11, 99)
                            );
                            DB::table('gst_report')->insert($GST_entry);

                            //GST Rebat
                            $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                            if (!empty($findlastow)) {
                                $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $gstamount;
                                $bal_fund_amt = $findlastow->balance;
                                $bal_win_amt = $findlastow->winning;
                                $bal_bonus_amt = $findlastow->bonus;
                            }

                            $transactionsgstrebat['userid'] = $user_id;
                            $transactionsgstrebat['paymentstatus'] = 'confirmed';
                            $transactionsgstrebat['type'] = 'GST Coins Rebat from PLAYNWIN11';
                            $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                            $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                            $transactionsgstrebat['amount'] = $gstamount;
                            $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                            $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                            $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                            // $transactionsgstrebat['addfund_amt'] = $gstamount;
                            $transactionsgstrebat['bonus_amt'] = $gstamount;
                            $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                            DB::table('transactions')->insert($transactionsgstrebat);

                            // $datainseert['balance'] = $findlastow->balance+$gstamount;
                            $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                            DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        }
                    }
                    $bal_bonus_amt = 0;
                    $bal_win_amt = 0;
                    $bal_fund_amt = 0;
                    $total_available_amt = 0;
                    $findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
                        $bal_fund_amt = $findlastow->balance;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                    }
                    //push notifications//
                    $titleget = 'Add fund successfully!';
                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);
                    // $transactionsdata['userid'] = $user_id;
                    $transactionsdata['type'] = 'Add Fund';
                    $transactionsdata['transaction_id'] = $txnid;
                    $transactionsdata['transaction_by'] = 'cashfree';
                    $transactionsdata['amount'] = $amount;
                    $transactionsdata['addfund_amt'] = $amount;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['cons_amount'] = $amount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;
                    DB::table('transactions')->where('id', $transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);
                    $notificationdata['userid'] = $user_id;
                    $notificationdata['title'] = 'Add Fund of Rs ' . $amount . ' through cashfree';
                    // DB::table('notifications')->insert($notificationdata);
                    //mail//
                    $toEmail = $userdata->email;

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'sonicpay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                //  DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'pending','sonicpay_id'=>$paymentId));
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }




    public function cashfree_notify_test()
    {
        exit;
        $orderId = "1949481631860256617";
        $orderAmount = 10;
        $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();
        // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
        var_dump($transaction_row);
        if (!empty($transaction_row)) {
            echo "transaction_row";
            DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus' => 'confirmed'));
            $user_id = $getdata['userid'] = $transaction_row->userid;
            $amount = $orderAmount;
            $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
            $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
            $referid = $userdata->refer_id;
            $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
            $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
            /* Insert IN Bonus */
            $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
            $bonusAmount = 0;
            $first_deposit = 0;
            $add_fund_count = 0;
            $promocode = "";
            if (!empty($promo) && @$promo->status == 0) {
                echo ":S";
                $promocode = $promo->promo_code;
                $bonusAmount = 0;
                var_dump($promocode);
                if ($promocode != "") {
                    $valid_promo = 0;
                    $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $amount)->where('maxamount', '>=', $amount)->where('status', 1)->first();
                    //check first deposit
                    if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                        $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                        $add_fund_count = $user_first_deposit_check->count();
                        if ($add_fund_count > 1) {
                            $first_deposit = 1;
                        }
                    }
                    // end check first deposit
                    print_r($offers);
                    // foreach($offers as $o){
                    if (!empty($offers)) {

                        $valid_promo = 1;
                        $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                        $bonusAmount1 = $offers->bonus;
                        $bonus_type = $offers->bonus_type;
                        if ($bonus_type == 'rs') {
                            $bonusAmount = $bonusAmount1;
                        } else {
                            $bonusAmount = (($amount * $bonusAmount1) / 100);
                        }
                        // if(!empty($used))
                        //     $bonusAmount= 0;

                        // }
                        if ($bonusAmount) {
                            $usedoffer['offer_id'] = $promocode;
                            $usedoffer['user_id'] = $user_id;
                            // DB::table('usedoffers')->insert($usedoffer);
                            DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                        }
                    }
                }
            }

            if ($bonusAmount != 0) {
                // find balance details //
                $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                if (!empty($finduser_bal)) {
                    $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                    $new_bal_fund_amt = $finduser_bal->balance;
                    $new_bal_win_amt = $finduser_bal->winning;
                    $new_bal_bonus_amt = $finduser_bal->bonus;
                    // $datainseert2['user_id'] = $user_id;
                    // $datainseert2['refer_id']= $referid;
                    // $datainseert['balance'] = $userBalance->balance+$amount;

                    if ($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')) {
                        $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                    } else {
                        $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                    }


                    //if($getdata['paymentby']=='cashfree') {
                    if ($first_deposit == 0) //for first deposit
                    {
                        var_dump($datainseert2);
                        // DB::table('userbalances')->where('user_id',$user_id)->update($datainseert2);
                    }
                    //}
                    $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                    $newtransactionsdata['userid'] = $user_id;
                    $newtransactionsdata['type'] = 'Bonus add during add fund (Valid for 30 days)';
                    $newtransactionsdata['transaction_id'] = $ntxnid;
                    $newtransactionsdata['transaction_by'] = 'cashfree';
                    $newtransactionsdata['amount'] = $bonusAmount;
                    $newtransactionsdata['bonus_amt'] = $bonusAmount;
                    $newtransactionsdata['paymentstatus'] = 'confirmed';
                    $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                    $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                    $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                    $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                    if ($first_deposit == 0) //for first deposit
                    {
                        // DB::table('transactions')->insert($newtransactionsdata);
                    }
                }
            }
        }
    }
    public function testCode()
    {
        $promocode = strtoupper(BRAND['name']) . "100";
        $amount = "2000";
        $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $amount)->where('maxamount', '>=', $amount)->where('status', 1)->first();
        var_dump($offers);
        exit;
    }
    public function checkAddCashPaymentStatusByOrderId($order_id)
    {

        $detail = DB::table('transactions')->where('transaction_id', $order_id)->first();
        $amount = $detail->amount;


        $clientId = "702513840c0cbfe82786c6e0d15207"; // live
        $clientSecret = "27d764350ea2d0b908dc24e4fbfe4892e4aede84";

        $url = "https://api.cashfree.com/api/v1/order/info/status";
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "appId=${clientId}&secretKey=${clientSecret}&orderId=${order_id}",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/x-www-form-urlencoded"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);


        $result = json_decode($response, true);
        echo "<pre>";
        print_r($result);
        die();
    }
    public function razorpay_notify(Request $request)
    {
        date_default_timezone_set('Asia/Kolkata');
        //  $headers = $request->header();
        //  // $myfile = fopen("razorpay_notify.txt", "a") or die("Unable to open file!");
        $myfile = fopen(base_path() . "/razorpay_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($request->all()) . "Request\n";
        fwrite($myfile, $txt);
        //  exit;


        if (isset($request->secret)) {
            if ($request->secret != "poiuytrewq") {
                return;
            }
        }
        $order_id = isset($request->payload['payment']['entity']['order_id']) ? $request->payload['payment']['entity']['order_id'] : '';

        $checkisPending = DB::table('transactions')->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->where('paymentstatus', 'pending')->first();

        if (empty($checkisPending)) {
            return;
        }
        $status = $request->payload['payment']['entity']['status'];
        // echo "<pre>";print_r($status);exit;
        $orderId = $txnid = $order_id;
        $orderAmount =  $checkisPending->amount;
        $txStatus = $status;
        $paymentStatus = $status;
        $paymentId =  $orderId;
        //$paymentmode = $request['transaction']['payment_mode'];
        $GST_ORDER_ID = 'GST-' . $orderId;
        $signature = '';


        $amount = $orderAmount;
        $TotalOrderAmount  = $orderAmount;
        $add_Fund     = round(($orderAmount / 128) * 100, 2);
        $GSTAmount    = round($orderAmount - $add_Fund, 2);
        $OrderAmount = $add_Fund;

        if (1) {
            if ($paymentStatus == 'captured'  || $paymentStatus == 'authorized') {
                $add_fund_respose = array(
                    "transaction_id" => $orderId,
                    "sonicpay_id" => $paymentId,
                    "amount" => $orderAmount,
                    "sonic_status" => $txStatus,
                    "Response" => json_encode($request->all()),
                );
                try {
                    DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                    exit;
                }

                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                if (!empty($transaction_row)) {
                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    if (empty($userBalance1)) {
                        DB::table('userbalances')->insert(['user_id' => $transaction_row->userid]);
                    }
                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'razorpay_id' => $paymentId,
                        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                        'bal_bonus_amt' => $userBalance1->bonus,
                        'bal_win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'bal_affi_amt' => $userBalance1->affiliation_commission,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                    //TDS Calculation
                    //  $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }

                    $amount = $orderAmount;
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($orderAmount - $add_Fund, 2);
                    $gstamount =  $GSTAmount;
                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount
                        ]);

                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";
                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;
                        $bonusAmount = 0;
                        if ($promocode != "") {
                            $valid_promo = 0;
                            $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $amount)->where('maxamount', '>=', $amount)->where('status', 1)->first();
                            // $offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $add_Fund)->where('maxamount','>=', $add_Fund)->where('status', 1)->first();
                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            if (!empty($offers)) {
                                $valid_promo = 1;
                                $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {
                                    $bonusAmount = $bonusAmount1;
                                } else {
                                    $bonusAmount = (($amount * $bonusAmount1) / 100);
                                    //$bonusAmount = (($add_Fund * $bonusAmount1)/100);
                                }
                                if ($bonusAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                                }
                            }
                        }
                    }

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus + $refer_bal->gst_bonus + $refer_bal->affiliation_commission;
                            //$trans->insert($ins_tran);
                        }
                    }


                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        // if($add_Fund>=1 && $add_Fund>=5000) {
                        if ($amount >= 1 && $amount >= 5000) {
                            $bonusAmount = 5000;
                        }
                    }

                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                            $new_bal_affi_amt = $finduser_bal->affiliation_commission;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;

                            if ($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || @$offers->btype == 'deposit')) {
                                $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            } else {
                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'PLAYNWIN11';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt + $bonusAmount;
                            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                            $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt + $bonusAmount;
                            //print_r($newtransactionsdata); exit;

                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Bonus */

                    //referral bonus refferal
                    if (0) {
                        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
                        if (empty($check_exist_referral)) {

                            //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                            if (1) {

                                $user_self = RegisterUser::where('id', $user_id)->first();
                                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                if (!empty($user_self) && !empty($user_referrer)) {
                                    // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                    $user_self_id = $user_self->id;
                                    $user_referrer_id = $user_referrer->id;
                                    ReferralBonus::create([
                                        'user_id' => $user_self_id,
                                        'refer_id' => $user_referrer_id,
                                        'amount' => $share_amount
                                    ]);

                                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                    $user_balance_self->bonus += $share_amount;
                                    $user_balance_referrer->bonus += $share_amount;

                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount) {
                                        $user_balance_self->save();
                                        $user_balance_referrer->save();
                                    }


                                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance + $user_balance_self->gst_bonus;
                                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance + $user_balance_referrer->gst_bonus;

                                    // echo 1; exit;

                                    $rand1 = rand(100000, 999999);
                                    $rand2 = rand(100000, 999999);

                                    // ENTRY FOR SELF USER
                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount >= 50) {
                                        $self_array = [
                                            'userid' => $user_self_id,
                                            'refer_id' => $user_referrer_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'addfund_amt' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'bal_bonus_amt' => $user_balance_self->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_self->gst_bonus,
                                            'bal_win_amt' => $user_balance_self->winning,
                                            'bal_fund_amt' => $user_balance_self->balance,
                                            'total_available_amt' => $total_balance_self,
                                        ];

                                        Transaction::create($self_array);

                                        // ENTRY FOR REFERRER USER
                                        Transaction::create([
                                            'userid' => $user_referrer_id,
                                            'refer_id' => $user_self_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'addfund_amt' => $share_amount,
                                            'bal_bonus_amt' => $user_balance_referrer->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_referrer->gst_bonus,
                                            'bal_win_amt' => $user_balance_referrer->winning,
                                            'bal_fund_amt' => $user_balance_referrer->balance,
                                            'total_available_amt' => $total_balance_referrer,
                                        ]);
                                    }
                                }
                            }
                        }
                    }

                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        //Gst transaction
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount = $GSTAmount;
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;
                            $bal_fund_amt = $findlastow->balance - $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }


                        $transactionsdata['userid'] = $user_id;
                        $transactionsdata['paymentstatus'] = 'confirmed';
                        $transactionsdata['type'] = 'GST Deduction as per new government rule';
                        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                        $transactionsdata['transaction_by'] = 'wallet';
                        $transactionsdata['amount'] = $gstamount;
                        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsdata['bal_win_amt'] = $bal_win_amt;
                        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsdata['cons_amount'] = $gstamount;
                        $transactionsdata['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsdata);

                        $datainseert['balance'] = $findlastow->balance - $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        //GST Report
                        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                        $igst = 0;
                        $cgst = 0;
                        $sgst = 0;
                        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                            $igst = 0;
                            $cgst = $gstamount;
                            $sgst = $gstamount;
                        } else {
                            $igst = $gstamount;
                            $cgst = 0;
                            $sgst = 0;
                        }
                        $GST_entry = array(
                            "user_id" => $user_id,
                            "deposit_amount" => $amount,
                            "gst_amount" => $gstamount,
                            "wallet_amount" => $amount,
                            "transaction_id" => $user_id . time() . rand(11, 99),
                            "igst" => $igst,
                            "cgst" => $cgst,
                            "sgst" =>  $sgst,
                            "transaction_by" => 'RAZORPAY',
                            "ip" => @$transaction_row->ip,
                            "transactions_date" => date('Y-m-d H:i:s'),
                        );
                        DB::table('deposit_gst')->insert($GST_entry);

                        //GST Rebat
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                            $bal_fund_amt = $findlastow->balance + $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsgstrebat['userid'] = $user_id;
                        $transactionsgstrebat['paymentstatus'] = 'confirmed';
                        $transactionsgstrebat['type'] = 'GST Real cash rebate from PLAYNWIN11';
                        $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                        $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                        $transactionsgstrebat['amount'] = $gstamount;
                        $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                        $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsgstrebat['addfund_amt'] = $gstamount;
                        // $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                        $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsgstrebat);

                        $datainseert['balance'] = $findlastow->balance + $gstamount;
                        // $datainseert['gst_bonus'] = $findlastow->gst_bonus+$gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        // }
                    }
                    $bal_bonus_amt = 0;
                    $bal_win_amt = 0;
                    $bal_fund_amt = 0;
                    $total_available_amt = 0;
                    $findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
                        $bal_fund_amt = $findlastow->balance;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                    }
                    //push notifications//
                    $titleget = 'Add fund successfully!';
                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);
                    // $transactionsdata['userid'] = $user_id;
                    $transactionsdata['type'] = 'Add Fund';
                    $transactionsdata['transaction_id'] = $txnid;
                    $transactionsdata['transaction_by'] = 'cashfree';
                    $transactionsdata['amount'] = $amount;
                    $transactionsdata['addfund_amt'] = $amount;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['cons_amount'] = $amount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;
                    //   DB::table('transactions')->where('id',$transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);
                    $notificationdata['userid'] = $user_id;
                    $notificationdata['title'] = 'Add Fund of ₹ ' . $amount . ' through cashfree';
                    // DB::table('notifications')->insert($notificationdata);
                    //mail//
                    $toEmail = $userdata->email;

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'sonicpay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance + $userBalance->gst_bonus + $userBalance->affiliation_commission,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    public function razorpay_notify_10_01_24Ganesh(Request $request)
    {
        date_default_timezone_set('Asia/Kolkata');
        // $headers = $request->header();
        // $myfile = fopen("razorpay_notify.txt", "a") or die("Unable to open file!");
        //$myfile = fopen(base_path()."/razorpay_notify.txt", "a") or die("Unable to open file!");
        //  $txt = json_encode($request->all())."Request\n";
        // fwrite($myfile, $txt);exit;

        if (isset($request->secret)) {
            if ($request->secret != "poiuytrewq") {
                return;
            }
        }
        $order_id = isset($request->payload['payment']['entity']['order_id']) ? $request->payload['payment']['entity']['order_id'] : '';

        $checkisPending = DB::table('transactions')->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->where('paymentstatus', 'pending')->first();

        if (empty($checkisPending)) {
            return;
        }
        $status = $request->payload['payment']['entity']['status'];
        // $GST_ORDER_ID = 'GST-'.$order_id;

        //print_r($finalresult); exit;

        $orderId = $txnid = $order_id;
        $orderAmount =  $checkisPending->amount;
        $txStatus = $status;
        $paymentStatus = $status;
        $paymentId =  $orderId;
        //$paymentmode = $request['transaction']['payment_mode'];
        $GST_ORDER_ID = 'GST-' . $orderId;
        $signature = '';


        $amount = $orderAmount;
        $TotalOrderAmount  = $orderAmount;
        $add_Fund     = round(($orderAmount / 128) * 100, 2);
        $GSTAmount    = round($orderAmount - $add_Fund, 2);
        $OrderAmount = $add_Fund;

        if (1) {
            if ($paymentStatus == 'captured'  || $paymentStatus == 'authorized') {
                $add_fund_respose = array(
                    "transaction_id" => $orderId,
                    "sonicpay_id" => $paymentId,
                    "amount" => $orderAmount,
                    "sonic_status" => $txStatus,
                    "Response" => json_encode($request->all()),
                );
                try {
                    DB::table('sonicpay_add_fund_respose')->insert($add_fund_respose);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                    exit;
                }

                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();
                // $this->db->select('id')->from('transaction')->where('transaction_id', $orderId)->where('status',0);
                if (!empty($transaction_row)) {

                    $userBalance1 = DB::table('userbalances')->where('user_id', $transaction_row->userid)->first();
                    $updatetrans = array(
                        'paymentstatus' => 'confirmed',
                        'razorpay_id' => $paymentId,
                        'bal_gst_bonus_amt' => $userBalance1->gst_bonus,
                        'bal_bonus_amt' => $userBalance1->bonus,
                        'bal_win_amt' => $userBalance1->winning,
                        'bal_fund_amt' => $userBalance1->balance,
                        'bal_affi_amt' => $userBalance1->affiliation_commission,
                        'addfund_amt' => $transaction_row->amount,
                        'total_available_amt' => $userBalance1->bonus + $userBalance1->gst_bonus + $userBalance1->winning + $userBalance1->balance + $userBalance1->affiliation_commission + $transaction_row->amount,
                    );

                    DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);


                    //TDS Calculation
                    //  $session_year = date("Y");
                    $session_year = Helpers::getCurrentSessionYear();
                    // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
                    // {
                    //   $session_year = "2024";
                    // }
                    $registerusers_session = DB::table("registerusers_session")
                        ->where("user_id", $transaction_row->userid)
                        ->where("session_year", $session_year)
                        ->first();
                    if (empty($registerusers_session)) {
                        DB::table("registerusers_session")->insert([
                            "session_year" => $session_year,
                            "user_id" => $transaction_row->userid,
                        ]);
                        sleep(1);
                        $registerusers_session = DB::table("registerusers_session")
                            ->where("user_id", $transaction_row->userid)
                            ->where("session_year", $session_year)
                            ->first();
                    }


                    // DB::table("registerusers_session")
                    //   ->where("id", $registerusers_session->id)
                    //   ->update([
                    //       "total_deposit" => $registerusers_session->total_deposit+$transaction_row->amount
                    //   ]);
                    $amount = $orderAmount;
                    // if($transaction_row->userid==3 || $transaction_row->userid==1 || $transaction_row->userid==1028)
                    // {
                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $GSTAmount    = round($orderAmount - $add_Fund, 2);
                    $gstamount =  $GSTAmount;
                    DB::table("registerusers_session")
                        ->where("id", $registerusers_session->id)
                        ->update([
                            "total_deposit" => $registerusers_session->total_deposit + $transaction_row->amount - $gstamount
                        ]);
                    // }

                    // DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'confirmed','sonicpay_id'=>$paymentId));
                    $user_id = $getdata['userid'] = $transaction_row->userid;

                    $add_Fund     = round(($amount / 128) * 100, 2);
                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                    $userdata = DB::table('registerusers')->where('id', $getdata['userid'])->first();
                    $referid = $userdata->refer_id;
                    $userBalanceReffred = DB::table('userbalances')->where('user_id', $referid)->first();
                    $referdata = DB::table('registerusers')->where('id', $referid)->where('refer_to_join', 0)->first();
                    /* Insert IN Bonus */
                    $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
                    $bonusAmount = 0;
                    $first_deposit = 0;
                    $add_fund_count = 0;
                    $promocode = "";
                    if (!empty($promo) && @$promo->status == 0) {
                        $promocode = $promo->promo_code;
                        $bonusAmount = 0;
                        if ($promocode != "") {
                            $valid_promo = 0;
                            //$offers= DB::table('offers')->where('code',$promocode)->where('minamount','<=', $amount)->where('maxamount','>=', $amount)->where('status', 1)->first();
                            $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $add_Fund)->where('maxamount', '>=', $add_Fund)->where('status', 1)->first();
                            //check first deposit
                            if (!empty($offers->first_deposit) && @$offers->first_deposit == 1) {
                                $user_first_deposit_check = DB::table('transactions')->where('userid', $user_id)->where('type', 'add fund')->where('paymentstatus', 'confirmed')->get();

                                $add_fund_count = $user_first_deposit_check->count();
                                if ($add_fund_count > 1) {
                                    $first_deposit = 1;
                                }
                            }
                            // foreach($offers as $o){
                            if (!empty($offers)) {
                                $valid_promo = 1;
                                $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                                $bonusAmount1 = $offers->bonus;
                                $bonus_type = $offers->bonus_type;
                                if ($bonus_type == 'rs') {
                                    $bonusAmount = $bonusAmount1;
                                } else {
                                    //$bonusAmount = (($amount * $bonusAmount1)/100);
                                    $bonusAmount = (($add_Fund * $bonusAmount1) / 100);
                                }
                                if ($bonusAmount) {
                                    $usedoffer['offer_id'] = $promocode;
                                    $usedoffer['user_id'] = $user_id;
                                    DB::table('usedoffers')->insert($usedoffer);
                                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                                }
                            }
                        }
                    }

                    //FEFER BONUS AMOUNT
                    $is_code_exist = RegisterUser::where('id', $transaction_row->userid)->first();
                    if (!empty($is_code_exist) && $is_code_exist->refer_to_join != 1) {
                        if (1) {
                            $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
                            $bns_amt['bonus'] = $refer_bal->bonus + 250;
                            // DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
                            // DB::table('registerusers')->where('id',$referid)->update(['refer_to_join'=>1]);
                            $trans = DB::table('transactions');
                            $ins_tran['userid'] = $is_code_exist->id;
                            $ins_tran['refer_id'] = $transaction_row->userid;
                            $ins_tran['transaction_id'] = BRAND['name'] . '-Refer-' . time();
                            $ins_tran['type'] = 'Refer Bonus';
                            $ins_tran['transaction_by'] = BRAND['name'];
                            $ins_tran['paymentstatus'] = CONFIRMED;
                            $ins_tran['total_available_amt'] = $refer_bal->winning + $refer_bal->balance + $refer_bal->bonus;
                            $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
                            $ins_tran['bonus_amt'] = 250;
                            $ins_tran['amount'] = 250;
                            //$trans->insert($ins_tran);
                        }
                    }

                    // if(!empty($promo) && $promo->status==0 && strtolower($promo->promo_code)=='real100') {
                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->where('type','add fund')->count();
                    // if($countFund == 1) {
                    //   if($amount>=1 && $amount<=500) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }

                    $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus', 'confirmed')->where('type', 'add fund')->count();
                    if ($countFund == 1) {
                        if ($add_Fund >= 1 && $add_Fund >= 5000) {
                            // if($amount>=1 && $amount>=5000) {
                            $bonusAmount = 5000;
                        }
                    }

                    /* Check first time bonus */
                    // $countFund = $trans = DB::table('transactions')->where('userid', $user_id)->where('paymentstatus','confirmed')->count();
                    // if($countFund == 1) {
                    //   if($amount>=100) {
                    //     $bonusAmount = $amount;
                    //   }
                    // }
                    /* Check first time bonus */
                    if ($bonusAmount != 0) {
                        // find balance details //
                        $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($finduser_bal)) {
                            $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus + $finduser_bal->gst_bonus + $finduser_bal->affiliation_commission;
                            $new_bal_fund_amt = $finduser_bal->balance;
                            $new_bal_win_amt = $finduser_bal->winning;
                            $new_bal_bonus_amt = $finduser_bal->bonus;
                            $new_bal_gst_bonus_amt = $finduser_bal->gst_bonus;
                            $new_bal_affi_amt = $finduser_bal->affiliation_commission;
                            // $datainseert2['user_id'] = $user_id;
                            // $datainseert2['refer_id']= $referid;
                            // $datainseert['balance'] = $userBalance->balance+$amount;

                            if ($promocode != '' && ($promocode == 'GURUJI3' || $promocode == 'GURUJI2' || $promocode == 'GURUJI1' || strtolower($promocode) == 'ganesha' || $offers->btype == 'deposit')) {
                                $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            } else {
                                $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            }


                            //if($getdata['paymentby']=='cashfree') {
                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                            }
                            //}
                            $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                            $newtransactionsdata['userid'] = $user_id;
                            $newtransactionsdata['type'] = 'Bonus add during add fund';
                            $newtransactionsdata['transaction_id'] = $ntxnid;
                            $newtransactionsdata['transaction_by'] = 'cashfree';
                            $newtransactionsdata['amount'] = $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $newtransactionsdata['paymentstatus'] = 'confirmed';
                            $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                            $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                            $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                            $newtransactionsdata['bal_gst_bonus_amt'] = $new_bal_gst_bonus_amt;
                            $newtransactionsdata['bal_affi_amt'] = $new_bal_affi_amt;
                            $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;

                            if ($first_deposit == 0) //for first deposit
                            {
                                DB::table('transactions')->insert($newtransactionsdata);
                            }
                        }
                    }
                    /* Bonus Credit */
                    /* Insert IN Bonus */

                    //referral bonus refferal
                    if (0) {
                        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
                        if (empty($check_exist_referral)) {

                            //$user_total_deposit = DB::table('transactions')->where('userid', $user_id)->where('type','add fund')->where('paymentstatus','confirmed')->sum('amount');
                            if (1) {

                                $user_self = RegisterUser::where('id', $user_id)->first();
                                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                                if (!empty($user_self) && !empty($user_referrer)) {
                                    // $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT)/100;
                                    $bonus_amount_db = DB::table('bonus_amount')->where('type', 'REFERAL_BONUS_AMOUNT')->first();
                                    $DEPOSIT_REFER_BONUS_AMOUNT = $bonus_amount_db->price;
                                    $share_amount = $DEPOSIT_REFER_BONUS_AMOUNT;

                                    $user_self_id = $user_self->id;
                                    $user_referrer_id = $user_referrer->id;
                                    ReferralBonus::create([
                                        'user_id' => $user_self_id,
                                        'refer_id' => $user_referrer_id,
                                        'amount' => $share_amount
                                    ]);

                                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                                    $user_balance_self->bonus += $share_amount;
                                    $user_balance_referrer->bonus += $share_amount;

                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount) {
                                        $user_balance_self->save();
                                        $user_balance_referrer->save();
                                    }


                                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance + $user_balance_self->gst_bonus;
                                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance + $user_balance_referrer->gst_bonus;

                                    // echo 1; exit;

                                    $rand1 = rand(100000, 999999);
                                    $rand2 = rand(100000, 999999);

                                    // ENTRY FOR SELF USER
                                    //check for minimum add fund amount for referral bonus
                                    if ($orderAmount >= 50) {
                                        $self_array = [
                                            'userid' => $user_self_id,
                                            'refer_id' => $user_referrer_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'addfund_amt' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'bal_bonus_amt' => $user_balance_self->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_self->gst_bonus,
                                            'bal_win_amt' => $user_balance_self->winning,
                                            'bal_fund_amt' => $user_balance_self->balance,
                                            'total_available_amt' => $total_balance_self,
                                        ];

                                        Transaction::create($self_array);

                                        // ENTRY FOR REFERRER USER
                                        Transaction::create([
                                            'userid' => $user_referrer_id,
                                            'refer_id' => $user_self_id,
                                            'type' => 'Referral Bonus',
                                            'transaction_id' => 'RFR-DPST-' . $rand1,
                                            'transaction_by' => APP_NAME,
                                            'amount' => $share_amount,
                                            'paymentstatus' => 'Confirmed',
                                            'addfund_amt' => $share_amount,
                                            'bal_bonus_amt' => $user_balance_referrer->bonus,
                                            'bal_gst_bonus_amt' => $user_balance_referrer->gst_bonus,
                                            'bal_win_amt' => $user_balance_referrer->winning,
                                            'bal_fund_amt' => $user_balance_referrer->balance,
                                            'total_available_amt' => $total_balance_referrer,
                                        ]);
                                    }
                                }
                            }
                        }
                    }

                    if (!empty($userBalance)) {
                        $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();
                        $datainseert['user_id'] = $user_id;
                        $datainseert['refer_id'] = $referid;
                        $datainseert['balance'] = $userBalance->balance + $amount;
                        // $datainseert['bonus'] = $userBalance->bonus+$bonusAmount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);

                        //Gst transaction
                        //if($user_id==3 || $user_id==1 ||$user_id==1028){
                        //Gst transaction
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        //$gstamount= $amount*28/100;
                        $add_Fund     = round(($amount / 128) * 100, 2);
                        $GSTAmount    = round($orderAmount - $add_Fund, 2);
                        $gstamount = $GSTAmount;
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission - $gstamount;
                            $bal_fund_amt = $findlastow->balance - $gstamount;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }


                        $transactionsdata['userid'] = $user_id;
                        $transactionsdata['paymentstatus'] = 'confirmed';
                        $transactionsdata['type'] = 'GST Deduction as per new government rule';
                        $transactionsdata['transaction_id'] = 'PLAYNWIN11-GSTDEDUCT-' . rand(0000, 9999) . $user_id;
                        $transactionsdata['transaction_by'] = 'wallet';
                        $transactionsdata['amount'] = $gstamount;
                        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsdata['bal_win_amt'] = $bal_win_amt;
                        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsdata['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsdata['bal_affi_amt'] = $bal_affi_amt;
                        $transactionsdata['cons_amount'] = $gstamount;
                        $transactionsdata['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsdata);

                        $datainseert['balance'] = $findlastow->balance - $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        //GST Report
                        $user_data = DB::table('registerusers')->where('id', $user_id)->first();
                        $igst = 0;
                        $cgst = 0;
                        $sgst = 0;
                        if (!empty($user_data) || strtolower($user_data->state) == 'Gujarat') {
                            $igst = 0;
                            $cgst = $gstamount;
                            $sgst = $gstamount;
                        } else {
                            $igst = $gstamount;
                            $cgst = 0;
                            $sgst = 0;
                        }
                        $GST_entry = array(
                            //"league_tran_id"=>$user_id.rand(11,999),
                            "user_id" => $user_id,
                            "deposit_amount" => $amount,
                            "gst_amount" => $gstamount,
                            "wallet_amount" => $add_Fund,
                            "transaction_id" => $user_id . time() . rand(11, 99),
                            // "state"=> $user_data->state,
                            "igst" => $igst,
                            "cgst" => $cgst,
                            "sgst" =>  $sgst,
                            "transaction_by" => 'RAZORPAY',
                            "transactions_date" => date('Y-m-d H:i:s'),
                            // "before_tax_platform_fees"=>$amount,
                            // "gst_rate"=>'28%',
                            // "challenge_id"=>rand(11,999).$user_id,
                            // "joinid"=>$user_id.time().rand(11,99)
                        );
                        DB::table('deposit_gst')->insert($GST_entry);

                        //GST Rebat
                        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
                        if (!empty($findlastow)) {
                            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus + $findlastow->gst_bonus + $findlastow->affiliation_commission + $gstamount;
                            $bal_fund_amt = $findlastow->balance;
                            $bal_win_amt = $findlastow->winning;
                            $bal_gst_bonus_amt = $findlastow->gst_bonus + $gstamount;
                            $bal_bonus_amt = $findlastow->bonus;
                            $bal_affi_amt = $findlastow->affiliation_commission;
                        }

                        $transactionsgstrebat['userid'] = $user_id;
                        $transactionsgstrebat['paymentstatus'] = 'confirmed';
                        $transactionsgstrebat['type'] = 'GST Coins Rebat from PLAYNWIN11';
                        $transactionsgstrebat['transaction_id'] = 'PLAYNWIN11-GSTREBAT-' . rand(0000, 9999) . $user_id;
                        $transactionsgstrebat['transaction_by'] = 'PLAYNWIN11';
                        $transactionsgstrebat['amount'] = $gstamount;
                        $transactionsgstrebat['bal_win_amt'] = $bal_win_amt;
                        $transactionsgstrebat['bal_bonus_amt'] = $bal_bonus_amt;
                        $transactionsgstrebat['bal_fund_amt'] = $bal_fund_amt;
                        $transactionsgstrebat['bal_gst_bonus_amt'] = $bal_gst_bonus_amt;
                        $transactionsgstrebat['bal_affi_amt'] = $bal_affi_amt;
                        // $transactionsgstrebat['addfund_amt'] = $gstamount;
                        $transactionsgstrebat['gst_bonus_amt'] = $gstamount;
                        $transactionsgstrebat['total_available_amt'] = $total_available_amt;
                        DB::table('transactions')->insert($transactionsgstrebat);

                        // $datainseert['balance'] = $findlastow->balance+$gstamount;
                        $datainseert['gst_bonus'] = $findlastow->gst_bonus + $gstamount;
                        DB::table('userbalances')->where('user_id', $getdata['userid'])->update($datainseert);
                        // }
                    }
                    $bal_bonus_amt = 0;
                    $bal_win_amt = 0;
                    $bal_fund_amt = 0;
                    $total_available_amt = 0;
                    $findlastow = DB::table('userbalances')->where('user_id', $getdata['userid'])->first();
                    if (!empty($findlastow)) {
                        $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
                        $bal_fund_amt = $findlastow->balance;
                        $bal_win_amt = $findlastow->winning;
                        $bal_bonus_amt = $findlastow->bonus;
                    }
                    //push notifications//
                    $titleget = 'Add fund successfully!';
                    // Helpers::sendnotification($titleget,$notificationdata['title'],'',$getdata['userid']);
                    // $transactionsdata['userid'] = $user_id;
                    $transactionsdata['type'] = 'Add Fund';
                    $transactionsdata['transaction_id'] = $txnid;
                    $transactionsdata['transaction_by'] = 'cashfree';
                    $transactionsdata['amount'] = $amount;
                    $transactionsdata['addfund_amt'] = $amount;
                    $transactionsdata['paymentstatus'] = 'confirmed';
                    $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
                    $transactionsdata['bal_win_amt'] = $bal_win_amt;
                    $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
                    $transactionsdata['cons_amount'] = $amount;
                    $transactionsdata['total_available_amt'] = $total_available_amt;
                    //   DB::table('transactions')->where('id',$transaction_row->id)->where('paytid', $orderId)->update($transactionsdata);
                    $notificationdata['userid'] = $user_id;
                    $notificationdata['title'] = 'Add Fund of ₹ ' . $amount . ' through cashfree';
                    // DB::table('notifications')->insert($notificationdata);
                    //mail//
                    $toEmail = $userdata->email;

                    echo json_encode(array("status" => "OK"));
                    exit;
                } else {
                    echo 0;
                }
                echo 'Success';
            } else if ($txStatus == 'Failed' || $txStatus == 'Dropped') {
                $transaction_row = DB::table('transactions')->where('transaction_id', $orderId)->where('paymentstatus', 'pending')->first();

                //add history
                $userBalance = DB::table('userbalances')->where('user_id', @$transaction_row->userid)->first();
                $updatetrans = array(
                    'paymentstatus' => 'pending',
                    'sonicpay_id' => $paymentId,
                    'bonus_amt' => @$userBalance->bonus,
                    'win_amt' => @$userBalance->winning,
                    'addfund_amt' => 0,
                    'total_available_amt' => $userBalance->bonus + $userBalance->winning + $userBalance->balance,
                );

                DB::table('transactions')->where('id', $transaction_row->id)->where('transaction_id', $orderId)->update($updatetrans);

                //  DB::table('transactions')->where('id',$transaction_row->id)->where('transaction_id', $orderId)->update(array('paymentstatus'=>'pending','sonicpay_id'=>$paymentId));
                echo 0;
            } else if ($txStatus == 'PENDING') {
                echo 0;
            }
        } else {
            echo 0;
        }
    }

    public function razorpay_notify_ganesh_old(Request $request)
    {
        $myfile = fopen(base_path() . "/razorpay_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($request->all()) . "Request\n";
        fwrite($myfile, $txt);

        if (isset($request->secret)) {
            if ($request->secret != "poiuytrewq") {
                return;
            }
        }

        $order_id = isset($request->payload['payment']['entity']['order_id']) ? $request->payload['payment']['entity']['order_id'] : '';
        $checkisPending = DB::table('transactions')->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->where('paymentstatus', 'pending')->first();
        if (empty($checkisPending)) {
            return;
        }

        $status = $request->payload['payment']['entity']['status'];
        $transaction = DB::table('transactions')
            ->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->first();

        $user_id = $transaction->userid;
        $amount = $transaction->amount;
        $up_data['paymentstatus'] = 'confirmed';

        if ($status == 'captured' || $status == 'authorized') {
            DB::table('transactions')->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->update($up_data);
        } else {
            exit;
        }
        $balance = DB::table('userbalances')->where('user_id', $user_id)->first();
        $up_balance['balance'] = $balance->balance + $amount;
        DB::table('userbalances')->where('user_id', $user_id)->update($up_balance);
        // Insert IN Bonus //
        $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();

        //   $promo_expire = DB::table('offers')
        //   ->where('code',$promo->promo_code)
        //   ->orderBy('id','DESC')->first();
        //
        //  if(!empty($promo_expire->expire_date)){
        //      if($promo_expire->expire_date < date('Y-m-d H:i:s')){
        //          $promo=array();
        //       }
        // }
        if (!empty($promo) && $promo->status == 0) {
            $promocode = $promo->promo_code;
            $bonusAmount = 0;
            if ($promocode != "") {
                $valid_promo = 0;
                // $offers= DB::table('offers')->where('code',$promocode)->where('minamount', $amount)->where('status', 1)->first();
                $offers = DB::table('offers')->where('code', $promocode)->where('minamount', '<=', $amount)->where('maxamount', '>=', $amount)->where('status', 1)->first();
                // foreach($offers as $o){
                if (!empty($offers)) {
                    $valid_promo = 1;
                    $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                    $bonusAmount1 = $offers->bonus;
                    $bonus_type = $offers->bonus_type;
                    if ($bonus_type == 'rs') {
                        $bonusAmount = $bonusAmount1;
                    } else {
                        $bonusAmount = (($amount * $bonusAmount1) / 100);
                    }

                    if (!$used->isEmpty()) {
                        if (@$offers->multiple_time == 0) {

                            $bonusAmount = 0;
                        }
                    }
                    /*if(!empty($used))
    $bonusAmount= 0;*/
                }
                // }

                if ($bonusAmount) {
                    $usedoffer['offer_id'] = $promocode;
                    $usedoffer['user_id'] = $user_id;
                    DB::table('usedoffers')->insert($usedoffer);
                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                }
                // Bonus Credit //
                if ($bonusAmount != 0) {
                    // find balance details //
                    $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                    if (!empty($finduser_bal)) {
                        $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                        $new_bal_fund_amt = $finduser_bal->balance;
                        $new_bal_win_amt = $finduser_bal->winning;
                        $new_bal_bonus_amt = $finduser_bal->bonus;
                        // $datainseert2['user_id'] = $user_id;
                        // $datainseert2['refer_id']= $referid;
                        $newtransactionsdata = [];
                        if ($offers->btype == 'deposit') {
                            $datainseert2['balance'] = $finduser_bal->balance + $bonusAmount;
                            $newtransactionsdata['addfund_amt'] = $bonusAmount;
                            $new_bal_fund_amt = $datainseert2['balance'];
                        } else {
                            $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                            $newtransactionsdata['bonus_amt'] = $bonusAmount;
                            $new_bal_bonus_amt = $datainseert2['bonus'];
                        }

                        $new_total_available_amt = $new_bal_fund_amt + $new_bal_bonus_amt + $new_bal_win_amt;


                        //if($getdata['paymentby']=='cashfree') {
                        DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                        //}
                        $ntxnid = 'PLAYNWIN11BONUS-' . time();
                        $newtransactionsdata['userid'] = $user_id;
                        $newtransactionsdata['type'] = 'Bonus add during add fund';
                        $newtransactionsdata['transaction_id'] = $ntxnid;
                        $newtransactionsdata['transaction_by'] = 'cashfree';
                        $newtransactionsdata['amount'] = $bonusAmount;

                        $newtransactionsdata['paymentstatus'] = 'confirmed';
                        $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                        $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                        $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                        $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                        DB::table('transactions')->insert($newtransactionsdata);
                    }
                }
            }
        }
        // Insert IN Bonus //

        ////   DEPOSIT REFERRAL BONUS 3%  ////

        $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
        if (empty($check_exist_referral)) {
            $user_self = RegisterUser::where('id', $user_id)->first();
            $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

            if (!empty($user_self) && !empty($user_referrer)) {
                $share_amount = 300;

                $user_self_id = $user_self->id;
                $user_referrer_id = $user_referrer->id;
                $referbonus = array(
                    'user_id' => $user_self_id,
                    'refer_id' => $user_referrer_id,
                    'amount' => $share_amount
                );
                $txt = "";
                $txt = json_encode($referbonus) . "Refer Bonus : \n";
                fwrite($myfile, $txt);
                DB::table('referral_bonus')->insert($referbonus);

                // ReferralBonus::create([
                // 'user_id' => $user_self_id,
                // 'refer_id' => $user_referrer_id,
                // 'amount' => $share_amount
                // ]);

                $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                //$user_balance_self->balance += $share_amount;
                $user_balance_referrer->bonus += $share_amount;

                //$user_balance_self->save();
                $txt = "";
                $txt = json_encode($user_balance_referrer) . "User Balance : \n";
                fwrite($myfile, $txt);
                $user_balance_referrer->save();

                $rand1 = rand(100000, 999999);
                //$total_balance_self = $user_balance_self->bonus+$user_balance_self->winning+$user_balance_self->balance;
                $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance;

                // // ENTRY FOR SELF USER
                // $self_array = [
                // 'userid' => $user_self_id,
                // 'refer_id' => $user_referrer_id,
                // 'type' => 'Refer Bonus',
                // 'transaction_id' => 'RFR-'.$rand1,
                // 'transaction_by' => 'Life11',
                // 'amount' => $share_amount,
                // 'addfund_amt' => $share_amount,
                // 'paymentstatus' => 'Confirmed',
                // 'bal_bonus_amt' => $user_balance_self->bonus,
                // 'bal_win_amt' => $user_balance_self->winning,
                // 'bal_fund_amt' => $user_balance_self->balance,
                // 'total_available_amt' => $total_balance_self,
                // ];
                // // // print_r($self_array); exit;
                //  Transaction::create($self_array);
                //
                //
                // // ENTRY FOR REFERRER USER

                $transaction = array(
                    'userid' => $user_referrer_id,
                    'refer_id' => $user_self_id,
                    'type' => 'Deposit Refer Bonus',
                    'transaction_id' => 'RFR-DPST-' . $rand1,
                    'transaction_by' => 'PLAYNWIN11',
                    'amount' => $share_amount,
                    'paymentstatus' => 'confirmed',
                    'bonus_amt' => $share_amount,
                    'bal_bonus_amt' => $user_balance_referrer->bonus,
                    'bal_win_amt' => $user_balance_referrer->winning,
                    'bal_fund_amt' => $user_balance_referrer->balance,
                    'total_available_amt' => $total_balance_referrer
                );
                // echo "<pre>"; print_r($transaction);
                DB::table('transactions')->insert($transaction);
            }
        }


        $findlastow = DB::table('userbalances')->where('user_id', $user_id)->first();
        if (!empty($findlastow)) {
            $total_available_amt = $findlastow->balance + $findlastow->winning + $findlastow->bonus;
            $bal_fund_amt = $findlastow->balance;
            $bal_win_amt = $findlastow->winning;
            $bal_bonus_amt = $findlastow->bonus;
        }
        $transactionsdata['userid'] = $user_id;
        $transactionsdata['type'] = 'Add Fund';
        $transactionsdata['transaction_id'] = $order_id;
        $transactionsdata['transaction_by'] = 'razorpay';
        $transactionsdata['amount'] = $amount;
        $transactionsdata['addfund_amt'] = $amount;
        $transactionsdata['paymentstatus'] = 'confirmed';
        $transactionsdata['bal_fund_amt'] = $bal_fund_amt;
        $transactionsdata['bal_win_amt'] = $bal_win_amt;
        $transactionsdata['bal_bonus_amt'] = $bal_bonus_amt;
        $transactionsdata['cons_amount'] = $amount;
        $transactionsdata['total_available_amt'] = $total_available_amt;
        DB::table('transactions')->where('transaction_id', $order_id)->update($transactionsdata);
        ////   DEPOSIT REFERRAL BONUS 3%  ////


        // $session_year = date("Y");
        $session_year = Helpers::getCurrentSessionYear();
        // if(date("Y-m-d H:i:s") > '2024-03-31 23:59:59')
        // {
        //   $session_year = "2024";
        // }
        $registerusers_session = DB::table("registerusers_session")
            ->where("user_id", $user_id)
            ->where("session_year", $session_year)
            ->first();
        if (empty($registerusers_session)) {
            DB::table("registerusers_session")->insert([
                "session_year" => $session_year,
                "user_id" => $user_id,
            ]);
            sleep(1);
            $registerusers_session = DB::table("registerusers_session")
                ->where("user_id", $user_id)
                ->where("session_year", $session_year)
                ->first();
        }

        DB::table("registerusers_session")
            ->where("id", $registerusers_session->id)
            ->update([
                "total_deposit" => $registerusers_session->total_deposit + $amount
            ]);
        echo json_encode(array("status" => "OK", "result" => $transaction));
        exit;
    }
    public function razorpay_notify_old(Request $request)
    {
        $myfile = fopen(base_path() . "/razorpay_notify.txt", "a") or die("Unable to open file!");
        $txt = json_encode($request->all()) . "John Doe\n";
        fwrite($myfile, $txt);
        // print_r($request->all());die;

        $order_id = $request->payload['payment']['entity']['order_id'];
        $status = $request->payload['payment']['entity']['status'];
        $transaction = DB::table('transactions')->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->first();
        $user_id = $transaction->userid;
        $amount = $transaction->amount;
        $up_data['paymentstatus'] = 'confirmed';
        if ($status == 'authorized') {
            DB::table('transactions')->where('transaction_by', 'razorPay')->where('transaction_id', $order_id)->update($up_data);
        }
        $balance = DB::table('userbalances')->where('user_id', $user_id)->first();
        $up_balance['balance'] = $balance->balance + $amount;
        DB::table('userbalances')->where('user_id', $user_id)->update($up_balance);

        /* Insert IN Bonus */
        $promo = DB::table('user_promo')->where('user_id', $user_id)->orderBy('id', 'DESC')->first();
        if (!empty($promo) && $promo->status == 0) {
            $promocode = $promo->promo_code;
            $bonusAmount = 0;
            if ($promocode != "") {
                $valid_promo = 0;
                $offers = DB::table('offers')->where('code', $promocode)->where('minamount', $amount)->where('status', 1)->first();
                // foreach($offers as $o){
                if (!empty($offers)) {
                    $valid_promo = 1;
                    $used = DB::table('usedoffers')->where('offer_id', $promocode)->where('user_id', $user_id)->get();
                    $bonusAmount1 = $offers->bonus;
                    $bonus_type = $offers->bonus_type;
                    if ($bonus_type == 'rs') {
                        $bonusAmount = $bonusAmount1;
                    } else {
                        $bonusAmount = (($amount * $bonusAmount1) / 100);
                    }
                    /*if(!empty($used))
        $bonusAmount= 0;*/
                }
                // }
                if ($bonusAmount) {
                    $usedoffer['offer_id'] = $promocode;
                    $usedoffer['user_id'] = $user_id;
                    DB::table('usedoffers')->insert($usedoffer);
                    DB::table('user_promo')->where('id', $promo->id)->update(array("status" => 1));
                }
                /* Bonus Credit */
                if ($bonusAmount != 0) {
                    // find balance details //
                    $finduser_bal = DB::table('userbalances')->where('user_id', $user_id)->first();
                    if (!empty($finduser_bal)) {
                        $new_total_available_amt = $finduser_bal->balance + $finduser_bal->winning + $finduser_bal->bonus;
                        $new_bal_fund_amt = $finduser_bal->balance;
                        $new_bal_win_amt = $finduser_bal->winning;
                        $new_bal_bonus_amt = $finduser_bal->bonus;
                        // $datainseert2['user_id'] = $user_id;
                        // $datainseert2['refer_id']= $referid;
                        // $datainseert['balance'] = $userBalance->balance+$amount;
                        $datainseert2['bonus'] = $finduser_bal->bonus + $bonusAmount;
                        //if($getdata['paymentby']=='cashfree') {
                        DB::table('userbalances')->where('user_id', $user_id)->update($datainseert2);
                        //}
                        $ntxnid = strtoupper(BRAND['name']) . '11BONUS-' . time();
                        $newtransactionsdata['userid'] = $user_id;
                        $newtransactionsdata['type'] = 'Bonus add during add fund';
                        $newtransactionsdata['transaction_id'] = $ntxnid;
                        $newtransactionsdata['transaction_by'] = 'cashfree';
                        $newtransactionsdata['amount'] = $bonusAmount;
                        $newtransactionsdata['bonus_amt'] = $bonusAmount;
                        $newtransactionsdata['paymentstatus'] = 'confirmed';
                        $newtransactionsdata['bal_fund_amt'] = $new_bal_fund_amt;
                        $newtransactionsdata['bal_win_amt'] = $new_bal_win_amt;
                        $newtransactionsdata['bal_bonus_amt'] = $new_bal_bonus_amt;
                        $newtransactionsdata['total_available_amt'] = $new_total_available_amt; //print_r($newtransactionsdata); exit;
                        DB::table('transactions')->insert($newtransactionsdata);
                    }
                }
                /* Bonus Credit */
            }
        }
        /* Insert IN Bonus */

        ////   DEPOSIT REFERRAL BONUS 3%  ////
        if (1) {
            $check_exist_referral = ReferralBonus::where('user_id', $user_id)->first();
            if (empty($check_exist_referral)) {
                $user_self = RegisterUser::where('id', $user_id)->first();
                $user_referrer = RegisterUser::where('id', $user_self->refer_id)->first();

                if (!empty($user_self) && !empty($user_referrer)) {
                    $share_amount = ($amount * DEPOSIT_REFER_BONUS_PERCENT) / 100;

                    $user_self_id = $user_self->id;
                    $user_referrer_id = $user_referrer->id;
                    ReferralBonus::create([
                        'user_id' => $user_self_id,
                        'refer_id' => $user_referrer_id,
                        'amount' => $share_amount
                    ]);

                    $user_balance_self = UserBalance::where('user_id', $user_self_id)->first();
                    $user_balance_referrer = UserBalance::where('user_id', $user_referrer_id)->first();


                    $user_balance_self->balance += $share_amount;
                    $user_balance_referrer->balance += $share_amount;

                    $user_balance_self->save();
                    $user_balance_referrer->save();


                    $total_balance_self = $user_balance_self->bonus + $user_balance_self->winning + $user_balance_self->balance;
                    $total_balance_referrer = $user_balance_referrer->bonus + $user_balance_referrer->winning + $user_balance_referrer->balance;

                    // echo 1; exit;

                    $rand1 = rand(100000, 999999);
                    $rand2 = rand(100000, 999999);

                    // ENTRY FOR SELF USER
                    $self_array = [
                        'userid' => $user_self_id,
                        'refer_id' => $user_referrer_id,
                        'type' => 'Deposit Refer Bonus',
                        'transaction_id' => 'RFR-DPST-' . $rand1,
                        'transaction_by' => strtoupper(BRAND['name']),
                        'amount' => $share_amount,
                        'addfund_amt' => $share_amount,
                        'paymentstatus' => 'Confirmed',
                        'bal_bonus_amt' => $user_balance_self->bonus,
                        'bal_win_amt' => $user_balance_self->winning,
                        'bal_fund_amt' => $user_balance_self->balance,
                        'total_available_amt' => $total_balance_self,
                    ];
                    // print_r($self_array); exit;
                    Transaction::create($self_array);


                    // ENTRY FOR REFERRER USER
                    Transaction::create([
                        'userid' => $user_referrer_id,
                        'refer_id' => $user_self_id,
                        'type' => 'Deposit Refer Bonus',
                        'transaction_id' => 'RFR-DPST-' . $rand1,
                        'transaction_by' => BRAND['name'],
                        'amount' => $share_amount,
                        'paymentstatus' => 'confirmed',
                        'addfund_amt' => $share_amount,
                        'bal_bonus_amt' => $user_balance_referrer->bonus,
                        'bal_win_amt' => $user_balance_referrer->winning,
                        'bal_fund_amt' => $user_balance_referrer->balance,
                        'total_available_amt' => $total_balance_referrer,
                    ]);
                }
            }
        }

        ////   DEPOSIT REFERRAL BONUS 3%  ////

        fwrite($myfile, $txt);
        echo json_encode(array("status" => "OK", "result" => $transaction));
        exit;
    }


    public function downloadwallet()
    {
        $output1 = "";
        $output1 .= '"User Id",';
        $output1 .= '"Team name",';
        $output1 .= '"Mobile",';
        $output1 .= '"Balance",';
        $output1 .= '"Winning",';
        $output1 .= '"Bonus",';
        $output1 .= '"GST/TDS",';
        $output1 .= '"Affiliation",';
        $output1 .= "\n";

        $query = DB::table('registerusers')
            ->join('userbalances', 'userbalances.user_id', '=', 'registerusers.id')
            ->select('registerusers.username', 'registerusers.mobile', 'registerusers.team', 'userbalances.*')->get();

        if (!empty($query)) {
            foreach ($query as $get) {
                $output1 .= '"' . $get->id . '",';
                $output1 .= '"' . $get->team . '",';
                $output1 .= '"' . $get->mobile . '",';
                $output1 .= '"' . $get->balance . '",';
                $output1 .= '"' . $get->winning . '",';
                $output1 .= '"' . $get->bonus . '",';
                $output1 .= '"' . $get->gst_bonus . '",';
                $output1 .= '"' . $get->affiliation_commission . '",';
                $output1 .= "\n";
            }
        }
        $filename =  "Details-userwallet.csv";
        header('Content-type: application/csv');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo $output1;
        exit;
    }

    //DEDUCT
    public function deduct_users_amount($id = null, Request $request)
    {

        //Get Satting
        //Get Id
        $id = unserialize(base64_decode($id));
        //print_r($id);die;

        $user = DB::table('userbalances as u')->join('registerusers as r', 'u.user_id', '=', 'r.id')->where('r.id', $id)->select('r.id', 'r.username', 'r.email', 'r.team', 'u.balance', 'u.winning', 'u.bonus', 'u.gst_bonus', 'u.affiliation_commission')->first();
        $formData = Input::all();
        //Insert Data
        if (!empty($formData)) {

            $validate    =    array(
                'deduct_from'  =>    'required',
                'amount' => 'required|numeric',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {

                $input_deduct_from = $formData['deduct_from'];
                $input_amount = $formData['amount'];
                //print_r($obj);die;

                if ($input_deduct_from == 0) {
                    if ($input_amount > $user->balance) {
                        Session::flash('flash_notice', 'Amount is greater than Unutilized amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }

                if ($input_deduct_from == 1) {
                    if ($input_amount > $user->winning) {
                        Session::flash('flash_notice', 'Amount is greater than Winning amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }

                if ($input_deduct_from == 2) {
                    if ($input_amount > $user->bonus) {
                        Session::flash('flash_notice', 'Amount is greater than Bonus amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }
                if ($input_deduct_from == 3) {
                    if ($input_amount > $user->gst_bonus) {
                        Session::flash('flash_notice', 'Amount is greater than GST Coin amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }
                if ($input_deduct_from == 4) {
                    if ($input_amount > $user->affiliation_commission) {
                        Session::flash('flash_notice', 'Amount is greater than Affiliation Commission amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }
                if ($input_deduct_from == 0) {
                    $obj['balance'] = $user->balance - $input_amount;
                } else if ($input_deduct_from == 1) {
                    $obj['winning'] = $user->winning - $input_amount;
                } else if ($input_deduct_from == 2) {
                    $obj['bonus'] = $user->bonus - $input_amount;
                } else if ($input_deduct_from == 3) {
                    $obj['gst_bonus'] = $user->gst_bonus - $input_amount;
                } else if ($input_deduct_from == 4) {
                    $obj['affiliation_commission'] = $user->affiliation_commission - $input_amount;
                }

                //Update
                DB::table('userbalances')->where('user_id', $id)->update($obj);

                $userBalances = DB::table('userbalances')->where('user_id', $id)->first();

                $dedcucttype = 'Amount';


                if ($input_deduct_from == 0) {
                    $dedcucttype = 'Deposit';
                } else if ($input_deduct_from == 1) {
                    $dedcucttype = 'Winning';
                } else if ($input_deduct_from == 2) {
                    $dedcucttype = 'Bonus';
                } else if ($input_deduct_from == 3) {
                    $dedcucttype = 'GST/TDS Bonus';
                } else if ($input_deduct_from == 4) {
                    $dedcucttype = 'Affiliation Amount';
                }


                $trans_id = BRAND['name'] . "-AABA" . time() . $id;
                $transaction['userid'] = $id;
                $transaction['type'] = $dedcucttype . " Deduction By Admin";
                $transaction['transaction_id'] = $trans_id;
                $transaction['transaction_by'] = "wallet";
                $transaction['amount'] = $input_amount;
                $transaction['paymentstatus'] = "confirmed";
                $transaction['bal_bonus_amt'] = $userBalances->bonus;
                $transaction['bal_win_amt'] = $userBalances->winning;
                $transaction['bal_fund_amt'] = $userBalances->balance;
                $transaction['bal_gst_bonus_amt'] = $userBalances->gst_bonus;
                $transaction['cons_gst_bonus'] = $input_deduct_from == 3 ? $input_amount : 0;
                $transaction['cons_affi_amt'] = $input_deduct_from == 4 ? $input_amount : 0;
                $transaction['cons_bonus'] = $input_deduct_from == 2 ? $input_amount : 0;
                $transaction['cons_win'] = $input_deduct_from == 1 ? $input_amount : 0;
                $transaction['cons_amount'] = $input_deduct_from == 0 ? $input_amount : 0;
                $transaction['total_available_amt'] = $userBalances->balance + $userBalances->winning + $userBalances->bonus + $userBalances->gst_bonus + $userBalances->affiliation_commission;
                DB::table('transactions')->insert($transaction);

                Session::flash('flash_notice',  trans("Successfully Update User!"));
                return Redirect::route($this->model . '.users_wallet');
            }
        }
        return view("admin.$this->model.deduct_users_amount", compact('user'));
    } //End

    //Edit UserAMOUNT
    public function edit_users_amount($id = null, Request $request)
    {

        //Get Satting
        //Get Id
        $id = unserialize(base64_decode($id));
        //print_r($id);die;

        $user = DB::table('userbalances as u')->join('registerusers as r', 'u.user_id', '=', 'r.id')->where('r.id', $id)->select('r.id', 'r.username', 'r.email', 'r.team', 'u.balance', 'u.winning', 'u.bonus', 'u.gst_bonus', 'u.affiliation_commission')->first();
        $formData = Input::all();
        //Insert Data
        if (!empty($formData)) {

            $validate    =    array(
                'transfer_from'       =>    'required',
                'transfer_to'     =>    'required',
                'amount' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {

                $input_transfer_from = $formData['transfer_from'];
                $input_transfer_to = $formData['transfer_to'];
                $input_amount = $formData['amount'];
                //print_r($obj);die;

                if ($input_transfer_from == 0) {
                    if ($input_amount > $user->balance) {
                        Session::flash('flash_notice', 'Amount is greater than Unutilized amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }

                if ($input_transfer_from == 1) {
                    if ($input_amount > $user->winning) {
                        Session::flash('flash_notice', 'Amount is greater than Winning amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }

                if ($input_transfer_from == 2) {
                    if ($input_amount > $user->bonus) {
                        Session::flash('flash_notice', 'Amount is greater than Bonus amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }
                if ($input_transfer_from == 3) {
                    if ($input_amount > $user->gst_bonus) {
                        Session::flash('flash_notice', 'Amount is greater than GST/TDS  amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }
                if ($input_transfer_from == 4) {
                    if ($input_amount > $user->affiliation_commission) {
                        Session::flash('flash_notice', 'Amount is greater than Affiliation amount');
                        Session::flash('alert-class', 'alert-danger');
                        return Redirect::back();
                    }
                }

                if ($input_transfer_from == 0 && $input_transfer_to == 0) {
                    Session::flash('error', 'Transfer from and to both same');
                    return Redirect::back();
                }
                if ($input_transfer_from == 1 && $input_transfer_to == 1) {
                    Session::flash('error', 'Transfer from and to both same');
                    return Redirect::back();
                }
                if ($input_transfer_from == 2 && $input_transfer_to == 2) {
                    Session::flash('error', 'Transfer from and to both same');
                    return Redirect::back();
                }
                if ($input_transfer_from == 3 && $input_transfer_to == 3) {
                    Session::flash('error', 'Transfer from and to both same');
                    return Redirect::back();
                }
                if ($input_transfer_from == 4 && $input_transfer_to == 4) {
                    Session::flash('error', 'Transfer from and to both same');
                    return Redirect::back();
                }

                if ($input_transfer_from == 0) {
                    $type = 'Cash';
                    $obj['balance'] = $user->balance - $input_amount;
                } else if ($input_transfer_from == 1) {
                    $type = 'Winning';
                    $obj['winning'] = $user->winning - $input_amount;
                } else if ($input_transfer_from == 2) {
                    $type = 'Bonus';
                    $obj['bonus'] = $user->bonus - $input_amount;
                } else if ($input_transfer_from == 3) {
                    $type = 'GST';
                    $obj['gst_bonus'] = $user->gst_bonus - $input_amount;
                } else if ($input_transfer_from == 4) {
                    $type = 'Affiliation';
                    $obj['affiliation_commission'] = $user->affiliation_commission - $input_amount;
                }

                if ($input_transfer_to == 0) {
                    $typeto = ' To Cash';
                    $obj['balance'] = $user->balance + $input_amount;
                } else if ($input_transfer_to == 1) {
                    $typeto = ' To Winning';
                    $obj['winning'] = $user->winning + $input_amount;
                } else if ($input_transfer_to == 2) {
                    $typeto = ' To Bonus';
                    $obj['bonus'] = $user->bonus + $input_amount;
                } else if ($input_transfer_to == 3) {
                    $typeto = ' To GST/TDS Bonus';
                    $obj['gst_bonus'] = $user->gst_bonus + $input_amount;
                } else if ($input_transfer_to == 4) {
                    $typeto = ' To Affiliation';
                    $obj['affiliation_commission'] = $user->affiliation_commission + $input_amount;
                }

                //Update
                if ($input_transfer_from == 1) {
                    $winningtomax = DB::table('setting')->where('setting_key', 'winning_to_transfer_max')->first();
                    if ($input_amount > $winningtomax->value) {
                        Session::flash('error',  trans("Maximum limit " . $winningtomax->value));
                        return Redirect::back();
                    }

                    $winningtomin = DB::table('setting')->where('setting_key', 'winning_to_transfer_min')->first();
                    if ($input_amount >= $winningtomin->value) {
                        $winningtocash = DB::table('setting')->where('setting_key', 'winning_to_deposit_extra_commission')->first();
                        $userbalance = DB::table('userbalances')->where('user_id', $id)->first();

                        $today_date = date('Y-m-d');
                        $check_multi_request = DB::table('winning_commission')->where('status', 1)->where('userid', $id)->where('created', 'like', '%' . $today_date . '%')->count();

                        $limit = DB::table('setting')->where('setting_key', 'winning_to_transfer_per_day_limit')->first();
                        if ($check_multi_request >= $limit->value) {
                            Session::flash('error',  trans("More than " . $limit->value . " transfer request cannot be done on same day."));
                            return Redirect::back();
                        }


                        //$commission= round(($input_amount*6)/100,2);
                        $commission = round(($input_amount * $winningtocash->value) / 100, 2);
                        $totaladdamount = $commission;
                        $userdata['balance'] = $userbalance->balance + $input_amount;
                        $userdata['winning'] = $userbalance->winning - $input_amount;


                        DB::table('userbalances')->where('user_id', $id)->update($userdata);
                        $userbalance = DB::table('userbalances')->where('user_id', $id)->first();
                        $totalbalanceremaing = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;

                        $transaction = array(
                            'userid' => $id,
                            'type' => 'Credited Cash Winning To Deposit',
                            'transaction_id' => BRAND['name'] . '-WINNDEPO-' . rand(100, 999) . $id,
                            'transaction_by' => 'PLAYNWIN11',
                            'amount' => $input_amount,
                            'paymentstatus' => 'confirmed',
                            'bal_gst_bonus_amt' => $userbalance->gst_bonus,
                            'bal_bonus_amt' => $userbalance->bonus,
                            'bal_win_amt' => $userbalance->winning,
                            'bal_fund_amt' => $userbalance->balance,
                            'bal_affi_amt' => $userbalance->affiliation_commission,
                            'total_available_amt' => $totalbalanceremaing
                        );
                        DB::table('transactions')->insert($transaction);

                        // Real cash add
                        $userbalance = DB::table('userbalances')->where('user_id', $id)->first();
                        $userdata['gst_bonus'] = $userbalance->gst_bonus + $totaladdamount;
                        DB::table('userbalances')->where('user_id', $id)->update($userdata);
                        $userbalance = DB::table('userbalances')->where('user_id', $id)->first();
                        $totalbalanceremaing = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                        $transaction1 = array(
                            'userid' => $id,
                            'type' => 'Credited additional real cash from PLAYNWIN11',
                            'transaction_id' => BRAND['name'] . '-REALCASH-' . rand(100, 999) . $id,
                            'transaction_by' => 'PLAYNWIN11',
                            'amount' => $totaladdamount,
                            'paymentstatus' => 'confirmed',
                            'bal_gst_bonus_amt' => $userbalance->gst_bonus,
                            'bal_bonus_amt' => $userbalance->bonus,
                            'bal_win_amt' => $userbalance->winning,
                            'bal_fund_amt' => $userbalance->balance,
                            'addfund_amt' => $commission,
                            'bal_affi_amt' => $userbalance->affiliation_commission,
                            'total_available_amt' => $totalbalanceremaing
                        );
                        DB::table('transactions')->insert($transaction1);


                        $tds_new["userid"] = $id;
                        $tds_new["transaction_id"] = BRAND['name'] . '-WINNTOCASH-' . rand(100, 999) . $id;
                        $tds_new["amount"] = $input_amount;
                        $tds_new["commission"] = $commission;
                        $tds_new["date"] = date('Y:m:d H:i:s');
                        $tds_new_id = DB::table("winning_commission")->insertGetId($tds_new);
                    } else {
                        Session::flash('error',  trans("Minimum amount transfer " . $winningtomin->value));
                        return Redirect::back();
                    }
                } else {
                    DB::table('userbalances')->where('user_id', $id)->update($obj);

                    $userBalances = DB::table('userbalances')->where('user_id', $id)->first();

                    $trans_id = BRAND['name'] . "-AABA" . time() . $id;
                    $transaction['userid'] = $id;
                    $transaction['type'] = $type . $typeto . " Amount Adjustments By Admin";
                    $transaction['transaction_id'] = $trans_id;
                    $transaction['transaction_by'] = BRAND['name'];
                    $transaction['amount'] = $input_amount;
                    $transaction['paymentstatus'] = "confirmed";
                    $transaction['bonus_amt'] = $input_transfer_to == 2 ? $input_amount : 0;
                    $transaction['win_amt'] = $input_transfer_to == 1 ? $input_amount : 0;
                    $transaction['addfund_amt'] = $input_transfer_to == 0 ? $input_amount : 0;
                    $transaction['gst_bonus_amt'] = $input_transfer_to == 3 ? $input_amount : 0;
                    $transaction['affiliation_amount'] = $input_transfer_to == 4 ? $input_amount : 0;
                    $transaction['bal_bonus_amt'] = $userBalances->bonus;
                    $transaction['bal_win_amt'] = $userBalances->winning;
                    $transaction['bal_fund_amt'] = $userBalances->balance;
                    $transaction['bal_gst_bonus_amt'] = $userBalances->gst_bonus;
                    $transaction['bal_affi_amt'] = $userBalances->affiliation_commission;
                    $transaction['total_available_amt'] = $userBalances->balance + $userBalances->winning + $userBalances->bonus + $userBalances->gst_bonus + $userBalances->affiliation_commission;
                    DB::table('transactions')->insert($transaction);
                }

                Session::flash('flash_notice',  trans("Successfully Update User!"));
                return Redirect::route($this->model . '.users_wallet');
            }
        }
        return view("admin.$this->model.edit_users_amount", compact('user'));
    } //End

    public function checkCashfreeTransaferStatus($transfer_id)
    {

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => CF_URL . '/payout/v1/authorize',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array(
                'X-Client-Id: ' . CF_CLIENT_ID,
                'X-Client-Secret: ' . CF_CLIENT_SECRET
            ),
        ));

        $result = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($result);
        $result_data = @$result->data;
        $token = @$result_data->token;

        if (!empty($token)) {
            // echo $token."<br>";
            $headers = array();
            $headers[] = "Authorization: Bearer " . $token;
            $headers[] = "Cache-Control: no-cache";
            //get balance of cashfree

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => CF_URL . "/payout/v1/getBalance",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => $headers,
            ));

            $result = curl_exec($curl);
            $result = json_decode($result);
            $result_data = @$result->data;
            echo "s<pre>";
            print_r($result_data);
            // exit();

            //end

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => CF_URL . "/payout/v1/getTransferStatus?transferId=$transfer_id",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => $headers,
            ));

            $result = curl_exec($curl);
            $result = json_decode($result);
            $result_data = @$result->data;
            echo "s<pre>";
            print_r($result_data);
        }
    }


    //Verify adhar List
    public function verifyadhar(Request $req)
    {
        // dd($req->all());
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    $query = DB::table('adhar_card_details as p')
                        ->join('registerusers as r', 'r.id', '=', 'p.userid')
                        ->where('p.status', '0')
                        ->where('r.mobile_verify', '1')
                        ->where('r.email_verify', '1')
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['filter_columns'])) {
                                if (isset($formData['filter_columns']['filter_username'])) {
                                    $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                                }
                                if (isset($formData['filter_columns']['filter_email'])) {
                                    $query->where('r.email', 'like', '%' . $formData['filter_columns']['filter_email'] . '%');
                                }
                            }
                        })
                        ->select('r.email', 'r.username', 'r.mobile_verify', 'r.email_verify', 'p.*')
                        ->orderBY('p.created_at', 'ASC')
                        ->get()
                )
                    ->addIndexColumn()
                    ->addColumn('email', function ($result) {
                        return '<a href="' . route($this->model . '.view_adhar_details', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="' . $result->id . '" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->email . '</a>';
                    })
                    ->addColumn('username', function ($result) {
                        if (!empty($result->email)) {
                            return $result->username;
                        } else {

                            return '<a href="' . route($this->model . '.view_adhar_details', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">' . $result->username . '</a>';
                        }
                    })
                    ->addColumn('created_at', function ($result) {
                        if ($result->created_at != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->created_at));
                        } else {
                            return '';
                        }
                    })

                    ->addColumn('status', function ($result) {
                        $status = '';
                        if ($result->status == '1') {
                            $status = 'Verified';
                        } elseif ($result->status == '0') {
                            $status = 'Pending';
                        } elseif ($result->status == '2') {
                            $status = 'Cancel';
                        }
                        return $status;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end

        }

        return view("admin.$this->model.verifyadhar");
    } //End Function

    //View adhar Detail
    public function viewadhardetails($id)
    {
        $id = unserialize(base64_decode($id));
        // dd($id);
        //Get Data
        $pancarddetails = DB::table('adhar_card_details')
            ->where('adhar_card_details.id', $id)
            ->join('registerusers', 'registerusers.id', '=', 'adhar_card_details.userid')
            ->select('adhar_card_details.*', 'registerusers.email', 'registerusers.dob')
            ->first();
        // echo "<pre>"; print_r($pancarddetails); die();
        if (!empty($pancarddetails)) {
            return view("admin.$this->model.viewadhardetails", compact('pancarddetails'));
        } else {
            Session::flash('error', 'Data Not Found!');
            return Redirect::back();
        }
    } //End Function

    //Update adhar Status
    public function updateadharstatus(Request $request)
    {
        //  print_r($request->all()); exit;
        $status = "";
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];
            $status = $input['status'];
            if (isset($input['adhar_number'])) {
                $input['adhar_number'] = strtoupper($input['adhar_number']);
            }
            if (isset($input['virtual_adhar_id'])) {
                $input['virtual_adhar_id'] = strtoupper($input['virtual_adhar_id']);
            }
            if (isset($input['front_image'])) {
                $filee = array_filter($input['front_image']);
                unset($input['front_image']);
                if (!empty($filee)) {
                    $destinationPath = 'uploads';
                    $oldimage = $input['oldimage'];
                    if ($oldimage != "") {
                        File::delete($oldimage);
                    }
                    unset($input['oldimage']);
                    if (!empty($filee)) {
                        $fileName  = 'select2win-pancard-' . rand(100, 999);
                        $imageName = Helpers::imageUpload($filee, $destinationPath, $fileName);
                        $input['front_image'] = config()->get('constants.PROJECT_URL') . 'uploads/users/' . $imageName;
                    }
                }
            }
            unset($input['oldimage']);
        }
        if ($status != "") {
            if ($status == 1) {
                $st = 'Verified';
            }
        }
        unset($input['_token']);
        $req['aadhar_verify'] = $status;
        DB::table('adhar_card_details')->where('id', $id)->update($input);
        $findlastow = DB::table('adhar_card_details')->where('id', $id)->first();
        if (!empty($findlastow)) {
            $userid = $findlastow->userid;
        }
        $finduserbonus = DB::table('registerusers')->where('id', $userid)->select('panbonus', 'email', 'team')->first();
        if ($status == 1) {
            $st = 'Verified';
        }
        if ($status == 2) {
            $st = 'rejected';
            $email = $finduserbonus->email;

            Helpers::logActivity('Aadhar Request Rejected', $userid);
            //Send Mail Template
            // $email_templates = DB::table('email_templates')->where('action','Adhar Card Request approved')->first();
            //Set Subject
            // $emailsubject = $email_templates->subject.'- FC';
            // //Set Email Body
            // $email_body=array('{NAME}','{comment}');
            // //Replace
            // $rep_Array =array(ucwords($finduserbonus->team),$input['comment']);
            // //Replase Value
            // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
            // //Send MAil
            // $msg = Helpers::mailheader();
            // $msg.= $messageBody;
            // $msg.= Helpers::mailfooter();
            // Helpers::mailsentFormat($email,$emailsubject,$msg);
        }
        // if($st=='Verified'){
        //   $req['username']=$findlastow->pan_name;
        //   $req['dob']=date('Y-m-d',strtotime($findlastow->pan_dob));
        //   $req['panbonus']=1;
        //   if($finduserbonus->panbonus==0){
        //     //ApiController::getbonus($userid,'Pan Card');
        //   }
        //
        //   if($finduserbonus->panbonus == 0) {
        $userbalance = UserBalance::where("user_id", $userid)->first();
        //     if(!empty($userbalance)) {
        //       $userbalance->bonus += PAN_VERIFY_BONUS_AMT;
        //       $userbalance->save();
        //
        if (empty($userbalance)) {
            DB::table('userbalances')->insert(['user_id' => $userid]);
        }
        if ($status == 1) {
            DB::table('registerusers')->where('id', $userid)->update($req);
            $exist_signup = DB::table('transactions')->where('userid', $userid)->where('type', ADHAR_VERIFY_SIGNUP_BONUS_STMT)->count();
            // if($exist_signup<1){
            //       $userbalance = UserBalance::where("user_id", $userid)->first();
            //       if(!empty($userbalance)) {
            //         $userbalance->bonus += ADHAR_VERIFY_SIGNUP_BONUS;
            //         $userbalance->save();
            //
            //         Transaction::insert([
            //           'userid'=> $userid,
            //           'amount' => ADHAR_VERIFY_SIGNUP_BONUS,
            //           'type' => ADHAR_VERIFY_SIGNUP_BONUS_STMT,
            //           'paymentstatus' => 'confirmed',
            //           'transaction_by' => 'PLAYNWIN11',
            //           'transaction_id' => 'PLAYNWIN11-SIGNUP-'.time(),
            //           'bonus_amt' => ADHAR_VERIFY_SIGNUP_BONUS,
            //           'bal_fund_amt' => $userbalance->balance,
            //           'bal_win_amt' => $userbalance->winning,
            //           'bal_bonus_amt' => $userbalance->bonus,
            //           'bal_gst_bonus_amt' => $userbalance->gst_bonus,
            //           'bal_affi_amt' => $userbalance->affiliation_commission,
            //           'total_available_amt' => round(($userbalance->balance+$userbalance->winning+$userbalance->bonus+$userbalance->gst_bonus+$userbalance->affiliation_commission),2)
            //         ]);
            //       }
            //   }
            Helpers::logActivity('Aadhar Request Approved', $userid);
        }
        //
        //     }
        //   }
        //Email
        //  $email = $finduserbonus->email;
        //Send Mail Template
        //  $email_templates = DB::table('email_templates')->where('action','Your PAN card documents approved')->first();
        //Set Subject
        // print_r($email_templates);die;
        // $emailsubject = $email_templates->subject.'- FC';
        // //Set Email Body
        // $email_body=array('{NAME}');
        // //Replace
        // $rep_Array =array(ucwords($finduserbonus->team));
        // //Replase Value
        // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
        // $msg = Helpers::mailheader();
        // $msg.= $messageBody;
        // $msg.= Helpers::mailfooter();
        // Helpers::mailsentFormat($email,$emailsubject,$msg);
        //  }
        Helpers::logActivity('ADHAR card verification request is' . $st . '!', $userid);

        DB::table('registerusers')->where('id', $userid)->update($req);
        $notificationdata['userid'] = $userid;
        $notificationdata['title'] = 'Your ADHAR card verification request is ' . $st;
        DB::table('notifications')->insert($notificationdata);
        //push notifications//
        $titleget = 'Verification Request!';
        Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
        //end push notifications//
        Session::flash('flash_notice', 'ADHAR Card Request is ' . $st . '!');
        return Redirect::back();
    } //End Functions


    public function editupidetails(Request $request, $id)
    {

        //Get ID Unserialize
        $id = unserialize(base64_decode($id));
        //Get Pan Card Data
        $editupidetails = DB::table('upi_verify')->where('id', $id)->first();

        if ($request->isMethod('post')) {

            //Velidation Bank
            $validate = array(
                'upi_id'              => "required",
                // 'virtual_adhar_id'                => "required",
                // 'pan_dob'              	  => "required",
                // 'status'              	  => "required",
                // 'comment'              	  => "required",
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Get Input data
                $input = Input::all();
                // dd($input);
                //Set Value
                //  $status=$input['status'];
                //  $fiends['upi_id'] = $input['adhar_number');


                unset($input['_token']);

                //print_r($input);die;
                DB::table('upi_verify')->where('id', $id)->update($input);
                $findlastow = DB::table('upi_verify')->where('id', $id)->first();
                // if(!empty($findlastow)){
                //   $userid = $findlastow->userid;
                // }
                // $finduserbonus = DB::table('registerusers')->where('id',$userid)->select('panbonus','email','team')->first();


                // $notificationdata['userid'] = $userid;
                // $notificationdata['title'] = 'Your ADHAR card verification request is '.$st;

                //push notifications//
                $titleget = 'Verification Request!';
                //  Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
                //end push notifications//
                Session::flash('flash_notice', 'UPI Id Update successfully!');
                Session::flash('alert-class', 'alert-success');
                //return Redirect::back();
                return Redirect::route($this->model . '.view_upi_details', base64_encode(serialize($id)));
            } //Validation
        } //EndCkeck Empty Val
        //Show Page
        return view("admin.$this->model.editupidetails", compact('editupidetails'));
    }

    //edit-adhar-details
    public function editadhardetails(Request $request, $id)
    {

        // echo "kk";die();

        //Get ID Unserialize
        $id = unserialize(base64_decode($id));
        //Get Pan Card Data
        $editpandetails = DB::table('adhar_card_details')->where('id', $id)->first();

        if ($request->isMethod('post')) {
            //Velidation Bank
            $validate = array(
                'adhar_number'              => "required|min:12|max:12",
                // 'virtual_adhar_id'                => "required",
                // 'pan_dob'              	  => "required",
                'status'                    => "required",
                'comment'                    => "required",
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Get Input data
                $input = Input::all();
                // dd($input);
                //Set Value
                $status = $input['status'];
                $fiends['adhar_number'] = strtoupper($input['adhar_number']);
                // $fiends['virtual_adhar_id'] = $input['virtual_adhar_id'];

                if (isset($input['front_image'])) {
                    $filee = array_filter($input['front_image']);
                    unset($input['front_image']);
                    if (!empty($filee)) {
                        $destinationPath = 'uploads/users';
                        // dd($destinationPath);
                        $oldimage = $input['oldimage'];
                        if ($oldimage != "") {
                            File::delete($oldimage);
                        }
                        unset($input['oldimage']);
                        if (!empty($filee)) {
                            $fileName  = 'select2win-aadharcard-' . rand(100, 999);
                            $imageName = Helpers::imageUpload($filee, $destinationPath, $fileName);
                            // dd($imageName);
                            $input['front_image'] = USERS_DIRECTORY_URL . $imageName;
                        }
                    }
                }
                unset($input['oldimage']);
                if (isset($input['back_image'])) {
                    $filee = array_filter($input['back_image']);
                    unset($input['back_image']);
                    if (!empty($filee)) {
                        $destinationPath = 'uploads/users';
                        // dd($destinationPath);
                        // $oldimage = $input['oldimage'];
                        // if($oldimage!=""){
                        //   File::delete($oldimage);
                        // }
                        unset($input['oldimage']);
                        if (!empty($filee)) {
                            $fileName  = 'select2win-aadharcard-' . rand(100, 999);
                            $imageName = Helpers::imageUpload($filee, $destinationPath, $fileName);
                            // dd($imageName);
                            $input['back_image'] = USERS_DIRECTORY_URL . $imageName;
                        }
                    }
                }
                unset($input['oldimage']);



                //       $input	=	$request->all();
                //       // dd($input);
                //       if (!empty($input['image'])) {
                //         if($input['image'] && $input['base64image'] == ""){
                //                 if(Input::hasFile('image')){
                //                         $extension =	Input::file('image')->getClientOriginalExtension();
                //                         $img_ext = explode(",",IMAGE_EXTENSION);
                //                         // dd($img_ext);
                //                         if(in_array($extension,$img_ext)){
                //                           $fileName='gamechela-pancard-'.rand(100,999).'.'.$extension;
                //                           if(Input::file('image')->move('uploads/users/', $fileName)){
                //                             $input['image']	=	$fileName;
                //                           }
                //                           // Helpers::aws_upload_image(ADVERTISMENTS_PROFILE_IMAGE_ROOT_PATH.$fileName, "uploads/banners/",$fileName);
                //                         }else{
                //                           Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
                //                           return Redirect::back()->withInput();
                //                         }
                //                       }
                //                   }
                //               else{
                //
                //                 if ($input['base64image'] || $input['base64image'] != '0') {
                //                   $destinationPath = 'uploads/users/';
                //                     // dd($destinationPath);
                //                     $image_parts = explode(";base64,", $input['base64image']);
                //                     $image_type_aux = explode("image/", $image_parts[0]);
                //                     $image_type = $image_type_aux[1];
                //                     $image_base64 = base64_decode($image_parts[1]);
                //                     // dd($image_base64);
                //                     // $fileName = 'Gamechela-team-'.str_replace(' ', '-', $formData['team_key']);
                //                     $fileName = BRAND['name'].'gamechela-pancard'.$image_type;
                //                     // dd($fileName);
                //
                //                     // dd($fileName);
                //                     // $imageName = CustomHelper::imageUpload($file,$destinationPath,$fileName);
                //                     // $filename = BRAND['name'].'-player-'.$image_type;
                //                     $file =$destinationPath.$fileName;
                //                     file_put_contents($file, $image_base64);
                //                     $input['image'] = $fileName;
                //                 }
                //               }
                //       }
                //
                //
                //
                // if($input['image'] || $input['base64image'] || $input['base64image'] != '0'){
                //
                //     $input = [
                //       'pan_name' => $input['pan_name'],
                //       'pan_number' => $input['pan_number'],
                //       'pan_dob' => $input['pan_dob'],
                //       'status' => $input['status'],
                //       'comment' => $input['comment'],
                //       'id' => $input['id'],
                //       'image' => $input['image'],
                //     ];
                //   }else{
                //
                //   }
                // dd('dd');


                if ($status != "") {
                    if ($status == 1) {
                        $st = 'Verified';
                    }
                }
                unset($input['_token']);
                $req['aadhar_verify'] = $status;

                //print_r($input);die;
                DB::table('adhar_card_details')->where('id', $id)->update($input);
                $findlastow = DB::table('adhar_card_details')->where('id', $id)->first();
                if (!empty($findlastow)) {
                    $userid = $findlastow->userid;
                }
                $finduserbonus = DB::table('registerusers')->where('id', $userid)->select('panbonus', 'email', 'team')->first();
                if ($status == 1) {
                    $st = 'Verified';
                }
                if ($status == 2) {
                    $st = 'rejected';
                    $email = $finduserbonus->email;
                    //Send Mail Template
                    $email_templates = DB::table('email_templates')->where('action', 'Your PAN card documents were not approved')->first();


                    // echo"<pre>";print_r($email_templates);exit;
                    //Set Subject
                    // $emailsubject = $email_templates->subject.'- FC';
                    //Set Email Body
                    $email_body = array('{NAME}', '{COMMENT}');
                    //Replace
                    $rep_Array = array(ucwords($finduserbonus->team), $input['comment']);
                    //Replase Value

                    // $messageBody = str_replace($email_body,$rep_Array,$email_templates->body);
                    //Send Mail
                    $msg = Helpers::mailheader();
                    // $msg.= $messageBody;
                    $msg .= Helpers::mailfooter();
                    // Helpers::mailsentFormat($email,$emailsubject,$msg);
                }
                if ($st == 'Verified') {
                    $req['username'] = $findlastow->adhar_number;
                    $req['dob'] = date('Y-m-d', strtotime($findlastow->virtual_adhar_id));
                    $req['panbonus'] = 1;
                    if ($finduserbonus->panbonus == 0) {
                        //ApiController::getbonus($userid,'Pan Card');
                    }
                    $email = $finduserbonus->email;
                    //Send Mail Template
                    $email_templates = DB::table('email_templates')->where('action', 'PAN Card Documents Approved')->first();
                    //Set Subject
                    $emailsubject = '- FC';
                    //Set Email Body
                    $email_body = array('{NAME}');
                    //Replace
                    $rep_Array = array(ucwords($finduserbonus->team));
                    //Replase Value
                    $messageBody = str_replace($email_body, $rep_Array, $email_body);
                    //Send Mail

                    $msg = Helpers::mailheader();
                    $msg .= $messageBody[0];
                    $msg .= Helpers::mailfooter();

                    Helpers::mailsentFormat($email, $emailsubject, $msg);
                }
                // if($st=='Verified'){
                //   $req['username']=$findlastow->adhar_number;
                //   $req['dob']=date('Y-m-d',strtotime($findlastow->virtual_adhar_id));
                //   $req['panbonus']=1;
                //   if($finduserbonus->panbonus==0){
                //     //ApiController::getbonus($userid,'Pan Card');
                //   }
                //   $email = $finduserbonus->email;
                //   //Send Mail Template
                //   $email_templates = DB::table('email_templates')->where('action','ADHAR Card Documents Approved')->first();
                //   //Set Subject
                //   $emailsubject = '- FC';
                //   //Set Email Body
                //   $email_body=array('{NAME}');
                //   //Replace
                //   $rep_Array =array(ucwords($finduserbonus->team));
                //   //Replase Value
                //   $messageBody = str_replace($email_body,$rep_Array,$email_body);
                //   //Send Mail
                //
                //   $msg = Helpers::mailheader();
                //   $msg.= $messageBody[0];
                //   $msg.= Helpers::mailfooter();
                //
                //   Helpers::mailsentFormat($email,$emailsubject,$msg);
                //   if($finduserbonus->panbonus == 0) {
                //     $userbalance = UserBalance::where("user_id", $userid)->first();
                //     if(!empty($userbalance)) {
                //       $userbalance->bonus += PAN_VERIFY_BONUS_AMT;
                //       $userbalance->save();
                //
                //       Transaction::insert([
                //         'userid'=> $userid,
                //         'amount' => PAN_VERIFY_BONUS_AMT,
                //         'type' => PAN_VERIFY_BONUS_TYPE,
                //         'paymentstatus' => 'confirmed',
                //         'transaction_by' => BRAND['name'],
                //         'transaction_id' => BRAND['name'].time().$userid.rand(11,99),
                //         'bonus_amt' => PAN_VERIFY_BONUS_AMT,
                //         'bal_fund_amt' => $userbalance->balance,
                //         'bal_win_amt' => $userbalance->winning,
                //         'bal_bonus_amt' => $userbalance->bonus,
                //         'total_available_amt' => round(($userbalance->balance+$userbalance->winning+$userbalance->bonus),2)
                //       ]);
                //
                //     }
                //   }
                // }
                // print_r($req); exit;
                DB::table('registerusers')->where('id', $userid)->update($req);
                $notificationdata['userid'] = $userid;
                $notificationdata['title'] = 'Your ADHAR card verification request is ' . $st;
                if ($st != 'Verified') {
                    $notificationdata['title'] = 'Your Bank documents request is ' . $st . ' Due to ' . $input['comment'];
                }
                DB::table('notifications')->insert($notificationdata);
                //push notifications//
                $titleget = 'Verification Request!';
                Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);
                //end push notifications//
                Session::flash('flash_notice', 'ADHAR Card Request is ' . $st . '!');
                Session::flash('alert-class', 'alert-success');
                //return Redirect::back();
                return Redirect::route($this->model . '.view_adhar_details', base64_encode(serialize($id)));
            } //Validation
        } //EndCkeck Empty Val
        //Show Page
        return view("admin.$this->model.editadhardetails", compact('editpandetails'));
    }


    public function razorpay_payouts_cron()
    {
        // $razorpay_key_id='rzp_live_Z3dpgmmVyXhJ0M';
        $razorpay_key_id = 'rzp_live_od8A1KotZ88AoT';
        //$razorpay_key_scrireference_idpt='wm5F6ieNsD6RMYcuSjaRX7vw';
        $razorpay_key_scrireference_idpt = 'FD7k8SuCXpyEsXsDhlGEd13N';
        $find_withdraw = DB::table('withdraw')
            ->where('status', 18)
            ->where('transfer_from', 1)
            //->where('id',465)
            ->where('type', 'bank')
            //  ->limit(1)
            ->get();

        foreach ($find_withdraw as $withdraw) {
            try {
                $razorpay_multiple_request_handle['withdraw_id'] = $withdraw->id;
                $type = "BANK";
                $bank = DB::table('bank')->where('status', 1)->where('userid', $withdraw->user_id)->first();

                if (empty($bank)) {
                    $type = "UPI";
                    $bank = DB::table('upi_verify')->where('status', 1)->where('user_id', $withdraw->user_id)->select('id', 'upi_id as accno')->first();
                }

                //dd($bank);

                $users = DB::table('registerusers')->where('activation_status', 'activated')->where('id', $withdraw->user_id)->first();
                // dd($users);

                $dbRazaorStat = DB::table('razorpay_response')->where('withdraw_id', $withdraw->id)->where('razorpay_status', "!=", null)->orderBy('id', "DESC")->first();
                //  dd($dbRazaorStat);

                DB::table('razorpay_multiple_request_handle')->insert($razorpay_multiple_request_handle);
                if (!empty($dbRazaorStat)) {

                    $response = Helpers::rozarpaypayoutStatus($bank, $users, $withdraw, $dbRazaorStat->razorpay_pout_id);
                    //echo '<pre>';  print_r($response);exit;
                    // $url = 'curl -u '.$razorpay_key_id.':'.$razorpay_key_script.' \-X GET https://api.razorpay.com/v1/payouts/'.$dbRazaorStat->razorpay_pout_id'. \-H "Content-Type: application/json"';
                    //  $response   = self:: shell_exec_url($url);
                    $data1 = array();
                    if (isset($response->status) && strtolower($response->status) == strtolower('reversed')) {
                        $data1['status'] = 0;
                        $data1['razorpay_status'] = "reversed";
                        DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
                    }
                    continue;
                }


                if (isset($bank->id) && !empty($bank->id)  && isset($users->id) &&  !empty($users->id)) {

                    $response = Helpers::rozarpaypayout($bank, $users, $withdraw, $type);

                    $notes = array();
                    $notes["notes_key_1"] = "user withdraw Payment ";
                    $notes["notes_key_2"] = "Focu11 razorpay payouts ";
                    //user details
                    $contacts = array();
                    $contacts["name"] = @$bank->ac_holder_name;
                    $contacts["email"] = $users->email;
                    $contacts["contact"] = $users->mobile;
                    $contacts["type"] = "customer";
                    $contacts["reference_id"] = "User" . $users->id;
                    $contacts["notes"] = $notes;
                    //user Bank details
                    $bankAccount = array();
                    $bankAccount["name"] = @$bank->ac_holder_name;
                    $bankAccount["ifsc"] = @$bank->ifsc;
                    $bankAccount["account_number"] = @$bank->accno;

                    $fundaccount = array();
                    $fundaccount["account_type"] = "bank_account";
                    $fundaccount["bank_account"] = $bankAccount;
                    $fundaccount["contact"] = $contacts;
                    $withdrawAmount = round($withdraw->amount, 2);
                    $withdrawAmountArr = explode(".", $withdrawAmount);
                    // dd($withdrawAmountArr);
                    if (isset($withdrawAmountArr[1])) {
                        $totalPaisa = $withdrawAmountArr[0] * 100 + $withdrawAmountArr[1];
                    } else {
                        $totalPaisa = $withdrawAmountArr[0] * 100;
                    }

                    $from_account = array();
                    $from_account["account_number"] = '409662910410';
                    //  $from_account["fund_account_id"]='fa_00000000000003';
                    $from_account["amount"] = $totalPaisa;
                    $from_account["currency"] = "INR";
                    $from_account["mode"] = "IMPS";
                    $from_account["purpose"] = "payout";
                    $from_account["fund_account"]['account_type'] = "bank_account";
                    $from_account["fund_account"]['bank_account'] = $bankAccount;
                    $from_account["fund_account"]['contact'] = $contacts;
                    //  $from_account["fund_account"]=$fundaccount;
                    $from_account["queue_if_low_balance"] = true;
                    $from_account["reference_id"] = "withdraw_" . $users->id;
                    $from_account["narration"] = "Winnings";
                    $from_account["notes"] = $notes;
                    $withdraw_id = $withdraw->id;
                    $appkey = $razorpay_key_id . ':' . $razorpay_key_scrireference_idpt;
                    $token = base64_encode($appkey);

                    $data1 = array();
                    if (isset($response->status) && strtolower($response->status) == strtolower('processing') ||  isset($response->status) && strtolower($response->status) == strtolower('processed')) {
                        $data1 = array();

                        $withdrawCheck = "withdraw_" . $withdraw->id;
                        if ($response->reference_id == $withdrawCheck) {
                            $data1['status'] = 22;
                            $data1['razorpay_pout_id'] = @$response->id;
                            $data1['razorpay_status'] = $response->status;
                        } else {
                            $data1['status'] = 99;
                            $data1['razorpay_pout_id'] = @$response->id;
                            $data1['razorpay_status'] = $response->status;
                        }

                        // $data1['status'] = 22;
                        // $data1['razorpay_pout_id'] = $response->id;
                        // $data1['razorpay_status'] = $response->status;
                        $responseData = array();
                        $responseData["user_id"] = $users->id;
                        $responseData["bank_id"] = $bank->id;
                        $responseData["withdraw_id"] = $withdraw->id;
                        $responseData["razorpay_pout_id"] = @$response->id;
                        $responseData["razorpay_merchant_id"] = @$response->merchant_id;
                        $responseData["status"] = $data1["status"];
                        $responseData["razorpay_created_at"] = @$response->created_at;
                        $responseData["razorpay_purpose"] = @$response->purpose;
                        $responseData["razorpay_amount"] = @$response->amount;
                        $responseData["razorpay_result"] = json_encode($response, true);
                        $responseData["razorpay_status"] = @$response->status;
                        $responseData["razorpay_request"] = json_encode($from_account, true);
                    } elseif (isset($response->status) && strtolower($response->status) == strtolower('reversed')) {
                        $data1['status'] = 0;
                        $data1['razorpay_status'] = "reversed";
                        DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
                    } elseif (isset($response->status) && strtolower($response->status) == strtolower('failed')) {
                        $data1['status'] = 0;
                        $data1['razorpay_status'] = "failed";
                        DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
                    } else {
                        $data1 = array();
                        $data1['status'] = 0;

                        // $data1['status'] = 22;
                        $data1['razorpay_pout_id'] = @$response->id;
                        if (isset($response->status)) {
                            $data1['status'] = 22;
                            if (@$response->status == 'queued') {
                                $data1['status'] = 22;
                            }
                            if (@$response->status_details->description == 'Payout is queued as Partner bank systems are down') {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == "Beneficiary bank's systems are not working. Payout will be processed after the system starts working else it will be failed after the pre-defined time limit.") {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == 'Payout is queued as Partner bank systems are down') {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == 'Payout is processed and the money has been credited into the beneficiary account.') {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == 'Payout is queued as there is insufficient balance in your account to process the payout.') {
                                $data1['status'] = 22;
                            }
                            // $data1['razorpay_status'] =   $response->status;
                            $data1['razorpay_status'] =   @$response->status_details->description;
                        } else {

                            if (@$response->status_details->description == 'Payout is queued as Partner bank systems are down') {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == "Beneficiary bank's systems are not working. Payout will be processed after the system starts working else it will be failed after the pre-defined time limit.") {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == 'Payout is queued as Partner bank systems are down') {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == 'Payout is processed and the money has been credited into the beneficiary account.') {
                                $data1['status'] = 22;
                            }
                            if (@$response->error->description == 'Payout is queued as there is insufficient balance in your account to process the payout.') {
                                $data1['status'] = 22;
                            } else {

                                //$data1['status']=0;
                                $data1['status'] = 0;
                                $data1['razorpay_status'] =   @$response->error->description;
                                // code...
                            }
                        }
                        // var_dump($response);exit;


                        // if($response->status=='Payout is queued as Partner bank systems are down')
                        // {
                        //     $responseData["status"]=22;
                        // }

                        $responseData = array();
                        $responseData["user_id"] = $users->id;
                        $responseData["bank_id"] = $bank->id;
                        $responseData["withdraw_id"] = $withdraw->id;
                        $responseData["razorpay_pout_id"] = @$response->id;
                        $responseData["razorpay_merchant_id"] = @$response->merchant_id;
                        $responseData["status"] = $data1["status"];
                        $responseData["razorpay_created_at"] = @$response->created_at;
                        $responseData["razorpay_purpose"] = @$response->purpose;
                        $responseData["razorpay_amount"] = @$response->amount;
                        $responseData["razorpay_result"] = json_encode($response, true);
                        $responseData["razorpay_status"] = @$response->status;
                        $responseData["razorpay_request"] = json_encode($from_account, true);
                    }
                    try {
                        DB::table('razorpay_response')->insert($responseData);
                        DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
                    } catch (\Exception $e) {
                        echo   $e->getMessage();
                    }
                    echo "record update successfully ";
                }
            } catch (\Exception $e) {
            }
        }
        echo 'No data found';
    }


    public function razorpayinstantProcessed()
    {
        $find_withdraw = DB::table('withdraw')
            ->where('status', 22)
            // ->where('id',12986)
            //->where('is_instant',1)
            ->where('type', 'bank')
            //->whereIn('user_id' , [1])
            ->limit(500)
            ->orderBy('id', 'DESC')
            ->get();




        foreach ($find_withdraw as $key => $withdraw) {
            $bank = DB::table('bank')->where('status', 1)->where('userid', $withdraw->user_id)->first();
            $users = DB::table('registerusers')->where('activation_status', 'activated')->where('id', $withdraw->user_id)->first();
            $pout_id = $withdraw->razorpay_pout_id;
            $response   = Helpers::rozarpaypayoutStatus($bank, $users, $withdraw, $pout_id);
            // echo '<pre>'; print_r($response );exit;
            $data1 = array();
            // if(isset($response->error)){
            //   if($response->error->code == "BAD_REQUEST_ERROR" && $response->error->field == "account_number"){
            //     $data1['status'] = 0;
            //     $data1['razorpay_pout_id'] =0;
            //     $data1['razorpay_status'] = "Invalid IFSC code";
            //
            //   }
            // }
            // exit;
            // $myfile = fopen("razorpay_notify.txt", "a") or die("Unable to open file!");
            // $txt = json_encode($response)."John Doe\n";
            // fwrite($myfile, $txt);

            if (isset($response->status) && strtolower($response->status) == strtolower('processed')) {
                $data1['status'] = 1;
                $data1['approved_date'] = date('Y-m-d H:i:s');
                $data1['razorpay_pout_id'] = $response->id;
                $data1['razorpay_status'] = $response->status;

                // Helpers::logActivity('Withdraw Request Processed successfully!',$withdraw->user_id);

                // if($withdraw->user_id=='4873'){

                $tds_rebat = DB::table('setting')->where('setting_key', 'tds_rebate')->first();
                $tds_rebate_monthly_limit = DB::table('setting')->where('setting_key', 'tds_rebate_monthly_limit')->first();
                $tdscheck = DB::table('tds_new')
                    ->where('user_id', $withdraw->user_id)
                    ->where('withdraw_id', $withdraw->id)->first();
                //$tdsrebate= DB::table('tds_new')->where('user_id',$withdraw->user_id)->whereMonth('created_at',date('m'))->whereYear('created_at',date('Y'))->count();
                $tds_rebate_count = DB::table('tds_rebate_commission')->where('user_id', $withdraw->user_id)->where('status', 1)->whereMonth('create_at', date('m'))->whereYear('create_at', date('Y'))->count();

                if ($tds_rebate_count < $tds_rebate_monthly_limit->value) {
                    if (!empty($tdscheck)) {
                        $userid = $withdraw->user_id;
                        $tds_amount = $tdscheck->tds_amount;
                        if ($tds_amount > 0 && $tds_rebat->value == 1) {
                            $userbalance = DB::table('userbalances')->where('user_id', $userid)->first();

                            $total_available_amt = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission + $tds_amount;

                            $tdsrebatfocus = array();
                            $tdsrebatfocus['userid'] = $userid;
                            $tdsrebatfocus['type'] = 'TDS Rebate from PLAYNWIN11';
                            $tdsrebatfocus['transaction_id'] = 'PLAYNWIN11-TDS-REBET-' . rand(11, 999) . $userid;
                            $tdsrebatfocus['transaction_by'] = 'PLAYNWIN11';
                            $tdsrebatfocus['amount'] = $tds_amount;
                            $tdsrebatfocus['paymentstatus'] = 'confirmed';
                            $tdsrebatfocus['affiliation_amount'] = $tds_amount;
                            $tdsrebatfocus['bal_fund_amt'] = $userbalance->balance;
                            $tdsrebatfocus['bal_win_amt'] = $userbalance->winning;
                            $tdsrebatfocus['bal_bonus_amt'] = $userbalance->bonus;
                            $tdsrebatfocus['bal_gst_bonus_amt'] = $userbalance->gst_bonus + $tds_amount;
                            $tdsrebatfocus['bal_affi_amt'] = $userbalance->affiliation_commission;
                            $tdsrebatfocus['withdraw_amt'] = 0;
                            $tdsrebatfocus['total_available_amt'] = $total_available_amt;
                            DB::table('transactions')->insert($tdsrebatfocus);

                            DB::table('tds_rebate_commission')->insert(['user_id' => $userid, 'amount' => $tds_amount, 'withdraw_id' => $withdraw->id]);

                            $updateuserbalance = $userbalance->gst_bonus + $tds_amount;
                            DB::table('userbalances')->where('user_id', $userid)->update(['gst_bonus' => $updateuserbalance]);

                            $session_year = Helpers::getCurrentSessionYear();
                            $registerusers_session = DB::table("registerusers_session")
                                ->where("user_id", $userid)
                                ->where("session_year", $session_year)
                                ->first();
                            if (empty($registerusers_session)) {
                                DB::table("registerusers_session")->insert([
                                    "session_year" => $session_year,
                                    "user_id" => $userid,
                                ]);
                                sleep(1);
                                $registerusers_session = DB::table("registerusers_session")
                                    ->where("user_id", $userid)
                                    ->where("session_year", $session_year)
                                    ->first();
                            }
                            DB::table("registerusers_session")
                                ->where("id", $registerusers_session->id)
                                ->update([
                                    "total_tds_rebate" => $registerusers_session->total_tds_rebate + $tds_amount
                                ]);
                        }
                    }
                }
                //}



            } else {
                if (isset($response->status) && strtolower($response->status) != strtolower('processing')) {

                    if (isset($response->status) && strtolower($response->status) == strtolower('reversed')) {
                        $data1['status'] = 0;
                        $data1['razorpay_pout_id'] = @$response->id;
                        $data1['razorpay_status'] = $response->status;
                        DB::table('withdraw')->where('razorpay_pout_id', @$response->id)->update(['status' => 0]);
                    } else {
                        if (isset($response->status) && strtolower($response->status) == strtolower('failed')) {
                            $data1['status'] = 0;
                            $data1['razorpay_pout_id'] = @$response->id;
                            $data1['razorpay_status'] = $response->status;
                        } else if (isset($response->status) && strtolower($response->status) == strtolower('cancelled')) {
                            $data1['status'] = 0;
                            $data1['razorpay_pout_id'] = @$response->id;
                            $data1['razorpay_status'] = $response->status;
                        } else {
                            $data1['status'] = 22;
                            $data1['razorpay_pout_id'] = @$response->id;
                            $data1['razorpay_status'] = $response->status;
                        }
                    }
                }
            }

            try {
                // DB::table('razorpay_response')->insert($responseData);
                if (!empty($data1)) {
                    DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
                }
            } catch (\Exception $e) {
                echo   $e->getMessage();
            }
        }
        echo 1;
    }

    public function razorpay_payouts_re_query_cron()
    {
        $fromDate = new Carbon('last week');
        $toDate = new Carbon('now');
        $find_withdraw = DB::table('withdraw')
            ->where('status', 0)
            ->where('type', 'bank')
            ->whereBetween('modified', array($fromDate->toDateTimeString(), $toDate->toDateTimeString()))
            ->orderBy('modified', 'asc')
            ->limit(30)
            ->get();

        $withdrawArray = array();
        foreach ($find_withdraw as $withdraw) {
            $withdrawArray[] = $withdraw->id;
        }
        if (!empty(count($withdrawArray))) {
            $data1 = array();
            $data1['status'] = 11;
            DB::table('withdraw')->whereIn('id', $withdrawArray)->update($data1);
        }

        foreach ($find_withdraw as $withdraw) {
            $bank = DB::table('bank')->where('status', 1)->where('userid', $withdraw->user_id)->first();
            $users = DB::table('registerusers')->where('activation_status', 'activated')->where('id', $withdraw->user_id)->first();

            if (isset($bank->id) && !empty($bank->id)  && isset($users->id) &&  !empty($users->id) && !empty($withdraw->razorpay_pout_id)) {

                $pout_id = $withdraw->razorpay_pout_id;
                $url = 'curl -u ' . ROZARPAY_KEY_ID . ':' . RAZORPAY_SECRET_KEY . ' \-X GET https://api.razorpay.com/v1/payouts/' . $pout_id . ' \-H "Content-Type: application/json"';
                $response   = self::shell_exec_url($url);


                $data1 = array();
                if (isset($response->status) && strtolower($response->status) == strtolower('processing') ||  isset($response->status) && strtolower($response->status) == strtolower('processed')) {
                    $data1['status'] = 22;
                    $data1['razorpay_pout_id'] = $response->id;
                    $data1['razorpay_status'] = $response->status;
                    $responseData = array();
                    $responseData["user_id"] = $users->id;
                    $responseData["bank_id"] = $bank->id;
                    $responseData["withdraw_id"] = $withdraw->id;
                    $responseData["razorpay_pout_id"] = @$response->id;
                    $responseData["razorpay_merchant_id"] = @$response->merchant_id;
                    $responseData["status"] = $data1["status"];
                    $responseData["razorpay_created_at"] = @$response->created_at;
                    $responseData["razorpay_purpose"] = @$response->purpose;
                    $responseData["razorpay_amount"] = @$response->amount;
                    $responseData["razorpay_result"] = json_encode($response, true);
                    $responseData["razorpay_status"] = @$response->status;
                    // $responseData["razorpay_request"] = json_encode($a, true);
                    $responseData["razorpay_payouts_re_query"] = 1;
                } else {
                    $data1['status'] = 0;
                    $data1['razorpay_pout_id'] = @$response->id;
                    $data1['razorpay_status'] = $response->status;
                    $responseData = array();
                    $responseData["user_id"] = $users->id;
                    $responseData["bank_id"] = $bank->id;
                    $responseData["withdraw_id"] = $withdraw->id;
                    $responseData["razorpay_pout_id"] = @$response->id;
                    $responseData["razorpay_merchant_id"] = @$response->merchant_id;
                    $responseData["status"] = $data1["status"];
                    $responseData["razorpay_created_at"] = @$response->created_at;
                    $responseData["razorpay_purpose"] = @$response->purpose;
                    $responseData["razorpay_amount"] = @$response->amount;
                    $responseData["razorpay_result"] = json_encode($response, true);
                    $responseData["razorpay_status"] = @$response->status;
                    // $responseData["razorpay_request"] = json_encode($a, true);
                    $responseData["razorpay_payouts_re_query"] = 1;
                }

                try {
                    DB::table('razorpay_response')->insert($responseData);
                    DB::table('withdraw')->where('id', $withdraw->id)->update($data1);
                } catch (\Exception $e) {
                    echo   $e->getMessage();
                }
                echo "record update successfully ";
            }
        }
    }

    public function checkRazorpayStatus($orderId)
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.razorpay.com/v1/orders/' . $orderId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic cnpwX2xpdmVfMElHTEFPZ1lmN0I1bXY6ZGtKWGtHdkFXMDZTOHVlRDdVZThQNzNN'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
        echo "<pre>";
        exit;
    }

    public function wrongrefundrevertwinning_worng()
    {
        $userbalance = DB::table('userbalances')->where('user_id', '2116')->first();
        $newamout = 3387;
        $newbalnce =  $userbalance->winning - $newamout;
        //dd($newbalnce);
        DB::table('userbalances')->where('user_id', '2116')->update(['winning' => $newbalnce]);

        // echo $remainingdeduct->deduct_amount+$newbalnce;
        //DB::table('revert_repeated_refund_amount')->insert($inserdata);

        $userbalance = DB::table('userbalances')->where('user_id', '2116')->first();
        $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $userbalance->user_id;
        $datatr['type'] = 'Revert balance for pending of contest join entryfee due to technical issue';
        $datatr['transaction_by'] = BRAND['name'];
        $datatr['amount'] = $newamout;
        $datatr['paymentstatus'] = 'confirmed';
        // $datatr['challengeid'] = $value->challengeid;
        $datatr['bonus_amt'] = $userbalance->bonus;
        $datatr['win_amt'] = $userbalance->winning;
        $datatr['addfund_amt'] = 0;
        $datatr['bal_bonus_amt'] = $userbalance->bonus;
        $datatr['bal_win_amt'] = $userbalance->winning;
        $datatr['cons_amount'] = $newamout;
        $datatr['userid'] = $userbalance->user_id;
        $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
        DB::table('transactions')->insert($datatr);
    }



    public function wrongrefundrevertwinningwinner()
    {
        // $userdata=  DB::table('refunds_old3108 as r')
        //   ->join("revert_repeated_refund_amount as u", "u.joinid", "=", "r.joinid")
        //   ->where('u.status','!=','1')
        //   ->where('l.user_id','2837')
        //   ->selectRaw("l.*,u.deduct_amount as remainingamount,u.total_deduct_amount,
        //     r.userid as refund_userid, r.joinid as refund_joinid,
        //     sum(r.amount) as total_amount,
        //     count(r.id) as c,
        //     (sum(r.amount)/count(r.id)*(count(r.id)-1)) as deduct_amount")
        //   ->groupBy('r.joinid','r.userid')
        //   ->having('c','>',1)
        //   ->orderBy('c','desc')
        //  // ->limit(1)
        //   ->get();
        $userdata =  DB::table('refunds_old3108 as r')
            ->join("leaugestransactions as l", "l.joinid", "=", "r.joinid")
            ->join("revert_repeated_refund_amount as u", "u.joinid", "=", "r.joinid")
            ->where('u.status', '!=', '1')
            ->where('l.user_id', '10097')
            //  ->where('u.id','1212')
            ->selectRaw("l.*,u.deduct_amount as remainingamount,u.total_deduct_amount,
                        r.userid as refund_userid, r.joinid as refund_joinid,
                        sum(r.amount) as total_amount,
                        count(r.id) as c,
                        (sum(r.amount)/count(r.id)*(count(r.id)-1)) as deduct_amount")
            ->groupBy('r.joinid', 'r.userid')
            ->having('c', '>', 1)
            ->orderBy('c', 'desc')
            // ->limit(1)
            ->get();
        //

        //  $this->newwrongwinningrevert(); exit;
        $this->deductAmountWinningBalance();
        exit;
        $userdata =  DB::table('revert_repeated_refund_amount as r')
            ->where('r.status', '!=', '1')
            //->where('created_at','like','%2024-03-23%')
            ->where('r.user_id', '7625')
            // ->limit(1)
            ->get();
        echo '<pre>';
        print_r($userdata);
        exit;
        foreach ($userdata as $key => $value) {
            // if($value->balance>0)
            // {
            $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
            if (!empty($userbalance) && $userbalance->winning >= $value->total_deduct_amount) {

                $newamout = $value->total_deduct_amount;
                $newbalnce =  $userbalance->winning - $newamout;

                DB::table('userbalances')->where('user_id', $value->user_id)->update(['winning' => $newbalnce]);

                $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                $inserdata = array(
                    'user_id' => $value->user_id,
                    'matchkey' => $value->matchkey,
                    'challengeid' => $value->challengeid,
                    'joinid' => $value->joinid,
                    'total_deduct_amount' => $value->total_deduct_amount,
                    'deduct_amount' => $newamout,
                    'status' => 1,
                );
                DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                $datatr['transaction_by'] = 'wallet';
                $datatr['amount'] = $newamout;
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['challengeid'] = $value->challengeid;
                $datatr['bonus_amt'] = 0;
                $datatr['win_amt'] = 0;
                $datatr['addfund_amt'] = 0;
                $datatr['bal_bonus_amt'] = $userbalance->bonus;
                $datatr['bal_win_amt'] = $userbalance->winning;
                $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                $datatr['bal_affi_amt'] = $userbalance->affiliation_commission;
                $datatr['bal_fund_amt'] = $userbalance->balance;;
                $datatr['userid'] = $value->user_id;
                $datatr['cons_win'] = $newamout;
                $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                DB::table('transactions')->insert($datatr);
            } else {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if (!empty($userbalance) && $userbalance->balance >= $value->total_deduct_amount)
                // if(!empty($userbalance) && $userbalance->balance >=$value->total_deduct_amount && $userbalance->balance=='1111111111111')
                {

                    // echo $value->deduct_amount-$value->remainingamount;exit;
                    $newamout = $value->total_deduct_amount;
                    $newbalnce =  $userbalance->balance - $newamout;
                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => $newbalnce]);

                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        // 'total_deduct_amount'=>$value->deduct_amount,
                        'deduct_amount' => $newamout,
                        'status' => 1,
                    );
                    // echo $remainingdeduct->deduct_amount+$newbalnce;
                    DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = 'wallet';
                    $datatr['amount'] = $newamout;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    $datatr['cons_amount'] = $newamout;
                    $datatr['bonus_amt'] = 0;
                    $datatr['win_amt'] = 0;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $userbalance->balance;
                    $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                    $datatr['bal_affi_amt'] = $userbalance->affiliation_commission;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                    DB::table('transactions')->insert($datatr);
                }

                //balance+winnig amount deduct
                $remainingdeductdata =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                // if($userbalance->winning  < $value->deduct_amount && $userbalance->winning>0 && $value->total_deduct_amount!= $remainingdeductdata->deduct_amount)
                // {
                //    $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
                //      $newamout= $value->deduct_amount-$value->remainingamount;
                //      $remainingamount=  $newamout-$userbalance->winning;
                //      $totaldeduct= $newamout-$remainingamount;
                //
                //      if($userbalance->winning>=$totaldeduct)
                //      {
                //         $newbalance= $userbalance->winning-$totaldeduct;
                //          DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>$newbalance]);
                //          $remainingdeduct=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
                //          $status=0;
                //          if($value->deduct_amount+$totaldeduct==$value->total_deduct_amount)
                //          {
                //            $status=1;
                //          }
                //           $inserdata= array('user_id'=>$value->user_id,
                //           'matchkey'=>$value->matchkey,
                //           'challengeid'=>$value->challengeid,
                //           'joinid'=>$value->joinid,
                //           'total_deduct_amount'=>$value->deduct_amount,
                //           'deduct_amount'=>$remainingdeduct->deduct_amount+$totaldeduct,
                //           'status'=>$status,
                //         );
                //         DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->update($inserdata);
                //
                //         $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
                //
                //         $datatr['transaction_id'] = BRAND['name'].'-REVERT-'.rand(100,999).$value->user_id;
                //          $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                //          $datatr['transaction_by'] = BRAND['name'];
                //          $datatr['amount'] = $totaldeduct;
                //          $datatr['paymentstatus'] = 'confirmed';
                //          $datatr['challengeid'] = $value->challengeid;
                //          $datatr['bonus_amt'] = $userbalance->bonus;
                //          $datatr['win_amt'] = $userbalance->winning;
                //          $datatr['addfund_amt'] = 0;
                //          $datatr['bal_bonus_amt'] =$userbalance->bonus;
                //          $datatr['bal_win_amt'] = $userbalance->winning;
                //          $datatr['bal_fund_amt'] =$totaldeduct;
                //          $datatr['userid'] = $value->user_id;
                //          $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
                //          DB::table('transactions')->insert($datatr);
                //       }
                //    }
                //
                //    $remainingdeductdata=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
                //    if($userbalance->balance < $value->deduct_amount-$value->remainingamount && $userbalance->balance>0   && $value->total_deduct_amount !=$remainingdeductdata->deduct_amount)
                //    {
                //       $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
                //         $newamout= $value->deduct_amount-$value->remainingamount;
                //         $remainingamount=  $newamout-$userbalance->balance;
                //        $totaldeduct= $newamout-$remainingamount;
                //
                //
                //         if($userbalance->balance>=$totaldeduct)
                //         {
                //             $newbalance= $userbalance->balance-$totaldeduct;
                //             DB::table('userbalances')->where('user_id',$value->user_id)->update(['balance'=>$newbalance]);
                //             $remainingdeduct=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
                //
                //             $status=0;
                //             if($value->deduct_amount+$totaldeduct==$value->total_deduct_amount)
                //             {
                //               $status=1;
                //             }
                //              $inserdata= array('user_id'=>$value->user_id,
                //              'matchkey'=>$value->matchkey,
                //              'challengeid'=>$value->challengeid,
                //              'joinid'=>$value->joinid,
                //              'total_deduct_amount'=>$value->deduct_amount,
                //              'deduct_amount'=>$remainingdeduct->deduct_amount+$totaldeduct,
                //              'status'=>$status,
                //            );
                //            DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->update($inserdata);
                //
                //            $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
                //            $datatr['transaction_id'] = BRAND['name'].'-REVERT-'.rand(100,999).$value->user_id;
                //             $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                //             $datatr['transaction_by'] = BRAND['name'];
                //             $datatr['amount'] = $totaldeduct;
                //             $datatr['paymentstatus'] = 'confirmed';
                //             $datatr['challengeid'] = $value->challengeid;
                //             $datatr['bonus_amt'] = $userbalance->bonus;
                //             $datatr['win_amt'] = $userbalance->winning;
                //             $datatr['addfund_amt'] = 0;
                //             $datatr['bal_bonus_amt'] =$userbalance->bonus;
                //             $datatr['bal_win_amt'] = $userbalance->winning;
                //             $datatr['bal_fund_amt'] =$totaldeduct;
                //             $datatr['userid'] = $value->user_id;
                //             $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
                //             DB::table('transactions')->insert($datatr);
                //          }
                //       }



            }
        }
        echo 'done';
        exit;
    }

    public function deductAmountWinningBalance()
    {
        $userdata =  DB::table('revert_repeated_refund_amount as r')
            ->where('r.status', '!=', '1')
            // ->where('created_at','like','%2023-11-05%')
            ->where('r.user_id', '7625')
            //->where('r.id','207')
            ->limit(1)
            ->get();
        //echo '<pre>'; print_r($userdata);exit;
        foreach ($userdata as $key => $result) {
            $revert_total_amount = $result->total_deduct_amount - $result->deduct_amount;

            $be_revert_amount = 0;
            $revert_bal_amount = 0;
            $revert_win_amount = 0;
            $userbalance = DB::table('userbalances')
                ->where('user_id', $result->user_id)->select('user_id', 'balance', 'winning')->first();

            $getwalletData = DB::table('userbalances')
                ->where('user_id', $result->user_id)->select('user_id', 'balance', 'winning')->first();
            $users = DB::table('userbalances')
                ->where('user_id', $result->user_id)->select('user_id', 'balance', 'winning')->first();

            $cons_winning = 0;
            $cons_balance = 0;
            $remaningAmount = $revert_total_amount;
            if ($users->winning >= $remaningAmount) {
                $winning = $users->winning - $remaningAmount;
                $cons_winning = $remaningAmount;
                $remaningAmount = 0;
            } else {
                $winning = 0;
                $remaningAmount = $remaningAmount - $users->winning;
                $cons_winning =  $users->winning;
            }

            if ($remaningAmount > 0) {
                if ($users->balance >= $remaningAmount) {
                    $balance = $users->balance - $remaningAmount;
                    $cons_balance = $remaningAmount;
                    $remaningAmount = 0;
                } else {
                    $balance = 0;
                    $remaningAmount = $remaningAmount - $users->balance;
                    $cons_balance = $users->balance;
                }
            }

            $total_deducted_amount = ($cons_winning + $cons_balance);
            if (!empty($userbalance)) {
                $data = array(
                    "winning"    => DB::raw("winning - " . $cons_winning),
                    "balance"    => DB::raw("balance - " . $cons_balance)
                );
                // update user balance
                $userbalance = DB::table('userbalances')->where('user_id', $users->user_id)->update($data);

                // DB :: table('userbalances')->where('user_id',$userbalance->user_id)->update($userBalance);

                $AfterDeduct_walletData = DB::table('userbalances')
                    ->where('user_id', $users->user_id)->first();

                if ($total_deducted_amount > 0) {
                    $tds_transaction_id = 'PLAYNWIN11-REVERT' . time() . '' . $result->user_id;
                    $transaction = array(
                        "userid" => $getwalletData->user_id,
                        "type" => 'Revert Repeated Contest Refund Amount',
                        "transaction_id" => $tds_transaction_id,
                        "transaction_by" => 'wallet',
                        "amount" => $total_deducted_amount,
                        "paymentstatus" => 'confirmed',
                        "cons_amount" => $cons_balance,
                        "cons_win" => $cons_winning,
                        "challengeid" => $result->challengeid,
                        //  "bonus_amt" =>$AfterDeduct_walletData->bonus,
                        // "gst_bonus_amt" =>$AfterDeduct_walletData->gst_bonus,
                        "bal_win_amt" => round($AfterDeduct_walletData->winning, 2),
                        "bal_fund_amt" => round($AfterDeduct_walletData->balance, 2),
                        "bal_bonus_amt" => $AfterDeduct_walletData->bonus,
                        "bal_gst_bonus_amt" => $AfterDeduct_walletData->gst_bonus,
                        "bal_affi_amt" => $AfterDeduct_walletData->affiliation_commission,
                        "total_available_amt" => round(($AfterDeduct_walletData->winning + $AfterDeduct_walletData->balance + $AfterDeduct_walletData->bonus + $AfterDeduct_walletData->gst_bonus + $AfterDeduct_walletData->affiliation_commission), 2),
                    );

                    DB::table('transactions')->insert($transaction);
                }

                //  $remingAmount = $revert_total_amount-$be_revert_amount;
                $remingAmount = $result->total_deduct_amount - $result->deduct_amount - $total_deducted_amount;

                if ($remingAmount > 0) {
                    // $reverreming=array(
                    //      "user_id"=>$getwalletData->user_id,
                    //     // "matchkey"=>$match_key,
                    //      "total_deduct_amount"=>$revert_total_amount,
                    //      "deduct_amount"=>$be_revert_amount,
                    //      "remain_deduct_amount"=>0,
                    //      "status"=>0
                    //  );
                    $reverreming = array(
                        "deduct_amount" => $result->deduct_amount + $total_deducted_amount,
                        "remain_deduct_amount" => $result->remain_deduct_amount + $total_deducted_amount,
                        "status" => 0
                    );

                    DB::table('revert_repeated_refund_amount')->where('id', $result->id)->update($reverreming);
                    // DB :: table('revert_repeated_refund_amount')->insert($reverreming);
                    // echo "</br>"; print_r($reverreming);
                } else {
                    $reverreming = array(
                        "deduct_amount" => $result->deduct_amount + $total_deducted_amount,
                        // "remain_deduct_amount"=>$result->remain_deduct_amount+$total_deducted_amount,
                        "status" => 1
                    );

                    DB::table('revert_repeated_refund_amount')->where('id', $result->id)->update($reverreming);
                }
            }
        }
        echo 'Done';
    }

    public function newwrongwinningrevert()
    {
        $userdata =  DB::table('revert_repeated_refund_amount as r')
            ->where('r.status', '!=', '1')
            // ->where('created_at','like','%2023-11-05%')
            ->where('r.user_id', '121262')
            ->limit(1)
            ->get();
        //echo '<pre>'; print_r($userdata);exit;
        foreach ($userdata as $key => $value) {
            // if($value->balance>0)
            // {
            $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
            if (!empty($userbalance) && $userbalance->balance >= $value->total_deduct_amount && $userbalance->balance == '1111111111111') {
                echo 'ff';
                exit;
                // echo $value->deduct_amount-$value->remainingamount;exit;
                $newamout = $value->total_deduct_amount;
                $newbalnce =  $userbalance->balance - $newamout;
                DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => $newbalnce]);

                $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                $inserdata = array(
                    'user_id' => $value->user_id,
                    'matchkey' => $value->matchkey,
                    'challengeid' => $value->challengeid,
                    'joinid' => $value->joinid,
                    // 'total_deduct_amount'=>$value->deduct_amount,
                    'deduct_amount' => $newamout,
                    'status' => 1,
                );
                // echo $remainingdeduct->deduct_amount+$newbalnce;
                DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                $datatr['transaction_by'] = 'wallet';
                $datatr['amount'] = $newamout;
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['challengeid'] = $value->challengeid;
                // $datatr['bonus_amt'] = $userbalance->bonus;
                // $datatr['gst_bonus_amt'] =$userbalance->gst_bonus;
                $datatr['cons_win'] = $newamout;
                $datatr['addfund_amt'] = 0;
                $datatr['bal_bonus_amt'] = $userbalance->bonus;
                $datatr['bal_win_amt'] = $userbalance->winning;
                $datatr['bal_fund_amt'] = $userbalance->balance;
                $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                $datatr['bal_affi_amt'] = $userbalance->affiliation_commission;
                $datatr['userid'] = $value->user_id;
                $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                // DB::table('transactions')->insert($datatr);

            } else {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if (!empty($userbalance) && $userbalance->winning >= $value->remain_deduct_amount) {

                    $newamout = $value->remain_deduct_amount;
                    $newbalnce =  $userbalance->winning - $newamout;

                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['winning' => $newbalnce]);

                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')
                        ->where('user_id', $value->user_id)
                        ->where('matchkey', $value->matchkey)
                        //->where('joinid',$value->joinid)
                        ->first();
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        //'challengeid'=>$value->challengeid,
                        // 'joinid'=>$value->joinid,
                        // 'total_deduct_amount'=>$value->total_deduct_amount,
                        'deduct_amount' => $value->deduct_amount + $newamout,
                        'remain_deduct_amount' => $value->deduct_amount + $newamout,
                        'status' => 1,
                    );
                    //echo '<br/><pre>'; print_r($remainingdeduct);
                    echo '<br/><pre>';
                    print_r($inserdata);
                    DB::table('revert_repeated_refund_amount')
                        ->where('id', $value->id)
                        //->where('matchkey',$value->matchkey)
                        // ->where('joinid',$value->joinid)
                        ->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    echo '<pre>';
                    print_r($userbalance);
                    $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = 'wallet';
                    $datatr['amount'] = $newamout;
                    $datatr['paymentstatus'] = 'confirmed';
                    //  $datatr['challengeid'] = $value->challengeid;
                    $datatr['cons_win'] = $newamout;
                    // $datatr['win_amt'] = $userbalance->winning-$newbalnce;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $userbalance->balance;
                    $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                    $datatr['bal_affi_amt'] = $userbalance->affiliation_commission;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                    DB::table('transactions')->insert($datatr);
                    echo '<pre>';
                    print_r($datatr);
                }
            }

            //balance+winnig amount deduct
            $remainingdeductdata =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
            // if($userbalance->winning  < $value->deduct_amount && $userbalance->winning>0 && $value->total_deduct_amount!= $remainingdeductdata->deduct_amount)
            // {
            //    $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
            //      $newamout= $value->deduct_amount-$value->remainingamount;
            //      $remainingamount=  $newamout-$userbalance->winning;
            //      $totaldeduct= $newamout-$remainingamount;
            //
            //      if($userbalance->winning>=$totaldeduct)
            //      {
            //         $newbalance= $userbalance->winning-$totaldeduct;
            //          DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>$newbalance]);
            //          $remainingdeduct=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
            //          $status=0;
            //          if($value->deduct_amount+$totaldeduct==$value->total_deduct_amount)
            //          {
            //            $status=1;
            //          }
            //           $inserdata= array('user_id'=>$value->user_id,
            //           'matchkey'=>$value->matchkey,
            //           'challengeid'=>$value->challengeid,
            //           'joinid'=>$value->joinid,
            //           'total_deduct_amount'=>$value->deduct_amount,
            //           'deduct_amount'=>$remainingdeduct->deduct_amount+$totaldeduct,
            //           'status'=>$status,
            //         );
            //         DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->update($inserdata);
            //
            //         $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
            //
            //         $datatr['transaction_id'] = BRAND['name'].'-REVERT-'.rand(100,999).$value->user_id;
            //          $datatr['type'] = 'Revert Repeated Contest Refund Amount';
            //          $datatr['transaction_by'] = BRAND['name'];
            //          $datatr['amount'] = $totaldeduct;
            //          $datatr['paymentstatus'] = 'confirmed';
            //          $datatr['challengeid'] = $value->challengeid;
            //          $datatr['bonus_amt'] = $userbalance->bonus;
            //          $datatr['win_amt'] = $userbalance->winning;
            //          $datatr['addfund_amt'] = 0;
            //          $datatr['bal_bonus_amt'] =$userbalance->bonus;
            //          $datatr['bal_win_amt'] = $userbalance->winning;
            //          $datatr['bal_fund_amt'] =$totaldeduct;
            //          $datatr['userid'] = $value->user_id;
            //          $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
            //          DB::table('transactions')->insert($datatr);
            //       }
            //    }
            //
            //    $remainingdeductdata=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
            //    if($userbalance->balance < $value->deduct_amount-$value->remainingamount && $userbalance->balance>0   && $value->total_deduct_amount !=$remainingdeductdata->deduct_amount)
            //    {
            //       $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
            //         $newamout= $value->deduct_amount-$value->remainingamount;
            //         $remainingamount=  $newamout-$userbalance->balance;
            //        $totaldeduct= $newamout-$remainingamount;
            //
            //
            //         if($userbalance->balance>=$totaldeduct)
            //         {
            //             $newbalance= $userbalance->balance-$totaldeduct;
            //             DB::table('userbalances')->where('user_id',$value->user_id)->update(['balance'=>$newbalance]);
            //             $remainingdeduct=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
            //
            //             $status=0;
            //             if($value->deduct_amount+$totaldeduct==$value->total_deduct_amount)
            //             {
            //               $status=1;
            //             }
            //              $inserdata= array('user_id'=>$value->user_id,
            //              'matchkey'=>$value->matchkey,
            //              'challengeid'=>$value->challengeid,
            //              'joinid'=>$value->joinid,
            //              'total_deduct_amount'=>$value->deduct_amount,
            //              'deduct_amount'=>$remainingdeduct->deduct_amount+$totaldeduct,
            //              'status'=>$status,
            //            );
            //            DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->update($inserdata);
            //
            //            $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
            //            $datatr['transaction_id'] = BRAND['name'].'-REVERT-'.rand(100,999).$value->user_id;
            //             $datatr['type'] = 'Revert Repeated Contest Refund Amount';
            //             $datatr['transaction_by'] = BRAND['name'];
            //             $datatr['amount'] = $totaldeduct;
            //             $datatr['paymentstatus'] = 'confirmed';
            //             $datatr['challengeid'] = $value->challengeid;
            //             $datatr['bonus_amt'] = $userbalance->bonus;
            //             $datatr['win_amt'] = $userbalance->winning;
            //             $datatr['addfund_amt'] = 0;
            //             $datatr['bal_bonus_amt'] =$userbalance->bonus;
            //             $datatr['bal_win_amt'] = $userbalance->winning;
            //             $datatr['bal_fund_amt'] =$totaldeduct;
            //             $datatr['userid'] = $value->user_id;
            //             $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
            //             DB::table('transactions')->insert($datatr);
            //          }
            //       }



        }
        echo 'done';
        exit;
    }

    public function wrongrefundrevertwinning()
    {
        $userdata =  DB::table('refunds_old3108 as r')
            ->join("leaugestransactions as l", "l.joinid", "=", "r.joinid")
            ->join("revert_repeated_refund_amount as u", "u.joinid", "=", "r.joinid")
            ->where('u.status', '!=', '1')
            ->where('l.user_id', '6978')
            //->where('u.id','220')
            ->selectRaw("l.*,u.deduct_amount as remainingamount,u.total_deduct_amount,
                    r.userid as refund_userid, r.joinid as refund_joinid,
                    sum(r.amount) as total_amount,
                    count(r.id) as c,
                    (sum(r.amount)/count(r.id)*(count(r.id)-1)) as deduct_amount")
            ->groupBy('r.joinid', 'r.userid')
            ->having('c', '>', 1)
            ->orderBy('c', 'desc')
            // ->limit(1)
            ->get();

        //echo '<pre>'; print_r($userdata);exit;
        foreach ($userdata as $key => $value) {
            // if($value->balance>0)
            // {
            $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
            if ($userbalance->balance >= $value->deduct_amount - $value->remainingamount && $userbalance->balance == 111111111111) {

                echo $value->deduct_amount - $value->remainingamount;
                exit;
                $newamout = $value->deduct_amount - $value->remainingamount;
                $newbalnce =  $userbalance->balance - $newamout;
                DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => $newbalnce]);

                $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                $inserdata = array(
                    'user_id' => $value->user_id,
                    'matchkey' => $value->matchkey,
                    'challengeid' => $value->challengeid,
                    'joinid' => $value->joinid,
                    'total_deduct_amount' => $value->deduct_amount,
                    'deduct_amount' => $remainingdeduct->deduct_amount + $newamout,
                    'status' => 1,
                );
                // echo $remainingdeduct->deduct_amount+$newbalnce;
                DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                $datatr['transaction_by'] = 'Wallet';
                $datatr['amount'] = $newamout;
                $datatr['paymentstatus'] = 'confirmed';
                $datatr['challengeid'] = $value->challengeid;
                $datatr['bonus_amt'] = $userbalance->bonus;
                $datatr['win_amt'] = $userbalance->winning;
                $datatr['addfund_amt'] = 0;
                $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                $datatr['bal_bonus_amt'] = $userbalance->bonus;
                $datatr['bal_win_amt'] = $userbalance->winning;
                $datatr['bal_affi_amt'] = @$userbalance->affiliation_commission;
                $datatr['bal_fund_amt'] = $userbalance->balance;
                $datatr['cons_amount'] = $newamout;
                $datatr['userid'] = $value->user_id;
                $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                DB::table('transactions')->insert($datatr);
            } else {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if ($userbalance->winning >= $value->deduct_amount - $value->remainingamount) {

                    $newamout = $value->deduct_amount - $value->remainingamount;
                    $newbalnce =  $userbalance->winning - $newamout;

                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['winning' => $newbalnce]);

                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $remainingdeduct->deduct_amount + $newamout,
                        'status' => 1,
                    );
                    echo '<pre>';
                    print_r($inserdata);
                    DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = 'wallet';
                    $datatr['amount'] = $newamout;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    // $datatr['bonus_amt'] = $userbalance->bonus;
                    //   $datatr['win_amt'] = $userbalance->winning;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                    $datatr['bal_affi_amt'] = @$userbalance->affiliation_commission;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $userbalance->balance;
                    $datatr['cons_win'] = $newamout;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission;
                    DB::table('transactions')->insert($datatr);
                    echo '<pre>';
                    print_r($datatr);
                    exit;
                }
            }
            exit;
            //balance+winnig amount deduct
            $remainingdeductdata =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
            if ($userbalance->winning  < $value->deduct_amount - $value->remainingamount && $userbalance->winning > 0 && $value->total_deduct_amount != $remainingdeductdata->deduct_amount) {
                exit;
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                $newamout = $value->deduct_amount - $value->remainingamount;
                $remainingamount =  $newamout - $userbalance->winning;
                $totaldeduct = $newamout - $remainingamount;
                echo '<pre>';
                print_r($totaldeduct);
                if ($userbalance->winning >= $totaldeduct) {
                    $newbalance = $userbalance->winning - $totaldeduct;
                    //    DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>$newbalance]);
                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                    $status = 0;
                    if ($value->deduct_amount + $totaldeduct == $value->total_deduct_amount) {
                        $status = 1;
                    }
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $remainingdeduct->deduct_amount + $totaldeduct,
                        'status' => $status,
                    );
                    // DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();

                    $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = BRAND['name'];
                    $datatr['amount'] = $totaldeduct;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    // $datatr['bonus_amt'] = $userbalance->bonus;
                    // $datatr['win_amt'] = $userbalance->winning;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $totaldeduct;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus;
                    //  DB::table('transactions')->insert($datatr);
                    echo 'ff';
                    print_r($datatr);
                }
            }
            exit;
            $remainingdeductdata =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
            if ($userbalance->balance < $value->deduct_amount - $value->remainingamount && $userbalance->balance > 0   && $value->total_deduct_amount != $remainingdeductdata->deduct_amount) {
                exit;
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                $newamout = $value->deduct_amount - $value->remainingamount;
                $remainingamount =  $newamout - $userbalance->balance;
                $totaldeduct = $newamout - $remainingamount;


                if ($userbalance->balance >= $totaldeduct) {
                    $newbalance = $userbalance->balance - $totaldeduct;
                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => $newbalance]);
                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();

                    $status = 0;
                    if ($value->deduct_amount + $totaldeduct == $value->total_deduct_amount) {
                        $status = 1;
                    }
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $remainingdeduct->deduct_amount + $totaldeduct,
                        'status' => $status,
                    );
                    DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    $datatr['transaction_id'] = BRAND['name'] . '-REVERT-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = BRAND['name'];
                    $datatr['amount'] = $totaldeduct;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    // $datatr['bonus_amt'] = $userbalance->bonus;
                    // $datatr['win_amt'] = $userbalance->winning;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_gst_bonus_amt'] = $userbalance->gst_bonus;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $totaldeduct;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus;
                    DB::table('transactions')->insert($datatr);
                }
            }
        }
        echo 'done';
        exit;
    }


    public function wrongrefundrevert()
    {
        $userdata =  DB::table('refunds_old3108 as r')
            ->join("leaugestransactions as l", "l.joinid", "=", "r.joinid")
            ->join("revert_repeated_refund_amount as u", "u.joinid", "=", "r.joinid")
            ->where('u.status', '!=', '1')
            ->where('l.user_id', '8998')
            ->selectRaw("l.*,u.deduct_amount as remainingamount,u.total_deduct_amount,
                  r.userid as refund_userid, r.joinid as refund_joinid,
                  sum(r.amount) as total_amount,
                  count(r.id) as c,
                  (sum(r.amount)/count(r.id)*(count(r.id)-1)) as deduct_amount")
            ->groupBy('r.joinid', 'r.userid')
            ->having('c', '>', 1)
            ->orderBy('c', 'desc')
            //  ->limit(1)
            ->get();
        // echo '<pre>'; print_r($userdata);exit;
        foreach ($userdata as $key => $value) {
            if ($value->balance > 0) {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if ($userbalance->balance >= $value->deduct_amount - $value->remainingamount) {

                    // echo $value->deduct_amount-$value->remainingamount;exit;
                    $newamout = $value->deduct_amount - $value->remainingamount;
                    $newbalnce =  $userbalance->balance - $newamout;
                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => $newbalnce]);

                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $remainingdeduct->deduct_amount + $newamout,
                        'status' => 1,
                    );
                    // echo $remainingdeduct->deduct_amount+$newbalnce;
                    DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = BRAND['name'];
                    $datatr['amount'] = $newamout;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    $datatr['bonus_amt'] = $userbalance->bonus;
                    $datatr['win_amt'] = $userbalance->winning;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $newamout;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
                    DB::table('transactions')->insert($datatr);
                } else {
                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    // if($userbalance->winning >=$value->deduct_amount-$value->remainingamount)
                    // {
                    //
                    //   $newamout= $value->deduct_amount-$value->remainingamount;
                    //   $newbalnce=  $userbalance->winning-$newamout;
                    //
                    //      DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>$newbalnce]);
                    //
                    //     $remainingdeduct=  DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->first();
                    //      $inserdata= array('user_id'=>$value->user_id,
                    //      'matchkey'=>$value->matchkey,
                    //      'challengeid'=>$value->challengeid,
                    //      'joinid'=>$value->joinid,
                    //      'total_deduct_amount'=>$value->deduct_amount,
                    //      'deduct_amount'=>$remainingdeduct->deduct_amount+$newamout,
                    //      'status'=>1,
                    //    );
                    //    DB::table('revert_repeated_refund_amount')->where('joinid',$value->joinid)->update($inserdata);
                    //    $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
                    //     $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    //     $datatr['transaction_by'] = BRAND['name'];
                    //     $datatr['amount'] = $newamout;
                    //     $datatr['paymentstatus'] = 'confirmed';
                    //     $datatr['challengeid'] = $value->challengeid;
                    //     $datatr['bonus_amt'] = $userbalance->bonus;
                    //     $datatr['win_amt'] = $userbalance->winning;
                    //     $datatr['addfund_amt'] = 0;
                    //     $datatr['bal_bonus_amt'] =0;
                    //     $datatr['bal_win_amt'] = 0;
                    //     $datatr['bal_fund_amt'] =0;
                    //     $datatr['userid'] = $value->user_id;
                    //     $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
                    //     DB::table('transactions')->insert($datatr);
                    // }
                    /////demo
                    // if($userbalance->balance>0)
                    // {
                    //   $deductamount= $value->deduct_amount-$value->remainingamount;
                    //   $newbalnce=  $deductamount-$userbalance->balance;
                    //   DB::table('userbalances')->where('user_id',$value->user_id)->update(['balance'=>'0.00']);
                    //   $remainingdeduct=  DB::table('wining_refund_amount')->where('joinid',$value->joinid)->first();
                    //
                    //   $inserdata= array('user_id'=>$value->user_id,
                    //   'matchkey'=>$value->matchkey,
                    //   'challengeid'=>$value->challengeid,
                    //   'joinid'=>$value->joinid,
                    //   'total_deduct_amount'=>$value->deduct_amount,
                    //   'deduct_amount'=>$remainingdeduct->deduct_amount+$newbalnce,
                    //   'status'=>0,
                    // );
                    //    DB::table('wining_refund_amount')->where('joinid',$value->joinid)->update($inserdata);
                    //
                    //   $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
                    //    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    //    $datatr['transaction_by'] = BRAND['name'];
                    //    $datatr['amount'] = $newbalnce;
                    //    $datatr['paymentstatus'] = 'confirmed';
                    //    $datatr['challengeid'] = $value->challengeid;
                    //    $datatr['bonus_amt'] =$userbalance->bonus;
                    //    $datatr['win_amt'] = $userbalance->winning;
                    //    $datatr['addfund_amt'] = 0;
                    //    $datatr['bal_bonus_amt'] =0;
                    //    $datatr['bal_win_amt'] = 0;
                    //    $datatr['bal_fund_amt'] =0;
                    //    $datatr['userid'] = $value->user_id;
                    //    $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
                    //    DB::table('transactions')->insert($datatr);
                    // }
                }
            } elseif ($value->winning > 0) {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if ($userbalance->winning >= $value->deduct_amount - $value->remainingamount) {
                    $newamout = $value->deduct_amount - $value->remainingamount;
                    $newbalnce =  $userbalance->winning - $newamout;

                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['winning' => $newbalnce]);

                    $remainingdeduct =  DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->first();
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $remainingdeduct->deduct_amount + $newamout,
                        'status' => 1,
                    );
                    DB::table('revert_repeated_refund_amount')->where('joinid', $value->joinid)->update($inserdata);

                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = BRAND['name'];
                    $datatr['amount'] = $newamout;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    $datatr['bonus_amt'] = $userbalance->bonus;
                    $datatr['win_amt'] = $userbalance->winning;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_bonus_amt'] = $userbalance->bonus;
                    $datatr['bal_win_amt'] = $userbalance->winning;
                    $datatr['bal_fund_amt'] = $userbalance->balance;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
                    DB::table('transactions')->insert($datatr);
                } else {
                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    // if($userbalance->winning>0)
                    // {
                    //   $deductamount= $value->deduct_amount-$value->remainingamount;
                    //   $newbalnce=  $deductamount-$userbalance->winning;
                    //   $deductamount=  $value->deduct_amount-$userbalance->winning;
                    //   DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>'0.00']);
                    //
                    //   $inserdata= array('user_id'=>$value->user_id,
                    //   'matchkey'=>$value->matchkey,
                    //   'challengeid'=>$value->challengeid,
                    //   'joinid'=>$value->joinid,
                    //   'total_deduct_amount'=>$value->deduct_amount,
                    //   'deduct_amount'=>$value->deduct_amount-$deductamount,
                    //   'status'=>0,
                    // );
                    //   DB::table('wining_refund_amount')->insert($inserdata);
                    //   $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
                    //    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    //    $datatr['transaction_by'] = BRAND['name'];
                    //    $datatr['amount'] = $value->deduct_amount-$deductamount;
                    //    $datatr['paymentstatus'] = 'confirmed';
                    //    $datatr['challengeid'] = $value->challengeid;
                    //    $datatr['bonus_amt'] = 0;
                    //    $datatr['win_amt'] = 0;
                    //    $datatr['addfund_amt'] = 0;
                    //    $datatr['bal_bonus_amt'] =0;
                    //    $datatr['bal_win_amt'] = 0;
                    //    $datatr['bal_fund_amt'] =0;
                    //    $datatr['userid'] = $value->user_id;
                    //    $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
                    //    DB::table('transactions')->insert($datatr);
                    // }
                }
            }
            //   exit;
        }
        echo 'done';
        exit;
        echo '<pre>';
        print_r($userdata);
        exit;
    }


    public function wrongrefundrevert_old()
    {
        $userdata =  DB::table('refunds_old3108 as r')
            ->join("leaugestransactions as l", "l.joinid", "=", "r.joinid")
            ->join("revert_repeated_refund_amount as u", "u.joinid", "=", "r.joinid")
            ->where('u.status', '!=', '1')
            ->selectRaw("u.*,u.deduct_amount as remainingamount,
          r.userid as refund_userid, r.joinid as refund_joinid,
          sum(r.amount) as total_amount,
          count(r.id) as c,
          (sum(r.amount)/count(r.id)*(count(r.id)-1)) as deduct_amount")
            ->groupBy('r.joinid', 'r.userid')
            ->having('c', '>', 1)
            ->orderBy('c', 'desc')
            ->get();
        echo '<pre>';
        print_r($userdata);
        exit;
        foreach ($userdata as $key => $value) {
            if ($value->balance > 0) {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if ($userbalance->balance >= $value->deduct_amount - $userbalance->remainingamount) {
                    $newamout = $value->deduct_amount - $userbalance->remainingamount;
                    $newbalnce =  $userbalance->balance - $newamout;
                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => $newbalnce]);
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $value->deduct_amount,
                        'status' => 1,
                    );
                    DB::table('wining_refund_amount')->insert($inserdata);
                    $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = BRAND['name'];
                    $datatr['amount'] = $value->deduct_amount;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    $datatr['bonus_amt'] = 0;
                    $datatr['win_amt'] = 0;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_bonus_amt'] = 0;
                    $datatr['bal_win_amt'] = 0;
                    $datatr['bal_fund_amt'] = 0;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
                    DB::table('transactions')->insert($datatr);
                } else {
                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    if ($userbalance->balance > 0) {
                        $deductamount = $value->deduct_amount - $userbalance->balance;
                        DB::table('userbalances')->where('user_id', $value->user_id)->update(['balance' => '0.00']);

                        $inserdata = array(
                            'user_id' => $value->user_id,
                            'matchkey' => $value->matchkey,
                            'challengeid' => $value->challengeid,
                            'joinid' => $value->joinid,
                            'total_deduct_amount' => $value->deduct_amount,
                            'deduct_amount' => $value->deduct_amount - $deductamount,
                            'status' => 0,
                        );
                        DB::table('wining_refund_amount')->insert($inserdata);

                        $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $value->user_id;
                        $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                        $datatr['transaction_by'] = BRAND['name'];
                        $datatr['amount'] = $value->deduct_amount - $deductamount;
                        $datatr['paymentstatus'] = 'confirmed';
                        $datatr['challengeid'] = $value->challengeid;
                        $datatr['bonus_amt'] = 0;
                        $datatr['win_amt'] = 0;
                        $datatr['addfund_amt'] = 0;
                        $datatr['bal_bonus_amt'] = 0;
                        $datatr['bal_win_amt'] = 0;
                        $datatr['bal_fund_amt'] = 0;
                        $datatr['userid'] = $value->user_id;
                        $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
                        DB::table('transactions')->insert($datatr);
                    } else {
                        $inserdata = array(
                            'user_id' => $value->user_id,
                            'matchkey' => $value->matchkey,
                            'challengeid' => $value->challengeid,
                            'joinid' => $value->joinid,
                            'total_deduct_amount' => $value->deduct_amount,
                            'deduct_amount' => 0,
                            'status' => 0,
                        );
                        DB::table('wining_refund_amount')->insert($inserdata);
                    }
                }
            } elseif ($value->winning > 0) {
                $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                if ($userbalance->winning >= $value->deduct_amount) {
                    $newbalnce =  $userbalance->winning - $value->deduct_amount;
                    DB::table('userbalances')->where('user_id', $value->user_id)->update(['winning' => $newbalnce]);
                    $inserdata = array(
                        'user_id' => $value->user_id,
                        'matchkey' => $value->matchkey,
                        'challengeid' => $value->challengeid,
                        'joinid' => $value->joinid,
                        'total_deduct_amount' => $value->deduct_amount,
                        'deduct_amount' => $value->deduct_amount,
                        'status' => 1,
                    );
                    DB::table('wining_refund_amount')->insert($inserdata);
                    $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $value->user_id;
                    $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                    $datatr['transaction_by'] = BRAND['name'];
                    $datatr['amount'] = $value->deduct_amount;
                    $datatr['paymentstatus'] = 'confirmed';
                    $datatr['challengeid'] = $value->challengeid;
                    $datatr['bonus_amt'] = 0;
                    $datatr['win_amt'] = 0;
                    $datatr['addfund_amt'] = 0;
                    $datatr['bal_bonus_amt'] = 0;
                    $datatr['bal_win_amt'] = 0;
                    $datatr['bal_fund_amt'] = 0;
                    $datatr['userid'] = $value->user_id;
                    $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
                    DB::table('transactions')->insert($datatr);
                }
                //exit;
                else {
                    $userbalance = DB::table('userbalances')->where('user_id', $value->user_id)->first();
                    if ($userbalance->winning > 0) {
                        $deductamount =  $value->deduct_amount - $userbalance->winning;
                        DB::table('userbalances')->where('user_id', $value->user_id)->update(['winning' => '0.00']);

                        $inserdata = array(
                            'user_id' => $value->user_id,
                            'matchkey' => $value->matchkey,
                            'challengeid' => $value->challengeid,
                            'joinid' => $value->joinid,
                            'total_deduct_amount' => $value->deduct_amount,
                            'deduct_amount' => $value->deduct_amount - $deductamount,
                            'status' => 0,
                        );
                        DB::table('wining_refund_amount')->insert($inserdata);
                        $datatr['transaction_id'] = BRAND['name'] . '-REFUND-' . rand(100, 999) . $value->user_id;
                        $datatr['type'] = 'Revert Repeated Contest Refund Amount';
                        $datatr['transaction_by'] = BRAND['name'];
                        $datatr['amount'] = $value->deduct_amount - $deductamount;
                        $datatr['paymentstatus'] = 'confirmed';
                        $datatr['challengeid'] = $value->challengeid;
                        $datatr['bonus_amt'] = 0;
                        $datatr['win_amt'] = 0;
                        $datatr['addfund_amt'] = 0;
                        $datatr['bal_bonus_amt'] = 0;
                        $datatr['bal_win_amt'] = 0;
                        $datatr['bal_fund_amt'] = 0;
                        $datatr['userid'] = $value->user_id;
                        $datatr['total_available_amt'] = $userbalance->balance + $userbalance->winning + $userbalance->bonus;
                        DB::table('transactions')->insert($datatr);
                    } else {
                        $inserdata = array(
                            'user_id' => $value->user_id,
                            'matchkey' => $value->matchkey,
                            'challengeid' => $value->challengeid,
                            'joinid' => $value->joinid,
                            'total_deduct_amount' => $value->deduct_amount,
                            'deduct_amount' => 0,
                            'status' => 0,
                        );
                        DB::table('wining_refund_amount')->insert($inserdata);
                    }
                }
            }
        }
        // foreach ($userdata as $key => $value)
        // {
        //   if($value->balance>0)
        //   {
        //     $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
        //       if($userbalance->balance>=$value->deduct_amount)
        //       {
        //         $newbalnce=  $userbalance->balance-$value->deduct_amount;
        //           DB::table('userbalances')->where('user_id',$value->user_id)->update(['balance'=>$newbalnce]);
        //           $inserdata= array('user_id'=>$value->user_id,
        //           'matchkey'=>$value->matchkey,
        //           'challengeid'=>$value->challengeid,
        //           'joinid'=>$value->joinid,
        //           'total_deduct_amount'=>$value->deduct_amount,
        //           'deduct_amount'=>$value->deduct_amount,
        //           'status'=>1,
        //         );
        //         DB::table('wining_refund_amount')->insert($inserdata);
        //         $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
        //          $datatr['type'] = 'Revert Repeated Contest Refund Amount';
        //          $datatr['transaction_by'] = BRAND['name'];
        //          $datatr['amount'] = $value->deduct_amount;
        //          $datatr['paymentstatus'] = 'confirmed';
        //          $datatr['challengeid'] = $value->challengeid;
        //          $datatr['bonus_amt'] = 0;
        //          $datatr['win_amt'] = 0;
        //          $datatr['addfund_amt'] = 0;
        //          $datatr['bal_bonus_amt'] =0;
        //          $datatr['bal_win_amt'] = 0;
        //          $datatr['bal_fund_amt'] =0;
        //          $datatr['userid'] = $value->user_id;
        //          $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
        //          DB::table('transactions')->insert($datatr);
        //
        //       }else {
        //         $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
        //         if($userbalance->balance>0)
        //         {
        //           $deductamount= $value->deduct_amount-$userbalance->balance;
        //           DB::table('userbalances')->where('user_id',$value->user_id)->update(['balance'=>'0.00']);
        //
        //           $inserdata= array('user_id'=>$value->user_id,
        //           'matchkey'=>$value->matchkey,
        //           'challengeid'=>$value->challengeid,
        //           'joinid'=>$value->joinid,
        //           'total_deduct_amount'=>$value->deduct_amount,
        //           'deduct_amount'=>$value->deduct_amount-$deductamount,
        //           'status'=>0,
        //         );
        //           DB::table('wining_refund_amount')->insert($inserdata);
        //
        //           $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
        //            $datatr['type'] = 'Revert Repeated Contest Refund Amount';
        //            $datatr['transaction_by'] = BRAND['name'];
        //            $datatr['amount'] = $value->deduct_amount-$deductamount;
        //            $datatr['paymentstatus'] = 'confirmed';
        //            $datatr['challengeid'] = $value->challengeid;
        //            $datatr['bonus_amt'] = 0;
        //            $datatr['win_amt'] = 0;
        //            $datatr['addfund_amt'] = 0;
        //            $datatr['bal_bonus_amt'] =0;
        //            $datatr['bal_win_amt'] = 0;
        //            $datatr['bal_fund_amt'] =0;
        //            $datatr['userid'] = $value->user_id;
        //            $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
        //            DB::table('transactions')->insert($datatr);
        //         }
        //         else {
        //               $inserdata= array('user_id'=>$value->user_id,
        //               'matchkey'=>$value->matchkey,
        //               'challengeid'=>$value->challengeid,
        //               'joinid'=>$value->joinid,
        //               'total_deduct_amount'=>$value->deduct_amount,
        //               'deduct_amount'=>0,
        //               'status'=>0,
        //             );
        //               DB::table('wining_refund_amount')->insert($inserdata);
        //         }
        //       }
        //   }elseif($value->winning>0)
        //   {
        //     $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
        //     if($userbalance->winning>=$value->deduct_amount)
        //     {
        //         $newbalnce=  $userbalance->winning-$value->deduct_amount;
        //         DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>$newbalnce]);
        //         $inserdata= array('user_id'=>$value->user_id,
        //         'matchkey'=>$value->matchkey,
        //         'challengeid'=>$value->challengeid,
        //         'joinid'=>$value->joinid,
        //         'total_deduct_amount'=>$value->deduct_amount,
        //         'deduct_amount'=>$value->deduct_amount,
        //         'status'=>1,
        //       );
        //         DB::table('wining_refund_amount')->insert($inserdata);
        //         $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
        //          $datatr['type'] = 'Revert Repeated Contest Refund Amount';
        //          $datatr['transaction_by'] = BRAND['name'];
        //          $datatr['amount'] = $value->deduct_amount;
        //          $datatr['paymentstatus'] = 'confirmed';
        //          $datatr['challengeid'] = $value->challengeid;
        //          $datatr['bonus_amt'] = 0;
        //          $datatr['win_amt'] = 0;
        //          $datatr['addfund_amt'] = 0;
        //          $datatr['bal_bonus_amt'] =0;
        //          $datatr['bal_win_amt'] = 0;
        //          $datatr['bal_fund_amt'] =0;
        //          $datatr['userid'] = $value->user_id;
        //          $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
        //          DB::table('transactions')->insert($datatr);
        //     }
        //   //exit;
        //     else {
        //       $userbalance= DB::table('userbalances')->where('user_id',$value->user_id)->first();
        //       if($userbalance->winning>0)
        //       {
        //         $deductamount=  $value->deduct_amount-$userbalance->winning;
        //         DB::table('userbalances')->where('user_id',$value->user_id)->update(['winning'=>'0.00']);
        //
        //         $inserdata= array('user_id'=>$value->user_id,
        //         'matchkey'=>$value->matchkey,
        //         'challengeid'=>$value->challengeid,
        //         'joinid'=>$value->joinid,
        //         'total_deduct_amount'=>$value->deduct_amount,
        //         'deduct_amount'=>$value->deduct_amount-$deductamount,
        //         'status'=>0,
        //       );
        //         DB::table('wining_refund_amount')->insert($inserdata);
        //         $datatr['transaction_id'] = BRAND['name'].'-REFUND-'.rand(100,999).$value->user_id;
        //          $datatr['type'] = 'Revert Repeated Contest Refund Amount';
        //          $datatr['transaction_by'] = BRAND['name'];
        //          $datatr['amount'] = $value->deduct_amount-$deductamount;
        //          $datatr['paymentstatus'] = 'confirmed';
        //          $datatr['challengeid'] = $value->challengeid;
        //          $datatr['bonus_amt'] = 0;
        //          $datatr['win_amt'] = 0;
        //          $datatr['addfund_amt'] = 0;
        //          $datatr['bal_bonus_amt'] =0;
        //          $datatr['bal_win_amt'] = 0;
        //          $datatr['bal_fund_amt'] =0;
        //          $datatr['userid'] = $value->user_id;
        //          $datatr['total_available_amt'] = $userbalance->balance+$userbalance->winning+$userbalance->bonus;
        //          DB::table('transactions')->insert($datatr);
        //       }
        //       else{
        //         $inserdata= array('user_id'=>$value->user_id,
        //         'matchkey'=>$value->matchkey,
        //         'challengeid'=>$value->challengeid,
        //         'joinid'=>$value->joinid,
        //         'total_deduct_amount'=>$value->deduct_amount,
        //         'deduct_amount'=>0,
        //         'status'=>0,
        //       );
        //         DB::table('wining_refund_amount')->insert($inserdata);
        //       }
        //     }
        //   }
        // }
        echo 'done';
        exit;
        echo '<pre>';
        print_r($userdata);
        exit;
    }

    public function contestclashrefund($matchkey)
    {
        $contest = DB::table('matchchallenges')->where('matchkey', $matchkey)->where('joinedusers', 1)->where('challenge_category_id', 40)->where('status', '!=', 'canceled')->where('status', '!=', 'closed')
            //->where('id','405824')
            ->get();
        // echo '<pre>'; print_r($contest);exit;
        foreach ($contest as $key => $value) {
            $coinamount = ($value->bonus_precent * $value->entryfee) / 100;
            $rebalance = $value->entryfee - $coinamount;

            $userdata = DB::table('joinedleauges')
                ->where('matchkey', $matchkey)->where('challengeid', $value->id)->first();
            $leagetrans = DB::table('leaugestransactions')
                ->where('matchkey', $matchkey)->where('challengeid', $value->id)->first();
            echo '<pre>';
            print_r($userdata);
            exit;
            //echo '<pre>'; print_r($userdata);exit;
            if (empty($leagetrans)) {
                $array = array(
                    'userid' => $userdata->userid,
                    'amount' => $value->entryfee,
                    'joinid' => $userdata->id,
                    'challengeid' => $userdata->challengeid,
                    'matchkey' => $matchkey,
                    'reason' => 'Challenge cancel'
                );

                $userbalance = DB::table('userbalances')->where('user_id', $userdata->userid)->first();

                $userbal['balance'] = $userbalance->balance + $rebalance;
                $userbal['gst_bonus'] = $userbalance->gst_bonus + $coinamount;

                DB::table('userbalances')->where('user_id', $userdata->userid)->update($userbal);
                DB::table('refunds')->insert($array);
                DB::table('matchchallenges')->where('id', $value->id)->update(['status' => 'canceled']);
                $arraytransaction = array(
                    'userid' => $userdata->userid,
                    'type' => 'Refund amount',
                    'transaction_id' => BRAND['name'] . '-REFUND-' . rand(100, 999) . $userdata->userid,
                    'transaction_by' => 'PLAYNWIN11',
                    'paymentstatus' => 'confirmed',
                    'bal_gst_bonus_amt' => $userbalance->gst_bonus + $coinamount,
                    'bal_bonus_amt' => $userbalance->bonus,
                    'bal_win_amt' => $userbalance->winning,
                    'bal_fund_amt' => $userbalance->balance + $rebalance,
                    'total_available_amt' => $userbalance->balance + $userbalance->winning + $userbalance->bonus + $userbalance->gst_bonus + $value->entryfee,
                    'amount' => $value->entryfee,
                    'challengeid' => $userdata->challengeid,
                );
                // echo '<pre>'; print_r($arraytransaction);exit;
                DB::table('transactions')->insert($arraytransaction);
            }
        }
    }

    public function testUpdateSessionTable()
    {
        return true;
        $session_users = DB::table("registerusers_session")
            ->where("session_year", "2024")
            // ->where("user_id", 4873)
            ->get();
        //-  echo "<pre>"; print_r($session_users); exit;
        // echo count($session_users);die;
        foreach ($session_users as $key => $value) {
            $user_id = $value->user_id;
            // $total_commission = $value->total_commission;
            echo  $user_id . "<br>";
            $total_deposit = DB::table("transactions")
                ->where("created", ">=", "2023-04-01 00:00:00")
                ->where("userid", $user_id)
                ->where("type", "=", "add fund")
                ->where("paymentstatus", "=", "confirmed")
                ->sum("amount");

            $total_withdraw_q = DB::table("withdraw as w")
                ->leftJoin("tds_new as t", function ($j) {
                    $j->on("t.withdraw_id", "=", "w.id")->where("t.status", 1);
                })
                ->where("w.user_id", $user_id)
                ->where("w.created", ">=", "2023-04-01 00:00:00")
                ->where("w.status", "<>", "-1")
                ->selectRaw("IFNULL(sum(t.tds_amount),0) as tds_amount_total, sum(w.amount) as withdraw_amount")
                ->first();
            $total_withdraw = $total_withdraw_q->tds_amount_total + $total_withdraw_q->withdraw_amount;


            $total_tds_dedcuted = DB::table("tds_new")
                ->where("user_id", $user_id)
                ->where("status", 1)
                ->sum("tds_amount");

            $updateArr = [
                "total_withdraw" => $total_withdraw,
                "total_tds_dedcuted" => $total_tds_dedcuted,
                "total_deposit" => $total_deposit,
                // "total_commission" => DB::raw("total_commission + ". $total_commission)
            ];

            DB::table("registerusers_session")
                ->where("user_id", $user_id)
                ->where("session_year", "=", "2023")
                ->update($updateArr);

            DB::table("registerusers_session")
                ->where("user_id", $user_id)
                ->where("id", $value->id)
                ->update([
                    "user_id" => $user_id . "00002024"
                ]);
        }
        echo "Done";
        exit;
    }

    public function depositinvestment()
    {
        $getinvestment = DB::table('deposit_investment')->where('win_status', 0)->get();
        foreach ($getinvestment as $key => $deposit) {
            if (date('Y-m-d') >= $deposit->start_date && date('Y-m-d') <= $deposit->end_date) {
                $checkadd = DB::table('investment_deposit_leaderboard')->whereDate('created', date('Y-m-d'))->first();

                if (empty($checkadd)) {
                    $userinvestment = DB::table('deposit_gst')->whereDate('transactions_date', date('Y-m-d'))->get();

                    foreach ($userinvestment as $key => $userdepo) {
                        DB::table('investment_deposit_leaderboard')->insert(['deposit_id' => $deposit->id, 'user_id' => $userdepo->user_id, 'points' => $userdepo->deposit_amount]);
                    }
                }
                $this->update_depositinvestments_leaderboard($deposit->id);
            }
        }
    }

    public function update_depositinvestments_leaderboard($series_id)
    {
        //dd($series_id);
        $match_leaderboard = DB::table('investment_deposit_leaderboard')->select(DB::raw('SUM(points) as points, user_id, deposit_id'))->where('deposit_id', $series_id)->orderByRaw('SUM(points) DESC')->groupBy('user_id')->get();

        $lastpoints = 0;
        $skip_count = 0;
        $rank = 1;
        $i = 0;

        if (!$match_leaderboard->isEmpty()) {
            foreach ($match_leaderboard as $key => $value) {
                if ($value->points == $lastpoints) {
                    $skip_count++;
                    $data[$i]['rank'] = $rank - $skip_count;
                } else {
                    $data[$i]['rank'] = $rank;
                    $skip_count = 0;
                }
                $data[$i]['points'] = $value->points;
                $data[$i]['user_id'] = $value->user_id;
                $data[$i]['deposit_id'] = $value->deposit_id;
                $data[$i]['status'] = 1;
                $rank++;
                $i++;
                $lastpoints = $value->points;
            }

            $check = DB::table('investment_leaderboard_deposit')->where('deposit_id', $series_id)->exists();

            if ($check) {
                DB::table('investment_leaderboard_deposit')->where('deposit_id', $series_id)->delete();
            }
            DB::table('investment_leaderboard_deposit')->insert($data);
            // echo "<pre>"; print_r($data); exit;
        }

        return 1;
    }

    public function financialyear_old()
    {
        $user = DB::table('registerusers_session')->get();
        foreach ($user as $key => $users) {
            $userbalance = DB::table('userbalances')->where('user_id', $users->user_id)->first();
            $closingbal = $userbalance->winning;

            $totaldeposite = $users->total_deposit;

            $totalwithdraw = $users->total_withdraw;

            $totalTds = $users->total_tds_dedcuted;

            $total = $totalwithdraw + $closingbal - $totaldeposite;

            $newopeningbalance = $userbalance->winning;
            //$newopeningbalance= $userbalance->winning+$userbalance->balance;
            $remainingtaxdata = 0;
            if ($total > 0) {
                $tdstax = $total * 0.3;
                $remainingtax = $tdstax - $totalTds;
                $newopeningbalance = $userbalance->winning;
                // $newopeningbalance= $userbalance->winning+$userbalance->balance;

                if ($remainingtax > 0) {
                    $remainingtaxdata = $remainingtax;
                    $newopeningbalance = $closingbal - $remainingtax;
                    //echo "</br>***NOT EMPTY TOTAL REMAINING **<pre>";print_r($remainingtax);
                }
            }


            $revert_total_amount = $remainingtaxdata;
            $be_revert_amount = 0;
            $revert_bal_amount = 0;
            $revert_bonus_amount = 0;
            $revert_win_amount = 0;
            $revert_gst_bonus_amount = 0;
            $getwalletData = DB::table('userbalances')
                ->where('user_id', $users->user_id)->select('user_id', 'balance', 'winning')->first();
            /// DEDUCT FROM WINNING
            if ($userbalance->winning >= $revert_total_amount) {

                $userBalance['winning'] = $userbalance->winning - $revert_total_amount;
                $be_revert_amount = $revert_total_amount;
                $revert_win_amount = $revert_total_amount;
                $revert_total_amount = 0;

                // $be_revert_amount = $be_revert_amount+  $revert_total_amount;
                // $revert_win_amount = $userbalance->winning - $revert_total_amount;
                //   $revert_total_amount =0;

            } else if ($userbalance->winning < $revert_total_amount) {
                $userBalance['winning'] = 0;
                $be_revert_amount = $userbalance->winning;
                $revert_total_amount = $revert_total_amount - $userbalance->winning;
                $revert_win_amount = $userbalance->winning;

                // $be_revert_amount = $userbalance->winning;
                // $revert_total_amount = $revert_total_amount - $getwalletData->winning;
                // $revert_win_amount = $userbalance->winning;
            }
            /// DEDUCT FROM BALANCE

            if ($userbalance->balance >= $revert_total_amount) {
                $userBalance['balance'] = $userbalance->balance - $revert_total_amount;
                $be_revert_amount = $be_revert_amount +  $revert_total_amount;
                $revert_bal_amount = $userbalance->balance - $revert_total_amount;
                $revert_total_amount = 0;
                // $be_revert_amount = $revert_total_amount;
                // $revert_bal_amount = $revert_total_amount;
                // $revert_total_amount =0;
            } else if ($userbalance->balance < $revert_total_amount) {
                $userBalance['balance'] = 0;
                $be_revert_amount = $be_revert_amount + $userbalance->balance;
                $revert_total_amount = $revert_total_amount - $getwalletData->balance;
                $revert_bal_amount = $userbalance->balance;
                // $be_revert_amount = $userbalance->balance;
                // $revert_total_amount = $revert_total_amount - $userbalance->balance;
                // $revert_bal_amount = $userbalance->balance;
            }



            $session_year = "2024";
            $registerusers_session = DB::table("registerusers_session")
                ->where("user_id", $users->user_id)
                ->where("session_year", $session_year)
                ->first();
            if (empty($registerusers_session)) {

                DB::table('userbalances')->where('user_id', $userbalance->user_id)->update($userBalance);

                $AfterDeduct_walletData = DB::table('userbalances')
                    ->where('user_id', $users->user_id)->first();

                DB::table("registerusers_session")
                    ->insert([
                        "user_id" => $userbalance->user_id,
                        "session_year" => $session_year,
                        "opening_balance" => $newopeningbalance,
                        "total_deposit" => 0,
                        "total_withdraw" => 0,
                    ]);

                if ($be_revert_amount > 0) {
                    $revert_transaction_id = 'PLAYNWIN11-FINA' . time() . '' . $userbalance->user_id;

                    $transaction = array(
                        "userid" => $getwalletData->user_id,
                        "type" => 'Financial Year Balance Deduct',
                        "transaction_id" => $revert_transaction_id,
                        "transaction_by" => 'wallet',
                        "amount" => $be_revert_amount,
                        "paymentstatus" => 'confirmed',
                        "cons_amount" => $revert_bal_amount,
                        "cons_win" => $revert_win_amount,
                        //  "bonus_amt" =>$AfterDeduct_walletData->bonus,
                        // "gst_bonus_amt" =>$AfterDeduct_walletData->gst_bonus,
                        "bal_win_amt" => round($AfterDeduct_walletData->winning, 2),
                        "bal_fund_amt" => round($AfterDeduct_walletData->balance, 2),
                        "bal_bonus_amt" => $AfterDeduct_walletData->bonus,
                        "bal_gst_bonus_amt" => $AfterDeduct_walletData->gst_bonus,
                        "bal_affi_amt" => $AfterDeduct_walletData->affiliation_commission,
                        "total_available_amt" => round(($AfterDeduct_walletData->winning + $AfterDeduct_walletData->balance + $AfterDeduct_walletData->bonus + $AfterDeduct_walletData->gst_bonus + $AfterDeduct_walletData->affiliation_commission), 2),
                    );
                    DB::table('transactions')->insert($transaction);
                }

                $remaingAmount = $remainingtaxdata - $be_revert_amount;

                if ($remaingAmount > 0) {
                    $reverremaing = array(
                        "user_id" => $getwalletData->user_id,
                        // "matchkey"=>$match_key,
                        "total_deduct_amount" => $remainingtaxdata,
                        "deduct_amount" => $be_revert_amount,
                        "remain_deduct_amount" => $remaingAmount,
                        "status" => ($remaingAmount <= 0) ? 1 : 0
                    );

                    DB::table('revert_repeated_refund_amount')->insert($reverremaing);
                    // echo "</br>"; print_r($reverreming);
                }
            }
        }
    }


    public function financialyear()
    {
        $titleget = 'test';
        $userid = 5;
        $notificationdata['title'] = 'test notificatopn';
        Helpers::sendnotification($titleget, $notificationdata['title'], '', $userid);

        exit;
        $user = DB::table('userbalances')
            ->where('league11_winning', 0)
            //->where('user_id',4808)
            ->limit(10000)
            ->get();
        foreach ($user as $key => $userbalance) {
            $usersession = DB::table('registerusers_session')->where('user_id', $userbalance->user_id)->where('session_year', '2023')->first();
            $closingbal = $userbalance->winning;

            $totaldeposite = @$usersession->total_deposit;

            $totalwithdraw = @$usersession->total_withdraw;

            $totalTds =  @$usersession->total_tds_dedcuted;

            $total = $totalwithdraw + $closingbal - $totaldeposite;

            $newopeningbalance = $userbalance->winning;
            //$newopeningbalance= $userbalance->winning+$userbalance->balance;

            $remainingtaxdata = 0;
            if ($total > 0) {
                $tdstax = $total * 0.3;
                $remainingtax = $tdstax - $totalTds;
                $newopeningbalance = $userbalance->winning;
                // $newopeningbalance= $userbalance->winning+$userbalance->balance;

                if ($remainingtax > 0) {
                    $remainingtaxdata = $remainingtax;
                    $newopeningbalance = $closingbal - $remainingtax;
                    //echo "</br>***NOT EMPTY TOTAL REMAINING **<pre>";print_r($remainingtax);
                }
            }

            $revert_total_amount = $remainingtaxdata;
            $be_revert_amount = 0;
            $revert_bal_amount = 0;
            $revert_bonus_amount = 0;
            $revert_win_amount = 0;
            $revert_gst_bonus_amount = 0;
            $getwalletData = DB::table('userbalances')
                ->where('user_id', $userbalance->user_id)->select('user_id', 'balance', 'winning')->first();
            /// DEDUCT FROM WINNING
            $users = DB::table('userbalances')
                ->where('user_id', $userbalance->user_id)->select('user_id', 'balance', 'winning')->first();

            $cons_winning = 0;
            $cons_balance = 0;
            if ($remainingtaxdata > 0) {

                $remaningAmount = $remainingtaxdata;
                if ($users->winning >= $remaningAmount) {
                    $winning = $users->winning - $remaningAmount;
                    $cons_winning = $remaningAmount;
                    $remaningAmount = 0;
                } else {
                    $winning = 0;
                    $remaningAmount = $remaningAmount - $users->winning;
                    $cons_winning =  $users->winning;
                }



                if ($remaningAmount > 0) {
                    if ($users->balance >= $remaningAmount) {
                        $balance = $users->balance - $remaningAmount;
                        $cons_balance = $remaningAmount;
                        $remaningAmount = 0;
                    } else {
                        $balance = 0;
                        $remaningAmount = $remaningAmount - $users->balance;
                        $cons_balance = $users->balance;
                    }
                }
            }

            if ($userbalance->winning >= $revert_total_amount && $userbalance->winning > 0) {

                $userBalance['winning'] = $userbalance->winning - $revert_total_amount;
                $be_revert_amount = $revert_total_amount;
                $revert_win_amount = $revert_total_amount;
                $revert_total_amount = 0;

                // $be_revert_amount = $be_revert_amount+  $revert_total_amount;
                // $revert_win_amount = $userbalance->winning - $revert_total_amount;
                //   $revert_total_amount =0;

            } else if ($userbalance->winning < $revert_total_amount) {
                $userBalance['winning'] = 0;
                $be_revert_amount = $userbalance->winning;
                $revert_total_amount = $revert_total_amount - $userbalance->winning;
                $revert_win_amount = $userbalance->winning;

                // $be_revert_amount = $userbalance->winning;
                // $revert_total_amount = $revert_total_amount - $getwalletData->winning;
                // $revert_win_amount = $userbalance->winning;
            }
            /// DEDUCT FROM BALANCE


            if ($userbalance->balance >= $revert_total_amount && $userbalance->balance > 0) {
                $userBalance['balance'] = $userbalance->balance - $revert_total_amount;
                $be_revert_amount =  $be_revert_amount + $revert_total_amount;
                $revert_bal_amount = $userbalance->balance - $revert_total_amount;
                $revert_total_amount = 0;
                // $be_revert_amount = $revert_total_amount;
                // $revert_bal_amount = $revert_total_amount;
                // $revert_total_amount =0;

            } else if ($userbalance->balance < $revert_total_amount) {

                $userBalance['balance'] = 0;
                $be_revert_amount = $be_revert_amount + $userbalance->balance;
                $revert_total_amount = $revert_total_amount - $getwalletData->balance;
                $revert_bal_amount = $userbalance->balance;
                // $be_revert_amount = $userbalance->balance;
                // $revert_total_amount = $revert_total_amount - $userbalance->balance;
                // $revert_bal_amount = $userbalance->balance;
            }

            // dd($be_revert_amount);
            $session_year = "2024";
            $registerusers_session = DB::table("registerusers_session")
                ->where("user_id", $userbalance->user_id)
                ->where("session_year", $session_year)
                ->first();
            if (empty($registerusers_session)) {

                $total_deducted_amount = ($cons_winning + $cons_balance);

                if ($total_deducted_amount > 0) {

                    $data = array(
                        "winning"    => DB::raw("winning - " . $cons_winning),
                        "balance"    => DB::raw("balance - " . $cons_balance)
                    );
                    // update user balance
                    $userbalance = DB::table('userbalances')->where('user_id', $users->user_id)->update($data);
                }

                // DB :: table('userbalances')->where('user_id',$userbalance->user_id)->update($userBalance);
                $AfterDeduct_walletData = DB::table('userbalances')
                    ->where('user_id', @$users->user_id)->first();


                if ($newopeningbalance > 0) {
                    $newopeningbalance = $newopeningbalance;
                } else {
                    $newopeningbalance = 0;
                }
                DB::table("registerusers_session")
                    ->insert([
                        "user_id" => $users->user_id,
                        "session_year" => $session_year,
                        "opening_balance" => $newopeningbalance,
                        "total_deposit" => 0,
                        "total_withdraw" => 0,
                    ]);

                DB::table('session_balance')->insert([
                    "session_year" => '2023',
                    "user_id" => $users->user_id,
                    "total_deposit" => isset($totaldeposite) ? $totaldeposite : 0,
                    "total_withdraw" => isset($totalwithdraw) ? $totalwithdraw : 0,
                    "total_tds_dedcuted" => isset($totalTds) ? $totalTds : 0,
                    "closing_balance" => isset($closingbal) ? $closingbal : 0,
                    "new_tds" => $remainingtaxdata,
                    "opening_balance" => $newopeningbalance
                ]);

                if ($remainingtaxdata > 0) {
                    $newtds = $totalTds + $remainingtaxdata;
                    DB::table('registerusers_session')->where('user_id', $users->user_id)->where('session_year', '2023')
                        ->update(['total_tds_dedcuted' => $newtds]);
                }


                if ($total_deducted_amount > 0) {
                    $revert_transaction_id = 'PLAYNWIN11-FINA' . time() . '' . $users->user_id;

                    $transaction = array(
                        "userid" => $getwalletData->user_id,
                        "type" => 'Financial Year Balance Deduct',
                        "transaction_id" => $revert_transaction_id,
                        "transaction_by" => 'wallet',
                        "amount" => $total_deducted_amount,
                        "paymentstatus" => 'confirmed',
                        "cons_amount" => $cons_balance,
                        "cons_win" => $cons_winning,
                        //  "bonus_amt" =>$AfterDeduct_walletData->bonus,
                        // "gst_bonus_amt" =>$AfterDeduct_walletData->gst_bonus,
                        "bal_win_amt" => round($AfterDeduct_walletData->winning, 2),
                        "bal_fund_amt" => round($AfterDeduct_walletData->balance, 2),
                        "bal_bonus_amt" => $AfterDeduct_walletData->bonus,
                        "bal_gst_bonus_amt" => $AfterDeduct_walletData->gst_bonus,
                        "bal_affi_amt" => $AfterDeduct_walletData->affiliation_commission,
                        "total_available_amt" => round(($AfterDeduct_walletData->winning + $AfterDeduct_walletData->balance + $AfterDeduct_walletData->bonus + $AfterDeduct_walletData->gst_bonus + $AfterDeduct_walletData->affiliation_commission), 2),
                    );
                    DB::table('transactions')->insert($transaction);
                }

                DB::table('userbalances')->where('user_id', $getwalletData->user_id)->update(['league11_winning' => 1]);

                $remaingAmount = $remainingtaxdata - $total_deducted_amount;

                if ($remaingAmount > 0) {
                    $reverremaing = array(
                        "user_id" => $getwalletData->user_id,
                        // "matchkey"=>$match_key,
                        "total_deduct_amount" => $remainingtax,
                        "deduct_amount" => $total_deducted_amount,
                        "remain_deduct_amount" => $remaingAmount,
                        "status" => ($remaingAmount <= 0) ? 1 : 0,
                        "resion" => 'Financial year balance'
                    );

                    DB::table('revert_repeated_refund_amount')->insert($reverremaing);
                    // echo "</br>"; print_r($reverreming);
                }
            }
        }
        echo 'done';
    }

    public function bonus_expire()
    {  //die;
        ini_set('memory_limit', '-1');

        $current_date = date('Y-m-d H:i:s');
        $date_before_thirty_days = date('Y-m-d', strtotime('-30 days'));
        $date_exclude = date('Y-m-d', strtotime('-29 days'));

        echo $date_before_thirty_days;
        echo $date_exclude . '<br>';

        //new query

        $bonus_txns = DB::table('transactions')
            ->select(
                'userid',
                'created_at',
                DB::raw('SUM(CASE
                      WHEN created_at LIKE "' . $date_before_thirty_days . '%"

                         THEN amount
                         ELSE 0
                     END) as total_amount'),
                DB::raw('SUM(CASE
                         WHEN created_at >= "' . $date_exclude . ' 00:00:00"
                         AND created_at < "' . $current_date . '"
                         THEN amount
                         ELSE 0
                     END) as ignore_amount')
            )
            ->whereIn('type', [
                'SIGN UP BONUS (Valid For 30 Days)',
                'REFER BONUS AMOUNT (Valid For 30 Days)'
            ])
            ->groupBy('userid')
            ->havingRaw('total_amount > 0 OR ignore_amount > 0')
            ->get();

        $other_ignore_amount = DB::table('transactions')
            ->select(
                'userid',
                DB::raw('SUM(CASE
                           WHEN
                           created_at < "' . $current_date . '"
                           THEN amount
                           ELSE 0
                       END) as ignore_amount')
            )
            ->whereIn('type', [
                'Bonus add during add fund',
                'Offer Bonus add during add fund',
                'Sign UP Bonus for Bank Verify',
                'Sign UP Bonus for Pan Verify',
                'Special Bonus'
            ])
            ->groupBy('userid')
            ->havingRaw('ignore_amount > 0')
            ->pluck('ignore_amount', 'userid')->toArray();

        echo '----------------------------------------------------------';
        echo '<pre>';
        echo ' Txn DATA';
        echo '<br>';
        print_r($bonus_txns); //die;
        echo '************************************************************';


        $txn_log = [];
        $bonus_deduct_log = [];
        $count = 0;
        $dedcucttype = 'Bonus';
        DB::beginTransaction();
        try {
            if (!$bonus_txns->isEmpty()) {
                foreach ($bonus_txns as $v) {
                    $user_id = $v->userid;
                    echo '<br>';
                    echo $user_id;
                    $other_amt = 0;
                    if (array_key_exists($user_id, $other_ignore_amount)) {
                        $other_amt = $other_ignore_amount[$user_id];
                    }


                    $v->ignore_amount =  $v->ignore_amount + $other_amt;

                    $userBalance = DB::table('userbalances')->where('user_id', $user_id)->first();

                    if (!$userBalance) {
                        echo "User balance not found for user ID: $user_id";
                        continue;
                    }

                    echo ' user balance : ';
                    print_r($userBalance);
                    echo '<br>';
                    echo '*********************************************************';

                    if ($userBalance->bonus != 0) {
                        echo 'balance not equal to zero... ';

                        $deductable_amt = 0;
                        if ($v->ignore_amount > 0) {
                            echo 'ignore amount greater than  0';
                            $ignore_amt = $v->ignore_amount;
                            echo ' ignore amt : ' . $ignore_amt;
                            $deductable_amt = $userBalance->bonus - $ignore_amt;
                            echo ' final deducted  amt : ' . $deductable_amt;
                        } else {
                            echo 'in else becoz there are no igmore amounts found !!!!!!!!';
                            if ($v->total_amount > $userBalance->bonus) {
                                $deductable_amt = $userBalance->bonus;
                            } else {
                                $deductable_amt = $v->total_amount;
                            }
                            echo 'final  deductable amt : ' . $deductable_amt;
                        }

                        if ($deductable_amt > 0) {
                            $obj['bonus'] = $userBalance->bonus - $deductable_amt;
                            echo '<br>';
                            echo 'Remaining bonus : ' . $obj['bonus'];
                            DB::table('userbalances')->where('user_id', $user_id)->update($obj);

                            $userBalances = DB::table('userbalances')->where('user_id', $user_id)->first();

                            $trans_id = 'PLAYNWIN11-BONUSEXP' . time() . '' . $user_id;
                            $txn_log[$count] = [
                                'userid' => $user_id,
                                'type' => "Bonus Expired",
                                'transaction_id' => $trans_id,
                                'transaction_by' => "wallet",
                                'amount' =>  $deductable_amt,
                                'paymentstatus' => "confirmed",
                                'bal_bonus_amt' => $userBalances->bonus,
                                'bal_win_amt' => $userBalances->winning,
                                'bal_fund_amt' => $userBalances->balance,
                                'cons_bonus' => $deductable_amt,
                                'cons_win' =>  0,
                                'cons_amount' => 0,
                                'total_available_amt' => $userBalances->balance + $userBalances->winning + $userBalances->bonus,
                            ];

                            $bonus_deduct_log[$count] = [
                                'user_id' => $user_id,
                                'deduct_amt' => $deductable_amt,
                                'available_bonus' => $userBalances->bonus,
                                'created_date' => $current_date,
                            ];

                            $count++;
                        }
                    }
                }

                echo '<br>';
                echo 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXx';
                echo 'transaction table log';
                echo '<pre>';
                print_r($txn_log);

                echo '&&&&&&&&&&&&&&&&&&&&&&&&&&&& bonus log data    &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&';
                echo '<pre>';
                print_r($bonus_deduct_log);

                try {
                    DB::table('transactions')->insert($txn_log);
                } catch (\Illuminate\Database\QueryException $ex) {
                    dd($ex->getMessage());
                }

                try {
                    DB::table('bonus_deduct_log')->insert($bonus_deduct_log);
                } catch (\Illuminate\Database\QueryException $ex) {
                    dd($ex->getMessage());
                }
            }

            // Commit the transaction
            DB::commit();
        } catch (\Exception $e) {
            // Rollback the transaction in case of any error
            DB::rollBack();
            echo "Error: " . $e->getMessage();
        }
    }
    public function bonus_expire_old()
    {
        $enddate = date('Y-m-d', strtotime('-30 days'));
        $userbonus = DB::table('transactions')
            //->where('userid',64)
            ->whereIN(
                'type',
                ['SIGN UP BONUS (Valid For 30 Days)', 'REFER BONUS AMOUNT (Valid For 30 Days)'] //,'Bonus add during add fund'
            )
            ->where('paymentstatus', 'confirmed')
            ->where('created', '>', $enddate . " 00:00:00")
            ->selectRaw("sum(amount) as credited_bonus, userid")
            ->groupBy("userid")
            ->havingRaw("credited_bonus > 0")
            ->get();

        $transactions_arr = [];
        foreach ($userbonus as $key => $value) {
            $transactions_arr[$value->userid] = $value->credited_bonus;
        }

        $user = DB::table('userbalances')
            ->where('bonus', '>', 0)
            // ->where('user_id', 64)
            ->selectRaw("user_id, bonus")
            ->get();
        foreach ($user as $key => $value) {
            $user_id = $value->user_id;
            $bonus = $value->bonus;
            $lastCreditedBonus = @$transactions_arr[$value->user_id] ?? 0;

            if ($bonus <= $lastCreditedBonus) {
                continue;
            }
            $bonus_deduct = $bonus - $lastCreditedBonus;

            $remainingamout = $bonus - $bonus_deduct;
            DB::table('userbalances')
                ->where('user_id', $user_id)
                ->update(["bonus" => $remainingamout]);
            if ($bonus_deduct > 0) {
                $userbalance = DB::table('userbalances')
                    ->where('user_id', $user_id)
                    //->selectRaw("user_id, bonus,winning,balan")
                    ->first();
                $revert_transaction_id = 'PLAYNWIN11-BONUSEXP' . time() . '' . $user_id;

                $transaction = array(
                    "userid" => $user_id,
                    "type" => 'Bonus Expired',
                    "transaction_id" => $revert_transaction_id,
                    "transaction_by" => 'wallet',
                    "amount" => $bonus_deduct,
                    "paymentstatus" => 'confirmed',
                    "cons_amount" => 0,
                    "cons_bonus" => $bonus_deduct,
                    "bal_win_amt" => $userbalance->winning,
                    "bal_fund_amt" => $userbalance->balance,
                    "bal_bonus_amt" => $remainingamout,
                    "bal_gst_bonus_amt" => $userbalance->gst_bonus,
                    "bal_affi_amt" => $userbalance->affiliation_commission,
                    "total_available_amt" => round(($userbalance->winning + $userbalance->balance + $userbalance->bonus + $userbalance->gst_bonus + $userbalance->affiliation_commission), 2),
                );
                DB::table('transactions')->insert($transaction);
            }
            // echo $user_id.'=>'; echo $bonus.'=>'.$remainingamout.'<br/>';
        }
        echo "Bonus expire Done";
    }

    public function isValidAmount($amount)
    {
        // Check if the input is a valid number (integer or decimal with up to 2 decimal places)
        return preg_match('/^\d+(\.\d{1,2})?$/', $amount);
    }
    public function bulk_add_cash(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'add_cash_csv' => 'required|mimes:csv,txt',
                'wallet' => 'required',
            ]);
            $wallet = $request->wallet;
            $file = $request->file('add_cash_csv');
            $csvFile = fopen($file->getRealPath(), 'r');
            $headers = fgetcsv($csvFile);
            $rows = array_map('str_getcsv', file($file->getRealPath()));
            fclose($csvFile);
            array_shift($rows); //remove first row
            // Combine headers with the respective rows
            $data = array_map(function ($row) use ($wallet) {

                $mobile = trim($row[0]);
                $amount = trim($row[1]);
                $comment = "";
                if (!empty($row[2])) {
                    $comment = $row[2];
                }
                $txn_info = '';
                $status = '';
                if (!empty($wallet) && $amount > 0 && !empty($this->isValidAmount($amount))) {
                    $finduserbalanace = DB::table('userbalances')
                        ->join('registerusers', 'registerusers.id', '=', 'userbalances.user_id')
                        ->where('mobile', $mobile)
                        ->select('userbalances.*')
                        ->first();
                    if (!empty($finduserbalanace)) {
                        $user_id = $finduserbalanace->user_id;
                        $balancebal = $finduserbalanace->balance;
                        $winningbal = $finduserbalanace->winning;
                        $bonusbal = $finduserbalanace->bonus;
                        $gstbonusbal = $finduserbalanace->gst_bonus;
                        $affbalancebal = $finduserbalanace->affiliation_commission;
                        $transactiondata = array();
                        $transactiondata['transaction_by'] = "admin";
                        $txn_info = $transactiondata['transaction_id'] = 'CSV-' . $user_id . '-' . time() . rand(1, 9);
                        if ($wallet == 'balance') {
                            $balancebal += $amount;
                            $transactiondata['addfund_amt'] = $amount;
                            $transactiondata['type'] = 'Add Amount';
                        }
                        if ($wallet == 'winning') {
                            $winningbal += $amount;
                            $transactiondata['win_amt'] = $amount;
                            $transactiondata['type'] = 'Winning Amount';
                        }
                        if ($wallet == 'bonus') {
                            $bonusbal += $amount;
                            $transactiondata['bonus_amt'] = $amount;
                            $transactiondata['type'] = 'Bonus Amount';
                        }
                        if ($wallet == 'gst_bonus') {
                            $gstbonusbal += $amount;
                            $transactiondata['gst_bonus_amt'] = $amount;
                            $transactiondata['type'] = 'GST/TDS Bonus';
                        }
                        if ($wallet == 'affiliation_commission') {
                            $affbalancebal += $amount;
                            $transactiondata['affiliation_amount'] = $amount;
                            $transactiondata['type'] = 'Affiliation Amount';
                        }
                        $update = array();
                        $update['bonus'] = $bonusbal;
                        $update['balance'] = $balancebal;
                        $update['winning'] = $winningbal;
                        $update['gst_bonus'] = $gstbonusbal;
                        $update['affiliation_commission'] = $affbalancebal;
                        $nowtotalbal = $bonusbal + $balancebal + $winningbal + $gstbonusbal + $affbalancebal;
                        DB::table('userbalances')->where('user_id', $user_id)->update($update);

                        $transactiondata['amount'] = $amount;
                        $transactiondata['total_available_amt'] = $nowtotalbal;
                        $transactiondata['userid'] = $user_id;
                        $transactiondata['paymentstatus'] = 'confirmed';
                        $transactiondata['bal_bonus_amt'] = $bonusbal;
                        $transactiondata['bal_gst_bonus_amt'] = $gstbonusbal;
                        $transactiondata['bal_win_amt'] = $winningbal;
                        $transactiondata['bal_fund_amt'] = $balancebal;
                        $transactiondata['bal_affi_amt'] = $affbalancebal;
                        $status = DB::table('transactions')->insertGetId($transactiondata);
                    } else {
                        $status = "User not found";
                    }
                } else {
                    $status = "Amount is less then 0 or Inavlid";
                }

                $new_row = array();
                $new_row['mobile'] = $mobile;
                $new_row['amount'] = $amount;
                $new_row['comment'] = $comment;
                $new_row['wallet'] = $wallet;
                if (empty($txn_info)) {
                    $new_row['txn_info'] = $status;
                } else {
                    $new_row['txn_info'] = $txn_info . ' (' . $status . ')';
                }

                return $new_row;
                //return array_combine($headers, $row);
            }, $rows);

            // save all csv rows
            DB::table('add_cash_csv')->insert($data);
            Session::flash('flash_notice', 'CSV uploaded successfully!');
            Session::flash('alert-class', 'alert-success');
            Helpers::logActivity('Add Cash CSV uploaded successfully!', "Bulk Add Cash");

            return Redirect::back();
        }
        //echo 'hi';die;
        $totaluser = "";
        return view("admin.$this->model.bulk_add_cash", compact('totaluser'));
    }

    public function get_bulk_add_cash(Request $req)
    {

        //Get Post Data
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (empty($formData['start_date'])) {
                $formData['start_date'] = date('Y-m-d H:i:s');
            }
            if (empty($formData['end_date'])) {
                $formData['end_date'] = date('Y-m-d H:i:s');
            }
            //echo '<pre>'; print_r($formData);exit;

            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    DB::table('add_cash_csv')
                        // ->where(function ($query) use ($formData) {
                        //   if(isset($formData['start_date']) && isset($formData['end_date']))
                        //   {
                        //     $newdate= date('Y-m-d', strtotime($formData['start_date']));
                        //     $startdate= $newdate.' 00:00:00';
                        //     $query->whereBetween('transactions.created', [$startdate, $formData['end_date']]);
                        //   }
                        // })
                        ->orderBy('id', 'DESC')->get()
                )
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->make(true);
            }
        }
    }

    public function verifyaddress(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();
            if (isset($formData) && !empty($formData)) {
                return Datatables::of(
                    $query = DB::table('address_verify as u')
                        ->join('registerusers as r', 'r.id', '=', 'u.user_id')
                        // ->orwhere('r.pan_verify', '0')
                        ->where('r.mobile_verify', '1')
                        //  ->where('r.email_verify', '1')
                        ->where(function ($query) use ($formData) {
                            if (isset($formData['filter_columns'])) {
                                if (isset($formData['filter_columns']['filter_username'])) {
                                    $query->where('r.username', 'like', '%' . $formData['filter_columns']['filter_username'] . '%');
                                }
                                if (isset($formData['filter_columns']['filter_mobile'])) {
                                    $query->where('r.mobile', 'like', '%' . $formData['filter_columns']['filter_mobile'] . '%');
                                }
                            }
                        })
                        ->select('r.mobile', 'r.mobile', 'r.username', 'r.mobile_verify', 'r.mobile_verify', 'u.*')
                        ->orderBY('u.created', 'ASC')
                        ->get()
                )
                    ->addIndexColumn()
                    ->addColumn('mobile', function ($result) {
                        //return '<a href="'.route($this->model.'.view_address_details', base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->mobile.'</a>';
                        return '<a href="javascript:void(0);" data-id="' . $result->id . '" data-toggle="tooltip" title="" class="btn-primary-light icon change_status" title="Change Status" data-original-title="Detail" style="text-decoration:underline;">' . $result->mobile . '</a>';
                    })
                    ->addColumn('username', function ($result) {
                        return $result->username;
                            //return '<a href="'.route($this->model.'.view_pan_details', base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn-primary-light icon" data-original-title="Detail" style="text-decoration:underline;">'.$result->username.'</a>'
                        ;
                    })
                    ->addColumn('created', function ($result) {
                        if ($result->created != '0000-00-00 00:00:00') {
                            return date('d M Y', strtotime($result->created));
                        } else {
                            return '';
                        }
                    })
                    ->addColumn('document_type', function ($result) {
                        return $result->document_type;
                    })
                    ->addColumn('document_id', function ($result) {
                        return $result->document_id;
                    })

                    ->addColumn('status', function ($result) {
                        $status = '';
                        if ($result->status == '1') {
                            $status = 'Verified';
                        } elseif ($result->status == '0') {
                            $status = 'Pending';
                        } elseif ($result->status == '2') {
                            $status = 'Rejected';
                        }
                        return '<a href="javascript:void(0);" data-id="' . $result->id . '" data-toggle="tooltip" title="" class="btn-primary-light icon change_status" title="Change Status" data-original-title="Detail" style="text-decoration:underline;">' . $status . '</a>';

                        //return $status;
                    })
                    ->escapeColumns([])
                    ->make(true);
            } //end

        }
        return view("admin.$this->model.address_verify");
    } //End Function

    public function verifyaddress_status(Request $request)
    {
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];
            DB::table('address_verify')->where('id', $id)->update(array('status' => $input['status']));
            return Redirect::back();
        }
    }

    //View Pan Card Detail
    public function viewaddressdetails($id)
    {

        //Get Data
        $id = unserialize(base64_decode($id));
        //Get Data
        $addressdetails = DB::table('address_verify')
            ->where('address_verify.id', $id)
            ->join('registerusers', 'registerusers.id', '=', 'address_verify.user_id')
            ->select('address_verify.*', 'registerusers.mobile', 'registerusers.dob', 'registerusers.username')
            ->first();
        //echo "<pre>"; print_r($pancarddetails); die();
        if (!empty($addressdetails)) {
            return view("admin.$this->model.viewaddressdetails", compact('addressdetails'));
        } else {
            Session::flash('error', 'Data Not Found!');
            return Redirect::back();
        }
    } //End Function

    //Update address Status
    public function updateaddressstatus(Request $request)
    {

        $status = "";
        if ($request->isMethod('post')) {
            $input = Input::all();
            $id = $input['id'];
            $status = $input['status'];
        }
        if ($status != "") {
            if ($status == 1) {
                $st = 'Verified';
            }
        }
        unset($input['_token']);
        $req['address_verify'] = $status;
        DB::table('address_verify')->where('id', $id)->update($input);
        $findlastow = DB::table('address_verify')->where('id', $id)->first();
        if (!empty($findlastow)) {
            $userid = $findlastow->user_id;
        }

        if ($status == 1) {
            $st = 'Verified';
        }
        if ($status == 2) {
            $st = 'rejected';
            Helpers::logActivity('address detail Rejected', $userid);
        }


        if ($status == 1) {

            Helpers::logActivity('address Approved', $userid);
        }
        Helpers::logActivity('address verification request is' . $st . '!', $userid);

        DB::table('registerusers')->where('id', $userid)->update($req);
        $notificationdata['userid'] = $userid;
        $notificationdata['title'] = 'Your address verification request is ' . $st;
        DB::table('notifications')->insert($notificationdata);
        //push notifications//
        $titleget = 'Verification Request!';
        //Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
        //end push notifications//
        Session::flash('flash_notice', 'address Request is ' . $st . '!');
        return Redirect::back();
    } //End Function
    public function editaddressdetails(Request $request, $id)
    {

        //Get ID Unserialize
        $id = unserialize(base64_decode($id));
        //Get Pan Card Data
        $editaddressdetails = DB::table('address_verify')->where('id', $id)->first();

        if ($request->isMethod('post')) {

            //Velidation Bank
            $validate = array(
                'address_id'              => "required",
                // 'virtual_adhar_id'                => "required",
                // 'pan_dob'              	  => "required",
                // 'status'              	  => "required",
                // 'comment'              	  => "required",
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Get Input data
                $input = Input::all();
                // dd($input);
                //Set Value
                //  $status=$input['status'];
                //  $fiends['address_id'] = $input['adhar_number');


                unset($input['_token']);

                //print_r($input);die;
                DB::table('address_verify')->where('id', $id)->update($input);
                $findlastow = DB::table('address_verify')->where('id', $id)->first();
                // if(!empty($findlastow)){
                //   $userid = $findlastow->userid;
                // }
                // $finduserbonus = DB::table('registerusers')->where('id',$userid)->select('panbonus','mobile','team')->first();


                // $notificationdata['userid'] = $userid;
                // $notificationdata['title'] = 'Your ADHAR card verification request is '.$st;

                //push notifications//
                $titleget = 'Verification Request!';
                //  Helpers::sendnotification($titleget,$notificationdata['title'],'',$userid);
                //end push notifications//
                Session::flash('flash_notice', 'address Id Update successfully!');
                Session::flash('alert-class', 'alert-success');
                //return Redirect::back();
                return Redirect::route($this->model . '.view_address_details', base64_encode(serialize($id)));
            } //Validation
        } //EndCkeck Empty Val
        //Show Page
        return view("admin.$this->model.editaddressdetails", compact('editaddressdetails'));
    }
} //End Class
