<?php

namespace App\Http\Controllers\Admin;

use App\Model\Series;
use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
//use App\Http\Controllers\Admin\SeriesController;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class SeriesController extends BaseController
{

    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'Series';

    public function __construct()
    {
        View::share('modelName', $this->model);
    }


    public function viewseries(Request $req)
    {
        if ($req->isMethod('post')) {
            $formData = Input::all();

            if (isset($formData) && !empty($formData)) {
                return Datatables::of($query = DB::table('series as s')
                    ->select('*')
                    ->where(function ($query) use ($formData) {
                        if (isset($formData['filter_columns'])) {
                            if (isset($formData['filter_columns']['filter_series_name'])) {
                                $query->where('s.name', 'like', '%' . $formData['filter_columns']['filter_series_name'] . '%');
                            }
                            if (isset($formData['filter_columns']['filter_series_status'])) {
                                $query->where('s.series_status', '=', $formData['filter_columns']['filter_series_status']);
                            }
                        }
                    })
                    ->get())
                    ->addIndexColumn()
                    ->addColumn('is_series_slide', function ($result) {
                        $status = 'No';
                        if ($result->is_series_slide == 1) {
                            $status = 'Yes';
                        }
                        return $status;
                    })
                    ->addColumn('is_investment_slide', function ($result) {
                        $status = 'No';
                        if ($result->is_investment == 1) {
                            $status = 'Yes';
                        }
                        return $status;
                    })
                    ->addColumn('is_leaderboard', function ($result) {
                        $status = 'No';
                        if ($result->is_leaderboard == 1) {
                            $status = 'Yes';
                        }
                        return $status;
                    })
                    ->addColumn('matches', function ($result) {
                        $findmatches = DB::table('listmatches')->where('series', $result->id)->count();
                        return $findmatches;
                    })
                    ->addColumn('action', function ($result) {
                        $series_status = '';
                        if ($result->series_status == 'opened') {
                            $series_status = '<a href="' . route($this->model . '.updateseries', [base64_encode(serialize($result->id)), "closed"]) . '" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Close"><i class="fa fa-lock" aria-hidden="true" data-original-title="Delete" ></i></a>';
                        } else {
                            $series_status = '<a href="' . route($this->model . '.updateseries', [base64_encode(serialize($result->id)), "opened"]) . '" class="btn btn-rg icon mr-1 mt-1" data-toggle="tooltip" title="Open"><i class="fa fa-unlock" aria-hidden="true" data-original-title="Check" ></i></a>';
                        }
                        return '<a href="' . route($this->model . '.update', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg icon mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                            . $series_status;
                    })

                    ->escapeColumns([])
                    ->make(true);
            } //end
        }

        return  View::make("admin.$this->model.viewseries");
    }


    //Add Series
    public function addseries(Request $request)
    {
        $formData    =    Input::all();
        if (!empty($formData)) {
            $validate    =    array(
                'name'                =>    'required|unique:series|min:3',
                'sport_type'    => 'required',

            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $input = Input::all();
                // $input = $request->input();
                // print_r($input);die;
                unset($input['_token']);

                if ($formData['start_date'] < $formData['end_date']) {
                    $input['start_date'] = date('Y-m-d h:i:s', strtotime($input['start_date']));
                    $input['end_date'] = date('Y-m-d h:i:s', strtotime($input['end_date']));
                    $input['series_status'] = 'opened';
                } else {
                    // dd('dsfasd');
                    return back()->with('successs', 'end date value less than start date value');
                    // return Redirect::back()->withErrors(['Maximum value less than minimum value']);
                }
                DB::table('series')->insert($input);
                Session::flash('flash_notice',  trans("Successfully added series!"));
                Helpers::logActivity('Successfully added series!', $input['name']);
                return Redirect::route($this->model . '.view_all');
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

        return view('admin.Series.addseries', compact('sport_types'));
    }


    public function editseries($id, Request $request)
    {

        $id = unserialize(base64_decode($id));
        $series = DB::table('series')->where('id', $id)->first();

        $formData    =    Input::all();
        if (!empty($formData)) {
            $validate    =    array(
                'name'                =>    "required|unique:series,name,$id",
                'sport_type'    => 'required',
            );

            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                $catname = $formData['name'];
                $findseries = DB::table('series')->where('name', $catname)->where('id', '!=', $id)->first();
                if (!empty($findseries)) {
                    return Redirect::back()
                        ->withErrors('This series is already exist.')
                        ->withInput(Input::except('password'));
                }
                if (!isset($formData['is_leaderboard'])) {
                    $formData['is_leaderboard'] = 0;
                }

                if (!isset($formData['is_investment'])) {
                    $formData['is_investment'] = 0;
                }

                if (!isset($formData['is_promoter_series_leaderboard']) && empty($formData['is_promoter_series_leaderboard'])) {
                    $formData['is_promoter_series_leaderboard'] = 0;
                }

                if (!empty($formData['is_series_slide'])) {
                    $getenable = DB::table('series')->where('is_series_slide', 1)->pluck('id');
                    DB::table('series')->whereIn('id', $getenable)->update(['is_series_slide' => 0]);
                }
                if (!isset($formData['is_series_slide'])) {
                    $formData['is_series_slide'] = 0;
                }
                unset($formData['_token']);
                $formData['start_date'] = date('Y-m-d h:i:s', strtotime($formData['start_date']));
                $formData['end_date'] = date('Y-m-d h:i:s', strtotime($formData['end_date']));
                //$formData['series_status']= isset($formData['series_status'])?$formData['series_status']:'';
                $checkseries = DB::table('investment_leaderboard_name')->where('series_id', $id)->first();
                if (empty($checkseries) && !empty($formData['is_investment'])) {
                    DB::table('investment_leaderboard_name')->insert(['series_id' => $id]);
                } else {

                    if (empty($formData['is_investment'])) {
                        DB::table('investment_leaderboard_name')->where('series_id', $id)->delete();
                    }
                }


                $start_d = $formData['start_date'];
                $end_d = $formData['end_date'];

                $data['start_date'] = $start_d;
                $data['end_date'] = $end_d;
                $data['name'] = $catname;
                $data['series_id'] = $id;

                if ($formData['is_promoter_series_leaderboard'] == 1) {
                    $promoter_check = DB::table('promoter_leaderboard_series')->select('id')->where('name', $catname)->first();
                    if (isset($promoter_check)) {
                        DB::table('promoter_leaderboard_series')->where('name', $catname)->update($data);
                    } else {
                        DB::table('promoter_leaderboard_series')->insert($data);
                    }
                }

                $rowCOllection = DB::table('series')->where('id', $id)->update($formData);
                Session::flash('flash_notice',  trans("Successfully updated series!"));
                Helpers::logActivity('Successfully updated series!', $formData['name']);
                return Redirect::route($this->model . '.view_all');
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('status', 1)->get();

        return view("admin.$this->model.editseries", compact('series', 'sport_types'));
    }

    public function updateseriesstatus($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $series = DB::table('series')->where('id', $id)->first();
        if (!empty($series)) {
            $data['series_status'] = $status;
            //print_r($data['series_status']);die;
            DB::table('series')->where('id', $id)->update($data);
            Session::flash('flash_notice', 'Successfully updated series status!');
            Helpers::logActivity('Successfully updated series status!', $series->name);
            //Session::flash('alert-class', 'alert-success');
        }
        return Redirect::back();
    }


    public function deleteseries($id)
    {
        $id = unserialize(base64_decode($id));
        $series = DB::table('series')->where('id', $id)->first();
        if (!empty($series)) {
            $findmatchexist = DB::table('listmatches')->where('series', $series->id)->get();
            if (!empty($findmatchexist)) {
                return Redirect::back()
                    ->withErrors('You cannot delete this series as match is added into this series');
            } else {
                DB::table('series')->where('id', $id)->delete();
                Session::flash('flash_notice', 'Successfully deleted series!');
                Helpers::logActivity('Successfully deleted series!', $series->name);
                //Session::flash('alert-class', 'alert-success');
                return redirect()->action('SeriesController@viewseries');
            }
        } else {
            Session::flash('flash_notice', 'Invalid Id Provided');
            //Session::flash('alert-class', 'alert-success');
            return Redirect::back();
        }
    }

    public function manualbot_joinuser_new($matchkey = 'c.match.dumw_vs_jjw.07edf')
    {

        $dataArr = array();
        $forv_date = date('Y-m-d', strtotime('-10 days'));
        $matchkeys = DB::table('listmatches')->whereDate('start_date', '>=', $forv_date)
            ->where('final_status', 'winnerdeclared')->pluck('matchkey');
        $userid = array();
        $userid = DB::table('joinedleauges')->whereIn('matchkey', $matchkeys)->pluck('userid');
        // var_dump($matchkeys);exit;
        $dataArr = DB::table('jointeam')
            ->select('userid', DB::raw("MAX(points) as points"))
            ->whereIn('userid', $userid)
            ->whereIn('matchkey', $matchkeys)
            ->groupBy('jointeam.matchkey', 'jointeam.userid')->orderBy('points', 'desc')->limit(10)->pluck('userid');

        $joinleagues = DB::table('joinedleauges')->where('matchkey', 'c.match.cli_vs_pakc.52032')->whereIn('userid', $dataArr)->get();
        var_dump($joinleagues);
        exit;
    }
}
