<?php
namespace App\Http\Controllers\Admin;

use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Models\Setting;
use App\libraries\CustomHelper;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class SettingController extends BaseController {
	//Setting Model
	public $model	=	'Setting';
	//Model Name Define
	public function __construct() {
		View::share('modelName',$this->model);
	}
	//View Players
    public function view(){
    	$formData = Input::all();
    	if(isset($formData) && !empty($formData)){
			return Datatables::of(DB::table('setting')->get())
	           ->addIndexColumn()
	           ->addColumn('action', function ($result) {
	                return '<a href="'.route($this->model.'.edit',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn btn-dark mr-2" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>'
	                .'<a href="'.route($this->model.'.delete',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn btn-danger action-setting" data-original-title="Delete"><i class="fa fa-trash mr-2" aria-hidden="true"></i>Delete</a>'
	                	;
	            })
	            ->escapeColumns([])
	            ->make(true);
	        }//end
        return view("admin.$this->model.view");
    }//End Function

    /**
	 * function add new settings view page
	 */
	public function add(Request  $request){


		if($request->isMethod('post')){
			$input = Input::all();
			//print_r($post);die;
	        $message  = array(
	            'setting_key.required' => 'Please enter Setting Key.',
	            'value.required'       => 'Please enter value.',
	        );
	        $validate = array(
	        	'setting_key' =>	'required|unique:setting,setting_key,NULL,id',
					//	'value'   	  =>	"required|unique:setting,value,NULL,id",
						'value'   	  =>	"required",
	        );

	        $validator = Validator::make(Input::all(),$validate,$message);
	       // print_r($validator);exit;
	        if ($validator->fails()){
	        	return Redirect::back()->withErrors($validator)->withInput();
	        	//Validation Comp.
	        }else{
	        	$input = Input::all();
	        	$setting['setting_key'] = $input['setting_key'];
				$setting['value'] = $input['value'];
				//Insert Data
	        	DB::table('setting')->insert($setting);
	        	//Send Message
				Session::flash('flash_notice', 'Settind Added Sucessfully!');
				return Redirect::route($this->model.'.view');
	        }
		}else{
			return  View::make("admin.$this->model.add");
		}
	}//end addSetting()

	/**
	 * function edit settings view page
	 */
	public function edit($id){
		$id = unserialize(base64_decode($id));
		$setting			 = 	Setting::findorFail($id);

		$formData	=	Input::all();
		 if(!empty($formData)){
			$validate	=	array(
			//'setting_key' =>	"required|setting_key|unique:setting,setting_key,$id",
			'setting_key' =>	"required",
			//'value'   	  =>	"required|value|unique:setting,value,$id",
			'value'   	  =>	"required",
			);

			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
				return Redirect::back()->withErrors($validator)->withInput();
			}else{

		 	unset($formData['_token']);
			$setting_data['setting_key'] = $formData['setting_key'];
			$setting_data['value'] = $formData['value'];
			DB::table('setting')->where('id',$id)->update($setting_data);
            Session::flash('flash_notice',  trans("Setting Successfully updated!"));
			return Redirect::route("$this->model.view");
			}
		}
		return  View::make("admin.$this->model.edit",compact('setting'));
	}//end editSetting()

	/**
	 * function for delete setting
	 */
	public function delete($id=null){
		### Breadcrumb End ###
		$id = unserialize(base64_decode($id));
		$obj	=  Setting::find($id);
		$obj->delete();
		Session::flash('flash_notice',  trans("Setting deleted!"));
		return Redirect::route("$this->model.view");
	}//End Function

	/**
	 * prefix function
	 */
	public function prefix($prefix = null) {
		$result = Setting::where('key_value', 'like', $prefix.'%')->where('editable', 1)->orderBy('weight', 'ASC')->get()->toArray();
		return  View::make("admin.$this->model.prefix",compact('result','prefix'));
	}// end prefix

	/**
	 * update prefix function
	 */

	public function updatePrefix($prefix = null){
		$allData	=	Input::all();
		$imageValue	=	Setting::where('key_value','Site.banner')->pluck('value');
		//Not Empty
		if(!empty($allData)){
			if(!empty($allData['Setting'])){
				foreach($allData['Setting'] as $key => $value){
					if(!empty($value['id']) && !empty($value['key_value'])){
						if($value['type'] == 'checkbox'){
							$val	=	(isset($value['value'])) ? 1 : 0;
						}else{
							$val	=	(isset($value['value'])) ? $value['value'] : '';
						}
						if($value['type'] == 'select'){
							Setting::where('id', $value['id'])->update(array(
								'key_value'   	 		=>  $value['key_value'],
								'default_type' 			=>  $val
							));
						}else{
							Setting::where('id', $value['id'])->update(array(
								'key_value'   	 	=>  $value['key_value'],
								'value' 			=>  $val
							));
						}
						if($value['key_value']=='Site.application_link'){
							$val	=	(isset($value['value'])) ? $value['value'] : '';
							if(!empty($val)){
								$extension 		=	 $val->getClientOriginalExtension();
								$fileName			=	 time().rand()."-$this->model-image.".$extension;
								if($val->move("public/images/settings/", $fileName)){
									Setting::where('id', $value['id'])->update(array(
										'key_value'   	 	=>  $value['key_value'],
										'value' 			=>  $fileName,
									));
								}
							}else{
								Setting::where('id', $value['id'])->update(array(
									'key_value'   	 	=>  $value['key_value'],
									'value' 			=>  $imageValue,
								));
							}
						}
					}
				}
			}
		}
		$this->settingFileWrite();
		Session::flash('flash_notice',  trans($this->model.'Update Profile'));
		return Redirect::route("$this->model.prefix_index",array($prefix));
	}//updatePrefix()

	/**
	 * function for write file on update and create
	 *
	 *@param $Id as Id
	 *
	 *@return void
	 */

	public function settingFileWrite() {
		$DB		=	Setting::query();
		$list	=	$DB->orderBy('key_value','ASC')->get(array('key_value','value','default_type','input_type'))->toArray();
        $file = SETTING_FILE_PATH;
		$settingfile = '<?php ' . "\n";
		foreach($list as $value){
			$val		  =	 str_replace('"',"'",$value['value']);
			if($value['input_type']=='select'){
			 $val		  =	 trim($value['default_type']);
			}
			if($value['key_value']=='Reading.records_per_page' || $value['key_value']=='Site.debug'){
				$settingfile .=  '$app->make('.'"config"'.')->set("'.$value['key_value'].'", '.$val.');' . "\n";
			}else{
				$settingfile .=  '$app->make('.'"config"'.')->set("'.$value['key_value'].'", "'.$val.'");' . "\n";
			}
		}
		$bytes_written = File::put($file, $settingfile);
		if ($bytes_written === false)
		{
			die("Error writing to file");
		}
	}//end settingFileWrite()


public function sportview()
{
    	$formData = Input::all();
    	if(isset($formData) && !empty($formData)){
			return Datatables::of(DB::table('sport_types')->get())
	           ->addIndexColumn()
	           ->addColumn('action', function ($result) {
	                return '<a href="'.route($this->model.'.sporttypeedit',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="" class="btn btn-dark mr-2" data-original-title="Edit"><i class="fa fa-pencil mr-2" aria-hidden="true"></i>Edit</a>'
	                	;
	            })
	            ->escapeColumns([])
	            ->make(true);
	        }//end

        return view("admin.$this->model.sport_type_view");
}

public function sportTypeEdit($id) {

		$id = unserialize(base64_decode($id));
		### breadcrumbs End ###
		$sports			 = DB::table('sport_types')->where('id',$id)->first();
		//print_r($player);die;
		$formData	=	Input::all();
		 if(!empty($formData)){
			$validate	=	array(
		//	'sport_name' =>	"required|sport_name|unique:setting,setting_key,$id",
			'status'   	  =>	"required|numeric",
			);
			$validator = Validator::make(Input::all(),$validate);
			if ($validator->fails()){
            Session::flash('flash_notice',  trans("Invalide status value only numeric value like 0 or 1"));
				return Redirect::back()->withErrors($validator)->withInput();
			}else{
		 	unset($formData['_token']);
			$setting_data['status'] = $formData['status'];
			DB::table('sport_types')->where('id',$id)->update($setting_data);
            Session::flash('flash_notice',  trans("Sports Successfully updated!"));
			return Redirect::route("$this->model.sport");
			}
		}
		return  View::make("admin.$this->model.sports_edit",compact('sports'));
}

	public function states()
	{
					$states=DB::table('states')->orderBy('status', 'ASC')->orderBy('name', 'ASC')->get()->toArray();
	        return view("admin.$this->model.states",compact('states'));
	}
	public function update_state(Request  $request){
		if($request->isMethod('post')){
					$input = Input::all();
					$id= $input['id'];
					$setting_data=array();
					$setting_data['status'] = $input['status'];
					DB::table('states')->where('id',$id)->update($setting_data);
				}
			}
}//end SettingsController class
