<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class Sub_adminController extends Controller
{
    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model = 'Sub_admin';

    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function

    public function view()
    {
        //Get Ajax Data
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(DB::table('users')
                ->where('user_type', 1)
                ->orderBy('id', 'DESC')
                ->get())
                ->addIndexColumn()
                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->activation_status) != 'activated') {
                        $activation_status = '<a href="' . route($this->model . '.update_subadmin_status', [base64_encode(serialize($result->id)), 'activated']) . '" class="btn btn-success mr-1 mt-1 action-userss">Activate</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_subadmin_status', [base64_encode(serialize($result->id)), 'deactivated']) . '" class="btn btn-warning mr-1 mt-1 action-users">Deactivate</a></br>';
                    }

                    $deleteAction = '<a href="' . route($this->model . '.delete_subadmin', [base64_encode(serialize($result->id))]) . '" class="btn btn-danger mr-1 mt-1 deleteaction-users"> Delete </a></br>';
                    return '<a href="' . route($this->model . '.edit', base64_encode(serialize($result->id))) . '" class="btn btn-dark mr-1 mt-1"><i class="fa fa-pencil mr-2" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i>Edit</a>' . $activation_status . $deleteAction;
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.view");
    } //End Function

    public function delete_subadmin($id = null)
    {
        $id = unserialize(base64_decode($id));
        DB::table('users')->where('id', $id)->delete();

        Session::flash('alert-class', 'alert-success');
        Session::flash('flash_notice', 'User deleted successfully!');
        return Redirect::back();
    } //end Function

    public function add()
    {

        $formData       = Input::all();
        // dd($formData);
        if (!empty($formData)) {
            $message  = array(
                'name.required'         => 'Please enter name.',
                'email.required'     => 'Please enter email id.',
                'mobile.required'     => 'Please enter phone no.',
                'password.required'     => 'Please enter password.'
            );
            $validate = array(
                /*
									'name'  => 'required',
									'email' => 'required|email|unique:users,email,NULL,id',
									'mobile' => 'required|numeric|min:10|unique:users,mobile,NULL,id',
									'password' => 'required'
							*/);
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['name'] = $formData['name'];
                $data['email'] = $formData['email'];
                $data['mobile'] = $formData['mobile'];
                $data['password'] = bcrypt($formData['password']);
                $data['user_type'] = 1;
                $id = DB::table('users')->insertGetId($data);
                $modelactionsArray = array();
                $subArray = array();
                $mactions = array();


                if (isset($formData['models_actions']) && !empty($formData['models_actions'])) {

                    foreach ($formData['models_actions'] as $modelactions) {
                        $subArray = explode(',', $modelactions);
                        unset($m_id);
                        unset($m_actions);
                        for ($i = 0; $i < count($subArray); $i++) {
                            if ($i == 1) {
                                $m_id = $subArray[$i];
                            }
                            if ($i == 0) {
                                $m_actions = $subArray[$i];
                            }
                        }
                        $modelactionsArray[$m_id][] = $m_actions;
                    }
                }
                $userwise_model_actions = array();

                foreach ($modelactionsArray as $key => $value) {
                    foreach ($value as $value2) {
                        $userwise_model_actions[] = array(
                            'sub_admin_id' => $id,
                            'model_id' => $key,
                            'model_actions_id' => $value2
                        );
                    }
                }

                if (!empty($userwise_model_actions) && $id > 0) {
                    foreach ($userwise_model_actions as $u_m_a) {
                        DB::table('sub_admin_models')->insert($u_m_a);
                    }
                }

                Session::flash('flash_notice',  trans("Sub Admin Add Successfully!"));
                return Redirect::route($this->model . '.view');
            }
            //First Time Page Lode
        } else {
            $sub_models = DB::table('models')->where('status',1)->orderBy('sort', 'asc')->get();
            return view("admin.$this->model.add", compact('sub_models'));
        }
    }





    public function add_old()
    {

        $formData       = Input::all();
        if (!empty($formData)) {
            $message  = array(
                'name.required'         => 'Please enter name.',
                'email.required'     => 'Please enter email id.',
                'mobile.required'     => 'Please enter phone no.',
                'password.required'     => 'Please enter password.'
            );
            $validate = array(
                'name'                      => 'required',
                'email'                => 'required|email|unique:users,email,NULL,id',
                'mobile'                => 'required|numeric|min:10|unique:users,mobile,NULL,id',
                'password'                => 'required'
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['name'] = $formData['name'];
                $data['email'] = $formData['email'];
                $data['mobile'] = $formData['mobile'];
                $data['password'] = bcrypt($formData['password']);
                $data['user_type'] = 1;
                //DB::table('users')->insert($data);
                $id = DB::table('users')->insertGetId($data);

                if (isset($formData['model_id']) && !empty($formData['model_id']) && $id > 0) {
                    foreach ($formData['model_id'] as $modelvalue) {
                        $data_model['model_id'] = $modelvalue;
                        $data_model['sub_admin_id'] = $id;
                        DB::table('sub_admin_models')->insert($data_model);
                    }
                }

                Session::flash('flash_notice',  trans("Sub Admin Add Successfully!"));
                return Redirect::route($this->model . '.view');
            }
            //First Time Page Lode
        } else {
            $sub_models = DB::table('models')->orderBy('sort')->get();
            return view("admin.$this->model.add", compact('sub_models'));
        }
    } //end Function

    public function edit($id = null)
    {

        $id = unserialize(base64_decode($id));

        //Get Val
        $formData       = Input::all();
        //echo "<pre>"; print_r($formData); exit;
        if (!empty($formData)) {
            $message  = array(
                'name.required'         => 'Please enter name.',
                'email.required'     => 'Please enter email id.',
                'mobile.required'     => 'Please enter phone no.',
            );
            $validate = array(
                'name'      => 'required',
                'email'  => "required|email|unique:users,email,$id", //|unique:users,email,NULL,$id
                //'mobile'  => "required|integer|min:10|unique:users,mobile,$id",//|unique:users,mobile,NULL,$id
                'mobile'  => "required|integer|digits:10",
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['name'] = $formData['name'];
                $data['email'] = $formData['email'];
                $data['mobile'] = $formData['mobile'];
                if (isset($formData['password']) && !empty($formData['password'])) {
                    $data['password'] = bcrypt($formData['password']);
                }
                DB::table('users')->where('id', $id)->update($data);

                DB::table('sub_admin_models')->where('sub_admin_id', $id)->delete();


                $modelactionsArray = array();
                $subArray = array();
                $mactions = array();

                if (isset($formData['models_actions']) && !empty($formData['models_actions'])) {

                    foreach ($formData['models_actions'] as $modelactions) {
                        $subArray = explode(',', $modelactions);
                        unset($m_id);
                        unset($m_actions);
                        for ($i = 0; $i < count($subArray); $i++) {
                            if ($i == 1) {
                                $m_id = $subArray[$i];
                            }
                            if ($i == 0) {
                                $m_actions = $subArray[$i];
                            }
                        }
                        $modelactionsArray[$m_id][] = $m_actions;
                    }
                }
                $userwise_model_actions = array();
                foreach ($modelactionsArray as $key => $value) {
                    foreach ($value as $value2) {
                        $userwise_model_actions[] = array(
                            'sub_admin_id' => $id,
                            'model_id' => $key,
                            'model_actions_id' => $value2
                        );
                    }
                }

                if (!empty($userwise_model_actions) && $id > 0) {
                    foreach ($userwise_model_actions as $u_m_a) {
                        DB::table('sub_admin_models')->insert($u_m_a);
                    }
                }

                Session::flash('flash_notice',  trans("Sub Admin Update Successfully!"));
                return Redirect::route($this->model . '.view');
            }
            //First Time Page Lode
        } else {
            //Get Model

            $subadmin = DB::table('users')->where('id', $id)->first();
            //echo "<pre>"; print_r($subadmin); exit;
            $sub_model = DB::table('models')->where('status',1)->orderBy('sort')->get();
            $selected_model_action = DB::table('sub_admin_models')
                ->where('sub_admin_id', $id)->groupBy('model_id')->select('model_id')->get();
            $selected_model = DB::table('sub_admin_models')
                ->where('sub_admin_id', $id)->get();
            // echo "<pre>"; print_r($selected_model); exit;
            return view("admin.$this->model.edit", compact('subadmin', 'sub_model', 'selected_model', 'selected_model_action'));
        }
    }


    //Edit
    public function edit_old($id = null)
    {

        $id = unserialize(base64_decode($id));
        //Get Val
        $formData       = Input::all();
        if (!empty($formData)) {
            $message  = array(
                'name.required'         => 'Please enter name.',
                'email.required'     => 'Please enter email id.',
                'mobile.required'     => 'Please enter phone no.',
            );
            $validate = array(
                'name'      => 'required',
                'email'  => "required|email|unique:users,email,$id", //|unique:users,email,NULL,$id
                'mobile'  => "required|integer|min:10|unique:users,mobile,$id", //|unique:users,mobile,NULL,$id
            );
            $validator = Validator::make(Input::all(), $validate, $message);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
                //Validation Comp.
            } else {
                //Insert Data
                $data['name'] = $formData['name'];
                $data['email'] = $formData['email'];
                $data['mobile'] = $formData['mobile'];
                if (isset($formData['password']) && !empty($formData['password'])) {
                    $data['password'] = bcrypt($formData['password']);
                }
                DB::table('users')->where('id', $id)->update($data);

                DB::table('sub_admin_models')->where('sub_admin_id', $id)->delete();

                if (isset($formData['model_id']) && !empty($formData['model_id'])) {
                    foreach ($formData['model_id'] as $modelvalue) {
                        $data_model['model_id'] = $modelvalue;
                        $data_model['sub_admin_id'] = $id;
                        DB::table('sub_admin_models')->insert($data_model);
                    }
                }

                Session::flash('flash_notice',  trans("Sub Admin Update Successfully!"));
                return Redirect::route($this->model . '.view');
            }
            //First Time Page Lode
        } else {
            //Get Model
            $subadmin = DB::table('users')->where('id', $id)->first();
            $sub_model = DB::table('models')->get();
            $selected_model = DB::table('sub_admin_models')
                ->where('sub_admin_id', $id)->get();
            return view("admin.$this->model.edit", compact('subadmin', 'sub_model', 'selected_model'));
        }
    } //end Function

    //update user status
    public function updatesubadminstatus($id, $status)
    {
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['activation_status'] = $status;
        DB::table('users')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'User ' . $status . ' successfully!');
        return Redirect::back();
    } //End Function

    public function get_model_action(Request $request)
    {
        if ($request->isMethod('post')) {

            $formData = Input::all();
            $model_actions = DB::table('model_actions')->where('model_id', $formData['model_id'])->get();
            $model_name = DB::table('models')->where('id', $formData['model_id'])->first();

            if (!$model_actions->isEmpty()) {

                $models_html = '<div class="form-row checkbox-' . $formData["model_id"] . '">
<ul class="list-group form-group"><div>
' . ucwords($model_name->model_name) . '
</div>';

                foreach ($model_actions as  $value) {
                    $models_html .= '
<li class="list-group-item">
<div class="form-group">
<label class="ml-3">' . ucwords($value->action) . '</label>
<input type="checkbox" name="models_actions[]" multiple="multiple" class="ml-3" value="' . $value->id . ',' . $model_name->id . '">
</div>
</li>';
                }
                $models_html .= '</div>';
            } else {
                $models_html = '';
            }

            return     $models_html;
        }
    }
} //End Class
