<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class Sub_admin_modelController extends Controller {

	/*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
	public $model ='Sub_admin_model';

	public function __construct() {
		View::share('modelName',$this->model);
	}//End Function

	//View Sub Admin
	public function view(){
		//Get Ajax Data
		$formData = Input::all();
    	if(isset($formData) && !empty($formData)){
			return Datatables::of(DB::table('sub_admin_models as sam')
				->leftJoin('users as u','u.id','=','sam.sub_admin_id')
				->leftJoin('models as m','m.id','=','sam.model_id')
				->where(['u.user_type'=>'1','u.activation_status' => 'activated'])
				->select('sam.id','u.id as sub_admin_id','u.name','m.id as model_id','m.model_name')
				->groupBy('m.id')
				->orderBy('id', 'DESC')
				->get())
	           	->addIndexColumn()
	           ->addColumn('action', function ($result) {
	           		$delete_modal='';
	           		$delete_modal='<a href="'.route($this->model.'.delete_sub_admin_model',base64_encode(serialize($result->id))).'" class="btn btn-danger mr-1 mt-1 action-users">Delete</a></br>';

	           		return '<a href="'.route('Sub_admin.edit',base64_encode(serialize($result->sub_admin_id))).'" class="btn btn-danger mr-1 mt-1"><i class="fa fa-pencil mr-2" aria-hidden="true" data-toggle="tooltip" title="" data-original-title="Edit" ></i>Edit</a>'.$delete_modal;
	            })
	            ->escapeColumns([])
	            ->make(true);
	        }//end

		return view("admin.$this->model.all_sub_admin");
    }//End Function

    public function add(){
    	$formData = Input::all();
		//Insert Data
		if(!empty($formData)){
			$message	=	array(
				'model_id.required'      => 'Please select model name.',
	            'sub_admin_id.required'  => 'Please select Sub Admin name.',
			);
			$validate	=	array(
				'model_id'                => 'required',
	            'sub_admin_id'                => 'required',
			);
			$validator = Validator::make(Input::all(),$validate,$message);
			if ($validator->fails()){
				 return Redirect::back()->withErrors($validator)->withInput();
			}else{
				//Insert
				foreach ($formData['model_id'] as $modelvalue) {
	        		 $data['model_id'] =$modelvalue;
	        		 $data['sub_admin_id'] =$formData['sub_admin_id'];
	             	 DB::table('sub_admin_models')->insert($data);
	        	}
				Session::flash('flash_notice',  trans("Sub Admin Model Add Successfully!"));
				return Redirect::route($this->model.'.view');
			}
	      //First Time Page Lode
	    }else{
	    	$model= DB::table('models')->get();
	        $sub_admin= DB::table('users')->where('users.user_type',1)->get();
	        return view("admin.$this->model.add",compact('model','sub_admin'));
	    }
    }//end Function

    //Edit
    public function edit($id=null){

		//Get Id
		$id = unserialize(base64_decode($id));
    	//Get Val
    	$formData       = Input::all();
	    if(!empty($formData)){
	        $message  = array(
	            'model_id.required'      => 'Please enter model name.',
	            'sub_admin_id.required'  => 'Please enter model name.',
	        );
	        $validate = array(
	            'model_id'      => 'required',
	            'sub_admin_id'  => 'required',
	        );
	        $validator = Validator::make(Input::all(),$validate,$message);
	        if ($validator->fails()){
	        return Redirect::back()->withErrors($validator)->withInput();
	        //Validation Comp.
	        }else{
	        	//Delete
	        	DB::table('sub_admin_models')->where('sub_admin_id',$formData['sub_admin_id'])->delete();
	        	//Insert Data
	             foreach ($formData['model_id'] as $modelvalue) {
	        		 $data['model_id'] =$modelvalue;
	        		 $data['sub_admin_id'] =$formData['sub_admin_id'];
	             	 DB::table('sub_admin_models')->insert($data);
	        	}
	        	Session::flash('flash_notice',  trans("Sub Admin Model Update Successfully!"));
				return Redirect::route($this->model.'.view');
	        }
	      //First Time Page Lode
	    }else{
	    	//Get Model
	        $sub_admin= DB::table('users')->where('users.user_type',1)->get();
	        $model=DB::table('models')->get();
	        $select_model= DB::table('sub_admin_models')
	                ->where('id',$id )
	                ->first();
	        //Edit Page
	        return view("admin.$this->model.edit",compact('model','sub_admin','select_model'));
	    }
    }//end Function

    //delete sub admin model
	public function deletesubadminmodel($id){
		$id = unserialize(base64_decode($id));
		DB::table('sub_admin_models')->where('id',$id)->delete();
		Session::flash('flash_notice', 'Sub admin deleted successfully');
		return Redirect::back();
	}//End Function


}//End Class
?>
