<?php

namespace App\Http\Controllers\Admin;

use App\Model\AdminUser;
use App\Http\Controllers\BaseController;
use App\Model\ThirdParty;
use App\Helpers\Helpers;
use Illuminate\Http\Request;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;

class ThirdPartyController extends BaseController
{
    /*
	 * Function for display email detail from database
	 *
	 * @param null
	 *
	 * @return view page.
	 */
    public $model    =    'ThirdParty';

    //First time Lode Function
    public function __construct()
    {
        View::share('modelName', $this->model);
    } //End Function


    //View Players
    public function paymentview()
    {

        // $findallteams= Db::table('teams')->select('id','team')->get();
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(
                DB::table('thirdparty_config_new')->where('transaction_type', '=', 1)
                    ->select('thirdparty_config_new.*')
                    ->get()
            )
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return $result->id;
                })
                ->editColumn('url', function ($result) {
                    return $result->url;
                })
                // ->addColumn('notify_url',function ($result){
                // 		return $result->notify_url;
                // })
                // ->addColumn('return_url',function ($result){
                // 		return $result->return_url;
                // })
                ->addColumn('merchant_id', function ($result) {
                    if (!empty($result->merchant_id)) {
                        return $result->merchant_id;
                    } else {
                        return "N/A";
                    }
                })
                ->addColumn('merchant_key', function ($result) {
                    if (!empty($result->merchant_key)) {
                        return $result->merchant_key;
                    } else {
                        return "N/A";
                    }
                })
                ->addColumn('app_id', function ($result) {
                    if (!empty($result->app_id)) {
                        return $result->app_id;
                    } else {
                        return "N/A";
                    }
                })
                ->addColumn('secret_key', function ($result) {
                    // return $result->secret_key;
                    if (!empty($result->secret_key)) {
                        return $result->secret_key;
                    } else {
                        return "N/A";
                    }
                })
                ->addColumn('merchant_salt', function ($result) {
                    // return $result->merchant_salt;
                    if (!empty($result->merchant_salt)) {
                        return $result->merchant_salt;
                    } else {
                        return "N/A";
                    }
                })
                // ->addColumn('mercent_username',function ($result){
                // 	return $result->mercent_username;
                // })

                ->addColumn('amount_max_limit', function ($result) {
                    return $result->amount_max_limit;
                })
                ->addColumn('amount_min_limit', function ($result) {
                    return $result->amount_min_limit;
                })

                ->addColumn('day_per_transaction', function ($result) {
                    return $result->day_per_transaction;
                })
                ->addColumn('gateway_charges', function ($result) {
                    return $result->gateway_charges;
                })
                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })

                // ->addColumn('status',function ($result){
                //        return $result->status;
                // })

                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.paymentstatus', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.paymentstatus', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }


                    // $bowler=$result->role;
                    return
                        '<a href="' . route($this->model . '.editpayment', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.deletepayment', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;

                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.viewpayment");
    } //End Function

    //add player
    public function add_payment(Request $request)
    {
        // dd($request->secret_key);
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $gatwaymaster = DB::table('gateway_master')->get();



        $formData    =    Input::all();
        if (!empty($formData)) {
            // unique:thirdparty_config_new,name

            $validate    =    array(
                'name'     =>    'required',
                'url'     =>    'required',
                // 'notify_url'	=>	'required',
                // 'return_url' => 'required',
                // 'merchant_id' => 'required',
                // 'merchant_key' => 'required',
                // 'mercent_username' => 'required',
                'amount_max_limit' => 'required',
                'amount_min_limit' => 'required',
                'day_per_transaction' => 'required',
                // 'gateway_charges' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                // $bonusname = str_replace(' ', '_', strtoupper($formData['type']));
                //       $bonusData['type'] = $bonusname;


                // $input['url'] = trim($input['url']);

                $bonusData['url'] = str_replace(' ', '', $formData['url']);
                // $bonusData['notify_url'] = str_replace(' ','',$formData['notify_url']);
                // $bonusData['return_url'] = str_replace(' ','',$formData['return_url']);
                $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);


                if (!empty($formData['merchant_id'])) {
                    $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);
                } else if (!empty($formData['merchant_idtwo'])) {
                    $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_idtwo']);
                } else {
                    $bonusData['merchant_id'] = "";
                }

                if (!empty($formData['merchant_key'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_key']);
                } else if (!empty($formData['merchant_keytwo'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_keytwo']);
                } else if (!empty($formData['merchant_keythree'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_keythree']);
                } else {
                    $bonusData['merchant_key'] = "";
                }



                $bonusData['app_id'] = str_replace(' ', '', $formData['app_id']);






                $bonusData['merchant_salt'] = str_replace(' ', '', $formData['merchant_salt']);

                //

                // $bonusData['mercent_username'] = str_replace(' ','',$formData['mercent_username']);
                $bonusData['amount_max_limit'] = str_replace(' ', '', $formData['amount_max_limit']);
                $bonusData['amount_min_limit'] = str_replace(' ', '', $formData['amount_min_limit']);
                $bonusData['day_per_transaction'] = str_replace(' ', '', $formData['day_per_transaction']);
                // $bonusData['gateway_charges'] = str_replace(' ','',$formData['gateway_charges']);
                $bonusData['status'] = str_replace(' ', '', $formData['status']);
                $bonusData['name'] = $formData['name'];



                // if(!empty($formData['name'])){
                //
                //
                //  if($formData['withdraw_type'] == 1){
                //
                // 	 $bonusData['name'] =$formData['name'].'_'.'BANK';
                //
                //
                //  }else if($formData['withdraw_type_instant'] == 2){
                // 	 // dd('d');
                // 		$bonusData['name'] =$formData['name'].'_'.'INSTANT';
                //
                //  }
                //
                //  else{
                // 	 // dd('f');
                // 	 $bonusData['name'] =$formData['name'];
                //
                //
                //  }
                //
                // }
                // dd($formData['withdraw_type']);

                if ($bonusData['name'] == "CASHFREE_PAYMENT_BANK" || $bonusData['name'] == "CASHFREE_PAYMENT_INSTANT" || $bonusData['name'] == "CASHFREE_PAYMENT") {
                    $bonusData['gateway_type'] = '4';
                } else if ($bonusData['name'] == "PAYTM_PAYMENT_BANK" || $bonusData['name'] == "PAYTM_PAYMENT_INSTANT" || $bonusData['name'] == "PAYTM_PAYMENT") {
                    $bonusData['gateway_type'] = '3';
                } else if (($bonusData['name'] == "RAZORPAY_PAYMENT_BANK" || $bonusData['name'] == "RAZORPAY_PAYMENT_INSTANT" || $bonusData['name'] == "RAZORPAY_PAYMENT")
                    || ($bonusData['name'] == "PAYUMONEY_PAYMENT_BANK" || $bonusData['name'] == "PAYUMONEY_PAYMENT_INSTANT" || $bonusData['name'] == "PAYUMONEY_PAYMENT")
                    || ($bonusData['name'] == "MPAISA_PAYMENT_BANK" || $bonusData['name'] == "MPAISA_PAYMENT_INSTANT" || $bonusData['name'] == "MPAISA_PAYMENT")
                ) {
                    $bonusData['gateway_type'] = '5';
                }



                $check = DB::table('thirdparty_config_new')->where('transaction_type', '=', 2)->where('name', '=', $bonusData['name'])->first();
                if ($check) {
                    return back()->with('success', 'Already Gateway Name exist');
                }



                $bonusData['transaction_type'] = '1';
                if (!empty($formData['secret_key'])) {
                    $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_key']);
                } else if (!empty($formData['secret_keytwo'])) {
                    $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_keytwo']);
                } else {
                    $bonusData['secret_key'] = "";
                }


                if (!empty($formData['withdraw_type'])) {
                    // dd($formData['withdraw_type']);
                    $bonusData['withdraw_type'] = $formData['withdraw_type'];
                } elseif (!empty($formData['withdraw_type_instant'])) {
                    $bonusData['withdraw_type'] = $formData['withdraw_type_instant'];
                } else {
                    // dd('ddd');
                    $bonusData['withdraw_type'] = 0;
                }
                // dd($bonusData);
                DB::table('thirdparty_config_new')->insert($bonusData);
                // dd('d');


                // Session::flash('flash_notice',  trans("Player Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.view");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_payment", compact('teams', 'sport_types', 'gatwaymaster'));
    } //End Function

    public function add_payment_old1(Request $request)
    {
        // dd('dd');
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $gatwaymaster = DB::table('gateway_master')->select('gateway_master.gateway_key', 'gateway_master.Name')->get();
        // dd($gateway_master);
        $formData    =    Input::all();
        // dd($formData);
        if (!empty($formData)) {

            $validate    =    array(
                'name' => 'required',
                'url'     =>    'required',
                // 'notify_url'	=>	'required',
                // 'return_url' => 'required',
                // 'merchant_id' => 'required',
                // 'merchant_key' => 'required',
                // 'mercent_username' => 'required',
                'amount_max_limit' => 'required',
                'amount_min_limit' => 'required',
                'day_per_transaction' => 'required',
                'gateway_charges' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                // $bonusname = str_replace(' ', '_', strtoupper($formData['type']));
                //       $bonusData['type'] = $bonusname;


                // $input['url'] = trim($input['url']);
                $bonusData['name'] = str_replace(' ', '', $formData['name']);
                $bonusData['url'] = str_replace(' ', '', $formData['url']);
                // $bonusData['notify_url'] = str_replace(' ','',$formData['notify_url']);
                // $bonusData['return_url'] = str_replace(' ','',$formData['return_url']);

                $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);
                $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_key']);
                $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_key']);
                $bonusData['app_id'] = str_replace(' ', '', $formData['app_id']);
                $bonusData['merchant_salt'] = str_replace(' ', '', $formData['merchant_salt']);
                // $bonusData['mercent_username'] = str_replace(' ','',$formData['mercent_username']);
                // $bonusData['mercent_username'] = str_replace(' ','',$formData['mercent_username']);

                $bonusData['amount_max_limit'] = str_replace(' ', '', $formData['amount_max_limit']);
                $bonusData['amount_min_limit'] = str_replace(' ', '', $formData['amount_min_limit']);
                $bonusData['day_per_transaction'] = str_replace(' ', '', $formData['day_per_transaction']);

                // $bonusData['gateway_charges'] = str_replace(' ','',$formData['gateway_charges']);
                $bonusData['status'] = str_replace(' ', '', $formData['status']);
                // if(!empty($bonusData['withdraw_type'])){
                // $bonusData['withdraw_type'] = $formData['withdraw_type'];
                // }else{
                // 		$bonusData['withdraw_type'] = '0';
                // }
                $bonusData['transaction_type'] = 1;

                if ($bonusData['name'] == 'PAYTM_PAYMENT') {
                    $bonusData['gateway_type'] = '3';
                } else if ($bonusData['name'] == 'CASHFREE_PAYMENT') {
                    $bonusData['gateway_type'] = '4';
                } else if ($bonusData['name'] == 'RAZORPAY_PAYOUT' || $bonusData['name'] == 'PAYUMONEY_PAYMENT' || $bonusData['name'] == 'MPAISA_PAYMENT') {
                    $bonusData['gateway_type'] = '5';
                }

                $check = DB::table('thirdparty_config_new')->where('transaction_type', '=', 1)->where('name', '=', $bonusData['name'])->first();
                if ($check) {
                    return redirect()->back()->with('message', "Gateway Name Already Exist");
                }
                dd($bonusData);
                DB::table('thirdparty_config_new')->insert($bonusData);
                // dd('d');


                Session::flash('flash_notice',  trans("Payment Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.view");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_payment", compact('teams', 'sport_types', 'gatwaymaster'));
    } //End Function


    public function deletepayment($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('thirdparty_config_new')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('thirdparty_config_new')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Payment!');
            Helpers::logActivity('Successfully Deleted Payment!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Payment id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }

    public function editpayment(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $gatwaymaster = DB::table('gateway_master')->select('gateway_master.gateway_key', 'gateway_master.Name')->get();
        $id = unserialize(base64_decode($id));
        $payment = ThirdParty::find($id);
        // dd($id);
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();


        return view("admin.$this->model.editpayment", compact('payment', 'sport_types', 'gatwaymaster'));
    }

    public function updatepayment(Request $request, $id)
    {




        // dd($request->all());
        $Payment = ThirdParty::find($id);
        // dd($Bonus);
        // $bonusname = str_replace(' ', '_', strtoupper($request->input('type')));
        $Payment->name = str_replace(' ', '', $request->input('name'));
        $Payment->app_id = str_replace(' ', '', $request->input('app_id'));
        $Payment->merchant_salt = str_replace(' ', '', $request->input('merchant_salt'));


        if (!empty($request->input('merchant_id')) && ($request->input('name') == "RAZORPAY_PAYMENT")) {
            // dd('ttt');
            $Payment->merchant_id = str_replace(' ', '', $request->input('merchant_id'));
        }
        if (!empty($request->input('merchant_idone')) && ($request->input('name') == "PAYTM_PAYMENT")) {
            // dd('s');

            $Payment->merchant_id = str_replace(' ', '', $request->input('merchant_idone'));
        }
        // dd($request->merchant_keyone);
        if (!empty($request->input('merchant_key'))) {
            // echo "ff";
            $Payment->merchant_key = str_replace(' ', '', $request->input('merchant_key'));
        }

        if (!empty($request->input('merchant_keyone')) && ($request->input('name') == "PAYTM_PAYMENT")) {
            $Payment->merchant_key = str_replace(' ', '', $request->input('merchant_keyone'));
        }

        if (!empty($request->input('merchant_keytwo')) && ($request->input('name') == "PAYUMONEY_PAYMENT")) {

            $Payment->merchant_key = str_replace(' ', '', $request->input('merchant_keytwo'));
        }
        // else{
        // 	$Payment->merchant_key = NULL;
        // }

        // dd($request->all());

        if (!empty($request->input('secret_key'))) {
            // RAZORPAY_PAYMENT
            $Payment->secret_key = str_replace(' ', '', $request->input('secret_key'));
            // dd($tets);
        }
        if (!empty($request->input('secret_keyone')) && ($request->input('name') == "CASHFREE_PAYMENT")) {
            $Payment->secret_key = str_replace(' ', '', $request->input('secret_keyone'));
        }
        $Payment->url = str_replace(' ', '', $request->input('url'));

        // 	if(!empty($request->input('merchant_id'))){
        // 	$Payment->merchant_id = str_replace(' ','',$request->input('merchant_id'));
        // }else if(!empty($request->input('merchant_idone'))){
        // 	$Payment->merchant_id = str_replace(' ','',$request->input('merchant_id'));
        // }else{
        // 	$Payment->merchant_id = NULL;
        //
        //
        // }
        //
        //    if(!empty($request->input('merchant_key'))){
        //       $Payment->merchant_key = str_replace(' ','',$request->input('merchant_key'));
        // 		}else if(!empty($request->input('merchant_keyone'))){
        // 			$Payment->merchant_key = str_replace(' ','',$request->input('merchant_key'));
        // 		}else if (!empty($request->input('merchant_keytwo'))){
        // 			$Payment->merchant_key = str_replace(' ','',$request->input('merchant_key'));
        // 		}else{
        // 			$Payment->merchant_key = NULL;
        //
        //
        // 		}
        //
        //
        // 		if(!empty($request->input('secret_key'))){
        // 		$Payment->secret_key = str_replace(' ','',$request->input('secret_key'));
        // 	}else if(!empty($request->input('secret_keyone'))){
        // 		$Payment->secret_key = str_replace(' ','',$request->input('secret_key'));
        //
        //
        // 	}
        // 	else{
        // 		$Payment->secret_key = NULL;
        //
        //
        // 	}


        $Payment->amount_max_limit = str_replace(' ', '', $request->input('amount_max_limit'));
        $Payment->amount_min_limit = str_replace(' ', '', $request->input('amount_min_limit'));
        $Payment->day_per_transaction = str_replace(' ', '', $request->input('day_per_transaction'));
        $Payment->gateway_charges = str_replace(' ', '', $request->input('gateway_charges'));
        $Payment->status = str_replace(' ', '', $request->input('status'));
        $Payment->withdraw_type = str_replace(' ', '', $request->input('withdraw_type'));
        if (empty($Payment['withdraw_type'])) {
            $Payment['withdraw_type'] = '0';
        }
        $Payment->update();
        Session::flash('flash_notice',  trans("Payment Successfully updated!"));
        // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
        return Redirect::route("$this->model.view");
    }

    public function updatesubadminstatus($id, $status)
    {
        // dd('d');
        $statuscheck = $status == 1 ? "active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('thirdparty_config_new')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'Api ' . $statuscheck . ' status update successfully!');
        return Redirect::back();
    } //End Function

    public function updateawsstatus($id, $status)
    {
        // dd('d');
        $statuscheck = $status == 1 ? "active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('aws_config')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'Aws ' . $statuscheck . ' status update successfully!');
        return Redirect::back();
    } //End Function















    public function payoutview()
    {

        // $findallteams= Db::table('teams')->select('id','team')->get();
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return Datatables::of(
                DB::table('thirdparty_config_new')->where('transaction_type', '=', 2)
                    ->select('thirdparty_config_new.*')
                    ->get()
            )
                ->addIndexColumn()
                ->addColumn('id', function ($result) {
                    return $result->id;
                })
                ->editColumn('url', function ($result) {
                    return $result->url;
                })
                // ->addColumn('notify_url',function ($result){
                // 	return $result->notify_url;
                // })
                // ->addColumn('return_url',function ($result){
                // 	return $result->return_url;
                // })

                ->addColumn('app_id', function ($result) {
                    if (!empty($result->app_id)) {
                        return $result->app_id;
                    } else {
                        return "N/A";
                    }
                })
                ->addColumn('secret_key', function ($result) {
                    if (!empty($result->secret_key)) {
                        return $result->secret_key;
                    } else {
                        return "N/A";
                    }
                    // return $result->secret_key;
                })
                ->addColumn('merchant_id', function ($result) {
                    // return $result->merchant_id;
                    if (!empty($result->merchant_id)) {
                        return $result->merchant_id;
                    } else {
                        return "N/A";
                    }
                })
                ->addColumn('merchant_key', function ($result) {
                    if (!empty($result->merchant_key)) {
                        return $result->merchant_key;
                    } else {
                        return "N/A";
                    }
                    // return $result->merchant_key;
                })
                ->addColumn('merchant_salt', function ($result) {
                    // return $result->merchant_salt;
                    if (!empty($result->merchant_salt)) {
                        return $result->merchant_salt;
                    } else {
                        return "N/A";
                    }
                })

                ->addColumn('amount_max_limit', function ($result) {
                    return $result->amount_max_limit;
                })
                ->addColumn('amount_min_limit', function ($result) {
                    return $result->amount_min_limit;
                })

                ->addColumn('day_per_transaction', function ($result) {
                    return $result->day_per_transaction;
                })
                ->addColumn('gateway_charges', function ($result) {
                    return $result->gateway_charges;
                })
                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                // ->addColumn('status',function ($result){
                // 			return $result->status;
                // })

                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.payoutstatus', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.payoutstatus', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }


                    // $bowler=$result->role;
                    return
                        '<a href="' . route($this->model . '.editpayout', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.deletepayout', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;

                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);
        } //end

        return view("admin.$this->model.viewpayout");
    } //End Function
    //add player
    public function add_payout(Request $request)
    {
        // dd($request->all());
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $gatwaymaster = DB::table('gateway_master')->where('gateway_key', '!=', 'PAYTM')->get();
        $formData    =    Input::all();
        // dd($forsmData);

        if (!empty($formData)) {
            // unique:thirdparty_config_new,name

            $validate    =    array(
                'name'     =>    'required',
                'url'     =>    'required',
                // 'notify_url'	=>	'required',
                // 'return_url' => 'required',
                // 'merchant_id' => 'required',
                // 'merchant_key' => 'required',
                // 'mercent_username' => 'required',
                'amount_max_limit' => 'required',
                'amount_min_limit' => 'required',
                'day_per_transaction' => 'required',
                'gateway_charges' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                // $bonusname = str_replace(' ', '_', strtoupper($formData['type']));
                //       $bonusData['type'] = $bonusname;


                // $input['url'] = trim($input['url']);

                $bonusData['url'] = str_replace(' ', '', $formData['url']);
                // $bonusData['notify_url'] = str_replace(' ','',$formData['notify_url']);
                // $bonusData['return_url'] = str_replace(' ','',$formData['return_url']);
                $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);


                if (!empty($formData['merchant_id'])) {
                    $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);
                } else if (!empty($formData['merchant_idtwo'])) {
                    $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_idtwo']);
                } else {
                    $bonusData['merchant_id'] = "";
                }

                if (!empty($formData['merchant_key'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_key']);
                } else if (!empty($formData['merchant_keytwo'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_keytwo']);
                } else if (!empty($formData['merchant_keythree'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_keythree']);
                } else {
                    $bonusData['merchant_key'] = "";
                }



                $bonusData['app_id'] = str_replace(' ', '', $formData['app_id']);






                $bonusData['merchant_salt'] = str_replace(' ', '', $formData['merchant_salt']);

                //

                // $bonusData['mercent_username'] = str_replace(' ','',$formData['mercent_username']);
                $bonusData['amount_max_limit'] = str_replace(' ', '', $formData['amount_max_limit']);
                $bonusData['amount_min_limit'] = str_replace(' ', '', $formData['amount_min_limit']);
                $bonusData['day_per_transaction'] = str_replace(' ', '', $formData['day_per_transaction']);
                $bonusData['gateway_charges'] = str_replace(' ', '', $formData['gateway_charges']);
                $bonusData['status'] = str_replace(' ', '', $formData['status']);



                if (!empty($formData['name'])) {


                    if ($formData['withdraw_type'] == 1) {

                        $bonusData['name'] = $formData['name'] . '_' . 'BANK';
                    } else if ($formData['withdraw_type_instant'] == 2) {
                        // dd('d');
                        $bonusData['name'] = $formData['name'] . '_' . 'INSTANT';
                    } else {
                        // dd('f');
                        $bonusData['name'] = $formData['name'];
                    }
                }
                // dd($formData['withdraw_type']);

                if ($bonusData['name'] == "CASHFREE_PAYOUT_BANK" || $bonusData['name'] == "CASHFREE_PAYOUT_INSTANT" || $bonusData['name'] == "CASHFREE_PAYOUT") {
                    $bonusData['gateway_type'] = '4';
                } else if ($bonusData['name'] == "PAYTM_PAYOUT_BANK" || $bonusData['name'] == "PAYTM_PAYOUT_INSTANT" || $bonusData['name'] == "PAYTM_PAYOUT") {
                    $bonusData['gateway_type'] = '3';
                } else if (($bonusData['name'] == "RAZORPAY_PAYOUT_BANK" || $bonusData['name'] == "RAZORPAY_PAYOUT_INSTANT" || $bonusData['name'] == "RAZORPAY_PAYOUT")
                    || ($bonusData['name'] == "PAYUMONEY_PAYOUT_BANK" || $bonusData['name'] == "PAYUMONEY_PAYOUT_INSTANT" || $bonusData['name'] == "PAYUMONEY_PAYOUT")
                    || ($bonusData['name'] == "MPAISA_PAYOUT_BANK" || $bonusData['name'] == "MPAISA_PAYOUT_INSTANT" || $bonusData['name'] == "MPAISA_PAYOUT")
                ) {
                    $bonusData['gateway_type'] = '5';
                }



                $check = DB::table('thirdparty_config_new')->where('transaction_type', '=', 2)->where('name', '=', $bonusData['name'])->first();
                if ($check) {
                    return back()->with('success', 'Already Gateway Name exist');
                }



                $bonusData['transaction_type'] = '2';
                if (!empty($formData['secret_key'])) {
                    $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_key']);
                } else if (!empty($formData['secret_keytwo'])) {
                    $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_keytwo']);
                } else {
                    $bonusData['secret_key'] = "";
                }


                if (!empty($formData['withdraw_type'])) {
                    // dd($formData['withdraw_type']);
                    $bonusData['withdraw_type'] = $formData['withdraw_type'];
                } elseif (!empty($formData['withdraw_type_instant'])) {
                    $bonusData['withdraw_type'] = $formData['withdraw_type_instant'];
                } else {
                    // dd('ddd');
                    $bonusData['withdraw_type'] = 0;
                }
                // dd($bonusData);
                DB::table('thirdparty_config_new')->insert($bonusData);
                // dd('d');


                // Session::flash('flash_notice',  trans("Player Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewpayout");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_payout", compact('teams', 'sport_types', 'gatwaymaster'));
    } //End Function

    //add player
    public function add_payout_oldfiroz(Request $request)
    {
        // dd($request->all());
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $gatwaymaster = DB::table('gateway_master')->where('gateway_key', '!=', 'PAYTM')->get();
        $formData    =    Input::all();
        // dd($formData);

        if (!empty($formData)) {
            // unique:thirdparty_config_new,name

            $validate    =    array(
                'name'     =>    'required',
                'url'     =>    'required',
                // 'notify_url'	=>	'required',
                // 'return_url' => 'required',
                // 'merchant_id' => 'required',
                // 'merchant_key' => 'required',
                // 'mercent_username' => 'required',
                // 'amount_max_limit' => 'required',
                // 'amount_min_limit' => 'required',
                'day_per_transaction' => 'required',
                // 'gateway_charges' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                // $bonusname = str_replace(' ', '_', strtoupper($formData['type']));
                //       $bonusData['type'] = $bonusname;


                // $input['url'] = trim($input['url']);

                $bonusData['url'] = str_replace(' ', '', $formData['url']);
                // $bonusData['notify_url'] = str_replace(' ','',$formData['notify_url']);
                // $bonusData['return_url'] = str_replace(' ','',$formData['return_url']);
                $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);


                if (!empty($formData['merchant_id'])) {
                    $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);
                } else if (!empty($formData['merchant_idtwo'])) {
                    $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_idtwo']);
                } else {
                    $bonusData['merchant_id'] = "";
                }





                if (!empty($formData['merchant_key'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_key']);
                } else if (!empty($formData['merchant_keytwo'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_keytwo']);
                } else if (!empty($formData['merchant_keythree'])) {
                    $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_keythree']);
                } else {
                    $bonusData['merchant_key'] = "";
                }



                $bonusData['app_id'] = str_replace(' ', '', $formData['app_id']);






                $bonusData['merchant_salt'] = str_replace(' ', '', $formData['merchant_salt']);

                //

                // $bonusData['mercent_username'] = str_replace(' ','',$formData['mercent_username']);
                $bonusData['amount_max_limit'] = str_replace(' ', '', $formData['amount_max_limit']);
                $bonusData['amount_min_limit'] = str_replace(' ', '', $formData['amount_min_limit']);
                $bonusData['day_per_transaction'] = str_replace(' ', '', $formData['day_per_transaction']);
                $bonusData['gateway_charges'] = str_replace(' ', '', $formData['gateway_charges']);
                $bonusData['status'] = str_replace(' ', '', $formData['status']);
                if (!empty($formData['name'])) {

                    if ($formData['withdraw_type'] == 1) {
                        // dd($formData);
                        // dd('111111111111');
                        $bonusData['name'] = $formData['name'] . '_' . 'BANK';
                    } else if ($formData['withdraw_type'] == 2) {
                        $bonusData['name'] = $formData['name'] . '_' . 'INSTANT';
                    } else {
                        $bonusData['name'] = $formData['name'];
                    }
                }
                // $bonusData['name'] =$formData['name'];

                if ($bonusData['name'] == "CASHFREE_PAYOUT") {
                    $bonusData['gateway_type'] = '4';
                } else if ($bonusData['name'] == "PAYTM_PAYOUT") {
                    $bonusData['gateway_type'] = '3';
                } else if ($bonusData['name'] == "RAZORPAY_PAYOUT" || $bonusData['name'] == "PAYUMONEY_PAYOUT" || $bonusData['name'] == "MPAISA_PAYOUT") {
                    $bonusData['gateway_type'] = '5';
                }

                $check = DB::table('thirdparty_config_new')->where('transaction_type', '=', 2)->where('name', '=', $bonusData['name'])->first();
                if ($check) {
                    return back()->with('success', 'Already Gateway Name exist');
                }

                if (!empty($formData['withdraw_type'])) {
                    $bonusData['withdraw_type'] = $formData['withdraw_type'];
                } else {
                    $bonusData['withdraw_type'] = '0';
                }


                $bonusData['transaction_type'] = '2';
                if (!empty($formData['secret_key'])) {
                    $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_key']);
                } else if (!empty($formData['secret_keytwo'])) {
                    $bonusData['secret_key'] = str_replace(' ', '', $formData['secret_keytwo']);
                } else {
                    $bonusData['secret_key'] = "";
                }



                // dd($bonusData['withdraw_type']);
                DB::table('thirdparty_config_new')->insert($bonusData);
                // dd('d');


                // Session::flash('flash_notice',  trans("Player Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewpayout");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_payout", compact('teams', 'sport_types', 'gatwaymaster'));
    } //End Function
    public function add_payout_old1(Request $request)
    {
        // dd('dd');
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $gatwaymaster = DB::table('gateway_master')->where('gateway_key', '!=', 'PAYTM')->select('gateway_master.gateway_key', 'gateway_master.Name')->get();
        $formData    =    Input::all();
        // dd($formData);
        if (!empty($formData)) {

            $validate    =    array(
                'name' => 'required',
                'url'     =>    'required',
                'notify_url'    =>    'required',
                'return_url' => 'required',
                'merchant_id' => 'required',
                'merchant_key' => 'required',
                'mercent_username' => 'required',
                'amount_max_limit' => 'required',
                'amount_min_limit' => 'required',
                'day_per_transaction' => 'required',
                'gateway_charges' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                // $bonusname = str_replace(' ', '_', strtoupper($formData['type']));
                //       $bonusData['type'] = $bonusname;


                // $input['url'] = trim($input['url']);
                $bonusData['name'] = str_replace(' ', '', $formData['name']);
                $bonusData['url'] = str_replace(' ', '', $formData['url']);
                $bonusData['notify_url'] = str_replace(' ', '', $formData['notify_url']);
                $bonusData['return_url'] = str_replace(' ', '', $formData['return_url']);

                $bonusData['merchant_id'] = str_replace(' ', '', $formData['merchant_id']);
                $bonusData['merchant_key'] = str_replace(' ', '', $formData['merchant_key']);
                $bonusData['mercent_username'] = str_replace(' ', '', $formData['mercent_username']);

                $bonusData['amount_max_limit'] = str_replace(' ', '', $formData['amount_max_limit']);
                $bonusData['amount_min_limit'] = str_replace(' ', '', $formData['amount_min_limit']);
                $bonusData['day_per_transaction'] = str_replace(' ', '', $formData['day_per_transaction']);

                $bonusData['gateway_charges'] = str_replace(' ', '', $formData['gateway_charges']);
                $bonusData['status'] = str_replace(' ', '', $formData['status']);
                $bonusData['transaction_type'] = 2;

                $check = DB::table('thirdparty_config_new')->where('transaction_type', '=', 2)->where('name', '=', $bonusData['name'])->first();
                if ($check) {
                    return back()->with('success', 'Gateway Name Already Exist');
                }

                if (!empty($bonusData['withdraw_type'])) {
                    $bonusData['withdraw_type'] = $formData['withdraw_type'];
                } else {
                    $bonusData['withdraw_type'] = 0;
                }
                if ($bonusData['name'] == 'PAYTM_PAYOUT') {
                    $bonusData['gateway_type'] = 3;
                } elseif ($bonusData['name'] == 'CASHFREE_PAYOUT') {
                    $bonusData['gateway_type'] = 4;
                } elseif ($bonusData['name'] == 'RAZORPAY_PAYOUT' || $bonusData['name'] == 'PAYUMONEY_PAYOUT' || $bonusData['name'] == 'MPAISA_PAYOUT') {
                    $bonusData['gateway_type'] = 5;
                }



                DB::table('thirdparty_config_new')->insert($bonusData);
                // dd('d');


                Session::flash('flash_notice',  trans("Payout Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewpayout");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_payout", compact('teams', 'sport_types', 'gatwaymaster'));
    } //End Function


    public function deletepayout($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('thirdparty_config_new')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('thirdparty_config_new')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Payout!');
            Helpers::logActivity('Successfully Deleted Payment!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Payment id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }

    public function editpayout(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $payment = ThirdParty::find($id);
        $gatwaymaster = DB::table('gateway_master')->select('gateway_master.gateway_key', 'gateway_master.Name')->where('gateway_key', '!=', 'PAYTM')->get();
        // dd($id);
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();


        return view("admin.$this->model.edit_payout", compact('payment', 'sport_types', 'gatwaymaster'));
    }

    public function updatepayout(Request $request, $id)
    {



        // dd($request->all());
        $Payment = ThirdParty::find($id);
        // dd($Bonus);
        // $bonusname = str_replace(' ', '_', strtoupper($request->input('type')));
        // $Payment->name = str_replace(' ','',$request->input('name'));

        $Payment->name = str_replace(' ', '', $request->input('name'));


        // try code



        //
        // 	if ($request->input('withdraw_type') == 1) {
        //
        //
        //
        //
        // 			$data = $request->input('name');
        // 			$last_world_get = explode('_',$data)[2];
        //
        // 		//	$last_world_get = substr($data, strpos($data, "_") + 2);
        // 			//dd($last_world_get);
        //
        //
        //
        // 		if($last_world_get == "BANK" || $last_world_get == "INSTANT"){
        // 			$text = $request->input('name');
        // 			// dd($text);
        // 			$last_space_position = strrpos($text, '_');
        // 			$text = substr($text, 0, $last_space_position);
        // 			$Payment->name = str_replace(' ','',$text.''.'_BANK');
        // 		}else{
        // 			// dd('ss');
        // 				$Payment->name = str_replace(' ','',$request->input('name'));
        //
        // 		}
        //
        //
        //
        //
        //
        // 		// dd($test);
        //
        //
        // 	}else if($request->input('withdraw_type') == 2){
        //
        // 		$data = $request->input('name');
        // 		$last_world_get = explode('_',$data)[2];
        //
        //
        // 	if($last_world_get == "BANK" || $last_world_get == "INSTANT"){
        // 		$text = $request->input('name');
        // 		dd($text);
        // 		$last_space_position = strrpos($text, '_');
        // 		$text = substr($text, 0, $last_space_position);
        // 		$Payment->name = str_replace(' ','',$text.''.'_INSTANT');
        // 	}else{
        // 		dd('ss');
        // 			$Payment->name = str_replace(' ','',$request->input('name'));
        //
        // 	}
        // 	// dd($test);
        //
        //
        // }else if($request->input('withdraw_type') == 0){
        // 	dd('3333333333333333');
        // 	$text = $request->input('name');
        // $last_space_position = strrpos($text, '_');
        // $text = substr($text, 0, $last_space_position);
        // // dd($text);
        //
        //
        // 	$Payment->name = str_replace(' ','',$text.''.'_OTHERS');
        // // dd($test);
        //
        // 	}
        //









        // try code end







        $Payment->url = str_replace(' ', '', $request->input('url'));
        // $Payment->notify_url = str_replace(' ','',$request->input('notify_url'));
        // $Payment->return_url = str_replace(' ','',$request->input('return_url'));
        $Payment->app_id = str_replace(' ', '', $request->input('app_id'));
        // $Payment->merchant_salt = str_replace(' ','',$request->input('merchant_salt'));
        // $Payment->merchant_id = str_replace(' ','',$request->input('merchant_id'));
        // $Payment->merchant_key = str_replace(' ','',$request->input('merchant_key'));
        // $Payment->mercent_username = str_replace(' ','',$request->input('mercent_username'));
        $Payment->amount_max_limit = str_replace(' ', '', $request->input('amount_max_limit'));
        $Payment->amount_min_limit = str_replace(' ', '', $request->input('amount_min_limit'));
        $Payment->day_per_transaction = str_replace(' ', '', $request->input('day_per_transaction'));
        $Payment->gateway_charges = str_replace(' ', '', $request->input('gateway_charges'));
        $Payment->status = str_replace(' ', '', $request->input('status'));

        // 							if(!empty($request->input('merchant_id')) && ($request->input('name') == "RAZORPAY_PAYOUT")){
        // 									// dd('ttt');
        // 							$Payment->merchant_id = str_replace(' ','',$request->input('merchant_id'));
        // 						}
        // 						if(!empty($request->input('merchant_idone')) && ($request->input('name') == "PAYTM_PAYOUT")){
        // 							// dd('s');
        //
        // 							$Payment->merchant_id = str_replace(' ','',$request->input('merchant_idone'));
        // 						}
        // // dd($request->merchant_keyone);
        // 							 if(!empty($request->input('merchant_key'))){
        // 								 // echo "ff";
        // 									$Payment->merchant_key = str_replace(' ','',$request->input('merchant_key'));
        // 								}
        //
        // 								if(!empty($request->input('merchant_keyone')) && ($request->input('name') == "PAYTM_PAYOUT")){
        // 									$Payment->merchant_key = str_replace(' ','',$request->input('merchant_keyone'));
        // 								}
        //
        // 							 if (!empty($request->input('merchant_keytwo')) && ($request->input('name') == "PAYUMONEY_PAYOUT")){
        // 										// dd('asdfdsfas');
        // 									$Payment->merchant_key = str_replace(' ','',$request->input('merchant_keytwo'));
        //
        // 								}
        // 								// else{
        // 								// 	$Payment->merchant_key = NULL;
        // 								// }
        //
        // 									// dd($request->all());
        //
        // 								if(!empty($request->input('secret_key'))){
        // 									// RAZORPAY_PAYMENT
        // 								$Payment->secret_key = str_replace(' ','',$request->input('secret_key'));
        // 							// dd($tets);
        // 							}
        // 							 if(!empty($request->input('secret_keyone')) && ($request->input('name') == "CASHFREE_PAYOUT") ){
        // 									$Payment->secret_key = str_replace(' ','',$request->input('secret_keyone'));
        //
        //
        // 							}

        if (!empty($request->input('merchant_id')) && ($request->input('name') == "RAZORPAY_PAYOUT") || ($request->input('name') == "RAZORPAY_PAYOUT_BANK") || ($request->input('name') == "RAZORPAY_PAYOUT_INSTANT")) {
            // dd('ttt');
            $Payment->merchant_id = str_replace(' ', '', $request->input('merchant_id'));
        }
        if (!empty($request->input('merchant_idone')) && ($request->input('name') == "CASHFREE_PAYOUT") || ($request->input('name') == "CASHFREE_PAYOUT_BANK") || ($request->input('name') == "CASHFREE_PAYOUT_INSTANT")) {
            // dd('s');

            $Payment->merchant_id = str_replace(' ', '', $request->input('merchant_idone'));
        }
        // dd($request->merchant_keyone);
        if (!empty($request->input('merchant_key') && ($request->input('name') == "RAZORPAY_PAYOUT") || ($request->input('name') == "RAZORPAY_PAYOUT_BANK") || ($request->input('name') == "RAZORPAY_PAYOUT_INSTANT"))) {
            $Payment->merchant_key = str_replace(' ', '', $request->input('merchant_key'));
        }

        if (!empty($request->input('merchant_keyone')) && ($request->input('name') == "CASHFREE_PAYOUT") || ($request->input('name') == "CASHFREE_PAYOUT_BANK") || ($request->input('name') == "CASHFREE_PAYOUT_INSTANT")) {
            $Payment->merchant_key = str_replace(' ', '', $request->input('merchant_keyone'));
        }

        if (!empty($request->input('merchant_keytwo')) && ($request->input('name') == "PAYUMONEY_PAYOUT") || ($request->input('name') == "PAYUMONEY_PAYOUT_BANK") || ($request->input('name') == "PAYUMONEY_PAYOUT_INSTANT")) {
            // dd('asdfdsfas');
            $Payment->merchant_key = str_replace(' ', '', $request->input('merchant_keytwo'));
        }
        // else{
        // 	$Payment->merchant_key = NULL;
        // }

        // dd($request->all());

        if (!empty($request->input('secret_key'))) {
            // RAZORPAY_PAYMENT
            $Payment->secret_key = str_replace(' ', '', $request->input('secret_key'));
            // dd($tets);
        }
        if (!empty($request->input('secret_keyone')) && ($request->input('name') == "CASHFREE_PAYOUT") || ($request->input('name') == "CASHFREE_PAYOUT_BANK") || ($request->input('name') == "CASHFREE_PAYOUT_INSTANT")) {
            $Payment->secret_key = str_replace(' ', '', $request->input('secret_keyone'));
        }

        $Payment->withdraw_type = str_replace(' ', '', $request->input('withdraw_type'));




        if ($request->input('name') == "CASHFREE_PAYOUT_BANK" || $request->input('name') == "CASHFREE_PAYOUT_INSTANT") {
            $Payment->gateway_type = '4';
        } else if ($request->input('name') == "PAYTM_PAYOUT_BANK" || $request->input('name') == "PAYTM_PAYOUT_INSTANT") {
            $Payment->gateway_type = '3';
        } else if (($request->input('name') == "RAZORPAY_PAYOUT_BANK" || $request->input('name') == "RAZORPAY_PAYOUT_INSTANT") || ($request->input('name') == "PAYUMONEY_PAYOUT_BANK" || $request->input('name') == "PAYUMONEY_PAYOUT_INSTANT") || ($request->input('name') == "MPAISA_PAYOUT_BANK" || $request->input('name') == "MPAISA_PAYOUT_INSTANT")) {
            $Payment->gateway_type = '5';
        }






        $Payment->update();
        Session::flash('flash_notice',  trans("Payout Successfully updated!"));
        // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
        return Redirect::route("$this->model.viewpayout");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }

    public function updatepayoutstatus($id, $status)
    {
        // dd('d');
        $statuscheck = $status == 1 ? "active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('thirdparty_config_new')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'payout  ' . $statuscheck . ' status update successfully!');
        return Redirect::back();
    } //End Function





    // AWS MANAGER
    public function viewaws()
    {

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('aws_config')
                ->get())
                ->addIndexColumn()

                ->addColumn('s3_name	', function ($result) {
                    return $users_referal['s3_name	'] = $result->s3_name;
                })

                ->addColumn('s3_key', function ($result) {
                    return $users_referal['s3_key'] = $result->s3_key;
                })
                ->addColumn('s3_secret', function ($result) {
                    return $users_referal['s3_secret'] = $result->s3_secret;
                })
                ->addColumn('end_point', function ($result) {
                    return $users_referal['end_point'] = $result->end_point;
                })
                ->addColumn('cdn_url', function ($result) {
                    return $users_referal['cdn_url'] = $result->cdn_url;
                })
                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                ->addColumn('action', function ($result) {
                    // $bowler=$result->role;
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.awsstatus', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.awsstatus', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }
                    return '<a href="' . route($this->model . '.edit_aws', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.delete_aws', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;
                    //
                    // ;
                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end
        return view("admin.$this->model.view_aws");
    }

    public function add_aws(Request $request)
    {
        $formData    =    Input::all();
        if (!empty($formData)) {
            $validate    =    array(
                's3_name'     =>    'required',
                's3_key' => 'required',
                's3_secret'    =>    'required',
                'end_point' => 'required',
                'cdn_url' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                $data['s3_name'] = $formData['s3_name'];
                $data['s3_key'] = str_replace(' ', '', $formData['s3_key']);
                $data['s3_secret'] = str_replace(' ', '', $formData['s3_secret']);
                $data['end_point'] = str_replace(' ', '', $formData['end_point']);
                $data['cdn_url'] = str_replace(' ', '', $formData['cdn_url']);
                $data['status'] = $formData['status'];
                DB::table('aws_config')->insert($data);


                Session::flash('flash_notice',  trans("AWS S3 Configuration Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewaws");
            }
        }
        return view("admin.$this->model.add_aws");
    }
    //End Function


    public function edit_aws(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        // $player = ThirdParty::find($id);
        // dd($id);
        $aws_data =   DB::table('aws_config')
            ->where('id', $id)
            ->first();
        return view("admin.$this->model.edit_aws", compact('aws_data'));
    }


    public function update_aws(Request $request, $id)
    {
        $id = unserialize(base64_decode($id));
        $getdata = DB::table('aws_config')->where('id', $id)->first();
        if ($request->isMethod('post')) {
            $formData = Input::all();
            unset($formData['_token']);

            $data = array();
            $data['s3_name'] = $formData['s3_name'];
            $data['s3_key'] = str_replace(' ', '', $formData['s3_key']);
            $data['s3_secret'] = str_replace(' ', '', $formData['s3_secret']);
            $data['end_point'] = str_replace(' ', '', $formData['end_point']);
            $data['cdn_url'] = str_replace(' ', '', $formData['cdn_url']);
            $data['status'] = $formData['status'];
            $data = str_replace(' ', '', $data);
            DB::table('aws_config')->where('id', $id)->update($data);
            Session::flash('flash_notice',  trans(" Successfully updated!"));
            // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
            return Redirect::route("$this->model.viewaws");
        }
        return Redirect::route("$this->model.viewaws");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }

    public function delete_aws($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('aws_config')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('aws_config')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted AWS S3 Configuration!');
            Helpers::logActivity('Successfully Deleted AWS S3 Configuration!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid AWS S3 Configuration');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }


    // AWS MANAGER







    // Fantasy Sports API
    public function viewapi()
    {

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('thirdparty_config_new')
                ->where('access_tokens', '!=', '')
                ->where('sports_type', '>', 0)
                ->get())
                ->addIndexColumn()

                ->addColumn('name', function ($result) {
                    return $users_referal['name'] = $result->name;
                })

                // ->addColumn('url',function ( $result){
                //   return $users_referal['url'] = $result->url;
                // })
                ->addColumn('sports_type', function ($result) {
                    return $users_referal['sports_type'] = DB::table('sport_types')->where('id', $result->sports_type)->first()->sport_key;
                })
                ->addColumn('access_tokens', function ($result) {
                    return $users_referal['access_tokens'] = $result->access_tokens;
                })
                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                ->addColumn('action', function ($result) {
                    // $bowler=$result->role;
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.apistatus', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.apistatus', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }
                    return '<a href="' . route($this->model . '.edit_api', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        // .'<a onclick="updateplayer('.$result->id.')" id="updateplayer'. $result->id.'" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.delete_api', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;
                    //
                    // ;
                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end
        return view("admin.$this->model.view_api");
    }

    public function add_api(Request $request)
    {
        $formData    =    Input::all();
        if (!empty($formData)) {
            $validate    =    array(
                'sports_type'     =>    'required',
                'name' => 'required',
                // 'url'	=>	'required',
                'access_tokens' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                $data['name'] = $formData['name'];
                $data['sports_type'] = $formData['sports_type'];
                // $data['url'] = str_replace(' ','',$formData['url']);
                $data['access_tokens'] = str_replace(' ', '', $formData['access_tokens']);
                $data['status'] = $formData['status'];
                DB::table('thirdparty_config_new')->insert($data);


                Session::flash('flash_notice',  trans("Fantasy API Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewapi");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_key')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();
        return view("admin.$this->model.add_api", compact('sport_types'));
    }
    //End Function


    public function edit_api(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        // $player = ThirdParty::find($id);
        // dd($id);
        $api_data =   DB::table('thirdparty_config_new')
            ->where('id', $id)
            ->first();


        $sport_types = DB::table('sport_types')->select('id', 'sport_key')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();
        return view("admin.$this->model.edit_api", compact('api_data', 'sport_types'));
    }


    public function update_api(Request $request, $id)
    {
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $input = Input::all();
            unset($input['_token']);
            $data = DB::table('thirdparty_config_new')->where('id', $id)->first();
            $data = array();
            $data = [
                'sports_type' => $input['sports_type'],
                'name' => $input['name'],
                // 'url' =>$input['url'],
                'access_tokens' => $input['access_tokens'],
                'status' => $input['status']
            ];
            $data = str_replace(' ', '', $data);
            DB::table('thirdparty_config_new')->where('id', $id)->update($data);
            Session::flash('flash_notice',  trans(" Successfully updated!"));
            // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
            return Redirect::route("$this->model.viewapi");
        }
        return Redirect::route("$this->model.viewapi");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }

    public function delete_api($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('thirdparty_config_new')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('thirdparty_config_new')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Fantasy Sports API!');
            Helpers::logActivity('Successfully Deleted Fantasy Sports API!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Fantasy Sports API');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }


    // Fantasy Sports API






    public function viewsms()
    {
        // $da =  DB::table('thirdparty_config_new as tdp')
        //   ->where('gateway_type',0)
        //   ->get();
        //   dd($da);die;exit;
        $formData = Input::all();
        // dd('d');

        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('thirdparty_config_new')
                ->where('gateway_type', 0)
                ->get())
                ->addIndexColumn()

                ->addColumn('name', function ($result) {
                    return $users_referal['name'] = $result->name;
                })
                // ->addColumn('gateway_type',function ( $result){
                //     return $users_referal['gateway_type'] = $result->gateway_type;
                //   // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->referral_id))).'" style="text-decoration:underline;">'.$result->referral_email.'</a>';
                //
                // })
                // ->addColumn('url',function ( $result){
                //   return $users_referal['url'] = $result->url;
                //   // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                // ->addColumn('sender_id',function ( $result){
                //   return $users_referal['sender_id'] = $result->sender_id;
                //   // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                ->addColumn('sms_auth_key', function ($result) {
                    return $users_referal['sms_auth_key'] = $result->sms_auth_key;
                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })
                // ->addColumn('header_id',function ( $result){
                //   return $users_referal['header_id'] = $result->header_id;
                //   // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                // ->addColumn('template_id',function ( $result){
                //   return $users_referal['template_id'] = $result->template_id;
                //   // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                // ->addColumn('dlt_id',function ( $result){
                //   return $users_referal['dlt_id'] = $result->dlt_id;
                //   // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                // ->addColumn('status',function ($result){
                // 			 return $result->status;
                // })
                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                ->addColumn('action', function ($result) {
                    // $bowler=$result->role;
                    //  $activation_status='';
                    //  if(strtolower($result->status)!='0'){
                    // 	 $activation_status='<a href="'.route($this->model.'.update_sms_status',[base64_encode(serialize($result->id)),'0']).'" class="btn btn-success mr-1 mt-1 action-userss" style="margin-left: 5px;">Active</a></br>';
                    //  }else{
                    // 	 $activation_status='<a href="'.route($this->model.'.update_sms_status',[base64_encode(serialize($result->id)),'1']).'" class="btn btn-warning mr-1 mt-1 action-users" style="margin-left: 5px;">Inactivate</a></br>';
                    //  }
                    // 		 return '<a href="'.route($this->model.'.edit',[base64_encode(serialize($result->id))]).'" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                    // 			 // .'<a onclick="updateplayer('.$result->id.')" id="updateplayer'. $result->id.'" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                    // 			 .'<a id="saveplayer'.$result->id.'" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                    // 			 .'<a href="'.route($this->model.'.delete',base64_encode(serialize($result->id))).'" data-toggle="tooltip" title="delete" class="btn btn-rg action-players"><i class="fa fa-trash" aria-hidden="true"></i></a>'
                    // 			 .$activation_status
                    //
                    // 			 ;
                    // // onclick="saveplayer('.$result->id.')"
                    //  })
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.update_sms_status', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_sms_status', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }
                    return '<a href="' . route($this->model . '.edit', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        // .'<a onclick="updateplayer('.$result->id.')" id="updateplayer'. $result->id.'" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.delete', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players  mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;
                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end
        ### Breadcrumb Start ###
        // Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
        // Breadcrumb::addBreadcrumb($this->model,route($this->model.'.view'));
        // $breadcrumbs 	= 	Breadcrumb::generate();
        ### Breadcrumb End ###
        //print_r($this->model);die;
        return view("admin.$this->model.view_sms");
    }

    public function add_sms(Request $request)
    {
        // dd('dd');
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $formData    =    Input::all();
        if (!empty($formData)) {

            $validate    =    array(
                'name'     =>    'required',
                // 'url'	=>	'required',
                // 'sender_id' => 'required',
                'auth_key' => 'required',
                // 'header_id' => 'required',
                // 'temp_id' => 'required',
                // 'dlt_id' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                $data['name'] = str_replace(' ', '', $formData['name']);
                // $data['url'] = str_replace(' ','',$formData['url']);
                $data['gateway_type'] = 0;
                // $data['sender_id'] = str_replace(' ','',$formData['sender_id']);
                $data['sms_auth_key'] = str_replace(' ', '', $formData['auth_key']);
                // $data['header_id'] = str_replace(' ','',$formData['header_id']);
                // $data['template_id'] = str_replace(' ','',$formData['temp_id']);
                // $data['dlt_id'] = str_replace(' ','',$formData['dlt_id']);
                $data['status'] = $formData['status'];
                // $bonusData['sport_type'] = $formData['sport_type'];
                // $bonusData['player_key'] =  substr(str_replace(' ', '', $formData['player_name']),0,5).'_'.$formData['team'].substr(time(),-4);
                // dd($bonusData);
                // echo "<pre>";print_r($data);exit;
                DB::table('thirdparty_config_new')->insert($data);


                Session::flash('flash_notice',  trans("SMS  Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewsms");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add", compact('teams', 'sport_types'));
    } //End Function

    public function deletesms($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('thirdparty_config_new')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('thirdparty_config_new')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Sms!');
            Helpers::logActivity('Successfully Deleted Sms!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Sms id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }

    public function editsms(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        // $player = ThirdParty::find($id);
        // dd($id);
        $player =   DB::table('thirdparty_config_new')
            ->where('id', $id)
            ->first();
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();


        return view("admin.$this->model.edit_sms", compact('player', 'sport_types'));
    }

    public function updatesmsstatus($id, $status)
    {

        $statuscheck = $status == 1 ? "Active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('thirdparty_config_new')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'SMS ' . $statuscheck . ' status update successfully !');
        return Redirect::back();
    } //End Function

    public function updatesms(Request $request, $id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $input = Input::all();
            unset($input['_token']);

            $data = DB::table('thirdparty_config_new')->where('id', $id)->first();
            // $data = ThirdParty::find($id);
            // dd($data);




            $data = array();
            $data = [
                'name' => $input['name'],
                // 'url' =>$input['url'],
                // 'gateway_type' => 0,
                // 'sender_id' => $input['sender_id'],
                'sms_auth_key' => $input['auth_key'],
                // 'header_id' => $input['header_id'],
                // 'template_id' => $input['temp_id'],
                // 'dlt_id' => $input['dlt_id'],
                'status' => $input['status']
            ];

            $data = str_replace(' ', '', $data);
            // dd($data);


            // dd($data);
            DB::table('thirdparty_config_new')->where('id', $id)->update($data);
            Session::flash('flash_notice',  trans(" Successfully updated!"));
            // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
            return Redirect::route("$this->model.viewsms");
        }
        return Redirect::route("$this->model.viewsms");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }


    public function viewemail()
    {

        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('email_config')
                ->where('status', 1)
                ->get())
                ->addIndexColumn()

                ->addColumn('from_name', function ($result) {
                    return $users_referal['from_name'] = $result->from_name;
                })
                ->addColumn('mail_driver', function ($result) {
                    return $users_referal['mail_driver'] = $result->mail_driver;
                })
                ->addColumn('mail_host', function ($result) {
                    return $users_referal['mail_host'] = $result->mail_host;
                })
                ->addColumn('mail_port', function ($result) {
                    return $users_referal['mail_port'] = $result->mail_port;
                })
                ->addColumn('form_address', function ($result) {
                    return $users_referal['form_address'] = $result->form_address;
                })
                ->addColumn('mail_username', function ($result) {
                    return $users_referal['mail_username'] = $result->mail_username;
                })
                ->addColumn('mail_password', function ($result) {
                    return $users_referal['mail_password'] = $result->mail_password;
                })
                ->addColumn('email_encryption', function ($result) {
                    return $users_referal['email_encryption'] = $result->email_encryption;
                })

                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                ->addColumn('action', function ($result) {
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.update_email_status', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_email_status', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }
                    return '<a href="' . route($this->model . '.editemail', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.deleteemail', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;
                })
                ->escapeColumns([])
                ->make(true);
        }
        return view("admin.$this->model.viewemail");
    }

    public function add_email(Request $request)
    {
        $formData    =    Input::all();
        if (!empty($formData)) {

            $validate    =    array(
                'name'     =>    'required',
                'driver'    =>    'required',
                'host' => 'required',
                'port' => 'required',
                'username' => 'required',
                'password' => 'required',
                'encryption' => 'required',
                'address' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                $data['from_name'] = str_replace(' ', '', $formData['name']);
                $data['mail_driver'] = str_replace(' ', '', $formData['driver']);
                $data['mail_host'] = str_replace(' ', '', $formData['host']);
                $data['mail_port'] = str_replace(' ', '', $formData['port']);
                $data['mail_username'] = str_replace(' ', '', $formData['username']);
                $data['mail_password'] = str_replace(' ', '', $formData['password']);
                $data['email_encryption'] = str_replace(' ', '', $formData['encryption']);
                $data['form_address'] = str_replace(' ', '', $formData['address']);
                // $data['dlt_id'] = str_replace(' ','',$formData['encryption']);
                $data['status'] = $formData['status'];

                DB::table('email_config')->insert($data);


                Session::flash('flash_notice',  trans("Email Successfully added!"));
                return Redirect::route("$this->model.viewemail");
            }
        }
        return view("admin.$this->model.add_email");
    } //End Function


    public function deleteemail($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('email_config')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('email_config')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Email!');
            Helpers::logActivity('Successfully Deleted Email!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Email id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }


    public function editemail(Request $request, $id)
    {

        $id = unserialize(base64_decode($id));


        $email =   DB::table('email_config')
            ->where('id', $id)
            ->first();
        // dd($email);

        return view("admin.$this->model.edit_email", compact('email'));
    }
    public function updateemail(Request $request, $id)

    {
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $input = Input::all();
            unset($input['_token']);

            $data = DB::table('email_config')->where('id', $id)->first();
            $data = array();
            $data = [
                'from_name' => $input['name'],
                'mail_driver' => $input['mail_driver'],
                'mail_host' => $input['mail_host'],
                'mail_port' => $input['mail_port'],
                'mail_username' => $input['mail_username'],
                'mail_password' => $input['mail_password'],
                'email_encryption' => $input['email_encryption'],
                'form_address' => $input['form_address'],
                'status' => $input['status']
            ];
            $data = str_replace(' ', '', $data);
            DB::table('email_config')->where('id', $id)->update($data);
            Session::flash('flash_notice',  trans(" Successfully updated!"));
            return Redirect::route("$this->model.viewemail");
        }
        return Redirect::route("$this->model.viewemail");
    }

    public function updateemailstatus($id, $status)
    {
        $statuscheck = $status == 1 ? "Active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('email_config')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'Email ' . $statuscheck . ' status update successfully !');
        return Redirect::back();
    } //End Function

    public function view_dlt()
    {
        // $da =  DB::table('thirdparty_config_new as tdp')
        //   ->where('gateway_type',0)
        //   ->get();
        // dd('f');
        $formData = Input::all();
        // dd('d');

        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('thirdparty_config_new')
                ->where('gateway_type', 7)
                ->get())
                ->addIndexColumn()

                // ->addColumn('name',function ( $result){
                // 	return $users_referal['name'] = $result->name;
                // })
                // ->addColumn('gateway_type',function ( $result){
                // 		return $users_referal['gateway_type'] = $result->gateway_type;
                // 	// return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->referral_id))).'" style="text-decoration:underline;">'.$result->referral_email.'</a>';
                //
                // })
                // ->addColumn('url',function ( $result){
                // 	return $users_referal['url'] = $result->url;
                // 	// return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                ->addColumn('sender_id', function ($result) {
                    return $users_referal['sender_id'] = $result->sender_id;
                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })
                // ->addColumn('sms_auth_key',function ( $result){
                // 	return $users_referal['sms_auth_key'] = $result->sms_auth_key;
                // 	// return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                ->addColumn('header_id', function ($result) {
                    return $users_referal['header_id'] = $result->header_id;
                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })
                ->addColumn('template_id', function ($result) {
                    return $users_referal['template_id'] = $result->template_id;
                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })

                ->addColumn('registered_message', function ($result) {

                    // return $users_referal['registered_message'] = $result->registered_message;
                    $doc = '...';

                    if (strlen($result->registered_message) > 50) {
                        return substr($result->registered_message, 0, 25)
                            . $doc;
                    } else {
                        return $result->registered_message;
                    }

                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })








                ->addColumn('dlt_id', function ($result) {
                    return $users_referal['dlt_id'] = $result->dlt_id;
                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })
                // ->addColumn('status',function ($result){
                // 			 return $result->status;
                // })
                ->addColumn('status', function ($result) {
                    if ($result->status == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                ->addColumn('action', function ($result) {
                    // $bowler=$result->role;
                    $activation_status = '';
                    if (strtolower($result->status) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.update_dlt_status', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss">Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_dlt_status', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }
                    return '<a href="' . route($this->model . '.editdlt', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        // .'<a onclick="updateplayer('.$result->id.')" id="updateplayer'. $result->id.'" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.deletedlt', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;
                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end
        ### Breadcrumb Start ###
        // Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
        // Breadcrumb::addBreadcrumb($this->model,route($this->model.'.view'));
        // $breadcrumbs 	= 	Breadcrumb::generate();
        ### Breadcrumb End ###
        //print_r($this->model);die;
        return view("admin.$this->model.view_dlt");
    }
    public function add_dlt(Request $request)
    {
        // dd('dd');
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $formData    =    Input::all();
        if (!empty($formData)) {

            $validate    =    array(
                // 'name'	 =>	'required',
                // 'url'	=>	'required',
                'sender_id' => 'required',
                'registered_message' => 'required',
                // 'auth_key' => 'required',
                'header_id' => 'required',
                'temp_id' => 'required',
                'dlt_id' => 'required',
                'status' => 'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);

                // $data['name'] =str_replace(' ','',$formData['name']);
                // $data['url'] = str_replace(' ','',$formData['url']);
                // $data['gateway_type'] = 0;
                $data['sender_id'] = str_replace(' ', '', $formData['sender_id']);
                $data['registered_message'] = str_replace(' ', '', $formData['registered_message']);
                $data['gateway_type'] = 7;
                // $data['sms_auth_key'] = str_replace(' ','',$formData['auth_key']);
                $data['header_id'] = str_replace(' ', '', $formData['header_id']);
                $data['template_id'] = str_replace(' ', '', $formData['temp_id']);
                $data['dlt_id'] = str_replace(' ', '', $formData['dlt_id']);
                $data['status'] = $formData['status'];
                // $bonusData['sport_type'] = $formData['sport_type'];
                // $bonusData['player_key'] =  substr(str_replace(' ', '', $formData['player_name']),0,5).'_'.$formData['team'].substr(time(),-4);
                // dd($bonusData);
                // echo "<pre>";print_r($data);exit;
                // dd($data);
                DB::table('thirdparty_config_new')->insert($data);


                Session::flash('flash_notice',  trans("Dlt  Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewdlt");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_dlt", compact('teams', 'sport_types'));
    } //End Function
    public function edit_dlt(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        // $player = ThirdParty::find($id);
        // dd($id);
        $player =   DB::table('thirdparty_config_new')
            ->where('id', $id)
            ->first();
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();


        return view("admin.$this->model.edit_dlt", compact('player', 'sport_types'));
    }

    public function updatedlt(Request $request, $id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $input = Input::all();
            unset($input['_token']);

            $data = DB::table('thirdparty_config_new')->where('id', $id)->first();
            // $data = ThirdParty::find($id);
            // dd($data);




            $data = array();
            $data = [
                // 'name' => $input['name'],
                // 'url' =>$input['url'],
                // 'gateway_type' => 0,
                'sender_id' => $input['sender_id'],
                'registered_message' => $input['registered_message'],
                // 'sms_auth_key' => $input['auth_key'],
                'header_id' => $input['header_id'],
                'template_id' => $input['temp_id'],
                'dlt_id' => $input['dlt_id'],
                'status' => $input['status']
            ];

            $data = str_replace(' ', '', $data);
            // dd($data);


            // dd($data);
            DB::table('thirdparty_config_new')->where('id', $id)->update($data);
            Session::flash('flash_notice',  trans(" Successfully updated!"));
            // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
            return Redirect::route("$this->model.viewdlt");
        }
        return Redirect::route("$this->model.viewdlt");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }

    public function updatedltstatus($id, $status)
    {

        $statuscheck = $status == 1 ? "Active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status'] = $status;
        // dd($input['status']);
        DB::table('thirdparty_config_new')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'DLT ' . $statuscheck . ' status update successfully !');
        return Redirect::back();
    } //End Function

    public function deletedlt($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('thirdparty_config_new')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('thirdparty_config_new')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Dlt!');
            Helpers::logActivity('Successfully Deleted Dlt!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Sms id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }

    public function view_firebase()
    {
        $formData = Input::all();
        if (isset($formData) && !empty($formData)) {
            return  Datatables::of(DB::table('thirdparty_config_new')
                ->where('gateway_type', 6)
                ->get())
                ->addIndexColumn()
                // ->addColumn('server_key',function ( $result){
                // 	return $users_referal['server_key'] = $result->server_key;
                // 	// return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                // })
                ->addColumn('server_key', function ($result) {

                    // return $users_referal['registered_message'] = $result->registered_message;
                    $doc = '...';

                    if (strlen($result->server_key) > 50) {
                        return substr($result->server_key, 0, 25)
                            . $doc;
                    } else {
                        return $result->server_key;
                    }

                    // return '<a href="'.route($this->model.'.details',base64_encode(serialize($result->id))).'" style="text-decoration:underline;">'.$result->email.'</a>';
                })
                ->addColumn('status_server', function ($result) {
                    if ($result->status_server == 1) {
                        return "Active";
                    } else {
                        return "InActive";
                    }
                })
                ->addColumn('action', function ($result) {
                    // $bowler=$result->role;
                    $activation_status = '';
                    if (strtolower($result->status_server) != '0') {
                        $activation_status = '<a href="' . route($this->model . '.update_firebase_status', [base64_encode(serialize($result->id)), '0']) . '" class="btn btn-success mr-1 mt-1 action-userss" >Active</a></br>';
                    } else {
                        $activation_status = '<a href="' . route($this->model . '.update_firebase_status', [base64_encode(serialize($result->id)), '1']) . '" class="btn btn-warning mr-1 mt-1 action-users">Inactivate</a></br>';
                    }
                    return '<a href="' . route($this->model . '.editfirebase', [base64_encode(serialize($result->id))]) . '" data-toggle="tooltip" title="Edit" class="btn btn-rg mr-1 mt-1" data-original-title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></a>'
                        // .'<a onclick="updateplayer('.$result->id.')" id="updateplayer'. $result->id.'" class="btn btn-rg mr-1 mt-1" aria-hidden="true" data-toggle="tooltip" title="Change Credits" data-original-title="Refresh"><i class="fa fa-refresh"></i></a>'
                        . '<a id="saveplayer' . $result->id . '" class="btn btn-rg mr-1 mt-1" style="display:none;cursor:pointer" data-toggle="tooltip" title="" data-original-title="Save" ><i class="fa fa-floppy-o" aria-hidden="true"></i></a>'
                        . '<a href="' . route($this->model . '.deletefirebase', base64_encode(serialize($result->id))) . '" data-toggle="tooltip" title="delete" class="btn btn-danger action-players mr-1 mt-1"><i class="fa fa-times mr-2" aria-hidden="true" data-original-title="Delete"></i>Delete</a>'
                        . $activation_status;
                    // onclick="saveplayer('.$result->id.')"
                })
                ->escapeColumns([])
                ->make(true);

            //print_r($dataa);exit;
        } //end
        ### Breadcrumb Start ###
        // Breadcrumb::addBreadcrumb('Dashboard',route('admin_dashboard'));
        // Breadcrumb::addBreadcrumb($this->model,route($this->model.'.view'));
        // $breadcrumbs 	= 	Breadcrumb::generate();
        ### Breadcrumb End ###
        //print_r($this->model);die;
        return view("admin.$this->model.view_firebase");
    }

    public function add_firebase(Request $request)
    {
        // dd('dd');
        $teams = DB::table('teams')->select('id', 'team')->orderBy('team', 'ASC')->get();
        $formData    =    Input::all();
        if (!empty($formData)) {

            $validate    =    array(
                'server_key'     =>    'required',
                'status_server'     =>    'required',
            );
            $validator = Validator::make(Input::all(), $validate);
            if ($validator->fails()) {
                return Redirect::back()->withErrors($validator)->withInput();
            } else {
                unset($formData['_token']);
                $data['server_key'] = str_replace(' ', '', $formData['server_key']);
                $data['status_server'] = $formData['status_server'];
                $data['gateway_type'] = 6;

                DB::table('thirdparty_config_new')->insert($data);


                Session::flash('flash_notice',  trans("Firebase  Successfully added!"));
                // Helpers::logActivity('Player Successfully added!',$formData['player_name']);
                return Redirect::route("$this->model.viewfirebase");
            }
        }
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();

        return view("admin.$this->model.add_firebase", compact('teams', 'sport_types'));
    } //End Function
    public function edit_firebase(Request $request, $id, $sport_type = 1)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        // $player = ThirdParty::find($id);
        // dd($id);
        $player =   DB::table('thirdparty_config_new')
            ->where('id', $id)
            ->first();
        $sport_types = DB::table('sport_types')->select('id', 'sport_name')->where('sport_name', '!=', 'Basketball')->where('status', 1)->get();


        return view("admin.$this->model.edit_firebase", compact('player', 'sport_types'));
    }

    public function update_firebase(Request $request, $id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        if ($request->isMethod('post')) {
            $input = Input::all();
            unset($input['_token']);

            $data = DB::table('thirdparty_config_new')->where('id', $id)->first();
            // $data = ThirdParty::find($id);
            // dd($data);




            $data = array();
            $data = [
                'server_key' => $input['server_key'],
                'status_server' => $input['status_server']
            ];

            $data = str_replace(' ', '', $data);
            // dd($data);


            // dd($data);
            DB::table('thirdparty_config_new')->where('id', $id)->update($data);
            Session::flash('flash_notice',  trans("Firebase Successfully updated!"));
            // Helpers::logActivity('Player successfully updated!',$fplay->player_name);
            return Redirect::route("$this->model.viewfirebase");
        }
        return Redirect::route("$this->model.viewfirebase");
        // return redirect()->back()->with('status','Student Updated Successfully');
    }

    public function updatefirebasestatus($id, $status)
    {

        $statuscheck = $status == 1 ? "Active" : "Inactive";
        $id = unserialize(base64_decode($id));
        $input['id'] = $id;
        $input['status_server'] = $status;
        // dd($input['status']);
        DB::table('thirdparty_config_new')->where('id', $id)->update($input);
        Session::flash('flash_notice', 'FIREBASE ' . $statuscheck . ' status update successfully !');
        return Redirect::back();
    } //End Function


    public function deletefirebase($id)
    {
        // dd('dd');
        $id = unserialize(base64_decode($id));
        $findPlayer = DB::table('thirdparty_config_new')->where('id', $id)->first();
        if (!empty($findPlayer)) {
            DB::table('thirdparty_config_new')->where('id', $id)->delete();
            Session::flash('flash_notice', 'Successfully Deleted Firebase!');
            Helpers::logActivity('Successfully Deleted Dlt!', $findPlayer->id);
            Session::flash('alert-class', 'alert-success');
        } else {
            Session::flash('flash_notice', 'Invalid Sms id');
            Session::flash('alert-class', 'alert-error');
        }
        return Redirect::back();
    }
}
