<?php
namespace App\Http\Controllers;

use App\Model\CarModel;
use App\Services\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;


class AjaxController extends Controller {

	/**
	 * Function for get list of states
	 */

	public function getStates(){
		$country_id	= Input::get('country_id');
		$stateList 	= DB::table("states")->where('status',ACTIVE)
                    ->where("country_id",$country_id)
                    ->orderBy('state_name', 'ASC')
                    ->pluck("state_name","id")->toArray();

		return json_encode($stateList);
	}

	/**
	 * Function for get list of cities
	 */
	public function getCities(){
		$country_id	= Input::get('country_id');
		$state_id 	= Input::get('state_id');
		$citylist 	= DB::table("cities")->where('status',ACTIVE)
                    ->where("country_id",$country_id)
                    ->where("state_id",$state_id)
                    ->orderBy('city_name', 'ASC')
                    ->pluck("city_name","id")->toArray();

		return json_encode($citylist);
	}


	/**
	 * Function for get list of state
	 */

	public function getStatesFront(){
		$country_id	= Input::get('country_id');
		$stateList 	= DB::table("states")->where('status',ACTIVE)
                    ->where("country_id",$country_id)
                    ->orderBy('state_name', 'ASC')
                    ->pluck("state_name","id")->toArray();

		return view::make('elements.get_state_by_country',compact('country_id','stateList'));
	}

	/**
	 * Function for get list of cities
	 */
	public function getCitiesFront(){
		$country_id	= Input::get('country_id');
		$state_id 	= Input::get('state_id');
		$citylist 	= DB::table("cities")->where('status',ACTIVE)
                    ->where("country_id",$country_id)
                    ->where("state_id",$state_id)
                    ->orderBy('city_name', 'ASC')
                    ->pluck("city_name","id")->toArray();

		return
		view::make('elements.get_city_by_state',compact('country_id','state_id','citylist'));
	}
	/**
	 * Function for get list of citie
	 */
	public function getCityByState(){
		$state_id 	= Input::get('state_id');
		$citylist 	= DB::table("cities")->where('status',ACTIVE)
										->where("state_id",$state_id)
										->orderBy('name', 'ASC')
										->pluck("name","id")->toArray();

		return json_encode($citylist);
	}

	/**
	 * Function for get model of make
	 */
	// public function getModelByMake(){
	// 	$car_make_id 	= Input::get('car_make_id');
	// 	$modelList 	= CarModel::select(DB::raw('concat(car_model_name," - ",model_year) as car_model_name'), 'car_model_id')
	// 													->where("car_make_id",$car_make_id)
	// 													->where('status', ACTIVE)
	// 													->orderBy('car_model_name', 'ASC')
	// 													->pluck('car_model_name', 'car_model_id');
	// 	return json_encode($modelList);
	// }

	/**
	 * Function for get dd  charge act. dealer

	 */
	public function getDDChargeByDealer(){
		$dealer_id 			= Input::get('dealer_id');
		$ddChargeList 	= DB::table("dealer_delivery_charge")->where('status',ACTIVE)
                    ->where("dealer_id",$dealer_id)
                    ->orderBy('dd_description', 'ASC')
                    ->pluck("dd_description","dd_id")->toArray();

		return json_encode($ddChargeList);
	}

	/**
	 * Function for get dd  charge act. dealer

	 */
	public function getDealerCampaign(){
		$dealer_id 			= Input::get('dealer_id');
		$campaignList 	= DB::table("car_campaign")->where('status',ACTIVE)
                    ->where("dealer_id",$dealer_id)
                    ->orderBy('car_campaign_id', 'DESC')
                    ->pluck("car_campaign_desc","car_campaign_id")->toArray();

		return json_encode($campaignList);
	}

}
