<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use JWTAuthException;
use App\User;
use App\Model\DropDown;
use App\Model\Country;
use App\Model\State;
use App\Model\City;
use App\Model\Language;
use App\Model\OTP;
use App\Model\Address_type;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class CommonController extends BaseController
{
  /*
 * get days
 */
  public function getDays(Request $request)
  {
    $result = DB::table("dropdown_managers")->where("dropdown_type","days")->where('status',ACTIVE)->orderBy("sort_order","ASC")->select("name","id")->get();
      return response()->json(['status'=>'success','data'=>$result]);
      die;
  } // end
  /* get newspapers */
  public function getNewspapers(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'language_id'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'];
      $vendorData = DB::table('users')->select('state_id','city_id')->where('id',$formData['user_id'])->first();
      $newpaper_count = DB::table('newspaper')->where('paper_type',1)->where('status',ACTIVE)->where('is_deleted',INACTIVE)->count();
      $magazine_count = DB::table('newspaper')->where('paper_type',2)->where('status',ACTIVE)->where('is_deleted',INACTIVE)->count();
        $result = DB::table("dropdown_managers as dm")
                  ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                  ->join('newspaper as np','dm.id','=','np.newspaper_id')
                  ->where("dm.dropdown_type","newspapers")
                  ->where('dm.status',ACTIVE)
                  ->where('dmd.language_id',$language_id)
                  //->where('np.state_id',$vendorData->state_id)
                  //->where('np.city_id',$vendorData->city_id)
                  //->whereRaw("find_in_set($vendorData->state_id,np.state_id)")
                  ->where('np.status',ACTIVE)
                  ->where('np.is_deleted',INACTIVE)
                  ->whereRaw("find_in_set($vendorData->city_id,np.city_id)")
                  ->orderBy("dm.name","ASC")
                  ->select("np.newspaper_id","dmd.name","np.day_price_type","np.paper_type","np.day_price")
                  ->get();
      if (count($result)) {
          foreach ($result as $key => $value) {
            $result[$key]->day_price = unserialize($value->day_price);
            // now change the day into string
            $i=1;
            if (!empty($result[$key]->day_price)) {
              foreach ($result[$key]->day_price as $key2 => $value2) {
                $value2 = json_decode(json_encode($value2));
                if (isset($value2->day)) {
                  $result[$key]->day_price[$key2]['day'] = (string)$value2->day;
                  $result[$key]->day_price[$key2]['price'] = (double)$value2->price;
                }
                $i++;
              }
            }
            // now change the day into string
          }
          $response['newpaper_count'] = $newpaper_count;
          $response['magazine_count'] = $magazine_count;
          $response['result'] = $result;
        return response()->json(['status'=>'success','data'=>$response]);
        die;
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end
  /* get states */
  public function getStates(Request $request)
  {
      $stateList = DB::table("states")->where('status',ACTIVE)->select("name","id")->get();
      return response()->json(['status'=>'success','data'=>$stateList]);
      die;
  } // end
  /* get city */
  public function getCity()
  {
    $cityList = [];
    $state_id = Input::get('state_id');
    if (isset($state_id) && $state_id > 0) {
      $cityList = DB::table("cities")->where('state_id',$state_id)->where('status',ACTIVE)->select("name","id")->get();
    }
    return response()->json(['status'=>'success','data'=>$cityList]);
    die;
  } // end
  /*
  * get address types like building, shop,chawl, Bungalow
  */
  public function getAddressTypes()
  {
    $result = array();
    $result  = DB::table("address_type")->select("name","id")->get();
    return response()->json(['status'=>'success','data'=>$result]);
    die;
  } // end
   /*
  * get languages
  */
  public function getLanguages()
  {
    $result = array();
    $result  = DB::table("languages")->select("title","id")->where("is_active",ACTIVE)->get();
    return response()->json(['status'=>'success','data'=>$result]);
    die;
  } // end

} // end CommonController class
