<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\Stop_newspaper_delivery;
use App\Model\Holiday;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class HolidaysController extends BaseController
{
  /*
  * add address
  */
  public function add(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'type'=> 'required',
        'caption'=> 'required',
        'from_date'=> 'required',
        'to_date'=> 'required',
      );
    if ( isset($formData['type']) && ($formData['type'] == 2)) {
      $validate['newspaper_id'] = "required";
    }
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj  = new Holiday;
      $obj->user_id = $formData['user_id'];
      $obj->type = $formData['type'];
      $obj->caption = $formData['caption'];
      $obj->from_date = $formData['from_date'];
      $obj->to_date = $formData['to_date'];
      if ( isset($formData['type']) && ($formData['type'] == 2)) {
        $obj->newspaper_id = $formData['newspaper_id'];
      }else {
        $obj->newspaper_id = 0;
      }
      $obj->total_leave = CustomHelper::countDays($formData['from_date'],$formData['to_date']);

      $obj->active = ACTIVE;
      $obj->save();
      if($obj){
        return Response::json(["status"=>"success","message"=>"Holiday added successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to add the record."]);
      }
    }
  } // end

  /*
  * get holiday for edit
  */
  public function get(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'holiday_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $query = Holiday::where('id',$formData['holiday_id'])
              ->where('user_id',$formData['user_id'])
              ->where('is_deleted','!=',ACTIVE)
              ->where('active', ACTIVE)
              ->first();
      $response = $query ?? array();
      return Response::json(["status"=>"success","data"=>$response]);
    }
  } // end
  /*
  * get holidays
  */
  public function getHolidays(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'type'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      if (isset($formData['type']) && $formData['type'] == 1) {
        $query = Holiday::where('type',1)
              ->where('is_deleted','!=',ACTIVE)
              ->where('active', ACTIVE)
              ->get();
      }else{
        $query = Holiday::where('type',$formData['type'])
              ->where('user_id',$formData['user_id'])
              ->where('is_deleted','!=',ACTIVE)
              ->where('active', ACTIVE)
              ->get();
      }
      if (!empty($query)) {
        if (isset($formData['type']) && $formData['type'] == 2) {
          $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
          foreach ($query as $key => $value) {
            $result = DB::table("dropdown_managers as dm")
                      ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                      ->where("dm.dropdown_type","newspapers")
                      ->where('dm.status',ACTIVE)
                      ->where('dm.id',$value->newspaper_id)
                      ->where('dmd.language_id',$language_id)
                      ->orderBy("dm.name","ASC")
                      ->select("dmd.name")
                      ->first();
            if (isset($result->name)) {
              $query[$key]->newspaper_name = $result->name;
            }
          }
        }
      }
      $response = $query ?? array();
      return Response::json(["status"=>"success","data"=>$response]);

    }
  } // end

  /*
  * update holiday
  */
  public function update(Request $request)
  {
    $formData       = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'holiday_id'=> 'required',
        'caption'=> 'required',
        'type'=> 'required',
        'from_date'=> 'required',
        'to_date'=> 'required',
      );
    if ( isset($formData['type']) && ($formData['type'] == 2)) {
      $validate['newspaper_id'] = "required";
    }
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj  = Holiday::findOrFail($formData['holiday_id']);
      $obj->user_id = $formData['user_id'];
      $obj->type = $formData['type'];
      $obj->caption = $formData['caption'];
      $obj->from_date = $formData['from_date'];
      $obj->to_date = $formData['to_date'];
      if ( isset($formData['type']) && ($formData['type'] == 2)) {
        $obj->newspaper_id = $formData['newspaper_id'];
      }else {
        $obj->newspaper_id = 0;
      }
      $obj->total_leave = CustomHelper::countDays($formData['from_date'],$formData['to_date']);

      $obj->active = ACTIVE;
      $obj->save();
      if($obj){
        return Response::json(["status"=>"success","message"=>"Holiday updated successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Failed to update the record."]);
      }
    }
  } // end

  public function delete(){
    $formData = Input::all();
    $message = array();
    $validate = array(
        'user_id'=> 'required',
        'holiday_id'=> 'required',
      );
    $validator = Validator::make(Input::all(),$validate,$message);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $holiday_id       = $formData['holiday_id'];
      $res = Holiday::where('id',$holiday_id)->where('user_id',$formData['user_id'])->update(array('is_deleted'=>ACTIVE));
      if ($res) {
        return Response::json(["status"=>"success","message"=>"Holiday deleted successfully."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Sorry, try later."]);
      }
    }
	} // end delete()

} // end HolidaysController class
