<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class LoginController extends BaseController
{
  public function email_login(Request $request)
  {
      $validator = Validator::make($request->all(), [
          'email' => 'required|string|email',
          'password'=> 'required'
      ]);
      if ($validator->fails()) {
        $message = "Please fill all required fields.";
        $message = $validator->errors()->getMessages();
        if (isset($message['email']) && !empty($message['email'])) {
          $message = $message['email'][0];
        }
        if (isset($message['password']) && !empty($message['password'])) {
          $message = $message['password'][0];
        }
        return Response::json(["status"=>"error","message"=>$message]);
      }

      $formData				=	Input::all();
      $loginData	=	User::where('email',$formData['email'])->where('user_role_id',VENDOR)->first();
      $credentials = $request->only('email', 'password');
      if(!empty($loginData)){
          if ($token = JWTAuth::attempt($credentials)){
            if(Auth::user()->is_verified == VERIFIED){
              if(Auth::user()->active == ACTIVE){
                if(Auth::user()->is_deleted == NOT_DELETE){
                  /*######## send OTP #########*/
        					$phone = $loginData->phone;
                  if (IS_DEFAULT_OTP == 1 || $phone==DEFAULT_MOB) {
                    $randOTP = DEFAULT_OTP;
                    $message =  'Welcome to '.Config::get('Site.title').', your login OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
                  }else{
                    $digits = 4;
          					$randOTP =  rand(pow(10, $digits-1), pow(10, $digits)-1);
                    $message =  'Welcome to '.Config::get('Site.title').', your login OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
                    CustomHelper::send_sms($phone,$message);
                  }
                  $otpData = array(
                    "user_id"=> $loginData->id,
                    "phone"=> $phone,
                    "otp"=> $randOTP,
                    "message"=> $message,
                    "status"=>INACTIVE,
                    "created_at"=>date("Y-m-d H:i:s")
                  );
                  DB::table('otp')->insert($otpData);

                  /*######## send OTP #########*/

                  return response()->json(['status'=>'success','data'=>$loginData,'message'=>'OTP sent.',"token"=>$token]);
                  die;
                }else{
                  return response()->json(['status'=>'error','message'=>trans("messages.login.account_deleted")]);
                  die;
                }
              }else{
                return response()->json(['status'=>'error','message'=>trans("messages.login.account_deactive")]);
                die;
              }
            }else{
              $validateString		=	Auth::user()->validate_string;
              $route_url      	=  	route('home.sendverifylinkagain',$validateString);
              $varify_link   		=   '<a style="color:blue" target="_blank" href='.$route_url.'>' .('click here') . '</a>';
              $verify_link      = trans("messages.login.not_verified").' '.$varify_link. ' to send verification link.';
              Auth::logout();
              return response()->json(['status'=>'error','message'=>$verify_link]);
              die;
            }
          }else{
            return response()->json(['status'=>'error','message'=>trans("messages.login.wrong_email_password_combination")]);
            die;
          }
       }else{
        Auth::logout();
        return response()->json(['status'=>'error','message'=>trans("messages.login.not_registered")]);
        die;
      }
  } // end

  // function to verify_otp
  public function login_verify_otp(Request $request)
  {
      $validator = Validator::make($request->all(), [
          'user_id'=> 'required',
          'otp'=> 'required',
      ]);
      if ($validator->fails()) {
        $message = "Please fill all required fields.";
        $message = $validator->errors()->getMessages();
        if (isset($message['user_id']) && !empty($message['user_id'])) {
          $message = $message['user_id'][0];
        }
        if (isset($message['otp']) && !empty($message['otp'])) {
          $message = $message['otp'][0];
        }
        return Response::json(["status"=>"error","message"=>$message]);
        //return response()->json($validator->errors());
      }
      $obj 		=	OTP::where("user_id",$request->user_id)->where("otp",$request->otp)->where("status",INACTIVE)->first();
      if ($obj) {
          /*######## send sms #########*/
          $userData = User::find($request->user_id);
          $userData->phone_verify = ACTIVE;
          $userData->save();

          $obj->status = ACTIVE;
          $obj->save();
          /*######## send sms #########*/
        return Response::json(["status"=>"success","message"=>"Logged in successfully.",'data'=>$userData]);
      }else {
        return Response::json(["status"=>"error","message"=>"Invalid OTP."]);
      }
  } // end

  // function to resend otp
  public function resend_otp(Request $request)
  {
      $formData = Input::all();
      $validator = Validator::make($request->all(), [
          'type'=> 'required',
          'data'=> 'required',

      ]);
      if ($validator->fails()) {
        $message = "Please fill all required fields.";
        $message = $validator->errors()->getMessages();
        if (isset($message['type']) && !empty($message['type'])) {
          $message = $message['type'][0];
        }
        if (isset($message['data']) && !empty($message['data'])) {
          $message = $message['data'][0];
        }
        return Response::json(["status"=>"error","message"=>$message]);
        //return response()->json($validator->errors());
      }
      $query 		=	User::query();
      if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'email') {
        $query->where('email',$formData['data']);
      }else if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'phone') {
        $query->where('phone',$formData['data']);
      }else if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'user_id') {
        $query->where('id',$formData['data']);
      }
      $userData = $query->where("user_role_id",VENDOR)->first();
      //pr($userData);die;
      if ($userData) {
        /*######## send OTP #########*/
        $phone = $userData->phone;
        $user_id = $userData->id;
        if (IS_DEFAULT_OTP == 1 || $phone==DEFAULT_MOB) {
          $randOTP = DEFAULT_OTP;
          $message =  'Welcome to '.Config::get('Site.title').', your resend OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
        }else{
          $digits = 4;
          $randOTP =  rand(pow(10, $digits-1), pow(10, $digits)-1);
          $message =  'Welcome to '.Config::get('Site.title').', your resend OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
          CustomHelper::send_sms($phone,$message);
        }
        $otpData = array(
          "user_id"=> $user_id,
          "phone"=> $phone,
          "otp"=> $randOTP,
          "message"=> $message,
          "status"=>INACTIVE,
          "created_at"=>date("Y-m-d H:i:s")
        );
        DB::table('otp')->insert($otpData);
        /*######## send OTP #########*/
        return Response::json(["status"=>"success","message"=>"OTP has been sent.",'data'=>$userData]);
      }else {
        return Response::json(["status"=>"error","message"=>"OTP can not be send."]);
      }
  } // end

  // function to verify otp
  public function verify_otp(Request $request)
  {
      $formData = Input::all();
      $validator = Validator::make($request->all(), [
          'type'=> 'required',
          'data'=> 'required',
          'otp'=> 'required',

      ]);
      if ($validator->fails()) {
        $message = "Please fill all required fields.";
        $message = $validator->errors()->getMessages();
        if (isset($message['type']) && !empty($message['type'])) {
          $message = $message['type'][0];
        }
        if (isset($message['data']) && !empty($message['data'])) {
          $message = $message['data'][0];
        }
        if (isset($message['otp']) && !empty($message['otp'])) {
          $message = $message['otp'][0];
        }
        return Response::json(["status"=>"error","message"=>$message]);
        //return response()->json($validator->errors());
      }
      $userData = array();
      $query 		=	OTP::query();
      if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'phone') {
        $query->where('phone',$formData['data']);
      }else if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'user_id') {
        $query->where('user_id',$formData['data']);
        $userData = User::find($formData['data']);
      }
      $obj = $query->where("status",INACTIVE)->where("otp",$formData['otp'])->orderBy('id','desc')->first();
      if ($obj) {
        /*######## update OTP #########*/
      OTP::where("status",INACTIVE)->where("otp",$formData['otp'])->orderBy('id','desc')->update(['status' => 1]);
        /*######## update OTP #########*/
      return Response::json(["status"=>"success","data"=>$userData,"message"=>"OTP has been successfully verified."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Invalid OTP."]);
      }
  } // end

  public function phone_login(Request $request)
  {
      $validator = Validator::make($request->all(), [
          'phone' => 'required'
      ]);
      if ($validator->fails()) {
          return response()->json($validator->errors());
      }

      $formData				=	Input::all();
      $loginData	=	User::where('phone',$formData['phone'])->where('user_role_id',VENDOR)->first();
      //pr($loginData);die;
      if(!empty($loginData)){
              if($loginData->active == ACTIVE){
                if($loginData->is_deleted == NOT_DELETE){
                  if($loginData->is_verified == NOT_IS_VERIFIED){
                    User::where('id',$loginData->id)->update(array('phone_verify'=>ACTIVE));
                    $loginData  = User::where('phone',$formData['phone'])->where('user_role_id',VENDOR)->first();
                  }
                  /*######## send OTP #########*/
        					$phone = $loginData->phone;
                  if (IS_DEFAULT_OTP == 1 || $phone==DEFAULT_MOB) {
                    $randOTP = DEFAULT_OTP;
                    $message =  'Welcome to '.Config::get('Site.title').', your login OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
                  }else{
                    $digits = 4;
          					$randOTP =  rand(pow(10, $digits-1), pow(10, $digits)-1);
                    $message =  'Welcome to '.Config::get('Site.title').', your login OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
                    CustomHelper::send_sms($phone,$message);
                  }
                  $otpData = array(
                    "user_id"=> $loginData->id,
                    "phone"=> $phone,
                    "otp"=> $randOTP,
                    "message"=> $message,
                    "status"=>INACTIVE,
                    "created_at"=>date("Y-m-d H:i:s")
                  );
                  DB::table('otp')->insert($otpData);
                  /*######## send OTP #########*/
                  $token = JWTAuth::fromUser($loginData);
                  return response()->json(['status'=>'success','data'=>$loginData,'message'=>'OTP has been sent.',"token"=>@$token]);
                  die;
                }else{
                  return response()->json(['status'=>'error','message'=>trans("messages.login.account_deleted")]);
                  die;
                }
              }else{
                return response()->json(['status'=>'error','message'=>trans("messages.login.account_deactive")]);
                die;
              }
       }else{
        Auth::logout();
        return response()->json(['status'=>'error','message'=>trans("Phone is not registered.")]);
        die;
      }
  } // end

  /**
   * Function is used to send email for forgot password process
   *
   * @param null
   *
   * @return url.
   */
  public function forgot_password(Request $request){

    // After 30 minute reset password link will be expired
    $expire_link_time	=	Carbon::now()->addMinute(30);
    $formData = Input::all();
    $validator = Validator::make($request->all(), [
        'type'=> 'required',
        'data'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $message = $validator->errors()->getMessages();
      if (isset($message['type']) && !empty($message['type'])) {
        $message = $message['type'][0];
      }
      if (isset($message['data']) && !empty($message['data'])) {
        $message = $message['data'][0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else{
      $query 		=	User::query();
      if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'email') {
        $query->where('email',$formData['data']);
        $email							=	$formData['data'];
      }else if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'phone') {
        $query->where('phone',$formData['data']);
      }
      $userDetail = $query->where("user_role_id",VENDOR)->first();
      //pr($userDetail);die;
      if(!empty($userDetail) && ($userDetail->user_role_id == VENDOR)){
        if($userDetail->is_deleted == INACTIVE ){
          if($userDetail->active == ACTIVE ){
            if($userDetail->is_verified == ACTIVE ){
              // forgot password using email
              if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'email') {
                $forgot_password_validate_string	= 	md5($userDetail->email);
                User::where('email',$email)->update(array('forgot_password_validate_string'=>$forgot_password_validate_string,'reset_password_link_time'=>$expire_link_time));

                $settingsEmail 		=  	Config::get('Site.email');
                $email 				=  	$userDetail->email;
                $username			=  	$userDetail->full_name;
                $full_name			=  	$userDetail->full_name;
                $route_url      	=  	route('User.reset_password',$forgot_password_validate_string);
                $varify_link   		=   $route_url;

                $emailActions		=	EmailAction::where('action','=','forgot_password')->get()->toArray();
                $emailTemplates		=	EmailTemplate::where('action','=','forgot_password')->get(array('name','subject','action','body'))->toArray();
                $cons = explode(',',$emailActions[0]['options']);
                $constants = array();

                foreach($cons as $key=>$val){
                  $constants[] = '{'.$val.'}';
                }
                $subject 			=  	$emailTemplates[0]['subject'];
                $rep_Array 			= 	array($full_name,$varify_link,$route_url);
                $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
                $this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
              }else if (isset($formData['type']) && !empty($formData['type']) && $formData['type'] == 'phone') {
                // forgot password using phone
                /*######## send OTP #########*/
                $phone = $userDetail->phone;
                $user_id = $userDetail->id;
                if (IS_DEFAULT_OTP == 1 || $phone==DEFAULT_MOB) {
                  $randOTP = DEFAULT_OTP;
                  $message =  'Welcome to '.Config::get('Site.title').', OTP for forgot password is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
                }else{
                  $digits = 4;
                  $randOTP =  rand(pow(10, $digits-1), pow(10, $digits)-1);
                  $message =  'Welcome to '.Config::get('Site.title').', OTP for forgot password is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
                  CustomHelper::send_sms($phone,$message);
                }
                $otpData = array(
                  "user_id"=> $user_id,
                  "phone"=> $phone,
                  "otp"=> $randOTP,
                  "message"=> $message,
                  "status"=>INACTIVE,
                  "created_at"=>date("Y-m-d H:i:s")
                );
                DB::table('otp')->insert($otpData);
                /*######## send OTP #########*/
                return Response::json(["status"=>"success","message"=>"OTP has been sent.","data"=>$userDetail]);
              }
              return Response::json(["status"=>"error","message"=>trans('messages.Login.password_send')]);
            }else{
              return Response::json(["status"=>"error","message"=>trans('messages.Login.account_not_verify')]);
            }
          }else{
            return Response::json(["status"=>"error","message"=>trans('messages.Login.account_disable')]);
          }
        }else{
          return Response::json(["status"=>"error","message"=>trans('messages.Login.account_deleted')]);
        }
      }else{
        return Response::json(["status"=>"error","message"=>trans('messages.Login.invalid_access')]);
      }
    }
  }// forgot_password()

  /**
	 * Function is used for save reset password
	 *
	 * @param $validate_string as validator string
	 *
	 * @return view page.
	 */
	public function reset_password(Request $request){
    $user_id = $request->user_id;
		$newPassword		=	Input::get('new_password');
		$messages = array(
    'new_password.required'         => 'Please enter new password.',
		);

		$validator = Validator::make(
			Input::all(),
			array(
				'user_id' 						=> 	'required',
				'new_password' 						=> 	'required|min:6',

			),$messages
		);
		$newPassword		=	Hash::make($newPassword);

		if ($validator->fails()){
      $message = "Please fill all required fields.";
      $message = $validator->errors()->getMessages();
      if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      if (isset($message['new_password']) && !empty($message['new_password'])) {
        $message = $message['new_password'][0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
		}else{
			$userInfo = User::where('id',$user_id)->first();

			User::where('id',$user_id)
				->update(array(
						'password'							=>	$newPassword,
						'forgot_password_validate_string'	=>	'',
						'reset_password_link_time'			=>	'',
				));
        $obj = OTP::where("status",INACTIVE)->where("user_id",$user_id)->orderBy('id','desc')->first();
        if ($obj) {
          /*######## update OTP #########*/
          OTP::where("status",INACTIVE)->where("user_id",$user_id)->orderBy('id','desc')->update(['status' => 1]);

          $message =  'Welcome to '.Config::get('Site.title').', Hi '.$userInfo->full_name.' your password has been successfully reset.';
          CustomHelper::send_sms($userInfo->phone,$message);
          $notificationData = array(
            "user_id"=> $user_id,
            "title"=> 'Password Reset',
            "description"=> $message,
            "status"=>ACTIVE,
            "created_at"=>date("Y-m-d H:i:s")
          );
          DB::table('notifications')->insert($notificationData);
          /*######## update OTP #########*/
          return Response::json(["status"=>"success","message"=>"Password successfully reset."]);
        }else {
          return Response::json(["status"=>"error","message"=>"Something went wrong."]);
        }
		}
	}// end reset_password()

} // end class
