<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\BankDetail;
use App\Model\VendorsNewspapers;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class NewspaperController extends BaseController
{
  public function updateNewspaper(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'newspaper_id'=> 'required',
        'day_price'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj = VendorsNewspapers::where('vendor_id',$formData['user_id'])->where('newspaper_id',$formData['newspaper_id'])->first();
      $day_price = json_decode($formData['day_price'],true);
      if (!empty($obj)) {
        $obj->day_price = serialize($day_price);
        //pr($obj);die;
        $obj->save();
        return Response::json(["status"=>"success","message"=>"Newpaper updated."]);
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
	}// end

} // end class
