<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use App\User;
use App\Model\OTP;
use JWTFactory;
use JWTAuth;
use App\libraries\CustomHelper;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class RegisterController extends BaseController
{
    // function to register
    public function register(Request $request)
    {
      $formData = Input::all();
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email|unique:users,email,NULL,id,is_deleted,0',
            'phone' => 'required|integer|unique:users,phone,NULL,id,is_deleted,0',
            'full_name' => 'required',
            'password'=> 'required',
            'newspaper_agency_name'=> 'required',
        ]);
        if ($validator->fails()) {
          $message = "Please fill all required fields.";
          $message = $validator->errors()->getMessages();
          if (isset($message['phone']) && !empty($message['phone'])) {
            $message = $message['phone'][0];
          }
          if (isset($message['email']) && !empty($message['email'])) {
            $message = $message['email'][0];
          }
          if (isset($message['full_name']) && !empty($message['full_name'])) {
            $message = $message['full_name'][0];
          }
          if (isset($message['newspaper_agency_name']) && !empty($message['newspaper_agency_name'])) {
            $message = $message['newspaper_agency_name'][0];
          }
          return Response::json(["status"=>"error","message"=>$message]);
          //return response()->json($validator->errors());
        }

        $fullName					=	Input::get('full_name');
        $fullName					=	strip_tags($fullName);
        $email						=	strip_tags(Input::get('email'));
        $slug             = $this->getSlug($fullName, 'slug','users',60);
        $obj 						  =	new User;
        $validateString				=	 md5(time() . Input::get('email'));
        $obj->validate_string	=	  $validateString;
        $obj->full_name 			=	ucwords($fullName);
        $obj->email 				  =	strip_tags(Input::get('email'));
        $obj->phone 				  =	strip_tags(Input::get('phone'));
        $obj->newspaper_agency_name 				  =	strip_tags(Input::get('newspaper_agency_name'));
        $obj->slug			 		  =	$slug;
        $obj->password	 			=	bcrypt($request->get('password'));
        // for social login
        $obj->provider		    =  	@$formData['provider'];
        $obj->provider_id		  =  	@$formData['provider_id'];
        $obj->image		        =  	@$formData['image'];

        $obj->user_role_id		=  	VENDOR;
        $obj->active				  =  	ACTIVE;
        $obj->is_verified			=  	ACTIVE;
        $obj->phone_verify	  =  	INACTIVE;
        $obj->is_deleted			=  	INACTIVE;
        $obj->save();

        if ($obj) {
          /*######## send OTP #########*/
          $phone = $obj->phone;
          if (IS_DEFAULT_OTP == 1 || $phone==DEFAULT_MOB) {
            $randOTP = DEFAULT_OTP;
            $message =  'Welcome to '.Config::get('Site.title').', your signup OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
          }else{
            $digits = 4;
            $randOTP =  rand(pow(10, $digits-1), pow(10, $digits)-1);
            $message =  'Welcome to '.Config::get('Site.title').', your signup OTP is '.$randOTP.'. Do not share this OTP to anyone for security reasons.';
            CustomHelper::send_sms($phone,$message);
          }
          $otpData = array(
            "user_id"=> $obj->id,
            "phone"=> $phone,
            "otp"=> $randOTP,
            "message"=> $message,
            "status"=>INACTIVE,
            "created_at"=>date("Y-m-d H:i:s")
          );
          DB::table('otp')->insert($otpData);
          /*######## send OTP #########*/
        }

        $userId					=	$obj->id;
        $encId					=	md5(time() . Input::get('email'));

        //mail email and password to new registered user
        $settingsEmail 			=	Config::get('Site.email');
        $full_name				   =	$fullName;
  			$validateStr 			=  $validateString;
  			$route_url      		=  	route('email_verify',$validateStr);
  			$link 					=   $route_url;
  			$click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

  			$emailActions			= 	EmailAction::where('action','=','account_verification')->get()->toArray();
  			$emailTemplates			= 	EmailTemplate::where('action','=','account_verification')
  											->get(array('name','subject','action','body'))->toArray();
  			$cons 					= 	explode(',',$emailActions[0]['options']);
  			$constants 				= 	array();

  			foreach($cons as $key => $val){
  				$constants[] 		= 	'{'.$val.'}';
  			}

  			$subject 				= 	$emailTemplates[0]['subject'];
  			$rep_Array 				= 	array($full_name,$click_link,$route_url);
  			$messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

  			//$mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
        $user = User::first();
        $token = JWTAuth::fromUser($user);
        return Response::json(["status"=>"success","message"=>"OTP has been sent.","data"=>$obj,'token'=>$token]);
    } // end

    // function to register
    public function verify_otp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id'=> 'required'
        ]);
        if ($validator->fails()) {
          $message = "Please fill all required fields.";
          $message = $validator->errors()->getMessages();
          if (isset($message['user_id']) && !empty($message['user_id'])) {
            $message = $message['user_id'][0];
          }
          return Response::json(["status"=>"error","message"=>$message]);
          //return response()->json($validator->errors());
        }
        $obj 		=	OTP::where("user_id",$request->user_id)->where("otp",$request->otp)->where("status",INACTIVE)->first();
        if ($obj) {
            /*######## send sms #########*/
            $userData = User::find($request->user_id);
            $userData->phone_verify = ACTIVE;
            $userData->save();

            $obj->status = ACTIVE;
            $obj->save();
            $phone = $obj->phone;
            $message =  'Welcome to '.Config::get('Site.title').', your mobile number has been verified successfully.';
            $dd = CustomHelper::send_sms($phone,$message);
            /*######## send sms #########*/
          return Response::json(["status"=>"success","message"=>"OTP verified successfully.",'data'=>$userData]);
        }else {
          return Response::json(["status"=>"error","message"=>"Invalid OTP."]);
        }
    } // end
}
