<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use JWTFactory;
use JWTAuth;
use App\User;
use App\Model\OTP;
use App\Model\BankDetail;
use App\Model\Address;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\libraries\CustomHelper;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;
use Carbon\Carbon;

class UserController extends BaseController
{

  public function __construct()
  {
      $this->middleware('jwt', ['except' => ['userPanDataSubmit','userBankDataSubmit','userProfileImageUpload']]);
  }

  public function accessrules(){
    date_default_timezone_set("Asia/Kolkata");
    header('Access-Control-Allow-Origin: *'); 
    header("Access-Control-Allow-Credentials: true");
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Max-Age: 1000');
    header('Access-Control-Allow-Headers: Authorization');
    header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
  }//End File


  public function updateLocation(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        'state' => 'required',
        'city'=> 'required',
        'pin_code'=> 'required|max:6|min:6',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $message = $validator->errors()->getMessages();
      if (isset($message['user_id']) && !empty($message['user_id'])) {
        $message = $message['user_id'][0];
      }
      if (isset($message['state']) && !empty($message['state'])) {
        $message = $message['state'][0];
      }
      if (isset($message['city']) && !empty($message['city'])) {
        $message = $message['city'][0];
      }
      if (isset($message['pin_code']) && !empty($message['pin_code'])) {
        $message = $message['pin_code'][0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj = User::findOrFail($formData['user_id']);
      if (!empty($obj)) {
        $obj->state_id = $formData['state'];
        $obj->city_id = $formData['city'];
        
        $address_obj = new Address;
        $address_obj->pin_code  = $formData['pin_code'];
        $address_obj->user_id  = $formData['user_id'];
        $address_obj->save();

        $obj->address_id = $address_obj->id;
        $obj->save();
        return Response::json(["status"=>"success","message"=>"Location added."]);
      }else {
        return Response::json(["status"=>"error","message"=>"No user found."]);
      }
    }
	}// end
     /*
     *  get vendor profile
     */
    public function getProfile(Request $request)
	{
		$formData				=	Input::all();
		$validator = Validator::make($request->all(), [
			'user_id'=> 'required'

		]);
		if ($validator->fails()) {
		  $message = "Please fill all required fields.";
		  $message = $validator->errors()->getMessages();
		  if (isset($message['user_id']) && !empty($message['user_id'])) {
			$message = $message['user_id'][0];
		  }
		  return Response::json(["status"=>"error","message"=>$message]);
		}else {
		  $obj = DB::table("users as u")
			->join('address as add','u.address_id','=','add.id')
			->select('u.*','add.id as address_id','add.address_type_id','add.address',
			'add.area','add.address_name','add.address','add.pin_code')
			->where('u.id',$formData['user_id'])
			->first();
		  if (!empty($obj)) {
			return Response::json(["status"=>"success","data"=>$obj]);
		  }else {
			return Response::json(["status"=>"error","message"=>"No user found."]);
		  }
		}
	}// end
    /*
     *  update vendor profile
     */
    public function updateProfile(Request $request)
	{
		$formData				=	Input::all();
		$validator = Validator::make($request->all(), [
			'user_id'=> 'required',
			'full_name'=>'required',
			'newspaper_agency_name'=>'required',
			'address'=>'required',
			'pin_code'=>'required',

		]);
		if ($validator->fails()) {
		  $message = "Please fill all required fields.";
		  $messages = $validator->errors()->getMessages();
		  $messages = array_reverse($messages);
		  foreach ($messages as $key => $value) {
			$message = $value[0];
		  }
		  return Response::json(["status"=>"error","message"=>$message]);
		}else {
		  $obj = User::findOrFail($formData['user_id']);
		  if (!empty($obj)) {
			$obj->full_name = $formData['full_name'];
			$obj->newspaper_agency_name = $formData['newspaper_agency_name'];
			$obj->save();
			if ($obj->address_id) {
			  $address_obj = Address::where('id',$obj->address_id)->first();
			}else {
			  $address_obj = new Address;
			}
			$address_obj->pin_code  = $formData['pin_code'];
			$address_obj->address  = $formData['address'];
			$address_obj->user_id  = $formData['user_id'];
			$address_obj->save();
			return Response::json(["status"=>"success","message"=>"Profile updated."]);
		  }else {
			return Response::json(["status"=>"error","message"=>"Try after some time."]);
		  }
		}
  }	 // end
  /*
     *  update vendor language
     */
    public function updateLanguage(Request $request)
	{
		$formData				=	Input::all();
		$validator = Validator::make($request->all(), [
			'user_id'=> 'required',
			'language_id'=>'required',

		]);
		if ($validator->fails()) {
		  $message = "Please fill all required fields.";
		  $messages = $validator->errors()->getMessages();
		  $messages = array_reverse($messages);
		  foreach ($messages as $key => $value) {
			$message = $value[0];
		  }
		  return Response::json(["status"=>"error","message"=>$message]);
		}else {
		  $obj = User::findOrFail($formData['user_id']);
		  if (!empty($obj)) {
			$obj->language_id = $formData['language_id'];
			$obj->save();
			return Response::json(["status"=>"success","message"=>"Language updated."]);
		  }else {
			return Response::json(["status"=>"error","message"=>"Try after some time."]);
		  }
		}
	}	 // end

  /*
   *  get vendor bank detail
   */
  public function getBankDetail(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
      'user_id'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
      $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj = BankDetail::where('user_id',$formData['user_id'])->first();
      if($obj){
        if (isset($obj->image) && !empty($obj->image)) {
          $obj->image = USER_PROFILE_IMAGE_URL.$obj->image;
        }
        return Response::json(["status"=>"success","data"=>$obj]);
      }else {
        return Response::json(["status"=>"error","message"=>"No Bank detail found."]);
      }
    }
  }	 // end
  /*
   *  update vendor profile
   */
  public function updateBankDetail(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
      'user_id'=> 'required',
      'account_holder_name'=>'required',
      'account_number'=>'required',
      'bank_name'=>'required',
      'branch_name'=>'required',
      'ifsc'=>'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj = User::findOrFail($formData['user_id']);
      if (!empty($obj)) {
        $BankDetail_obj = BankDetail::where('user_id',$obj->id)->first();
        if (empty($BankDetail_obj)) {
          $BankDetail_obj = new BankDetail;
        }
        $BankDetail_obj->account_holder_name  = $formData['account_holder_name'];
        $BankDetail_obj->account_number  = $formData['account_number'];
        $BankDetail_obj->bank_name  = $formData['bank_name'];
        $BankDetail_obj->branch_name  = $formData['branch_name'];
        $BankDetail_obj->ifsc  = $formData['ifsc'];
        $BankDetail_obj->user_id  = $formData['user_id'];

        if(input::hasFile('image')){

					$extension 	=	Input::file('image')->getClientOriginalExtension();
					$img_ext 	= 	explode(",",IMAGE_EXTENSION);

					if(in_array($extension,$img_ext)){
						$fileName			=	time().'-bank-image.'.$extension;

						if(Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)){
							$BankDetail_obj->image		=	$fileName;
						}
						//@unlink(USER_PROFILE_IMAGE_ROOT_PATH.$oldimage);
					}else{
            return Response::json(["status"=>"error","message"=>INVALID_IMAGE_EXTENSION]);
					}
				}

        $BankDetail_obj->save();
        return Response::json(["status"=>"success",'data'=>$BankDetail_obj,"message"=>"Bank detail updated."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Try after some time."]);
      }
    }
  }	 // end
  /*
   *  update vendor update-delivery-charge
   */
  public function updateDeliveryCharge(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
      'user_id'=> 'required',
      'delivery_charge'=>'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $obj = User::findOrFail($formData['user_id']);
      if (!empty($obj)) {
        $obj->delivery_charge  = $formData['delivery_charge'];
        $obj->save();
        return Response::json(["status"=>"success","message"=>"Delivery charge updated."]);
      }else {
        return Response::json(["status"=>"error","message"=>"Try after some time."]);
      }
    }
  }	 // end
  /**
   * Function for change password
   *
   * @param null
   *
   * @return view page.
   */
  public function change_password(){
    $formData = Input::all();
    $obj = User::findOrFail($formData['user_id']);
      $message	=	array(
              'current_password.required'     => 'Please enter current password.',
              'current_password.old_password'       => 'Current password is incorrect.',
              'new_password.required'         => 'Please enter new password.',
              'new_password.min'              => 'New password should have atleast 6 characters.',
          );
      $validate	=	array(
          'user_id' => 'required',
          'current_password'        => 'required|old_password:'.$obj->password,
          'new_password'            => 'required|different:current_password|min:6',
        );

      $validator = Validator::make(Input::all(),$validate,$message);

      if ($validator->fails()){
        $message = "Please fill all required fields.";
        $messages = $validator->errors()->getMessages();
        $messages = array_reverse($messages);
        foreach ($messages as $key => $value) {
          $message = $value[0];
        }
        return Response::json(["status"=>"error","message"=>$message]);
      }else {

        if (!empty($obj)) {
          $get_password				     =	strip_tags(Input::get('new_password'));
          $obj->password	 		    =  	Hash::make(Input::get('new_password'));
          $obj->save();
          return Response::json(["status"=>"success","message"=>"Password changed."]);
        }else {
          return Response::json(["status"=>"error","message"=>"Try after some time."]);
        }
      }
  } // end

  /* get newspapers */
  public function getNewspapers(Request $request)
  {
    $formData				=	Input::all();
    $validator = Validator::make($request->all(), [
        'user_id'=> 'required',
        //'language_id'=> 'required',

    ]);
    if ($validator->fails()) {
      $message = "Please fill all required fields.";
      $messages = $validator->errors()->getMessages();
      $messages = array_reverse($messages);
      foreach ($messages as $key => $value) {
        $message = $value[0];
      }
      return Response::json(["status"=>"error","message"=>$message]);
    }else {
      $response = array();
      $language_id = $formData['language_id'] ?? Config::get('default_language.language_code');
      $vendorData = DB::table('users')->select('state_id','city_id')->where('id',$formData['user_id'])->first();
      $newpaper_count = DB::table('vendors_newspapers')->where('paper_type',1)->where('vendor_id',$formData['user_id'])->where('status',ACTIVE)->where('is_deleted',INACTIVE)->count();
      $magazine_count = DB::table('vendors_newspapers')->where('paper_type',2)->where('vendor_id',$formData['user_id'])->where('status',ACTIVE)->where('is_deleted',INACTIVE)->count();

        $result = DB::table("dropdown_managers as dm")
                  ->join('dropdown_manager_descriptions as dmd','dm.id','=','dmd.parent_id')
                  ->join('vendors_newspapers as vnp','dm.id','=','vnp.newspaper_id')
                  ->where("dm.dropdown_type","newspapers")
                  ->where('dm.status',ACTIVE)
                  ->where('dmd.language_id',$language_id)
                  ->where('vnp.vendor_id',$formData['user_id'])
                  ->where('vnp.status',ACTIVE)
                  ->where('vnp.is_deleted',INACTIVE)
                  ->whereRaw("find_in_set($vendorData->city_id,vnp.city_id)")
                  ->orderBy("dm.name","ASC")
                  ->select("vnp.newspaper_id","dmd.name","vnp.day_price_type","vnp.paper_type","vnp.day_price")
                  ->get();
      if (count($result)) {
          foreach ($result as $key => $value) {
            $result[$key]->day_price = unserialize($value->day_price);
            // now change the day into string
            $i=1;
            if (!empty($result[$key]->day_price)) {
              foreach ($result[$key]->day_price as $key2 => $value2) {
                $value2 = json_decode(json_encode($value2));
                if (isset($value2->day)) {
                  $result[$key]->day_price[$key2]['day'] = (string)$value2->day;
                  $result[$key]->day_price[$key2]['price'] = (double)$value2->price;
                }
                $i++;
              }
            }
            // now change the day into string
          }
        $response['newpaper_count'] = $newpaper_count;
        $response['magazine_count'] = $magazine_count;
        $response['result'] = $result;
        return response()->json(['status'=>'success','data'=>$response]);
        die;
      }else {
        return Response::json(["status"=>"error","message"=>"No record found."]);
      }
    }
  } // end

    public function userProfileImageUpload(Request $request){
        $this->accessrules();
        $formData = $request->all();
        if(!empty($formData)){     
            $message  = array(
              'userAvatar.required'           => 'Please Select Avatar.',
            );
            $validate = array(
                'userAvatar'             => 'required',
            );
            $validator = Validator::make($formData,$validate,$message);
            if ($validator->fails()){
                $error_message = array("message"=>"Please upload image","status"=>500);
                echo json_encode($error_message);
                die();

            }else{
                $user_id = $formData['user_id'];
                $userinfo = DB::table('registerusers')->where('id',$user_id)->first();
                if($formData['userAvatar']){
                    $file = $formData['userAvatar'];
                    $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
                    $extension        = $file->getClientOriginalExtension();
                    $img_ext = explode(",",$img_ext);
                    if(in_array($extension,$img_ext)){
                        $fileName = time().'-users-11caps.'.$extension;
                        $dir_path = base_path().'/uploads/user/';
                        if($this->checkRemoteFile($dir_path.$userinfo->image)){
                            unlink($dir_path.$userinfo->image);
                        }
                        if($file->move($dir_path, $fileName)){
                            $userdata['image'] = $fileName;
                        }
                        
                        DB::table('registerusers')->where('id',$user_id)->update($userdata);
                        $success_message = array("message"=>"Image upload successfully","status"=>200);
                        echo json_encode($success_message);
                        die();             
                    }
                    else {
                        $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                        echo json_encode($error_message);
                        die();
                    }                
                }
            }   
        } else {
            $error_message = array("message"=>"Please upload image.!","status"=>500);
            echo json_encode($error_message);
            die();
        }
    }

    public function userPanDataSubmit(Request $request){
        $this->accessrules();
        $formData = $request->all();
        if(!empty($formData)){     
            $message  = array(
              'pan_name.required'           => 'Please enter name.',
              'pan_number.required'         => 'Please enter pan number.',
              'pan_image.required'          => 'Please upload pan image'
            );
            $validate = array(
                'pan_name'             => 'required',
                'pan_number'           => 'required',
                'pan_image'            => 'required'
            );
            $validator = Validator::make($formData,$validate,$message);
            if ($validator->fails()){
                $error_message = array("message"=>"Please fill all required fields.!","status"=>500);
                echo json_encode($error_message);
                die();

            }else{
                $user_id = $formData['user_id'];
                DB::table('pancard')->where('userid', $user_id)->delete();
               
                $pan_data=$query =DB::table('registerusers')->where('mobile_verify','1')
                ->where('email_verify','1')
                ->where('id','=',$user_id)
                ->select('registerusers.email','registerusers.mobile_verify','registerusers.username','registerusers.email_verify')->first(); 

              if(isset($pan_data) && !empty($pan_data)){
                  if($formData['pan_image']){
                      $file = $formData['pan_image'];
                      $img_ext='jpeg,jpg,png,JPEG,JPG,PNG'; 
                      $extension = $file->getClientOriginalExtension();
                      $img_ext = explode(",",$img_ext);
                      if(in_array($extension,$img_ext)){
                          $fileName = time().'-pancard-image.'.$extension;
                          $dir_path = PAN_IMAGE_ROOT_PATH;
                          if($file->move($dir_path, $fileName)){
                              $userdata['image'] = $fileName;
                          }
                      }
                      else {
                          $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                          echo json_encode($error_message);
                          die();
                      }

                  } 
                  else {
                      $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                      echo json_encode($error_message);
                      die();
                  }

                  $userdata['pan_name']=$formData['pan_name'];
                  $userdata['pan_number']=$formData['pan_number'];
                  $userdata['status']=0;
                  $userdata['userid']=$user_id;

                  DB::table('pancard')->insert($userdata);

                  $pan_verify['pan_verify']=0;  
                  DB::table('registerusers')->where('id', $user_id)->update($pan_verify);
                  $success_message = array("message"=>"Pan Verify Request Submit!","status"=>200);
                  echo json_encode($success_message);
                  die();
   
              } else {
                  $error_message = array("message"=>"Please Verify Email Id And Mobile No.!","status"=>500);
                  echo json_encode($error_message);
                  die();
              }//End
          }   
        } else {
            return Redirect::to(action('web\MoreController@verify_detail'));
        }//End Function
    }//End Function


    public function userBankDataSubmit(Request $request){
        $this->accessrules();
        $formData = $request->all();
        if(!empty($formData)){     
            $message  = array(
              'accno.required'           => 'Please enter A/C no.',
              'ifsc.required'            => 'Please enter ifsc no.',
              'bankname.required'        => 'Please enter bank name.',
              'bank_image.required'      => 'Please upload passbook image'
            );
            $validate = array(
                'accno'             => 'required',
                'ifsc'           => 'required',
                'bankname'            => 'required',
                'bank_image'    => 'required'
            );
            $validator = Validator::make($formData,$validate,$message);
            if ($validator->fails()){
                $error_message = array("message"=>"Please fill all required fields.!","status"=>500);
                echo json_encode($error_message);
                die();

            }else{
                $user_id = $formData['user_id'];
                DB::table('bank')->where('userid', $user_id)->delete();
                
                $bank_data=$query =DB::table('registerusers')
                                        ->where('mobile_verify','1')
                                        ->where('email_verify','1')
                                        ->where('id','=',$user_id)
                                        ->select('registerusers.email','registerusers.username')
                                        ->first(); 

                if(isset($bank_data) && !empty($bank_data)){
                    if($formData['bank_image']){
                        $file = $formData['bank_image'];
                        $img_ext='jpeg,jpg,png,JPEG,JPG,PNG'; 
                        $extension = $file->getClientOriginalExtension();
                        $img_ext = explode(",",$img_ext);
                        if(in_array($extension,$img_ext)){
                            $fileName = time().'-bank-image.'.$extension;
                            $dir_path = BANK_IMAGE_ROOT_PATH;
                            if($file->move($dir_path, $fileName)){
                                $userdata['image'] = $fileName;
                            }
                        }
                        else {
                            $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                            echo json_encode($error_message);
                            die();
                        }

                    } 
                    else {
                        $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                        echo json_encode($error_message);
                        die();
                    }

                    $userdata['ac_holder_name'] = $formData['ac_holder_name'];
                    $userdata['accno']=$formData['accno'];
                    $userdata['ifsc']=$formData['ifsc'];
                    $userdata['status']=0;
                    $userdata['userid']=$user_id;
                    $userdata['bankname']=$formData['bankname'];

                    DB::table('bank')->insert($userdata);

                    $bank_verify['bank_verify']=0;  
                    DB::table('registerusers')->where('id', $user_id)->update($bank_verify);
                    $success_message = array("message"=>"Pan Verify Request Submit!","status"=>200);
                    echo json_encode($success_message);
                    die();
     
                } else {
                    $error_message = array("message"=>"Please Verify Email Id And Mobile No.!","status"=>500);
                    echo json_encode($error_message);
                    die();
                }//End
          }   
        } else {
            return Redirect::to(action('web\MoreController@verify_detail'));
        }//End Function
    }//End Function

    function checkRemoteFile($url) {
        $url = str_replace(' ', '%20', $url);
        $file_headers = @get_headers($url);
        if (strpos($file_headers[0], "200 OK") > 0) {
           return true;
        } else {
          return false;
        }
    }


} // end class
