<?php
namespace App\Http\Controllers;
use DB;
use Session;
use bcrypt;
use Config;
use Redirect;
use Hash;
use Mail;
use App\global_constants;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
class BasketBallController extends Controller {
    public function accessrules(){
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Credentials: true");
        header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
        header('Access-Control-Max-Age: 1000');
        header('Access-Control-Allow-Headers: Authorization');
        header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
    }

    public static function genrateToken() {
        return ENTITY_SPORT_TOKEN_BASKETBALL;
    }

    public static function getMatches(){
        $token = BasketBallController::genrateToken();
        // echo ENTITY_SPORT_API_URL."basketball/matches/?token=".$token."&status=1&pre_squad=true"; exit;
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => ENTITY_SPORT_API_URL_BASETBALL."/matches/?token=".$token."&status=1&pre_squad=true",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cache-Control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $result = json_decode($response);
            // print_r($result); exit;
            if($result->status=="ok") {
                $response = $result->response;
                $data = $response->items;
                return $data;
            }
        }
    }

    public static function get_live_score_data($matchkey,$comp_id) {
    $token = BasketBallController::genrateToken();
      $curl = curl_init();



      $url = ENTITY_SPORT_API_URL_BASETBALL."/matches/".$matchkey."/scorecard?token=".$token."";
      // echo $url; exit;
      curl_setopt_array($curl, array(
        CURLOPT_URL => ENTITY_SPORT_API_URL_BASETBALL."/matches/".$matchkey."/scorecard?token=".$token."",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "Cache-Control: no-cache",
          "Postman-Token: cc748f1a-a898-463c-900c-47e74ac7b2c4"
        ),
      ));

      $response = curl_exec($curl);
      $err = curl_error($curl);

      curl_close($curl);
      if ($err) {
        echo "cURL Error #:" . $err; exit;
      } else {
        $result = json_decode($response);
        if($result->status=='ok') {
          $response = $result->response;
          return $response;
        }
      }
    }


    public static function get_match_squad($match_id, $comp_id) {
        $token = BasketBallController::genrateToken();
        $curl = curl_init();
// echo ENTITY_SPORT_API_URL."basketball/matches/".$match_id."/fantasysquad?token=".$token."&status=1&per_page=20&=&paged=1";
        curl_setopt_array($curl, array(
            CURLOPT_URL => ENTITY_SPORT_API_URL_BASETBALL."/matches/".$match_id."/fantasysquad?token=".$token."&status=1&per_page=20&=&paged=1",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cache-Control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $result = json_decode($response);
            if($result->status=="ok") {
                $response = $result->response;
                return $response;
            }
        }
    }

    public static function get_match_details($match_id) {
        $token = BasketBallController::genrateToken();
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => ENTITY_SPORT_API_URL_BASETBALL."/matches/".$match_id."/info?token=".$token,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cache-Control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $result = json_decode($response);
            if($result->status=="ok") {
                $response = $result->response;
                return $response;
            }
        }
    }

    public static function get_match_playing_players($api_unique_id) {
        $token = BasketBallController::genrateToken();
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => ENTITY_SPORT_API_URL_BASETBALL."/matches/".$api_unique_id."/info?token=".$token."",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cache-Control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $result = json_decode($response);
            if($result->status=="ok" && isset($result->response->items->lineup) && !empty($result->response->items->lineup)) {
                $response = $result->response->items->lineup;
                $playing_players = array();
                if(isset($response->players->home) && isset($response->players->away)) {
                    $teama_players = $response->players->home;
                    $teamb_players = $response->players->away;
                    $players = array_merge($teama_players, $teamb_players);
                    foreach ($players as $player) {
                        $playing_players[] = $player->pid;
                    }
                }
                return $playing_players;
            }
        }
        return [];
    }

    public static function get_match_score($match_id) {
        $token = BasketBallController::genrateToken();
        // echo ENTITY_SPORT_API_URL."basketball/matches/".$match_id."/fantasy?token=".$token;exit;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => ENTITY_SPORT_API_URL_BASETBALL."/matches/".$match_id."/fantasy?token=".$token,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cache-Control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $result = json_decode($response);
            if(@$result->status=="ok") {
                $response = $result->response;
                return $response;
            }
        }
    }

}
