<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use App\Model\Dealer;
use App\Model\User;
use App\Model\City;
use App\Model\Media;
use App\Model\Slider;
use App\Model\Testimonial;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\CarDetail;
use App\Model\Contract;
use App\libraries\CustomHelper;
use mjanssen\BreadcrumbsBundle\Breadcrumbs;
use Carbon\Carbon;
use App\Services\Input;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Yajra\DataTables\Facades\DataTables;
/**
 * Dealer  Controller
 *
 * Add your methods in the class below
 *
 * This file will render views\pages
 */


class DealerController extends BaseController {
protected $guard = 'dealers';
  /*
  * Function to return view of login
  */
  public function login()
  {
      return view('pages/dealer_login');
  } // end login()


   /**
   * Method for used login of registered user
   *
   * @param null
   *
   * @return null
   */
   public function dealerLogin(){
   $formData				=	Input::all();
   $loginData	=	Dealer::where('email',$formData['email'])->where('user_role_id',DEALER)->first();
   //pr(Auth::guard('dealers')->user());die;
   if(!empty($loginData)){
     if(Auth::guard('dealers')->check()){
       if(Auth::guard('dealers')->user()->user_role_id == DEALER){
         return response()->json(['status'=>'error','message'=>trans("messages.login.ALREADY_LOGIN")]);
         return Redirect::route("home");
         die;
       }else{
         Auth::guard('dealers')->user()->logout();
         return response()->json(['status'=>'error','message'=>trans("messages.login.INVALID_ACCESS")]);
         return Redirect::route("home");
         die;
       }
     }else{
       $userdata = array(
         'email' 		=> Input::get('email'),
         'password' 		=> Input::get('password'),
       );
       //pr($userdata);die;
       if (Auth::guard('dealers')->attempt($userdata)){
         if(Auth::guard('dealers')->user()->is_verified == VERIFIED){
           if(Auth::guard('dealers')->user()->active == ACTIVE){
             if(Auth::guard('dealers')->user()->is_deleted == NOT_DELETE){
               if(Auth::guard('dealers')->user()->user_role_id == DEALER){
                 if(isset($formData['remember']) && !empty($formData['remember'])){
                   $successmessage = trans("messages.global.hello") .'<strong>' .' ' .ucfirst(Auth::guard('dealers')->user()->name).'</strong>,'. trans("messages.login.logged_in_success");
                   Session::flash('flash_notice',$successmessage);
                   return response()->json(['status'=>'success','redirect_url'=>route("dealer_dashboard"),trans("messages.login.logged_in_success")])->withCookie(cookie('email_dealer', $formData['email'], 45000))->withCookie(cookie('remember_dealer', $formData['remember'], 45000));

                   return Redirect::route("dealer_dashboard");
                   die;
                 }else{
                   $successmessage = trans("messages.global.hello") .'<strong>' .' ' .ucfirst(Auth::guard('dealers')->user()->name).'</strong>,'. trans("messages.login.logged_in_success");
                   Session::flash('flash_notice',$successmessage);
                   return response()->json(['status'=>'success','redirect_url'=>route("dealer_dashboard"),trans("messages.login.logged_in_success")])->withCookie(cookie('email_dealer', $formData['email'], -45000))->withCookie(cookie('remember_dealer', '', -45000));
                   return Redirect::route("dealer_dashboard");
                   die;
                 }
               }else{
                 if(Auth::guard('dealers')->check()){
                   Auth::guard('dealers')->user()->logout();
                 }
                 return response()->json(['status'=>'error','message'=>trans("messages.login.INVALID_ACCESS")]);
                 return Redirect::route("home");
                 die;
               }

             }else{
               if(Auth::guard('dealers')->check()){
                 Auth::guard('dealers')->user()->logout();
               }
               return response()->json(['status'=>'error','message'=>trans("messages.login.account_deleted")]);
               die;
             }
           }else{
             if(Auth::guard('dealers')->check()){
               Auth::guard('dealers')->user()->logout();
             }
             return response()->json(['status'=>'error','message'=>trans("messages.login.account_deactive")]);
             die;
           }
         }else{
           $validateString		=	Auth::guard('dealers')->user()->validate_string;
           $route_url      	=  	route('home.sendverifylinkagain',$validateString);
           $varify_link   		=   '<a style="color:blue" target="_blank" href='.$route_url.'>' .('click here') . '</a>';
           $verify_link      = trans("messages.login.not_verified").' '.$varify_link. ' to send verification link.';
           Auth::guard('dealers')->user()->logout();
           return response()->json(['status'=>'error','message'=>$verify_link]);
         //  return response()->json(['status'=>'error','message'=>trans("messages.login.not_verified"),'link'=>$varify_link]);
           die;
         }
       }else{
         return response()->json(['status'=>'error','message'=>trans("messages.login.wrong_email_password_combination")]);
         die;
       }
     }
    }else{
      if(Auth::guard('dealers')->check()){
        Auth::guard('dealers')->user()->logout();
      }
     return response()->json(['status'=>'error','message'=>trans("messages.login.not_registered")]);
     return Redirect::route("home");
     die;
   }
   }// end login()

   /**
   * Method for used to render dealer dashboard
   *
   * @param null
   *
   * @return null
   */
   public function dealer_dashboard(){
      return view('pages/dealer/dealer_dashboard');
   } // end dealer_dashboard()
   /**
   * Method for used to render dealer dealer_account
   *
   * @param null
   *
   * @return null
   */
   public function dealer_account(){
      $dealerDetails = Auth::guard('dealers')->user();
      $cityList = [];
      $old_state_id = Input::Old('state_id');
      if (isset($old_state_id) && $old_state_id > 0) {
        $cityList = City::where('state_id',Input::Old('state_id'))->where('status',ACTIVE)->pluck('name','id')->toArray();
      }else{
        $cityList = City::where('state_id',$dealerDetails['state_id'])->where('status',ACTIVE)->pluck('name','id')->toArray();
      }
      return view('pages/dealer/dealer_account',compact('cityList','dealerDetails'));
   } // end dealer_account()

   /**
 * Function for update dealer profile
 *
 * @param null
 *
 * @return view page.
 */
public function updateProfile(){

  $formData	=	Input::all();
  $dealerDetails = Auth::guard('dealers')->user();
  $userId		=	$dealerDetails->id;
  if(!empty($formData)){

    $message	=	array(
          'image.max'						               =>	MAX_IMAGE_SIZE,
          'name.required'                      => 'Please enter name.',
          'name.regex'                         => 'Name should have alphabets only.',
          'email.required'                     => 'Please enter email.',
          'email.email'                        => 'Please enter a valid email.',
          'email.unique'                       => 'This email is already used, try another.',
          'dealer_phone_number.required'       => 'Please enter phone number.',
          'dealer_phone_number.digits_between' => 'Phone number should be 5 to 11 digits.',
          'dealer_phone_number.unique'         => 'This phone number is already used, try another.',
          'dealer_brand.required'              => 'Please select brand.',
          'dealer_principal_name.required'     => 'Please enter principal name.',
          'dealer_main_contact_name.required'  => 'Please enter main contact name.',
          'dealer_main_contact_name.required'  => 'Please enter main contact name.',
          'dealer_post_code.required'          => 'Please enter postal code.',
          'dealer_street_number.required'      => 'Please enter street number.',
          'dealer_street_name.required'        => 'Please enter street name.',
          'state_id.required'                  => 'Please select state.',
          'city_id.required'                   => 'Please select city.',
        );
      $validate	=	array(
          'name'			                  =>	'required|regex:/^[\pL\s\-]+$/u',
          'email' 				              =>	'required|email|unique:dealers,email,'.$userId,
          'dealer_phone_number'					=>	'required|digits_between:5,11|unique:dealers,dealer_phone_number,'.$userId,
          'gender'				              =>	'required',
          'dealer_brand'				        =>	'required',
          'dealer_principal_name'				=>	'required',
          'dealer_main_contact_name'		=>	'required',
          'dealer_post_code'				    =>	'required',
          'dealer_street_number'				=>	'required',
          'dealer_street_name'				  =>	'required',
          'state_id'				            =>	'required',
          'city_id'				              =>	'required',
          //'image'					  =>	'required|max:2048|mimes:'.IMAGE_EXTENSION,
     );

    $validator = Validator::make(Input::all(),$validate,$message);

    if ($validator->fails()){
       return Redirect::back()->withErrors($validator)->withInput();
    }else{

      $obj 						=	Dealer::findOrFail($userId);
      $oldimage					=	$obj['image'];
      //$obj->email 				        =	strip_tags(Input::get('email'));
      $obj->name					         =	strip_tags(Input::get('name'));
      $obj->dealer_phone_number	   =	strip_tags(Input::get('dealer_phone_number'));
      $obj->dealer_brand       =	strip_tags(Input::get('dealer_brand'));
      $obj->dealer_principal_name       =	strip_tags(Input::get('dealer_principal_name'));
      $obj->dealer_main_contact_name       =	strip_tags(Input::get('dealer_main_contact_name'));
      $obj->dealer_post_code          =	strip_tags(Input::get('dealer_post_code'));
      $obj->dealer_street_name          =	strip_tags(Input::get('dealer_street_name'));
      $obj->dealer_street_number          =	strip_tags(Input::get('dealer_street_number'));
      $obj->state_id          =	strip_tags(Input::get('state_id'));
      $obj->city_id          =	strip_tags(Input::get('city_id'));
      $obj->gender				        =	strip_tags(!empty(Input::get('gender')) ? Input::get('gender') : ZERO);

      if(input::hasFile('image')){

        $extension 	=	Input::file('image')->getClientOriginalExtension();
        $img_ext 	= 	explode(",",IMAGE_EXTENSION);

        if(in_array($extension,$img_ext)){
          $fileName			=	time().'-user-image.'.$extension;

          if(Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)){
            $obj->image		=	$fileName;
          }
          //@unlink(USER_PROFILE_IMAGE_ROOT_PATH.$oldimage);
        }
        else{
          Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
          return Redirect::back();
        }
      }


      $obj->save();

      Session::flash('flash_notices',  trans("Profile updated successfully."));
      return Redirect::route("dealer_dashboard");
    }
  }
}// end updateProfile()


   /**
   * Method for used to render dealer_delivery
   *
   * @param null
   *
   * @return null
   */
   public function dealer_delivery(){
     $current = Carbon::now();
    // add 1 days to the current time
    $next24hours = $current->addDays(1);
    $results = Contract::where('payment_status', ACTIVE)->where('contract_complete_status',ACTIVE)->where('dealer_id', Auth::guard('dealers')->user()->id)->where('contract_estimated_delivery_date', '<=', strtotime($next24hours))->orderBy('contract_date','desc')->get();

    //pr($results);die;
      return view('pages/dealer/dealer_delivery',compact('results'));
   } // end dealer_delivery()

   /**
   * Method for used to render dealer_offer_on_cars
   *
   * @param null
   *
   * @return null
   */
   public function offer_on_cars(){
      $results  = DB::table('car_detail as cd')
  					->select('cd.*','cmd.car_model_name','dm.name as car_make_name','cmd.model_year')
            ->leftJoin('dealers as dl', 'cd.dealer_id', '=', 'dl.id')
            ->leftJoin('car_make as cmk', 'cd.car_make_id', '=', 'cmk.car_make_id')
            ->leftJoin('car_model as cmd', 'cd.car_model_id', '=', 'cmd.car_model_id')
            ->leftJoin('dropdown_managers as dm', 'cmk.car_make_brand', '=', 'dm.id')
  					->where('cd.sold_status', INACTIVE)
            ->where('dealer_id', Auth::guard('dealers')->user()->id)
  					->where('cd.discount_end_date', '>=', strtotime("now"))
            ->get();
      return view('pages/dealer/dealer_offer_on_cars',compact('results'));
   } // end offer_on_cars()

   /**
   * Method for used to render dealer_offer_expire_soon
   *
   * @param null
   *
   * @return null
   */
   public function offer_expire_soon(){
     $results  = DB::table('car_detail as cd')
          ->select('cd.*','cmd.car_model_name','dm.name as car_make_name','cmd.model_year')
           ->leftJoin('dealers as dl', 'cd.dealer_id', '=', 'dl.id')
           ->leftJoin('car_make as cmk', 'cd.car_make_id', '=', 'cmk.car_make_id')
           ->leftJoin('car_model as cmd', 'cd.car_model_id', '=', 'cmd.car_model_id')
           ->leftJoin('dropdown_managers as dm', 'cmk.car_make_brand', '=', 'dm.id')
          ->where('cd.sold_status', INACTIVE)
           ->where('dealer_id', Auth::guard('dealers')->user()->id)
          ->where('cd.discount_end_date', '>=', strtotime("now"))
           ->get();
      return view('pages/dealer/dealer_offer_expire_soon',compact('results'));
   } // end offer_expire_soon()

   /**
   * Method for used to render dealer_payment_recived
   *
   * @param null
   *
   * @return null
   */
   public function dealer_payment_recived(){
      $results = Contract::where('payment_status', ACTIVE)->where('contract_complete_status', '!=',INACTIVE)->where('created_at', '>=', Carbon::now()->subDay())->orderBy('contract_date','desc')->get();
      return view('pages/dealer/dealer_payment_recived',compact('results'));
   } // end dealer_payment_recived()

   /**
   * Method for used to render customers_review
   *
   * @param null
   *
   * @return null
   */
   public function customers_review(){
      return view('pages/dealer/customers_review');
   } // end customers_review()

   /**
   * Method for get all booker cars of logged in dealer
   *
   * @param null
   *
   * @return null
   */
   public function booked_cars(){
      $model = Contract::where('payment_status', ACTIVE)->where('contract_complete_status','!=',INACTIVE)->where('contract_complete_status','!=',THREE)->where('dealer_id', Auth::guard('dealers')->user()->id)->orderBy('contract_date','desc')->get();
      return view('pages/dealer/booked_cars',compact('model'));
   } // end booked_car()

   /**
  * Function for  car to change status delivered
  *
  * @param $Id as id of car make
  * @param $Status as status of car
  *
  * @return redirect page.
  */
 public function delivered($contractId = 0,$dealerId=0,$carId, $status = 0){
   //echo $contractId;die;
   if ($contractId > 0 && $dealerId > 0 && $carId > 0 && $status == TWO) {
     $contactData = Contract::where('contract_id', $contractId)->first();
     if (!empty($contactData)) {
       CarDetail::where('id', '=', $carId)->where('dealer_id', '=', $dealerId)->update(array('sold_status' => ACTIVE));
       Contract::where('contract_id', '=', $contractId)->where('dealer_id', '=', $dealerId)->update(array('contract_complete_status' => TWO,'contract_actual_delivery_date'=>strtotime(date('Y-m-d H:i:s'))));

       /*###################### Send mail to User, Dealer, Admin #######################*/
       $emails = array();
       $user_email = $contactData->email;
       array_push($emails,$user_email);
       $dealerData = unserialize($contactData->dealer_data);
       $dealerEmail = '';
       if (!empty($dealerData)) {
         $dealer_email = $dealerData->email;
         array_push($emails,$dealer_email);
       }
       $order_id = $contactData->order_id;
       $delivery_validate_string	= 	md5($user_email).'-'.time();
       Contract::where('contract_id',$contractId)->update(array('delivery_validate_string'=>$delivery_validate_string));

       $settingsEmail 		=  	Config::get('Site.email');
       array_push($emails,$settingsEmail);

       $full_name			=  	$contactData->first_name;

       $emailActions		=	EmailAction::where('action','=','car_delivered')->get()->toArray();
       $emailTemplates		=	EmailTemplate::where('action','=','car_delivered')->get(array('name','subject','action','body'))->toArray();
       $cons = explode(',',$emailActions[0]['options']);
       $constants = array();

       foreach($cons as $key=>$val){
         $constants[] = '{'.$val.'}';
       }
       $subject 			=  	isset($full_name) && !empty($full_name) ? $full_name.', your order '.$order_id.' delivered successfully' : $emailTemplates[0]['subject'];
       $rep_Array 			= 	array($full_name,$order_id);
       $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

       foreach ($emails as $email_key => $email_value) {
         $this->sendMail($email_value,$full_name,$subject,$messageBody,$settingsEmail);
       }
       /*###################### Send mail to User, Dealer, Admin #######################*/

       Session::flash('flash_notices', trans("Car has been successfully marked as delivered."));
       return Redirect::route("Dealer.booked_cars");
     }else {
       Session::flash('errorss', trans("No contract found."));
       return Redirect::route("Dealer.booked_cars");
     }

   }else {
     Session::flash('errorss', trans("Something went worng."));
     return Redirect::route("Dealer.booked_cars");
   }

 }// end delivered()

   /**
    * Function to verify user if not verified
    *
    * @param $encId as validate String
    *
    * @return void()
    */
     public function send_verifylink_again($encId = null) {
     if (!empty($encId)) {
       $userInfo		=	User::where('validate_string',$encId)->first();
       if (!empty($userInfo)) {
         $validateString =  $userInfo->validate_string;
                 $full_name 	=	$userInfo->full_name;
                 $email 		= 	$userInfo->email;
         /*Send mail to user for resend verification mail */
         $settingsEmail 			=	Config::get('Site.email');
         $full_name				=	$full_name;
         $validateStr 			=  $validateString;
         $route_url      		=  	route('email_verify',$validateStr);
         $link 					=   $route_url;
         $click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

         $emailActions			= 	EmailAction::where('action','=','resend_verification_link')->get()->toArray();

         $emailTemplates			= 	EmailTemplate::where('action','=','resend_verification_link')
                         ->get(array('name','subject','action','body'))->toArray();

         $cons 					= 	explode(',',$emailActions[0]['options']);

         $constants 				= 	array();

         foreach($cons as $key => $val){
           $constants[] 		= 	'{'.$val.'}';
         }

         $subject 				= 	$emailTemplates[0]['subject'];
         $rep_Array 				= 	array($full_name,$click_link,$route_url);
         $messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

         $mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
         Session::flash('flash_notice',trans("Email verification link has been sent on your email address."));
         return Redirect::route("home");
         /*Send mail to user for resend verification mail */
       }else{
         Session::flash('flash_notice',trans("messages.Login.logout"));
         return Redirect::route("home");
       }
         }
   }
 /**
 * Function for logout admin users
 *
 * @param null
 *
 * @return rerirect page.
 */
	public function logout(){
    //echo 224;die;
    if(Auth::guard('dealers')->user()){
      $successmessage = trans("Hello") .'<strong>' .' ' .ucfirst(Auth::guard('dealers')->user()->name).'</strong>,'. trans(" you are logged out now.");
    //  Auth::guard('dealers')->user()->logout();
       Auth::logout();
      Session::flush();
      Session::regenerate();
      Session::flash('flash_notice',$successmessage);
    }
    return Redirect::route("dealer.login");
	}//endLogout()

/**
 * Function is used to display forget password page
 *
 * @param null
 *
 * @return view page.
 */
	public function forgot_password(){
		return View::make('pages.dealer.forgot_password');
	}// end forgot_password()

  /**
   * Function is used to send email for forgot password process
   *
   * @param null
   *
   * @return url.
   */
  public function sendPassword(){

    // After 30 minute reset password link will be expired
    $expire_link_time	=	Carbon::now()->addMinute(30);

    $validator = Validator::make(
            Input::all(),
            array(
              'email' => 'required|email',
            )
          );
    if ($validator->fails()){
      return Redirect::back()
        ->withErrors($validator)->withInput();
    }else{

      $email							=	Input::get('email');
      $userDetail						=	Dealer::where('email',trim($email))->first();

      if(!empty($userDetail) && ($userDetail->user_role_id == DEALER)){
        if($userDetail->is_deleted == INACTIVE ){
          if($userDetail->active == ACTIVE ){
            if($userDetail->is_verified == ACTIVE ){

              $forgot_password_validate_string	= 	md5($userDetail->email);
              Dealer::where('email',$email)->update(array('forgot_password_validate_string'=>$forgot_password_validate_string,'reset_password_link_time'=>$expire_link_time));

              $settingsEmail 		=  	Config::get('Site.email');
              $email 				=  	$userDetail->email;
              $full_name			=  	$userDetail->name;
              $route_url      	=  	route('Dealer.reset_password',$forgot_password_validate_string);
              $varify_link   		=   $route_url;

              $emailActions		=	EmailAction::where('action','=','forgot_password')->get()->toArray();
              $emailTemplates		=	EmailTemplate::where('action','=','forgot_password')->get(array('name','subject','action','body'))->toArray();
              $cons = explode(',',$emailActions[0]['options']);
              $constants = array();

              foreach($cons as $key=>$val){
                $constants[] = '{'.$val.'}';
              }
              $subject 			=  	$emailTemplates[0]['subject'];
              $rep_Array 			= 	array($full_name,$varify_link,$route_url);
              $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

              $this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
              Session::flash('flash_notices', trans('messages.Login.password_send'));
              return Redirect::route('dealer.login');
            }else{
              return Redirect::back()->withInput()
                ->with('error', trans('messages.Login.account_not_verify'));
            }
          }else{
            return Redirect::back()->withInput()
              ->with('error', trans('messages.Login.account_disable'));
          }
        }else{
          return Redirect::back()->withInput()
            ->with('error', trans('messages.Login.account_deleted'));
        }
      }
      else{
        return Redirect::back()->withInput()
            ->with('error', trans('messages.Login.invalid_access'));
      }
    }
  }// sendPassword()


  /**
 * Function is used for reset password
 *
 * @param $validate_string as validator string
 *
 * @return view page.
 */
  public function reset_password($validate_string=null){
    if($validate_string!="" && $validate_string!=null){
      $userDetail	=	Dealer::where('active',ACTIVE)->where('forgot_password_validate_string',$validate_string)->first();
      if(!empty($userDetail)){
        if($userDetail['reset_password_link_time']!="" && $userDetail['reset_password_link_time']!=null && $userDetail['reset_password_link_time'] > Carbon::now()){
          return View::make('pages.dealer.reset_password' ,compact('validate_string'));
        }else{
          return Redirect::route('dealer.login')->with('error', trans('messages.Sorry, you are using wrong link.'));
        }
      }else{
        return Redirect::route('dealer.login')
        ->with('error', trans('messages.Sorry, you are using wrong link.'));
      }

    }else{
      return Redirect::route('dealer.login')->with('error', trans('messages.Sorry, you are using wrong link.'));
    }
  }// end reset_password()

  /**
   * Function is used for save reset password
   *
   * @param $validate_string as validator string
   *
   * @return view page.
   */
  public function resetPasswordSave($validate_string=null){
    $newPassword		=	Input::get('new_password');
    $messages = array(
    'new_password.required'         => 'Please enter new password.',
    'new_password.min'              => 'New password should have atleast 6 characters.',
    'confirm_new_password.required' => 'Please enter confirm new password.',
    'confirm_new_password.same'     => 'New password and confirm new password do not match.',
    );

    $validator = Validator::make(
      Input::all(),
      array(
        'new_password' 						=> 	'required|min:6',
        'confirm_new_password' 		=> 	'required|same:new_password',

      ),$messages
    );
    $newPassword		=	Hash::make($newPassword);

    if ($validator->fails()){
      return Redirect::back()
        ->withErrors($validator)->withInput()->with(compact(''));
    }else{
      $userInfo = Dealer::where('forgot_password_validate_string',$validate_string)->first();

      Dealer::where('forgot_password_validate_string',$validate_string)
        ->update(array(
            'password'							=>	$newPassword,
            'forgot_password_validate_string'	=>	'',
            'reset_password_link_time'			=>	'',
        ));
      $settingsEmail 		= 	Config::get('Site.email');
      $action				= 	"reset_password";
      $emailActions		=	EmailAction::where('action','=','reset_password')->get()->toArray();
      $emailTemplates		=	EmailTemplate::where('action','=','reset_password')->get(array('name','subject','action','body'))->toArray();
      $cons 				= 	explode(',',$emailActions[0]['options']);
      $constants 			= 	array();
      foreach($cons as $key=>$val){
        $constants[] 	= 	'{'.$val.'}';
      }

      $subject 			=  	$emailTemplates[0]['subject'];
      $rep_Array 			=  	array($userInfo->name);

      $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

      $this->sendMail($userInfo->email,$userInfo->name,$subject,$messageBody,$settingsEmail);
      Session::flash('flash_notices', trans('Password successfully reset.'));
      Auth::logout();
      return Redirect::route('dealer.login');
    }
  }// end resetPasswordSave()

  /**
   * Function is used to display change_password page
   *
   * @param null
   *
   * @return view page.
   */
  	public function change_password(){
  		return View::make('pages/dealer/change_password');
  	}// end change_password()

  /**
   * Function for update password
   *
   * @param null
   *
   * @return view page.
   */
  public function update_password(){
    $formData = Input::all();
    $userId		=	Auth::guard('dealers')->user()->id;
      $message	=	array(
              'current_password.required'     => 'Please enter old password.',
              'current_password.old_password'       => 'Current password is incorrect.',
              'new_password.required'         => 'Please enter old password.',
              'new_password.min'              => 'New password should have atleast 6 characters.',
              'confirm_new_password.required' => 'Please enter confirm new password.',
              'confirm_new_password.same'     => 'New password and confirm new password do not match.',
          );
      $validate	=	array(
          'current_password'        => 'required|old_password:'.Auth::guard('dealers')->user()->password,
          'new_password'            => 'required|different:current_password|min:6',
          'confirm_new_password'    => 'required|same:new_password',
        );

      $validator = Validator::make(Input::all(),$validate,$message);

      if ($validator->fails()){
         return Redirect::back()->withErrors($validator)->withInput();
      }else{

        $obj 						         =	Dealer::findOrFail($userId);
        $get_password				     =	strip_tags(Input::get('new_password'));
        $get_confirm_password		 =	(Input::get('confirm_new_password'));

        if(!empty($get_password) && !empty($get_confirm_password) && $get_password == $get_confirm_password){
          $obj->password	 		    =  	Hash::make(Input::get('new_password'));
        }

        $obj->save();
      }

    Session::flash('flash_notices',  trans("Password successfully changed."));
    return Redirect::route("dealer_dashboard");
  } // end


}// end DealerController
