<?php
namespace App\Http\Controllers;

use App\Http\Controllers\BaseController;
use App\Model\AdminUser;
use App\Model\User;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use Carbon\Carbon;
use mjanssen\BreadcrumbsBundle\Breadcrumbs as Breadcrumb;
use Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,mongoDate,Redirect,Request,Response,Session,URL,View,Validator;

/**
 * Login Controller
 *
 * Add your methods in the class below
 *
 * This file will render views\pages\login
 */

class LoginController extends BaseController {

 /**
 * Function for display admin  login page
 *
 * @param null
 *
 * @return view page.
 */
	public function login(){
		$formData	=	Input::all();

		if(Auth::check()){
			if(Auth::user()->user_role_id==SUPER_ADMIN){
				return Redirect:: route('admin_dashboard');
			}
		}
		if(Request::isMethod('post')){
			$userdata = array(
				'email' 		=> Input::get('email'),
				'password' 		=> Input::get('password'),
			);

			if(!empty($formData['remember'])){

				if (Auth::attempt($userdata)){
					Session::flash('flash_notice',trans("messages.Login.success"));
					return Redirect:: route('admin_dashboard')->withCookie(cookie('email', $formData['email'], 45000))->withCookie(cookie('remember', $formData['remember'], 45000));
				}else{
					Session::flash('error',trans("messages.Login.incorrect_credential"));
					return Redirect::back() ->withInput();
				}
			}

			if (Auth::attempt($userdata)){
					Session::flash('flash_notice',trans("messages.Login.success"));
					return Redirect:: route('admin_dashboard')->withCookie(cookie('email', $formData['email'], -45000))->withCookie(cookie('remember', '', -45000));
			}else{
				Session::flash('error',trans("messages.Login.incorrect_credential"));
				return Redirect::back() ->withInput();
			}


		}else{
			return View::make('admin.Login.index');
		}
   }// end index()

 /**
 * Function for logout  users
 *
 * @param null
 *
 * @return rerirect page.
 */
	public function logout(){
		Auth::logout();
		Session::flash('flash_notice',trans("messages.Login.logout"));
		return Redirect::route('Admin.login');
	}//endLogout()

/**
 * Function is used to display forget password page
 *
 * @param null
 *
 * @return view page.
 */
	public function forgetPassword(){
		return View::make('admin.Login.forgot_password');
	}// end forgetPassword()

/**
 * Function is used for reset password
 *
 * @param $validate_string as validator string
 *
 * @return view page.
 */
	public function resetPassword($validate_string=null){
		if($validate_string!="" && $validate_string!=null){
			$userDetail	=	AdminUser::where('active',ACTIVE)->where('forgot_password_validate_string',$validate_string)->first();
			if(!empty($userDetail)){
				if($userDetail['reset_password_link_time']!="" && $userDetail['reset_password_link_time']!=null && $userDetail['reset_password_link_time'] > Carbon::now()){
					return View::make('admin.Login.reset_password' ,compact('validate_string'));
				}else{
					return Redirect::route('Admin.login')->with('error', trans('messages.Sorry, you are using wrong link.'));
				}
			}else{
				return Redirect::route('Admin.login')
				->with('error', trans('messages.Sorry, you are using wrong link.'));
			}

		}else{
			return Redirect::route('Admin.login')->with('error', trans('messages.Sorry, you are using wrong link.'));
		}
	}// end resetPassword()

	/**
	 * Function is used to send email for forgot password process
	 *
	 * @param null
	 *
	 * @return url.
	 */
	public function sendPassword(){

		// After 30 minute reset password link will be expired
		$expire_link_time	=	Carbon::now()->addMinute(30);

		$validator = Validator::make(
						Input::all(),
						array(
							'email' => 'required|email',
						)
					);
		if ($validator->fails()){
			return Redirect::back()
				->withErrors($validator)->withInput();
		}else{

			$email							=	Input::get('email');
			$userDetail						=	AdminUser::where('email',trim($email))->first();

			if(!empty($userDetail) && ($userDetail->user_role_id == SUPER_ADMIN)){
				if($userDetail->is_deleted == INACTIVE ){
					if($userDetail->active == ACTIVE ){
						if($userDetail->is_verified == ACTIVE ){

							$forgot_password_validate_string	= 	md5($userDetail->email);
							AdminUser::where('email',$email)->update(array('forgot_password_validate_string'=>$forgot_password_validate_string,'reset_password_link_time'=>$expire_link_time));

							$settingsEmail 		=  	Config::get('Site.email');
							$email 				=  	$userDetail->email;
							$username			=  	$userDetail->username;
							$full_name			=  	$userDetail->full_name;
							$route_url      	=  	route('Admin.reset_password',$forgot_password_validate_string);
							$varify_link   		=   $route_url;

							$emailActions		=	EmailAction::where('action','=','forgot_password')->get()->toArray();
							$emailTemplates		=	EmailTemplate::where('action','=','forgot_password')->get(array('name','subject','action','body'))->toArray();
							$cons = explode(',',$emailActions[0]['options']);
							$constants = array();

							foreach($cons as $key=>$val){
								$constants[] = '{'.$val.'}';
							}
							$subject 			=  	$emailTemplates[0]['subject'];
							$rep_Array 			= 	array($full_name,$varify_link,$route_url);
							$messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

							$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
							Session::flash('flash_notice', trans('messages.Login.password_send'));
							return Redirect::route('Admin.login');
						}else{
							return Redirect::back()
								->with('error', trans('messages.Login.account_not_verify'));
						}
					}else{
						return Redirect::back()
							->with('error', trans('messages.Login.account_disable'));
					}
				}else{
					return Redirect::back()
						->with('error', trans('messages.Login.account_deleted'));
				}
			}
			else{
				return Redirect::back()
						->with('error', trans('messages.Login.invalid_access'));
			}
		}
	}// sendPassword()

	/**
	 * Function is used for save reset password
	 *
	 * @param $validate_string as validator string
	 *
	 * @return view page.
	 */
	public function resetPasswordSave($validate_string=null){
		$newPassword		=	Input::get('new_password');
		$validate_string	=	Input::get('validate_string');

		$messages = array(
			'new_password.required' 				=> 	trans('messages.AdminLogin.reset_password_message'),
			'new_password_confirmation.required' 	=> 	trans('messages.AdminLogin.reset_password_comfrom_message'),
			'new_password.confirmed' 				=> 	trans('messages.AdminLogin.reset_password_comfrom__match_message'),
			'new_password.min' 						=> 	trans('messages.AdminUser.password_help_message'),
		);

		$validator = Validator::make(
			Input::all(),
			array(
				'new_password' 						=> 	'required|min:6|confirmed',
				'new_password_confirmation' 		=> 	'required|min:6',

			),$messages
		);
		$newPassword		=	Hash::make($newPassword);

		if ($validator->fails()){
			return Redirect::back()
				->withErrors($validator)->withInput()->with(compact(''));
		}else{
			$userInfo = AdminUser::where('forgot_password_validate_string',$validate_string)->first();

			AdminUser::where('forgot_password_validate_string',$validate_string)
				->update(array(
						'password'							=>	$newPassword,
						'forgot_password_validate_string'	=>	'',
						'reset_password_link_time'			=>	'',
				));
			$settingsEmail 		= 	Config::get('Site.email');
			$action				= 	"reset_password";
			$emailActions		=	EmailAction::where('action','=','reset_password')->get()->toArray();
			$emailTemplates		=	EmailTemplate::where('action','=','reset_password')->get(array('name','subject','action','body'))->toArray();
			$cons 				= 	explode(',',$emailActions[0]['options']);
			$constants 			= 	array();
			foreach($cons as $key=>$val){
				$constants[] 	= 	'{'.$val.'}';
			}

			$subject 			=  	$emailTemplates[0]['subject'];
			$rep_Array 			=  	array($userInfo->full_name);

			$messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

			$this->sendMail($userInfo->email,$userInfo->full_name,$subject,$messageBody,$settingsEmail);
			Session::flash('flash_notice', trans('messages.Login.reset_password_success'));
			Auth::logout();
			return Redirect::route('Admin.login');
		}
	}// end resetPasswordSave()

}// end LoginController
