<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\User;
use Illuminate\Http\Request;
use Auth;
use Socialite;
use Redirect;
use Session,URL;
class SocialLoginController extends Controller
{

  public function redirect($provider,Request $request) {
    if($provider == 'google'){
      return Socialite::driver('google')->with(['state' => $request->previous ])->redirect();
    }else{
      return Socialite::driver($provider)->redirect ();
    }
  }

  public function callback($provider,Request $request) {
      if ($request->has('state')) {
        $url_original = $request->state ;
        //pr($url_original);die;
      }else {
        $url_original = route('home');
      }
      if (!$request->has('code') || $request->has('denied')) {
          return Redirect::route('home');
      }
      try {
            if($provider == 'google'){
              $user = Socialite::driver('google')->stateless()->user();
            }else{
              $user = Socialite::driver($provider)->user();
            }
        }
        catch (Exception $e) {
            return Redirect::route('home');
        }
        $authUser = $this->findOrCreateUser($user, $provider);
        Auth::login($authUser, true);
      return Redirect::to($url_original);
  }


  public function findOrCreateUser($user, $provider)
  {
      $authUser = User::where('provider_id', $user->id)->first();
      if (!$authUser) {
        $authUser = User::create([
            'first_name'     => $user->name,
            'email'    => $user->email,
            'image'    => $user->avatar,
            'user_role_id'    => THREE,
            'provider' => $provider,
            'provider_id' => $user->id
        ]);
      }
      return $authUser;

  }

}
