<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\URL;

class StreamController extends Controller
{
    /**
     * Generate a signed URL for streaming the video.
     */
    public function generateSignedUrl()
    {
        $expiresAt = now()->addMinutes(30);

        // Generate a signed URL for the main .m3u8 playlist
        $url = URL::temporarySignedRoute('stream.video', $expiresAt, [
            'video' => 'test.m3u8',  // The .m3u8 file URL
        ]);

        return $url;
    }

    /**
     * Serve the video stream (for .m3u8 and .ts files).
     */
    public function serveVideo($video, Request $request)
    {
        // Get the file path (either .m3u8 or .ts)
        $filePath = $request->query('video');
        if(empty($filepath)){
            $filePath = $video;
        }

        // If the file is a .ts file, stream it, else serve the .m3u8 file
        if (substr($filePath, -3) === 'ts') {
            return $this->streamTsFile($filePath);
        } else {
            return $this->streamM3u8File($filePath);
        }
    }

    /**
     * Stream a .ts file.
     */
    public function streamTsFile($filePath)
    {
        // You can proxy the .ts files here, fetching them from the external server
        $videoUrl = "http://143.244.138.166:8088/hls/{$filePath}";  // Adjust the path as needed

        // Stream the .ts file
        return response()->stream(function () use ($videoUrl) {
            readfile($videoUrl);
        }, 200, [
            'Content-Type' => 'video/MP2T',
            'Cache-Control' => 'no-store, no-cache, must-revalidate',
            'Connection' => 'keep-alive',
        ]);
    }

    /**
     * Stream the .m3u8 playlist.
     */
    public function streamM3u8File($filePath)
    {
        // For .m3u8 files, stream them from the external server
        $videoUrl = "http://143.244.138.166:8088/hls/{$filePath}";  // Adjust the path as needed

        return response()->stream(function () use ($videoUrl) {
            readfile($videoUrl);
        }, 200, [
            'Content-Type' => 'application/x-mpegURL',
            'isHls' => true
        ]);
    }

    public function stream()
    {
        $signedUrl = $this->generateSignedUrl();
        dd($signedUrl);
        return view("test.stream", compact("signedUrl"));
    }

}
