<?php
namespace App\Http\Controllers;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\User;
use Cartalyst\Stripe\Laravel\Facades\Stripe;
use Stripe\Error\Card;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\model\Contract;
use App\model\CarDetail;
use App\model\Payment;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Response,Session,URL,View,Validator;

	class StripeController extends BaseController
	{

		public function __construct()
		{
			parent::__construct();
			$this->user = new User;
		}

		/**
		 * Show the application paywith stripe.
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function payWithStripe()
		{
			$contract_id = Session::get('contract_id');

			if(!empty($contract_id)){
				$contract = Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('payment_status', INACTIVE)->where('contract_complete_status', INACTIVE)->where('is_accepted', ACTIVE)->first();
				if(!empty($contract)){
					$carData = CarDetail::where('id', $contract->car_detail_id)->where('sold_status', INACTIVE)->first();
					if (!empty($carData)) {
							return view('paywithstripe',compact('contract_id','carData','contract'));
					}else {
						Session::flash('sorry',  trans("Sorry,for Inconvenience car has been sold or reserved.You can book another best one."));
						return Redirect::route('car_listing');
					}
				}else {
					Session::flash('errorss',  trans("Something went wrong."));
					return Redirect::back();
				}
			}else{
				Session::flash('errorss',  trans("Session Expired."));
				return Redirect::route('car_listing');
			}

		}
		/**
		 * Store a newly created resource in storage.
		 *
		 * @param  \Illuminate\Http\Request  $request
		 * @return \Illuminate\Http\Response
		 */
		public function postPaymentWithStripe()
		{
			$thisData = Input::all();
			$contract_id = Session::get('contract_id');
			// pr($thisData);die;
			if(!empty($thisData)){
					$validator = Validator::make(
						Input::all(),
						array(
							'card_no' 			=> 'required',
							'ccExpiryMonth' => 'required|numeric',
							'ccExpiryYear' 	=> 'required|numeric',
							'cvvNumber' 		=> 'required|numeric',
							'amount' 				=> 'required|numeric',
						),
						array(
							'card_no.required' => 'Please enter card number.',
							'ccExpiryMonth.required' => 'Please expiry month.',
							'ccExpiryMonth.numeric' => 'Please enter numeric value.',
							'cvvNumber.required' => 'Please enter cvv number.',
							'cvvNumber.numeric' => 'Please enter numeric value.',
							'ccExpiryYear.required' => 'Please enter expiry year.',
							'ccExpiryYear.numeric' => 'Please enter numeric value.',
							'amount.required' => 'Please amount to be pay.',
							'amount.numeric' => 'Amount should be numeric.'
						)
					);
			}

			if ($validator->fails()){
				return Redirect::back()->withErrors($validator)->withInput();
			}else{

					$input = array_except($thisData,array('_token'));
					$stripe = Stripe::make(Config::get('Payment.stripe_secret_id'));
					if(!empty($contract_id)){
						$contract = Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('payment_status', INACTIVE)->where('contract_complete_status', INACTIVE)->where('is_accepted', ACTIVE)->where('contract_deposit_amount_paid', $thisData['amount'])->first();
						if(!empty($contract)){
							$carData = CarDetail::where('id', $contract->car_detail_id)->where('sold_status', INACTIVE)->first();
							if (!empty($carData)) {
									// update the payment mode and render pages
									try {
										$token = $stripe->tokens()->create([
											'card' => [
												'number'    => $thisData['card_no'],
												'exp_month' => $thisData['ccExpiryMonth'],
												'exp_year'  => $thisData['ccExpiryYear'],
												'cvc'       => $thisData['cvvNumber'],
											],
										]);
										if (!isset($token['id'])) {
											Session::flash('errorss','The Stripe Token was not generated correctly');
											return redirect()->route('stripform');
										}

										if (isset($contract['dealer_data'])) {
											$dealerData = unserialize($contract['dealer_data']);
										}

										$charge = $stripe->charges()->create([
											'card' => $token['id'],
											'currency' => 'aud',
											'amount'   => $thisData['amount'],
											'description' => 'car payment',
										]);
										if($charge['status'] == 'succeeded') {
											// check car is available or not
											$carData = CarDetail::where('id', $contract->car_detail_id)->where('sold_status', INACTIVE)->first();
											if (!empty($carData)) {
												//pr($charge);die;
												$current_date = date('Y-m-d H:i:s');
			                  $tenDays = date('Y-m-d H:i:s', strtotime($current_date. ' + 10 days'));
												Contract::where('user_id', '=', Auth::user()->id)->where('contract_id',$contract_id)->where('car_detail_id', $contract->car_detail_id)->update(array('payment_mode' => 'credit_card','contract_complete_status' => ACTIVE,'contract_date' => strtotime($current_date),'contract_estimated_delivery_date'=>strtotime($tenDays),'contract_actual_delivery_date'=>strtotime($tenDays), 'payment_status' => ACTIVE,'txn_id' => $charge['id']));

												if(isset($thisData['amount']) && $contract->contract_sale_amount == $thisData['amount']){
													CarDetail::where('id', $contract->car_detail_id)->update(array('sold_status'=>ONE));
												}else {
													CarDetail::where('id', $contract->car_detail_id)->update(array('sold_status'=>TWO));
												}

												if (!empty($dealerData)) {
													$remaining_amount = "$".($contract->contract_sale_amount - $contract->contract_deposit_amount_paid);
													$booking_message = "Congratulations on being the most recent owner of a new ".@$contract->car_model.".Your car will be delivered by ".@$dealerData->name." at ".@$dealerData->dealer_street_number.", ".@$dealerData->dealer_street_name.", ".@$dealerData->dealer_post_code.".Please contact ".@$dealerData->dealer_main_contact_name." at '".@$dealerData->dealer_phone_number."' Contract Id '".@$contract->contract_id."' & Order Id '".@$contract->order_id."' for reference.Automotiv will confirm your delivery date. At this point,the estimated delivery will be ".date('d-m-Y',strtotime($tenDays))." as some time is required to prepare your shiny new car and also register it.Should you wish to have a specific pick up date, a special number plate, please call us let us know on 1300 XXX XXX. Or drop us an email at automitv@automitiv.com.We know you are excited to pick up your car and so are we to see you ride your new set of wheels. So please have the following ready by the ".date('d-m-Y',strtotime($tenDays)).". 1. Balance of payment of ".@$remaining_amount.".2. Certificate of currency with Financial Interest noted (if Financing) 3. CTP Green Slip";
												}else {
													$booking_message = 'Your car has been successfully booked.';
												}
												//pr($booking_message);die;

												/*###################### Send mail to User, Dealer, Admin #######################*/
												$emails = array();
												$userDetail = Auth::user();
												$dealer_email = $dealerData->email;
												array_push($emails,$dealer_email);
												$car_booking_validate_string	= 	md5($userDetail->email).'-'.time();
					              Contract::where('contract_id',$contract_id)->update(array('car_booking_validate_string'=>$car_booking_validate_string));

					              $settingsEmail 		=  	Config::get('Site.email');
												array_push($emails,$settingsEmail);
					              $user_email 				=  	$userDetail->email;
												array_push($emails,$user_email);
					              $username			=  	$userDetail->username;
					              $full_name			=  	$userDetail->first_name;
					              $route_url      	=  	route('Car_Booking_Mail',$car_booking_validate_string);
					              $varify_link   		=   $route_url;
												$reference_code = $contract->order_id;

					              $emailActions		=	EmailAction::where('action','=','car_booking')->get()->toArray();
					              $emailTemplates		=	EmailTemplate::where('action','=','car_booking')->get(array('name','subject','action','body'))->toArray();
					              $cons = explode(',',$emailActions[0]['options']);
					              $constants = array();

					              foreach($cons as $key=>$val){
					                $constants[] = '{'.$val.'}';
					              }
												$subject 			=  	'Congratulations on the purchase of your new '. $contract->car_make.'/'.$contract->car_model.' Ref# '. $contract->order_id;
			                  $rep_Array 			= 	array($full_name,$varify_link,$route_url,$reference_code,$contract->car_make,$contract->car_model);
					              $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
												foreach ($emails as $email_key => $email_value) {
													$this->sendMail($email_value,$full_name,$subject,$messageBody,$settingsEmail);
												}
												/*###################### Send mail to User, Dealer, Admin #######################*/

												// remove contact_id
												Session::forget('contract_id');

												Session::flash('flash_notices',$booking_message);
												return redirect()->route('my_orders');


										}else {
			                  // car has been sold and paypal payment success also

			                  /*###################### Send mail to User, Dealer, Admin #######################*/
			                  $emails = array();
			                  $userDetail = Auth::user();
			                  $dealer_email = $dealerData->email;
			                  array_push($emails,$dealer_email);
			                  $car_booking_validate_string	= 	md5($userDetail->email).'-'.time();
			                  Contract::where('contract_id',$contract_id)->update(array('car_booking_validate_string'=>$car_booking_validate_string,'contract_complete_status'=>THREE,'payment_status'=>ACTIVE,'txn_id'=>$charge['id']));

			                  $settingsEmail 		=  	Config::get('Site.email');
			                  array_push($emails,$settingsEmail);
			                  $user_email 				=  	$userDetail->email;
			                  array_push($emails,$user_email);
			                  $username			=  	$userDetail->username;
			                  $full_name			=  	$userDetail->first_name;
			                  $route_url      	=  	route('Car_Booking_Mail',$car_booking_validate_string);
			                  $varify_link   		=   $route_url;
			                  $reference_code = $contract->order_id;

			                  $emailActions		=	EmailAction::where('action','=','car_booking_fail')->get()->toArray();
			                  $emailTemplates		=	EmailTemplate::where('action','=','car_booking_fail')->get(array('name','subject','action','body'))->toArray();
			                  $cons = explode(',',$emailActions[0]['options']);
			                  $constants = array();

			                  foreach($cons as $key=>$val){
			                    $constants[] = '{'.$val.'}';
			                  }
			                  $subject 			=  	$emailTemplates[0]['subject'];
			                  $rep_Array 			= 	array($full_name,$reference_code,$txn_id,$varify_link,$route_url);
			                  $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);
			                  foreach ($emails as $email_key => $email_value) {
			                    $this->sendMail($email_value,$full_name,$subject,$messageBody,$settingsEmail);
			                  }
			                  /*###################### Send mail to User, Dealer, Admin #######################*/

			                  Session::flash('errorss',  trans("errorss,for Inconvenience car has been sold or reserved.You can book another best one."));
			  								return Redirect::route('car_listing');
			                }

											// update payment table
											if(!empty($charge)){
												$obj  = new Payment;
												$obj->contract_id = $contract_id;
												$obj->amount = $thisData['amount'];
												$obj->txn_id = $charge['id'];
												$obj->description = 'car payment';
												$obj->currency_code = 'AUD';
												$obj->payment_status = 'Completed';
												$obj->save();
											}

										} else {
											Session::flash('errorss','Payment fail.');
											return redirect()->route('stripform');
										}
									} catch (Exception $e) {
										Session::flash('errorss',$e->getMessage());
										return redirect()->route('stripform');
									} catch(\Cartalyst\Stripe\Exception\CardErrorException $e) {
										Session::flash('errorss',$e->getMessage());
										return redirect()->route('stripform');
									} catch(\Cartalyst\Stripe\Exception\MissingParameterException $e) {
										Session::flash('errorss',$e->getMessage());
										return redirect()->route('stripform');
									}

							}else {
								Session::flash('sorry',  trans("Sorry,for Inconvenience car has been sold or reserved.You can book another best one."));
								return Redirect::route('car_listing');
							}
						}else {
							Session::flash('errorss',  trans("Something went wrong."));
							return Redirect::back();
						}
					}else{
						Session::flash('errorss',  trans("Session Expired due to late payment."));
						return Redirect::route('car_listing');
					}
			}
		}
	}
