<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use App\Model\User;
use App\Model\AdminUser;
use App\Model\Media;
use App\Model\Slider;
use App\Model\City;
use App\Model\Testimonial;
use App\Model\EmailAction;
use App\Model\EmailTemplate;
use App\Model\Contract;
use App\libraries\CustomHelper;
use mjanssen\BreadcrumbsBundle\Breadcrumbs;
use Str,Auth,Blade,Config,Cache,Cookie,DB,File,Hash,Input,Mail,Redirect,Request,Response,Session,URL,View,Validator;
use Carbon\Carbon;
// UserController class start

class UserController extends BaseController
{
    public $model	=	'User';

	public function __construct() {
		View::share('modelName',$this->model);
	}

  /*
  * Function to return view of sign up
  */
  public function signup(Request $request)
  {
    if (!empty(Request::get('previous'))) {
      $previousURL = Request::get('previous');
    }else {
      $previousURL = Redirect::route('user_dashboard');
    }
      return view('pages/signup',compact('previousURL'));
  } // end signup()
  /**
 * Function for save user
 *
 * @param null
 *
 * @return view page.
 */
public function saveSignUp(){

  $formData				=	Input::all();
  //pr($formData);die;
  if(!empty($formData)){

    $message	=	array(
          'image.max'						        =>	MAX_IMAGE_SIZE,
          'first_name.required'         => 'Please enter first name.',
          'first_name.regex'            => 'Only alphabets are allowed.',
          'last_name.regex'             => 'Only alphabets are allowed.',
          'last_name.required'          => 'Please enter last name.',
          'email.required'              => 'Please enter email address.',
          'email.email'                 => 'Please enter a valid email address.',
          'email.unique'                => 'This email address is already registered with us, try another.',
          'password.required'           => 'Please enter password.',
          'confirm_password.required'   => 'Please enter confirm password.',
          'confirm_password.same'       => 'Confirm password and password should be same.',
        );
    $validate	=	array(
        'first_name'			     =>	'required|regex:/^[\pL\s\-]+$/u',
        'last_name' 			     =>	'required|regex:/^[\pL\s\-]+$/u',
        'email' 				       =>	'required|email|unique:users,email,NULL,id,is_deleted,0',
        'password'				     =>	'required|min:6',
        'confirm_password' 		 =>	'required|same:password',
      );

    $validator = Validator::make(Input::all(),$validate,$message);

    $password 					   =	Input::get('password');
    $correctPassword			 =	Hash::make($password);

    if ($validator->fails()){
       return Redirect::back()->withErrors($validator)->withInput();
    }else{

      $fullName					=	ucwords(Input::get('first_name').' '.Input::get('last_name'));
      $fullName					=	strip_tags($fullName);
      $email						=	strip_tags(Input::get('email'));

      $obj 						=	new User;

      $validateString				=	md5(time() . Input::get('email'));
      $obj->validate_string	=	$validateString;
      $obj->full_name 			=	ucwords($fullName);
      $obj->email 				  =	strip_tags(Input::get('email'));
      $obj->slug			 		  =	Str::slug($fullName);
      $obj->password	 			=	strip_tags($correctPassword);
      $obj->first_name			=	strip_tags(Input::get('first_name'));
      $obj->last_name				=	strip_tags(Input::get('last_name'));
      $obj->user_role_id			=  	USER;
      $obj->active				  =  	ACTIVE;
      $obj->is_verified			=  	INACTIVE;
      $obj->is_deleted			=  	INACTIVE;

      if(Input::hasFile('image')){

        $extension 				=	Input::file('image')->getClientOriginalExtension();
        $img_ext = explode(",",IMAGE_EXTENSION);

        if(in_array($extension,$img_ext)){
          $fileName				=	time().'-user-image.'.$extension;

          if(Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)){
            $obj->image			=	$fileName;
          }
        }else{
          Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
          return Redirect::back()->withInput();
        }
      }

        $obj->save();
      $userId					=	$obj->id;
      $encId					=	md5(time() . Input::get('email'));

      //mail email and password to new registered user
      $settingsEmail 			=	Config::get('Site.email');
			$full_name				=	$fullName;
			$validateStr 			=  $validateString;
			$route_url      		=  	route('email_verify',$validateStr);
			$link 					=   $route_url;
			$click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

			$emailActions			= 	EmailAction::where('action','=','account_verification')->get()->toArray();

			$emailTemplates			= 	EmailTemplate::where('action','=','account_verification')
											->get(array('name','subject','action','body'))->toArray();

			$cons 					= 	explode(',',$emailActions[0]['options']);

			$constants 				= 	array();

			foreach($cons as $key => $val){
				$constants[] 		= 	'{'.$val.'}';
			}

			$subject 				= 	$emailTemplates[0]['subject'];
			$rep_Array 				= 	array($full_name,$click_link,$route_url);
			$messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

			$mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);

      Session::flash('flash_notice',  trans("Thank you for registered with us. A verication link has been sent on your email to verify your account."));
      return Redirect::route("home");

    }
  }
}// end saveSignUp()
/**
* Method for used login of registered user
*
* @param null
*
* @return null
*/
public function login(){
$formData				=	Input::all();
$loginData	=	AdminUser::where('email',$formData['email'])->where('user_role_id',USER)->first();
if(!empty($loginData)){
  if(Auth::check()){
    if(Auth::user()->user_role_id == USER){
      return response()->json(['status'=>'error','message'=>trans("messages.login.ALREADY_LOGIN")]);
      die;
    }else{
      Auth::logout();
      return response()->json(['status'=>'error','message'=>trans("messages.login.INVALID_ACCESS")]);
      return Redirect::route("login");
      die;
    }
  }else{
    $userdata = array(
      'email' 		=> Input::get('email'),
      'password' 		=> Input::get('password'),
    );
    if (Auth::attempt($userdata)){
      if(Auth::user()->is_verified == VERIFIED){
        if(Auth::user()->active == ACTIVE){
          if(Auth::user()->is_deleted == NOT_DELETE){
            if(Auth::user()->user_role_id == USER){
              if(isset($formData['remember']) && !empty($formData['remember'])){
                if (isset($formData['previous']) && !empty($formData['previous'])) {
                  $redirect_url = $formData['previous'];
                }else {
                  $redirect_url = route("user_dashboard");
                }
                //pr($redirect_url);die;
                $successmessage = trans("messages.global.hello") .'<strong>' .' ' .ucfirst(Auth::user()->first_name).'</strong>,'. trans("messages.login.logged_in_success");
                Session::flash('flash_notice',$successmessage);
                return response()->json(['status'=>'success','redirect_url'=>$redirect_url,trans("messages.login.logged_in_success")])->withCookie(cookie('email_front', $formData['email'], 45000))->withCookie(cookie('remember_front', $formData['remember'], 45000));
                //return Redirect::route("user_dashboard");
                die;
              }else{
                if (isset($formData['previous']) && !empty($formData['previous'])) {
                  $redirect_url = $formData['previous'];
                }else {
                  $redirect_url = route("user_dashboard");
                }
                $successmessage = trans("messages.global.hello") .'<strong>' .' ' .ucfirst(Auth::user()->first_name).'</strong>,'. trans("messages.login.logged_in_success");
                Session::flash('flash_notice',$successmessage);
                return response()->json(['status'=>'success','redirect_url'=>$redirect_url,trans("messages.login.logged_in_success")])->withCookie(cookie('email_front', $formData['email'], -45000))->withCookie(cookie('remember_front', '', -45000));
                //return Redirect::route("user_dashboard");
                die;
              }
            }else{
              Auth::logout();
              return response()->json(['status'=>'error','message'=>trans("messages.login.INVALID_ACCESS")]);
              return Redirect::route("login");
              die;
            }

          }else{
            Auth::logout();
            return response()->json(['status'=>'error','message'=>trans("messages.login.account_deleted")]);
            die;
          }
        }else{
          Auth::logout();
          return response()->json(['status'=>'error','message'=>trans("messages.login.account_deactive")]);
          die;
        }
      }else{
        $validateString		=	Auth::user()->validate_string;
        $route_url      	=  	route('home.sendverifylinkagain',$validateString);
        $varify_link   		=   '<a style="color:blue" target="_blank" href='.$route_url.'>' .('click here') . '</a>';
        $verify_link      = trans("messages.login.not_verified").' '.$varify_link. ' to send verification link.';
        Auth::logout();
        return response()->json(['status'=>'error','message'=>$verify_link]);
      //  return response()->json(['status'=>'error','message'=>trans("messages.login.not_verified"),'link'=>$varify_link]);
        die;
      }
    }else{
      return response()->json(['status'=>'error','message'=>trans("messages.login.wrong_email_password_combination")]);
      die;
    }
  }
 }else{
  Auth::logout();
  return response()->json(['status'=>'error','message'=>trans("messages.login.not_registered")]);
  return Redirect::route("home");
  die;
}
}// end login()

/*
* Function to render pages/user/dashboard
*/
public function user_dashboard()
{
  return view('pages/user/dashboard');
}

/*
* Function to render pages/user/profile
*/
public function profile()
{
  $userDetails = Auth::user();
  $cityList = [];
  $old_state_id = Input::Old('state_id');
  if (isset($old_state_id) && $old_state_id > 0) {
    $cityList = City::where('state_id',Input::Old('state_id'))->where('status',ACTIVE)->pluck('name','id')->toArray();
  }else{
    $cityList = City::where('state_id',$userDetails['state_id'])->where('status',ACTIVE)->pluck('name','id')->toArray();
  }
  return view('pages/user/profile',compact('userDetails','cityList'));
} // end

/**
* Function for update profile
*
* @param null
*
* @return view page.
*/
public function updateProfile(){

$formData	=	Input::all();
$userId		=	Auth::user()->id;
if(!empty($formData)){

 $message	=	array(
       'image.max'						=>	MAX_IMAGE_SIZE,
     );
 $validate	=	array(
     'first_name'			=>	'required|regex:/^[\pL\s\-]+$/u',
     'last_name' 			=>	'required|regex:/^[\pL\s\-]+$/u',
     'email' 				=>	'required|email|unique:users,email,'.$userId,
     'phone'					=>	'required|integer|unique:users,phone,'.$userId,
     'gender'				=>	'required',
     'abn' 					=>	'nullable|digits:11|unique:users,abn,'.$userId,
     'state_id'   => 'required',
     'city_id'   => 'required',
     'post_code'   => 'required',
     'street_name'   => 'required',
     'street_number'   => 'required',
   );

 $validator = Validator::make(Input::all(),$validate,$message);

 if ($validator->fails()){
    return Redirect::back()->withErrors($validator)->withInput();
 }else{

   $fullName					=	ucwords(Input::get('first_name').' '.Input::get('last_name'));
   $fullName					=	strip_tags($fullName);

   $obj 						=	User::findOrFail($userId);
   $oldimage					=	$obj['image'];
   $obj->full_name 			=	ucwords($fullName);
   //$obj->email 				=	strip_tags(Input::get('email'));
   $obj->first_name			=	strip_tags(Input::get('first_name'));
   $obj->last_name				=	strip_tags(Input::get('last_name'));
   $obj->phone					=	strip_tags(Input::get('phone'));
   $obj->abn					=	strip_tags(Input::get('abn'));
   $obj->age_range				=	strip_tags(Input::get('age_range'));
   $obj->driver_licence_number	=	strip_tags(Input::get('driver_licence_number'));
   $obj->state_id	=	strip_tags(Input::get('state_id'));
   $obj->city_id	=	strip_tags(Input::get('city_id'));
   $obj->post_code	=	strip_tags(Input::get('post_code'));
   $obj->street_name	=	strip_tags(Input::get('street_name'));
   $obj->street_number	=	strip_tags(Input::get('street_number'));
   $obj->gender				=	strip_tags(Input::get('gender'));

   if(input::hasFile('image')){

     $extension 	=	Input::file('image')->getClientOriginalExtension();
     $img_ext 	= 	explode(",",IMAGE_EXTENSION);

     if(in_array($extension,$img_ext)){
       $fileName			=	time().'-user-image.'.$extension;

       if(Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)){
         $obj->image		=	$fileName;
       }
       //@unlink(USER_PROFILE_IMAGE_ROOT_PATH.$oldimage);
     }
     else{
       Session::flash('error',  trans("messages.$this->model.INVALID_IMAGE_EXTENSION"));
       return Redirect::back();
     }
   }

   $obj->save();

   Session::flash('flash_notices',  trans("Profile successfully updated."));
   return Redirect::route("user_dashboard");
 }
}
}// end updateProfile()

/**
 * Function for change password
 *
 * @param null
 *
 * @return view page.
 */
public function change_password(){
  return view('pages/user/change_password');
} // end

/**
 * Function for update password
 *
 * @param null
 *
 * @return view page.
 */
public function update_password(){
  $formData = Input::all();
  $userId		=	Auth::user()->id;
    $message	=	array(
            'current_password.required'     => 'Please enter old password.',
            'current_password.old_password'       => 'Current password is incorrect.',
            'new_password.required'         => 'Please enter old password.',
            'new_password.min'              => 'New password should have atleast 6 characters.',
            'confirm_new_password.required' => 'Please enter confirm new password.',
            'confirm_new_password.same'     => 'New password and confirm new password do not match.',
        );
    $validate	=	array(
        'current_password'        => 'required|old_password:'.Auth::user()->password,
        'new_password'            => 'required|different:current_password|min:6',
        'confirm_new_password'    => 'required|same:new_password',
      );

    $validator = Validator::make(Input::all(),$validate,$message);

    if ($validator->fails()){
       return Redirect::back()->withErrors($validator)->withInput();
    }else{

      $obj 						         =	User::findOrFail($userId);
      $get_password				     =	strip_tags(Input::get('new_password'));
      $get_confirm_password		 =	(Input::get('confirm_new_password'));

      if(!empty($get_password) && !empty($get_confirm_password) && $get_password == $get_confirm_password){
        $obj->password	 		    =  	Hash::make(Input::get('new_password'));
      }

      $obj->save();
    }

  Session::flash('flash_notices',  trans("Password successfully changed."));
  return Redirect::route("user_dashboard");
} // end

/**
 * Function for logout users
 *
 * @param null
 *
 * @return rerirect page.
 */
public function logout(){
  $successmessage = trans("Hello") .'<strong>' .' ' .ucfirst(Auth::user()->first_name).'</strong>,'. trans(" you are logged out now.");
  Auth::logout();
  Session::flash('flash_notice',$successmessage);
  return Redirect::route("login");
}//endLogout()

/**
 * Function is used to display forget password page
 *
 * @param null
 *
 * @return view page.
 */
	public function forgot_password(){
		return View::make('pages.user.forgot_password');
	}// end forgot_password()

  /**
   * Function is used to send email for forgot password process
   *
   * @param null
   *
   * @return url.
   */
  public function sendPassword(){

    // After 30 minute reset password link will be expired
    $expire_link_time	=	Carbon::now()->addMinute(30);
    $validator = Validator::make(
            Input::all(),
            array(
              'email' => 'required|email',
            )
          );
    if ($validator->fails()){
      return Redirect::back()
        ->withErrors($validator)->withInput();
    }else{

      $email							=	Input::get('email');
      $userDetail						=	AdminUser::where('email',trim($email))->first();

      if(!empty($userDetail) && ($userDetail->user_role_id == USER)){
        if($userDetail->is_deleted == INACTIVE ){
          if($userDetail->active == ACTIVE ){
            if($userDetail->is_verified == ACTIVE ){

              $forgot_password_validate_string	= 	md5($userDetail->email);
              AdminUser::where('email',$email)->update(array('forgot_password_validate_string'=>$forgot_password_validate_string,'reset_password_link_time'=>$expire_link_time));

              $settingsEmail 		=  	Config::get('Site.email');
              $email 				=  	$userDetail->email;
              $username			=  	$userDetail->username;
              $full_name			=  	$userDetail->first_name;
              $route_url      	=  	route('User.reset_password',$forgot_password_validate_string);
              $varify_link   		=   $route_url;

              $emailActions		=	EmailAction::where('action','=','forgot_password')->get()->toArray();
              $emailTemplates		=	EmailTemplate::where('action','=','forgot_password')->get(array('name','subject','action','body'))->toArray();
              $cons = explode(',',$emailActions[0]['options']);
              $constants = array();

              foreach($cons as $key=>$val){
                $constants[] = '{'.$val.'}';
              }
              $subject 			=  	$emailTemplates[0]['subject'];
              $rep_Array 			= 	array($full_name,$varify_link,$route_url);
              $messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

              $this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
              Session::flash('flash_notices', trans('messages.Login.password_send'));
              return Redirect::route('login');
            }else{
              return Redirect::back()->withInput()
                ->with('error', trans('messages.Login.account_not_verify'));
            }
          }else{
            return Redirect::back()->withInput()
              ->with('error', trans('messages.Login.account_disable'));
          }
        }else{
          return Redirect::back()->withInput()
            ->with('error', trans('messages.Login.account_deleted'));
        }
      }
      else{
        return Redirect::back()->withInput()
            ->with('error', trans('messages.Login.invalid_access'));
      }
    }
  }// sendPassword()


  /**
 * Function is used for reset password
 *
 * @param $validate_string as validator string
 *
 * @return view page.
 */
	public function reset_password($validate_string=null){
		if($validate_string!="" && $validate_string!=null){
			$userDetail	=	User::where('active',ACTIVE)->where('forgot_password_validate_string',$validate_string)->first();
			if(!empty($userDetail)){
				if($userDetail['reset_password_link_time']!="" && $userDetail['reset_password_link_time']!=null && $userDetail['reset_password_link_time'] > Carbon::now()){
					return View::make('pages.user.reset_password' ,compact('validate_string'));
				}else{
					return Redirect::route('login')->with('error', trans('messages.Sorry, you are using wrong link.'));
				}
			}else{
				return Redirect::route('login')
				->with('error', trans('messages.Sorry, you are using wrong link.'));
			}

		}else{
			return Redirect::route('login')->with('error', trans('messages.Sorry, you are using wrong link.'));
		}
	}// end reset_password()

  /**
	 * Function is used for save reset password
	 *
	 * @param $validate_string as validator string
	 *
	 * @return view page.
	 */
	public function resetPasswordSave($validate_string=null){
		$newPassword		=	Input::get('new_password');
		$messages = array(
    'new_password.required'         => 'Please enter new password.',
    'new_password.min'              => 'New password should have atleast 6 characters.',
    'confirm_new_password.required' => 'Please enter confirm new password.',
    'confirm_new_password.same'     => 'New password and confirm new password do not match.',
		);

		$validator = Validator::make(
			Input::all(),
			array(
				'new_password' 						=> 	'required|min:6',
				'confirm_new_password' 		=> 	'required|same:new_password',

			),$messages
		);
		$newPassword		=	Hash::make($newPassword);

		if ($validator->fails()){
			return Redirect::back()
				->withErrors($validator)->withInput()->with(compact(''));
		}else{
			$userInfo = User::where('forgot_password_validate_string',$validate_string)->first();

			User::where('forgot_password_validate_string',$validate_string)
				->update(array(
						'password'							=>	$newPassword,
						'forgot_password_validate_string'	=>	'',
						'reset_password_link_time'			=>	'',
				));
			$settingsEmail 		= 	Config::get('Site.email');
			$action				= 	"reset_password";
			$emailActions		=	EmailAction::where('action','=','reset_password')->get()->toArray();
			$emailTemplates		=	EmailTemplate::where('action','=','reset_password')->get(array('name','subject','action','body'))->toArray();
			$cons 				= 	explode(',',$emailActions[0]['options']);
			$constants 			= 	array();
			foreach($cons as $key=>$val){
				$constants[] 	= 	'{'.$val.'}';
			}

			$subject 			=  	$emailTemplates[0]['subject'];
			$rep_Array 			=  	array($userInfo->first_name);

			$messageBody		=  	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

			$this->sendMail($userInfo->email,$userInfo->first_name,$subject,$messageBody,$settingsEmail);
			Session::flash('flash_notices', trans('Password successfully reset.'));
			Auth::logout();
			return Redirect::route('login');
		}
	}// end resetPasswordSave()

  /**
	 * Method for used registration of new user
	 *
	 * @param null
	 *
	 * @return null
	 */
	public function register(){
		$formData				=	Input::all();

		if(!empty($formData)){
      $message	=	array(
            'phone.numeric'               => 'Phone number should be number.',
            'phone.unique'                => 'This phone number is already registered with us, try another.',
            'email.required'              => 'Please enter email address.',
            'email.email'                 => 'Please enter a valid email address.',
            'email.unique'                => 'This email address is already registered with us, try another.',
            'password.required'           => 'Please enter password.',
            'password.min'                => 'Password should be min 6 characters.',
            'confirm_password.required'   => 'Please enter confirm password.',
            'confirm_password.same'       => 'Confirm password and password should be same.',
          );
			$validate	=	array(
					'email' 				      =>	'required|email|unique:users,email,NULL,id,is_deleted,0',
					'phone'					      =>	'nullable|unique:users,phone',
					'password'				    =>	'required|min:6',
					'confirm_password' 		=>	'required|same:password',
			);
			$validator = Validator::make(Input::all(),$validate,$message);

			if ($validator->fails()){
				$allErrors 		= 	$validator->errors()->toArray();
				return response()->json(['status'=>'error','error'=>$allErrors]);
				die;
			}else{
        $password 					   =	Input::get('password');
        $correctPassword			 =	Hash::make($password);

        $fullName					=	"Customer";
        $fullName					=	strip_tags($fullName);
        $email						=	strip_tags(Input::get('email'));

        $obj 						=	new User;

        $validateString				=	md5(time() . Input::get('email'));
        $obj->validate_string	=	$validateString;
        $obj->full_name 			=	ucwords($fullName);
        $obj->first_name 			=	ucwords($fullName);
        $obj->email 				  =	strip_tags(Input::get('email'));
        $obj->phone 				  =	strip_tags(Input::get('phone'));
        $obj->slug			 		  =	Str::slug($fullName);
        $obj->password	 			=	strip_tags($correctPassword);
        $obj->user_role_id			=  	USER;
        $obj->active				  =  	ACTIVE;
        $obj->is_verified			=  	INACTIVE;
        $obj->is_deleted			=  	INACTIVE;

        $obj->save();

        $userdata = array(
          'email' 		=> Input::get('email'),
          'password' 		=> Input::get('password'),
        );
        Auth::attempt($userdata);

        $userId					=	$obj->id;
        $encId					=	md5(time() . Input::get('email'));

        //mail email and password to new registered user
        $settingsEmail 			=	Config::get('Site.email');
  			$full_name				=	"Customer";
  			$validateStr 			=  $validateString;
  			$route_url      		=  	route('email_verify',$validateStr);
  			$link 					=   $route_url;
  			$click_link 			= '<a target="_blank" style="font-weight:bold;text-decoration:none;color:#4286f4;" href="' . $link . '">Click Here</a>';

  			$emailActions			= 	EmailAction::where('action','=','account_verification')->get()->toArray();

  			$emailTemplates			= 	EmailTemplate::where('action','=','account_verification')
  											->get(array('name','subject','action','body'))->toArray();

  			$cons 					= 	explode(',',$emailActions[0]['options']);

  			$constants 				= 	array();

  			foreach($cons as $key => $val){
  				$constants[] 		= 	'{'.$val.'}';
  			}

  			$subject 				= 	$emailTemplates[0]['subject'];
  			$rep_Array 				= 	array($full_name,$click_link,$route_url);
  			$messageBody			= 	str_replace($constants, $rep_Array, $emailTemplates[0]['body']);

  			$mail					= 	$this->sendMail($email,$full_name,$subject,$messageBody,$settingsEmail);
				//mail to new registered user
				//Session::flash('success', trans("You have successfully register with us."));
        return response()->json(['status'=>'success','redirect_url'=>route("car_listing"),trans("You have successfully register with us.")]);
				 die;
			}
		}else{
			return response()->json(['status'=>'empty']);
			die;
		}
	}

  /*
  * function to display my orders
  */
  public function my_orders()
  {
    $results = Contract::where('user_id', Auth::user()->id)
                        ->where('payment_status', ACTIVE)
                        ->where('contract_complete_status','!=', INACTIVE)
                        ->orderBy('created_at', 'desc')
                        ->get();
    return view::make('pages/user/my_order',compact('results'));
  }
  /*
  * function to get my orders detail
  */
  public function myOrderDetail($order_id=0)
  {
    if (!empty($order_id)) {
      $result = Contract::where('user_id', Auth::user()->id)
                          ->where('order_id', $order_id)
                          ->first();
      if (empty($result)) {
        Session::flash('errorss','No order detail found.');
        return Redirect::route('my_orders');
      }else{
				$carData = unserialize($result['car_full_data']);
				$dealerData = unserialize($result['dealer_data']);
      }
      return view::make('pages/user/my_order_detail',compact('result','carData','dealerData'));
    }else {
      Session::flash('errorss','No order detail found.');
      return Redirect::route('my_orders');
    }
  }
}//end UserController()
