<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
/**
 * UserActivity Model
 */

class UserActivity extends Model  {

/**
 * The database table used by the model.
 *
 * @var string
 */

	protected $table = 'user_activities';

	/**
	 * Function for  bind user model for get user detail
	 *
	 * @param null
	 *
	 * return query
	 */

	public function userDetail(){
		return $this->belongsTo('App\Model\User','user_id')->select('id','image','gender');
	}//end userDetail()

	/**
	 * Function for  bind Provider Package model for get package detail
	 *
	 * @param null
	 *
	 * return query
	 */

	public function packageDetail(){
		return $this->belongsTo('App\Model\ProviderPackage','section_id')->select('id','title','slug');
	}//end packageDetail()


	public function portfolioDetail(){
		return $this->belongsTo('App\Model\Portfolio','section_id')->select('id','title','user_id');
	}//end portfolioDetail()

	public function ProviderCredentialDetail(){
		return $this->belongsTo('App\Model\ProviderCredential','section_id')->select('id','title','user_id');
	}//end ProviderCredentialDetail()

	public function blogDetail(){
		return $this->belongsTo('App\Model\Blog','section_id')->select('id','name','user_id');
	}//end ProviderCredentialDetail()


}// end UserActivity class
