<?php

namespace App\Services;

// use App\Services\GoogleLibraries;

class Firebase
{

    private $fields;

    public function __construct($title, $message, $to = "global")
    {
        $this->fields = match ($to) {
            'global' => [
                "message" => [
                    "topic" => $to,
                    "notification" => [
                        "title" => $title,
                        "body" => $message
                    ]
                ]
            ],
            default => [
                "message" => [
                    "token" => $to,
                    "notification" => [
                        "title" => $title,
                        "body" => $message,
                    ],
                ]
            ],
        };
    }

    // sending push message to single user by firebase reg id
    public function send()
    {
        return $this->sendAppNotification($this->fields);
    }

    // Sending message to a topic by topic name
    public function sendToTopic($to, $message)
    {
        $fields = array(
            'to' => '/topics/' . $to,
            'data' => $message,
            'notification' => $message,
        );
        // $this->sendPushNotification($fields);
        //  $fields = array(
        //      'to' => '/topics/' . $to,
        //      'notification' => $message,
        //  );
        return $this->sendPushNotification($fields);
    }

    // sending push message to multiple users by firebase registration ids
    public function sendMultiple($registration_ids, $message)
    {
        $fields = array(
            'to' => $registration_ids,
            'data' => $message,
        );

        return $this->sendPushNotification($fields);
    }

    // function makes curl request to firebase servers
    // private function sendPushNotification($fields) {
    //
    //     // Set POST variables
    //     $url = 'https://fcm.googleapis.com/fcm/send';
    //
    //     $headers = array(
    //         'Authorization: key=' . env('FIREBASE_API_KEY', ''),
    //         'Content-Type: application/json'
    //     );
    //     // Open connection
    //     $ch = curl_init();
    //     // Set the url, number of POST vars, POST data
    //     curl_setopt($ch, CURLOPT_URL, $url);
    //     curl_setopt($ch, CURLOPT_POST, true);
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     // Disabling SSL Certificate support temporarly
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    //
    //     // Execute post
    //     $result = curl_exec($ch);
    //     if ($result === FALSE) {
    //         die('Curl failed: ' . curl_error($ch));
    //     }
    //
    //     // Close connection
    //     curl_close($ch);
    //     return $result;
    // }


    public function sendAppNotification()
    {
        // echo "sendAppNotification";die;
        $client = new GoogleLibraries();
        $token = $client->generateToken();

        $tokenResponse = $client->generateToken();
        // dd($tokenResponse);
        if (@$tokenResponse->access_token == "") {
            return "token not generating from firebase google";
        }

        $apiurl = 'https://fcm.googleapis.com/v1/projects/FW11/messages:send';
        $headers = [
            'Authorization: Bearer ' . $tokenResponse->access_token,
            'Content-Type: application/json'
        ];

        // Open connection
        $ch = curl_init();

        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $apiurl);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($this->fields));

        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);
        // echo "string";die;
        // dd($result);
        return $result;
    }
}
