$(document).ready(function() {
	/*Show hide media modal*/
	 $('.create-ticket').on('click', function() {
		$('#create_ticket').modal('show');
		setTimeout(function(){
			$('body').addClass('modal-open');
		},1000);
	});
	/*Show hide media modal*/
	
  //create ticket form submit
  $('.create_ticket_submit').on('click', function(e) {
    e.preventDefault();
    $.ajax({
      type: 'POST',
      url: CREATE_TICKET_URL,
      data: $("#createTicketForm").serialize(),
      success: function(r) {
        if (r['status'] == 'error') {
          if (r['error']['ticket_name']) {
            $(".ticket_error").html(r['error']['ticket_name']);
          } else {
            $(".ticket_error").html('');
          }
          if (r['error']['event']) {
            $(".event_error").html(r['error']['event']);
          } else {
            $(".event_error").html('');
          }
          if (r['error']['price']) {
            $(".price_error").html(r['error']['price']);
          } else {
            $(".price_error").html('');
          }

        } else {
          $('#createTicketForm').trigger("reset");
          $('#create_ticket').modal('hide');
          location.reload();
        }
      }
    });
  });

  //edit ticket form submit
  $('.edit-ticket').on('click', function(e) {

	var id = $(this).attr('data-id');
	var C_URL = EDIT_TICKET_URL + "/" + id;
	var UPDATE_URL = UPDATE_TICKET_URL + "/" + id;
	$.ajax({
		type: 'GET',
		url: C_URL,
		data: {
		id: id
		},
		dataType: 'json',
		success: function(model) {
			
			$('#update_event').val(model.event);
			$('#update_ticket_name').val(model.ticket_name);
			$('#update_price').val(model.price);
			$('#update_quantity_available').val(model.available_quantity);
			$('#update_description').val(model.description);
			$('.update_startdate').val(model.start_date).change();
			$('.update_enddate').val(model.end_date).change();
			$('#update_min_ticket').val(model.min_ticket);
			$('#update_max_ticket').val(model.max_ticket);
			
			$('#update_startdate').datetimepicker({
				useCurrent: false,
				format:'MM/DD/YYYY HH:mm',
				minDate: moment(),
			});
			$('#update_enddate').datetimepicker({
				useCurrent: false,
				format:'MM/DD/YYYY HH:mm',
				minDate: moment(),
			});
			
			$('#update_ticket').modal('show');
	
			//update ticket form submit
			$('.update_ticket_submit').on('click', function(e) {
			e.preventDefault();
			$.ajax({
				type: 'POST',
				url: UPDATE_URL,
				data: $("#updateTicketForm").serialize(),
				success: function(r) {
				if (r['status'] == 'error') {
					if (r['error']['ticket_name']) {
						$(".update_ticket_error").html(r['error']['ticket_name']);
					} else {
						$(".update_ticket_error").html('');
					}
					if (r['error']['event']) {
						$(".update_event_error").html(r['error']['event']);
					} else {
						$(".update_event_error").html('');
					}
					if (r['error']['price']) {
						$(".update_price_error").html(r['error']['price']);
					} else {
						$(".update_price_error").html('');
					}
				} else {
					$('#updateTicketForm').trigger("reset");
					$('#update_ticket').modal('hide');
					location.reload();
				}
				}
			});
			});

      }
    });
  });

	
	/* For add datetimepicker */
	$('#start_date,#end_date').datetimepicker({
		useCurrent: false,
		format:'MM/DD/YYYY HH:mm',
		minDate: moment(),
	});
	$('#start_date').datetimepicker().on('dp.change', function (e) {
		var incrementDay = moment(new Date(e.date));
		incrementDay.add(0, 'days');
		$('#end_date').data('DateTimePicker').minDate(incrementDay);
		//$(this).data("DateTimePicker").hide();
	});

	$('#end_date').datetimepicker().on('dp.change', function (e) {
		var decrementDay = moment(new Date(e.date));
		decrementDay.subtract(0, 'days');
		$('#start_date').data('DateTimePicker').maxDate(decrementDay);
		// $(this).data("DateTimePicker").hide();
	});
	
	/* For update datetimepicker */
	/*$('#update_startdate,#update_enddate').datetimepicker({
		useCurrent: false,
		format:'MM/DD/YYYY HH:mm',
		minDate: moment(),
	});*/
	$('#update_startdate').datetimepicker().on('dp.change', function (e) {
		var incrementDay = moment(new Date(e.date));
		incrementDay.add(0, 'days');
		$('#update_enddate').data('DateTimePicker').minDate(incrementDay);
		//$(this).data("DateTimePicker").hide();
	});

	$('#update_enddate').datetimepicker().on('dp.change', function (e) {
		var decrementDay = moment(new Date(e.date));
		decrementDay.subtract(0, 'days');
		$('#update_startdate').data('DateTimePicker').maxDate(decrementDay);
		 //$(this).data("DateTimePicker").hide();
	});

});


