<?php

/**
 * @author Ravi Tamada
 * @link URL Tutorial link
 */
// use GoogleLibraries;
class Firebase {

    // sending push message to single user by firebase reg id
    public function send($to, $message) {
      echo "send";die;
        // $fields = array(
        //     'to' => $to,
        //     'data' => $message,
        // );
        // return $this->sendPushNotification($fields);

        $fields = array(
            "message" => [
                "token" => $to,
                // "token" => "fgpUppwYQ2qLJAh_qWMnDh:APA91bECQNRqmiO2b1FmdQ-YNmjIOmFY6w46h7loTUYpkNIeo1YOkTiWs1sHB2PgZ-gIta_Ka_ZKGOMKXJOrq8FZ1pmaqYuC_40-OeuvkBvk2brNdsrBkHmtFG7yuXg73j1mL44T-UrD",
                "notification" => [
                    "title" => $message['data']['title'],
                    "body" => $message['data']['message']
                ],
        //     'data' => [
        //     'type' => 'testing',
        //     'user_id' => '1101963',
        //     'challengeid' => '123456',
        // ]
            ]
        );
        // dd($fields);

        return $this->sendAppNotification($fields);
    }

    // Sending message to a topic by topic name
    public function sendToTopic($to, $message) {

        $fields = array(
            "message" => [
                "topic" => $to,
                "notification" => [
                  "title" => $message['title'],
                  "body" => $message['message']
                ]
            ]
        );


        return $this->sendAppNotification($fields);

    }

    // sending push message to multiple users by firebase registration ids
    public function sendMultiple($registration_ids, $message) {
        $fields = array(
            'to' => $registration_ids,
            'data' => $message,
        );

        return $this->sendPushNotification($fields);
    }

    // function makes curl request to firebase servers
    private function sendPushNotification($fields) {

        require_once __DIR__ . '/config.php';

        // Set POST variables
        $url = 'https://fcm.googleapis.com/fcm/send';

        $headers = array(
            'Authorization: key=' . FIREBASE_API_KEY,
            'Content-Type: application/json'
        );
        // Open connection
        $ch = curl_init();
        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);
        return $result;
    }

    public function sendAppNotification($fields) {
      echo "string";die;
        require_once('./sendnotification/google_libraries.php');
        $client = new GoogleLibraries();
        $token = $client->generateToken();

        $tokenResponse = $client->generateToken();
        if(@$tokenResponse->access_token == "") {
            return "token not generating from firebase google";
        }

        $apiurl = 'https://fcm.googleapis.com/v1/projects/munch11/messages:send';
        $headers = [
            'Authorization: Bearer ' . $tokenResponse->access_token,
            'Content-Type: application/json'
        ];

        // Open connection
        $ch = curl_init();

        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $apiurl);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);
dd($result);
        return $result;
    }
}

?>
