@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Advertisment</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view') }}">In-App Banner Ads</a></li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit In-App Banner</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route('Advertisments.edit', base64_encode(serialize($Advertisments->id))) }}"
                                method="POST" id="advertismentsEditForm" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Title</label>
                                        <input id="title" type="text" placeholder="enter title here" name="title"
                                            class="form-control in_text" value="{{ $Advertisments->title }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('title'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">URL</label>
                                        <input class="form-control in_text" autocomplete="off" placeholder="Url"
                                            id="url" name="url" aria-describedby="inputSuccess2Status2"
                                            type="text" value="{{ $Advertisments->url }}">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Type</label>
                                        <select class="form-control in_text bor-input js-example-basic-single"
                                            name="type" id="typeId">
                                            <option value="">Select Type</option>
                                            <!-- <option value="home" <?php //if(!empty($Advertisments->type) && $Advertisments->type ='home') echo "Selected"; else echo "";
                                            ?>><?php echo strtoupper(BANNER_TYPE_HOME); ?></option>
                                        <option value="addcash" <?php //if(!empty($Advertisments->type) && $Advertisments->type ='addcash') echo "Selected"; else echo "";
                                        ?>><?php echo strtoupper(BANNER_TYPE_ADD_CASH); ?></option> -->
                                            <option {{ old('type', $Advertisments->type) == 'home' ? 'selected' : '' }}
                                                value="home">HOME</option>
                                            <option {{ old('type', $Advertisments->type) == 'addcash' ? 'selected' : '' }}
                                                value="addcash">ADDCASH</option>
                                            <option {{ old('type', $Advertisments->type) == 'popup' ? 'selected' : '' }}
                                                value="popup"><?php echo strtoupper(BANNER_TYPE_POPUP); ?></option>
                                            <option {{ old('type', $Advertisments->type) == 'tdspolicy' ? 'selected' : '' }}
                                                value="tdspolicy">Tds Policy</option>
                                            <option {{ old('type', $Advertisments->type) == 'refer_earn' ? 'selected' : '' }}
                                                value="refer_earn">Refer Earn</option>


                                        </select>
                                    </div>

                                    <div class="form-group col-md-6" style="display: none;" id="offer_code">
                                        <label class="lbl_frm py-2">Offer Code</label>
                                        <input type="text" placeholder="Enter offer code" name="offer_code"
                                            class="form-control in_text" value="{{ @$Advertisments->offer_code }}">
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6" id="offer_coded">
                                        <label class="lbl_frm py-2">sort</label>
                                        <input type="number" placeholder="Enter sort value" name="sort"
                                            class="form-control in_text" value="{{ @$Advertisments->sort }}">
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Image</label>
                                        <input type='file' id="" accept=".png, .jpg, .jpeg" name="image"
                                            class="form-control in_text" />
                                        <!-- <input type="hidden" name="base64image" name="base64image" id="base64image"> -->
                                        <label for="imageUpload"></label>
                                        <!-- <input class="form-control in_text" name="image" id="image" type="file"> -->
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('image'); ?>
                                        </div>
                                        <?php if($Advertisments->image!=""){ ?>
                                        <img src="<?php echo $Advertisments->image; ?>" class="py-2" style="width:100px;height:100px;">
                                        <?php
                                    }else{
                                      ?>
                                        <img src="<?php echo url()->asset('images/logo.png'); ?>" class="py-2" style="width:100px;height:100px;">
                                        <?php } ?>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('image'); ?>
                                        </div>

                                    </div>
                                </div>
                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
                Content body end
            ***********************************-->

    <div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog"
        aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <!-- <span aria-hidden="true">&times;</span> -->
                    </button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <div class="row">
                            <div class="col-md-11">
                                <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                    <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
                </div>
            </div>
        </div>
    </div>



    <!-- <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script> -->
    <!-- <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script> -->
    <!-- <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script> -->
    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.6/cropper.js"></script> -->
    <script>
        var $modal = $('.imagecrop');
        var image = document.getElementById('image');
        var cropper;
        $("body").on("change", ".imageUpload", function(e) {
            var files = e.target.files;
            var done = function(url) {
                image.src = url;
                $modal.modal('show');
            };
            var reader;
            var file;
            var url;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        });
        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 0,
                viewMode: 0,
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });
        $("body").on("click", "#crop,#crop1", function() {
            canvas = cropper.getCroppedCanvas({
                width: 160,
                height: 160,
            });
            canvas.toBlob(function(blob) {
                url = URL.createObjectURL(blob);
                var reader = new FileReader();
                reader.readAsDataURL(blob);
                reader.onloadend = function() {
                    var base64data = reader.result;
                    $('#base64image').val(base64data);
                    // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                    $modal.modal('hide');
                }
            });
        })
    </script>

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });

            $(document).on('change', '#typeId', function() {
                let val = $('#typeId').val();
                if (val == 'addcash') {
                    $('#offer_code').show();
                }
            });
        });
    </script>
@endsection
