@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Offers</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.viewOffers') }}">View all offers</a>
                    </li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Offers</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            @foreach ($findOffer as $offer)
                                <form action="{{ route('Advertisments.editOffers', base64_encode(serialize($offer->id))) }}"
                                    id="offersEditForm" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="id" id="id" value="{{ $offer->id }}">
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Minimum Amount</label>
                                            <input id="minamount" type="number" placeholder="enter minimum amount here"
                                                name="minamount" class="form-control in_text"
                                                value="{{ $offer->minamount }}" maxlength="10">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('minamount'); ?>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Maximum Amount</label>
                                            <input id="maxamount" type="number" placeholder="enter maximum amount here"
                                                name="maxamount" class="form-control in_text"
                                                value="{{ $offer->maxamount }}" maxlength="10">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('maxamount'); ?>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <fieldset class="form-group">
                                                <div class="row mx-0">
                                                    <label class="lbl_frm">Bonus Type</label>
                                                    <div class="col-sm-9 px-0">
                                                        <div class="form-check frm_chk">
                                                            <input class="form-check-input" type="radio" name="bonus_type"
                                                                id="bonus_type" value="per" <?php if($offer->bonus_type == 'per'){ ?> checked
                                                                <?php }?>>
                                                            <label class="form-check-label">
                                                                Percentage
                                                            </label>
                                                        </div>
                                                        <div class="form-check frm_chk">
                                                            <input class="form-check-input" type="radio" name="bonus_type"
                                                                id="bonus_type" value="rs" <?php if($offer->bonus_type == 'rs'){ ?> checked
                                                                <?php }?>>
                                                            <label class="form-check-label">
                                                                Rupees
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('bonus_type'); ?>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Bonus</label>
                                            <input class="form-control in_text" autocomplete="off"
                                                placeholder="enter bonus here" id="bonus" name="bonus" type="number"
                                                value="{{ $offer->bonus }}">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('bonus'); ?>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <fieldset class="form-group">
                                                <div class="row mx-0">
                                                    <label class="lbl_frm py-2">Bonus Credit Wallet</label>
                                                    <?php $transactionby = $offer->btype; ?>
                                                    <select name="bonuscredittype" class="form-control in_text">
                                                        <option value="">Select Wallet </option>
                                                        <option value="balance"
                                                            @if ($transactionby == 'balance') selected @endif> Deposit
                                                        </option>
                                                        <option value="winning"
                                                            @if ($transactionby == 'winning') selected @endif> Winning
                                                        </option>
                                                        <option value="bonus"
                                                            @if ($transactionby == 'bonus') selected @endif> Bonus
                                                        </option>
                                                        <option value="affiliation_commission"
                                                            @if ($transactionby == 'affiliation_commission') selected @endif> Affiliation
                                                        </option>
                                                        <option value="gst_bonus"
                                                            @if ($transactionby == 'gst_bonus') selected @endif> GST/TDS Bonus
                                                        </option>
                                                    </select>
                                                </div>
                                            </fieldset>
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('bonuscredittype'); ?>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Promo Code</label>
                                            <input class="form-control in_text" autocomplete="off"
                                                placeholder="Enter promo code here" id="code" name="code"
                                                type="text" value="{{ $offer->code }}">
                                            <div class="error-message help-inline row col-md-6 px-0">
                                                <?php echo $errors->first('code'); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php /* ?> ?>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <fieldset class="form-group">
                                                <div class="row mx-0">
                                                    <label class="lbl_frm">Bonus Credit wallet</label>
                                                    <div class="col-sm-9 px-0">
                                                        <div class="form-check frm_chk">
                                                            <input class="form-check-input" type="radio" name="btype"
                                                                id="" required value="deposit"
                                                                <?php if($offer->btype == 'deposit'){ ?> checked <?php }?>>
                                                            <label class="form-check-label">
                                                                Deposit
                                                            </label>
                                                        </div>
                                                        <div class="form-check frm_chk">
                                                            <input class="form-check-input" type="radio" name="btype"
                                                                id=""required value="bonus" <?php if($offer->btype == 'bonus'){ ?>
                                                                checked <?php }?>>
                                                            <label class="form-check-label">
                                                                Bonus
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </fieldset>
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('bonus_type'); ?>
                                            </div>
                                        </div>

                                    </div> <?php */ ?>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Expire Date</label>
                                            <input class="form-control datetimepickerget in_text" autocomplete="off"
                                                placeholder="enter expire date here" id="expire_date" name="expire_date"
                                                type="text" value="{{ $offer->expire_date }}">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('expire_date'); ?>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Description</label>
                                            <input class="form-control in_text" autocomplete="off"
                                                placeholder="enter description here" id="description" name="description"
                                                type="text" value="{{ $offer->description }}">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('description'); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">First Deposit</label>
                                            <div class="form-check frm_chk py-2">
                                                <input class="form-check-input" value="1" type="checkbox"
                                                    <?php if(isset($offer->first_deposit) && $offer->first_deposit==1){ ?> checked <?php } ?> name="first_deposit"
                                                    id="first_deposit">
                                            </div>
                                        </div>
                                        <!-- <div class="form-group col-md-6">
                                            <fieldset class="form-group">
                                                <div class="row mx-0">
                                                    <label class="lbl_frm py-2">For All Users</label>
                                                    <div class="form-check frm_chk py-2">
                                                        <input class="form-check-input" value="1" type="checkbox"
                                                            name="is_for_all" id="is_for_all" <?php if(isset($offer->is_for_all) && $offer->is_for_all==1){ ?> checked
                                                            <?php } ?>>
                                                    </div>
                                                </div>
                                                <fieldset>
                                                    <small>Note: Keep it unchecked if you want to upload csv for
                                                        users.</small>

                                        </div> -->
                                    </div>
                                    <div class="form-row">
                                        <!-- <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Maximum Utilization Per User</label>
                                            <input id="per_user_count" type="text"
                                                placeholder="enter maximum utilization" name="per_user_count"
                                                class="form-control in_text" value="{{ $offer->per_user_count }}">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('per_user_count'); ?>
                                            </div>
                                        </div> -->
                                        <!-- <div class="form-group col-md-6">
                                            <fieldset class="form-group">
                                                <div class="row mx-0">
                                                    <label class="lbl_frm py-2">Show In Apps</label>
                                                    <div class="form-check frm_chk py-2">
                                                        <input class="form-check-input" value="1" type="checkbox"
                                                            name="status" id="status" <?php if(isset($offer->status) && $offer->status==1){ ?> checked
                                                            <?php } ?>>
                                                    </div>
                                                </div>
                                                <fieldset>

                                        </div> -->
                                    </div>
                                    <div class="py-2">
                                        <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                        <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                    </div>
                                </form>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--***************************Content body end ****************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
@endsection
