@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Offers list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Offers</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
      <div class="col-12">
          <div class="card" data-aos="fade-up">
             <div class="card-header">
                <h4>All Offers</h4>
                <a href="{{route('Advertisments.addNewOffers')}}" class="btn btn-primary btn-sm"> Add New Offer</a>
              </div>
              <div class="card-body">
                  <div class="table-responsive">
                      <table id="dataList" class="display" style="min-width: 845px">
                          <thead>
                              <tr>
                              <th>S No.</th>
                              <th>Minimum Amount</th>
                              <th>Maximum Amount</th>
                              <th>Bonus Type</th>
                              <th>Bonus</th>
                              <th>Wallet</th>
                              <th>Code</th>
                              <th>Description</th>
                              <th>Expiry Date</th>
                              <th>For All</th>
                              <th>Uses</th>
                              <th>Action</th>
                          </tr>
                          </thead>
                          <tfoot>
                              <tr>
                              <th>S No.</th>
                              <th>Minimum Amount</th>
                                <th>Maximum Amount</th>
                              <th>Bonus Type</th>
                              <th>Bonus</th>
                              <th>Wallet</th>
                              <th>Code</th>
                              <th>Description</th>
                              <th>Expiry Date</th>
                              <th>For All</th>
                              <th>Uses</th>

                              <th>Action</th>
                          </tr>
                          </tfoot>
                      </table>
                  </div>
              </div>
          </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.viewOffers')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable: false, searchable: false},
            {data: 'minamount', name: 'minamount'},
            {data: 'maxamount', name: 'maxamount'},
            {data: 'bonus_type', name: 'bonus_type'},
            {data: 'bonus', name: 'bonus'},
            {data: 'btype', name: 'btype'},
            {data: 'code', name: 'code'},
            {data: 'description', name: 'description'},
            {data: 'expire_date', name: 'expire_date'},
            {data: 'is_for_all', name: 'is_for_all'},
            {data: 'per_user_count', name: 'per_user_count'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

    $(document).on('click', '.confirm_delete', function () {
      if(!confirm("Confirm to Delete this offer?"))
      event.preventDefault();
    });


});
</script>
@endsection
