@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!-- <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous"> -->
    <style type="text/css">
        th {
            color: #30323f;
        }

        .pagination {
            display: inline-block;
            padding-left: 0;
            margin: 20px 0;
            border-radius: 4px;
            margin-right: 20px;
        }

        .pagination>li {
            display: inline;
        }

        .pagination>li.active>span {
            background-color: #30323f;
            color: white;
        }

        .pagination>li>a,
        .pagination>li>span,
        .pagination>.disabled>a {
            background-color: #393e45;
            border-color: #4a5059;
        }

        .pagination>li>a,
        .pagination>li>span {
            position: relative;
            float: left;
            padding: 6px 12px;
            margin-left: -1px;
            line-height: 1.42857143;
            color: #337ab7;
            text-decoration: none;
            background-color: #fff;
            border: 1px solid #ddd;
            border-top-color: rgb(221, 221, 221);
            border-right-color: rgb(221, 221, 221);
            border-bottom-color: rgb(221, 221, 221);
            border-left-color: rgb(221, 221, 221);
        }

        @media only screen and (max-width: 600px) {}
    </style>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>GST Report</h4>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">GST Report</a></li>
                    </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4>GST Report</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.gst_report2') }}" method="GET" id="searchGstForm"
                                enctype="multipart/form-data"
                                @php
$start_date = @$_GET['start_date'] != '' ? $_GET['start_date'] : date('Y-m-d', strtotime("2020-09-01"));
                                $end_date = @$_GET['end_date'] != '' ? $_GET['end_date'] : date('Y-m-d', strtotime("2020-09-30"));
                                $matchkey = @$_GET['matchkey'] != '' ? $_GET['matchkey'] : '';
                                $sport_type = @$_GET['sport_type'] != '' ? $_GET['sport_type'] : '';
                                $challenge_id = @$_GET['challenge_id'] != '' ? $_GET['challenge_id'] : ''; @endphp
                                <div class="form-row">

                                <div class="form-group col-md-2 mb-0">
                                    <label>Start Date</label>
                                    <div class="form-group col-md-6">
                                        <input type="text" name="start_date" id="start_date"
                                            class="pull-left form-control datetimepickerget w-95"
                                            value="{{ isset($start_date) && !empty($start_date) ? $start_date : '' }}"
                                            autocomplete="off">
                                    </div>
                                </div>

                                <div class="form-group col-md-2 mb-0">
                                    <label>End Date</label>
                                    <div class="form-group col-md-6">
                                        <input type="text" name="end_date" id="end_date"
                                            class="pull-left form-control datetimepickerget w-95"
                                            value="{{ isset($end_date) && !empty($end_date) ? $end_date : '' }}"
                                            autocomplete="off">
                                    </div>
                                </div>

                                <!-- <div class="form-group col-md-2 mb-0">
                                        <label>Match Id</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="matchkey" id="matchkey" class="pull-left form-control w-95" value="{{ isset($matchkey) && !empty($matchkey) ? $matchkey : '' }}">
                                        </div>
                                    </div>

                                    <div class="form-group col-md-2 mb-0">
                                        <label>Challenge Id</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="challenge_id" id="challenge_id" class="pull-left form-control w-95" value="{{ isset($challenge_id) && !empty($challenge_id) ? $challenge_id : '' }}">
                                        </div>
                                    </div> -->



                        </div>

                    </div>
                </div>
                <div class="card-footer py-4">
                    <button name="get-report" type="submit" class="btn btn-primary">Get GST Report</button>
                </div>
                </form>

                <div class="card-footer py-4">
                    <form id="Downlode_GSTForm" action="{{ route('Analytics.gst_report2') }}" method="get">
                        <input type="hidden" name="start_date" value="{{ $start_date }}">
                        <input type="hidden" name="end_date" value="{{ $end_date }}">
                        <input type="hidden" name="matchkey" value="{{ $matchkey }}">

                        <input type="hidden" name="challenge_id" value="{{ $challenge_id }}">
                        <input type="hidden" name="download" value="download">
                        <button id="Downlode_GSTBtn" class="btn btn-primary gst-download">Download GST Report
                        </button>
                    </form>

                </div>


                <div id="datatablediv" class="card-body">
                    <div class="table-responsive">

                        <table id="dataList" class="table table-striped" class="display" style="min-width: 845px"
                            style="display: none;">
                            <thead>
                                <tr>
                                    <th>S. NO</th>
                                    <th>INVOICE NO</th>
                                    <th>INVOICE DATE</th>
                                    <th>CUSTOMER ID</th>
                                    <th>STATE OF CUSTOMER</th>
                                    <th>Referer Email</th>
                                    <th>Referer Name</th>
                                    <th>Referer Comisssion</th>
                                    <th>Sports</th>
                                    <th>Match Title</th>
                                    <th>Match Id</th>
                                    <th>Challenge Id</th>
                                    <th>CONTEST FEES</th>
                                    <th>Challenge status</th>
                                    <th>RATE%</th>
                                    <th>TOTAL PLATFORM FEES</th>
                                    <th>AFTER TAX PLATFORM FEES</th>
                                    <th>IGST</th>
                                    <th>SGST</th>
                                    <th>CGST</th>
                                    <th>Total Tax to Pay</th>
                                </tr>
                            </thead>

                            <tbody>

                            </tbody>

                            <tr>
                                <th>Total</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>

                            </tr>
                        </table>

                    </div>
                </div>



            </div>
        </div>
    </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            var start_date = $('#start_date').val();
            var end_date = $('#end_date').val();
            var matchkey = $('#matchkey').val();
            var challenge_id = $('#challenge_id').val();

            $.fn.dataTable.ext.errMode = 'none';
            $('#dataList').DataTable({
                // order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "searching": false,
                "ajax": {
                    "url": '<?php echo url()->asset('admin/analytics/gst-report'); ?>?start_date=' + start_date + '&end_date=' + end_date +
                        '&matchkey=' + matchkey + '&challenge_id=' + challenge_id + '&sport_type=' +
                        sport_type,
                    "dataType": "json",
                    "type": "POST",
                    "data": {
                        _token: "{{ csrf_token() }}"
                    }
                },
                "columns": [{
                        "data": "s_no"
                    },
                    {
                        "data": "invoiceno"
                    },
                    {
                        "data": "InvoiceDate"
                    },
                    {
                        "data": "CustomerID"
                    },
                    {
                        "data": "state"
                    },
                    {
                        "data": "email"
                    },
                    {
                        "data": "username"
                    },
                    {
                        "data": "comisssion"
                    },
                    {
                        "data": "title"
                    },
                    {
                        "data": "matchkey"
                    },
                    {
                        "data": "challenge_id"
                    },
                    {
                        "data": "contestfees"
                    },
                    {
                        "data": "status"
                    },
                    {
                        "data": "rate"
                    },
                    {
                        "data": "total_platform_fees"
                    },
                    {
                        "data": "before_tax_platform_fees"
                    },
                    {
                        "data": "igst"
                    },
                    {
                        "data": "sgst"
                    },
                    {
                        "data": "cgst"
                    },
                    {
                        "data": "total_tax"
                    },
                ]

            });
        });
    </script>
    <style type="text/css">
        #dataList_wrapper {
            overflow-x: scroll;
        }
    </style>


    <script type="text/javascript">
        //datepicket without time
        $(document).ready(function() {
            $('#end_date,#start_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d',
                closeOnDateSelect: true,
            });
        });

        $(document).on('click', '#Downlode_GSTBtn', function(event) {
            $("#Downlode_GSTForm").submit();
        });
    </script>
@endsection
