@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
  {{ HTML::style('css/admin/datatable.css') }}
  {{ HTML::script("js/admin/datatable.js") }}
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>GST Report</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">GST Report</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header"><h4>GST Report</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                      {{ Form::open(['role' => 'form','id'=>'Downlode_GSTForm','route'=>[$modelName.'.download_gst_report'],'files' => true,'method' => 'get']) }}
                    {{csrf_field()}}
                        @php
                        $matchkey="";$start_date="";$end_date="";
                        if(isset($_GET['start_date'])){
                          $start_date = $_GET['start_date'];
                        }
                        if(isset($_GET['end_date'])){
                          $end_date = $_GET['end_date'];
                        }
                        @endphp
                            <div class="form-row">
                                <div class="form-group col-md-6 mb-0">
                                    <label>Start Date</label>
                                    <div class="form-group col-md-6">
                                    <input type="text" required="" name="start_date" id="start_date" class="pull-left form-control datetimepickerget w-95" value="{{isset($start_date) && !empty($start_date) ? $start_date:''}}" autocomplete="off">
                                </div>
                                </div>

                                <div class="form-group col-md-6 mb-0">
                                    <label>End Date</label>
                                    <div class="form-group col-md-6">
                                    <input type="text" required="" name="end_date" id="end_date" class="pull-left form-control datetimepickerget w-95" value="{{isset($end_date) && !empty($end_date) ? $end_date:''}}" autocomplete="off">
                                </div>
                                </div>
                             </div>
                        {{ Form::close() }}
                    </div>
                </div>
                <div class="card-footer py-4"><button type="submit" class="btn btn-primary show-data">Get GST Report</button></div>
                </div>

                <div class="card-body d-none">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Challange Id</th>
                                <th>IsMarthon</th>
                                <th>Match Key</th>
                                <th>Match Status</th>
                                <th>Max Allowed Users</th>
                                <th>Joined Users</th>
                                <th>User ID</th>
                                <th>Entry Fee</th>
                                <th>Win Amount</th>
                                <th>Date</th>
                                <th>Invoice No</th>
                                <th>Pool Prize</th>
                                <th>Plate Form Fee</th>
                                <th>IGST</th>
                                <th>CGST</th>
                                <th>SGST</th>
                                <th>Margin %</th>
                                <th>User State</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Challange Id</th>
                                <th>IsMarthon</th>
                                <th>Match Key</th>
                                <th>Match Status</th>
                                <th>Max Allowed Users</th>
                                <th>Joined Users</th>
                                <th>User ID</th>
                                <th>Entry Fee</th>
                                <th>Win Amount</th>
                                <th>Date</th>
                                <th>Invoice No</th>
                                <th>Pool Prize</th>
                                <th>Plate Form Fee</th>
                                <th>IGST</th>
                                <th>CGST</th>
                                <th>SGST</th>
                                <th>Margin %</th>
                                <th>User State</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">

// $(document).ready(function(){
//     $('#dataList').DataTable({
//       order: [1, 'desc'],
//         "processing": true,
//         "serverSide": true,
//         "ajax":{
//           url:"{{route($modelName.'.gst_report')}}",
//           type: "POST",
//           data : {"_token": "{{ csrf_token() }}"}
//         },
//         "columns": [
//             {data: 'DT_RowIndex', name: 'DT_RowIndex'},
//             {data: 'challengeid', name: 'challengeid'},
//             {data: 'marathon', name: 'marathon'},
//             {data: 'matchkey', name: 'matchkey'},
//             {data: 'final_status', name: 'final_status'},
//             {data: 'maximum_user', name: 'maximum_user'},
//             {data: 'joinedusers', name: 'joinedusers'},
//             {data: 'userid', name: 'userid'},
//             {data: 'entryfee', name: 'entryfee'},
//             {data: 'win_amount', name: 'win_amount'},
//             {data: 'joineddate', name: 'joineddate'},
//             {data: 'transaction_id', name: 'transaction_id'},
//             {data: 'getpoolprize', name: 'getpoolprize'},
//             {data: 'platformfee', name: 'platformfee'},
//             {data: 'igst', name: 'igst'},
//             {data: 'cgst', name: 'cgst'},
//             {data: 'sgst', name: 'sgst'},
//             {data: 'margin', name: 'margin'},
//             {data: 'state', name: 'state'},
//         ]
//     });
// });

//datepicket without time
$(document).ready(function(){
    $('#end_date,#start_date').datetimepicker({
        timepicker: false,
        format:'Y-m-d'
    });

    var d = new Date();

    var month = d.getMonth()+1;
    var day = d.getDate();

    var output = d.getFullYear() + '-' +
    (month<10 ? '0' : '') + month + '-' +
    (day<10 ? '0' : '') + day;

    $('#end_date,#start_date').val(output);
});

//Select Date Show Data
$(document).on('click', '.show-data', function(event){
    event.preventDefault();
    $('#dataList').DataTable().clear().destroy();
    var start_date=$('#start_date').val();
    var end_date=$('#end_date').val();
    $('#dataList').DataTable({
      order: [1, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.gst_report')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}",start_date:start_date,end_date:end_date}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'challengeid', name: 'challengeid'},
            {data: 'marathon', name: 'marathon'},
            {data: 'matchkey', name: 'matchkey'},
            {data: 'final_status', name: 'final_status'},
            {data: 'maximum_user', name: 'maximum_user'},
            {data: 'joinedusers', name: 'joinedusers'},
            {data: 'userid', name: 'userid'},
            {data: 'entryfee', name: 'entryfee'},
            {data: 'win_amount', name: 'win_amount'},
            {data: 'joineddate', name: 'joineddate'},
            {data: 'transaction_id', name: 'transaction_id'},
            {data: 'getpoolprize', name: 'getpoolprize'},
            {data: 'platformfee', name: 'platformfee'},
            {data: 'igst', name: 'igst'},
            {data: 'cgst', name: 'cgst'},
            {data: 'sgst', name: 'sgst'},
            {data: 'margin', name: 'margin'},
            {data: 'state', name: 'state'},
        ]
    });
    $( "#Downlode_GSTForm" ).submit();
});
</script>
@endsection
