@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <div class="welcome-text">
                    <h4>Bot Add Screen</h4>
                    <!-- <span class="ml-1">Layout</span> -->
                </div>
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.create_challenge') }}">Challenge
                            Category</a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Bot Add Screen</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Bot Add Screen</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route('AutoBots.addBotsInChallengeAPI') }}" id="MatchAddForm" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Match Name:</label>
                                        <label class="form-check-label"> <b>{{ ucwords($findmatchnames->name) }}</b></label>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Entry Fee:</label>
                                        <label class="form-check-label"> <b>{{ $challenge->entryfee }}</b></label>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Total Bots Available :</label>
                                        <label class="form-check-label"> <b>{{ $botsAvailble }}</b></label>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Total Bots Used :</label>
                                        <label class="form-check-label"> <b>{{ $botsUsed }}</b></label>
                                    </div>

                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Add Number of bots </label>
                                        <input type="hidden" name="challenge_id" value="{{ $challenge->id }}">
                                        <input type="text" class="form-control" min="0" name="number_of_bots"
                                            required>
                                    </div>
                                    <!-- <div class="form-group col-md-6">
                                        <label>Total Bots Used :</label>
                                        <label class="form-check-label"> <b>111</b></label>
                                    </div> -->

                                </div>




                        </div>

                        <br>
                        <div class="form-group col-md-6 py-2">
                            <button type="submit" class="btn btn-primary">Add Bot</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!--**********************************
      Content body end
    ***********************************-->


    <script type="text/javascript">
        function show3() {
            if (document.getElementById("bonus").checked == true) {
                document.getElementById('bonus_precents').style.display = 'block';
            } else {
                document.getElementById('bonus_precents').style.display = 'none';
            }
        }


        function showHideGiveawayAmount(event) {
            if (event.target.checked) {
                $("#toggleGiveawayAmount").show();
            } else {
                $("#toggleGiveawayAmount").hide();
            }
        }



        function showHideOfferFields(event) {
            if (event.target.checked) {
                $("#toggleOfferFields").show();
            } else {
                $("#toggleOfferFields").hide();
            }
        }

        function showHideChampionFields(event) {
            if (event.target.checked) {
                $("#toggleChampionFields").show();
            } else {
                $("#toggleChampionFields").hide();
            }
        }

        $(document).ready(function() {
            let canUseBonus = <?php echo $challenge->bonus; ?>;
            console.log(canUseBonus);
            if (canUseBonus == 1)
                $("#bonus_precents").show();
            else
                $("#bonus_precents").hide();

            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });

        });
    </script>
@endsection
