@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Add Match League</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route($modelName . '.create_challenge') }}">Challenge Category</a>
                    </li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">Add</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add Promoter Private League</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.add_private_contest') }}" id="MatchAddForm" method="POST"
                                enctype="multipart/form-data">

                                <div class="form-row my-3">

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Contest Invite Code</label>
                                        <input type="text" min="0" id="ContestCode" name="ContestCode"
                                            class="form-control in_text" onchange="enablebuttons(this.value);">

                                        <input type="hidden" id="contestidSerialize" name="contestidSerialize"
                                            class="form-control in_text">

                                        <button class="btn btn-primary" type="button" onclick="fetchContestData()">Fetch
                                            Contest Data </button>

                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Contest Id</label>
                                        <input type="text" readonly id="ContestId" name="ContestId"
                                            class="form-control in_text" value="{{ old('ContestId') }}">

                                    </div>


                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Contest Name</label>
                                        <input type="text" readonly id="ContestName" name="ContestName"
                                            class="form-control in_text" value="{{ old('ContestName') }}">

                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Contest EntryFee</label>
                                        <input type="text" readonly id="ContestEntryfee" name="ContestEntryfee"
                                            class="form-control in_text" value="{{ old('ContestEntryfee') }}">

                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Contest WinAmount</label>
                                        <input type="text" readonly id="ContestWinAmount" name="ContestWinAmount"
                                            class="form-control in_text" value="{{ old('ContestWinAmount') }}">

                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Edit Invite Code</label>
                                        <input type="text" id="ContestUpdateCode" name="ContestUpdateCode"
                                            class="form-control in_text" value="{{ old('ContestUpdateCode') }}">
                                        <input type="hidden" id="ContestJoinId" name="ContestJoinId"
                                            class="form-control in_text" value="{{ old('ContestJoinId') }}">
                                        <button type="button" class="btn btn-primary" id='updateContestInviteCode'
                                            onclick="updateContestInviteCode()">Update contest code</button>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Edit Contest Details</label>
                                        <button class="btn btn-primary" id="Edit_Contest_Details" type="button"
                                            onclick="editContestDetails()">Edit Contest Details</button>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Edit Price card</label>
                                        <button class="btn btn-primary" id="editPricecard" type="button"
                                            onclick="editPricecard()">Edit price Card</button>
                                    </div>

                                </div>

                        </div>
                        <div class="py-2">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!--**********************************
        Content body end
    ***********************************-->

    <script type="text/javascript">
        $('#ContestCode').change(function() {
            if (ContestCode == '' || ContestCode == 'undefine') {
                document.getElementById("Edit_Contest_Details").disabled = true;
                document.getElementById("updateContestInviteCode").disabled = true;
                document.getElementById("editPricecard").disabled = true;
            } else {

                document.getElementById("Edit_Contest_Details").disabled = false;
                document.getElementById("updateContestInviteCode").disabled = false;
                document.getElementById("editPricecard").disabled = false;
            }
        });
        $(document).ready(function() {
            var ContestCode = $('#ContestCode').val();
            if (ContestCode == '' || ContestCode == 'undefine') {
                document.getElementById("Edit_Contest_Details").disabled = true;
                document.getElementById("updateContestInviteCode").disabled = true;
                document.getElementById("editPricecard").disabled = true;

            }

        });



        function fetchContestData() {
            let contestid = $("#ContestCode").val();
            // alert(contestid);
            $.ajax({
                url: "{{ route($modelName . '.fetchContestData') }}",
                type: "post",
                data: {
                    "id": contestid
                },
                success: function(res) {
                    console.log(res);
                    if (res) {
                        $("#ContestId").val(res.id);
                        $("#ContestName").val(res.name);
                        $("#ContestWinAmount").val(res.win_amount);
                        $("#ContestEntryfee").val(res.entryfee);
                        $("#contestidSerialize").val(res.serializeId);

                        $("#ContestUpdateCode").val(res.JoinContestCode);
                        $("#ContestJoinId").val(res.joinId);


                    }
                    // res.
                    // $("#registerusers").html(res);
                },
                error: function(err) {
                    console.log(err);
                }
            });
        }


        function updateContestInviteCode() {

            let joinId = $("#ContestJoinId").val();
            let ContestUpdateCode = $("#ContestUpdateCode").val();

            $.ajax({
                url: "{{ route($modelName . '.updateContestInviteCode') }}",
                type: "post",
                data: {
                    "ContestUpdateCode": ContestUpdateCode,
                    "joinId": joinId
                },
                success: function(res) {
                    console.log(res);
                    if (res) {
                        alert("Invite Code Updated");
                    }
                    // res.
                    // $("#registerusers").html(res);
                },
                error: function(err) {
                    console.log(err);
                }
            });

        }

        function editContestDetails() {
            var contest_id = $("#contestidSerialize").val();
            // window.location.href="https://admin.kuberafantasy.live/admin/challenges/edit-match-challenge/"+$("#contestidSerialize").val();
            if (contest_id == '' || contest_id == 'undefined') {
                alert('Could not allow empty Contest ID ');
                return false;
            } else {
                window.location.href =
                    "https://fantasy.rgisports.com/repos/gameon11/gameon11_admin/admin/challenges/edit-match-challenge/" +
                    $("#contestidSerialize").val();

            }
        }

        function editPricecard() {
            var contest_id = $("#contestidSerialize").val();
            if (contest_id == '' || contest_id == 'undefined') {
                alert('Could not allow empty Contest ID ');
                return false;
            } else {
                // window.location.href="https://admin.kuberafantasy.live/admin/challenges/add-match-pricecard/"+$("#contestidSerialize").val();
                window.location.href =
                    "https://fantasy.rgisports.com/repos/gameon11/gameon11_admin/admin/challenges/add-match-pricecard/" + $(
                        "#contestidSerialize").val();

                admin.fantasy.rgisports.com
            }
        }
        // $(document).ready(function(){
        //   $("input[name$='challenge_type']").click(function() {
        //       var test = $(this).val();
        //       if(test=='percentage'){
        //         $("#winn_percent").show();
        //         $("#maximum_user").hide();
        //       }else{
        //         $("#minimum_user").hide();

        //       }
        //   });
        // });
    </script>
@endsection
