@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Leauges Details</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.create_challenge') }}">All Leauges
                            Challenges</a></li>
                    <li class="breadcrumb-item">League Price Card</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add League Price Card</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive mb-3 pb-3">
                            <table class="table table-hover table-responsive-sm league_box float-left">
                                <!-- <thead>
                                    <tr>
                                        <th></th>
                                        <th>Detail</th>
                                    </tr>
                                </thead> -->
                                <tbody>
                                    @foreach ($findchallenge as $fmatch)
                                        <tr>
                                            <td>Wining amount</td>
                                            <td><!-- <span class="badge badge-primary"> --><i
                                                    class="fa fa-inr"></i>{{ ucwords($fmatch->win_amount) }}<!-- </span> -->
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Entry fees</td>
                                            <td><i class="fa fa-inr"></i>{{ ucwords($fmatch->entryfee) }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Maximum users</td>
                                            <td>{{ ucwords($fmatch->maximum_user) }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Multiple Entry</td>
                                            <td>
                                                @if ($fmatch->multi_entry == 1)
                                                    <?php echo '<i class="fa fa-check-circle-o fa-2x" style="color:green">'; ?>
                                                @else
                                                    <?php echo '<i class="fa fa-times-circle-o fa-2x" style="color:red">'; ?>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Is running</td>
                                            <td>
                                                @if ($fmatch->confirmed_challenge == 1)
                                                    <?php echo '<i class="fa fa-check-circle-o fa-2x" style="color:green">'; ?>
                                                @else
                                                    <?php echo '<i class="fa fa-times-circle-o fa-2x" style="color:red">'; ?>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Confirm Challenge</td>
                                            <td>
                                                @if ($fmatch->is_running == 1)
                                                    <?php echo '<i class="fa fa-check-circle-o fa-2x" style="color:green">'; ?>
                                                @else
                                                    <?php echo '<i class="fa fa-times-circle-o fa-2x" style="color:red">'; ?>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="row league_box w-65 float-right p-0">
                                <div class="col-xl-12 col-xxl-12 px-0">
                                    <div class="aos-init aos-animate" data-aos="fade-up">
                                        <div class="card-header">
                                            <h4 class="card-title">Add New Price Card</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="basic-form">
                                                <form action="{{ route($modelName . '.add_match_pricecard', $addcardid) }}"
                                                    method="POST" id="price_cardAddForm" enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                            <label class="lbl_frm py-2">Start Position</label>
                                                            <input type="number" min="0" id="min_position"
                                                                name="min_position" class="form-control in_text"
                                                                value="{{ $min_position }}">
                                                            <div class="error-message help-inline">
                                                                <?php echo $errors->first('min_position'); ?>
                                                            </div>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label class="lbl_frm">Number of winners</label>
                                                            <input type="number" min="1" id="winners"
                                                                name="winners" class="form-control in_text"
                                                                value="{{ old('winners') }}"
                                                                placeholder="Enter number of winnners here">
                                                            <div class="error-message help-inline">
                                                                <?php echo $errors->first('winners'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                            <label class="lbl_frm py-2">Price Amount</label>
                                                            <input type="text" min="0" id="price"
                                                                name="price" class="form-control in_text"
                                                                value="{{ old('price') }}"
                                                                placeholder="Enter wining amount">
                                                            <div class="error-message help-inline">
                                                                <?php echo $errors->first('price'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <!-- <div class="form-group col-md-4">

                                                            <div class="form-check mb-2">
                                                                <input type="checkbox" class="form-check-input"
                                                                    onchange="showHideGadgetFields(event)" id="is_gadget"
                                                                    name="is_gadget" value="1">
                                                                <label class="form-check-label" for="is_gadget">Is Gadgets
                                                                    ?</label>
                                                            </div>
                                                        </div> -->
                                                        <div class="form-group col-md-8" style="display:none"
                                                            id="toggleGadgetFields">
                                                            <label class="lbl_frm">Gadgets Image </label>
                                                            <input class="form-control in_text" name="gadget_image"
                                                                id="gadget_image" type="file">

                                                        </div>
                                                    </div>
                                                    <div class="py-2">
                                                        <button type="submit" class="btn btn-primary mr-2">Add Price
                                                            Card</button>
                                                        <button class="btn btn-gray" type="button"
                                                            id="cancel_btn">Cancel</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-bordered table-responsive-sm">
                            <thead>
                                <tr>
                                    <th>S No.</th>
                                    <th>Min Position</th>
                                    <th>Max Position</th>
                                    <th>wining users</th>
                                    <th>Each winner amount</th>
                                    <th>Total amount</th>
                                    <th>Gadgets Image</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if (!empty($findallpricecards))
                                    <?php
                                    $snoo = 1;
                                    $countpricecards = count($findallpricecards);
                                    ?>
                                    @foreach ($findallpricecards as $pricecars)
                                        <tr>
                                            <th>{{ $snoo }}</th>
                                            <td>{{ $pricecars->min_position }}</td>
                                            <td>{{ $pricecars->max_position }}</td>
                                            <td>{{ $pricecars->winners }}</td>
                                            <td>{{ $pricecars->price }}</td>
                                            <td>{{ $pricecars->total }}</td>
                                            <?php if(!empty($pricecars->gadget_image)){?>
                                            <td>
                                                <img src="<?php echo url()->asset('uploads/banners/' . $pricecars->gadget_image); ?>"
                                                    style="width:50px;height:50px; border-radius:2px;">
                                                <?php } else { ?>
                                                <!-- <td><img src="<?php //echo url()->asset("uploads/players/logo.jpg");
                                                ?>" style="width:50px; height:50px; border-radius:2px;"></td> -->
                                            <td></td>
                                            <?php } ?>
                                            @if ($snoo == $countpricecards)
                                                <td>
                                                    <a class="delbtn btn btn-danger" data-id="{{ $pricecars->id }}"
                                                        href="{{ route($modelName . '.delete_price_card', base64_encode(serialize($pricecars->id))) }}"
                                                        onclick="return confirm('Do you really want to delete?');"> Delete
                                                    </a>
                                                </td>
                                            @endif
                                        </tr>
                                        <?php $snoo++; ?>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /# card -->
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
    ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });

        function showHideGadgetFields(event) {
            if (event.target.checked) {
                $("#toggleGadgetFields").show();
            } else {
                $("#toggleGadgetFields").hide();
            }
        }
    </script>

@endsection
