@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Challenges Categories</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Players</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
                    <div class="card" data-aos="fade-up">
                        <div class="card-header">
                        <h4>All Challenges Categories</h4>
                          <a href="{{route($modelName.'.category_add')}}" class="btn btn-primary btn-sm"> Add New Category</a>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataList" class="display" style="min-width: 845px">
                                    <thead>
                                        <tr>
                                        <th>S No.</th>
                                        <th>Title</th>
                                        <th>Sub Text</th>
                                        <th>Sort Order</th>
                                        <th>Status</th>
                                        <th>Sport Type</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                        <th>S No.</th>
                                        <th>Title</th>
                                        <th>Sub Text</th>
                                        <th>Sort Order</th>
                                        <th>Status</th>
                                        <th>Sport Type</th>
                                        <th>Action</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.category')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'contest_sub_text', name: 'contest_sub_text'},
            {data: 'sort_order', name: 'sort_order'},
            {data: 'status', name: 'status'},
            {data: 'sport_type', name: 'sport_type'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

    $(document).on('click', '.action-users', function () {
        if(!confirm("Are You Sure update this status?"))
        event.preventDefault();
      });



});
</script>
@endsection
