@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Master Leauge</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view_challenges') }}">View all Master
                            Leauge</a></li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Master Leauge</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form method="POST"
                                action="{{ route($modelName . '.edit_global_challenge', base64_encode(serialize($challenge['challenge']->id))) }}"
                                id="categoryAddForm">
                                @csrf
                                <?php
                                $category = $challenge['challenges_category'];
                                $challenge = $challenge['challenge'];
                                ?>
                                <div class="form-row">
                                    <fieldset class="form-group col-md-6">
                                        <div class="row mx-0">
                                            <label class="lbl_frm">Challenge Type</label>
                                            <div class="col-sm-9 px-0">
                                                <div class="form-check frm_chk">
                                                    <input class="form-check-input" type="radio" name="challenge_type"
                                                        value="money" <?php if ($challenge->challenge_type == 'money') {
                                                            echo 'checked';
                                                        } ?>>
                                                    <label class="form-check-label">
                                                        Fixed Challenge
                                                    </label>
                                                </div>
                                                <!-- <div class="form-check frm_chk">
                                              <input class="form-check-input" type="radio" name="challenge_type" value="percentage" <?php if ($challenge->challenge_type == 'percentage') {
                                                  echo 'checked';
                                              } ?>>
                                              <label class="form-check-label">
                                                  Percentage based
                                              </label>
                                          </div> -->
                                            </div>
                                        </div>
                                    </fieldset>


                                </div>
                                <div class="form-row my-3">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Entry Fee</label>
                                        <input type="number" min="0" id="entryfee" name="entryfee"
                                            class="form-control in_text"
                                            value="{{ $challenge->real_entry_fees > 0 ? $challenge->real_entry_fees : $challenge->entryfee }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('entryfee'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Wining Amount</label>
                                        <input class="form-control in_text" name="win_amount" id="win_amount" type="number"
                                            min="0" value="{{ $challenge->win_amount }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('win_amount'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6" id="max_user">
                                        <label class="lbl_frm py-2">Maximum number of users</label>
                                        <input type="number" min="0" id="maximum_user" name="maximum_user"
                                            class="form-control in_text" value="{{ $challenge->maximum_user }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('maximum_user'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm">Minimum number of users to confirm Challenge</label>
                                        <input class="form-control in_text" name="minimum_user" id="minimum_user"
                                            type="number" min="0" value="{{ $challenge->minimum_user }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('minimum_user'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6" id="winn_percent">
                                        <label class="lbl_frm py-2">Winning Percentage</label>
                                        <input type="number" min="0" id="winning_percentage"
                                            name="winning_percentage" class="form-control in_text"
                                            value="{{ $challenge->winning_percentage }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('winning_percentage'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Sport Type</label>
                                        <select class="form-control in_text sport_types" onchange="getChallangesCategory()"
                                            name="sport_type">
                                            <option value="">Select Sport</option>
                                            @foreach ($sport_types as $key => $value)
                                                <option value="{{ $value->id }}" <?php if ($challenge->sport_type == $value->id) {
                                                    echo 'selected';
                                                } ?>>
                                                    {{ $value->sport_name }}</option>
                                            @endforeach
                                        </select>
                                        <div class="error-message help-inline">
                                            {{ $errors->first('sport_type') }}
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Challenge Category</label>
                                        <select class="form-control in_text challanges_category"
                                            name="challenge_category_id" id="challenge_category_id">
                                            <option value="">Select Category</option>
                                            @if (isset($category) && !empty($category))
                                                @foreach ($category as $key => $value)
                                                    <option value="{{ $value->id }}" <?php if ($challenge->challenge_category_id == $value->id) {
                                                        echo 'selected';
                                                    } ?>>
                                                        {{ $value->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>


                                </div>

                                <div class="form-row my-3">
                                    <!-- <div class="form-group col-md-4">
                                  <div class="form-check mb-2">
                                      <input type="checkbox" class="form-check-input" id="is_discount" name="is_discount" value="1" <?php if ($challenge->is_discount == 1) {
                                          echo 'checked';
                                      } ?> onclick="show12();">
                                      <label class="form-check-label">Can Use Discount</label>
                                  </div>
                                </div> -->
                                    <div class="form-group col-md-4" id="discount_price_id"
                                        @if ($challenge->discount_price == '') style="display: none;" @else
                                  style="display: block;" @endif>
                                        <label class="lbl_frm py-2">Discount After Amount</label>
                                        <input type="number" min="0" id="discount_price" name="discount_price"
                                            class="form-control in_text" value="{{ $challenge->discount_price }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('max_team_limit'); ?>
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-4">
                                <div class="form-check mb-2">
                                    <input type="checkbox" class="form-check-input" id="is_free" name="is_free" value="1" <?php if ($challenge->is_free == 1) {
                                        echo 'checked';
                                    } ?>>
                                    <label class="form-check-label">Is Free</label>
                                </div>
                              </div> -->

                                    <!-- <div class="form-group col-md-4">
                                <div class="form-check mb-2">
                                    <input type="checkbox" class="form-check-input" id="multi_entry" name="multi_entry" value="1" <?php if ($challenge->multi_entry == 1) {
                                        echo 'checked';
                                    } ?>>
                                    <label class="form-check-label">Multi Entry</label>
                                </div>
                              </div>

                              <div class="form-group col-md-4" id="max_team_limit_id">
                                      <label class="lbl_frm py-2">Max Team Limit</label>
                                        <input type="number" min="0" id="max_team_limit" name="max_team_limit" class="form-control in_text" value="{{ $challenge->max_team_limit }}">
                                         <div class="error-message help-inline">
                                          <?php echo $errors->first('max_team_limit'); ?>
                                        </div>
                                    </div> -->


                                    @if ($challenge->multi_entry == 1)
                                        <div class="form-group col-md-4 py-2">

                                            <div class="form-check mb-2">
                                                <input type="checkbox" class="form-check-input" id="multi_entry"
                                                    name="multi_entry" value="1" <?php if ($challenge->multi_entry == 1) {
                                                        echo 'checked';
                                                    } ?>
                                                    onclick="show4();">
                                                <label class="form-check-label">Multi Entry</label>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-4" id="max_team_limit_id">
                                            <label class="lbl_frm py-2">Max Team Limit</label>
                                            <input type="number" min="0" id="max_team_limit"
                                                name="max_team_limit" class="form-control in_text"
                                                value="<?php echo $challenge->max_team_limit; ?>">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('max_team_limit'); ?>
                                            </div>
                                        </div>

                                        <!-- <div class="form-group col-md-4 py-2" id="freeTeamOffer" >
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="freeTeamOfferCheck" name="is_offer_team" <?php //if($challenge->multi_entry==1){ echo 'checked'; }
                                            ?> value="1" onclick="FreeTeamOfferInput();" >
                                            <label class="form-check-label">Is Offer Team</label>
                                        </div>
                                     </div> -->

                                        <!-- <div class="form-group col-md-4 py-2" id="freeTeamOfferinp">
                                         <label>Free Team Number</label>
                                         <input type="number" id="freeTeamOfferinp" name="offer_team_no" class="form-control"  value="{{ $challenge->offer_team_no }}">
                                          <div class="error-message help-inline">
                                           <?php //echo// $errors->first('offer_team_no');
                                           ?>
                                         </div>
                                     </div> -->
                                        <div class="form-group col-md-12" id="offersclick" style="display: none;">
                                            <div class="form-group col-md-4">
                                                <!-- <label>Multi Entry</label> -->
                                                <div class="form-check mb-2">
                                                    <input type="checkbox" class="form-check-input"
                                                        onchange="showHideOfferFields(event)" id="offer_checkbox"
                                                        name="is_offer_team" value="1">
                                                    <label class="form-check-label" for="offer_checkbox">Is Offer
                                                        Team</label>
                                                </div>
                                            </div>

                                            <div class="form-row" style="display:none" id="toggleOfferFields">
                                                <div class="form-group col-md-4">
                                                    <label class="lbl_frm py-2">Contest Free Team </label>
                                                    <input type="number" class="form-control in_text"
                                                        id="contest_free_team" min="0" name="contest_free_team"
                                                        value="0">

                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label class="lbl_frm py-2">Contest Bonus team </label>
                                                    <input type="number" class="form-control in_text"
                                                        id="contest_bonus_team" min="0" name="contest_bonus_team"
                                                        value="0">

                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label class="lbl_frm py-2">Bonus Team Percentage </label>
                                                    <input type="number" class="form-control in_text"
                                                        id="offer_bonus_percent" min="0" max="100"
                                                        name="offer_bonus_percent" value="0">


                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <div class="form-group col-md-4 py-2">

                                            <div class="form-check mb-2">
                                                <input type="checkbox" class="form-check-input" id="multi_entry"
                                                    name="multi_entry" value="1" <?php if ($challenge->multi_entry == 1) {
                                                        echo 'checked';
                                                    } ?>>
                                                <label class="form-check-label">Multi Entry</label>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-4" id="max_team_limit_id" style="display: none;">
                                            <label class="lbl_frm py-2">Max Team Limit</label>
                                            <input type="number" min="0" id="max_team_limit"
                                                name="max_team_limit" class="form-control in_text"
                                                value="{{ old('max_team_limit') }}">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('max_team_limit'); ?>
                                            </div>
                                        </div>

                                        <!-- firoz code -->
                                        <div class="form-group col-md-4 py-2" id="freeTeamOffer" style="display: none;">
                                            <div class="form-check mb-2">
                                                <input type="checkbox" class="form-check-input" id="freeTeamOfferCheck1"
                                                    name="is_offer_team" value="1" <?php if ($challenge->is_offer_team == 1) {
                                                        echo 'checked';
                                                    } ?>
                                                    onchange="FreeTeamOfferInput1();">
                                                <label class="form-check-label">Is Offer Team</label>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-4 py-2" id="freeTeamOfferinp1"
                                            style="display: none;">
                                            <label>Free Team Number</label>
                                            <input type="number" id="freeTeamOfferinp1" name="offer_team_no"
                                                class="form-control" value="">
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('offer_team_no'); ?>
                                            </div>
                                        </div>
                                    @endif


                                    <!-- firoz code -->








                                    <div class="form-group col-md-4">
                                        <!-- <label>Confirmed Challenge</label> -->
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="confirmed_challenge"
                                                name="confirmed_challenge" value="1" <?php if ($challenge->confirmed_challenge == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Confirmed Challenge</label>
                                        </div>
                                    </div>


                                    <div class="form-group col-md-4">
                                        <!-- <label>Can Use Bonus</label> -->
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="bonus"
                                                name="bonus" value="1" <?php if ($challenge->bonus == 1) {
                                                    echo 'checked';
                                                } ?> onclick="show3();">
                                            <label class="form-check-label">Can Use Bonus</label>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-4" id="bonus_precents">
                                        <label class="lbl_frm py-2">Bonus percent</label>
                                        <input type="number" min="0" id="bonus_precent" name="bonus_precent"
                                            class="form-control in_text" value="{{ $challenge->bonus_precent }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('bonus_precent'); ?>
                                        </div>
                                    </div>


                                    <!-- <div class="form-group col-md-4">

                                  <div class="form-check mb-2 py-2">
                                      <input type="checkbox" class="form-check-input" id="is_running" name="is_running" value="1" <?php if ($challenge->is_running == 1) {
                                          echo 'checked';
                                      } ?>>
                                      <label class="form-check-label">Is Running?</label>
                                  </div>
                                </div> -->

                                    <div class="form-group col-md-4">
                                        <!-- <label>Is Running</label> -->
                                        <!-- <div class="form-check mb-2 py-2">
                                            <input type="checkbox" class="form-check-input" id="is_flexible"
                                                name="is_flexible" value="1" <?php if ($challenge->is_flexible == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Flexible?</label>
                                        </div> -->
                                    </div>
                                    <div class="form-group col-md-4">
                                        <!-- <label>Loop stop</label> -->
                                        <div class="form-check mb-2 py-2">
                                            <input type="checkbox" class="form-check-input" id="loops"
                                                name="loops" value="1" <?php if ($challenge->loops == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Loop Stop</label>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <!-- <div class="form-check mb-2 py-2">
                                            <input type="checkbox" class="form-check-input" id="is_free_for_referrer"
                                                name="is_free_for_referrer" value="1" <?php if ($challenge->is_free_for_referrer == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Free For Referrer</label>
                                        </div> -->
                                    </div>
                                    <div class="form-group col-md-6">
                                        <!-- <label>Join Similar Contest</label> -->
                                        <!-- <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_join_similar_contest"
                                                name="is_join_similar_contest" value="1" onclick="show33();"
                                                <?php if ($challenge->is_join_similar_contest == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Join Similar Contest</label>
                                        </div> -->
                                    </div>
                                    <!-- <div class="form-group col-md-4" id="join_contest_limit" style="display: none;">
                                  <label class="lbl_frm py-2">Join Similar Contest limit</label>
                                    <input type="number" min="0" id="join_C_limit" name="join_similar_contest_limit" class="form-control in_text" value="{{ $challenge->join_similar_contest_limit }}">
                                     <div class="error-message help-inline">
                                      <?php //echo $errors->first('join_similar_contest_limit');
                                      ?>
                                    </div>
                                </div> -->
                                    <!-- <div class="form-group col-md-4">
                            <div class="form-check mb-2">
                              <input type="checkbox" class="form-check-input" onchange="showHideGadgetFields(event)" id="is_gadgets" name="is_gadgets" value="1" <?php if ($challenge->is_gadgets == 1) {
                                  echo 'checked';
                              } ?> >
                              <label class="form-check-label" for="is_gadgets">Is Gadgets ?</label>
                            </div>
                          </div> -->

                                    <div class="form-group col-md-4" <?php if ($challenge->is_gadgets != 1) {
                                        echo 'style="display:none"';
                                    } ?> id="toggleGadgetFields">

                                        <label class="lbl_frm py-2">Gadgets Image </label>
                                        <input class="form-control in_text" name="gadgets_image" id="gadgets_image"
                                            type="file">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('gadgets_image'); ?>
                                        </div>
                                        @if ($challenge->gadgets_image != '')
                                            <img src="<?php echo url()->asset('uploads/players/' . $challenge->gadgets_image); ?>" class="py-2"
                                                style="width:100px;height:100px;">
                                        @endif


                                    </div>

                                    <div class="form-group col-md-4 py-2 ">
                                        <!-- <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_promotor"
                                                name="is_promotor" value="1"
                                                onchange="showHidepromototFields(event)" <?php if ($challenge->is_promotor == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Promoter?</label>
                                        </div> -->

                                    </div>

                                    <div class="form-row my-3" <?php if ($challenge->is_promotor != 1) {
                                        echo 'style="display:none"';
                                    } ?> id="togglePromotorFields">

                                        @foreach ($user_promotor as $users)
                                            <div class="form-group col-md-4 py-2">
                                                @if (in_array($users->id, $is_setuserid))
                                                    <div class="form-check mb-2">
                                                        <input type="checkbox" class="form-check-input"
                                                            name="promotor_id[]" value="{{ $users->id }}" checked>
                                                        <label class="form-check-label">{{ $users->refercode }} \
                                                            ({{ $users->team }})\ ({{ $users->mobile }})</label>
                                                    </div>
                                                @else
                                                    <div class="form-check mb-2">
                                                        <input type="checkbox" class="form-check-input"
                                                            name="promotor_id[]" value="{{ $users->id }}">
                                                        <label class="form-check-label">{{ $users->refercode }} \
                                                            ({{ $users->team }})\ ({{ $users->mobile }})</label>
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>

                                    <!-- <div class="form-group col-md-4">

                                  <div class="form-check mb-2 py-2">
                                      <input type="checkbox" class="form-check-input" id="is_manual_bot" name="is_manual_bot" value="1" <?php if ($challenge->is_manual_bot == 1) {
                                          echo 'checked';
                                      } ?>>
                                      <label class="form-check-label">Enable Bots</label>
                                  </div>
                                </div> -->


                                </div>
                        </div>
                        <div class="py-2">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <!--**********************************
        Content body end
    ***********************************-->
    <script type="text/javascript">
        function show3() {
            if (document.getElementById("bonus").checked == true) {
                document.getElementById('bonus_precents').style.display = 'block';
            } else {
                document.getElementById('bonus_precents').style.display = 'none';
            }
        }


        function show4() {
            if (document.getElementById("multi_entry").checked == true) {
                document.getElementById('offersclick').style.display = 'block';
            } else {
                document.getElementById('offersclick').style.display = 'none';
            }
        }

        function show12() {
            if (document.getElementById("is_discount").checked == true) {
                document.getElementById('discount_price_id').style.display = 'block';
            } else {
                document.getElementById('discount_price_id').style.display = 'none';
            }
        }

        function showHideOfferFields(event) {
            if (event.target.checked) {
                $("#toggleOfferFields").show();
            } else {
                $("#toggleOfferFields").hide();
            }
        }
        // function show4(){
        //
        //
        //   if ( document.getElementById("multi_entry").checked==true ) {
        //     document.getElementById('offersclick').style.display ='block';
        //   document.getElementById('freeTeamOffer').style.display ='block';
        //     document.getElementById('freeTeamOfferinp').style.display ='block';
        // }
        //   else {
        //     document.getElementById('max_team_limit_id').style.display ='none';
        //   document.getElementById('freeTeamOffer').style.display ='none';
        //   document.getElementById('freeTeamOfferinp').style.display ='none';
        //   }
        // }
        function FreeTeamOfferInput() {

            if (document.getElementById("freeTeamOfferCheck").checked == true) {
                document.getElementById('freeTeamOfferinp').style.display = 'block';
            } else {
                document.getElementById('freeTeamOfferinp').style.display = 'none';
            }
        }

        function FreeTeamOfferInput1() {

            if (document.getElementById("freeTeamOfferCheck1").checked == true) {
                document.getElementById('freeTeamOfferinp1').style.display = 'block';
            } else {
                document.getElementById('freeTeamOfferinp1').style.display = 'none';
            }
        }

        $(document).ready(function() {
            let canUseBonus = <?php echo $challenge->bonus; ?>;
            var chall = $('input[name=challenge_type]:checked').val();
            if (chall == 'money') {
                $("#winn_percent").hide();
            } else {
                $("#max_user").hide();
            }
            $("input[name$='challenge_type']").click(function() {
                var test = $(this).val();
                if (test == 'percentage') {
                    $("#winn_percent").show();
                    $("#max_user").hide();
                } else {
                    $("#winn_percent").hide();
                    $("#max_user").show();
                }
            });
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });

            if (canUseBonus == 1)
                $("#bonus_precents").show();
            else
                $("#bonus_precents").hide();

        });

        function getChallangesCategory() {

            var sport_type = $(".sport_types").val();
            $.ajax({
                url: "{{ route($modelName . '.getChallangesBySportType') }}",
                type: "post",
                data: {
                    "sport_type": sport_type
                },
                success: function(res) {
                    var optionval = [];
                    if (res != '') {
                        var output = '<option value="">Select Category</option>';
                        $.each(res, function(key, value) {
                            output += '<option value="' + value.id + '">' + value.name + '</option>';
                            optionval.push(value.id);

                        });
                        $('.challanges_category').html(output);
                    } else {
                        var output = '<option value="">Select Category</option>';
                        $('.challanges_category').html(output);
                    }
                    var challangecate = {{ $challenge->challenge_category_id }};
                    jqueryinarray = optionval.indexOf(challangecate);
                    if (jqueryinarray > -1) {
                        $('.challanges_category').val(challangecate);
                    } else {
                        $('.challanges_category').val('');
                    }

                },
                error: function(err) {
                    console.log(err);
                }
            });
        }
        //  setTimeout(function(){
        getChallangesCategory();

        function showHideGadgetFields(event) {
            if (event.target.checked) {
                $("#toggleGadgetFields").show();
            } else {
                $("#toggleGadgetFields").hide();
            }
        }

        function showHidepromototFields(event) {
            if (event.target.checked) {
                $("#togglePromotorFields").show();
            } else {
                $("#togglePromotorFields").hide();
            }
        }

        //},800);

        function show33() {
            if (document.getElementById("is_join_similar_contest").checked == true) {
                document.getElementById('join_contest_limit').style.display = 'block';
            } else {
                document.getElementById('join_contest_limit').style.display = 'none';
            }
        }
    </script>


@endsection
