@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Master Leauges</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Leauges</a></li>
            </ol> -->
            @if(Session()->has('message'))
<p class="alert alert-danger">{{ Session()->get('message') }}</p>
@endif
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4>All Master Leauges</h4>
                  <a href="{{route($modelName.'.global_challenge')}}" class="btn btn-primary btn-sm"> Add New Master League</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Wining amount</th>
                                <th>Entry fees</th>
                                <th>Sport Type</th>
                                <th>Challenge Type</th>
                                <th>Maximum users</th>
                                <!-- <th>Winning Percentage</th> -->
                                <th>Multiple Entry</th>
                                <th>Can Use Bonus</th>
                                <!-- <th>Is running</th> -->
                                <th>Confirm Leauge</th>
                                <th>Category</th>
                                <th>Action</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Wining amount</th>
                                <th>Entry fees</th>
                                <th>Sport Type</th>
                                <th>Challenge Type</th>
                                <th>Maximum users</th>
                                <!-- <th>Winning Percentage</th> -->
                                <th>Multiple Entry</th>
                                <th>Can Use Bonus</th>
                                <!-- <th>Is running</th> -->
                                <th>Confirm Leauge</th>
                                <th>Category</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.view_challenges')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'win_amount', name: 'win_amount'},
            {data: 'entryfee', name: 'entryfee'},
            {data: 'sport_type', name: 'sport_type'},
            {data: 'challenge_type', name: 'challenge_type'},
            {data: 'maximum_user', name: 'maximum_user'},
            // {data: 'winning_percentage', name: 'winning_percentage'},
            {data: 'multi_entry', name: 'multi_entry'},
            {data: 'bonus', name: 'bonus'},
            // {data: 'is_running', name: 'is_running'},
            {data: 'confirmed_challenge', name: 'confirmed_challenge'},
            {data: 'name', name: 'name'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
</script>
<script type="text/javascript">
     $(document).on('click', '.deleteChallanges', function () {
          if(!confirm("Are You Sure to delete this?"))
          event.preventDefault();
    });
</script>

@endsection
