@extends('admin.layouts.default')
@section('content')
    <!--**********************************
    Content body start
    ***********************************-->
    <!-- row -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12 col-xxl-12 pl-4 mx-2 pr-5">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="widget-quantity" data-aos="fade-up" data-aos-once="true">
                            <div class="card">
                                <div class="card-body">
                                    <div class="basic-form">
                                        <form action="{{ route($modelName . '.viewDepositWithdraw') }}" method="GET">
                                            @csrf
                                            @php
                                                $matchkey = '';
                                                $start_date = '';
                                                $end_date = '';
                                                if (isset($_GET['start_date'])) {
                                                    $start_date = $_GET['start_date'];
                                                }
                                                if (isset($_GET['end_date'])) {
                                                    $end_date = $_GET['end_date'];
                                                }
                                            @endphp
                                            <div class="form-row">
                                                <div class="form-group col-md-3 mb-0">
                                                    <label>Start Date</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="text" required="" name="start_date"
                                                            id="start_date"
                                                            class="pull-left form-control datetimepickerget w-95"
                                                            value="{{ isset($start_date) && !empty($start_date) ? $start_date : '' }}"
                                                            autocomplete="off">
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-3 mb-0">
                                                    <label>End Date</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="text" required="" name="end_date" id="end_date"
                                                            class="pull-left form-control datetimepickerget w-95"
                                                            value="{{ isset($end_date) && !empty($end_date) ? $end_date : '' }}"
                                                            autocomplete="off">
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-3 mb-0">
                                                    <label>&ensp;</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="submit" class="btn btn-primary">
                                                    </div>
                                                </div>

                                            </div>

                                        </form>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="widget-content">
                                            <h4>Deposit / Withdraw Cash</h4>
                                        </div>
                                        <h4>
                                            Total Deposit Cash : ₹ <span class="counter">{{ $user_add_total_amount }}</span>
                                        </h4>
                                        <h4>Total Withdraw Cash : ₹ <span
                                                class="counter">{{ $user_withdraw_total_amount }}</span></h4>

                                    </div>
                                    <div class="chart mt-3">
                                        <canvas id="total_amount_add"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--****************** Content body end *************************-->
    <!-------------Show Total Amount Add Month Wise------------>
    @php
        $days = [];
        $amount = [];
        $withdraw_amount = [];
        $add_cash_color = [];
        $withdraw_cash_color = [];

    @endphp
    @if (isset($user_add_amount) && !empty($user_add_amount))
        @foreach ($user_add_amount as $amount_val)
            @php
                $days[] = date_format(date_create($amount_val->date), 'd M Y');
                $amount[] = floatval($amount_val->user_add_amount);
                $add_cash_color[] = '#25d5f2';
            @endphp
        @endforeach
    @else
        $days=array();
        $amount=array();
    @endif

    @if (isset($user_withdraw_amount) && !empty($user_withdraw_amount))
        @foreach ($user_withdraw_amount as $withdraw_amount_val)
            @php
                $withdraw_amount[] = floatval($withdraw_amount_val->user_withdraw_amount);
                $withdraw_cash_color[] = '#ff407b';
            @endphp
        @endforeach
    @else
        $withdraw_amount=array();
    @endif


    <script src="//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>

    <script type="text/javascript">
        //datepicket without time
        $(document).ready(function() {
            $('#end_date,#start_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
        });

        var ctx = document.getElementById("total_amount_add").getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($days); ?>,
                datasets: [{
                        label: "Deposit Cash",
                        backgroundColor: <?php echo json_encode($add_cash_color); ?>,
                        data: <?php echo json_encode($amount); ?>,
                    },
                    {
                        label: "Withdraw Cash",
                        backgroundColor: <?php echo json_encode($withdraw_cash_color); ?>,
                        data: <?php echo json_encode($withdraw_amount); ?>,
                    }
                ]
            },
        });
    </script>


    <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

@endsection
